<div align="center">
  <img src="https://user-images.githubusercontent.com/6267663/221538828-de1343f2-b249-4ba2-85e3-a2e43cc5f265.svg">
  <h1>Python SDK</h1>
  <p>Hightouch exposes a REST API that lets users interact with resources like syncs, models, sources and destinations.</p>
  <a href="https://hightouch.com/docs/api-reference"><img src="https://img.shields.io/static/v1?label=Docs&message=API Ref&color=000000&style=for-the-badge" /></a>
  <a href="https://github.com/speakeasy-sdks/hightouch-python-sdk/actions"><img src="https://img.shields.io/github/actions/workflow/status/speakeasy-sdks/hightouch-python-sdk/speakeasy_sdk_generation.yml?style=for-the-badge" /></a>
  <a href="https://opensource.org/licenses/MIT"><img src="https://img.shields.io/badge/License-MIT-blue.svg?style=for-the-badge" /></a>
  <a href="https://github.com/speakeasy-sdks/hightouch-python-sdk/releases"><img src="https://img.shields.io/github/v/release/speakeasy-sdks/hightouch-python-sdk?sort=semver&style=for-the-badge" /></a>
</div>

<!-- Start SDK Installation -->
## SDK Installation

```bash
pip install hightouch
```
<!-- End SDK Installation -->

## Authentication

- Create an [API key](https://app.hightouch.com/settings/api-keys)
- From the API keys tab on the Settings page, select Add API key.
- Enter a descriptive Name for your key.
- Copy your API key and store it in a safe location. The key will only be displayed once.
- Click Create API key.

## SDK Example Usage
<!-- Start SDK Example Usage -->
```python
import hightouch
from hightouch.models import operations, shared

s = hightouch.Hightouch()


req = shared.DestinationCreate(
    configuration={
        "deserunt": "porro",
        "nulla": "id",
        "vero": "perspiciatis",
    },
    name="nulla",
    slug="nihil",
    type="fuga",
)
    
res = s.create_destination(req, operations.CreateDestinationSecurity(
    bearer_auth="Bearer YOUR_BEARER_TOKEN_HERE",
))

if res.create_destination_200_application_json_any_of is not None:
    # handle response
```
<!-- End SDK Example Usage -->

<!-- Start SDK Available Operations -->
## SDK Available Operations

### Hightouch SDK

* `create_destination` - Create Destination
* `create_model` - Create Model
* `create_source` - Create Source
* `create_sync` - Create Sync
* `get_destination` - Get Destination
* `get_model` - Get Model
* `get_source` - Get Source
* `get_sync` - Get Sync
* `list_destination` - List Destinations
* `list_model` - List Models
* `list_source` - List Sources
* `list_sync` - List Syncs
* `list_sync_runs` - List Sync Runs
* `trigger_run` - Trigger Sync
* `trigger_run_custom` - Trigger Sync From ID or Slug
* `update_destination` - Update Destination
* `update_model` - Update Model
* `update_source` - Update Source
* `update_sync` - Update Sync
<!-- End SDK Available Operations -->

### SDK Generated by [Speakeasy](https://speakeasyapi.dev/)
