# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['pymagnet',
 'pymagnet.forces',
 'pymagnet.magnets',
 'pymagnet.plots',
 'pymagnet.utils']

package_data = \
{'': ['*']}

install_requires = \
['matplotlib>=3.5.0,<4.0.0',
 'numba>=0.55.1,<0.56.0',
 'numpy-stl>=2.16.3,<3.0.0',
 'numpy>=1.21,<2.0',
 'plotly>=5.4.0,<6.0.0']

setup_kwargs = {
    'name': 'pymagnet',
    'version': '0.4.1',
    'description': 'User Friendly Magnetic Field Calculations',
    'long_description': '# Pymagnet\n\nUser friendly magnetic field calculations in Python\n\n[![License: MPL 2.0](https://img.shields.io/badge/License-MPL%202.0-blue.svg)](https://opensource.org/licenses/MPL-2.0)\n[![License: CC BY-SA 4.0](https://img.shields.io/badge/License-CC%20BY--SA%204.0-lightgrey.svg)](https://creativecommons.org/licenses/by-sa/4.0/)\n[![DOI](https://zenodo.org/badge/339667292.svg)](https://zenodo.org/badge/latestdoi/339667292)\n<!-- [![Anaconda-Server Badge](https://anaconda.org/pdunne/pymagnet/badges/version.svg)](https://anaconda.org/pdunne/pymagnet) -->\n\n<!-- [![Python versions](https://img.shields.io/pypi/pymagnet/genbadge.svg)](https://pypi.python.org/pypi/pymagnet/) -->\n\n<!-- [![Build Status](https://github.com/smarie/python-genbadge/actions/workflows/base.yml/badge.svg)](https://github.com/smarie/python-genbadge/actions/workflows/base.yml) -->\n\n [![Tests Status](https://raw.githubusercontent.com/pdunne/pymagnet/main/reports/tests-badge.svg?dummy=8484744)](https://github.com/pdunne/pymagnet/blob/main/reports/junit/junit.xml)\n [![Coverage Status](https://raw.githubusercontent.com/pdunne/pymagnet/main/reports/coverage-badge.svg?dummy=8484744)](https://github.com/pdunne/pymagnet/blob/main/reports/coverage/coverage.xml)\n [![Flake8 Status](https://raw.githubusercontent.com/pdunne/pymagnet/main/reports/flake8-badge.svg?dummy=8484744)](https://github.com/pdunne/pymagnet/blob/main/reports/flake8/index.html)\n\n## Getting Started\n\nInstalling `pymagnet` can be done using\n\n```bash\npython -m pip install pymagnet \n```\n\nPymagnet is a collection of routines to calculate and plot the magnetic field due to arbitrary 2D\nand 3D objects, like cubes or cylinders, as well as complex non-convex structures stored in STL\nfiles. The library can also calculate the magnetic forces and torques on one magnet due to all other magnets in the system.\n\nThe approach assumes the magnets are uniformly magnetised, and fully transparent to magnetic fields.\nThere are some drawbacks to this compared to Finite Element Methods (FEM), but with the advantage of\nsignificantly faster calculations.\n\nThe current version is written in Python with some speed up using [Numpy](https://numpy.org/) and\n[Numba](https://numba.pydata.org/), but the backend is being ported to\n[Rust](https://github.com/pdunne/magnet_rs) for improved performance.\n\n## Features\n\nThis code uses analytical expressions to calculate the magnetic field due to\nsimple magnets:\n\n* 3D: cubes, prisms (cuboids), cylinders, spheres\n\n![3D Example Slide](https://raw.githubusercontent.com/pdunne/pymagnet/main/docs/img/3d_example_slice_1.png)\n\n![3D Example Volume](https://raw.githubusercontent.com/pdunne/pymagnet/main/docs/img/3d_example_volume_2.png)\n\n* 2D: rectangles, squares, circles\n\n![2D circle contour](https://raw.githubusercontent.com/pdunne/pymagnet/main/docs/img/2d_circle_contour.png)\n\n![2D circle stream](https://raw.githubusercontent.com/pdunne/pymagnet/main/docs/img/2d_circle_stream.png)\n\nand complex compound objects:\n\n* 3D: Polyhedra stored as STL meshes\n* 2D: Polygons constructed from collections of line elements\n\nThere are helper functions to plot the data as line, contour, slice, and volume plots,\nbut the underlying data is also accessible.\n\n## Documentation\n\nFull documentation can be found here: [https://pdunne.github.io/pymagnet/](https://pdunne.github.io/pymagnet/)\n\n### Examples\n\nExamples can be found [in the repository](https://github.com/pdunne/pymagnet/tree/main/examples).\n\n**Or run on Colab:**\n\n#### 2D Examples\n\nGetting Started [![First Steps](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/pdunne/pymagnet/blob/main/examples/notebooks/First%20Steps.ipynb)\n\n1D Simple Plots [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/pdunne/pymagnet/blob/main/examples/notebooks/Fields/1D%20Examples.ipynb)\n\n2D Standard Shapes [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/pdunne/pymagnet/blob/main/examples/notebooks/Fields/2D%20Examples.ipynb)\n\n2D Arbitrary Polygons [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/pdunne/pymagnet/blob/main/examples/notebooks/Fields/2D%20PolyMagnet.ipynb)\n\nMisc. Examples [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/pdunne/pymagnet/blob/main/examples/notebooks/Fields/Misc%20Examples.ipynb)\n\n#### 3D Examples\n\nAnalytical Shapes [![3D Examples](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/pdunne/pymagnet/blob/main/examples/notebooks/Fields/3D%20Examples%20-%20Assemblies.ipynb)\n\nSpheres [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/pdunne/pymagnet/blob/main/examples/notebooks/Fields/3D_Examples%20Spheres.ipynb)\n\n3D STL Meshes [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/pdunne/pymagnet/blob/main/examples/notebooks/STL%20Magnets/STL%20Examples.ipynb)\n\n3D Stanford Bunny [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/pdunne/pymagnet/blob/main/examples/notebooks/STL%20Magnets/Stanford%20Bunny.ipynb)\n\nUpload Your Own Custom Magnet [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/pdunne/pymagnet/blob/main/examples/notebooks/STL%20Magnets/Colab%20Custom%20Magnet.ipynb)\n\n#### Forces and Torques\n\nCubes [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/pdunne/pymagnet/blob/main/examples/notebooks/Forces%20Torques/Cubes.ipynb)\n\nCylinders [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/pdunne/pymagnet/blob/main/examples/notebooks/Forces%20Torques/Cylinders.ipynb)\n\nSpheres [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/pdunne/pymagnet/blob/main/examples/notebooks/Forces%20Torques/Spheres.ipynb)\n\nSTL Cubes [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/pdunne/pymagnet/blob/main/examples/notebooks/STL%20Magnets/STL%20Examples.ipynb)\n\nSTL Pentagonal Prisms [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/pdunne/pymagnet/blob/main/examples/notebooks/STL%20Magnets/STL%20Forces%20Pentagon.ipynb)\n\n### Binder\n\nThe example notebooks can be run as an instance using Binder:\n\n[![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/pdunne/pymagnet/main?filepath=examples%2Fnotebooks)\n\n<!-- ## Prerequisites\n\nEnsure you have [Python](https://www.anaconda.com/) version >= 3.6\n (to use f-strings), and the following packages:\n\n* numpy\n* numpy-stl\n* numba\n* matplotlib\n* plotly -->\n\n## Usage\n\nForms of this library have been used in a number of projects including [Liquid flow and control without solid walls, Nature 2020](https://www.nature.com/articles/s41586-020-2254-4).\n\n## Licensing\n\nSource code licensed under the [Mozilla Public License Version 2.0](https://www.mozilla.org/en-US/MPL/2.0/)\n\nDocumentation is licensed under a Creative Commons Attribution-ShareAlike 4.0 International [(CC BY-SA 4.0)](https://creativecommons.org/licenses/by-sa/4.0/) license.\n\nThis is a human-readable summary of (and not a substitute for) the license, adapted from [CS50x](https://cs50.harvard.edu/x/2021/license/). Official translations of this license are available in other languages.\n\n**You are free to:**\n\n* **Share** — copy and redistribute the material in any medium or format.\n* **Adapt** — remix, transform, and build upon the material.\n\n**Under the following terms:**\n\n* **Attribution** — You must give appropriate credit, provide a link to the license, and indicate if changes were made. You may do so in any reasonable manner, but not in any way that suggests the licensor endorses you or your use.\n* **ShareAlike** — If you remix, transform, or build upon the material, you must distribute your contributions under the same license as the original\n* No additional restrictions — You may not apply legal terms or technological measures that legally restrict others from doing anything the license permits.\n\n### Contribution\n\nUnless you explicitly state otherwise, any contribution intentionally submitted\nfor inclusion in the work by you shall be licensed as above, without any\nadditional terms or conditions.\n',
    'author': 'Peter Dunne',
    'author_email': 'peter.dunne@applied-magnetism.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://www.applied-magnetism.com',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<3.10',
}


setup(**setup_kwargs)
