# Generated by Django 2.2.17 on 2021-05-16 08:22

from django.conf import settings
import django.contrib.auth.models
import django.contrib.auth.validators
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import xlibrary.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0011_update_proxy_permissions'),
    ]

    operations = [
        migrations.CreateModel(
            name='User',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
                ('username', models.CharField(error_messages={'unique': 'A user with that username already exists.'}, help_text='Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.', max_length=150, unique=True, validators=[django.contrib.auth.validators.UnicodeUsernameValidator()], verbose_name='username')),
                ('first_name', models.CharField(blank=True, max_length=30, verbose_name='first name')),
                ('last_name', models.CharField(blank=True, max_length=150, verbose_name='last name')),
                ('email', models.EmailField(blank=True, max_length=254, verbose_name='email address')),
                ('is_staff', models.BooleanField(default=False, help_text='Designates whether the user can log into this admin site.', verbose_name='staff status')),
                ('is_active', models.BooleanField(default=True, help_text='Designates whether this user should be treated as active. Unselect this instead of deleting accounts.', verbose_name='active')),
                ('date_joined', models.DateTimeField(default=django.utils.timezone.now, verbose_name='date joined')),
                ('groups', models.ManyToManyField(blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.', related_name='user_set', related_query_name='user', to='auth.Group', verbose_name='groups')),
                ('user_permissions', models.ManyToManyField(blank=True, help_text='Specific permissions for this user.', related_name='user_set', related_query_name='user', to='auth.Permission', verbose_name='user permissions')),
            ],
            options={
                'verbose_name': 'User',
                'verbose_name_plural': 'Users',
            },
            managers=[
                ('objects', django.contrib.auth.models.UserManager()),
            ],
        ),
        migrations.CreateModel(
            name='GroupOptions',
            fields=[
                ('groups', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, primary_key=True, related_name='option', serialize=False, to='auth.Group')),
                ('privilege', models.CharField(choices=[('ALL', 'Can access all permitted data'), ('GROUP', 'Can access permitted data belonging to group only'), ('SELF', 'Can access permitted data belonging to the logged in user only')], default='ALL', max_length=20)),
            ],
        ),
        migrations.CreateModel(
            name='GuestInvitation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('accepted', models.BooleanField(default=False, verbose_name='accepted')),
                ('key', models.CharField(max_length=64, unique=True, verbose_name='key')),
                ('sent', models.DateTimeField(null=True, verbose_name='sent')),
                ('email', models.EmailField(max_length=254, unique=True, verbose_name='e-mail address')),
                ('created', models.DateTimeField(default=django.utils.timezone.now, verbose_name='created')),
                ('authorentity', xlibrary.fields.ForeignKeyOptional(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to=settings.INVITATIONS_AUTHOR_MODEL)),
                ('inviter', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Guest Invitation',
                'verbose_name_plural': 'Guest Invitations',
            },
        ),
    ]
