import sys
import os
import re

sys.path.append(os.path.abspath(os.getcwd()))

from hebrew_tokenizer import tokenize

text = """
דחיינות היא התנהגות המתאפיינת בדחייה או הימנעות של אדם מביצוע פעולה או מטלה שהוא מעוניין או צריך לבצע. דחיינות מקושרת לרוב לפרפקציוניזם, לדיכאון, להפרעת קשב וריכוז ובעיקר לחרדה חברתית. דחיינות כרונית עלולה להיות תסמין להפרעה פסיכולוגית או פיזיולוגית. מחקרים בנוגע לשורשים הפיזיולוגים של דחיינות נוגעים לרוב בתפקידו של הקורטקס הפרה-פרונטלי. אזור זה במוח אחראי על תפקודים ניהוליים כגון תכנון, שליטה בדחפים וקשב, והוא מתפקד כמסנן על ידי הקטנת גירויים מפריעים באזורי מוח אחרים. פגיעה או נזק באזור זה עלולה לפגוע ביכולת האדם לסנן גירויים מפריעים, דבר הפוגע ביכולת ההתארגנות ובקשב וגורר התגברות הדחיינות. כך הדבר גם לגבי תפקוד האונה הפרה-פרונטלית בהפרעת קשב, שתת-עוררות נפוצה בה. קיים מגוון רב של גורמים פסיכולוגיים לדחיינות, אך ככלל מדובר בסוגיות של חרדה, הערכה עצמית נמוכה, ומנטליות של תבוסתנות. במקרים אלה, הדחיינות מאפשרת לתרץ את הסיבה לכישלון בחוסר השקעה במקום ביכולת נמוכה. מצבים אלו אופייניים כהשלכות משניות של מצבים כמו לקות למידה והפרעת קשב, אשר עלולים להפגיש את האדם עם חוויות שליליות באופן חוזר ונשנה. ההשפעה שלהם גוברת במיוחד במקרים בהם לא מתקבלת הבנה או תמיכה מתאימה מהסביבה. גורם אחר לדחיינות עשוי להיות מרדנות - למשל ישנם ילדים אשר מפתחים התנהגות דחיינית (בנושאים כגון סידור חדרם או הכנת שיעורי בית), אל מול נוקשות ההורים, כחלק ממאבקי כוחות ושליטה, כאשר הדחיינות מקבלת משמעות של התרסה כלפי ההורים. דייוויד אלן מתאר שתי קבוצות גורמים משמעותיים לדחיינות בעבודה ובחיים ככלל, הקשורים לחרדה ולא לעצלות. הקבוצה הראשונה היא דברים הקטנים מכדי לדאוג בגללם, מטלות שהן הפרעה מעצבנת של שטף העניינים ושניתן לעקפן בקלות; דוגמה לכך היא סידור חדר מבולגן. הקבוצה השנייה היא דברים הגדולים מדי לשליטה, מטלות מפחידות או כאלו שהשלכותיהן על החיים עלולות להיות רבות השפעה; דוגמה לכך היא הצורך של בן בוגר להחליט על סידורי המגורים המתאימים להורה קשיש שמצבו הדרדר. מי שדחיינות הפכה עבורו לטבע, עלול להעריך בהערכת יתר או חסר את היקף המטלה. דחיינים נחשבים לבעלי מודעות עצמית גבוהה מהממוצע, המבוססת על שאיפות לשלמות והישגיות יותר מאשר על הערכה מציאותית של מחויבויותיהם וכישוריהם. בהתאם לכך, נהוג לקשר דחיינות עם פרפקציוניזם - נטייה של אנשים להעריך באופן שלילי את ביצועיהם ותוצאות מעשיהם, אנשים החווים פחד עז עד כדי הימנעות מהערכת הכישורים על ידי הזולת, מודעותם העצמית מוגברת והם סובלים מחרדה, מצב רוח רע החוזר ונשנה, ווורקהוליזם. לפי ממצאי סלייני (Slaney) (מ-1966) פרפקציוניסטים סתגלתנים נטו פחות לדחיינות לעומת לא-פרפקציוניסטים. לעומת זאת לפרפקציוניסטים שראו בפרפקציוניזם שלהם בעיה, היו רמות גבוהות של דחיינות (וכן של חרדה). רמה מסוימת של דחיינות היא נורמלית, אך היא הופכת לבעיה כאשר היא מסכלת את התפקוד הנורמלי. דחיינים עלולים לסבול מדחק, רגשי אשמה, גרימת משבר וגרימת אכזבה לזולת בשל אי עמידתם בהתחייבויותיהם. כמו כן, ככל שסטודנטים דוחים את המטלות האקדמאיות שלהם, פחות סביר שיצליחו להגיע למצב זרימה במהלך הלמידה. דחיינות עלולה להיות הפרעה מתמשכת ומתישה ולגרום למוגבלות. היא עשויה לנבוע מבעיה נפשית כגון דיכאון או ADD. לעומת דחיינות שהיא מצב התנהגותי, בהפרעות אלו ניתן לטפל באופן תרופתי או באמצעות שיחות טיפוליות. תרופות עשויות לשפר את טווח הקשב (ב-ADHD) או לשפר את מצב הרוח הכללי (בדיכאון). טיפול בשיחות עשוי להוות כלי למידה למטופל לדרכי התנהגות חדשות, להתגברות על פחדים וחרדות, ולהשגת איכות חיים טובה יותר. דחיינות נחשבת לתופעה נפוצה במיוחד בסביבה אקדמית. הסביבה האקדמית דורשת מחד עמידה בלוחות זמנים של מבחנים והגשת עבודות, ומאידך מציעה שפע אירועים ופעילויות המתחרים על זמנם ותשומת לבם של הסטודנטים. הדחיינות קשורה לבעיות שבהם נתקלים סטודנטים רבים. במחקר שפורסם בשנת 1992, 52% מהסטודנטים שהשתתפו בסקר הצהירו כי הם זקוקים לרמה מתונה עד גבוהה של עזרה בשל דחיינות. המצב גרוע במיוחד בעת כתיבת עבודת גמר, אז קיימים התנאים המושלמים לדחיינות - עבודה מנטלית מופשטת בשילוב לוח זמנים גמיש ויעד עמום. לסטודנטים רבים מוכר המצב בו יעשו כל דבר אפשרי, מלבד לגשת לכתיבת העבודה. סטודנטים חסרי מוטיבציה החשים חוסר שליטה על תהליך הלמידה שלהם נוטים יותר לדחיינות. יש סטודנטים הסובלים מדחיינות בשל אי ניהול נכון של הזמן או חוסר כישורי למידה, מצב של דחק או כריעה תחת העומס. אחרים סובלים מבעיה רפואית (כמו ADD/ADHD) או מליקוי למידה כמו דיסלקסיה. ישנן סיבות לדחיינות המוכרות על ידי מערכת החינוך, כמו ליקויי למידה, אשר מטופלות בתוך המערכת על ידי הוראה מתקנת ומתן התאמות לתלמידים (כמו הארכת זמן בחינה, בחינה בעל פה וכדומה). לדחיין רגוע תפישה שלילית של חובותיו והוא מפנה את האנרגיות שלו למטלות אחרות. דוגמה לכך הם תלמידים דחיינים, שמתעלמים משיעורי הבית אך ממשיכים לנהל חיי חברה מלאים. דחיינות כזו היא סוג של הכחשה. הדחיין נמנע ממצבים שאינם מהנים ומחליפם במעשים מהנים יותר. במונחים פרוידיאנים, אנשים אלו מסרבים לוותר על עקרון העונג ובמקום זאת מקריבים את עקרון המציאות. ייתכן שאינם נראים כמודאגים מהעבודה הממתינה ומלוח הזמנים הדוחק, אך זו בעיקר התחמקות. דחיין מתוח-מפוחד חש לרוב כורע תחת הלחץ, אינו מציאותי בהערכת הזמן, חסר ביטחון בהערכת המטרות וחווה רגשות שליליים רבים נוספים. כשדחיינים אלו חשים כי אין להם יכולת להתמקד או להשלים את מטלותיהם בהצלחה, הם אומרים לעצמם כי הם חייבים לסגת ולהרגע, כי מוטב להרפות לזמן מה, ולהתחיל מחדש למחרת, למשל, בכוחות מחודשים. ה"מנוחה" שלהם זמנית ואינה מועילה, ורק מובילה ללחץ נוסף ככל שהזמן אוזל ורגשי האשמה גוברים בעוד תחושת הכשירות פוחתת. התוכניות והמטלות מועברות ביומן ליום הבא ולשבוע הבא והתנהגות זו הופכת למעגל של כישלון ודחייה, שקשה לפרוץ אותו. זו התנהגות מתישה, בעלת השלכה על החיים ועל מערכות היחסים. כיוון שהם חסרי ביטחון לגבי יכולתם להגשים מטרות, הם חשים פעמים רבות שלא בנוח בחברת אנשים הנראים בטוחים ומכווני-מטרה, עד כדי כך שתחושה זו עלולה להוביל לדיכאון. דחיינים מתוחים-מפוחדים נמנעים לעיתים מחיי חברה, ואפילו מקשר עם חברים קרובים. בתרבויות רבות מושג המחר עלול לשמש להבעת דחיינות. הדוגמה הידועה ביותר היא התרבות הספרדית, בה המילה "Mañana" (מחר בספרדית, מבוטא "מַנֲיַאנָה") מציינת דחייה שעשויה להיות אינסופית. ברומנית משמש הניב "La paştele cailor" (בפסחא של הסוסים) לציון דחייה למועד לא ידוע. בתלמוד משמש הביטוי שה"י פה"י, ראשי תיבות של "שבת היום, פסח היום", לתיאור דחיינות בתירוצי סרק. בעברית ישראלית משמש הביטוי "אחרי החגים" לדחיית כל התחייבות למועד בלתי ידוע, שכן בכל עת מצוי באופק הקרוב חג כלשהו מחגי ישראל המרובים. בערבית קיים הביטוי "בוקרה פיל מישמיש" שתרגומו "מחר בעונת המשמש" לדחייה למועד בלתי אפשרי. "המלבוש", סיפור קצר מאת ש"י עגנון מתאר דחיינות ותוצאותיה. הסיפור עוסק בחייט העוסק בתפירת מלבוש לשר, אך הוא דוחה את עבודתו בתירוצים שונים ומסיח את דעתו מן המלאכה, ולכן אינו מסיים את המשימה במועד שנקבע לה. גם כאשר ניתנת לו ארכה, הוא מכלה זמנו בפעולות אחרות, וסופו שנכשל כליל במשימה ומקפח את חייו.
"""
with open("/Users/yonti/Code/Hebrew-Tokenizer/tests/maniana.txt", "r") as f:
    text = f.read()

# for token in tokenize(text):
#     print(f"start={token[3][0]}")
search_phrase = "דחיינות"

for token in tokenize(text[590:1000]):
    _, tok, i, (s_i, e_i) = token
    if tok == search_phrase:
        print(s_i)
    print(i, tok, text[s_i:e_i])

for occurrence in re.finditer(search_phrase, text):
    word_start = occurrence.start()
    print(word_start)

print(len(text))