# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.

    OpenAPI spec version: v2.1
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class Folder(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, error_details=None, filter=None, folder_id=None, folder_items=None, folders=None, has_access=None, has_sub_folders=None, item_count=None, name=None, owner=None, parent_folder_id=None, parent_folder_uri=None, sub_folder_count=None, type=None, uri=None):
        """
        Folder - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'error_details': 'ErrorDetails',
            'filter': 'Filter',
            'folder_id': 'str',
            'folder_items': 'list[FolderItemV2]',
            'folders': 'list[Folder]',
            'has_access': 'str',
            'has_sub_folders': 'str',
            'item_count': 'str',
            'name': 'str',
            'owner': 'UserInfo',
            'parent_folder_id': 'str',
            'parent_folder_uri': 'str',
            'sub_folder_count': 'str',
            'type': 'str',
            'uri': 'str'
        }

        self.attribute_map = {
            'error_details': 'errorDetails',
            'filter': 'filter',
            'folder_id': 'folderId',
            'folder_items': 'folderItems',
            'folders': 'folders',
            'has_access': 'hasAccess',
            'has_sub_folders': 'hasSubFolders',
            'item_count': 'itemCount',
            'name': 'name',
            'owner': 'owner',
            'parent_folder_id': 'parentFolderId',
            'parent_folder_uri': 'parentFolderUri',
            'sub_folder_count': 'subFolderCount',
            'type': 'type',
            'uri': 'uri'
        }

        self._error_details = error_details
        self._filter = filter
        self._folder_id = folder_id
        self._folder_items = folder_items
        self._folders = folders
        self._has_access = has_access
        self._has_sub_folders = has_sub_folders
        self._item_count = item_count
        self._name = name
        self._owner = owner
        self._parent_folder_id = parent_folder_id
        self._parent_folder_uri = parent_folder_uri
        self._sub_folder_count = sub_folder_count
        self._type = type
        self._uri = uri

    @property
    def error_details(self):
        """
        Gets the error_details of this Folder.

        :return: The error_details of this Folder.
        :rtype: ErrorDetails
        """
        return self._error_details

    @error_details.setter
    def error_details(self, error_details):
        """
        Sets the error_details of this Folder.

        :param error_details: The error_details of this Folder.
        :type: ErrorDetails
        """

        self._error_details = error_details

    @property
    def filter(self):
        """
        Gets the filter of this Folder.

        :return: The filter of this Folder.
        :rtype: Filter
        """
        return self._filter

    @filter.setter
    def filter(self, filter):
        """
        Sets the filter of this Folder.

        :param filter: The filter of this Folder.
        :type: Filter
        """

        self._filter = filter

    @property
    def folder_id(self):
        """
        Gets the folder_id of this Folder.
        

        :return: The folder_id of this Folder.
        :rtype: str
        """
        return self._folder_id

    @folder_id.setter
    def folder_id(self, folder_id):
        """
        Sets the folder_id of this Folder.
        

        :param folder_id: The folder_id of this Folder.
        :type: str
        """

        self._folder_id = folder_id

    @property
    def folder_items(self):
        """
        Gets the folder_items of this Folder.
        A list of the envelopes in the specified folder or folders. 

        :return: The folder_items of this Folder.
        :rtype: list[FolderItemV2]
        """
        return self._folder_items

    @folder_items.setter
    def folder_items(self, folder_items):
        """
        Sets the folder_items of this Folder.
        A list of the envelopes in the specified folder or folders. 

        :param folder_items: The folder_items of this Folder.
        :type: list[FolderItemV2]
        """

        self._folder_items = folder_items

    @property
    def folders(self):
        """
        Gets the folders of this Folder.
        A collection of folder objects returned in a response.

        :return: The folders of this Folder.
        :rtype: list[Folder]
        """
        return self._folders

    @folders.setter
    def folders(self, folders):
        """
        Sets the folders of this Folder.
        A collection of folder objects returned in a response.

        :param folders: The folders of this Folder.
        :type: list[Folder]
        """

        self._folders = folders

    @property
    def has_access(self):
        """
        Gets the has_access of this Folder.
        

        :return: The has_access of this Folder.
        :rtype: str
        """
        return self._has_access

    @has_access.setter
    def has_access(self, has_access):
        """
        Sets the has_access of this Folder.
        

        :param has_access: The has_access of this Folder.
        :type: str
        """

        self._has_access = has_access

    @property
    def has_sub_folders(self):
        """
        Gets the has_sub_folders of this Folder.
        

        :return: The has_sub_folders of this Folder.
        :rtype: str
        """
        return self._has_sub_folders

    @has_sub_folders.setter
    def has_sub_folders(self, has_sub_folders):
        """
        Sets the has_sub_folders of this Folder.
        

        :param has_sub_folders: The has_sub_folders of this Folder.
        :type: str
        """

        self._has_sub_folders = has_sub_folders

    @property
    def item_count(self):
        """
        Gets the item_count of this Folder.
        

        :return: The item_count of this Folder.
        :rtype: str
        """
        return self._item_count

    @item_count.setter
    def item_count(self, item_count):
        """
        Sets the item_count of this Folder.
        

        :param item_count: The item_count of this Folder.
        :type: str
        """

        self._item_count = item_count

    @property
    def name(self):
        """
        Gets the name of this Folder.
        

        :return: The name of this Folder.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Folder.
        

        :param name: The name of this Folder.
        :type: str
        """

        self._name = name

    @property
    def owner(self):
        """
        Gets the owner of this Folder.

        :return: The owner of this Folder.
        :rtype: UserInfo
        """
        return self._owner

    @owner.setter
    def owner(self, owner):
        """
        Sets the owner of this Folder.

        :param owner: The owner of this Folder.
        :type: UserInfo
        """

        self._owner = owner

    @property
    def parent_folder_id(self):
        """
        Gets the parent_folder_id of this Folder.
        

        :return: The parent_folder_id of this Folder.
        :rtype: str
        """
        return self._parent_folder_id

    @parent_folder_id.setter
    def parent_folder_id(self, parent_folder_id):
        """
        Sets the parent_folder_id of this Folder.
        

        :param parent_folder_id: The parent_folder_id of this Folder.
        :type: str
        """

        self._parent_folder_id = parent_folder_id

    @property
    def parent_folder_uri(self):
        """
        Gets the parent_folder_uri of this Folder.
        

        :return: The parent_folder_uri of this Folder.
        :rtype: str
        """
        return self._parent_folder_uri

    @parent_folder_uri.setter
    def parent_folder_uri(self, parent_folder_uri):
        """
        Sets the parent_folder_uri of this Folder.
        

        :param parent_folder_uri: The parent_folder_uri of this Folder.
        :type: str
        """

        self._parent_folder_uri = parent_folder_uri

    @property
    def sub_folder_count(self):
        """
        Gets the sub_folder_count of this Folder.
        

        :return: The sub_folder_count of this Folder.
        :rtype: str
        """
        return self._sub_folder_count

    @sub_folder_count.setter
    def sub_folder_count(self, sub_folder_count):
        """
        Sets the sub_folder_count of this Folder.
        

        :param sub_folder_count: The sub_folder_count of this Folder.
        :type: str
        """

        self._sub_folder_count = sub_folder_count

    @property
    def type(self):
        """
        Gets the type of this Folder.
        

        :return: The type of this Folder.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this Folder.
        

        :param type: The type of this Folder.
        :type: str
        """

        self._type = type

    @property
    def uri(self):
        """
        Gets the uri of this Folder.
        

        :return: The uri of this Folder.
        :rtype: str
        """
        return self._uri

    @uri.setter
    def uri(self, uri):
        """
        Sets the uri of this Folder.
        

        :param uri: The uri of this Folder.
        :type: str
        """

        self._uri = uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
