# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.

    OpenAPI spec version: v2.1
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class BillingInvoice(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, amount=None, balance=None, due_date=None, invoice_id=None, invoice_items=None, invoice_number=None, invoice_uri=None, non_taxable_amount=None, pdf_available=None, taxable_amount=None):
        """
        BillingInvoice - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'amount': 'str',
            'balance': 'str',
            'due_date': 'str',
            'invoice_id': 'str',
            'invoice_items': 'list[BillingInvoiceItem]',
            'invoice_number': 'str',
            'invoice_uri': 'str',
            'non_taxable_amount': 'str',
            'pdf_available': 'str',
            'taxable_amount': 'str'
        }

        self.attribute_map = {
            'amount': 'amount',
            'balance': 'balance',
            'due_date': 'dueDate',
            'invoice_id': 'invoiceId',
            'invoice_items': 'invoiceItems',
            'invoice_number': 'invoiceNumber',
            'invoice_uri': 'invoiceUri',
            'non_taxable_amount': 'nonTaxableAmount',
            'pdf_available': 'pdfAvailable',
            'taxable_amount': 'taxableAmount'
        }

        self._amount = amount
        self._balance = balance
        self._due_date = due_date
        self._invoice_id = invoice_id
        self._invoice_items = invoice_items
        self._invoice_number = invoice_number
        self._invoice_uri = invoice_uri
        self._non_taxable_amount = non_taxable_amount
        self._pdf_available = pdf_available
        self._taxable_amount = taxable_amount

    @property
    def amount(self):
        """
        Gets the amount of this BillingInvoice.
        Reserved: TBD

        :return: The amount of this BillingInvoice.
        :rtype: str
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """
        Sets the amount of this BillingInvoice.
        Reserved: TBD

        :param amount: The amount of this BillingInvoice.
        :type: str
        """

        self._amount = amount

    @property
    def balance(self):
        """
        Gets the balance of this BillingInvoice.
        Reserved: TBD

        :return: The balance of this BillingInvoice.
        :rtype: str
        """
        return self._balance

    @balance.setter
    def balance(self, balance):
        """
        Sets the balance of this BillingInvoice.
        Reserved: TBD

        :param balance: The balance of this BillingInvoice.
        :type: str
        """

        self._balance = balance

    @property
    def due_date(self):
        """
        Gets the due_date of this BillingInvoice.
        Reserved: TBD

        :return: The due_date of this BillingInvoice.
        :rtype: str
        """
        return self._due_date

    @due_date.setter
    def due_date(self, due_date):
        """
        Sets the due_date of this BillingInvoice.
        Reserved: TBD

        :param due_date: The due_date of this BillingInvoice.
        :type: str
        """

        self._due_date = due_date

    @property
    def invoice_id(self):
        """
        Gets the invoice_id of this BillingInvoice.
        Reserved: TBD

        :return: The invoice_id of this BillingInvoice.
        :rtype: str
        """
        return self._invoice_id

    @invoice_id.setter
    def invoice_id(self, invoice_id):
        """
        Sets the invoice_id of this BillingInvoice.
        Reserved: TBD

        :param invoice_id: The invoice_id of this BillingInvoice.
        :type: str
        """

        self._invoice_id = invoice_id

    @property
    def invoice_items(self):
        """
        Gets the invoice_items of this BillingInvoice.
        Reserved: TBD

        :return: The invoice_items of this BillingInvoice.
        :rtype: list[BillingInvoiceItem]
        """
        return self._invoice_items

    @invoice_items.setter
    def invoice_items(self, invoice_items):
        """
        Sets the invoice_items of this BillingInvoice.
        Reserved: TBD

        :param invoice_items: The invoice_items of this BillingInvoice.
        :type: list[BillingInvoiceItem]
        """

        self._invoice_items = invoice_items

    @property
    def invoice_number(self):
        """
        Gets the invoice_number of this BillingInvoice.
        Reserved: TBD

        :return: The invoice_number of this BillingInvoice.
        :rtype: str
        """
        return self._invoice_number

    @invoice_number.setter
    def invoice_number(self, invoice_number):
        """
        Sets the invoice_number of this BillingInvoice.
        Reserved: TBD

        :param invoice_number: The invoice_number of this BillingInvoice.
        :type: str
        """

        self._invoice_number = invoice_number

    @property
    def invoice_uri(self):
        """
        Gets the invoice_uri of this BillingInvoice.
        Contains a URI for an endpoint that you can use to retrieve invoice information.

        :return: The invoice_uri of this BillingInvoice.
        :rtype: str
        """
        return self._invoice_uri

    @invoice_uri.setter
    def invoice_uri(self, invoice_uri):
        """
        Sets the invoice_uri of this BillingInvoice.
        Contains a URI for an endpoint that you can use to retrieve invoice information.

        :param invoice_uri: The invoice_uri of this BillingInvoice.
        :type: str
        """

        self._invoice_uri = invoice_uri

    @property
    def non_taxable_amount(self):
        """
        Gets the non_taxable_amount of this BillingInvoice.
        

        :return: The non_taxable_amount of this BillingInvoice.
        :rtype: str
        """
        return self._non_taxable_amount

    @non_taxable_amount.setter
    def non_taxable_amount(self, non_taxable_amount):
        """
        Sets the non_taxable_amount of this BillingInvoice.
        

        :param non_taxable_amount: The non_taxable_amount of this BillingInvoice.
        :type: str
        """

        self._non_taxable_amount = non_taxable_amount

    @property
    def pdf_available(self):
        """
        Gets the pdf_available of this BillingInvoice.
        

        :return: The pdf_available of this BillingInvoice.
        :rtype: str
        """
        return self._pdf_available

    @pdf_available.setter
    def pdf_available(self, pdf_available):
        """
        Sets the pdf_available of this BillingInvoice.
        

        :param pdf_available: The pdf_available of this BillingInvoice.
        :type: str
        """

        self._pdf_available = pdf_available

    @property
    def taxable_amount(self):
        """
        Gets the taxable_amount of this BillingInvoice.
        

        :return: The taxable_amount of this BillingInvoice.
        :rtype: str
        """
        return self._taxable_amount

    @taxable_amount.setter
    def taxable_amount(self, taxable_amount):
        """
        Sets the taxable_amount of this BillingInvoice.
        

        :param taxable_amount: The taxable_amount of this BillingInvoice.
        :type: str
        """

        self._taxable_amount = taxable_amount

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
