import io
import os
import re

from setuptools import find_packages
from setuptools import setup

__version__ = '0.1.0'

def read(filename):
    filename = os.path.join(os.path.dirname(__file__), filename)
    text_type = type(u"")
    with io.open(filename, mode="r", encoding='utf-8') as fd:
        return re.sub(text_type(r':[a-z]+:`~?(.*?)`'), text_type(r'``\1``'), fd.read())

setup(
    name="gww_service",
    version=__version__,
    url="https://github.com/global-water-watch/gww-service",
    license='MIT',

    author="Jaap Langemeijer",
    author_email="jaaplangemeijer@gmail.com",

    description="Package for GWW service components.",
    long_description_content_type="text/markdown",
    long_description=read("README.md"),

    packages=find_packages(exclude=('tests',)),

    install_requires=[
        "earthengine-api>=0.1.284",
        "eepackages>=0.21",
        "fastapi>=0.83",
        "GeoAlchemy2>=0.12",
        "geojson>=2.5",
        "geojson-pydantic>=0.4.3",
        "httpx>=0.23",
        "python-dateutil",
        "shapely>=1.8",
        "SQLAlchemy>=1.4",
        "uvicorn>=0.18",
    ],

    classifiers=[
        'Development Status :: 2 - Pre-Alpha',
        'License :: OSI Approved :: MIT License',
        'Programming Language :: Python',
        'Programming Language :: Python :: 2',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.4',
        'Programming Language :: Python :: 3.5',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
    ],
)
