import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RunnerConfig extends cdktf.TerraformMetaArguments {
    /**
    * The access_level of the runner. Valid values are: `not_protected`, `ref_protected`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/runner#access_level Runner#access_level}
    */
    readonly accessLevel?: string;
    /**
    * The runner's description.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/runner#description Runner#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/runner#id Runner#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Whether the runner should be locked for current project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/runner#locked Runner#locked}
    */
    readonly locked?: boolean | cdktf.IResolvable;
    /**
    * Maximum timeout set when this runner handles the job.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/runner#maximum_timeout Runner#maximum_timeout}
    */
    readonly maximumTimeout?: number;
    /**
    * Whether the runner should ignore new jobs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/runner#paused Runner#paused}
    */
    readonly paused?: boolean | cdktf.IResolvable;
    /**
    * The registration token used to register the runner.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/runner#registration_token Runner#registration_token}
    */
    readonly registrationToken: string;
    /**
    * Whether the runner should handle untagged jobs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/runner#run_untagged Runner#run_untagged}
    */
    readonly runUntagged?: boolean | cdktf.IResolvable;
    /**
    * List of runner’s tags.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/runner#tag_list Runner#tag_list}
    */
    readonly tagList?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/runner gitlab_runner}
*/
export declare class Runner extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_runner";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/runner gitlab_runner} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RunnerConfig
    */
    constructor(scope: Construct, id: string, config: RunnerConfig);
    private _accessLevel?;
    get accessLevel(): string;
    set accessLevel(value: string);
    resetAccessLevel(): void;
    get accessLevelInput(): string | undefined;
    get authenticationToken(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _locked?;
    get locked(): boolean | cdktf.IResolvable;
    set locked(value: boolean | cdktf.IResolvable);
    resetLocked(): void;
    get lockedInput(): boolean | cdktf.IResolvable | undefined;
    private _maximumTimeout?;
    get maximumTimeout(): number;
    set maximumTimeout(value: number);
    resetMaximumTimeout(): void;
    get maximumTimeoutInput(): number | undefined;
    private _paused?;
    get paused(): boolean | cdktf.IResolvable;
    set paused(value: boolean | cdktf.IResolvable);
    resetPaused(): void;
    get pausedInput(): boolean | cdktf.IResolvable | undefined;
    private _registrationToken?;
    get registrationToken(): string;
    set registrationToken(value: string);
    get registrationTokenInput(): string | undefined;
    private _runUntagged?;
    get runUntagged(): boolean | cdktf.IResolvable;
    set runUntagged(value: boolean | cdktf.IResolvable);
    resetRunUntagged(): void;
    get runUntaggedInput(): boolean | cdktf.IResolvable | undefined;
    get status(): string;
    private _tagList?;
    get tagList(): string[];
    set tagList(value: string[]);
    resetTagList(): void;
    get tagListInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
