# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['dndfog', 'dndfog.draw']

package_data = \
{'': ['*']}

install_requires = \
['pygame==2.2.0', 'pywin32==305']

entry_points = \
{'console_scripts': ['dndfog = dndfog.main:start']}

setup_kwargs = {
    'name': 'dndfog',
    'version': '0.6.1',
    'description': 'DND battle map with fog of war',
    'long_description': "# DnD Fog\n\n[![GitHub Workflow Status][status-badge]][status]\n[![PyPI][pypi-badge]][pypi]\n[![GitHub][licence-badge]][licence]\n[![GitHub Last Commit][repo-badge]][repo]\n[![GitHub Issues][issues-badge]][issues]\n[![Downloads][downloads-badge]][pypi]\n[![Python Version][version-badge]][pypi]\n\n```shell\npip install dndfog\n```\n\n---\n\n**Documentation**: [https://mrthearman.github.io/dndfog/](https://mrthearman.github.io/dndfog/)\n\n**Source Code**: [https://github.com/MrThearMan/dndfog/](https://github.com/MrThearMan/dndfog/)\n\n---\n\nCreate battlemaps for tabletop RPGs, like [D&D](https://www.dndbeyond.com/).\n\n> Program is Windows only for now. This is due to the saving and loading widgets\n> being Windows only (using pywin32). You're free to modify the code to add file\n> loading and saving for other platforms.\n\n![Example Map](https://github.com/MrThearMan/dndfog/blob/main/docs/img/example-map.png?raw=true)\n\n## Features\n\n- Infinite grid\n- Add and remove a [fog of war](https://en.wikipedia.org/wiki/Fog_of_war) effect\n- Import maps from image files\n- Place, move and remove pieces on a grid (can be matched to image grid)\n- Place 1x1, 2x2, 3x3, or 4x4 pieces\n- Make markings on the map to show areas of effect or point out things to the players\n- Save and load file to a single JSON file (no need to keep the image file separately!)\n\n## How to use\n\nWhen installing from [pypi](https://pypi.org/), the library should come with a script\nnamed `dndfog` that you can run. It should be available in your environment if\nthe `Python\\Scripts` folder is set in PATH. You can also download an EXE from\nthe [GitHub releases](https://github.com/MrThearMan/dndfog/releases).\n\nWhen the program opens, you need to select an image file to use as a background,\nor a JSON data file to load a map from. You can also lauch the program with\n`--file=<filepath>` to add an initial file.\n\n> The program does not autosave! You have to save (and override) the file yourself!\n\n### Keyboard shortcuts\n\nToolbar:\n- Open/close the toolbar: `TAB`\n- Select tool from the toolbar: Quick select with the number keys `1-9` or click the\n  tool button with `Left mouse button` when the toolbar is open\n\nCamera:\n- Move camera: `Click and drag: Middle mouse button`\n- Zoom in: _Any tool except the `grid` tool_ selected from the toolbar + `Scroll wheel: Up`\n- Zoom out: _Any tool except the `grid` tool_ selected from the toolbar + `Scroll wheel: Down`\n\nPiece (quick select: `1`):\n- Add a piece: Select the `piece` tool from the toolbar + `Right mouse button` on an empty square\n- Remove a piece: Select the `piece` tool from the toolbar  + `Right mouse button` on a piece\n- Move a piece: Select the `piece` tool from the toolbar  + `Click and drag: Left mouse button`\n\nFog (quick select: `2`):\n- Add fog: Select the `fog` tool from the toolbar  + `Left mouse button`\n- Remove fog: Select the `fog` tool from the toolbar  + `Right mouse button`\n- Show/hide fog: `F1` or the checkbox in the `fog` toolbar\n- Change fog size: Select the size to use from the `size` selector in the `fog` toolbar\n\nMap (quick select: `3`):\n- Move map image: Select the `map` tool from the toolbar + `Click and drag: Left mouse button`\n\nGrid (quick select: `4`):\n- Increase gridsize: Select the `grid` tool from the toolbar + `Scroll wheel: Up`\n- Decrease gridsize: Select the `grid` tool from the toolbar + `Scroll wheel: Down`\n- Show/hide grid: `F2` or the checkbox in the `fog` toolbar\n\nMark (quick select: `5`):\n- Make markings: Select the `mark` tool from the toolbar + `Click and drag: Left mouse button`\n- Erase markings: Select the `mark` tool from the toolbar + `Click and drag: Right mouse button`\n- Clear markings: Click the `clear` button in the `mark` toolbar\n- Change marker color: Use the color selector in the `mark` toolbar\n\nMisc:\n- Save file: `CTRL + S` (will skip file dialog if json data file already exists)\n- Save file as: `CTRL + Shift + S` (will always open a file dialog)\n- Open file: `CTRL + O`\n- Quit program: Press the X mutton on the window\n\n## Known issues or lacking features\n\n- Matching program gridsize to background gridsize is a bit awkward\n- When zooming, the program grid and background map might not stay aligned\n- It's hard to keep track of combat, since there is no built-in turn order tracking\n- It's too easy to accidentally remove fog you didn't mean to. There should be some way to\n  layer fog, so that only some of it can be removed\n- Markings do not scale when zooming\n- There is no undo or redo\n- There is no way to add pictures to pieces to identify them better\n\n[status-badge]: https://img.shields.io/github/actions/workflow/status/MrThearMan/dndfog/test.yml?branch=main\n[pypi-badge]: https://img.shields.io/pypi/v/dndfog\n[licence-badge]: https://img.shields.io/github/license/MrThearMan/dndfog\n[repo-badge]: https://img.shields.io/github/last-commit/MrThearMan/dndfog\n[issues-badge]: https://img.shields.io/github/issues-raw/MrThearMan/dndfog\n[version-badge]: https://img.shields.io/pypi/pyversions/dndfog\n[downloads-badge]: https://img.shields.io/pypi/dm/dndfog\n\n[status]: https://github.com/MrThearMan/dndfog/actions/workflows/test.yml\n[pypi]: https://pypi.org/project/dndfog\n[licence]: https://github.com/MrThearMan/dndfog/blob/main/LICENSE\n[repo]: https://github.com/MrThearMan/dndfog/commits/main\n[issues]: https://github.com/MrThearMan/dndfog/issues\n",
    'author': 'Matti Lamppu',
    'author_email': 'lamppu.matti.akseli@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://mrthearman.github.io/dndfog/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.10,<3.12',
}


setup(**setup_kwargs)
