# Changelog

## [v2.7.1](https://github.com/tj-django/django-clone/tree/v2.7.1) (2021-06-25)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v2.7.0...v2.7.1)

**Closed issues:**

- Add release automation which would be triggered by a new release. [\#231](https://github.com/tj-django/django-clone/issues/231)

**Merged pull requests:**

- Updated docs [\#391](https://github.com/tj-django/django-clone/pull/391) ([github-actions[bot]](https://github.com/apps/github-actions))
- Updated docs [\#389](https://github.com/tj-django/django-clone/pull/389) ([github-actions[bot]](https://github.com/apps/github-actions))
- Updated README.md [\#388](https://github.com/tj-django/django-clone/pull/388) ([jackton1](https://github.com/jackton1))
- docs: add ptrck as a contributor for code [\#387](https://github.com/tj-django/django-clone/pull/387) ([allcontributors[bot]](https://github.com/apps/allcontributors))
- Updated docs [\#386](https://github.com/tj-django/django-clone/pull/386) ([github-actions[bot]](https://github.com/apps/github-actions))
- Upgraded v2.6.1 → v2.7.0 [\#385](https://github.com/tj-django/django-clone/pull/385) ([jackton1](https://github.com/jackton1))

## [v2.7.0](https://github.com/tj-django/django-clone/tree/v2.7.0) (2021-06-24)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v2.6.1...v2.7.0)

**Fixed bugs:**

- UUIDField with unique re-uses previous value and raises an IntegrityError [\#381](https://github.com/tj-django/django-clone/issues/381)

**Closed issues:**

- Dependency Dashboard [\#198](https://github.com/tj-django/django-clone/issues/198)

**Merged pull requests:**

- Updated translation to exclude sample apps [\#384](https://github.com/tj-django/django-clone/pull/384) ([jackton1](https://github.com/jackton1))
- Resolve bug re-using the source instance value. [\#383](https://github.com/tj-django/django-clone/pull/383) ([jackton1](https://github.com/jackton1))
- Updated translation. [\#382](https://github.com/tj-django/django-clone/pull/382) ([jackton1](https://github.com/jackton1))
- Update tj-actions/verify-changed-files action to v7 [\#380](https://github.com/tj-django/django-clone/pull/380) ([renovate[bot]](https://github.com/apps/renovate))
- Fix typo in doc strings. [\#379](https://github.com/tj-django/django-clone/pull/379) ([jackton1](https://github.com/jackton1))
- Update precommit hook pycqa/isort to v5.9.1 [\#378](https://github.com/tj-django/django-clone/pull/378) ([renovate[bot]](https://github.com/apps/renovate))
- Update precommit hook pycqa/isort to v5.9.0 [\#377](https://github.com/tj-django/django-clone/pull/377) ([renovate[bot]](https://github.com/apps/renovate))
- Updated docs [\#376](https://github.com/tj-django/django-clone/pull/376) ([github-actions[bot]](https://github.com/apps/github-actions))
- Upgraded v2.6.0 → v2.6.1 [\#375](https://github.com/tj-django/django-clone/pull/375) ([jackton1](https://github.com/jackton1))

## [v2.6.1](https://github.com/tj-django/django-clone/tree/v2.6.1) (2021-06-19)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v2.6.0...v2.6.1)

**Merged pull requests:**

- Upgraded v2.5.3 → v2.6.0 [\#374](https://github.com/tj-django/django-clone/pull/374) ([jackton1](https://github.com/jackton1))

## [v2.6.0](https://github.com/tj-django/django-clone/tree/v2.6.0) (2021-06-19)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v2.5.3...v2.6.0)

**Implemented enhancements:**

- Drop python2.7 support. [\#204](https://github.com/tj-django/django-clone/issues/204)

**Fixed bugs:**

- \[BUG\] - Duplicated models are not always created in same database [\#366](https://github.com/tj-django/django-clone/issues/366)
- \[BUG\] \(Admin view\) Cloning from "bulk" doees not work, while it works fine inside of instance editor [\#333](https://github.com/tj-django/django-clone/issues/333)
- `TextField` is not supported with unique value generation [\#331](https://github.com/tj-django/django-clone/issues/331)

**Closed issues:**

- How to clone a question with its choices? [\#315](https://github.com/tj-django/django-clone/issues/315)
- Cloning complex model relationships [\#175](https://github.com/tj-django/django-clone/issues/175)

**Merged pull requests:**

- Increase test coverage and add release automation [\#373](https://github.com/tj-django/django-clone/pull/373) ([jackton1](https://github.com/jackton1))
- Updated docs [\#372](https://github.com/tj-django/django-clone/pull/372) ([github-actions[bot]](https://github.com/apps/github-actions))
- Updated locales. [\#371](https://github.com/tj-django/django-clone/pull/371) ([jackton1](https://github.com/jackton1))
- Updated README.md [\#370](https://github.com/tj-django/django-clone/pull/370) ([jackton1](https://github.com/jackton1))
- Added translation support. [\#369](https://github.com/tj-django/django-clone/pull/369) ([jackton1](https://github.com/jackton1))
- Add support for multiple databases [\#368](https://github.com/tj-django/django-clone/pull/368) ([jackton1](https://github.com/jackton1))
- Update auto-merge.yml [\#367](https://github.com/tj-django/django-clone/pull/367) ([jackton1](https://github.com/jackton1))
- \[pre-commit.ci\] pre-commit autoupdate [\#365](https://github.com/tj-django/django-clone/pull/365) ([pre-commit-ci[bot]](https://github.com/apps/pre-commit-ci))
- Update codecov/codecov-action action to v1.5.2 [\#364](https://github.com/tj-django/django-clone/pull/364) ([renovate[bot]](https://github.com/apps/renovate))
- Updated docs [\#363](https://github.com/tj-django/django-clone/pull/363) ([github-actions[bot]](https://github.com/apps/github-actions))
- Updated README.md [\#362](https://github.com/tj-django/django-clone/pull/362) ([jackton1](https://github.com/jackton1))
- Updated docs [\#361](https://github.com/tj-django/django-clone/pull/361) ([github-actions[bot]](https://github.com/apps/github-actions))
- Update README.md [\#360](https://github.com/tj-django/django-clone/pull/360) ([jackton1](https://github.com/jackton1))
- Updated docs [\#359](https://github.com/tj-django/django-clone/pull/359) ([github-actions[bot]](https://github.com/apps/github-actions))
- Updated README.md [\#358](https://github.com/tj-django/django-clone/pull/358) ([jackton1](https://github.com/jackton1))
- Updated README.md [\#357](https://github.com/tj-django/django-clone/pull/357) ([jackton1](https://github.com/jackton1))
- docs: add ptrck as a contributor [\#356](https://github.com/tj-django/django-clone/pull/356) ([allcontributors[bot]](https://github.com/apps/allcontributors))
- feature/update docs and usage of str format [\#355](https://github.com/tj-django/django-clone/pull/355) ([jackton1](https://github.com/jackton1))
- Update dependency django to v3.2.4 [\#354](https://github.com/tj-django/django-clone/pull/354) ([renovate[bot]](https://github.com/apps/renovate))
- Updated docs [\#353](https://github.com/tj-django/django-clone/pull/353) ([github-actions[bot]](https://github.com/apps/github-actions))
- Updated README.md [\#352](https://github.com/tj-django/django-clone/pull/352) ([jackton1](https://github.com/jackton1))
- Updated docs [\#350](https://github.com/tj-django/django-clone/pull/350) ([github-actions[bot]](https://github.com/apps/github-actions))
- Updated README.md [\#349](https://github.com/tj-django/django-clone/pull/349) ([jackton1](https://github.com/jackton1))
- Update README.md [\#348](https://github.com/tj-django/django-clone/pull/348) ([jackton1](https://github.com/jackton1))
- Make sure format string is properly translated [\#346](https://github.com/tj-django/django-clone/pull/346) ([ptrck](https://github.com/ptrck))
- Update wearerequired/lint-action action to v1.10.0 [\#345](https://github.com/tj-django/django-clone/pull/345) ([renovate[bot]](https://github.com/apps/renovate))
- Update actions/cache action to v2.1.6 [\#344](https://github.com/tj-django/django-clone/pull/344) ([renovate[bot]](https://github.com/apps/renovate))
- Update pascalgn/automerge-action action to v0.14.2 [\#343](https://github.com/tj-django/django-clone/pull/343) ([renovate[bot]](https://github.com/apps/renovate))
- Bump django from 3.2.2 to 3.2.3 [\#342](https://github.com/tj-django/django-clone/pull/342) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): update peter-evans/create-pull-request action to v3.10.0 [\#340](https://github.com/tj-django/django-clone/pull/340) ([renovate[bot]](https://github.com/apps/renovate))
- Updated docs [\#339](https://github.com/tj-django/django-clone/pull/339) ([github-actions[bot]](https://github.com/apps/github-actions))
- Updated README.md [\#338](https://github.com/tj-django/django-clone/pull/338) ([jackton1](https://github.com/jackton1))
- Updated docs [\#337](https://github.com/tj-django/django-clone/pull/337) ([github-actions[bot]](https://github.com/apps/github-actions))
- docs: add diesieben07 as a contributor [\#336](https://github.com/tj-django/django-clone/pull/336) ([allcontributors[bot]](https://github.com/apps/allcontributors))
- Skip lint actions on forks [\#335](https://github.com/tj-django/django-clone/pull/335) ([jackton1](https://github.com/jackton1))
- Remove tox cache [\#334](https://github.com/tj-django/django-clone/pull/334) ([jackton1](https://github.com/jackton1))
- Add support for unique TextFields [\#332](https://github.com/tj-django/django-clone/pull/332) ([diesieben07](https://github.com/diesieben07))
- Update precommit hook pre-commit/pre-commit-hooks to v4.0.1 [\#329](https://github.com/tj-django/django-clone/pull/329) ([renovate[bot]](https://github.com/apps/renovate))
- Drop python2.7 support [\#328](https://github.com/tj-django/django-clone/pull/328) ([jackton1](https://github.com/jackton1))
- Update precommit hook pre-commit/pre-commit-hooks to v4 [\#327](https://github.com/tj-django/django-clone/pull/327) ([renovate[bot]](https://github.com/apps/renovate))
- Bump peter-evans/create-pull-request from 3.9.1 to 3.9.2 [\#326](https://github.com/tj-django/django-clone/pull/326) ([dependabot[bot]](https://github.com/apps/dependabot))
- Update dependency django to v3.2.3 [\#325](https://github.com/tj-django/django-clone/pull/325) ([renovate[bot]](https://github.com/apps/renovate))
- Bump actions/first-interaction from 1 to 1.1.0 [\#324](https://github.com/tj-django/django-clone/pull/324) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump actions/setup-python from 2 to 2.2.2 [\#323](https://github.com/tj-django/django-clone/pull/323) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump actions/cache from 2 to 2.1.5 [\#322](https://github.com/tj-django/django-clone/pull/322) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump peaceiris/actions-gh-pages from 3 to 3.8.0 [\#321](https://github.com/tj-django/django-clone/pull/321) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump actions/checkout from 2 to 2.3.4 [\#320](https://github.com/tj-django/django-clone/pull/320) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump peter-evans/create-pull-request from 3 to 3.9.1 [\#319](https://github.com/tj-django/django-clone/pull/319) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump codecov/codecov-action from 1 to 1.5.0 [\#318](https://github.com/tj-django/django-clone/pull/318) ([dependabot[bot]](https://github.com/apps/dependabot))
- \[pre-commit.ci\] pre-commit autoupdate [\#317](https://github.com/tj-django/django-clone/pull/317) ([pre-commit-ci[bot]](https://github.com/apps/pre-commit-ci))
- Updated docs [\#316](https://github.com/tj-django/django-clone/pull/316) ([github-actions[bot]](https://github.com/apps/github-actions))
- Update dependency django to v3.2.2 [\#313](https://github.com/tj-django/django-clone/pull/313) ([renovate[bot]](https://github.com/apps/renovate))
- Update dependency six to v1.16.0 [\#312](https://github.com/tj-django/django-clone/pull/312) ([renovate[bot]](https://github.com/apps/renovate))
- Update dependency django to v3.2.1 [\#310](https://github.com/tj-django/django-clone/pull/310) ([renovate[bot]](https://github.com/apps/renovate))
- \[pre-commit.ci\] pre-commit autoupdate [\#309](https://github.com/tj-django/django-clone/pull/309) ([pre-commit-ci[bot]](https://github.com/apps/pre-commit-ci))
- Update dependency typing-extensions to v3.10.0.0 [\#307](https://github.com/tj-django/django-clone/pull/307) ([renovate[bot]](https://github.com/apps/renovate))
- Upgrade to GitHub-native Dependabot [\#306](https://github.com/tj-django/django-clone/pull/306) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- \[pre-commit.ci\] pre-commit autoupdate [\#305](https://github.com/tj-django/django-clone/pull/305) ([pre-commit-ci[bot]](https://github.com/apps/pre-commit-ci))
- Updated django master -\> main [\#304](https://github.com/tj-django/django-clone/pull/304) ([jackton1](https://github.com/jackton1))
- Updated docs [\#303](https://github.com/tj-django/django-clone/pull/303) ([github-actions[bot]](https://github.com/apps/github-actions))

## [v2.5.3](https://github.com/tj-django/django-clone/tree/v2.5.3) (2021-04-25)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v2.5.2...v2.5.3)

**Merged pull requests:**

- Fixed bug using sub\_clone=True [\#302](https://github.com/tj-django/django-clone/pull/302) ([jackton1](https://github.com/jackton1))
- Updated docs [\#301](https://github.com/tj-django/django-clone/pull/301) ([github-actions[bot]](https://github.com/apps/github-actions))
- Updated docs [\#300](https://github.com/tj-django/django-clone/pull/300) ([github-actions[bot]](https://github.com/apps/github-actions))

## [v2.5.2](https://github.com/tj-django/django-clone/tree/v2.5.2) (2021-04-23)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v2.5.1...v2.5.2)

**Merged pull requests:**

- Improve test coverage. [\#299](https://github.com/tj-django/django-clone/pull/299) ([jackton1](https://github.com/jackton1))
- Updated docs [\#298](https://github.com/tj-django/django-clone/pull/298) ([github-actions[bot]](https://github.com/apps/github-actions))
- Updated docs [\#297](https://github.com/tj-django/django-clone/pull/297) ([github-actions[bot]](https://github.com/apps/github-actions))
- Fixed regression calling instance.full\_clean [\#296](https://github.com/tj-django/django-clone/pull/296) ([jackton1](https://github.com/jackton1))

## [v2.5.1](https://github.com/tj-django/django-clone/tree/v2.5.1) (2021-04-22)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v2.5.0...v2.5.1)

**Fixed bugs:**

- \[BUG\] Regression on full\_clean [\#295](https://github.com/tj-django/django-clone/issues/295)

**Merged pull requests:**

- Updated docs [\#294](https://github.com/tj-django/django-clone/pull/294) ([github-actions[bot]](https://github.com/apps/github-actions))
- Update README.md [\#293](https://github.com/tj-django/django-clone/pull/293) ([jackton1](https://github.com/jackton1))
- Revert "Update README.md" [\#291](https://github.com/tj-django/django-clone/pull/291) ([jackton1](https://github.com/jackton1))
- Updated docs [\#290](https://github.com/tj-django/django-clone/pull/290) ([github-actions[bot]](https://github.com/apps/github-actions))
- Update README.md [\#289](https://github.com/tj-django/django-clone/pull/289) ([jackton1](https://github.com/jackton1))
- Updated docs [\#288](https://github.com/tj-django/django-clone/pull/288) ([github-actions[bot]](https://github.com/apps/github-actions))

## [v2.5.0](https://github.com/tj-django/django-clone/tree/v2.5.0) (2021-04-21)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v2.4.0...v2.5.0)

**Merged pull requests:**

- Updated docs [\#287](https://github.com/tj-django/django-clone/pull/287) ([github-actions[bot]](https://github.com/apps/github-actions))
- Update README.md [\#286](https://github.com/tj-django/django-clone/pull/286) ([jackton1](https://github.com/jackton1))
- Updated docs [\#285](https://github.com/tj-django/django-clone/pull/285) ([github-actions[bot]](https://github.com/apps/github-actions))
- Added black pre-commit hook [\#284](https://github.com/tj-django/django-clone/pull/284) ([jackton1](https://github.com/jackton1))
- Updated docs [\#283](https://github.com/tj-django/django-clone/pull/283) ([github-actions[bot]](https://github.com/apps/github-actions))
- Update README.md [\#282](https://github.com/tj-django/django-clone/pull/282) ([jackton1](https://github.com/jackton1))
- Fix bugs for related\_name and m2o clone [\#281](https://github.com/tj-django/django-clone/pull/281) ([yuekui](https://github.com/yuekui))
- Updated docs [\#280](https://github.com/tj-django/django-clone/pull/280) ([github-actions[bot]](https://github.com/apps/github-actions))
- Update classmethod order. [\#276](https://github.com/tj-django/django-clone/pull/276) ([jackton1](https://github.com/jackton1))
- Update test coverage. [\#274](https://github.com/tj-django/django-clone/pull/274) ([jackton1](https://github.com/jackton1))
- Update function order. [\#273](https://github.com/tj-django/django-clone/pull/273) ([jackton1](https://github.com/jackton1))
- Updated tox to test django3.2. [\#272](https://github.com/tj-django/django-clone/pull/272) ([jackton1](https://github.com/jackton1))
- Updated docs [\#271](https://github.com/tj-django/django-clone/pull/271) ([github-actions[bot]](https://github.com/apps/github-actions))

## [v2.4.0](https://github.com/tj-django/django-clone/tree/v2.4.0) (2021-04-16)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v2.3.3...v2.4.0)

**Fixed bugs:**

- \[BUG\] when cloning, images are not created but are linked to the source image [\#268](https://github.com/tj-django/django-clone/issues/268)

**Closed issues:**

- Consolidate the sample apps [\#216](https://github.com/tj-django/django-clone/issues/216)
- Add ROADMAP and outstanding features [\#55](https://github.com/tj-django/django-clone/issues/55)
- Document the excluded fields. [\#25](https://github.com/tj-django/django-clone/issues/25)

**Merged pull requests:**

- Updated install\_requires and doc strings. [\#269](https://github.com/tj-django/django-clone/pull/269) ([jackton1](https://github.com/jackton1))
- Clean up implementation. [\#267](https://github.com/tj-django/django-clone/pull/267) ([jackton1](https://github.com/jackton1))
- Add a delay to resolve inconsistency in windows [\#266](https://github.com/tj-django/django-clone/pull/266) ([jackton1](https://github.com/jackton1))
- Update test\_clone\_mixin.py [\#265](https://github.com/tj-django/django-clone/pull/265) ([jackton1](https://github.com/jackton1))
- Updated docs [\#263](https://github.com/tj-django/django-clone/pull/263) ([github-actions[bot]](https://github.com/apps/github-actions))
- Updated the default auto field [\#262](https://github.com/tj-django/django-clone/pull/262) ([jackton1](https://github.com/jackton1))
- Updated docs [\#260](https://github.com/tj-django/django-clone/pull/260) ([github-actions[bot]](https://github.com/apps/github-actions))
- Updated docs [\#259](https://github.com/tj-django/django-clone/pull/259) ([github-actions[bot]](https://github.com/apps/github-actions))
- Updated docs [\#258](https://github.com/tj-django/django-clone/pull/258) ([github-actions[bot]](https://github.com/apps/github-actions))

## [v2.3.3](https://github.com/tj-django/django-clone/tree/v2.3.3) (2021-04-09)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v2.3.2...v2.3.3)

## [v2.3.2](https://github.com/tj-django/django-clone/tree/v2.3.2) (2021-04-08)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v2.3.1...v2.3.2)

**Merged pull requests:**

- Improve doc strings [\#257](https://github.com/tj-django/django-clone/pull/257) ([jackton1](https://github.com/jackton1))
- Updated docs [\#256](https://github.com/tj-django/django-clone/pull/256) ([github-actions[bot]](https://github.com/apps/github-actions))

## [v2.3.1](https://github.com/tj-django/django-clone/tree/v2.3.1) (2021-04-08)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v2.3.0...v2.3.1)

## [v2.3.0](https://github.com/tj-django/django-clone/tree/v2.3.0) (2021-04-08)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v2.2.1...v2.3.0)

**Fixed bugs:**

- Error cloning models that have one to one fields [\#248](https://github.com/tj-django/django-clone/issues/248)

**Merged pull requests:**

- Fix bug cloning o2o fields [\#255](https://github.com/tj-django/django-clone/pull/255) ([jackton1](https://github.com/jackton1))
- Revert "Fixed bug with cloning o2o fields" [\#254](https://github.com/tj-django/django-clone/pull/254) ([jackton1](https://github.com/jackton1))
- Updated the library verbose name. [\#253](https://github.com/tj-django/django-clone/pull/253) ([jackton1](https://github.com/jackton1))
- Fixed bug with cloning o2o fields [\#252](https://github.com/tj-django/django-clone/pull/252) ([jackton1](https://github.com/jackton1))
- Updated docs [\#251](https://github.com/tj-django/django-clone/pull/251) ([github-actions[bot]](https://github.com/apps/github-actions))

## [v2.2.1](https://github.com/tj-django/django-clone/tree/v2.2.1) (2021-04-07)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v2.2.0...v2.2.1)

## [v2.2.0](https://github.com/tj-django/django-clone/tree/v2.2.0) (2021-04-07)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v2.1.1...v2.2.0)

**Merged pull requests:**

- Update test.yml [\#250](https://github.com/tj-django/django-clone/pull/250) ([jackton1](https://github.com/jackton1))
- Updated docs [\#247](https://github.com/tj-django/django-clone/pull/247) ([github-actions[bot]](https://github.com/apps/github-actions))

## [v2.1.1](https://github.com/tj-django/django-clone/tree/v2.1.1) (2021-03-25)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v2.1.3...v2.1.1)

**Merged pull requests:**

- Updated docs [\#245](https://github.com/tj-django/django-clone/pull/245) ([github-actions[bot]](https://github.com/apps/github-actions))

## [v2.1.3](https://github.com/tj-django/django-clone/tree/v2.1.3) (2021-03-25)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v2.1.0...v2.1.3)

## [v2.1.0](https://github.com/tj-django/django-clone/tree/v2.1.0) (2021-03-25)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v2.0.2...v2.1.0)

**Merged pull requests:**

- Increased test coverage. [\#244](https://github.com/tj-django/django-clone/pull/244) ([jackton1](https://github.com/jackton1))
- Updated docs [\#243](https://github.com/tj-django/django-clone/pull/243) ([github-actions[bot]](https://github.com/apps/github-actions))

## [v2.0.2](https://github.com/tj-django/django-clone/tree/v2.0.2) (2021-03-24)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v2.0.1...v2.0.2)

**Fixed bugs:**

- Fixed bug cloning unique slug fields. [\#242](https://github.com/tj-django/django-clone/pull/242) ([jackton1](https://github.com/jackton1))

**Merged pull requests:**

- Increased test coverage. [\#241](https://github.com/tj-django/django-clone/pull/241) ([jackton1](https://github.com/jackton1))
- Updated docs [\#240](https://github.com/tj-django/django-clone/pull/240) ([github-actions[bot]](https://github.com/apps/github-actions))

## [v2.0.1](https://github.com/tj-django/django-clone/tree/v2.0.1) (2021-03-24)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v2.0.0...v2.0.1)

**Merged pull requests:**

- Fixed typo. [\#239](https://github.com/tj-django/django-clone/pull/239) ([jackton1](https://github.com/jackton1))
- Updated docs [\#238](https://github.com/tj-django/django-clone/pull/238) ([github-actions[bot]](https://github.com/apps/github-actions))
- Updated docs [\#237](https://github.com/tj-django/django-clone/pull/237) ([github-actions[bot]](https://github.com/apps/github-actions))
- Update and rename update-readme.yml to update-doc-assets.yml [\#236](https://github.com/tj-django/django-clone/pull/236) ([jackton1](https://github.com/jackton1))
- Updated docs [\#235](https://github.com/tj-django/django-clone/pull/235) ([github-actions[bot]](https://github.com/apps/github-actions))
- Updated docs [\#234](https://github.com/tj-django/django-clone/pull/234) ([github-actions[bot]](https://github.com/apps/github-actions))

## [v2.0.0](https://github.com/tj-django/django-clone/tree/v2.0.0) (2021-03-20)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v1.1.10...v2.0.0)

**Implemented enhancements:**

- Update the clone link to include the model verbose name. [\#51](https://github.com/tj-django/django-clone/issues/51)

**Closed issues:**

- Action Required: Fix Renovate Configuration [\#214](https://github.com/tj-django/django-clone/issues/214)
- Initial Update [\#210](https://github.com/tj-django/django-clone/issues/210)
- Initial Update [\#208](https://github.com/tj-django/django-clone/issues/208)

**Merged pull requests:**

- Updated coverage config. [\#233](https://github.com/tj-django/django-clone/pull/233) ([jackton1](https://github.com/jackton1))
- Updated docs [\#232](https://github.com/tj-django/django-clone/pull/232) ([github-actions[bot]](https://github.com/apps/github-actions))
- Updated docs [\#230](https://github.com/tj-django/django-clone/pull/230) ([github-actions[bot]](https://github.com/apps/github-actions))
- Update README.md [\#229](https://github.com/tj-django/django-clone/pull/229) ([jackton1](https://github.com/jackton1))
- Update admin.py [\#228](https://github.com/tj-django/django-clone/pull/228) ([jackton1](https://github.com/jackton1))
- Added succinct field names. [\#226](https://github.com/tj-django/django-clone/pull/226) ([jackton1](https://github.com/jackton1))
- Update test.yml [\#225](https://github.com/tj-django/django-clone/pull/225) ([jackton1](https://github.com/jackton1))
- Update wearerequired/lint-action action to v1.9.0 [\#224](https://github.com/tj-django/django-clone/pull/224) ([renovate[bot]](https://github.com/apps/renovate))
- Bump rokroskar/workflow-run-cleanup-action from v0.3.0 to v0.3.2 [\#223](https://github.com/tj-django/django-clone/pull/223) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Update wearerequired/lint-action action to v1.8.0 [\#220](https://github.com/tj-django/django-clone/pull/220) ([renovate[bot]](https://github.com/apps/renovate))
- Updated docs [\#219](https://github.com/tj-django/django-clone/pull/219) ([github-actions[bot]](https://github.com/apps/github-actions))
- Updated docs [\#218](https://github.com/tj-django/django-clone/pull/218) ([github-actions[bot]](https://github.com/apps/github-actions))
- Updated docs [\#217](https://github.com/tj-django/django-clone/pull/217) ([github-actions[bot]](https://github.com/apps/github-actions))
- Update test.yml [\#215](https://github.com/tj-django/django-clone/pull/215) ([jackton1](https://github.com/jackton1))
- Bump rokroskar/workflow-run-cleanup-action from v0.2.2 to v0.3.0 [\#213](https://github.com/tj-django/django-clone/pull/213) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Update rokroskar/workflow-run-cleanup-action action to v0.3.0 [\#212](https://github.com/tj-django/django-clone/pull/212) ([renovate[bot]](https://github.com/apps/renovate))
- Update README.md [\#211](https://github.com/tj-django/django-clone/pull/211) ([jackton1](https://github.com/jackton1))
- Config file for pyup.io [\#209](https://github.com/tj-django/django-clone/pull/209) ([pyup-bot](https://github.com/pyup-bot))

## [v1.1.10](https://github.com/tj-django/django-clone/tree/v1.1.10) (2020-12-05)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v1.1.9...v1.1.10)

**Closed issues:**

- Update create\_copy\_of\_instance imports [\#202](https://github.com/tj-django/django-clone/issues/202)

**Merged pull requests:**

- Include python3.9 in the test matrix. [\#207](https://github.com/tj-django/django-clone/pull/207) ([jackton1](https://github.com/jackton1))
- Moved import of create\_copy\_of\_instance. [\#206](https://github.com/tj-django/django-clone/pull/206) ([jackton1](https://github.com/jackton1))

## [v1.1.9](https://github.com/tj-django/django-clone/tree/v1.1.9) (2020-11-29)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v1.1.8...v1.1.9)

**Implemented enhancements:**

- Remove circle CI integration [\#196](https://github.com/tj-django/django-clone/issues/196)

**Merged pull requests:**

- Update tox.ini [\#203](https://github.com/tj-django/django-clone/pull/203) ([jackton1](https://github.com/jackton1))
- Update README.md [\#201](https://github.com/tj-django/django-clone/pull/201) ([jackton1](https://github.com/jackton1))
- Delete config.yml [\#200](https://github.com/tj-django/django-clone/pull/200) ([jackton1](https://github.com/jackton1))
- Update README.md [\#199](https://github.com/tj-django/django-clone/pull/199) ([jackton1](https://github.com/jackton1))

## [v1.1.8](https://github.com/tj-django/django-clone/tree/v1.1.8) (2020-11-07)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v1.1.6...v1.1.8)

**Merged pull requests:**

- Fixed lint errors. [\#197](https://github.com/tj-django/django-clone/pull/197) ([jackton1](https://github.com/jackton1))
- Try to fix lint error for forks [\#195](https://github.com/tj-django/django-clone/pull/195) ([yuekui](https://github.com/yuekui))
- Update setup.py [\#194](https://github.com/tj-django/django-clone/pull/194) ([jackton1](https://github.com/jackton1))
- Update test.yml [\#192](https://github.com/tj-django/django-clone/pull/192) ([jackton1](https://github.com/jackton1))
- Add support for running workflow on forks [\#191](https://github.com/tj-django/django-clone/pull/191) ([jackton1](https://github.com/jackton1))
- Add support for related ManyToMany fields [\#190](https://github.com/tj-django/django-clone/pull/190) ([yuekui](https://github.com/yuekui))
- Update README.md [\#188](https://github.com/tj-django/django-clone/pull/188) ([jackton1](https://github.com/jackton1))
- Update clone.py [\#187](https://github.com/tj-django/django-clone/pull/187) ([jackton1](https://github.com/jackton1))

## [v1.1.6](https://github.com/tj-django/django-clone/tree/v1.1.6) (2020-09-07)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v1.1.5...v1.1.6)

## [v1.1.5](https://github.com/tj-django/django-clone/tree/v1.1.5) (2020-09-07)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v1.1.4...v1.1.5)

## [v1.1.4](https://github.com/tj-django/django-clone/tree/v1.1.4) (2020-09-07)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v1.1.3...v1.1.4)

## [v1.1.3](https://github.com/tj-django/django-clone/tree/v1.1.3) (2020-09-07)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v1.1.2...v1.1.3)

## [v1.1.2](https://github.com/tj-django/django-clone/tree/v1.1.2) (2020-09-07)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v1.1.1...v1.1.2)

## [v1.1.1](https://github.com/tj-django/django-clone/tree/v1.1.1) (2020-09-07)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v1.1.0...v1.1.1)

## [v1.1.0](https://github.com/tj-django/django-clone/tree/v1.1.0) (2020-09-07)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v1.0.0...v1.1.0)

**Fixed bugs:**

- Resolve bug with Clone Meta class [\#185](https://github.com/tj-django/django-clone/pull/185) ([jackton1](https://github.com/jackton1))

**Closed issues:**

- Implicit declaration of ManyToManyField, auto\_created is of type "CloneMetaClass" [\#184](https://github.com/tj-django/django-clone/issues/184)
- Add the MANIFEST.in [\#62](https://github.com/tj-django/django-clone/issues/62)

**Merged pull requests:**

- Update README.md [\#183](https://github.com/tj-django/django-clone/pull/183) ([jackton1](https://github.com/jackton1))
- Update dependency six to v1.15.0 [\#81](https://github.com/tj-django/django-clone/pull/81) ([renovate[bot]](https://github.com/apps/renovate))
- Update dependency pip-tools to v5.3.1 [\#80](https://github.com/tj-django/django-clone/pull/80) ([renovate[bot]](https://github.com/apps/renovate))

## [v1.0.0](https://github.com/tj-django/django-clone/tree/v1.0.0) (2020-09-05)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v0.2.0...v1.0.0)

**Merged pull requests:**

- Create test.yml [\#182](https://github.com/tj-django/django-clone/pull/182) ([jackton1](https://github.com/jackton1))
- docs: add yuekui as a contributor [\#181](https://github.com/tj-django/django-clone/pull/181) ([allcontributors[bot]](https://github.com/apps/allcontributors))
- Updated to test django3.1 [\#180](https://github.com/tj-django/django-clone/pull/180) ([jackton1](https://github.com/jackton1))
- Update setup.py module [\#179](https://github.com/tj-django/django-clone/pull/179) ([jackton1](https://github.com/jackton1))
- Fix invalid enum field value for unique\_together fields [\#178](https://github.com/tj-django/django-clone/pull/178) ([yuekui](https://github.com/yuekui))
- docs: add renovate-bot as a contributor [\#177](https://github.com/tj-django/django-clone/pull/177) ([allcontributors[bot]](https://github.com/apps/allcontributors))
- chore\(deps\): update dependency twine to v3 [\#173](https://github.com/tj-django/django-clone/pull/173) ([renovate[bot]](https://github.com/apps/renovate))
- Updated classifiers to Production/Stable [\#108](https://github.com/tj-django/django-clone/pull/108) ([jackton1](https://github.com/jackton1))
- Update dependency git-changelog to v0.4.0 [\#78](https://github.com/tj-django/django-clone/pull/78) ([renovate[bot]](https://github.com/apps/renovate))

## [v0.2.0](https://github.com/tj-django/django-clone/tree/v0.2.0) (2020-06-04)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v0.1.6...v0.2.0)

## [v0.1.6](https://github.com/tj-django/django-clone/tree/v0.1.6) (2020-06-04)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v0.1.5...v0.1.6)

**Closed issues:**

- 'CloneMixin' has no attribute '\_meta' [\#58](https://github.com/tj-django/django-clone/issues/58)

**Merged pull requests:**

- Update admin.py [\#90](https://github.com/tj-django/django-clone/pull/90) ([jackton1](https://github.com/jackton1))
- Update README.md [\#89](https://github.com/tj-django/django-clone/pull/89) ([jackton1](https://github.com/jackton1))
- Update dependency bump2version to v1 [\#85](https://github.com/tj-django/django-clone/pull/85) ([renovate[bot]](https://github.com/apps/renovate))
- Update dependency isort to v4.3.21 [\#79](https://github.com/tj-django/django-clone/pull/79) ([renovate[bot]](https://github.com/apps/renovate))
- Update dependency future to v0.18.2 [\#77](https://github.com/tj-django/django-clone/pull/77) ([renovate[bot]](https://github.com/apps/renovate))
- Configure Renovate [\#73](https://github.com/tj-django/django-clone/pull/73) ([renovate[bot]](https://github.com/apps/renovate))
- Update README.md [\#72](https://github.com/tj-django/django-clone/pull/72) ([jackton1](https://github.com/jackton1))
- Replicate model errors [\#71](https://github.com/tj-django/django-clone/pull/71) ([jackton1](https://github.com/jackton1))
- Remove the information for updating INSTALLED\_APPS [\#70](https://github.com/tj-django/django-clone/pull/70) ([jackton1](https://github.com/jackton1))

## [v0.1.5](https://github.com/tj-django/django-clone/tree/v0.1.5) (2020-05-12)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v0.1.4...v0.1.5)

## [v0.1.4](https://github.com/tj-django/django-clone/tree/v0.1.4) (2020-05-12)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v0.1.3...v0.1.4)

**Closed issues:**

- Document support for Django3+ [\#64](https://github.com/tj-django/django-clone/issues/64)
- Improve README.md [\#63](https://github.com/tj-django/django-clone/issues/63)

**Merged pull requests:**

- Updated to include python3.8 test. [\#69](https://github.com/tj-django/django-clone/pull/69) ([jackton1](https://github.com/jackton1))
- Merge pull request \#67 from jackton1/master [\#68](https://github.com/tj-django/django-clone/pull/68) ([jackton1](https://github.com/jackton1))
- Master to develop [\#67](https://github.com/tj-django/django-clone/pull/67) ([jackton1](https://github.com/jackton1))
- Develop [\#66](https://github.com/tj-django/django-clone/pull/66) ([jackton1](https://github.com/jackton1))

## [v0.1.3](https://github.com/tj-django/django-clone/tree/v0.1.3) (2020-04-16)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v0.1.2...v0.1.3)

**Closed issues:**

- Create a new git repo [\#56](https://github.com/tj-django/django-clone/issues/56)

**Merged pull requests:**

- Update test and documentation to include Django3.0 support. [\#65](https://github.com/tj-django/django-clone/pull/65) ([jackton1](https://github.com/jackton1))
- Updated the example to use the clonable model above. [\#61](https://github.com/tj-django/django-clone/pull/61) ([jackton1](https://github.com/jackton1))
- Update README.md [\#59](https://github.com/tj-django/django-clone/pull/59) ([jackton1](https://github.com/jackton1))
- Fixed typo [\#54](https://github.com/tj-django/django-clone/pull/54) ([jackton1](https://github.com/jackton1))
- Fixed example documentation. [\#53](https://github.com/tj-django/django-clone/pull/53) ([jackton1](https://github.com/jackton1))
- Update README.md [\#50](https://github.com/tj-django/django-clone/pull/50) ([jackton1](https://github.com/jackton1))
- Update README.md [\#49](https://github.com/tj-django/django-clone/pull/49) ([jackton1](https://github.com/jackton1))
- Update README.md [\#48](https://github.com/tj-django/django-clone/pull/48) ([jackton1](https://github.com/jackton1))
- Updated .set passing the instance instead of pk. [\#47](https://github.com/tj-django/django-clone/pull/47) ([jackton1](https://github.com/jackton1))
- docs: add SebastianKapunkt as a contributor [\#46](https://github.com/tj-django/django-clone/pull/46) ([allcontributors[bot]](https://github.com/apps/allcontributors))
- Removed unused line [\#45](https://github.com/tj-django/django-clone/pull/45) ([jackton1](https://github.com/jackton1))
- Reordered badges [\#44](https://github.com/tj-django/django-clone/pull/44) ([jackton1](https://github.com/jackton1))
- Updated the .circle config. [\#43](https://github.com/tj-django/django-clone/pull/43) ([jackton1](https://github.com/jackton1))
- Actually clone clone\_many\_to\_one fields not only transfer them [\#42](https://github.com/tj-django/django-clone/pull/42) ([SebastianKapunkt](https://github.com/SebastianKapunkt))
- Feature/add spec for cloning in parallel. [\#37](https://github.com/tj-django/django-clone/pull/37) ([jackton1](https://github.com/jackton1))

## [v0.1.2](https://github.com/tj-django/django-clone/tree/v0.1.2) (2019-12-03)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v0.1.1...v0.1.2)

**Closed issues:**

- :bug: wheel does not include templates [\#38](https://github.com/tj-django/django-clone/issues/38)

**Merged pull requests:**

- Fixed indentation. [\#40](https://github.com/tj-django/django-clone/pull/40) ([jackton1](https://github.com/jackton1))
- Added PyPi badge. [\#39](https://github.com/tj-django/django-clone/pull/39) ([jackton1](https://github.com/jackton1))

## [v0.1.1](https://github.com/tj-django/django-clone/tree/v0.1.1) (2019-12-02)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v0.1.0...v0.1.1)

**Implemented enhancements:**

- Fix bug with cloning unique fields and added support for bulk\_clone. [\#33](https://github.com/tj-django/django-clone/pull/33) ([jackton1](https://github.com/jackton1))

**Merged pull requests:**

- Updated MANIFEST.in to include model\_clone templates. [\#41](https://github.com/tj-django/django-clone/pull/41) ([jackton1](https://github.com/jackton1))
- Cleaned up the sample app. [\#36](https://github.com/tj-django/django-clone/pull/36) ([jackton1](https://github.com/jackton1))
- Update README.md [\#35](https://github.com/tj-django/django-clone/pull/35) ([jackton1](https://github.com/jackton1))
- Update README.md [\#34](https://github.com/tj-django/django-clone/pull/34) ([jackton1](https://github.com/jackton1))
- Fix typo cloneModelAdmin -\> CloneModelAdmin [\#32](https://github.com/tj-django/django-clone/pull/32) ([SebastianKapunkt](https://github.com/SebastianKapunkt))
- Handle case when value in unquie field has fields max\_length [\#31](https://github.com/tj-django/django-clone/pull/31) ([SebastianKapunkt](https://github.com/SebastianKapunkt))
- Update README.md [\#30](https://github.com/tj-django/django-clone/pull/30) ([jackton1](https://github.com/jackton1))
- Feature/update test and rename clonable to clone [\#29](https://github.com/tj-django/django-clone/pull/29) ([jackton1](https://github.com/jackton1))
- Update README.md [\#28](https://github.com/tj-django/django-clone/pull/28) ([jackton1](https://github.com/jackton1))
- Increased test coverage and renamed clonable -\> clone. [\#19](https://github.com/tj-django/django-clone/pull/19) ([jackton1](https://github.com/jackton1))

## [v0.1.0](https://github.com/tj-django/django-clone/tree/v0.1.0) (2019-11-23)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v0.0.11...v0.1.0)

## [v0.0.11](https://github.com/tj-django/django-clone/tree/v0.0.11) (2019-11-23)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v0.0.10...v0.0.11)

**Implemented enhancements:**

- Increase test coverage.  [\#2](https://github.com/tj-django/django-clone/issues/2)

**Fixed bugs:**

- Fix python2.7 test using circle CI's docker image. [\#1](https://github.com/tj-django/django-clone/issues/1)

**Closed issues:**

- Bug when installing version above 0.0.3 [\#18](https://github.com/tj-django/django-clone/issues/18)

**Merged pull requests:**

- Update README.md inlcuded snyk tag. [\#27](https://github.com/tj-django/django-clone/pull/27) ([jackton1](https://github.com/jackton1))
- Updated to use excluded fields. [\#23](https://github.com/tj-django/django-clone/pull/23) ([jackton1](https://github.com/jackton1))
- Updated the .gitignore. [\#22](https://github.com/tj-django/django-clone/pull/22) ([jackton1](https://github.com/jackton1))
- Updated CI and fix tox test. [\#21](https://github.com/tj-django/django-clone/pull/21) ([jackton1](https://github.com/jackton1))
- Update README.md [\#20](https://github.com/tj-django/django-clone/pull/20) ([jackton1](https://github.com/jackton1))

## [v0.0.10](https://github.com/tj-django/django-clone/tree/v0.0.10) (2019-11-12)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v0.0.9...v0.0.10)

**Merged pull requests:**

- Updated .circleci config. [\#17](https://github.com/tj-django/django-clone/pull/17) ([jackton1](https://github.com/jackton1))

## [v0.0.9](https://github.com/tj-django/django-clone/tree/v0.0.9) (2019-11-10)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v0.0.8...v0.0.9)

## [v0.0.8](https://github.com/tj-django/django-clone/tree/v0.0.8) (2019-11-10)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v0.0.7...v0.0.8)

## [v0.0.7](https://github.com/tj-django/django-clone/tree/v0.0.7) (2019-11-10)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v0.0.6...v0.0.7)

## [v0.0.6](https://github.com/tj-django/django-clone/tree/v0.0.6) (2019-11-10)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v0.0.5...v0.0.6)

## [v0.0.5](https://github.com/tj-django/django-clone/tree/v0.0.5) (2019-11-10)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v0.0.3...v0.0.5)

## [v0.0.3](https://github.com/tj-django/django-clone/tree/v0.0.3) (2019-11-10)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v0.0.2...v0.0.3)

**Closed issues:**

- @all-contributors please add @jakebolam for infrastructure, tests and code [\#11](https://github.com/tj-django/django-clone/issues/11)
- Doesn't duplicate with custom `id` [\#9](https://github.com/tj-django/django-clone/issues/9)

**Merged pull requests:**

- Update issue templates [\#16](https://github.com/tj-django/django-clone/pull/16) ([jackton1](https://github.com/jackton1))
- docs: add andresp99999 as a contributor [\#15](https://github.com/tj-django/django-clone/pull/15) ([allcontributors[bot]](https://github.com/apps/allcontributors))
- Add class variable USE\_UNIQUE\_DUPLICATE\_SUFFIX [\#14](https://github.com/tj-django/django-clone/pull/14) ([andresp99999](https://github.com/andresp99999))
- docs: add SebastianKapunkt as a contributor [\#13](https://github.com/tj-django/django-clone/pull/13) ([allcontributors[bot]](https://github.com/apps/allcontributors))
- docs: add gerbyzation as a contributor [\#12](https://github.com/tj-django/django-clone/pull/12) ([allcontributors[bot]](https://github.com/apps/allcontributors))
- filter pk field from concrete\_fields [\#10](https://github.com/tj-django/django-clone/pull/10) ([gerbyzation](https://github.com/gerbyzation))
- Added create\_copy\_of\_instance utility. [\#8](https://github.com/tj-django/django-clone/pull/8) ([jackton1](https://github.com/jackton1))
- Feature/move to including the duplicate action and duplicate object tools [\#7](https://github.com/tj-django/django-clone/pull/7) ([jackton1](https://github.com/jackton1))
- Admin button [\#6](https://github.com/tj-django/django-clone/pull/6) ([SebastianKapunkt](https://github.com/SebastianKapunkt))
- Fix clone of one to many and many to one [\#5](https://github.com/tj-django/django-clone/pull/5) ([SebastianKapunkt](https://github.com/SebastianKapunkt))
- Updated example [\#3](https://github.com/tj-django/django-clone/pull/3) ([jackton1](https://github.com/jackton1))

## [v0.0.2](https://github.com/tj-django/django-clone/tree/v0.0.2) (2019-04-07)

[Full Changelog](https://github.com/tj-django/django-clone/compare/v0.0.1...v0.0.2)

## [v0.0.1](https://github.com/tj-django/django-clone/tree/v0.0.1) (2019-04-06)

[Full Changelog](https://github.com/tj-django/django-clone/compare/7b01ca1df72d4ac2a691257807cf9eab426332ae...v0.0.1)



\* *This Changelog was automatically generated by [github_changelog_generator](https://github.com/github-changelog-generator/github-changelog-generator)*
