#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['scirpy',
 'scirpy._plotting',
 'scirpy._preprocessing',
 'scirpy._tools',
 'scirpy.datasets',
 'scirpy.io',
 'scirpy.io._tracerlib',
 'scirpy.tcr_dist',
 'scirpy.util']

package_data = \
{'': ['*'], 'scirpy.datasets': ['_processing_scripts/*']}

install_requires = \
['get_version',
 'anndata>=0.7.3',
 'scanpy>=1.5.1',
 'pandas>=0.21',
 'numpy',
 'scipy',
 'parasail',
 'scikit-learn',
 'python-levenshtein',
 'python-igraph',
 'networkx',
 'squarify',
 'airr',
 'tqdm>=4.29.1']

extras_require = \
{'doc': ['sphinx>=3.0.1',
         'sphinx_autodoc_typehints>=1.8.0',
         'sphinx_rtd_theme>=0.4',
         'scanpydoc>=0.4.5',
         'leidenalg',
         'nbsphinx>=0.6.0',
         'jupytext',
         'sphinxcontrib-bibtex>=1.0.0',
         'pycairo',
         'jupyter_client',
         'ipykernel'],
 'doc:python_version < "3.8"': ['typing_extensions'],
 'optional': ['rectangle-packer'],
 'test': ['pytest', 'black']}

setup(name='scirpy',
      version='0.3',
      description='Python library for single-cell TCR analysis',
      author='Gregor Sturm',
      author_email='gregor.sturm@i-med.ac.at',
      url='https://github.com/grst/scirpy',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      python_requires='>= 3.6',
     )
