"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.stripBeginAndEndQuotes = exports.decodeBase64String = void 0;
/**
 * Decodes the given string from base64 into UTF-8.
 * @param encodedString base64 encoded string
 * @returns UTF-8 representation of the string.
 */
function decodeBase64String(encodedString) {
    if (encodedString === null || encodedString === undefined) {
        return null;
    }
    return Buffer.from(encodedString, 'base64').toString('utf-8');
}
exports.decodeBase64String = decodeBase64String;
/**
 * Remove beginning and end quotes from the given sting.
 * @param input string to strip
 * @returns input without the start or end quote if they existed.
 */
function stripBeginAndEndQuotes(input) {
    if (input === null || input === undefined) {
        return null;
    }
    return input.replace(/^\"|\"$/g, '');
}
exports.stripBeginAndEndQuotes = stripBeginAndEndQuotes;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGF0YS11dGlscy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy91dGlscy9kYXRhLXV0aWxzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBOzs7O0dBSUc7QUFDSCxTQUFnQixrQkFBa0IsQ0FBQyxhQUFxQjtJQUN0RCxJQUFJLGFBQWEsS0FBSyxJQUFJLElBQUksYUFBYSxLQUFLLFNBQVMsRUFBRTtRQUFFLE9BQU8sSUFBSSxDQUFDO0tBQUU7SUFDM0UsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLGFBQWEsRUFBRSxRQUFRLENBQUMsQ0FBQyxRQUFRLENBQUMsT0FBTyxDQUFDLENBQUM7QUFDaEUsQ0FBQztBQUhELGdEQUdDO0FBRUQ7Ozs7R0FJRztBQUNILFNBQWdCLHNCQUFzQixDQUFDLEtBQWE7SUFDbEQsSUFBSSxLQUFLLEtBQUssSUFBSSxJQUFJLEtBQUssS0FBSyxTQUFTLEVBQUU7UUFBRSxPQUFPLElBQUksQ0FBQztLQUFFO0lBQzNELE9BQU8sS0FBSyxDQUFDLE9BQU8sQ0FBQyxVQUFVLEVBQUUsRUFBRSxDQUFDLENBQUM7QUFDdkMsQ0FBQztBQUhELHdEQUdDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBEZWNvZGVzIHRoZSBnaXZlbiBzdHJpbmcgZnJvbSBiYXNlNjQgaW50byBVVEYtOC5cbiAqIEBwYXJhbSBlbmNvZGVkU3RyaW5nIGJhc2U2NCBlbmNvZGVkIHN0cmluZ1xuICogQHJldHVybnMgVVRGLTggcmVwcmVzZW50YXRpb24gb2YgdGhlIHN0cmluZy5cbiAqL1xuZXhwb3J0IGZ1bmN0aW9uIGRlY29kZUJhc2U2NFN0cmluZyhlbmNvZGVkU3RyaW5nOiBzdHJpbmcpOiBzdHJpbmcgfCBudWxsIHtcbiAgaWYgKGVuY29kZWRTdHJpbmcgPT09IG51bGwgfHwgZW5jb2RlZFN0cmluZyA9PT0gdW5kZWZpbmVkKSB7IHJldHVybiBudWxsOyB9XG4gIHJldHVybiBCdWZmZXIuZnJvbShlbmNvZGVkU3RyaW5nLCAnYmFzZTY0JykudG9TdHJpbmcoJ3V0Zi04Jyk7XG59XG5cbi8qKlxuICogUmVtb3ZlIGJlZ2lubmluZyBhbmQgZW5kIHF1b3RlcyBmcm9tIHRoZSBnaXZlbiBzdGluZy5cbiAqIEBwYXJhbSBpbnB1dCBzdHJpbmcgdG8gc3RyaXBcbiAqIEByZXR1cm5zIGlucHV0IHdpdGhvdXQgdGhlIHN0YXJ0IG9yIGVuZCBxdW90ZSBpZiB0aGV5IGV4aXN0ZWQuXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiBzdHJpcEJlZ2luQW5kRW5kUXVvdGVzKGlucHV0OiBzdHJpbmcpOiBzdHJpbmcgfCBudWxsIHtcbiAgaWYgKGlucHV0ID09PSBudWxsIHx8IGlucHV0ID09PSB1bmRlZmluZWQpIHsgcmV0dXJuIG51bGw7IH1cbiAgcmV0dXJuIGlucHV0LnJlcGxhY2UoL15cXFwifFxcXCIkL2csICcnKTtcbn0iXX0=