import { Platform } from '../domain/platform';
import { SimulationResult } from '../domain/simulation-result';
import { IEnvironment } from '../interface/environment';
import { CommandStep } from '../parent-steps/command-step';
import { CommandSimulationProps } from './simulation';
/**
 * The same interface as CommandSimulationProps but all fields are required.
 */
export interface RequiredCommandSimulationProps {
    readonly environment: IEnvironment;
    readonly simulationPlatform: Platform;
}
export declare class CommandStepSimulation {
    readonly step: CommandStep;
    readonly props: RequiredCommandSimulationProps;
    constructor(step: CommandStep, props: CommandSimulationProps);
    /**
     * Invokes the current step on the input and will return a SimulationResult.
     * @param inputs must contain all of the inputs declared by the current step.
     * @returns a SimulationResult with the step outputs in the case of success or stacktrace in the case of failure.
     */
    invoke(inputs: {
        [name: string]: any;
    }): SimulationResult;
    /**
     * If fallback/retries are specified for this step, the retry or skip logic is handled in this function.
     */
    private invokeWithFallback;
    private runFinally;
    private formatResult;
    /**
     * This function receives all of the available inputs and returns the subset of inputs that were requested.
     * If any input requested in the current step is not available in the received inputs, this will throw.
     * @param inputs all available inputs for the currently executing step
     * @returns the subset of inputs which are requested by the current step
     */
    private filterInputs;
    /**
     * Adds this step name to the list of executed steps.
     * Since the steps are invoked as a chain, the current step is prepended as invocation stack is popped.
     */
    protected prependSelf(futureSteps: string[]): string[];
    private tryExecute;
    private shouldExecuteStep;
    private mySimulation;
}
