"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RunCommandSimulation = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const automation_simulation_base_1 = require("./automation-simulation-base");
/**
 * AutomationStep implementation of [aws:runCommand](https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-runcommand.html)
 */
class RunCommandSimulation extends automation_simulation_base_1.AutomationSimulationBase {
    constructor(step, props) {
        super(step);
        this.action = 'aws:runCommand';
        this.runCommandStep = step;
        this.props = props;
    }
    /**
       * May perform a real approval ask based on the params used during instance creation.
       */
    executeStep(inputs) {
        const props = {
            documentName: this.runCommandStep.documentName?.resolve(inputs),
            targets: this.runCommandStep.targets?.resolve(inputs),
            parameters: this.runCommandStep.parameters?.resolve(inputs),
            cloudWatchOutputConfig: this.runCommandStep.cloudWatchOutputConfig?.resolve(inputs),
            comment: this.runCommandStep.comment?.resolve(inputs),
            documentHash: this.runCommandStep.documentHash?.resolve(inputs),
            documentHashType: this.runCommandStep.documentHashType?.resolve(inputs),
            notificationConfig: this.runCommandStep.notificationConfig?.resolve(inputs),
            outputS3BucketName: this.runCommandStep.outputS3BucketName?.resolve(inputs),
            outputS3KeyPrefix: this.runCommandStep.outputS3KeyPrefix?.resolve(inputs),
            serviceRoleArn: this.runCommandStep.serviceRoleArn?.resolve(inputs),
            timeoutSeconds: this.runCommandStep.commandTimeoutSeconds?.resolve(inputs),
            maxConcurrency: this.runCommandStep.maxConcurrency?.resolve(inputs),
            maxErrors: this.runCommandStep.maxErrors?.resolve(inputs),
        };
        console.log('RunCommand: Executing run command hook');
        const result = this.props.runCommandHook.execute(props);
        console.log('RunCommand: Finished executing hook');
        return {
            CommandId: result.commandId,
            Status: result.status,
            ResponseCode: result.responseCode ?? null,
            Output: result.output ?? null,
        };
    }
}
exports.RunCommandSimulation = RunCommandSimulation;
_a = JSII_RTTI_SYMBOL_1;
RunCommandSimulation[_a] = { fqn: "@cdklabs/cdk-ssm-documents.RunCommandSimulation", version: "0.0.28" };
//# sourceMappingURL=data:application/json;base64,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