"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PythonScriptHandler = void 0;
const synchronous_promise_1 = require("../sync/synchronous-promise");
/**
 * Perform Python script evaluation.
 * Function returns the value received from the python invocation synchronously nested inside "Payload".
 * This class will not work if python is not available in the environment that this code is running in.
 */
class PythonScriptHandler {
    /**
       * Runs the python function specified by the input argument.
       * The python result will be nested inside a "Payload" object as is done by SSM.
       * Another json entry is appended to the root object called "status".
       * If the value of the json "status" key is "FAILURE", this function throws the result of Payload.
       * @param path to the python code
       * @param handler function to execute in the python code
       * @param params function parameters to send to handler
       * @returns python function response
       * @example {Payload: {"MyOutput": "MyValue"}, "Status": "SUCCESS"}
       */
    run(path, handler, params) {
        const pyResult = new synchronous_promise_1.SynchronousPromise().wait('../../lib/sync/python-async-runner', 'PythonAsyncRunner', [path, handler, params]);
        // results from python function is wrapped in object containing status and Payload
        if (pyResult.status == 'FAILURE') {
            console.error(`Exception occurred calling python function ${path}.${handler}\n${pyResult.Payload}`);
            throw new Error(pyResult.Payload);
        }
        return pyResult;
    }
}
exports.PythonScriptHandler = PythonScriptHandler;
//# sourceMappingURL=data:application/json;base64,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