"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimedDocument = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const __1 = require("../..");
const automation_document_1 = require("../../document/automation-document");
class TimedDocument extends automation_document_1.AutomationDocument {
    constructor(stage, id, props) {
        super(stage, id, props);
    }
    collectedSteps() {
        const middleSteps = super.collectedSteps();
        // If this is called a second time during synthesis then the newly created objects are inserted into the tree.
        // So first ensure that these aren't already added
        if (middleSteps.find(s => s.name == 'RecordStartTime')) {
            return middleSteps;
        }
        const recordStartTime = new __1.ExecuteScriptStep(this, 'RecordStartTime', {
            code: __1.ScriptCode.inline('from datetime import datetime, timezone\n\n' +
                'def script_handler(params: dict, context):\n' +
                '    return datetime.now(timezone.utc).isoformat()\n\n'),
            language: __1.ScriptLanguage.python(__1.PythonVersion.VERSION_3_6, 'script_handler'),
            outputs: [{ outputType: __1.DataTypeEnum.STRING, name: 'StartTime', selector: '$.Payload' }],
            inputPayload: {},
        });
        const outputRecoveryTime = new __1.ExecuteScriptStep(this, 'OutputRecoveryTime', {
            code: __1.ScriptCode.inline('from datetime import datetime, timezone\n' +
                'from dateutil import parser\n\n' +
                'def script_handler(params: dict, context):\n' +
                '    return (datetime.now(timezone.utc) - parser.parse(params[\'startTime\'])).seconds\n\n'),
            language: __1.ScriptLanguage.python(__1.PythonVersion.VERSION_3_6, 'script_handler'),
            outputs: [{ outputType: __1.DataTypeEnum.INTEGER, name: 'RecoveryTime', selector: '$.Payload' }],
            inputPayload: { startTime: __1.StringVariable.of('RecordStartTime.StartTime') },
        });
        this.builder.steps.unshift(recordStartTime);
        this.builder.steps.push(outputRecoveryTime);
        return this.builder.steps;
    }
}
exports.TimedDocument = TimedDocument;
_a = JSII_RTTI_SYMBOL_1;
TimedDocument[_a] = { fqn: "@cdklabs/cdk-ssm-documents.TimedDocument", version: "0.0.28" };
//# sourceMappingURL=data:application/json;base64,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