"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WaitForInstanceRunning = void 0;
const composite_step_1 = require("./composite-step");
const wait_for_and_assert_resource_1 = require("./wait-for-and-assert-resource");
/**
 * Waits for EC2 instance(s) to be no longer pending and asserts that the status is running.
 */
class WaitForInstanceRunning extends composite_step_1.CompositeAutomationStep {
    constructor(scope, id, props) {
        super(scope, id);
        const stepParams = {
            service: 'EC2',
            pascalCaseApi: 'DescribeInstanceStatus',
            apiParams: {
                InstanceIds: props.instanceIds,
                IncludeAllInstances: true,
            },
            awsInvoker: props.awsInvoker,
            selector: '$.InstanceStatuses..InstanceState.Name',
            waitForValues: ['running', 'shutting-down', 'terminated', 'stopping', 'stopped'],
            desiredValues: ['running'],
        };
        this.component = new wait_for_and_assert_resource_1.WaitForAndAssertResource(this, 'waitForInstanceRunning', stepParams);
    }
    addToDocument(doc) {
        this.component.addToDocument(doc);
    }
}
exports.WaitForInstanceRunning = WaitForInstanceRunning;
//# sourceMappingURL=data:application/json;base64,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