import { Construct } from 'constructs';
import { IActionVariable } from '../../domain/enum/install-action';
import { Platform } from '../../domain/platform';
import { CommandStep, CommandStepProps } from '../command-step';
/**
 * Properties for ConfigureDocker step
 */
export interface ConfigureDockerStepProps extends CommandStepProps {
    /**
     * The type of action to perform. True correlates to "Install" false correlates to "Uninstall"
     */
    readonly action: IActionVariable;
}
/**
 * AutomationStep implemenation for aws:UpdateAgent
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-plugins.html#aws-configuredocker
 */
export declare class ConfigureDockerStep extends CommandStep {
    readonly installAction: IActionVariable;
    readonly platforms: Platform[];
    readonly action = "aws:configureDocker";
    constructor(scope: Construct, id: string, props: ConfigureDockerStepProps);
    /**
     * Inputs required for this command include agentName allowDowngrade source and targetVersion if version other than latest is desired
     */
    listInputs(): string[];
    toSsmEntry(): {
        [name: string]: any;
    };
}
