"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvokeWebhookStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const data_type_1 = require("../../domain/data-type");
const prune_and_transform_record_1 = require("../../utils/prune-and-transform-record");
const automation_step_1 = require("../automation-step");
/**
 * AutomationStep implementation for [aws:invokeWebhook](https://docs.aws.amazon.com/systems-manager/latest/userguide/invoke-webhook.html)
 */
class InvokeWebhookStep extends automation_step_1.AutomationStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.action = 'aws:invokeWebhook';
        this.integrationName = props.integrationName;
        this.body = props.body;
    }
    listOutputs() {
        return [{
                outputType: data_type_1.DataTypeEnum.STRING,
                selector: '$.Response',
                name: 'Response',
            }, {
                outputType: data_type_1.DataTypeEnum.INTEGER,
                selector: '$.ResponseCode',
                name: 'ResponseCode',
            }];
    }
    listInputs() {
        const inputs = [
            this.integrationName,
            this.body,
        ];
        return inputs.flatMap(i => i?.requiredInputs() ?? []);
    }
    toSsmEntry() {
        return super.prepareSsmEntry(prune_and_transform_record_1.pruneAndTransformRecord({
            IntegrationName: this.integrationName,
            Body: this.body,
        }, x => x.print()));
    }
}
exports.InvokeWebhookStep = InvokeWebhookStep;
_a = JSII_RTTI_SYMBOL_1;
InvokeWebhookStep[_a] = { fqn: "@cdklabs/cdk-ssm-documents.InvokeWebhookStep", version: "0.0.28" };
//# sourceMappingURL=data:application/json;base64,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