"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExecuteAutomationStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const data_type_1 = require("../../domain/data-type");
const automation_step_1 = require("../automation-step");
/**
 * AutomationStep implementation for aws:executeAutomation
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-executeAutomation.html
 */
class ExecuteAutomationStep extends automation_step_1.AutomationStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.action = 'aws:executeAutomation';
        this.documentName = props.documentName;
        this.documentVersion = props.documentVersion;
        this.maxConcurrency = props.maxConcurrency;
        this.maxErrors = props.maxErrors;
        this.runtimeParameters = props.runtimeParameters;
        this.tags = props.tags;
        this.targetLocations = props.targetLocations;
        this.targetMaps = props.targetMaps;
        this.targetParameterName = props.targetParameterName;
        this.targets = props.targets;
    }
    listInputs() {
        const inputs = [
            this.documentName,
            this.documentVersion,
            this.maxConcurrency,
            this.maxErrors,
            this.runtimeParameters,
            this.tags,
            this.targetLocations,
            this.targetMaps,
            this.targetParameterName,
            this.targets,
        ];
        return inputs.flatMap(i => i?.requiredInputs() ?? []);
    }
    listOutputs() {
        return [{
                outputType: data_type_1.DataTypeEnum.STRING_LIST,
                name: 'Output',
                selector: '$.Output',
            },
            {
                outputType: data_type_1.DataTypeEnum.STRING,
                name: 'ExecutionId',
                selector: '$.ExecutionId',
            },
            {
                outputType: data_type_1.DataTypeEnum.STRING,
                name: 'Status',
                selector: '$.Status',
            }];
    }
    toSsmEntry() {
        const inputs = {
            DocumentName: this.documentName,
        };
        if (this.documentVersion != undefined) {
            inputs.DocumentVersion = this.documentVersion;
        }
        if (this.maxConcurrency != undefined) {
            inputs.MaxConcurrency = this.maxConcurrency;
        }
        if (this.maxErrors != undefined) {
            inputs.MaxErrors = this.maxErrors;
        }
        if (this.runtimeParameters != undefined) {
            inputs.RuntimeParameters = this.runtimeParameters;
        }
        if (this.tags != undefined) {
            inputs.Tags = this.tags;
        }
        if (this.targetLocations != undefined) {
            inputs.TargetLocations = this.targetLocations;
        }
        if (this.targetMaps != undefined) {
            inputs.TargetMaps = this.targetMaps;
        }
        if (this.targetParameterName != undefined) {
            inputs.TargetParameterName = this.targetParameterName;
        }
        if (this.targets != undefined) {
            inputs.Targets = this.targets;
        }
        const entireEntry = super.prepareSsmEntry(inputs);
        const { outputs, ...newObj } = entireEntry;
        return newObj;
    }
}
exports.ExecuteAutomationStep = ExecuteAutomationStep;
_a = JSII_RTTI_SYMBOL_1;
ExecuteAutomationStep[_a] = { fqn: "@cdklabs/cdk-ssm-documents.ExecuteAutomationStep", version: "0.0.28" };
//# sourceMappingURL=data:application/json;base64,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