"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.isBoolean = exports.assertBoolean = exports.BooleanVariable = exports.HardCodedBoolean = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const variable_1 = require("./variable");
/**
 * A hard-coded boolean variable.
 * Used when not dependent on step inputs.
 */
class HardCodedBoolean extends variable_1.HardCodedValueBase {
    resolveToBoolean(inputs) {
        return this.resolve(inputs);
    }
    assertType(value) {
        assertBoolean(value);
    }
}
exports.HardCodedBoolean = HardCodedBoolean;
_a = JSII_RTTI_SYMBOL_1;
HardCodedBoolean[_a] = { fqn: "@cdklabs/cdk-ssm-documents.HardCodedBoolean", version: "0.0.28" };
HardCodedBoolean.TRUE = new HardCodedBoolean(true);
HardCodedBoolean.FALSE = new HardCodedBoolean(false);
/**
 * A boolean variable reference.
 * Used to resolve the value from step inputs.
 */
class BooleanVariable extends variable_1.GenericVariable {
    static of(reference) {
        return new BooleanVariable(reference);
    }
    resolveToBoolean(inputs) {
        return this.resolve(inputs);
    }
    assertType(value) {
        assertBoolean(value);
    }
}
exports.BooleanVariable = BooleanVariable;
_b = JSII_RTTI_SYMBOL_1;
BooleanVariable[_b] = { fqn: "@cdklabs/cdk-ssm-documents.BooleanVariable", version: "0.0.28" };
/**
 * Assert that the given value is a NullableBoolean.
 * @param value value to assert
 */
function assertBoolean(value) {
    if (!isBoolean(value)) {
        throw new Error(`${value} is not a boolean`);
    }
}
exports.assertBoolean = assertBoolean;
/**
 * Whether the given value is a NullableBoolean.
 * @param value value to check
 * @returns true if the value is a NullableBoolean, otherwise false
 */
function isBoolean(value) {
    if (value === null) {
        return true;
    }
    return typeof value === 'boolean' || value instanceof Boolean;
}
exports.isBoolean = isBoolean;
//# sourceMappingURL=data:application/json;base64,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