"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoggingEnvironment = exports.MockEnvironment = exports.DockerEnvironment = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// eslint-disable-next-line
const execSync = require('child_process').execSync;
// eslint-disable-next-line
const os = require('os');
/**
 * Provides a Docker client against which customers can execute their commands.
 * This utility will not download docker images, rather will create containers from images provided.
 * You can use this rather than running your run commands against a real EC2 machine.
 */
class DockerEnvironment {
    constructor(containerId) {
        this.containerId = containerId;
    }
    /**
     * Use an existing container against which to run commands using the run function.
     */
    static fromContainer(containerId) {
        return new DockerEnvironment(containerId);
    }
    /**
     * Create a container from the provided image.
     * The container created will be used by this instance to run commands using the run function.
     */
    static fromImage(image) {
        return new DockerEnvironment(DockerEnvironment.execute(`docker run -di ${image}`));
    }
    static execute(command) {
        return DockerEnvironment.removeTrailingNewLine(execSync(command).toString());
    }
    static removeTrailingNewLine(line) {
        return line.endsWith(os.EOL) ? line.slice(0, -1) : line;
    }
    /**
     * Runs commands against the docker specified during construction.
     * This function runs synchronously.
     * @returns the response from the docker as a string.
     */
    run(command) {
        return DockerEnvironment.execute(`docker exec -i ${this.containerId} ${command}`);
    }
    /**
     * Force removes the container associated with this instance.
     */
    removeContainer() {
        execSync(`docker rm -f ${this.containerId}`);
    }
}
exports.DockerEnvironment = DockerEnvironment;
_a = JSII_RTTI_SYMBOL_1;
DockerEnvironment[_a] = { fqn: "@cdklabs/cdk-ssm-documents.DockerEnvironment", version: "0.0.28" };
/**
 * Environment that simply saves commands into a previousCommands variable.
 * This is useful if you want to unit test the commands that would be sent to a real environment.
 */
class MockEnvironment {
    constructor() {
        this.previousCommands = [];
    }
    run(command) {
        this.previousCommands.push(command);
        return '';
    }
}
exports.MockEnvironment = MockEnvironment;
_b = JSII_RTTI_SYMBOL_1;
MockEnvironment[_b] = { fqn: "@cdklabs/cdk-ssm-documents.MockEnvironment", version: "0.0.28" };
/**
 * Environment that simply logs the commands that it receives and displays them on the console.
 */
class LoggingEnvironment {
    run(command) {
        console.log(command);
        return '';
    }
}
exports.LoggingEnvironment = LoggingEnvironment;
_c = JSII_RTTI_SYMBOL_1;
LoggingEnvironment[_c] = { fqn: "@cdklabs/cdk-ssm-documents.LoggingEnvironment", version: "0.0.28" };
//# sourceMappingURL=data:application/json;base64,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