"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UsernamePasswordAuthMethod = exports.NoAuthMethod = exports.AuthMethod = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
class AuthMethod {
    static ofNone() {
        return new NoAuthMethod();
    }
    static ofBasic(userName, password) {
        return new UsernamePasswordAuthMethod('Basic', userName, password);
    }
    static ofDigest(userName, password) {
        return new UsernamePasswordAuthMethod('Digest', userName, password);
    }
}
exports.AuthMethod = AuthMethod;
_a = JSII_RTTI_SYMBOL_1;
AuthMethod[_a] = { fqn: "@cdklabs/cdk-ssm-documents.AuthMethod", version: "0.0.28" };
class NoAuthMethod extends AuthMethod {
    requiredInputs() {
        return [];
    }
    toEntry() {
        return {
            authMethod: 'None',
        };
    }
}
exports.NoAuthMethod = NoAuthMethod;
_b = JSII_RTTI_SYMBOL_1;
NoAuthMethod[_b] = { fqn: "@cdklabs/cdk-ssm-documents.NoAuthMethod", version: "0.0.28" };
class UsernamePasswordAuthMethod extends AuthMethod {
    constructor(authMethod, userName, password) {
        super();
        this.authMethod = authMethod;
        this.userName = userName;
        this.password = password;
    }
    requiredInputs() {
        const inputs = [
            this.userName,
            this.password,
        ];
        return inputs.flatMap(i => i?.requiredInputs() ?? []);
    }
    toEntry() {
        return {
            authMethod: this.authMethod,
            username: this.userName,
            password: this.password,
        };
    }
}
exports.UsernamePasswordAuthMethod = UsernamePasswordAuthMethod;
_c = JSII_RTTI_SYMBOL_1;
UsernamePasswordAuthMethod[_c] = { fqn: "@cdklabs/cdk-ssm-documents.UsernamePasswordAuthMethod", version: "0.0.28" };
//# sourceMappingURL=data:application/json;base64,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