"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MockApprove = exports.ApproveImpl = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// eslint-disable-next-line
const readline = require('readline');
// eslint-disable-next-line
const sp = require('synchronized-promise');
/**
 * This IApproveHook implementation provides a real ask and waits for user input of Enter.
 * This implementation does not work well on all exported JSII languages.
 * Users can provide their own impl using the IAskHook interface.
 */
class ApproveImpl {
    ask(approver) {
        const rl = readline.createInterface({
            input: process.stdin,
            output: process.stdout,
        });
        let asyncAsk = () => {
            return new Promise(resolve => rl.question(`'approvalRuntime' flag enabled. Approve running step for ${approver}? (Y/n)\n`, (ans) => {
                rl.close();
                resolve(ans);
            })).then(function (ans) {
                console.log('Proceeding with runtime after approval');
                return ans === 'Y';
            }, function () {
                console.log('error');
            });
        };
        return sp(asyncAsk)();
    }
}
exports.ApproveImpl = ApproveImpl;
_a = JSII_RTTI_SYMBOL_1;
ApproveImpl[_a] = { fqn: "@cdklabs/cdk-ssm-documents.ApproveImpl", version: "0.0.28" };
/**
 * Mock implementation of IApproveHook. Does not simulate an approval request.
 */
class MockApprove {
    constructor() {
        this.timesInvoked = 0;
    }
    ask(_approver) {
        console.log('Mocked implementation! Not performing real approval ask');
        this.timesInvoked++;
        return true;
    }
}
exports.MockApprove = MockApprove;
_b = JSII_RTTI_SYMBOL_1;
MockApprove[_b] = { fqn: "@cdklabs/cdk-ssm-documents.MockApprove", version: "0.0.28" };
//# sourceMappingURL=data:application/json;base64,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