"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutomationDocument = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const document_builder_1 = require("./document-builder");
const ssm_document_1 = require("./ssm-document");
/**
 * The AutomationDocuemnt used to both build the SSM Automation yaml/json and to use in simulation.
 * The AutomationDocument will delegate execution responsibility to the AutomationSteps that it receives.
 * The SsmDocument parent class contains methods to runSimulation() as well as print().
 */
class AutomationDocument extends ssm_document_1.SsmDocument {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.builder = new document_builder_1.AutomationDocumentBuilder();
    }
    addStep(component) {
        component.addToDocument(this.builder);
    }
    collectedSteps() {
        this.validateOutputs(this.builder.steps);
        if (this.builder.steps.length == 0) {
            throw new Error('No Steps found. Either you did not declare steps or did not synthesize CDK. ' +
                'Be sure to run cdk.SynthUtils.synthesize(stack) prior to printing or running simulation');
        }
        return this.builder.steps;
    }
    /**
       * @returns an object that can be used to build the json/yaml string representation of this document.
       */
    buildSsmDocument() {
        const automationSteps = this.collectedSteps().map(step => step.toSsmEntry());
        const root = {
            description: this.description,
            schemaVersion: '0.3',
            parameters: this.formatInputs(),
        };
        if (this.assumeRole) {
            root.assumeRole = this.assumeRole;
        }
        if (this.docOutputs.length > 0) {
            root.outputs = this.docOutputs.map(o => o.name);
        }
        root.mainSteps = automationSteps;
        return root;
    }
    /**
       * Ensures that all outputs specified in the Automation document are valid and that the steps and outputs exist.
       * Throws if any output specified cannot be found.
       */
    validateOutputs(steps) {
        this.docOutputs.forEach(docOutput => {
            if (!docOutput.name.includes('.')) {
                throw new Error(`Automation document outputs must be formatted Step.OutputName, failed validation: ${docOutput}`);
            }
            const stepAndOutput = docOutput.name.split('.');
            const stepOfOutput = steps.filter(step => step.name == stepAndOutput[0]);
            if (stepOfOutput.length != 1) {
                throw new Error(`Document must contain the step for output ${docOutput.name} but found: ${JSON.stringify(stepOfOutput)}`);
            }
            if (!stepOfOutput[0].listOutputs().map(out => out.name).includes(stepAndOutput[1])) {
                throw new Error(`Cannot find output ${JSON.stringify(docOutput)} specified as an output of step ${stepOfOutput[0].name}`);
            }
        });
    }
    documentType() {
        return 'Automation';
    }
}
exports.AutomationDocument = AutomationDocument;
_a = JSII_RTTI_SYMBOL_1;
AutomationDocument[_a] = { fqn: "@cdklabs/cdk-ssm-documents.AutomationDocument", version: "0.0.28" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXV0b21hdGlvbi1kb2N1bWVudC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9kb2N1bWVudC9hdXRvbWF0aW9uLWRvY3VtZW50LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBR0EseURBQStEO0FBQy9ELGlEQUErRDtBQVMvRDs7OztHQUlHO0FBQ0gsTUFBYSxrQkFBbUIsU0FBUSwwQkFBVztJQUlqRCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQThCO1FBQ3RFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEtBQUssQ0FBQyxDQUFDO1FBQ3hCLElBQUksQ0FBQyxPQUFPLEdBQUcsSUFBSSw0Q0FBeUIsRUFBRSxDQUFDO0lBQ2pELENBQUM7SUFFTSxPQUFPLENBQUMsU0FBK0I7UUFDNUMsU0FBUyxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLENBQUM7SUFDeEMsQ0FBQztJQUVNLGNBQWM7UUFDbkIsSUFBSSxDQUFDLGVBQWUsQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQ3pDLElBQUksSUFBSSxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMsTUFBTSxJQUFJLENBQUMsRUFBRTtZQUNsQyxNQUFNLElBQUksS0FBSyxDQUFDLDhFQUE4RTtnQkFDcEYseUZBQXlGLENBQUMsQ0FBQztTQUN0RztRQUNELE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUM7SUFDNUIsQ0FBQztJQUVEOztTQUVLO0lBQ0ssZ0JBQWdCO1FBQ3hCLE1BQU0sZUFBZSxHQUFHLElBQUksQ0FBQyxjQUFjLEVBQUUsQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsVUFBVSxFQUFFLENBQUMsQ0FBQztRQUU3RSxNQUFNLElBQUksR0FBNEI7WUFDcEMsV0FBVyxFQUFFLElBQUksQ0FBQyxXQUFXO1lBQzdCLGFBQWEsRUFBRSxLQUFLO1lBQ3BCLFVBQVUsRUFBRSxJQUFJLENBQUMsWUFBWSxFQUFFO1NBQ2hDLENBQUM7UUFDRixJQUFJLElBQUksQ0FBQyxVQUFVLEVBQUU7WUFDbkIsSUFBSSxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUMsVUFBVSxDQUFDO1NBQ25DO1FBQ0QsSUFBSSxJQUFJLENBQUMsVUFBVSxDQUFDLE1BQU0sR0FBRyxDQUFDLEVBQUU7WUFDOUIsSUFBSSxDQUFDLE9BQU8sR0FBRyxJQUFJLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsQ0FBQztTQUNqRDtRQUNELElBQUksQ0FBQyxTQUFTLEdBQUcsZUFBZSxDQUFDO1FBQ2pDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7U0FHSztJQUNHLGVBQWUsQ0FBQyxLQUF1QjtRQUM3QyxJQUFJLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxTQUFTLENBQUMsRUFBRTtZQUNsQyxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsR0FBRyxDQUFDLEVBQUU7Z0JBQ2pDLE1BQU0sSUFBSSxLQUFLLENBQUMscUZBQXFGLFNBQVMsRUFBRSxDQUFDLENBQUM7YUFDbkg7WUFDRCxNQUFNLGFBQWEsR0FBRyxTQUFTLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQztZQUNoRCxNQUFNLFlBQVksR0FBRyxLQUFLLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLElBQUksSUFBSSxhQUFhLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztZQUN6RSxJQUFJLFlBQVksQ0FBQyxNQUFNLElBQUksQ0FBQyxFQUFFO2dCQUM1QixNQUFNLElBQUksS0FBSyxDQUFDLDZDQUE2QyxTQUFTLENBQUMsSUFBSSxlQUFlLElBQUksQ0FBQyxTQUFTLENBQUMsWUFBWSxDQUFDLEVBQUUsQ0FBQyxDQUFDO2FBQzNIO1lBQ0QsSUFBSSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUMsQ0FBQyxXQUFXLEVBQUUsQ0FBQyxHQUFHLENBQUMsR0FBRyxDQUFDLEVBQUUsQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLENBQUMsUUFBUSxDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO2dCQUNsRixNQUFNLElBQUksS0FBSyxDQUFDLHNCQUFzQixJQUFJLENBQUMsU0FBUyxDQUFDLFNBQVMsQ0FBQyxtQ0FBbUMsWUFBWSxDQUFDLENBQUMsQ0FBQyxDQUFDLElBQUksRUFBRSxDQUFDLENBQUM7YUFDM0g7UUFDSCxDQUFDLENBQUMsQ0FBQztJQUNMLENBQUM7SUFFTSxZQUFZO1FBQ2pCLE9BQU8sWUFBWSxDQUFDO0lBQ3RCLENBQUM7O0FBakVILGdEQW1FQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgSUF1dG9tYXRpb25Db21wb25lbnQgfSBmcm9tICcuLi9jb25zdHJ1Y3QvZG9jdW1lbnQtY29tcG9uZW50JztcbmltcG9ydCB7IEF1dG9tYXRpb25TdGVwIH0gZnJvbSAnLi4vcGFyZW50LXN0ZXBzL2F1dG9tYXRpb24tc3RlcCc7XG5pbXBvcnQgeyBBdXRvbWF0aW9uRG9jdW1lbnRCdWlsZGVyIH0gZnJvbSAnLi9kb2N1bWVudC1idWlsZGVyJztcbmltcG9ydCB7IFNzbURvY3VtZW50UHJvcHMsIFNzbURvY3VtZW50IH0gZnJvbSAnLi9zc20tZG9jdW1lbnQnO1xuXG4vKipcbiAqIE9wdGlvbnMgZm9yIEF1dG9tYXRpb25Eb2N1bWVudFxuICovXG5leHBvcnQgaW50ZXJmYWNlIEF1dG9tYXRpb25Eb2N1bWVudFByb3BzIGV4dGVuZHMgU3NtRG9jdW1lbnRQcm9wcyB7XG5cbn1cblxuLyoqXG4gKiBUaGUgQXV0b21hdGlvbkRvY3VlbW50IHVzZWQgdG8gYm90aCBidWlsZCB0aGUgU1NNIEF1dG9tYXRpb24geWFtbC9qc29uIGFuZCB0byB1c2UgaW4gc2ltdWxhdGlvbi5cbiAqIFRoZSBBdXRvbWF0aW9uRG9jdW1lbnQgd2lsbCBkZWxlZ2F0ZSBleGVjdXRpb24gcmVzcG9uc2liaWxpdHkgdG8gdGhlIEF1dG9tYXRpb25TdGVwcyB0aGF0IGl0IHJlY2VpdmVzLlxuICogVGhlIFNzbURvY3VtZW50IHBhcmVudCBjbGFzcyBjb250YWlucyBtZXRob2RzIHRvIHJ1blNpbXVsYXRpb24oKSBhcyB3ZWxsIGFzIHByaW50KCkuXG4gKi9cbmV4cG9ydCBjbGFzcyBBdXRvbWF0aW9uRG9jdW1lbnQgZXh0ZW5kcyBTc21Eb2N1bWVudCB7XG5cbiAgcmVhZG9ubHkgYnVpbGRlcjogQXV0b21hdGlvbkRvY3VtZW50QnVpbGRlcjtcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogQXV0b21hdGlvbkRvY3VtZW50UHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHByb3BzKTtcbiAgICB0aGlzLmJ1aWxkZXIgPSBuZXcgQXV0b21hdGlvbkRvY3VtZW50QnVpbGRlcigpO1xuICB9XG5cbiAgcHVibGljIGFkZFN0ZXAoY29tcG9uZW50OiBJQXV0b21hdGlvbkNvbXBvbmVudCkge1xuICAgIGNvbXBvbmVudC5hZGRUb0RvY3VtZW50KHRoaXMuYnVpbGRlcik7XG4gIH1cblxuICBwdWJsaWMgY29sbGVjdGVkU3RlcHMoKTogQXV0b21hdGlvblN0ZXBbXSB7XG4gICAgdGhpcy52YWxpZGF0ZU91dHB1dHModGhpcy5idWlsZGVyLnN0ZXBzKTtcbiAgICBpZiAodGhpcy5idWlsZGVyLnN0ZXBzLmxlbmd0aCA9PSAwKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ05vIFN0ZXBzIGZvdW5kLiBFaXRoZXIgeW91IGRpZCBub3QgZGVjbGFyZSBzdGVwcyBvciBkaWQgbm90IHN5bnRoZXNpemUgQ0RLLiAnICtcbiAgICAgICAgICAgICAgICAnQmUgc3VyZSB0byBydW4gY2RrLlN5bnRoVXRpbHMuc3ludGhlc2l6ZShzdGFjaykgcHJpb3IgdG8gcHJpbnRpbmcgb3IgcnVubmluZyBzaW11bGF0aW9uJyk7XG4gICAgfVxuICAgIHJldHVybiB0aGlzLmJ1aWxkZXIuc3RlcHM7XG4gIH1cblxuICAvKipcbiAgICAgKiBAcmV0dXJucyBhbiBvYmplY3QgdGhhdCBjYW4gYmUgdXNlZCB0byBidWlsZCB0aGUganNvbi95YW1sIHN0cmluZyByZXByZXNlbnRhdGlvbiBvZiB0aGlzIGRvY3VtZW50LlxuICAgICAqL1xuICBwcm90ZWN0ZWQgYnVpbGRTc21Eb2N1bWVudCgpOiB7IFtuYW1lOiBzdHJpbmddOiBhbnkgfSB7XG4gICAgY29uc3QgYXV0b21hdGlvblN0ZXBzID0gdGhpcy5jb2xsZWN0ZWRTdGVwcygpLm1hcChzdGVwID0+IHN0ZXAudG9Tc21FbnRyeSgpKTtcblxuICAgIGNvbnN0IHJvb3Q6IHsgW25hbWU6IHN0cmluZ106IGFueSB9ID0ge1xuICAgICAgZGVzY3JpcHRpb246IHRoaXMuZGVzY3JpcHRpb24sXG4gICAgICBzY2hlbWFWZXJzaW9uOiAnMC4zJyxcbiAgICAgIHBhcmFtZXRlcnM6IHRoaXMuZm9ybWF0SW5wdXRzKCksXG4gICAgfTtcbiAgICBpZiAodGhpcy5hc3N1bWVSb2xlKSB7XG4gICAgICByb290LmFzc3VtZVJvbGUgPSB0aGlzLmFzc3VtZVJvbGU7XG4gICAgfVxuICAgIGlmICh0aGlzLmRvY091dHB1dHMubGVuZ3RoID4gMCkge1xuICAgICAgcm9vdC5vdXRwdXRzID0gdGhpcy5kb2NPdXRwdXRzLm1hcChvID0+IG8ubmFtZSk7XG4gICAgfVxuICAgIHJvb3QubWFpblN0ZXBzID0gYXV0b21hdGlvblN0ZXBzO1xuICAgIHJldHVybiByb290O1xuICB9XG5cbiAgLyoqXG4gICAgICogRW5zdXJlcyB0aGF0IGFsbCBvdXRwdXRzIHNwZWNpZmllZCBpbiB0aGUgQXV0b21hdGlvbiBkb2N1bWVudCBhcmUgdmFsaWQgYW5kIHRoYXQgdGhlIHN0ZXBzIGFuZCBvdXRwdXRzIGV4aXN0LlxuICAgICAqIFRocm93cyBpZiBhbnkgb3V0cHV0IHNwZWNpZmllZCBjYW5ub3QgYmUgZm91bmQuXG4gICAgICovXG4gIHByaXZhdGUgdmFsaWRhdGVPdXRwdXRzKHN0ZXBzOiBBdXRvbWF0aW9uU3RlcFtdKSB7XG4gICAgdGhpcy5kb2NPdXRwdXRzLmZvckVhY2goZG9jT3V0cHV0ID0+IHtcbiAgICAgIGlmICghZG9jT3V0cHV0Lm5hbWUuaW5jbHVkZXMoJy4nKSkge1xuICAgICAgICB0aHJvdyBuZXcgRXJyb3IoYEF1dG9tYXRpb24gZG9jdW1lbnQgb3V0cHV0cyBtdXN0IGJlIGZvcm1hdHRlZCBTdGVwLk91dHB1dE5hbWUsIGZhaWxlZCB2YWxpZGF0aW9uOiAke2RvY091dHB1dH1gKTtcbiAgICAgIH1cbiAgICAgIGNvbnN0IHN0ZXBBbmRPdXRwdXQgPSBkb2NPdXRwdXQubmFtZS5zcGxpdCgnLicpO1xuICAgICAgY29uc3Qgc3RlcE9mT3V0cHV0ID0gc3RlcHMuZmlsdGVyKHN0ZXAgPT4gc3RlcC5uYW1lID09IHN0ZXBBbmRPdXRwdXRbMF0pO1xuICAgICAgaWYgKHN0ZXBPZk91dHB1dC5sZW5ndGggIT0gMSkge1xuICAgICAgICB0aHJvdyBuZXcgRXJyb3IoYERvY3VtZW50IG11c3QgY29udGFpbiB0aGUgc3RlcCBmb3Igb3V0cHV0ICR7ZG9jT3V0cHV0Lm5hbWV9IGJ1dCBmb3VuZDogJHtKU09OLnN0cmluZ2lmeShzdGVwT2ZPdXRwdXQpfWApO1xuICAgICAgfVxuICAgICAgaWYgKCFzdGVwT2ZPdXRwdXRbMF0ubGlzdE91dHB1dHMoKS5tYXAob3V0ID0+IG91dC5uYW1lKS5pbmNsdWRlcyhzdGVwQW5kT3V0cHV0WzFdKSkge1xuICAgICAgICB0aHJvdyBuZXcgRXJyb3IoYENhbm5vdCBmaW5kIG91dHB1dCAke0pTT04uc3RyaW5naWZ5KGRvY091dHB1dCl9IHNwZWNpZmllZCBhcyBhbiBvdXRwdXQgb2Ygc3RlcCAke3N0ZXBPZk91dHB1dFswXS5uYW1lfWApO1xuICAgICAgfVxuICAgIH0pO1xuICB9XG5cbiAgcHVibGljIGRvY3VtZW50VHlwZSgpOiBzdHJpbmcge1xuICAgIHJldHVybiAnQXV0b21hdGlvbic7XG4gIH1cblxufVxuIl19