{
  description = "TODO FIXME";

  inputs = {
    nixpkgs.url = "github:NixOS/nixpkgs/nixpkgs-unstable";
    flake-utils.url = "github:numtide/flake-utils";
    pre-commit-hooks = {
      url = "github:cachix/pre-commit-hooks.nix";
      inputs.nixpkgs.follows = "nixpkgs";
      inputs.flake-utils.follows = "flake-utils";
    };
  };

  outputs = {
    self,
    flake-utils,
    nixpkgs,
    pre-commit-hooks,
    ...
  }:
    flake-utils.lib.eachDefaultSystem (system: let
      pkgs = import nixpkgs {
        inherit system;
      };
      inherit (pkgs) lib;
      defaultPackageSet = pkgs.python311Packages;
      src = lib.cleanSource ./.;
      mkSchematics = pyPackageSet:
        with pyPackageSet;
          buildPythonPackage {
            inherit src;
            checkInputs = mkTestDependencies pyPackageSet;
            format = "flit";
            pname = "schematics-py310-plus";
            version = "0.0.1";
          };
      mkTestDependencies = pyPackageSet:
        with pyPackageSet; [
          bson
          pymongo
          pytest
          pytestCheckHook
          python-dateutil
        ];
      mkDevShell = pyPackageSet: schematicsDrv:
        with pyPackageSet;
          pkgs.mkShell {
            inherit (schematicsDrv) propagatedNativeBuildInputs;

            shellHook =
              self.checks.${system}.pre-commit.shellHook
              + ''
                export PYTHONBREAKPOINT=ipdb.set_trace
                export PYTHONDONTWRITEBYTECODE=1
              '';
            inputsFrom = [schematicsDrv];
            buildInputs =
              (mkTestDependencies pyPackageSet)
              ++ [
                pkgs.cachix
                pkgs.nodePackages.pyright
                schematicsDrv

                # python dev deps (but not CI test deps)
                black
                flake8
                flit
                ipdb
                ipython
                isort
                python
              ];
          };

      schematics310 = mkSchematics pkgs.python310Packages;
      schematics39 = mkSchematics pkgs.python39Packages;
      schematics311 = mkSchematics pkgs.python311Packages;

      get_schematics_version = pkgs.writeShellApplication {
        name = "schematics_version";
        runtimeInputs = with pkgs; [coreutils gnused ripgrep];
        text = ''
          rg -F "__version__ = " schematics/__init__.py \
          | cut -d = -f 2 \
          | sed -e 's/__version__ = //' \
          | sed 's/"//g' \
          | sed 's/\s//g' \
        '';
      };
    in {
      checks = {
        inherit schematics39 schematics310 schematics311 get_schematics_version;

        pre-commit = pre-commit-hooks.lib.${system}.run {
          inherit src;
          hooks = rec {
            alejandra.enable = true;
            black.enable = true;
            isort.enable = true;
            flake8 = {
              enable = false;
              entry = "${pkgs.writeShellApplication {
                name = "check-flake8";
                runtimeInputs = with defaultPackageSet; [flake8];
                text = "flake8 schematics";
              }}/bin/check-flake8";
              name = "flake8";
              pass_filenames = false;
              types = ["file" "python"];
            };
            markdown-linter = {
              enable = true;
              entry = with pkgs; "${mdl}/bin/mdl -g";
              language = "system";
              name = "markdown-linter";
              pass_filenames = true;
              types = ["markdown"];
            };
            pyright = {
              # FIXME
              enable = false;
              entry = "${pkgs.writeShellApplication {
                name = "check-pyright";
                runtimeInputs = with defaultPackageSet; [
                  pkgs.nodePackages.pyright
                  pytest
                  python
                ];
                text = "pyright";
              }}/bin/check-pyright";
              name = "pyright";
              pass_filenames = false;
              types = ["file" "python"];
            };
            statix.enable = true;
          };
        };
      };

      packages = {
        inherit schematics39 schematics310 schematics311;
        default = schematics310;
      };
      apps = rec {
        pytest39 = flake-utils.lib.mkApp {
          drv = pkgs.python39Packages.pytest;
        };
        pytest310 = flake-utils.lib.mkApp {
          drv = pkgs.python310Packages.pytest;
        };
        pytest311 = flake-utils.lib.mkApp {
          drv = pkgs.python311Packages.pytest;
        };
        pytest = flake-utils.lib.mkApp {
          drv = defaultPackageSet.pytest;
        };
        default = pytest;
        flit = flake-utils.lib.mkApp {
          drv = defaultPackageSet.flit;
        };
        schematics_version = flake-utils.lib.mkApp {
          drv = get_schematics_version;
        };
      };

      devShells = {
        schematics39 = mkDevShell pkgs.python39Packages schematics39;
        schematics310 = mkDevShell pkgs.python310Packages schematics310;
        schematics311 = mkDevShell pkgs.python311Packages schematics311;
      };
      devShells.default = self.outputs.devShells.${system}.schematics311;

      formatter = pkgs.alejandra;
    });
}
