# arlas-subscriptions-manager-api-python
Manage ARLAS subscriptions on ARLAS collections' events.

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 23.0.1
- Package version: 1.0.0
- Build package: io.swagger.codegen.languages.PythonClientCodegen
For more information, please visit [https://arlas.io/](https://arlas.io/)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import arlas_subscriptions_manager_api_python 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import arlas_subscriptions_manager_api_python
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import arlas_subscriptions_manager_api_python
from arlas_subscriptions_manager_api_python.rest import ApiException
from pprint import pprint

# create an instance of the API class
api_instance = arlas_subscriptions_manager_api_python.AdminApi(arlas_subscriptions_manager_api_python.ApiClient(configuration))
id = 'id_example' # str | Subscription ID to delete
pretty = false # bool | Pretty print (optional) (default to false)

try:
    # Delete a subscription
    api_response = api_instance.delete(id, pretty=pretty)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AdminApi->delete: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost/arlas-subscriptions-manager*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AdminApi* | [**delete**](docs/AdminApi.md#delete) | **DELETE** /admin/subscriptions/{id} | Delete a subscription
*AdminApi* | [**get**](docs/AdminApi.md#get) | **GET** /admin/subscriptions/{id} | Find subscription by ID
*AdminApi* | [**get_all**](docs/AdminApi.md#get_all) | **GET** /admin/subscriptions | List all available subscriptions
*AdminApi* | [**post**](docs/AdminApi.md#post) | **POST** /admin/subscriptions | Register a new subscription
*AdminApi* | [**put**](docs/AdminApi.md#put) | **PUT** /admin/subscriptions/{id} | Update an existing subscription
*EndUserApi* | [**delete1**](docs/EndUserApi.md#delete1) | **DELETE** /subscriptions/{id} | Delete a subscription
*EndUserApi* | [**get1**](docs/EndUserApi.md#get1) | **GET** /subscriptions/{id} | Find subscription by ID
*EndUserApi* | [**get_all1**](docs/EndUserApi.md#get_all1) | **GET** /subscriptions | List all available subscriptions
*EndUserApi* | [**post1**](docs/EndUserApi.md#post1) | **POST** /subscriptions | Register a new subscription
*EndUserApi* | [**put1**](docs/EndUserApi.md#put1) | **PUT** /subscriptions/{id} | Update an existing subscription


## Documentation For Models

 - [Error](docs/Error.md)
 - [Hits](docs/Hits.md)
 - [Link](docs/Link.md)
 - [Subscription](docs/Subscription.md)
 - [SubscriptionListResource](docs/SubscriptionListResource.md)
 - [UserSubscription](docs/UserSubscription.md)
 - [UserSubscriptionWithLinks](docs/UserSubscriptionWithLinks.md)


## Documentation For Authorization

 All endpoints do not require authorization.


## Author

contact@gisaia.com

