__doc__, __version__ = 'Provides `make_infix` to create custom infix classes and multiple premade infix classes.', '0.0.2'
make_infix = lambda op: type(f'{op.title()}Infix', (), {'TYPE': op, '__new__': lambda cls, fn, args=[]: fn(*args) if len(args) > 1 else object.__new__(cls), '__init__': lambda self, fn, args=[]: [setattr(self, 'fn', fn), setattr(self, 'args', args)][0], f'__r{op}__': (w := lambda self, other: type(self)(self.fn, self.args + [other])), f'__{op}__': w, '__call__': lambda self, *args: self.fn(*args), '__doc__': f'This function creates an infix operator using the symbols for `{op}`. Since this is an automatically generated docstring, specific examples cannot be shown; however, general examples can be shown.\n\t>>> from infix import or_infix\n\t>>>add = or_infix(lambda x, y: x + y)\n\t>>> 5 |add| 7\n\t12\n\nSince the symbol for `or` is `|`, `add` is surrounded by pipes. Similarly, for `and_infix`, the delimiting symbol will be `&`. The symbol that this function uses should be obvious from its name'})
for x, y in list(map(lambda x: (x + '_infix', x), ['add', 'sub', 'mul', 'pow', 'or', 'and'])) + [('div_infix', 'truediv'), ('infix', 'or')]: globals()[x] = make_infix(y)
