import { EndpointInterface, RequestParameters, OctokitResponse } from "@octokit/types";
declare type AnyResponse = OctokitResponse<any>;
declare type EmptyParams = {};
declare type UsersUpdateAuthenticatedResponsePlan = {
    collaborators: number;
    name: string;
    private_repos: number;
    space: number;
};
declare type UsersUpdateAuthenticatedResponse = {
    avatar_url: string;
    bio: string;
    blog: string;
    collaborators: number;
    company: string;
    created_at: string;
    disk_usage: number;
    email: string;
    events_url: string;
    followers: number;
    followers_url: string;
    following: number;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    hireable: boolean;
    html_url: string;
    id: number;
    location: string;
    login: string;
    name: string;
    node_id: string;
    organizations_url: string;
    owned_private_repos: number;
    plan: UsersUpdateAuthenticatedResponsePlan;
    private_gists: number;
    public_gists: number;
    public_repos: number;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    total_private_repos: number;
    two_factor_authentication: boolean;
    type: string;
    updated_at: string;
    url: string;
};
declare type UsersTogglePrimaryEmailVisibilityResponseItem = {
    email: string;
    primary: boolean;
    verified: boolean;
    visibility: string;
};
declare type UsersListPublicKeysForUserResponseItem = {
    id: number;
    key: string;
};
declare type UsersListPublicKeysResponseItem = {
    key: string;
    key_id: string;
};
declare type UsersListPublicEmailsResponseItem = {
    email: string;
    primary: boolean;
    verified: boolean;
    visibility: string;
};
declare type UsersListGpgKeysForUserResponseItemSubkeysItem = {
    can_certify: boolean;
    can_encrypt_comms: boolean;
    can_encrypt_storage: boolean;
    can_sign: boolean;
    created_at: string;
    emails: Array<any>;
    expires_at: null;
    id: number;
    key_id: string;
    primary_key_id: number;
    public_key: string;
    subkeys: Array<any>;
};
declare type UsersListGpgKeysForUserResponseItemEmailsItem = {
    email: string;
    verified: boolean;
};
declare type UsersListGpgKeysForUserResponseItem = {
    can_certify: boolean;
    can_encrypt_comms: boolean;
    can_encrypt_storage: boolean;
    can_sign: boolean;
    created_at: string;
    emails: Array<UsersListGpgKeysForUserResponseItemEmailsItem>;
    expires_at: null;
    id: number;
    key_id: string;
    primary_key_id: null;
    public_key: string;
    subkeys: Array<UsersListGpgKeysForUserResponseItemSubkeysItem>;
};
declare type UsersListGpgKeysResponseItemSubkeysItem = {
    can_certify: boolean;
    can_encrypt_comms: boolean;
    can_encrypt_storage: boolean;
    can_sign: boolean;
    created_at: string;
    emails: Array<any>;
    expires_at: null;
    id: number;
    key_id: string;
    primary_key_id: number;
    public_key: string;
    subkeys: Array<any>;
};
declare type UsersListGpgKeysResponseItemEmailsItem = {
    email: string;
    verified: boolean;
};
declare type UsersListGpgKeysResponseItem = {
    can_certify: boolean;
    can_encrypt_comms: boolean;
    can_encrypt_storage: boolean;
    can_sign: boolean;
    created_at: string;
    emails: Array<UsersListGpgKeysResponseItemEmailsItem>;
    expires_at: null;
    id: number;
    key_id: string;
    primary_key_id: null;
    public_key: string;
    subkeys: Array<UsersListGpgKeysResponseItemSubkeysItem>;
};
declare type UsersListFollowingForUserResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type UsersListFollowingForAuthenticatedUserResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type UsersListFollowersForUserResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type UsersListFollowersForAuthenticatedUserResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type UsersListEmailsResponseItem = {
    email: string;
    primary: boolean;
    verified: boolean;
    visibility: string;
};
declare type UsersListBlockedResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type UsersListResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type UsersGetPublicKeyResponse = {
    key: string;
    key_id: string;
};
declare type UsersGetGpgKeyResponseSubkeysItem = {
    can_certify: boolean;
    can_encrypt_comms: boolean;
    can_encrypt_storage: boolean;
    can_sign: boolean;
    created_at: string;
    emails: Array<any>;
    expires_at: null;
    id: number;
    key_id: string;
    primary_key_id: number;
    public_key: string;
    subkeys: Array<any>;
};
declare type UsersGetGpgKeyResponseEmailsItem = {
    email: string;
    verified: boolean;
};
declare type UsersGetGpgKeyResponse = {
    can_certify: boolean;
    can_encrypt_comms: boolean;
    can_encrypt_storage: boolean;
    can_sign: boolean;
    created_at: string;
    emails: Array<UsersGetGpgKeyResponseEmailsItem>;
    expires_at: null;
    id: number;
    key_id: string;
    primary_key_id: null;
    public_key: string;
    subkeys: Array<UsersGetGpgKeyResponseSubkeysItem>;
};
declare type UsersGetContextForUserResponseContextsItem = {
    message: string;
    octicon: string;
};
declare type UsersGetContextForUserResponse = {
    contexts: Array<UsersGetContextForUserResponseContextsItem>;
};
declare type UsersGetByUsernameResponsePlan = {
    collaborators: number;
    name: string;
    private_repos: number;
    space: number;
};
declare type UsersGetByUsernameResponse = {
    avatar_url: string;
    bio: string;
    blog: string;
    company: string;
    created_at: string;
    email: string;
    events_url: string;
    followers: number;
    followers_url: string;
    following: number;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    hireable: boolean;
    html_url: string;
    id: number;
    location: string;
    login: string;
    name: string;
    node_id: string;
    organizations_url: string;
    public_gists: number;
    public_repos: number;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    updated_at: string;
    url: string;
    plan?: UsersGetByUsernameResponsePlan;
};
declare type UsersGetAuthenticatedResponsePlan = {
    collaborators: number;
    name: string;
    private_repos: number;
    space: number;
};
declare type UsersGetAuthenticatedResponse = {
    avatar_url: string;
    bio: string;
    blog: string;
    collaborators?: number;
    company: string;
    created_at: string;
    disk_usage?: number;
    email: string;
    events_url: string;
    followers: number;
    followers_url: string;
    following: number;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    hireable: boolean;
    html_url: string;
    id: number;
    location: string;
    login: string;
    name: string;
    node_id: string;
    organizations_url: string;
    owned_private_repos?: number;
    plan?: UsersGetAuthenticatedResponsePlan;
    private_gists?: number;
    public_gists: number;
    public_repos: number;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    total_private_repos?: number;
    two_factor_authentication?: boolean;
    type: string;
    updated_at: string;
    url: string;
};
declare type UsersCreatePublicKeyResponse = {
    key: string;
    key_id: string;
};
declare type UsersCreateGpgKeyResponseSubkeysItem = {
    can_certify: boolean;
    can_encrypt_comms: boolean;
    can_encrypt_storage: boolean;
    can_sign: boolean;
    created_at: string;
    emails: Array<any>;
    expires_at: null;
    id: number;
    key_id: string;
    primary_key_id: number;
    public_key: string;
    subkeys: Array<any>;
};
declare type UsersCreateGpgKeyResponseEmailsItem = {
    email: string;
    verified: boolean;
};
declare type UsersCreateGpgKeyResponse = {
    can_certify: boolean;
    can_encrypt_comms: boolean;
    can_encrypt_storage: boolean;
    can_sign: boolean;
    created_at: string;
    emails: Array<UsersCreateGpgKeyResponseEmailsItem>;
    expires_at: null;
    id: number;
    key_id: string;
    primary_key_id: null;
    public_key: string;
    subkeys: Array<UsersCreateGpgKeyResponseSubkeysItem>;
};
declare type UsersAddEmailsResponseItem = {
    email: string;
    primary: boolean;
    verified: boolean;
    visibility: string | null;
};
declare type TeamsUpdateLegacyResponseOrganization = {
    avatar_url: string;
    blog: string;
    company: string;
    created_at: string;
    description: string;
    email: string;
    events_url: string;
    followers: number;
    following: number;
    has_organization_projects: boolean;
    has_repository_projects: boolean;
    hooks_url: string;
    html_url: string;
    id: number;
    is_verified: boolean;
    issues_url: string;
    location: string;
    login: string;
    members_url: string;
    name: string;
    node_id: string;
    public_gists: number;
    public_members_url: string;
    public_repos: number;
    repos_url: string;
    type: string;
    url: string;
};
declare type TeamsUpdateLegacyResponse = {
    created_at: string;
    description: string;
    html_url: string;
    id: number;
    members_count: number;
    members_url: string;
    name: string;
    node_id: string;
    organization: TeamsUpdateLegacyResponseOrganization;
    parent: null;
    permission: string;
    privacy: string;
    repos_count: number;
    repositories_url: string;
    slug: string;
    updated_at: string;
    url: string;
};
declare type TeamsUpdateInOrgResponseOrganization = {
    avatar_url: string;
    blog: string;
    company: string;
    created_at: string;
    description: string;
    email: string;
    events_url: string;
    followers: number;
    following: number;
    has_organization_projects: boolean;
    has_repository_projects: boolean;
    hooks_url: string;
    html_url: string;
    id: number;
    is_verified: boolean;
    issues_url: string;
    location: string;
    login: string;
    members_url: string;
    name: string;
    node_id: string;
    public_gists: number;
    public_members_url: string;
    public_repos: number;
    repos_url: string;
    type: string;
    url: string;
};
declare type TeamsUpdateInOrgResponse = {
    created_at: string;
    description: string;
    html_url: string;
    id: number;
    members_count: number;
    members_url: string;
    name: string;
    node_id: string;
    organization: TeamsUpdateInOrgResponseOrganization;
    parent: null;
    permission: string;
    privacy: string;
    repos_count: number;
    repositories_url: string;
    slug: string;
    updated_at: string;
    url: string;
};
declare type TeamsUpdateDiscussionLegacyResponseReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
};
declare type TeamsUpdateDiscussionLegacyResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type TeamsUpdateDiscussionLegacyResponse = {
    author: TeamsUpdateDiscussionLegacyResponseAuthor;
    body: string;
    body_html: string;
    body_version: string;
    comments_count: number;
    comments_url: string;
    created_at: string;
    html_url: string;
    last_edited_at: string;
    node_id: string;
    number: number;
    pinned: boolean;
    private: boolean;
    reactions: TeamsUpdateDiscussionLegacyResponseReactions;
    team_url: string;
    title: string;
    updated_at: string;
    url: string;
};
declare type TeamsUpdateDiscussionInOrgResponseReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
};
declare type TeamsUpdateDiscussionInOrgResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type TeamsUpdateDiscussionInOrgResponse = {
    author: TeamsUpdateDiscussionInOrgResponseAuthor;
    body: string;
    body_html: string;
    body_version: string;
    comments_count: number;
    comments_url: string;
    created_at: string;
    html_url: string;
    last_edited_at: string;
    node_id: string;
    number: number;
    pinned: boolean;
    private: boolean;
    reactions: TeamsUpdateDiscussionInOrgResponseReactions;
    team_url: string;
    title: string;
    updated_at: string;
    url: string;
};
declare type TeamsUpdateDiscussionCommentLegacyResponseReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
};
declare type TeamsUpdateDiscussionCommentLegacyResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type TeamsUpdateDiscussionCommentLegacyResponse = {
    author: TeamsUpdateDiscussionCommentLegacyResponseAuthor;
    body: string;
    body_html: string;
    body_version: string;
    created_at: string;
    discussion_url: string;
    html_url: string;
    last_edited_at: string;
    node_id: string;
    number: number;
    reactions: TeamsUpdateDiscussionCommentLegacyResponseReactions;
    updated_at: string;
    url: string;
};
declare type TeamsUpdateDiscussionCommentInOrgResponseReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
};
declare type TeamsUpdateDiscussionCommentInOrgResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type TeamsUpdateDiscussionCommentInOrgResponse = {
    author: TeamsUpdateDiscussionCommentInOrgResponseAuthor;
    body: string;
    body_html: string;
    body_version: string;
    created_at: string;
    discussion_url: string;
    html_url: string;
    last_edited_at: string;
    node_id: string;
    number: number;
    reactions: TeamsUpdateDiscussionCommentInOrgResponseReactions;
    updated_at: string;
    url: string;
};
declare type TeamsUpdateDiscussionCommentResponseReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
};
declare type TeamsUpdateDiscussionCommentResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type TeamsUpdateDiscussionCommentResponse = {
    author: TeamsUpdateDiscussionCommentResponseAuthor;
    body: string;
    body_html: string;
    body_version: string;
    created_at: string;
    discussion_url: string;
    html_url: string;
    last_edited_at: string;
    node_id: string;
    number: number;
    reactions: TeamsUpdateDiscussionCommentResponseReactions;
    updated_at: string;
    url: string;
};
declare type TeamsUpdateDiscussionResponseReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
};
declare type TeamsUpdateDiscussionResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type TeamsUpdateDiscussionResponse = {
    author: TeamsUpdateDiscussionResponseAuthor;
    body: string;
    body_html: string;
    body_version: string;
    comments_count: number;
    comments_url: string;
    created_at: string;
    html_url: string;
    last_edited_at: string;
    node_id: string;
    number: number;
    pinned: boolean;
    private: boolean;
    reactions: TeamsUpdateDiscussionResponseReactions;
    team_url: string;
    title: string;
    updated_at: string;
    url: string;
};
declare type TeamsUpdateResponseOrganization = {
    avatar_url: string;
    blog: string;
    company: string;
    created_at: string;
    description: string;
    email: string;
    events_url: string;
    followers: number;
    following: number;
    has_organization_projects: boolean;
    has_repository_projects: boolean;
    hooks_url: string;
    html_url: string;
    id: number;
    is_verified: boolean;
    issues_url: string;
    location: string;
    login: string;
    members_url: string;
    name: string;
    node_id: string;
    public_gists: number;
    public_members_url: string;
    public_repos: number;
    repos_url: string;
    type: string;
    url: string;
};
declare type TeamsUpdateResponse = {
    created_at: string;
    description: string;
    html_url: string;
    id: number;
    members_count: number;
    members_url: string;
    name: string;
    node_id: string;
    organization: TeamsUpdateResponseOrganization;
    parent: null;
    permission: string;
    privacy: string;
    repos_count: number;
    repositories_url: string;
    slug: string;
    updated_at: string;
    url: string;
};
declare type TeamsReviewProjectLegacyResponsePermissions = {
    admin: boolean;
    read: boolean;
    write: boolean;
};
declare type TeamsReviewProjectLegacyResponseCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type TeamsReviewProjectLegacyResponse = {
    body: string;
    columns_url: string;
    created_at: string;
    creator: TeamsReviewProjectLegacyResponseCreator;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    number: number;
    organization_permission: string;
    owner_url: string;
    permissions: TeamsReviewProjectLegacyResponsePermissions;
    private: boolean;
    state: string;
    updated_at: string;
    url: string;
};
declare type TeamsReviewProjectInOrgResponsePermissions = {
    admin: boolean;
    read: boolean;
    write: boolean;
};
declare type TeamsReviewProjectInOrgResponseCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type TeamsReviewProjectInOrgResponse = {
    body: string;
    columns_url: string;
    created_at: string;
    creator: TeamsReviewProjectInOrgResponseCreator;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    number: number;
    organization_permission: string;
    owner_url: string;
    permissions: TeamsReviewProjectInOrgResponsePermissions;
    private: boolean;
    state: string;
    updated_at: string;
    url: string;
};
declare type TeamsReviewProjectResponsePermissions = {
    admin: boolean;
    read: boolean;
    write: boolean;
};
declare type TeamsReviewProjectResponseCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type TeamsReviewProjectResponse = {
    body: string;
    columns_url: string;
    created_at: string;
    creator: TeamsReviewProjectResponseCreator;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    number: number;
    organization_permission: string;
    owner_url: string;
    permissions: TeamsReviewProjectResponsePermissions;
    private: boolean;
    state: string;
    updated_at: string;
    url: string;
};
declare type TeamsListReposLegacyResponseItemPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type TeamsListReposLegacyResponseItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type TeamsListReposLegacyResponseItemLicense = {
    key: string;
    name: string;
    node_id: string;
    spdx_id: string;
    url: string;
};
declare type TeamsListReposLegacyResponseItem = {
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    license: TeamsListReposLegacyResponseItemLicense;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: TeamsListReposLegacyResponseItemOwner;
    permissions: TeamsListReposLegacyResponseItemPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type TeamsListReposInOrgResponseItemPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type TeamsListReposInOrgResponseItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type TeamsListReposInOrgResponseItemLicense = {
    key: string;
    name: string;
    node_id: string;
    spdx_id: string;
    url: string;
};
declare type TeamsListReposInOrgResponseItem = {
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    license: TeamsListReposInOrgResponseItemLicense;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: TeamsListReposInOrgResponseItemOwner;
    permissions: TeamsListReposInOrgResponseItemPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type TeamsListReposResponseItemPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type TeamsListReposResponseItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type TeamsListReposResponseItemLicense = {
    key: string;
    name: string;
    node_id: string;
    spdx_id: string;
    url: string;
};
declare type TeamsListReposResponseItem = {
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    license: TeamsListReposResponseItemLicense;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: TeamsListReposResponseItemOwner;
    permissions: TeamsListReposResponseItemPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type TeamsListProjectsLegacyResponseItemPermissions = {
    admin: boolean;
    read: boolean;
    write: boolean;
};
declare type TeamsListProjectsLegacyResponseItemCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type TeamsListProjectsLegacyResponseItem = {
    body: string;
    columns_url: string;
    created_at: string;
    creator: TeamsListProjectsLegacyResponseItemCreator;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    number: number;
    organization_permission: string;
    owner_url: string;
    permissions: TeamsListProjectsLegacyResponseItemPermissions;
    private: boolean;
    state: string;
    updated_at: string;
    url: string;
};
declare type TeamsListProjectsInOrgResponseItemPermissions = {
    admin: boolean;
    read: boolean;
    write: boolean;
};
declare type TeamsListProjectsInOrgResponseItemCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type TeamsListProjectsInOrgResponseItem = {
    body: string;
    columns_url: string;
    created_at: string;
    creator: TeamsListProjectsInOrgResponseItemCreator;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    number: number;
    organization_permission: string;
    owner_url: string;
    permissions: TeamsListProjectsInOrgResponseItemPermissions;
    private: boolean;
    state: string;
    updated_at: string;
    url: string;
};
declare type TeamsListProjectsResponseItemPermissions = {
    admin: boolean;
    read: boolean;
    write: boolean;
};
declare type TeamsListProjectsResponseItemCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type TeamsListProjectsResponseItem = {
    body: string;
    columns_url: string;
    created_at: string;
    creator: TeamsListProjectsResponseItemCreator;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    number: number;
    organization_permission: string;
    owner_url: string;
    permissions: TeamsListProjectsResponseItemPermissions;
    private: boolean;
    state: string;
    updated_at: string;
    url: string;
};
declare type TeamsListPendingInvitationsLegacyResponseItemInviter = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type TeamsListPendingInvitationsLegacyResponseItem = {
    created_at: string;
    email: string;
    id: number;
    invitation_team_url: string;
    inviter: TeamsListPendingInvitationsLegacyResponseItemInviter;
    login: string;
    role: string;
    team_count: number;
};
declare type TeamsListPendingInvitationsInOrgResponseItemInviter = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type TeamsListPendingInvitationsInOrgResponseItem = {
    created_at: string;
    email: string;
    id: number;
    invitation_team_url: string;
    inviter: TeamsListPendingInvitationsInOrgResponseItemInviter;
    login: string;
    role: string;
    team_count: number;
};
declare type TeamsListPendingInvitationsResponseItemInviter = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type TeamsListPendingInvitationsResponseItem = {
    created_at: string;
    email: string;
    id: number;
    invitation_team_url: string;
    inviter: TeamsListPendingInvitationsResponseItemInviter;
    login: string;
    role: string;
    team_count: number;
};
declare type TeamsListMembersLegacyResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type TeamsListMembersInOrgResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type TeamsListMembersResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type TeamsListForAuthenticatedUserResponseItemOrganization = {
    avatar_url: string;
    blog: string;
    company: string;
    created_at: string;
    description: string;
    email: string;
    events_url: string;
    followers: number;
    following: number;
    has_organization_projects: boolean;
    has_repository_projects: boolean;
    hooks_url: string;
    html_url: string;
    id: number;
    is_verified: boolean;
    issues_url: string;
    location: string;
    login: string;
    members_url: string;
    name: string;
    node_id: string;
    public_gists: number;
    public_members_url: string;
    public_repos: number;
    repos_url: string;
    type: string;
    url: string;
};
declare type TeamsListForAuthenticatedUserResponseItem = {
    created_at: string;
    description: string;
    html_url: string;
    id: number;
    members_count: number;
    members_url: string;
    name: string;
    node_id: string;
    organization: TeamsListForAuthenticatedUserResponseItemOrganization;
    parent: null;
    permission: string;
    privacy: string;
    repos_count: number;
    repositories_url: string;
    slug: string;
    updated_at: string;
    url: string;
};
declare type TeamsListDiscussionsLegacyResponseItemReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
};
declare type TeamsListDiscussionsLegacyResponseItemAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type TeamsListDiscussionsLegacyResponseItem = {
    author: TeamsListDiscussionsLegacyResponseItemAuthor;
    body: string;
    body_html: string;
    body_version: string;
    comments_count: number;
    comments_url: string;
    created_at: string;
    html_url: string;
    last_edited_at: null;
    node_id: string;
    number: number;
    pinned: boolean;
    private: boolean;
    reactions: TeamsListDiscussionsLegacyResponseItemReactions;
    team_url: string;
    title: string;
    updated_at: string;
    url: string;
};
declare type TeamsListDiscussionsInOrgResponseItemReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
};
declare type TeamsListDiscussionsInOrgResponseItemAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type TeamsListDiscussionsInOrgResponseItem = {
    author: TeamsListDiscussionsInOrgResponseItemAuthor;
    body: string;
    body_html: string;
    body_version: string;
    comments_count: number;
    comments_url: string;
    created_at: string;
    html_url: string;
    last_edited_at: null;
    node_id: string;
    number: number;
    pinned: boolean;
    private: boolean;
    reactions: TeamsListDiscussionsInOrgResponseItemReactions;
    team_url: string;
    title: string;
    updated_at: string;
    url: string;
};
declare type TeamsListDiscussionsResponseItemReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
};
declare type TeamsListDiscussionsResponseItemAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type TeamsListDiscussionsResponseItem = {
    author: TeamsListDiscussionsResponseItemAuthor;
    body: string;
    body_html: string;
    body_version: string;
    comments_count: number;
    comments_url: string;
    created_at: string;
    html_url: string;
    last_edited_at: null;
    node_id: string;
    number: number;
    pinned: boolean;
    private: boolean;
    reactions: TeamsListDiscussionsResponseItemReactions;
    team_url: string;
    title: string;
    updated_at: string;
    url: string;
};
declare type TeamsListDiscussionCommentsLegacyResponseItemReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
};
declare type TeamsListDiscussionCommentsLegacyResponseItemAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type TeamsListDiscussionCommentsLegacyResponseItem = {
    author: TeamsListDiscussionCommentsLegacyResponseItemAuthor;
    body: string;
    body_html: string;
    body_version: string;
    created_at: string;
    discussion_url: string;
    html_url: string;
    last_edited_at: null;
    node_id: string;
    number: number;
    reactions: TeamsListDiscussionCommentsLegacyResponseItemReactions;
    updated_at: string;
    url: string;
};
declare type TeamsListDiscussionCommentsInOrgResponseItemReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
};
declare type TeamsListDiscussionCommentsInOrgResponseItemAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type TeamsListDiscussionCommentsInOrgResponseItem = {
    author: TeamsListDiscussionCommentsInOrgResponseItemAuthor;
    body: string;
    body_html: string;
    body_version: string;
    created_at: string;
    discussion_url: string;
    html_url: string;
    last_edited_at: null;
    node_id: string;
    number: number;
    reactions: TeamsListDiscussionCommentsInOrgResponseItemReactions;
    updated_at: string;
    url: string;
};
declare type TeamsListDiscussionCommentsResponseItemReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
};
declare type TeamsListDiscussionCommentsResponseItemAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type TeamsListDiscussionCommentsResponseItem = {
    author: TeamsListDiscussionCommentsResponseItemAuthor;
    body: string;
    body_html: string;
    body_version: string;
    created_at: string;
    discussion_url: string;
    html_url: string;
    last_edited_at: null;
    node_id: string;
    number: number;
    reactions: TeamsListDiscussionCommentsResponseItemReactions;
    updated_at: string;
    url: string;
};
declare type TeamsListChildLegacyResponseItemParent = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
};
declare type TeamsListChildLegacyResponseItem = {
    description: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: TeamsListChildLegacyResponseItemParent;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
};
declare type TeamsListChildInOrgResponseItemParent = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
};
declare type TeamsListChildInOrgResponseItem = {
    description: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: TeamsListChildInOrgResponseItemParent;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
};
declare type TeamsListChildResponseItemParent = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
};
declare type TeamsListChildResponseItem = {
    description: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: TeamsListChildResponseItemParent;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
};
declare type TeamsListResponseItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
};
declare type TeamsGetMembershipLegacyResponse = {
    role: string;
    state: string;
    url: string;
};
declare type TeamsGetMembershipInOrgResponse = {
    role: string;
    state: string;
    url: string;
};
declare type TeamsGetMembershipResponse = {
    role: string;
    state: string;
    url: string;
};
declare type TeamsGetLegacyResponseOrganization = {
    avatar_url: string;
    blog: string;
    company: string;
    created_at: string;
    description: string;
    email: string;
    events_url: string;
    followers: number;
    following: number;
    has_organization_projects: boolean;
    has_repository_projects: boolean;
    hooks_url: string;
    html_url: string;
    id: number;
    is_verified: boolean;
    issues_url: string;
    location: string;
    login: string;
    members_url: string;
    name: string;
    node_id: string;
    public_gists: number;
    public_members_url: string;
    public_repos: number;
    repos_url: string;
    type: string;
    url: string;
};
declare type TeamsGetLegacyResponse = {
    created_at: string;
    description: string;
    html_url: string;
    id: number;
    members_count: number;
    members_url: string;
    name: string;
    node_id: string;
    organization: TeamsGetLegacyResponseOrganization;
    parent: null;
    permission: string;
    privacy: string;
    repos_count: number;
    repositories_url: string;
    slug: string;
    updated_at: string;
    url: string;
};
declare type TeamsGetDiscussionLegacyResponseReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
};
declare type TeamsGetDiscussionLegacyResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type TeamsGetDiscussionLegacyResponse = {
    author: TeamsGetDiscussionLegacyResponseAuthor;
    body: string;
    body_html: string;
    body_version: string;
    comments_count: number;
    comments_url: string;
    created_at: string;
    html_url: string;
    last_edited_at: null;
    node_id: string;
    number: number;
    pinned: boolean;
    private: boolean;
    reactions: TeamsGetDiscussionLegacyResponseReactions;
    team_url: string;
    title: string;
    updated_at: string;
    url: string;
};
declare type TeamsGetDiscussionInOrgResponseReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
};
declare type TeamsGetDiscussionInOrgResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type TeamsGetDiscussionInOrgResponse = {
    author: TeamsGetDiscussionInOrgResponseAuthor;
    body: string;
    body_html: string;
    body_version: string;
    comments_count: number;
    comments_url: string;
    created_at: string;
    html_url: string;
    last_edited_at: null;
    node_id: string;
    number: number;
    pinned: boolean;
    private: boolean;
    reactions: TeamsGetDiscussionInOrgResponseReactions;
    team_url: string;
    title: string;
    updated_at: string;
    url: string;
};
declare type TeamsGetDiscussionCommentLegacyResponseReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
};
declare type TeamsGetDiscussionCommentLegacyResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type TeamsGetDiscussionCommentLegacyResponse = {
    author: TeamsGetDiscussionCommentLegacyResponseAuthor;
    body: string;
    body_html: string;
    body_version: string;
    created_at: string;
    discussion_url: string;
    html_url: string;
    last_edited_at: null;
    node_id: string;
    number: number;
    reactions: TeamsGetDiscussionCommentLegacyResponseReactions;
    updated_at: string;
    url: string;
};
declare type TeamsGetDiscussionCommentInOrgResponseReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
};
declare type TeamsGetDiscussionCommentInOrgResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type TeamsGetDiscussionCommentInOrgResponse = {
    author: TeamsGetDiscussionCommentInOrgResponseAuthor;
    body: string;
    body_html: string;
    body_version: string;
    created_at: string;
    discussion_url: string;
    html_url: string;
    last_edited_at: null;
    node_id: string;
    number: number;
    reactions: TeamsGetDiscussionCommentInOrgResponseReactions;
    updated_at: string;
    url: string;
};
declare type TeamsGetDiscussionCommentResponseReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
};
declare type TeamsGetDiscussionCommentResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type TeamsGetDiscussionCommentResponse = {
    author: TeamsGetDiscussionCommentResponseAuthor;
    body: string;
    body_html: string;
    body_version: string;
    created_at: string;
    discussion_url: string;
    html_url: string;
    last_edited_at: null;
    node_id: string;
    number: number;
    reactions: TeamsGetDiscussionCommentResponseReactions;
    updated_at: string;
    url: string;
};
declare type TeamsGetDiscussionResponseReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
};
declare type TeamsGetDiscussionResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type TeamsGetDiscussionResponse = {
    author: TeamsGetDiscussionResponseAuthor;
    body: string;
    body_html: string;
    body_version: string;
    comments_count: number;
    comments_url: string;
    created_at: string;
    html_url: string;
    last_edited_at: null;
    node_id: string;
    number: number;
    pinned: boolean;
    private: boolean;
    reactions: TeamsGetDiscussionResponseReactions;
    team_url: string;
    title: string;
    updated_at: string;
    url: string;
};
declare type TeamsGetByNameResponseOrganization = {
    avatar_url: string;
    blog: string;
    company: string;
    created_at: string;
    description: string;
    email: string;
    events_url: string;
    followers: number;
    following: number;
    has_organization_projects: boolean;
    has_repository_projects: boolean;
    hooks_url: string;
    html_url: string;
    id: number;
    is_verified: boolean;
    issues_url: string;
    location: string;
    login: string;
    members_url: string;
    name: string;
    node_id: string;
    public_gists: number;
    public_members_url: string;
    public_repos: number;
    repos_url: string;
    type: string;
    url: string;
};
declare type TeamsGetByNameResponse = {
    created_at: string;
    description: string;
    html_url: string;
    id: number;
    members_count: number;
    members_url: string;
    name: string;
    node_id: string;
    organization: TeamsGetByNameResponseOrganization;
    parent: null;
    permission: string;
    privacy: string;
    repos_count: number;
    repositories_url: string;
    slug: string;
    updated_at: string;
    url: string;
};
declare type TeamsGetResponseOrganization = {
    avatar_url: string;
    blog: string;
    company: string;
    created_at: string;
    description: string;
    email: string;
    events_url: string;
    followers: number;
    following: number;
    has_organization_projects: boolean;
    has_repository_projects: boolean;
    hooks_url: string;
    html_url: string;
    id: number;
    is_verified: boolean;
    issues_url: string;
    location: string;
    login: string;
    members_url: string;
    name: string;
    node_id: string;
    public_gists: number;
    public_members_url: string;
    public_repos: number;
    repos_url: string;
    type: string;
    url: string;
};
declare type TeamsGetResponse = {
    created_at: string;
    description: string;
    html_url: string;
    id: number;
    members_count: number;
    members_url: string;
    name: string;
    node_id: string;
    organization: TeamsGetResponseOrganization;
    parent: null;
    permission: string;
    privacy: string;
    repos_count: number;
    repositories_url: string;
    slug: string;
    updated_at: string;
    url: string;
};
declare type TeamsCreateDiscussionLegacyResponseReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
};
declare type TeamsCreateDiscussionLegacyResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type TeamsCreateDiscussionLegacyResponse = {
    author: TeamsCreateDiscussionLegacyResponseAuthor;
    body: string;
    body_html: string;
    body_version: string;
    comments_count: number;
    comments_url: string;
    created_at: string;
    html_url: string;
    last_edited_at: null;
    node_id: string;
    number: number;
    pinned: boolean;
    private: boolean;
    reactions: TeamsCreateDiscussionLegacyResponseReactions;
    team_url: string;
    title: string;
    updated_at: string;
    url: string;
};
declare type TeamsCreateDiscussionInOrgResponseReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
};
declare type TeamsCreateDiscussionInOrgResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type TeamsCreateDiscussionInOrgResponse = {
    author: TeamsCreateDiscussionInOrgResponseAuthor;
    body: string;
    body_html: string;
    body_version: string;
    comments_count: number;
    comments_url: string;
    created_at: string;
    html_url: string;
    last_edited_at: null;
    node_id: string;
    number: number;
    pinned: boolean;
    private: boolean;
    reactions: TeamsCreateDiscussionInOrgResponseReactions;
    team_url: string;
    title: string;
    updated_at: string;
    url: string;
};
declare type TeamsCreateDiscussionCommentLegacyResponseReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
};
declare type TeamsCreateDiscussionCommentLegacyResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type TeamsCreateDiscussionCommentLegacyResponse = {
    author: TeamsCreateDiscussionCommentLegacyResponseAuthor;
    body: string;
    body_html: string;
    body_version: string;
    created_at: string;
    discussion_url: string;
    html_url: string;
    last_edited_at: null;
    node_id: string;
    number: number;
    reactions: TeamsCreateDiscussionCommentLegacyResponseReactions;
    updated_at: string;
    url: string;
};
declare type TeamsCreateDiscussionCommentInOrgResponseReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
};
declare type TeamsCreateDiscussionCommentInOrgResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type TeamsCreateDiscussionCommentInOrgResponse = {
    author: TeamsCreateDiscussionCommentInOrgResponseAuthor;
    body: string;
    body_html: string;
    body_version: string;
    created_at: string;
    discussion_url: string;
    html_url: string;
    last_edited_at: null;
    node_id: string;
    number: number;
    reactions: TeamsCreateDiscussionCommentInOrgResponseReactions;
    updated_at: string;
    url: string;
};
declare type TeamsCreateDiscussionCommentResponseReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
};
declare type TeamsCreateDiscussionCommentResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type TeamsCreateDiscussionCommentResponse = {
    author: TeamsCreateDiscussionCommentResponseAuthor;
    body: string;
    body_html: string;
    body_version: string;
    created_at: string;
    discussion_url: string;
    html_url: string;
    last_edited_at: null;
    node_id: string;
    number: number;
    reactions: TeamsCreateDiscussionCommentResponseReactions;
    updated_at: string;
    url: string;
};
declare type TeamsCreateDiscussionResponseReactions = {
    "+1": number;
    "-1": number;
    confused: number;
    heart: number;
    hooray: number;
    laugh: number;
    total_count: number;
    url: string;
};
declare type TeamsCreateDiscussionResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type TeamsCreateDiscussionResponse = {
    author: TeamsCreateDiscussionResponseAuthor;
    body: string;
    body_html: string;
    body_version: string;
    comments_count: number;
    comments_url: string;
    created_at: string;
    html_url: string;
    last_edited_at: null;
    node_id: string;
    number: number;
    pinned: boolean;
    private: boolean;
    reactions: TeamsCreateDiscussionResponseReactions;
    team_url: string;
    title: string;
    updated_at: string;
    url: string;
};
declare type TeamsCreateResponseOrganization = {
    avatar_url: string;
    blog: string;
    company: string;
    created_at: string;
    description: string;
    email: string;
    events_url: string;
    followers: number;
    following: number;
    has_organization_projects: boolean;
    has_repository_projects: boolean;
    hooks_url: string;
    html_url: string;
    id: number;
    is_verified: boolean;
    issues_url: string;
    location: string;
    login: string;
    members_url: string;
    name: string;
    node_id: string;
    public_gists: number;
    public_members_url: string;
    public_repos: number;
    repos_url: string;
    type: string;
    url: string;
};
declare type TeamsCreateResponse = {
    created_at: string;
    description: string;
    html_url: string;
    id: number;
    members_count: number;
    members_url: string;
    name: string;
    node_id: string;
    organization: TeamsCreateResponseOrganization;
    parent: null;
    permission: string;
    privacy: string;
    repos_count: number;
    repositories_url: string;
    slug: string;
    updated_at: string;
    url: string;
};
declare type TeamsCheckManagesRepoLegacyResponsePermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type TeamsCheckManagesRepoLegacyResponseOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type TeamsCheckManagesRepoLegacyResponse = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: TeamsCheckManagesRepoLegacyResponseOwner;
    permissions: TeamsCheckManagesRepoLegacyResponsePermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type TeamsCheckManagesRepoInOrgResponsePermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type TeamsCheckManagesRepoInOrgResponseOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type TeamsCheckManagesRepoInOrgResponse = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: TeamsCheckManagesRepoInOrgResponseOwner;
    permissions: TeamsCheckManagesRepoInOrgResponsePermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type TeamsCheckManagesRepoResponsePermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type TeamsCheckManagesRepoResponseOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type TeamsCheckManagesRepoResponse = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: TeamsCheckManagesRepoResponseOwner;
    permissions: TeamsCheckManagesRepoResponsePermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type TeamsAddOrUpdateProjectLegacyResponse = {
    documentation_url: string;
    message: string;
};
declare type TeamsAddOrUpdateProjectInOrgResponse = {
    documentation_url: string;
    message: string;
};
declare type TeamsAddOrUpdateProjectResponse = {
    documentation_url: string;
    message: string;
};
declare type TeamsAddOrUpdateMembershipLegacyResponse = {
    role: string;
    state: string;
    url: string;
};
declare type TeamsAddOrUpdateMembershipInOrgResponse = {
    role: string;
    state: string;
    url: string;
};
declare type TeamsAddOrUpdateMembershipResponse = {
    role: string;
    state: string;
    url: string;
};
declare type TeamsAddMemberLegacyResponseErrorsItem = {
    code: string;
    field: string;
    resource: string;
};
declare type TeamsAddMemberLegacyResponse = {
    errors: Array<TeamsAddMemberLegacyResponseErrorsItem>;
    message: string;
};
declare type TeamsAddMemberResponseErrorsItem = {
    code: string;
    field: string;
    resource: string;
};
declare type TeamsAddMemberResponse = {
    errors: Array<TeamsAddMemberResponseErrorsItem>;
    message: string;
};
declare type SearchUsersLegacyResponseUsersItem = {
    created: string;
    created_at: string;
    followers: number;
    followers_count: number;
    fullname: string;
    gravatar_id: string;
    id: string;
    language: string;
    location: string;
    login: string;
    name: string;
    public_repo_count: number;
    repos: number;
    score: number;
    type: string;
    username: string;
};
declare type SearchUsersLegacyResponse = {
    users: Array<SearchUsersLegacyResponseUsersItem>;
};
declare type SearchUsersResponseItemsItem = {
    avatar_url: string;
    followers_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    score: number;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type SearchUsersResponse = {
    incomplete_results: boolean;
    items: Array<SearchUsersResponseItemsItem>;
    total_count: number;
};
declare type SearchTopicsResponseItemsItem = {
    created_at: string;
    created_by: string;
    curated: boolean;
    description: string;
    display_name: string;
    featured: boolean;
    name: string;
    released: string;
    score: number;
    short_description: string;
    updated_at: string;
};
declare type SearchTopicsResponse = {
    incomplete_results: boolean;
    items: Array<SearchTopicsResponseItemsItem>;
    total_count: number;
};
declare type SearchReposLegacyResponseRepositoriesItem = {
    created: string;
    created_at: string;
    description: string;
    followers: number;
    fork: boolean;
    forks: number;
    has_downloads: boolean;
    has_issues: boolean;
    has_wiki: boolean;
    homepage: string;
    language: string;
    name: string;
    open_issues: number;
    owner: string;
    private: boolean;
    pushed: string;
    pushed_at: string;
    score: number;
    size: number;
    type: string;
    url: string;
    username: string;
    watchers: number;
};
declare type SearchReposLegacyResponse = {
    repositories: Array<SearchReposLegacyResponseRepositoriesItem>;
};
declare type SearchReposResponseItemsItemOwner = {
    avatar_url: string;
    gravatar_id: string;
    id: number;
    login: string;
    node_id: string;
    received_events_url: string;
    type: string;
    url: string;
};
declare type SearchReposResponseItemsItem = {
    created_at: string;
    default_branch: string;
    description: string;
    fork: boolean;
    forks_count: number;
    full_name: string;
    homepage: string;
    html_url: string;
    id: number;
    language: string;
    master_branch: string;
    name: string;
    node_id: string;
    open_issues_count: number;
    owner: SearchReposResponseItemsItemOwner;
    private: boolean;
    pushed_at: string;
    score: number;
    size: number;
    stargazers_count: number;
    updated_at: string;
    url: string;
    watchers_count: number;
};
declare type SearchReposResponse = {
    incomplete_results: boolean;
    items: Array<SearchReposResponseItemsItem>;
    total_count: number;
};
declare type SearchLabelsResponseItemsItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    score: number;
    url: string;
};
declare type SearchLabelsResponse = {
    incomplete_results: boolean;
    items: Array<SearchLabelsResponseItemsItem>;
    total_count: number;
};
declare type SearchIssuesLegacyResponseIssuesItem = {
    body: string;
    comments: number;
    created_at: string;
    gravatar_id: string;
    html_url: string;
    labels: Array<string>;
    number: number;
    position: number;
    state: string;
    title: string;
    updated_at: string;
    user: string;
    votes: number;
};
declare type SearchIssuesLegacyResponse = {
    issues: Array<SearchIssuesLegacyResponseIssuesItem>;
};
declare type SearchIssuesAndPullRequestsResponseItemsItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type SearchIssuesAndPullRequestsResponseItemsItemPullRequest = {
    diff_url: null;
    html_url: null;
    patch_url: null;
};
declare type SearchIssuesAndPullRequestsResponseItemsItemLabelsItem = {
    color: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
};
declare type SearchIssuesAndPullRequestsResponseItemsItem = {
    assignee: null;
    body: string;
    closed_at: null;
    comments: number;
    comments_url: string;
    created_at: string;
    events_url: string;
    html_url: string;
    id: number;
    labels: Array<SearchIssuesAndPullRequestsResponseItemsItemLabelsItem>;
    labels_url: string;
    milestone: null;
    node_id: string;
    number: number;
    pull_request: SearchIssuesAndPullRequestsResponseItemsItemPullRequest;
    repository_url: string;
    score: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
    user: SearchIssuesAndPullRequestsResponseItemsItemUser;
};
declare type SearchIssuesAndPullRequestsResponse = {
    incomplete_results: boolean;
    items: Array<SearchIssuesAndPullRequestsResponseItemsItem>;
    total_count: number;
};
declare type SearchIssuesResponseItemsItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type SearchIssuesResponseItemsItemPullRequest = {
    diff_url: null;
    html_url: null;
    patch_url: null;
};
declare type SearchIssuesResponseItemsItemLabelsItem = {
    color: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
};
declare type SearchIssuesResponseItemsItem = {
    assignee: null;
    body: string;
    closed_at: null;
    comments: number;
    comments_url: string;
    created_at: string;
    events_url: string;
    html_url: string;
    id: number;
    labels: Array<SearchIssuesResponseItemsItemLabelsItem>;
    labels_url: string;
    milestone: null;
    node_id: string;
    number: number;
    pull_request: SearchIssuesResponseItemsItemPullRequest;
    repository_url: string;
    score: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
    user: SearchIssuesResponseItemsItemUser;
};
declare type SearchIssuesResponse = {
    incomplete_results: boolean;
    items: Array<SearchIssuesResponseItemsItem>;
    total_count: number;
};
declare type SearchEmailLegacyResponseUser = {
    blog: string;
    company: string;
    created: string;
    created_at: string;
    email: string;
    followers_count: number;
    following_count: number;
    gravatar_id: string;
    id: number;
    location: string;
    login: string;
    name: string;
    public_gist_count: number;
    public_repo_count: number;
    type: string;
};
declare type SearchEmailLegacyResponse = {
    user: SearchEmailLegacyResponseUser;
};
declare type SearchCommitsResponseItemsItemRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type SearchCommitsResponseItemsItemRepository = {
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    description: string;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    hooks_url: string;
    html_url: string;
    id: number;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    name: string;
    node_id: string;
    notifications_url: string;
    owner: SearchCommitsResponseItemsItemRepositoryOwner;
    private: boolean;
    pulls_url: string;
    releases_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    url: string;
};
declare type SearchCommitsResponseItemsItemParentsItem = {
    html_url: string;
    sha: string;
    url: string;
};
declare type SearchCommitsResponseItemsItemCommitter = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type SearchCommitsResponseItemsItemCommitTree = {
    sha: string;
    url: string;
};
declare type SearchCommitsResponseItemsItemCommitCommitter = {
    date: string;
    email: string;
    name: string;
};
declare type SearchCommitsResponseItemsItemCommitAuthor = {
    date: string;
    email: string;
    name: string;
};
declare type SearchCommitsResponseItemsItemCommit = {
    author: SearchCommitsResponseItemsItemCommitAuthor;
    comment_count: number;
    committer: SearchCommitsResponseItemsItemCommitCommitter;
    message: string;
    tree: SearchCommitsResponseItemsItemCommitTree;
    url: string;
};
declare type SearchCommitsResponseItemsItemAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type SearchCommitsResponseItemsItem = {
    author: SearchCommitsResponseItemsItemAuthor;
    comments_url: string;
    commit: SearchCommitsResponseItemsItemCommit;
    committer: SearchCommitsResponseItemsItemCommitter;
    html_url: string;
    parents: Array<SearchCommitsResponseItemsItemParentsItem>;
    repository: SearchCommitsResponseItemsItemRepository;
    score: number;
    sha: string;
    url: string;
};
declare type SearchCommitsResponse = {
    incomplete_results: boolean;
    items: Array<SearchCommitsResponseItemsItem>;
    total_count: number;
};
declare type SearchCodeResponseItemsItemRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type SearchCodeResponseItemsItemRepository = {
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    description: string;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    hooks_url: string;
    html_url: string;
    id: number;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    name: string;
    node_id: string;
    notifications_url: string;
    owner: SearchCodeResponseItemsItemRepositoryOwner;
    private: boolean;
    pulls_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    url: string;
};
declare type SearchCodeResponseItemsItem = {
    git_url: string;
    html_url: string;
    name: string;
    path: string;
    repository: SearchCodeResponseItemsItemRepository;
    score: number;
    sha: string;
    url: string;
};
declare type SearchCodeResponse = {
    incomplete_results: boolean;
    items: Array<SearchCodeResponseItemsItem>;
    total_count: number;
};
declare type ReposUploadReleaseAssetResponseValueUploader = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposUploadReleaseAssetResponseValue = {
    browser_download_url: string;
    content_type: string;
    created_at: string;
    download_count: number;
    id: number;
    label: string;
    name: string;
    node_id: string;
    size: number;
    state: string;
    updated_at: string;
    uploader: ReposUploadReleaseAssetResponseValueUploader;
    url: string;
};
declare type ReposUploadReleaseAssetResponse = {
    value: ReposUploadReleaseAssetResponseValue;
};
declare type ReposUpdateReleaseAssetResponseUploader = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposUpdateReleaseAssetResponse = {
    browser_download_url: string;
    content_type: string;
    created_at: string;
    download_count: number;
    id: number;
    label: string;
    name: string;
    node_id: string;
    size: number;
    state: string;
    updated_at: string;
    uploader: ReposUpdateReleaseAssetResponseUploader;
    url: string;
};
declare type ReposUpdateReleaseResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposUpdateReleaseResponseAssetsItemUploader = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposUpdateReleaseResponseAssetsItem = {
    browser_download_url: string;
    content_type: string;
    created_at: string;
    download_count: number;
    id: number;
    label: string;
    name: string;
    node_id: string;
    size: number;
    state: string;
    updated_at: string;
    uploader: ReposUpdateReleaseResponseAssetsItemUploader;
    url: string;
};
declare type ReposUpdateReleaseResponse = {
    assets: Array<ReposUpdateReleaseResponseAssetsItem>;
    assets_url: string;
    author: ReposUpdateReleaseResponseAuthor;
    body: string;
    created_at: string;
    draft: boolean;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    prerelease: boolean;
    published_at: string;
    tag_name: string;
    tarball_url: string;
    target_commitish: string;
    upload_url: string;
    url: string;
    zipball_url: string;
};
declare type ReposUpdateProtectedBranchRequiredStatusChecksResponse = {
    contexts: Array<string>;
    contexts_url: string;
    strict: boolean;
    url: string;
};
declare type ReposUpdateProtectedBranchPullRequestReviewEnforcementResponseDismissalRestrictionsUsersItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposUpdateProtectedBranchPullRequestReviewEnforcementResponseDismissalRestrictionsTeamsItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
};
declare type ReposUpdateProtectedBranchPullRequestReviewEnforcementResponseDismissalRestrictions = {
    teams: Array<ReposUpdateProtectedBranchPullRequestReviewEnforcementResponseDismissalRestrictionsTeamsItem>;
    teams_url: string;
    url: string;
    users: Array<ReposUpdateProtectedBranchPullRequestReviewEnforcementResponseDismissalRestrictionsUsersItem>;
    users_url: string;
};
declare type ReposUpdateProtectedBranchPullRequestReviewEnforcementResponse = {
    dismiss_stale_reviews: boolean;
    dismissal_restrictions: ReposUpdateProtectedBranchPullRequestReviewEnforcementResponseDismissalRestrictions;
    require_code_owner_reviews: boolean;
    required_approving_review_count: number;
    url: string;
};
declare type ReposUpdateInvitationResponseRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposUpdateInvitationResponseRepository = {
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    description: string;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    html_url: string;
    id: number;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    name: string;
    node_id: string;
    notifications_url: string;
    owner: ReposUpdateInvitationResponseRepositoryOwner;
    private: boolean;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    url: string;
};
declare type ReposUpdateInvitationResponseInviter = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposUpdateInvitationResponseInvitee = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposUpdateInvitationResponse = {
    created_at: string;
    html_url: string;
    id: number;
    invitee: ReposUpdateInvitationResponseInvitee;
    inviter: ReposUpdateInvitationResponseInviter;
    permissions: string;
    repository: ReposUpdateInvitationResponseRepository;
    url: string;
};
declare type ReposUpdateHookResponseLastResponse = {
    code: null;
    message: null;
    status: string;
};
declare type ReposUpdateHookResponseConfig = {
    content_type: string;
    insecure_ssl: string;
    url: string;
};
declare type ReposUpdateHookResponse = {
    active: boolean;
    config: ReposUpdateHookResponseConfig;
    created_at: string;
    events: Array<string>;
    id: number;
    last_response: ReposUpdateHookResponseLastResponse;
    name: string;
    ping_url: string;
    test_url: string;
    type: string;
    updated_at: string;
    url: string;
};
declare type ReposUpdateFileResponseContentLinks = {
    git: string;
    html: string;
    self: string;
};
declare type ReposUpdateFileResponseContent = {
    _links: ReposUpdateFileResponseContentLinks;
    download_url: string;
    git_url: string;
    html_url: string;
    name: string;
    path: string;
    sha: string;
    size: number;
    type: string;
    url: string;
};
declare type ReposUpdateFileResponseCommitVerification = {
    payload: null;
    reason: string;
    signature: null;
    verified: boolean;
};
declare type ReposUpdateFileResponseCommitTree = {
    sha: string;
    url: string;
};
declare type ReposUpdateFileResponseCommitParentsItem = {
    html_url: string;
    sha: string;
    url: string;
};
declare type ReposUpdateFileResponseCommitCommitter = {
    date: string;
    email: string;
    name: string;
};
declare type ReposUpdateFileResponseCommitAuthor = {
    date: string;
    email: string;
    name: string;
};
declare type ReposUpdateFileResponseCommit = {
    author: ReposUpdateFileResponseCommitAuthor;
    committer: ReposUpdateFileResponseCommitCommitter;
    html_url: string;
    message: string;
    node_id: string;
    parents: Array<ReposUpdateFileResponseCommitParentsItem>;
    sha: string;
    tree: ReposUpdateFileResponseCommitTree;
    url: string;
    verification: ReposUpdateFileResponseCommitVerification;
};
declare type ReposUpdateFileResponse = {
    commit: ReposUpdateFileResponseCommit;
    content: ReposUpdateFileResponseContent;
};
declare type ReposUpdateCommitCommentResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposUpdateCommitCommentResponse = {
    body: string;
    commit_id: string;
    created_at: string;
    html_url: string;
    id: number;
    line: number;
    node_id: string;
    path: string;
    position: number;
    updated_at: string;
    url: string;
    user: ReposUpdateCommitCommentResponseUser;
};
declare type ReposUpdateBranchProtectionResponseRestrictionsUsersItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposUpdateBranchProtectionResponseRestrictionsTeamsItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
};
declare type ReposUpdateBranchProtectionResponseRestrictionsAppsItemPermissions = {
    contents: string;
    issues: string;
    metadata: string;
    single_file: string;
};
declare type ReposUpdateBranchProtectionResponseRestrictionsAppsItemOwner = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
};
declare type ReposUpdateBranchProtectionResponseRestrictionsAppsItem = {
    created_at: string;
    description: string;
    events: Array<string>;
    external_url: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    owner: ReposUpdateBranchProtectionResponseRestrictionsAppsItemOwner;
    permissions: ReposUpdateBranchProtectionResponseRestrictionsAppsItemPermissions;
    slug: string;
    updated_at: string;
};
declare type ReposUpdateBranchProtectionResponseRestrictions = {
    apps: Array<ReposUpdateBranchProtectionResponseRestrictionsAppsItem>;
    apps_url: string;
    teams: Array<ReposUpdateBranchProtectionResponseRestrictionsTeamsItem>;
    teams_url: string;
    url: string;
    users: Array<ReposUpdateBranchProtectionResponseRestrictionsUsersItem>;
    users_url: string;
};
declare type ReposUpdateBranchProtectionResponseRequiredStatusChecks = {
    contexts: Array<string>;
    contexts_url: string;
    strict: boolean;
    url: string;
};
declare type ReposUpdateBranchProtectionResponseRequiredPullRequestReviewsDismissalRestrictionsUsersItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposUpdateBranchProtectionResponseRequiredPullRequestReviewsDismissalRestrictionsTeamsItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
};
declare type ReposUpdateBranchProtectionResponseRequiredPullRequestReviewsDismissalRestrictions = {
    teams: Array<ReposUpdateBranchProtectionResponseRequiredPullRequestReviewsDismissalRestrictionsTeamsItem>;
    teams_url: string;
    url: string;
    users: Array<ReposUpdateBranchProtectionResponseRequiredPullRequestReviewsDismissalRestrictionsUsersItem>;
    users_url: string;
};
declare type ReposUpdateBranchProtectionResponseRequiredPullRequestReviews = {
    dismiss_stale_reviews: boolean;
    dismissal_restrictions: ReposUpdateBranchProtectionResponseRequiredPullRequestReviewsDismissalRestrictions;
    require_code_owner_reviews: boolean;
    required_approving_review_count: number;
    url: string;
};
declare type ReposUpdateBranchProtectionResponseRequiredLinearHistory = {
    enabled: boolean;
};
declare type ReposUpdateBranchProtectionResponseEnforceAdmins = {
    enabled: boolean;
    url: string;
};
declare type ReposUpdateBranchProtectionResponseAllowForcePushes = {
    enabled: boolean;
};
declare type ReposUpdateBranchProtectionResponseAllowDeletions = {
    enabled: boolean;
};
declare type ReposUpdateBranchProtectionResponse = {
    allow_deletions: ReposUpdateBranchProtectionResponseAllowDeletions;
    allow_force_pushes: ReposUpdateBranchProtectionResponseAllowForcePushes;
    enforce_admins: ReposUpdateBranchProtectionResponseEnforceAdmins;
    required_linear_history: ReposUpdateBranchProtectionResponseRequiredLinearHistory;
    required_pull_request_reviews: ReposUpdateBranchProtectionResponseRequiredPullRequestReviews;
    required_status_checks: ReposUpdateBranchProtectionResponseRequiredStatusChecks;
    restrictions: ReposUpdateBranchProtectionResponseRestrictions;
    url: string;
};
declare type ReposUpdateResponseSourcePermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type ReposUpdateResponseSourceOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposUpdateResponseSource = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: ReposUpdateResponseSourceOwner;
    permissions: ReposUpdateResponseSourcePermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type ReposUpdateResponsePermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type ReposUpdateResponseParentPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type ReposUpdateResponseParentOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposUpdateResponseParent = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: ReposUpdateResponseParentOwner;
    permissions: ReposUpdateResponseParentPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type ReposUpdateResponseOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposUpdateResponseOrganization = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposUpdateResponse = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    organization: ReposUpdateResponseOrganization;
    owner: ReposUpdateResponseOwner;
    parent: ReposUpdateResponseParent;
    permissions: ReposUpdateResponsePermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    source: ReposUpdateResponseSource;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type ReposTransferResponsePermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type ReposTransferResponseOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposTransferResponse = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: ReposTransferResponseOwner;
    permissions: ReposTransferResponsePermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type ReposRetrieveCommunityProfileMetricsResponseFilesReadme = {
    html_url: string;
    url: string;
};
declare type ReposRetrieveCommunityProfileMetricsResponseFilesPullRequestTemplate = {
    html_url: string;
    url: string;
};
declare type ReposRetrieveCommunityProfileMetricsResponseFilesLicense = {
    html_url: string;
    key: string;
    name: string;
    spdx_id: string;
    url: string;
};
declare type ReposRetrieveCommunityProfileMetricsResponseFilesIssueTemplate = {
    html_url: string;
    url: string;
};
declare type ReposRetrieveCommunityProfileMetricsResponseFilesContributing = {
    html_url: string;
    url: string;
};
declare type ReposRetrieveCommunityProfileMetricsResponseFilesCodeOfConduct = {
    html_url: string;
    key: string;
    name: string;
    url: string;
};
declare type ReposRetrieveCommunityProfileMetricsResponseFiles = {
    code_of_conduct: ReposRetrieveCommunityProfileMetricsResponseFilesCodeOfConduct;
    contributing: ReposRetrieveCommunityProfileMetricsResponseFilesContributing;
    issue_template: ReposRetrieveCommunityProfileMetricsResponseFilesIssueTemplate;
    license: ReposRetrieveCommunityProfileMetricsResponseFilesLicense;
    pull_request_template: ReposRetrieveCommunityProfileMetricsResponseFilesPullRequestTemplate;
    readme: ReposRetrieveCommunityProfileMetricsResponseFilesReadme;
};
declare type ReposRetrieveCommunityProfileMetricsResponse = {
    description: string;
    documentation: boolean;
    files: ReposRetrieveCommunityProfileMetricsResponseFiles;
    health_percentage: number;
    updated_at: string;
};
declare type ReposRequestPageBuildResponse = {
    status: string;
    url: string;
};
declare type ReposReplaceTopicsResponse = {
    names: Array<string>;
};
declare type ReposReplaceProtectedBranchUserRestrictionsResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposReplaceProtectedBranchTeamRestrictionsResponseItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
};
declare type ReposReplaceProtectedBranchAppRestrictionsResponseItemPermissions = {
    contents: string;
    issues: string;
    metadata: string;
    single_file: string;
};
declare type ReposReplaceProtectedBranchAppRestrictionsResponseItemOwner = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
};
declare type ReposReplaceProtectedBranchAppRestrictionsResponseItem = {
    created_at: string;
    description: string;
    events: Array<string>;
    external_url: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    owner: ReposReplaceProtectedBranchAppRestrictionsResponseItemOwner;
    permissions: ReposReplaceProtectedBranchAppRestrictionsResponseItemPermissions;
    slug: string;
    updated_at: string;
};
declare type ReposRemoveProtectedBranchUserRestrictionsResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposRemoveProtectedBranchTeamRestrictionsResponseItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
};
declare type ReposRemoveProtectedBranchAppRestrictionsResponseItemPermissions = {
    contents: string;
    issues: string;
    metadata: string;
    single_file: string;
};
declare type ReposRemoveProtectedBranchAppRestrictionsResponseItemOwner = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
};
declare type ReposRemoveProtectedBranchAppRestrictionsResponseItem = {
    created_at: string;
    description: string;
    events: Array<string>;
    external_url: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    owner: ReposRemoveProtectedBranchAppRestrictionsResponseItemOwner;
    permissions: ReposRemoveProtectedBranchAppRestrictionsResponseItemPermissions;
    slug: string;
    updated_at: string;
};
declare type ReposMergeResponseParentsItem = {
    sha: string;
    url: string;
};
declare type ReposMergeResponseCommitter = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposMergeResponseCommitVerification = {
    payload: null;
    reason: string;
    signature: null;
    verified: boolean;
};
declare type ReposMergeResponseCommitTree = {
    sha: string;
    url: string;
};
declare type ReposMergeResponseCommitCommitter = {
    date: string;
    email: string;
    name: string;
};
declare type ReposMergeResponseCommitAuthor = {
    date: string;
    email: string;
    name: string;
};
declare type ReposMergeResponseCommit = {
    author: ReposMergeResponseCommitAuthor;
    comment_count: number;
    committer: ReposMergeResponseCommitCommitter;
    message: string;
    tree: ReposMergeResponseCommitTree;
    url: string;
    verification: ReposMergeResponseCommitVerification;
};
declare type ReposMergeResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposMergeResponse = {
    author: ReposMergeResponseAuthor;
    comments_url: string;
    commit: ReposMergeResponseCommit;
    committer: ReposMergeResponseCommitter;
    html_url: string;
    node_id: string;
    parents: Array<ReposMergeResponseParentsItem>;
    sha: string;
    url: string;
};
declare type ReposListUsersWithAccessToProtectedBranchResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposListTopicsResponse = {
    names: Array<string>;
};
declare type ReposListTeamsWithAccessToProtectedBranchResponseItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
};
declare type ReposListTeamsResponseItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
};
declare type ReposListTagsResponseItemCommit = {
    sha: string;
    url: string;
};
declare type ReposListTagsResponseItem = {
    commit: ReposListTagsResponseItemCommit;
    name: string;
    tarball_url: string;
    zipball_url: string;
};
declare type ReposListStatusesForRefResponseItemCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposListStatusesForRefResponseItem = {
    avatar_url: string;
    context: string;
    created_at: string;
    creator: ReposListStatusesForRefResponseItemCreator;
    description: string;
    id: number;
    node_id: string;
    state: string;
    target_url: string;
    updated_at: string;
    url: string;
};
declare type ReposListReleasesResponseItemAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposListReleasesResponseItemAssetsItemUploader = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposListReleasesResponseItemAssetsItem = {
    browser_download_url: string;
    content_type: string;
    created_at: string;
    download_count: number;
    id: number;
    label: string;
    name: string;
    node_id: string;
    size: number;
    state: string;
    updated_at: string;
    uploader: ReposListReleasesResponseItemAssetsItemUploader;
    url: string;
};
declare type ReposListReleasesResponseItem = {
    assets: Array<ReposListReleasesResponseItemAssetsItem>;
    assets_url: string;
    author: ReposListReleasesResponseItemAuthor;
    body: string;
    created_at: string;
    draft: boolean;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    prerelease: boolean;
    published_at: string;
    tag_name: string;
    tarball_url: string;
    target_commitish: string;
    upload_url: string;
    url: string;
    zipball_url: string;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseItemRequestedTeamsItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseItemRequestedReviewersItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseItemMilestoneCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseItemMilestone = {
    closed_at: string;
    closed_issues: number;
    created_at: string;
    creator: ReposListPullRequestsAssociatedWithCommitResponseItemMilestoneCreator;
    description: string;
    due_on: string;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    number: number;
    open_issues: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseItemLabelsItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseItemHeadUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseItemHeadRepoPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseItemHeadRepoOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseItemHeadRepo = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: ReposListPullRequestsAssociatedWithCommitResponseItemHeadRepoOwner;
    permissions: ReposListPullRequestsAssociatedWithCommitResponseItemHeadRepoPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseItemHead = {
    label: string;
    ref: string;
    repo: ReposListPullRequestsAssociatedWithCommitResponseItemHeadRepo;
    sha: string;
    user: ReposListPullRequestsAssociatedWithCommitResponseItemHeadUser;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseItemBaseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseItemBaseRepoPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseItemBaseRepoOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseItemBaseRepo = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: ReposListPullRequestsAssociatedWithCommitResponseItemBaseRepoOwner;
    permissions: ReposListPullRequestsAssociatedWithCommitResponseItemBaseRepoPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseItemBase = {
    label: string;
    ref: string;
    repo: ReposListPullRequestsAssociatedWithCommitResponseItemBaseRepo;
    sha: string;
    user: ReposListPullRequestsAssociatedWithCommitResponseItemBaseUser;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseItemAssigneesItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseItemAssignee = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseItemLinksStatuses = {
    href: string;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseItemLinksSelf = {
    href: string;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseItemLinksReviewComments = {
    href: string;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseItemLinksReviewComment = {
    href: string;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseItemLinksIssue = {
    href: string;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseItemLinksHtml = {
    href: string;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseItemLinksCommits = {
    href: string;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseItemLinksComments = {
    href: string;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseItemLinks = {
    comments: ReposListPullRequestsAssociatedWithCommitResponseItemLinksComments;
    commits: ReposListPullRequestsAssociatedWithCommitResponseItemLinksCommits;
    html: ReposListPullRequestsAssociatedWithCommitResponseItemLinksHtml;
    issue: ReposListPullRequestsAssociatedWithCommitResponseItemLinksIssue;
    review_comment: ReposListPullRequestsAssociatedWithCommitResponseItemLinksReviewComment;
    review_comments: ReposListPullRequestsAssociatedWithCommitResponseItemLinksReviewComments;
    self: ReposListPullRequestsAssociatedWithCommitResponseItemLinksSelf;
    statuses: ReposListPullRequestsAssociatedWithCommitResponseItemLinksStatuses;
};
declare type ReposListPullRequestsAssociatedWithCommitResponseItem = {
    _links: ReposListPullRequestsAssociatedWithCommitResponseItemLinks;
    active_lock_reason: string;
    assignee: ReposListPullRequestsAssociatedWithCommitResponseItemAssignee;
    assignees: Array<ReposListPullRequestsAssociatedWithCommitResponseItemAssigneesItem>;
    author_association: string;
    base: ReposListPullRequestsAssociatedWithCommitResponseItemBase;
    body: string;
    closed_at: string;
    comments_url: string;
    commits_url: string;
    created_at: string;
    diff_url: string;
    draft: boolean;
    head: ReposListPullRequestsAssociatedWithCommitResponseItemHead;
    html_url: string;
    id: number;
    issue_url: string;
    labels: Array<ReposListPullRequestsAssociatedWithCommitResponseItemLabelsItem>;
    locked: boolean;
    merge_commit_sha: string;
    merged_at: string;
    milestone: ReposListPullRequestsAssociatedWithCommitResponseItemMilestone;
    node_id: string;
    number: number;
    patch_url: string;
    requested_reviewers: Array<ReposListPullRequestsAssociatedWithCommitResponseItemRequestedReviewersItem>;
    requested_teams: Array<ReposListPullRequestsAssociatedWithCommitResponseItemRequestedTeamsItem>;
    review_comment_url: string;
    review_comments_url: string;
    state: string;
    statuses_url: string;
    title: string;
    updated_at: string;
    url: string;
    user: ReposListPullRequestsAssociatedWithCommitResponseItemUser;
};
declare type ReposListPublicResponseItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposListPublicResponseItem = {
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    description: string;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    html_url: string;
    id: number;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    name: string;
    node_id: string;
    notifications_url: string;
    owner: ReposListPublicResponseItemOwner;
    private: boolean;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    url: string;
};
declare type ReposListProtectedBranchUserRestrictionsResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposListProtectedBranchTeamRestrictionsResponseItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
};
declare type ReposListPagesBuildsResponseItemPusher = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposListPagesBuildsResponseItemError = {
    message: null;
};
declare type ReposListPagesBuildsResponseItem = {
    commit: string;
    created_at: string;
    duration: number;
    error: ReposListPagesBuildsResponseItemError;
    pusher: ReposListPagesBuildsResponseItemPusher;
    status: string;
    updated_at: string;
    url: string;
};
declare type ReposListLanguagesResponse = {
    C: number;
    Python: number;
};
declare type ReposListInvitationsForAuthenticatedUserResponseItemRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposListInvitationsForAuthenticatedUserResponseItemRepository = {
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    description: string;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    html_url: string;
    id: number;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    name: string;
    node_id: string;
    notifications_url: string;
    owner: ReposListInvitationsForAuthenticatedUserResponseItemRepositoryOwner;
    private: boolean;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    url: string;
};
declare type ReposListInvitationsForAuthenticatedUserResponseItemInviter = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposListInvitationsForAuthenticatedUserResponseItemInvitee = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposListInvitationsForAuthenticatedUserResponseItem = {
    created_at: string;
    html_url: string;
    id: number;
    invitee: ReposListInvitationsForAuthenticatedUserResponseItemInvitee;
    inviter: ReposListInvitationsForAuthenticatedUserResponseItemInviter;
    permissions: string;
    repository: ReposListInvitationsForAuthenticatedUserResponseItemRepository;
    url: string;
};
declare type ReposListInvitationsResponseItemRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposListInvitationsResponseItemRepository = {
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    description: string;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    html_url: string;
    id: number;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    name: string;
    node_id: string;
    notifications_url: string;
    owner: ReposListInvitationsResponseItemRepositoryOwner;
    private: boolean;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    url: string;
};
declare type ReposListInvitationsResponseItemInviter = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposListInvitationsResponseItemInvitee = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposListInvitationsResponseItem = {
    created_at: string;
    html_url: string;
    id: number;
    invitee: ReposListInvitationsResponseItemInvitee;
    inviter: ReposListInvitationsResponseItemInviter;
    permissions: string;
    repository: ReposListInvitationsResponseItemRepository;
    url: string;
};
declare type ReposListHooksResponseItemLastResponse = {
    code: null;
    message: null;
    status: string;
};
declare type ReposListHooksResponseItemConfig = {
    content_type: string;
    insecure_ssl: string;
    url: string;
};
declare type ReposListHooksResponseItem = {
    active: boolean;
    config: ReposListHooksResponseItemConfig;
    created_at: string;
    events: Array<string>;
    id: number;
    last_response: ReposListHooksResponseItemLastResponse;
    name: string;
    ping_url: string;
    test_url: string;
    type: string;
    updated_at: string;
    url: string;
};
declare type ReposListForksResponseItemPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type ReposListForksResponseItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposListForksResponseItemLicense = {
    key: string;
    name: string;
    node_id: string;
    spdx_id: string;
    url: string;
};
declare type ReposListForksResponseItem = {
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    license: ReposListForksResponseItemLicense;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: ReposListForksResponseItemOwner;
    permissions: ReposListForksResponseItemPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type ReposListForOrgResponseItemPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type ReposListForOrgResponseItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposListForOrgResponseItemLicense = {
    key: string;
    name: string;
    node_id: string;
    spdx_id: string;
    url: string;
};
declare type ReposListForOrgResponseItem = {
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    license: ReposListForOrgResponseItemLicense;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: ReposListForOrgResponseItemOwner;
    permissions: ReposListForOrgResponseItemPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type ReposListDownloadsResponseItem = {
    content_type: string;
    description: string;
    download_count: number;
    html_url: string;
    id: number;
    name: string;
    size: number;
    url: string;
};
declare type ReposListDeploymentsResponseItemPayload = {
    deploy: string;
};
declare type ReposListDeploymentsResponseItemCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposListDeploymentsResponseItem = {
    created_at: string;
    creator: ReposListDeploymentsResponseItemCreator;
    description: string;
    environment: string;
    id: number;
    node_id: string;
    original_environment: string;
    payload: ReposListDeploymentsResponseItemPayload;
    production_environment: boolean;
    ref: string;
    repository_url: string;
    sha: string;
    statuses_url: string;
    task: string;
    transient_environment: boolean;
    updated_at: string;
    url: string;
};
declare type ReposListDeploymentStatusesResponseItemCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposListDeploymentStatusesResponseItem = {
    created_at: string;
    creator: ReposListDeploymentStatusesResponseItemCreator;
    deployment_url: string;
    description: string;
    environment: string;
    environment_url: string;
    id: number;
    log_url: string;
    node_id: string;
    repository_url: string;
    state: string;
    target_url: string;
    updated_at: string;
    url: string;
};
declare type ReposListDeployKeysResponseItem = {
    created_at: string;
    id: number;
    key: string;
    read_only: boolean;
    title: string;
    url: string;
    verified: boolean;
};
declare type ReposListContributorsResponseItem = {
    avatar_url: string;
    contributions: number;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposListCommitsResponseItemParentsItem = {
    sha: string;
    url: string;
};
declare type ReposListCommitsResponseItemCommitter = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposListCommitsResponseItemCommitVerification = {
    payload: null;
    reason: string;
    signature: null;
    verified: boolean;
};
declare type ReposListCommitsResponseItemCommitTree = {
    sha: string;
    url: string;
};
declare type ReposListCommitsResponseItemCommitCommitter = {
    date: string;
    email: string;
    name: string;
};
declare type ReposListCommitsResponseItemCommitAuthor = {
    date: string;
    email: string;
    name: string;
};
declare type ReposListCommitsResponseItemCommit = {
    author: ReposListCommitsResponseItemCommitAuthor;
    comment_count: number;
    committer: ReposListCommitsResponseItemCommitCommitter;
    message: string;
    tree: ReposListCommitsResponseItemCommitTree;
    url: string;
    verification: ReposListCommitsResponseItemCommitVerification;
};
declare type ReposListCommitsResponseItemAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposListCommitsResponseItem = {
    author: ReposListCommitsResponseItemAuthor;
    comments_url: string;
    commit: ReposListCommitsResponseItemCommit;
    committer: ReposListCommitsResponseItemCommitter;
    html_url: string;
    node_id: string;
    parents: Array<ReposListCommitsResponseItemParentsItem>;
    sha: string;
    url: string;
};
declare type ReposListCommitCommentsResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposListCommitCommentsResponseItem = {
    body: string;
    commit_id: string;
    created_at: string;
    html_url: string;
    id: number;
    line: number;
    node_id: string;
    path: string;
    position: number;
    updated_at: string;
    url: string;
    user: ReposListCommitCommentsResponseItemUser;
};
declare type ReposListCommentsForCommitResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposListCommentsForCommitResponseItem = {
    body: string;
    commit_id: string;
    created_at: string;
    html_url: string;
    id: number;
    line: number;
    node_id: string;
    path: string;
    position: number;
    updated_at: string;
    url: string;
    user: ReposListCommentsForCommitResponseItemUser;
};
declare type ReposListCollaboratorsResponseItemPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type ReposListCollaboratorsResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    permissions: ReposListCollaboratorsResponseItemPermissions;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposListBranchesForHeadCommitResponseItemCommit = {
    sha: string;
    url: string;
};
declare type ReposListBranchesForHeadCommitResponseItem = {
    commit: ReposListBranchesForHeadCommitResponseItemCommit;
    name: string;
    protected: string;
};
declare type ReposListBranchesResponseItemProtectionRequiredStatusChecks = {
    contexts: Array<string>;
    enforcement_level: string;
};
declare type ReposListBranchesResponseItemProtection = {
    enabled: boolean;
    required_status_checks: ReposListBranchesResponseItemProtectionRequiredStatusChecks;
};
declare type ReposListBranchesResponseItemCommit = {
    sha: string;
    url: string;
};
declare type ReposListBranchesResponseItem = {
    commit: ReposListBranchesResponseItemCommit;
    name: string;
    protected: boolean;
    protection: ReposListBranchesResponseItemProtection;
    protection_url: string;
};
declare type ReposListAssetsForReleaseResponseItemUploader = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposListAssetsForReleaseResponseItem = {
    browser_download_url: string;
    content_type: string;
    created_at: string;
    download_count: number;
    id: number;
    label: string;
    name: string;
    node_id: string;
    size: number;
    state: string;
    updated_at: string;
    uploader: ReposListAssetsForReleaseResponseItemUploader;
    url: string;
};
declare type ReposListAppsWithAccessToProtectedBranchResponseItemPermissions = {
    contents: string;
    issues: string;
    metadata: string;
    single_file: string;
};
declare type ReposListAppsWithAccessToProtectedBranchResponseItemOwner = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
};
declare type ReposListAppsWithAccessToProtectedBranchResponseItem = {
    created_at: string;
    description: string;
    events: Array<string>;
    external_url: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    owner: ReposListAppsWithAccessToProtectedBranchResponseItemOwner;
    permissions: ReposListAppsWithAccessToProtectedBranchResponseItemPermissions;
    slug: string;
    updated_at: string;
};
declare type ReposGetViewsResponseViewsItem = {
    count: number;
    timestamp: string;
    uniques: number;
};
declare type ReposGetViewsResponse = {
    count: number;
    uniques: number;
    views: Array<ReposGetViewsResponseViewsItem>;
};
declare type ReposGetUsersWithAccessToProtectedBranchResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposGetTopReferrersResponseItem = {
    count: number;
    referrer: string;
    uniques: number;
};
declare type ReposGetTopPathsResponseItem = {
    count: number;
    path: string;
    title: string;
    uniques: number;
};
declare type ReposGetTeamsWithAccessToProtectedBranchResponseItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
};
declare type ReposGetReleaseByTagResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposGetReleaseByTagResponseAssetsItemUploader = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposGetReleaseByTagResponseAssetsItem = {
    browser_download_url: string;
    content_type: string;
    created_at: string;
    download_count: number;
    id: number;
    label: string;
    name: string;
    node_id: string;
    size: number;
    state: string;
    updated_at: string;
    uploader: ReposGetReleaseByTagResponseAssetsItemUploader;
    url: string;
};
declare type ReposGetReleaseByTagResponse = {
    assets: Array<ReposGetReleaseByTagResponseAssetsItem>;
    assets_url: string;
    author: ReposGetReleaseByTagResponseAuthor;
    body: string;
    created_at: string;
    draft: boolean;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    prerelease: boolean;
    published_at: string;
    tag_name: string;
    tarball_url: string;
    target_commitish: string;
    upload_url: string;
    url: string;
    zipball_url: string;
};
declare type ReposGetReleaseAssetResponseUploader = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposGetReleaseAssetResponse = {
    browser_download_url: string;
    content_type: string;
    created_at: string;
    download_count: number;
    id: number;
    label: string;
    name: string;
    node_id: string;
    size: number;
    state: string;
    updated_at: string;
    uploader: ReposGetReleaseAssetResponseUploader;
    url: string;
};
declare type ReposGetReleaseResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposGetReleaseResponseAssetsItemUploader = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposGetReleaseResponseAssetsItem = {
    browser_download_url: string;
    content_type: string;
    created_at: string;
    download_count: number;
    id: number;
    label: string;
    name: string;
    node_id: string;
    size: number;
    state: string;
    updated_at: string;
    uploader: ReposGetReleaseResponseAssetsItemUploader;
    url: string;
};
declare type ReposGetReleaseResponse = {
    assets: Array<ReposGetReleaseResponseAssetsItem>;
    assets_url: string;
    author: ReposGetReleaseResponseAuthor;
    body: string;
    created_at: string;
    draft: boolean;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    prerelease: boolean;
    published_at: string;
    tag_name: string;
    tarball_url: string;
    target_commitish: string;
    upload_url: string;
    url: string;
    zipball_url: string;
};
declare type ReposGetReadmeResponseLinks = {
    git: string;
    html: string;
    self: string;
};
declare type ReposGetReadmeResponse = {
    _links: ReposGetReadmeResponseLinks;
    content: string;
    download_url: string;
    encoding: string;
    git_url: string;
    html_url: string;
    name: string;
    path: string;
    sha: string;
    size: number;
    type: string;
    url: string;
};
declare type ReposGetProtectedBranchRestrictionsResponseUsersItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposGetProtectedBranchRestrictionsResponseTeamsItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
};
declare type ReposGetProtectedBranchRestrictionsResponseAppsItemPermissions = {
    contents: string;
    issues: string;
    metadata: string;
    single_file: string;
};
declare type ReposGetProtectedBranchRestrictionsResponseAppsItemOwner = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
};
declare type ReposGetProtectedBranchRestrictionsResponseAppsItem = {
    created_at: string;
    description: string;
    events: Array<string>;
    external_url: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    owner: ReposGetProtectedBranchRestrictionsResponseAppsItemOwner;
    permissions: ReposGetProtectedBranchRestrictionsResponseAppsItemPermissions;
    slug: string;
    updated_at: string;
};
declare type ReposGetProtectedBranchRestrictionsResponse = {
    apps: Array<ReposGetProtectedBranchRestrictionsResponseAppsItem>;
    apps_url: string;
    teams: Array<ReposGetProtectedBranchRestrictionsResponseTeamsItem>;
    teams_url: string;
    url: string;
    users: Array<ReposGetProtectedBranchRestrictionsResponseUsersItem>;
    users_url: string;
};
declare type ReposGetProtectedBranchRequiredStatusChecksResponse = {
    contexts: Array<string>;
    contexts_url: string;
    strict: boolean;
    url: string;
};
declare type ReposGetProtectedBranchRequiredSignaturesResponse = {
    enabled: boolean;
    url: string;
};
declare type ReposGetProtectedBranchPullRequestReviewEnforcementResponseDismissalRestrictionsUsersItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposGetProtectedBranchPullRequestReviewEnforcementResponseDismissalRestrictionsTeamsItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
};
declare type ReposGetProtectedBranchPullRequestReviewEnforcementResponseDismissalRestrictions = {
    teams: Array<ReposGetProtectedBranchPullRequestReviewEnforcementResponseDismissalRestrictionsTeamsItem>;
    teams_url: string;
    url: string;
    users: Array<ReposGetProtectedBranchPullRequestReviewEnforcementResponseDismissalRestrictionsUsersItem>;
    users_url: string;
};
declare type ReposGetProtectedBranchPullRequestReviewEnforcementResponse = {
    dismiss_stale_reviews: boolean;
    dismissal_restrictions: ReposGetProtectedBranchPullRequestReviewEnforcementResponseDismissalRestrictions;
    require_code_owner_reviews: boolean;
    required_approving_review_count: number;
    url: string;
};
declare type ReposGetProtectedBranchAdminEnforcementResponse = {
    enabled: boolean;
    url: string;
};
declare type ReposGetParticipationStatsResponse = {
    all: Array<number>;
    owner: Array<number>;
};
declare type ReposGetPagesBuildResponsePusher = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposGetPagesBuildResponseError = {
    message: null;
};
declare type ReposGetPagesBuildResponse = {
    commit: string;
    created_at: string;
    duration: number;
    error: ReposGetPagesBuildResponseError;
    pusher: ReposGetPagesBuildResponsePusher;
    status: string;
    updated_at: string;
    url: string;
};
declare type ReposGetPagesResponseSource = {
    branch: string;
    directory: string;
};
declare type ReposGetPagesResponse = {
    cname: string;
    custom_404: boolean;
    html_url: string;
    source: ReposGetPagesResponseSource;
    status: string;
    url: string;
};
declare type ReposGetLatestReleaseResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposGetLatestReleaseResponseAssetsItemUploader = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposGetLatestReleaseResponseAssetsItem = {
    browser_download_url: string;
    content_type: string;
    created_at: string;
    download_count: number;
    id: number;
    label: string;
    name: string;
    node_id: string;
    size: number;
    state: string;
    updated_at: string;
    uploader: ReposGetLatestReleaseResponseAssetsItemUploader;
    url: string;
};
declare type ReposGetLatestReleaseResponse = {
    assets: Array<ReposGetLatestReleaseResponseAssetsItem>;
    assets_url: string;
    author: ReposGetLatestReleaseResponseAuthor;
    body: string;
    created_at: string;
    draft: boolean;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    prerelease: boolean;
    published_at: string;
    tag_name: string;
    tarball_url: string;
    target_commitish: string;
    upload_url: string;
    url: string;
    zipball_url: string;
};
declare type ReposGetLatestPagesBuildResponsePusher = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposGetLatestPagesBuildResponseError = {
    message: null;
};
declare type ReposGetLatestPagesBuildResponse = {
    commit: string;
    created_at: string;
    duration: number;
    error: ReposGetLatestPagesBuildResponseError;
    pusher: ReposGetLatestPagesBuildResponsePusher;
    status: string;
    updated_at: string;
    url: string;
};
declare type ReposGetHookResponseLastResponse = {
    code: null;
    message: null;
    status: string;
};
declare type ReposGetHookResponseConfig = {
    content_type: string;
    insecure_ssl: string;
    url: string;
};
declare type ReposGetHookResponse = {
    active: boolean;
    config: ReposGetHookResponseConfig;
    created_at: string;
    events: Array<string>;
    id: number;
    last_response: ReposGetHookResponseLastResponse;
    name: string;
    ping_url: string;
    test_url: string;
    type: string;
    updated_at: string;
    url: string;
};
declare type ReposGetDownloadResponse = {
    content_type: string;
    description: string;
    download_count: number;
    html_url: string;
    id: number;
    name: string;
    size: number;
    url: string;
};
declare type ReposGetDeploymentStatusResponseCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposGetDeploymentStatusResponse = {
    created_at: string;
    creator: ReposGetDeploymentStatusResponseCreator;
    deployment_url: string;
    description: string;
    environment: string;
    environment_url: string;
    id: number;
    log_url: string;
    node_id: string;
    repository_url: string;
    state: string;
    target_url: string;
    updated_at: string;
    url: string;
};
declare type ReposGetDeploymentResponsePayload = {
    deploy: string;
};
declare type ReposGetDeploymentResponseCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposGetDeploymentResponse = {
    created_at: string;
    creator: ReposGetDeploymentResponseCreator;
    description: string;
    environment: string;
    id: number;
    node_id: string;
    original_environment: string;
    payload: ReposGetDeploymentResponsePayload;
    production_environment: boolean;
    ref: string;
    repository_url: string;
    sha: string;
    statuses_url: string;
    task: string;
    transient_environment: boolean;
    updated_at: string;
    url: string;
};
declare type ReposGetDeployKeyResponse = {
    created_at: string;
    id: number;
    key: string;
    read_only: boolean;
    title: string;
    url: string;
    verified: boolean;
};
declare type ReposGetContributorsStatsResponseItemWeeksItem = {
    a: number;
    c: number;
    d: number;
    w: string;
};
declare type ReposGetContributorsStatsResponseItemAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposGetContributorsStatsResponseItem = {
    author: ReposGetContributorsStatsResponseItemAuthor;
    total: number;
    weeks: Array<ReposGetContributorsStatsResponseItemWeeksItem>;
};
declare type ReposGetContentsResponseItemLinks = {
    git: string;
    html: string;
    self: string;
};
declare type ReposGetContentsResponseItem = {
    _links: ReposGetContentsResponseItemLinks;
    download_url: string | null;
    git_url: string;
    html_url: string;
    name: string;
    path: string;
    sha: string;
    size: number;
    type: string;
    url: string;
};
declare type ReposGetContentsResponseLinks = {
    git: string;
    html: string;
    self: string;
};
declare type ReposGetContentsResponse = {
    _links: ReposGetContentsResponseLinks;
    content?: string;
    download_url: string | null;
    encoding?: string;
    git_url: string;
    html_url: string;
    name: string;
    path: string;
    sha: string;
    size: number;
    type: string;
    url: string;
    target?: string;
    submodule_git_url?: string;
} | Array<ReposGetContentsResponseItem>;
declare type ReposGetCommitCommentResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposGetCommitCommentResponse = {
    body: string;
    commit_id: string;
    created_at: string;
    html_url: string;
    id: number;
    line: number;
    node_id: string;
    path: string;
    position: number;
    updated_at: string;
    url: string;
    user: ReposGetCommitCommentResponseUser;
};
declare type ReposGetCommitActivityStatsResponseItem = {
    days: Array<number>;
    total: number;
    week: number;
};
declare type ReposGetCommitResponseStats = {
    additions: number;
    deletions: number;
    total: number;
};
declare type ReposGetCommitResponseParentsItem = {
    sha: string;
    url: string;
};
declare type ReposGetCommitResponseFilesItem = {
    additions: number;
    blob_url: string;
    changes: number;
    deletions: number;
    filename: string;
    patch: string;
    raw_url: string;
    status: string;
};
declare type ReposGetCommitResponseCommitter = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposGetCommitResponseCommitVerification = {
    payload: null;
    reason: string;
    signature: null;
    verified: boolean;
};
declare type ReposGetCommitResponseCommitTree = {
    sha: string;
    url: string;
};
declare type ReposGetCommitResponseCommitCommitter = {
    date: string;
    email: string;
    name: string;
};
declare type ReposGetCommitResponseCommitAuthor = {
    date: string;
    email: string;
    name: string;
};
declare type ReposGetCommitResponseCommit = {
    author: ReposGetCommitResponseCommitAuthor;
    comment_count: number;
    committer: ReposGetCommitResponseCommitCommitter;
    message: string;
    tree: ReposGetCommitResponseCommitTree;
    url: string;
    verification: ReposGetCommitResponseCommitVerification;
};
declare type ReposGetCommitResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposGetCommitResponse = {
    author: ReposGetCommitResponseAuthor;
    comments_url: string;
    commit: ReposGetCommitResponseCommit;
    committer: ReposGetCommitResponseCommitter;
    files: Array<ReposGetCommitResponseFilesItem>;
    html_url: string;
    node_id: string;
    parents: Array<ReposGetCommitResponseParentsItem>;
    sha: string;
    stats: ReposGetCommitResponseStats;
    url: string;
};
declare type ReposGetCombinedStatusForRefResponseStatusesItem = {
    avatar_url: string;
    context: string;
    created_at: string;
    description: string;
    id: number;
    node_id: string;
    state: string;
    target_url: string;
    updated_at: string;
    url: string;
};
declare type ReposGetCombinedStatusForRefResponseRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposGetCombinedStatusForRefResponseRepository = {
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    description: string;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    html_url: string;
    id: number;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    name: string;
    node_id: string;
    notifications_url: string;
    owner: ReposGetCombinedStatusForRefResponseRepositoryOwner;
    private: boolean;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    url: string;
};
declare type ReposGetCombinedStatusForRefResponse = {
    commit_url: string;
    repository: ReposGetCombinedStatusForRefResponseRepository;
    sha: string;
    state: string;
    statuses: Array<ReposGetCombinedStatusForRefResponseStatusesItem>;
    total_count: number;
    url: string;
};
declare type ReposGetCollaboratorPermissionLevelResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposGetCollaboratorPermissionLevelResponse = {
    permission: string;
    user: ReposGetCollaboratorPermissionLevelResponseUser;
};
declare type ReposGetClonesResponseClonesItem = {
    count: number;
    timestamp: string;
    uniques: number;
};
declare type ReposGetClonesResponse = {
    clones: Array<ReposGetClonesResponseClonesItem>;
    count: number;
    uniques: number;
};
declare type ReposGetBranchProtectionResponseRestrictionsUsersItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposGetBranchProtectionResponseRestrictionsTeamsItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
};
declare type ReposGetBranchProtectionResponseRestrictionsAppsItemPermissions = {
    contents: string;
    issues: string;
    metadata: string;
    single_file: string;
};
declare type ReposGetBranchProtectionResponseRestrictionsAppsItemOwner = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
};
declare type ReposGetBranchProtectionResponseRestrictionsAppsItem = {
    created_at: string;
    description: string;
    events: Array<string>;
    external_url: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    owner: ReposGetBranchProtectionResponseRestrictionsAppsItemOwner;
    permissions: ReposGetBranchProtectionResponseRestrictionsAppsItemPermissions;
    slug: string;
    updated_at: string;
};
declare type ReposGetBranchProtectionResponseRestrictions = {
    apps: Array<ReposGetBranchProtectionResponseRestrictionsAppsItem>;
    apps_url: string;
    teams: Array<ReposGetBranchProtectionResponseRestrictionsTeamsItem>;
    teams_url: string;
    url: string;
    users: Array<ReposGetBranchProtectionResponseRestrictionsUsersItem>;
    users_url: string;
};
declare type ReposGetBranchProtectionResponseRequiredStatusChecks = {
    contexts: Array<string>;
    contexts_url: string;
    strict: boolean;
    url: string;
};
declare type ReposGetBranchProtectionResponseRequiredPullRequestReviewsDismissalRestrictionsUsersItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposGetBranchProtectionResponseRequiredPullRequestReviewsDismissalRestrictionsTeamsItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
};
declare type ReposGetBranchProtectionResponseRequiredPullRequestReviewsDismissalRestrictions = {
    teams: Array<ReposGetBranchProtectionResponseRequiredPullRequestReviewsDismissalRestrictionsTeamsItem>;
    teams_url: string;
    url: string;
    users: Array<ReposGetBranchProtectionResponseRequiredPullRequestReviewsDismissalRestrictionsUsersItem>;
    users_url: string;
};
declare type ReposGetBranchProtectionResponseRequiredPullRequestReviews = {
    dismiss_stale_reviews: boolean;
    dismissal_restrictions: ReposGetBranchProtectionResponseRequiredPullRequestReviewsDismissalRestrictions;
    require_code_owner_reviews: boolean;
    required_approving_review_count: number;
    url: string;
};
declare type ReposGetBranchProtectionResponseRequiredLinearHistory = {
    enabled: boolean;
};
declare type ReposGetBranchProtectionResponseEnforceAdmins = {
    enabled: boolean;
    url: string;
};
declare type ReposGetBranchProtectionResponseAllowForcePushes = {
    enabled: boolean;
};
declare type ReposGetBranchProtectionResponseAllowDeletions = {
    enabled: boolean;
};
declare type ReposGetBranchProtectionResponse = {
    allow_deletions: ReposGetBranchProtectionResponseAllowDeletions;
    allow_force_pushes: ReposGetBranchProtectionResponseAllowForcePushes;
    enforce_admins: ReposGetBranchProtectionResponseEnforceAdmins;
    required_linear_history: ReposGetBranchProtectionResponseRequiredLinearHistory;
    required_pull_request_reviews: ReposGetBranchProtectionResponseRequiredPullRequestReviews;
    required_status_checks: ReposGetBranchProtectionResponseRequiredStatusChecks;
    restrictions: ReposGetBranchProtectionResponseRestrictions;
    url: string;
};
declare type ReposGetBranchResponseProtectionRequiredStatusChecks = {
    contexts: Array<string>;
    enforcement_level: string;
};
declare type ReposGetBranchResponseProtection = {
    enabled: boolean;
    required_status_checks: ReposGetBranchResponseProtectionRequiredStatusChecks;
};
declare type ReposGetBranchResponseCommitParentsItem = {
    sha: string;
    url: string;
};
declare type ReposGetBranchResponseCommitCommitter = {
    avatar_url: string;
    gravatar_id: string;
    id: number;
    login: string;
    url: string;
};
declare type ReposGetBranchResponseCommitCommitVerification = {
    payload: null;
    reason: string;
    signature: null;
    verified: boolean;
};
declare type ReposGetBranchResponseCommitCommitTree = {
    sha: string;
    url: string;
};
declare type ReposGetBranchResponseCommitCommitCommitter = {
    date: string;
    email: string;
    name: string;
};
declare type ReposGetBranchResponseCommitCommitAuthor = {
    date: string;
    email: string;
    name: string;
};
declare type ReposGetBranchResponseCommitCommit = {
    author: ReposGetBranchResponseCommitCommitAuthor;
    committer: ReposGetBranchResponseCommitCommitCommitter;
    message: string;
    tree: ReposGetBranchResponseCommitCommitTree;
    url: string;
    verification: ReposGetBranchResponseCommitCommitVerification;
};
declare type ReposGetBranchResponseCommitAuthor = {
    avatar_url: string;
    gravatar_id: string;
    id: number;
    login: string;
    url: string;
};
declare type ReposGetBranchResponseCommit = {
    author: ReposGetBranchResponseCommitAuthor;
    commit: ReposGetBranchResponseCommitCommit;
    committer: ReposGetBranchResponseCommitCommitter;
    node_id: string;
    parents: Array<ReposGetBranchResponseCommitParentsItem>;
    sha: string;
    url: string;
};
declare type ReposGetBranchResponseLinks = {
    html: string;
    self: string;
};
declare type ReposGetBranchResponse = {
    _links: ReposGetBranchResponseLinks;
    commit: ReposGetBranchResponseCommit;
    name: string;
    protected: boolean;
    protection: ReposGetBranchResponseProtection;
    protection_url: string;
};
declare type ReposGetAppsWithAccessToProtectedBranchResponseItemPermissions = {
    contents: string;
    issues: string;
    metadata: string;
    single_file: string;
};
declare type ReposGetAppsWithAccessToProtectedBranchResponseItemOwner = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
};
declare type ReposGetAppsWithAccessToProtectedBranchResponseItem = {
    created_at: string;
    description: string;
    events: Array<string>;
    external_url: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    owner: ReposGetAppsWithAccessToProtectedBranchResponseItemOwner;
    permissions: ReposGetAppsWithAccessToProtectedBranchResponseItemPermissions;
    slug: string;
    updated_at: string;
};
declare type ReposGetResponseSourcePermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type ReposGetResponseSourceOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposGetResponseSource = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: ReposGetResponseSourceOwner;
    permissions: ReposGetResponseSourcePermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type ReposGetResponsePermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type ReposGetResponseParentPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type ReposGetResponseParentOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposGetResponseParent = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: ReposGetResponseParentOwner;
    permissions: ReposGetResponseParentPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type ReposGetResponseOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposGetResponseOrganization = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposGetResponseLicense = {
    key: string;
    name: string;
    node_id: string;
    spdx_id: string;
    url: string;
};
declare type ReposGetResponse = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    license: ReposGetResponseLicense;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    organization: ReposGetResponseOrganization;
    owner: ReposGetResponseOwner;
    parent: ReposGetResponseParent;
    permissions: ReposGetResponsePermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    source: ReposGetResponseSource;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type ReposEnablePagesSiteResponseSource = {
    branch: string;
    directory: string;
};
declare type ReposEnablePagesSiteResponse = {
    cname: string;
    custom_404: boolean;
    html_url: string;
    source: ReposEnablePagesSiteResponseSource;
    status: string;
    url: string;
};
declare type ReposDeleteFileResponseCommitVerification = {
    payload: null;
    reason: string;
    signature: null;
    verified: boolean;
};
declare type ReposDeleteFileResponseCommitTree = {
    sha: string;
    url: string;
};
declare type ReposDeleteFileResponseCommitParentsItem = {
    html_url: string;
    sha: string;
    url: string;
};
declare type ReposDeleteFileResponseCommitCommitter = {
    date: string;
    email: string;
    name: string;
};
declare type ReposDeleteFileResponseCommitAuthor = {
    date: string;
    email: string;
    name: string;
};
declare type ReposDeleteFileResponseCommit = {
    author: ReposDeleteFileResponseCommitAuthor;
    committer: ReposDeleteFileResponseCommitCommitter;
    html_url: string;
    message: string;
    node_id: string;
    parents: Array<ReposDeleteFileResponseCommitParentsItem>;
    sha: string;
    tree: ReposDeleteFileResponseCommitTree;
    url: string;
    verification: ReposDeleteFileResponseCommitVerification;
};
declare type ReposDeleteFileResponse = {
    commit: ReposDeleteFileResponseCommit;
    content: null;
};
declare type ReposDeleteResponse = {
    documentation_url: string;
    message: string;
};
declare type ReposCreateUsingTemplateResponseTemplateRepositoryPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type ReposCreateUsingTemplateResponseTemplateRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposCreateUsingTemplateResponseTemplateRepository = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: ReposCreateUsingTemplateResponseTemplateRepositoryOwner;
    permissions: ReposCreateUsingTemplateResponseTemplateRepositoryPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type ReposCreateUsingTemplateResponsePermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type ReposCreateUsingTemplateResponseOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposCreateUsingTemplateResponse = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: ReposCreateUsingTemplateResponseOwner;
    permissions: ReposCreateUsingTemplateResponsePermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: ReposCreateUsingTemplateResponseTemplateRepository;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type ReposCreateStatusResponseCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposCreateStatusResponse = {
    avatar_url: string;
    context: string;
    created_at: string;
    creator: ReposCreateStatusResponseCreator;
    description: string;
    id: number;
    node_id: string;
    state: string;
    target_url: string;
    updated_at: string;
    url: string;
};
declare type ReposCreateReleaseResponseAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposCreateReleaseResponse = {
    assets: Array<any>;
    assets_url: string;
    author: ReposCreateReleaseResponseAuthor;
    body: string;
    created_at: string;
    draft: boolean;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    prerelease: boolean;
    published_at: string;
    tag_name: string;
    tarball_url: string;
    target_commitish: string;
    upload_url: string;
    url: string;
    zipball_url: string;
};
declare type ReposCreateOrUpdateFileResponseContentLinks = {
    git: string;
    html: string;
    self: string;
};
declare type ReposCreateOrUpdateFileResponseContent = {
    _links: ReposCreateOrUpdateFileResponseContentLinks;
    download_url: string;
    git_url: string;
    html_url: string;
    name: string;
    path: string;
    sha: string;
    size: number;
    type: string;
    url: string;
};
declare type ReposCreateOrUpdateFileResponseCommitVerification = {
    payload: null;
    reason: string;
    signature: null;
    verified: boolean;
};
declare type ReposCreateOrUpdateFileResponseCommitTree = {
    sha: string;
    url: string;
};
declare type ReposCreateOrUpdateFileResponseCommitParentsItem = {
    html_url: string;
    sha: string;
    url: string;
};
declare type ReposCreateOrUpdateFileResponseCommitCommitter = {
    date: string;
    email: string;
    name: string;
};
declare type ReposCreateOrUpdateFileResponseCommitAuthor = {
    date: string;
    email: string;
    name: string;
};
declare type ReposCreateOrUpdateFileResponseCommit = {
    author: ReposCreateOrUpdateFileResponseCommitAuthor;
    committer: ReposCreateOrUpdateFileResponseCommitCommitter;
    html_url: string;
    message: string;
    node_id: string;
    parents: Array<ReposCreateOrUpdateFileResponseCommitParentsItem>;
    sha: string;
    tree: ReposCreateOrUpdateFileResponseCommitTree;
    url: string;
    verification: ReposCreateOrUpdateFileResponseCommitVerification;
};
declare type ReposCreateOrUpdateFileResponse = {
    commit: ReposCreateOrUpdateFileResponseCommit;
    content: ReposCreateOrUpdateFileResponseContent;
};
declare type ReposCreateInOrgResponsePermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type ReposCreateInOrgResponseOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposCreateInOrgResponse = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: ReposCreateInOrgResponseOwner;
    permissions: ReposCreateInOrgResponsePermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type ReposCreateHookResponseLastResponse = {
    code: null;
    message: null;
    status: string;
};
declare type ReposCreateHookResponseConfig = {
    content_type: string;
    insecure_ssl: string;
    url: string;
};
declare type ReposCreateHookResponse = {
    active: boolean;
    config: ReposCreateHookResponseConfig;
    created_at: string;
    events: Array<string>;
    id: number;
    last_response: ReposCreateHookResponseLastResponse;
    name: string;
    ping_url: string;
    test_url: string;
    type: string;
    updated_at: string;
    url: string;
};
declare type ReposCreateForkResponsePermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type ReposCreateForkResponseOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposCreateForkResponse = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: ReposCreateForkResponseOwner;
    permissions: ReposCreateForkResponsePermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type ReposCreateForAuthenticatedUserResponsePermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type ReposCreateForAuthenticatedUserResponseOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposCreateForAuthenticatedUserResponse = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: ReposCreateForAuthenticatedUserResponseOwner;
    permissions: ReposCreateForAuthenticatedUserResponsePermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type ReposCreateFileResponseContentLinks = {
    git: string;
    html: string;
    self: string;
};
declare type ReposCreateFileResponseContent = {
    _links: ReposCreateFileResponseContentLinks;
    download_url: string;
    git_url: string;
    html_url: string;
    name: string;
    path: string;
    sha: string;
    size: number;
    type: string;
    url: string;
};
declare type ReposCreateFileResponseCommitVerification = {
    payload: null;
    reason: string;
    signature: null;
    verified: boolean;
};
declare type ReposCreateFileResponseCommitTree = {
    sha: string;
    url: string;
};
declare type ReposCreateFileResponseCommitParentsItem = {
    html_url: string;
    sha: string;
    url: string;
};
declare type ReposCreateFileResponseCommitCommitter = {
    date: string;
    email: string;
    name: string;
};
declare type ReposCreateFileResponseCommitAuthor = {
    date: string;
    email: string;
    name: string;
};
declare type ReposCreateFileResponseCommit = {
    author: ReposCreateFileResponseCommitAuthor;
    committer: ReposCreateFileResponseCommitCommitter;
    html_url: string;
    message: string;
    node_id: string;
    parents: Array<ReposCreateFileResponseCommitParentsItem>;
    sha: string;
    tree: ReposCreateFileResponseCommitTree;
    url: string;
    verification: ReposCreateFileResponseCommitVerification;
};
declare type ReposCreateFileResponse = {
    commit: ReposCreateFileResponseCommit;
    content: ReposCreateFileResponseContent;
};
declare type ReposCreateDeploymentStatusResponseCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposCreateDeploymentStatusResponse = {
    created_at: string;
    creator: ReposCreateDeploymentStatusResponseCreator;
    deployment_url: string;
    description: string;
    environment: string;
    environment_url: string;
    id: number;
    log_url: string;
    node_id: string;
    repository_url: string;
    state: string;
    target_url: string;
    updated_at: string;
    url: string;
};
declare type ReposCreateDeploymentResponsePayload = {
    deploy: string;
};
declare type ReposCreateDeploymentResponseCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposCreateDeploymentResponse = {
    created_at: string;
    creator: ReposCreateDeploymentResponseCreator;
    description: string;
    environment: string;
    id: number;
    node_id: string;
    original_environment: string;
    payload: ReposCreateDeploymentResponsePayload;
    production_environment: boolean;
    ref: string;
    repository_url: string;
    sha: string;
    statuses_url: string;
    task: string;
    transient_environment: boolean;
    updated_at: string;
    url: string;
};
declare type ReposCreateCommitCommentResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposCreateCommitCommentResponse = {
    body: string;
    commit_id: string;
    created_at: string;
    html_url: string;
    id: number;
    line: number;
    node_id: string;
    path: string;
    position: number;
    updated_at: string;
    url: string;
    user: ReposCreateCommitCommentResponseUser;
};
declare type ReposCompareCommitsResponseMergeBaseCommitParentsItem = {
    sha: string;
    url: string;
};
declare type ReposCompareCommitsResponseMergeBaseCommitCommitter = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposCompareCommitsResponseMergeBaseCommitCommitVerification = {
    payload: null;
    reason: string;
    signature: null;
    verified: boolean;
};
declare type ReposCompareCommitsResponseMergeBaseCommitCommitTree = {
    sha: string;
    url: string;
};
declare type ReposCompareCommitsResponseMergeBaseCommitCommitCommitter = {
    date: string;
    email: string;
    name: string;
};
declare type ReposCompareCommitsResponseMergeBaseCommitCommitAuthor = {
    date: string;
    email: string;
    name: string;
};
declare type ReposCompareCommitsResponseMergeBaseCommitCommit = {
    author: ReposCompareCommitsResponseMergeBaseCommitCommitAuthor;
    comment_count: number;
    committer: ReposCompareCommitsResponseMergeBaseCommitCommitCommitter;
    message: string;
    tree: ReposCompareCommitsResponseMergeBaseCommitCommitTree;
    url: string;
    verification: ReposCompareCommitsResponseMergeBaseCommitCommitVerification;
};
declare type ReposCompareCommitsResponseMergeBaseCommitAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposCompareCommitsResponseMergeBaseCommit = {
    author: ReposCompareCommitsResponseMergeBaseCommitAuthor;
    comments_url: string;
    commit: ReposCompareCommitsResponseMergeBaseCommitCommit;
    committer: ReposCompareCommitsResponseMergeBaseCommitCommitter;
    html_url: string;
    node_id: string;
    parents: Array<ReposCompareCommitsResponseMergeBaseCommitParentsItem>;
    sha: string;
    url: string;
};
declare type ReposCompareCommitsResponseFilesItem = {
    additions: number;
    blob_url: string;
    changes: number;
    contents_url: string;
    deletions: number;
    filename: string;
    patch: string;
    raw_url: string;
    sha: string;
    status: string;
};
declare type ReposCompareCommitsResponseCommitsItemParentsItem = {
    sha: string;
    url: string;
};
declare type ReposCompareCommitsResponseCommitsItemCommitter = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposCompareCommitsResponseCommitsItemCommitVerification = {
    payload: null;
    reason: string;
    signature: null;
    verified: boolean;
};
declare type ReposCompareCommitsResponseCommitsItemCommitTree = {
    sha: string;
    url: string;
};
declare type ReposCompareCommitsResponseCommitsItemCommitCommitter = {
    date: string;
    email: string;
    name: string;
};
declare type ReposCompareCommitsResponseCommitsItemCommitAuthor = {
    date: string;
    email: string;
    name: string;
};
declare type ReposCompareCommitsResponseCommitsItemCommit = {
    author: ReposCompareCommitsResponseCommitsItemCommitAuthor;
    comment_count: number;
    committer: ReposCompareCommitsResponseCommitsItemCommitCommitter;
    message: string;
    tree: ReposCompareCommitsResponseCommitsItemCommitTree;
    url: string;
    verification: ReposCompareCommitsResponseCommitsItemCommitVerification;
};
declare type ReposCompareCommitsResponseCommitsItemAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposCompareCommitsResponseCommitsItem = {
    author: ReposCompareCommitsResponseCommitsItemAuthor;
    comments_url: string;
    commit: ReposCompareCommitsResponseCommitsItemCommit;
    committer: ReposCompareCommitsResponseCommitsItemCommitter;
    html_url: string;
    node_id: string;
    parents: Array<ReposCompareCommitsResponseCommitsItemParentsItem>;
    sha: string;
    url: string;
};
declare type ReposCompareCommitsResponseBaseCommitParentsItem = {
    sha: string;
    url: string;
};
declare type ReposCompareCommitsResponseBaseCommitCommitter = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposCompareCommitsResponseBaseCommitCommitVerification = {
    payload: null;
    reason: string;
    signature: null;
    verified: boolean;
};
declare type ReposCompareCommitsResponseBaseCommitCommitTree = {
    sha: string;
    url: string;
};
declare type ReposCompareCommitsResponseBaseCommitCommitCommitter = {
    date: string;
    email: string;
    name: string;
};
declare type ReposCompareCommitsResponseBaseCommitCommitAuthor = {
    date: string;
    email: string;
    name: string;
};
declare type ReposCompareCommitsResponseBaseCommitCommit = {
    author: ReposCompareCommitsResponseBaseCommitCommitAuthor;
    comment_count: number;
    committer: ReposCompareCommitsResponseBaseCommitCommitCommitter;
    message: string;
    tree: ReposCompareCommitsResponseBaseCommitCommitTree;
    url: string;
    verification: ReposCompareCommitsResponseBaseCommitCommitVerification;
};
declare type ReposCompareCommitsResponseBaseCommitAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposCompareCommitsResponseBaseCommit = {
    author: ReposCompareCommitsResponseBaseCommitAuthor;
    comments_url: string;
    commit: ReposCompareCommitsResponseBaseCommitCommit;
    committer: ReposCompareCommitsResponseBaseCommitCommitter;
    html_url: string;
    node_id: string;
    parents: Array<ReposCompareCommitsResponseBaseCommitParentsItem>;
    sha: string;
    url: string;
};
declare type ReposCompareCommitsResponse = {
    ahead_by: number;
    base_commit: ReposCompareCommitsResponseBaseCommit;
    behind_by: number;
    commits: Array<ReposCompareCommitsResponseCommitsItem>;
    diff_url: string;
    files: Array<ReposCompareCommitsResponseFilesItem>;
    html_url: string;
    merge_base_commit: ReposCompareCommitsResponseMergeBaseCommit;
    patch_url: string;
    permalink_url: string;
    status: string;
    total_commits: number;
    url: string;
};
declare type ReposAddProtectedBranchUserRestrictionsResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposAddProtectedBranchTeamRestrictionsResponseItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
};
declare type ReposAddProtectedBranchRequiredSignaturesResponse = {
    enabled: boolean;
    url: string;
};
declare type ReposAddProtectedBranchAppRestrictionsResponseItemPermissions = {
    contents: string;
    issues: string;
    metadata: string;
    single_file: string;
};
declare type ReposAddProtectedBranchAppRestrictionsResponseItemOwner = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
};
declare type ReposAddProtectedBranchAppRestrictionsResponseItem = {
    created_at: string;
    description: string;
    events: Array<string>;
    external_url: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    owner: ReposAddProtectedBranchAppRestrictionsResponseItemOwner;
    permissions: ReposAddProtectedBranchAppRestrictionsResponseItemPermissions;
    slug: string;
    updated_at: string;
};
declare type ReposAddProtectedBranchAdminEnforcementResponse = {
    enabled: boolean;
    url: string;
};
declare type ReposAddDeployKeyResponse = {
    created_at: string;
    id: number;
    key: string;
    read_only: boolean;
    title: string;
    url: string;
    verified: boolean;
};
declare type ReposAddCollaboratorResponseRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposAddCollaboratorResponseRepository = {
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    description: string;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    html_url: string;
    id: number;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    name: string;
    node_id: string;
    notifications_url: string;
    owner: ReposAddCollaboratorResponseRepositoryOwner;
    private: boolean;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    url: string;
};
declare type ReposAddCollaboratorResponseInviter = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposAddCollaboratorResponseInvitee = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReposAddCollaboratorResponse = {
    created_at: string;
    html_url: string;
    id: number;
    invitee: ReposAddCollaboratorResponseInvitee;
    inviter: ReposAddCollaboratorResponseInviter;
    permissions: string;
    repository: ReposAddCollaboratorResponseRepository;
    url: string;
};
declare type ReactionsListForTeamDiscussionLegacyResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReactionsListForTeamDiscussionLegacyResponseItem = {
    content: string;
    created_at: string;
    id: number;
    node_id: string;
    user: ReactionsListForTeamDiscussionLegacyResponseItemUser;
};
declare type ReactionsListForTeamDiscussionInOrgResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReactionsListForTeamDiscussionInOrgResponseItem = {
    content: string;
    created_at: string;
    id: number;
    node_id: string;
    user: ReactionsListForTeamDiscussionInOrgResponseItemUser;
};
declare type ReactionsListForTeamDiscussionCommentLegacyResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReactionsListForTeamDiscussionCommentLegacyResponseItem = {
    content: string;
    created_at: string;
    id: number;
    node_id: string;
    user: ReactionsListForTeamDiscussionCommentLegacyResponseItemUser;
};
declare type ReactionsListForTeamDiscussionCommentInOrgResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReactionsListForTeamDiscussionCommentInOrgResponseItem = {
    content: string;
    created_at: string;
    id: number;
    node_id: string;
    user: ReactionsListForTeamDiscussionCommentInOrgResponseItemUser;
};
declare type ReactionsListForTeamDiscussionCommentResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReactionsListForTeamDiscussionCommentResponseItem = {
    content: string;
    created_at: string;
    id: number;
    node_id: string;
    user: ReactionsListForTeamDiscussionCommentResponseItemUser;
};
declare type ReactionsListForTeamDiscussionResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReactionsListForTeamDiscussionResponseItem = {
    content: string;
    created_at: string;
    id: number;
    node_id: string;
    user: ReactionsListForTeamDiscussionResponseItemUser;
};
declare type ReactionsListForPullRequestReviewCommentResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReactionsListForPullRequestReviewCommentResponseItem = {
    content: string;
    created_at: string;
    id: number;
    node_id: string;
    user: ReactionsListForPullRequestReviewCommentResponseItemUser;
};
declare type ReactionsListForIssueCommentResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReactionsListForIssueCommentResponseItem = {
    content: string;
    created_at: string;
    id: number;
    node_id: string;
    user: ReactionsListForIssueCommentResponseItemUser;
};
declare type ReactionsListForIssueResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReactionsListForIssueResponseItem = {
    content: string;
    created_at: string;
    id: number;
    node_id: string;
    user: ReactionsListForIssueResponseItemUser;
};
declare type ReactionsListForCommitCommentResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReactionsListForCommitCommentResponseItem = {
    content: string;
    created_at: string;
    id: number;
    node_id: string;
    user: ReactionsListForCommitCommentResponseItemUser;
};
declare type ReactionsCreateForTeamDiscussionLegacyResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReactionsCreateForTeamDiscussionLegacyResponse = {
    content: string;
    created_at: string;
    id: number;
    node_id: string;
    user: ReactionsCreateForTeamDiscussionLegacyResponseUser;
};
declare type ReactionsCreateForTeamDiscussionInOrgResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReactionsCreateForTeamDiscussionInOrgResponse = {
    content: string;
    created_at: string;
    id: number;
    node_id: string;
    user: ReactionsCreateForTeamDiscussionInOrgResponseUser;
};
declare type ReactionsCreateForTeamDiscussionCommentLegacyResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReactionsCreateForTeamDiscussionCommentLegacyResponse = {
    content: string;
    created_at: string;
    id: number;
    node_id: string;
    user: ReactionsCreateForTeamDiscussionCommentLegacyResponseUser;
};
declare type ReactionsCreateForTeamDiscussionCommentInOrgResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReactionsCreateForTeamDiscussionCommentInOrgResponse = {
    content: string;
    created_at: string;
    id: number;
    node_id: string;
    user: ReactionsCreateForTeamDiscussionCommentInOrgResponseUser;
};
declare type ReactionsCreateForTeamDiscussionCommentResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReactionsCreateForTeamDiscussionCommentResponse = {
    content: string;
    created_at: string;
    id: number;
    node_id: string;
    user: ReactionsCreateForTeamDiscussionCommentResponseUser;
};
declare type ReactionsCreateForTeamDiscussionResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReactionsCreateForTeamDiscussionResponse = {
    content: string;
    created_at: string;
    id: number;
    node_id: string;
    user: ReactionsCreateForTeamDiscussionResponseUser;
};
declare type ReactionsCreateForPullRequestReviewCommentResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReactionsCreateForPullRequestReviewCommentResponse = {
    content: string;
    created_at: string;
    id: number;
    node_id: string;
    user: ReactionsCreateForPullRequestReviewCommentResponseUser;
};
declare type ReactionsCreateForIssueCommentResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReactionsCreateForIssueCommentResponse = {
    content: string;
    created_at: string;
    id: number;
    node_id: string;
    user: ReactionsCreateForIssueCommentResponseUser;
};
declare type ReactionsCreateForIssueResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReactionsCreateForIssueResponse = {
    content: string;
    created_at: string;
    id: number;
    node_id: string;
    user: ReactionsCreateForIssueResponseUser;
};
declare type ReactionsCreateForCommitCommentResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ReactionsCreateForCommitCommentResponse = {
    content: string;
    created_at: string;
    id: number;
    node_id: string;
    user: ReactionsCreateForCommitCommentResponseUser;
};
declare type RateLimitGetResponseResourcesSearch = {
    limit: number;
    remaining: number;
    reset: number;
};
declare type RateLimitGetResponseResourcesIntegrationManifest = {
    limit: number;
    remaining: number;
    reset: number;
};
declare type RateLimitGetResponseResourcesGraphql = {
    limit: number;
    remaining: number;
    reset: number;
};
declare type RateLimitGetResponseResourcesCore = {
    limit: number;
    remaining: number;
    reset: number;
};
declare type RateLimitGetResponseResources = {
    core: RateLimitGetResponseResourcesCore;
    graphql: RateLimitGetResponseResourcesGraphql;
    integration_manifest: RateLimitGetResponseResourcesIntegrationManifest;
    search: RateLimitGetResponseResourcesSearch;
};
declare type RateLimitGetResponseRate = {
    limit: number;
    remaining: number;
    reset: number;
};
declare type RateLimitGetResponse = {
    rate: RateLimitGetResponseRate;
    resources: RateLimitGetResponseResources;
};
declare type PullsUpdateReviewResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsUpdateReviewResponseLinksPullRequest = {
    href: string;
};
declare type PullsUpdateReviewResponseLinksHtml = {
    href: string;
};
declare type PullsUpdateReviewResponseLinks = {
    html: PullsUpdateReviewResponseLinksHtml;
    pull_request: PullsUpdateReviewResponseLinksPullRequest;
};
declare type PullsUpdateReviewResponse = {
    _links: PullsUpdateReviewResponseLinks;
    body: string;
    commit_id: string;
    html_url: string;
    id: number;
    node_id: string;
    pull_request_url: string;
    state: string;
    user: PullsUpdateReviewResponseUser;
};
declare type PullsUpdateCommentResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsUpdateCommentResponseLinksSelf = {
    href: string;
};
declare type PullsUpdateCommentResponseLinksPullRequest = {
    href: string;
};
declare type PullsUpdateCommentResponseLinksHtml = {
    href: string;
};
declare type PullsUpdateCommentResponseLinks = {
    html: PullsUpdateCommentResponseLinksHtml;
    pull_request: PullsUpdateCommentResponseLinksPullRequest;
    self: PullsUpdateCommentResponseLinksSelf;
};
declare type PullsUpdateCommentResponse = {
    _links: PullsUpdateCommentResponseLinks;
    author_association: string;
    body: string;
    commit_id: string;
    created_at: string;
    diff_hunk: string;
    html_url: string;
    id: number;
    in_reply_to_id: number;
    line: number;
    node_id: string;
    original_commit_id: string;
    original_line: number;
    original_position: number;
    original_start_line: number;
    path: string;
    position: number;
    pull_request_review_id: number;
    pull_request_url: string;
    side: string;
    start_line: number;
    start_side: string;
    updated_at: string;
    url: string;
    user: PullsUpdateCommentResponseUser;
};
declare type PullsUpdateBranchResponse = {
    message: string;
    url: string;
};
declare type PullsUpdateResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsUpdateResponseRequestedTeamsItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
};
declare type PullsUpdateResponseRequestedReviewersItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsUpdateResponseMilestoneCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsUpdateResponseMilestone = {
    closed_at: string;
    closed_issues: number;
    created_at: string;
    creator: PullsUpdateResponseMilestoneCreator;
    description: string;
    due_on: string;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    number: number;
    open_issues: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
};
declare type PullsUpdateResponseMergedBy = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsUpdateResponseLabelsItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
};
declare type PullsUpdateResponseHeadUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsUpdateResponseHeadRepoPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type PullsUpdateResponseHeadRepoOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsUpdateResponseHeadRepo = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: PullsUpdateResponseHeadRepoOwner;
    permissions: PullsUpdateResponseHeadRepoPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type PullsUpdateResponseHead = {
    label: string;
    ref: string;
    repo: PullsUpdateResponseHeadRepo;
    sha: string;
    user: PullsUpdateResponseHeadUser;
};
declare type PullsUpdateResponseBaseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsUpdateResponseBaseRepoPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type PullsUpdateResponseBaseRepoOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsUpdateResponseBaseRepo = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: PullsUpdateResponseBaseRepoOwner;
    permissions: PullsUpdateResponseBaseRepoPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type PullsUpdateResponseBase = {
    label: string;
    ref: string;
    repo: PullsUpdateResponseBaseRepo;
    sha: string;
    user: PullsUpdateResponseBaseUser;
};
declare type PullsUpdateResponseAssigneesItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsUpdateResponseAssignee = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsUpdateResponseLinksStatuses = {
    href: string;
};
declare type PullsUpdateResponseLinksSelf = {
    href: string;
};
declare type PullsUpdateResponseLinksReviewComments = {
    href: string;
};
declare type PullsUpdateResponseLinksReviewComment = {
    href: string;
};
declare type PullsUpdateResponseLinksIssue = {
    href: string;
};
declare type PullsUpdateResponseLinksHtml = {
    href: string;
};
declare type PullsUpdateResponseLinksCommits = {
    href: string;
};
declare type PullsUpdateResponseLinksComments = {
    href: string;
};
declare type PullsUpdateResponseLinks = {
    comments: PullsUpdateResponseLinksComments;
    commits: PullsUpdateResponseLinksCommits;
    html: PullsUpdateResponseLinksHtml;
    issue: PullsUpdateResponseLinksIssue;
    review_comment: PullsUpdateResponseLinksReviewComment;
    review_comments: PullsUpdateResponseLinksReviewComments;
    self: PullsUpdateResponseLinksSelf;
    statuses: PullsUpdateResponseLinksStatuses;
};
declare type PullsUpdateResponse = {
    _links: PullsUpdateResponseLinks;
    active_lock_reason: string;
    additions: number;
    assignee: PullsUpdateResponseAssignee;
    assignees: Array<PullsUpdateResponseAssigneesItem>;
    author_association: string;
    base: PullsUpdateResponseBase;
    body: string;
    changed_files: number;
    closed_at: string;
    comments: number;
    comments_url: string;
    commits: number;
    commits_url: string;
    created_at: string;
    deletions: number;
    diff_url: string;
    draft: boolean;
    head: PullsUpdateResponseHead;
    html_url: string;
    id: number;
    issue_url: string;
    labels: Array<PullsUpdateResponseLabelsItem>;
    locked: boolean;
    maintainer_can_modify: boolean;
    merge_commit_sha: string;
    mergeable: boolean;
    mergeable_state: string;
    merged: boolean;
    merged_at: string;
    merged_by: PullsUpdateResponseMergedBy;
    milestone: PullsUpdateResponseMilestone;
    node_id: string;
    number: number;
    patch_url: string;
    rebaseable: boolean;
    requested_reviewers: Array<PullsUpdateResponseRequestedReviewersItem>;
    requested_teams: Array<PullsUpdateResponseRequestedTeamsItem>;
    review_comment_url: string;
    review_comments: number;
    review_comments_url: string;
    state: string;
    statuses_url: string;
    title: string;
    updated_at: string;
    url: string;
    user: PullsUpdateResponseUser;
};
declare type PullsSubmitReviewResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsSubmitReviewResponseLinksPullRequest = {
    href: string;
};
declare type PullsSubmitReviewResponseLinksHtml = {
    href: string;
};
declare type PullsSubmitReviewResponseLinks = {
    html: PullsSubmitReviewResponseLinksHtml;
    pull_request: PullsSubmitReviewResponseLinksPullRequest;
};
declare type PullsSubmitReviewResponse = {
    _links: PullsSubmitReviewResponseLinks;
    body: string;
    commit_id: string;
    html_url: string;
    id: number;
    node_id: string;
    pull_request_url: string;
    state: string;
    submitted_at: string;
    user: PullsSubmitReviewResponseUser;
};
declare type PullsMergeResponse = {
    merged: boolean;
    message: string;
    sha: string;
};
declare type PullsListReviewsResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsListReviewsResponseItemLinksPullRequest = {
    href: string;
};
declare type PullsListReviewsResponseItemLinksHtml = {
    href: string;
};
declare type PullsListReviewsResponseItemLinks = {
    html: PullsListReviewsResponseItemLinksHtml;
    pull_request: PullsListReviewsResponseItemLinksPullRequest;
};
declare type PullsListReviewsResponseItem = {
    _links: PullsListReviewsResponseItemLinks;
    body: string;
    commit_id: string;
    html_url: string;
    id: number;
    node_id: string;
    pull_request_url: string;
    state: string;
    submitted_at: string;
    user: PullsListReviewsResponseItemUser;
};
declare type PullsListReviewRequestsResponseUsersItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsListReviewRequestsResponseTeamsItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
};
declare type PullsListReviewRequestsResponse = {
    teams: Array<PullsListReviewRequestsResponseTeamsItem>;
    users: Array<PullsListReviewRequestsResponseUsersItem>;
};
declare type PullsListFilesResponseItem = {
    additions: number;
    blob_url: string;
    changes: number;
    contents_url: string;
    deletions: number;
    filename: string;
    patch: string;
    raw_url: string;
    sha: string;
    status: string;
};
declare type PullsListCommitsResponseItemParentsItem = {
    sha: string;
    url: string;
};
declare type PullsListCommitsResponseItemCommitter = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsListCommitsResponseItemCommitVerification = {
    payload: null;
    reason: string;
    signature: null;
    verified: boolean;
};
declare type PullsListCommitsResponseItemCommitTree = {
    sha: string;
    url: string;
};
declare type PullsListCommitsResponseItemCommitCommitter = {
    date: string;
    email: string;
    name: string;
};
declare type PullsListCommitsResponseItemCommitAuthor = {
    date: string;
    email: string;
    name: string;
};
declare type PullsListCommitsResponseItemCommit = {
    author: PullsListCommitsResponseItemCommitAuthor;
    comment_count: number;
    committer: PullsListCommitsResponseItemCommitCommitter;
    message: string;
    tree: PullsListCommitsResponseItemCommitTree;
    url: string;
    verification: PullsListCommitsResponseItemCommitVerification;
};
declare type PullsListCommitsResponseItemAuthor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsListCommitsResponseItem = {
    author: PullsListCommitsResponseItemAuthor;
    comments_url: string;
    commit: PullsListCommitsResponseItemCommit;
    committer: PullsListCommitsResponseItemCommitter;
    html_url: string;
    node_id: string;
    parents: Array<PullsListCommitsResponseItemParentsItem>;
    sha: string;
    url: string;
};
declare type PullsListCommentsForRepoResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsListCommentsForRepoResponseItemLinksSelf = {
    href: string;
};
declare type PullsListCommentsForRepoResponseItemLinksPullRequest = {
    href: string;
};
declare type PullsListCommentsForRepoResponseItemLinksHtml = {
    href: string;
};
declare type PullsListCommentsForRepoResponseItemLinks = {
    html: PullsListCommentsForRepoResponseItemLinksHtml;
    pull_request: PullsListCommentsForRepoResponseItemLinksPullRequest;
    self: PullsListCommentsForRepoResponseItemLinksSelf;
};
declare type PullsListCommentsForRepoResponseItem = {
    _links: PullsListCommentsForRepoResponseItemLinks;
    author_association: string;
    body: string;
    commit_id: string;
    created_at: string;
    diff_hunk: string;
    html_url: string;
    id: number;
    in_reply_to_id: number;
    line: number;
    node_id: string;
    original_commit_id: string;
    original_line: number;
    original_position: number;
    original_start_line: number;
    path: string;
    position: number;
    pull_request_review_id: number;
    pull_request_url: string;
    side: string;
    start_line: number;
    start_side: string;
    updated_at: string;
    url: string;
    user: PullsListCommentsForRepoResponseItemUser;
};
declare type PullsListCommentsResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsListCommentsResponseItemLinksSelf = {
    href: string;
};
declare type PullsListCommentsResponseItemLinksPullRequest = {
    href: string;
};
declare type PullsListCommentsResponseItemLinksHtml = {
    href: string;
};
declare type PullsListCommentsResponseItemLinks = {
    html: PullsListCommentsResponseItemLinksHtml;
    pull_request: PullsListCommentsResponseItemLinksPullRequest;
    self: PullsListCommentsResponseItemLinksSelf;
};
declare type PullsListCommentsResponseItem = {
    _links: PullsListCommentsResponseItemLinks;
    author_association: string;
    body: string;
    commit_id: string;
    created_at: string;
    diff_hunk: string;
    html_url: string;
    id: number;
    in_reply_to_id: number;
    line: number;
    node_id: string;
    original_commit_id: string;
    original_line: number;
    original_position: number;
    original_start_line: number;
    path: string;
    position: number;
    pull_request_review_id: number;
    pull_request_url: string;
    side: string;
    start_line: number;
    start_side: string;
    updated_at: string;
    url: string;
    user: PullsListCommentsResponseItemUser;
};
declare type PullsListResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsListResponseItemRequestedTeamsItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
};
declare type PullsListResponseItemRequestedReviewersItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsListResponseItemMilestoneCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsListResponseItemMilestone = {
    closed_at: string;
    closed_issues: number;
    created_at: string;
    creator: PullsListResponseItemMilestoneCreator;
    description: string;
    due_on: string;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    number: number;
    open_issues: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
};
declare type PullsListResponseItemLabelsItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
};
declare type PullsListResponseItemHeadUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsListResponseItemHeadRepoPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type PullsListResponseItemHeadRepoOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsListResponseItemHeadRepo = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: PullsListResponseItemHeadRepoOwner;
    permissions: PullsListResponseItemHeadRepoPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type PullsListResponseItemHead = {
    label: string;
    ref: string;
    repo: PullsListResponseItemHeadRepo;
    sha: string;
    user: PullsListResponseItemHeadUser;
};
declare type PullsListResponseItemBaseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsListResponseItemBaseRepoPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type PullsListResponseItemBaseRepoOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsListResponseItemBaseRepo = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: PullsListResponseItemBaseRepoOwner;
    permissions: PullsListResponseItemBaseRepoPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type PullsListResponseItemBase = {
    label: string;
    ref: string;
    repo: PullsListResponseItemBaseRepo;
    sha: string;
    user: PullsListResponseItemBaseUser;
};
declare type PullsListResponseItemAssigneesItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsListResponseItemAssignee = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsListResponseItemLinksStatuses = {
    href: string;
};
declare type PullsListResponseItemLinksSelf = {
    href: string;
};
declare type PullsListResponseItemLinksReviewComments = {
    href: string;
};
declare type PullsListResponseItemLinksReviewComment = {
    href: string;
};
declare type PullsListResponseItemLinksIssue = {
    href: string;
};
declare type PullsListResponseItemLinksHtml = {
    href: string;
};
declare type PullsListResponseItemLinksCommits = {
    href: string;
};
declare type PullsListResponseItemLinksComments = {
    href: string;
};
declare type PullsListResponseItemLinks = {
    comments: PullsListResponseItemLinksComments;
    commits: PullsListResponseItemLinksCommits;
    html: PullsListResponseItemLinksHtml;
    issue: PullsListResponseItemLinksIssue;
    review_comment: PullsListResponseItemLinksReviewComment;
    review_comments: PullsListResponseItemLinksReviewComments;
    self: PullsListResponseItemLinksSelf;
    statuses: PullsListResponseItemLinksStatuses;
};
declare type PullsListResponseItem = {
    _links: PullsListResponseItemLinks;
    active_lock_reason: string;
    assignee: PullsListResponseItemAssignee;
    assignees: Array<PullsListResponseItemAssigneesItem>;
    author_association: string;
    base: PullsListResponseItemBase;
    body: string;
    closed_at: string;
    comments_url: string;
    commits_url: string;
    created_at: string;
    diff_url: string;
    draft: boolean;
    head: PullsListResponseItemHead;
    html_url: string;
    id: number;
    issue_url: string;
    labels: Array<PullsListResponseItemLabelsItem>;
    locked: boolean;
    merge_commit_sha: string;
    merged_at: string;
    milestone: PullsListResponseItemMilestone;
    node_id: string;
    number: number;
    patch_url: string;
    requested_reviewers: Array<PullsListResponseItemRequestedReviewersItem>;
    requested_teams: Array<PullsListResponseItemRequestedTeamsItem>;
    review_comment_url: string;
    review_comments_url: string;
    state: string;
    statuses_url: string;
    title: string;
    updated_at: string;
    url: string;
    user: PullsListResponseItemUser;
};
declare type PullsGetReviewResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsGetReviewResponseLinksPullRequest = {
    href: string;
};
declare type PullsGetReviewResponseLinksHtml = {
    href: string;
};
declare type PullsGetReviewResponseLinks = {
    html: PullsGetReviewResponseLinksHtml;
    pull_request: PullsGetReviewResponseLinksPullRequest;
};
declare type PullsGetReviewResponse = {
    _links: PullsGetReviewResponseLinks;
    body: string;
    commit_id: string;
    html_url: string;
    id: number;
    node_id: string;
    pull_request_url: string;
    state: string;
    submitted_at: string;
    user: PullsGetReviewResponseUser;
};
declare type PullsGetCommentsForReviewResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsGetCommentsForReviewResponseItemLinksSelf = {
    href: string;
};
declare type PullsGetCommentsForReviewResponseItemLinksPullRequest = {
    href: string;
};
declare type PullsGetCommentsForReviewResponseItemLinksHtml = {
    href: string;
};
declare type PullsGetCommentsForReviewResponseItemLinks = {
    html: PullsGetCommentsForReviewResponseItemLinksHtml;
    pull_request: PullsGetCommentsForReviewResponseItemLinksPullRequest;
    self: PullsGetCommentsForReviewResponseItemLinksSelf;
};
declare type PullsGetCommentsForReviewResponseItem = {
    _links: PullsGetCommentsForReviewResponseItemLinks;
    author_association: string;
    body: string;
    commit_id: string;
    created_at: string;
    diff_hunk: string;
    html_url: string;
    id: number;
    in_reply_to_id: number;
    node_id: string;
    original_commit_id: string;
    original_position: number;
    path: string;
    position: number;
    pull_request_review_id: number;
    pull_request_url: string;
    updated_at: string;
    url: string;
    user: PullsGetCommentsForReviewResponseItemUser;
};
declare type PullsGetCommentResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsGetCommentResponseLinksSelf = {
    href: string;
};
declare type PullsGetCommentResponseLinksPullRequest = {
    href: string;
};
declare type PullsGetCommentResponseLinksHtml = {
    href: string;
};
declare type PullsGetCommentResponseLinks = {
    html: PullsGetCommentResponseLinksHtml;
    pull_request: PullsGetCommentResponseLinksPullRequest;
    self: PullsGetCommentResponseLinksSelf;
};
declare type PullsGetCommentResponse = {
    _links: PullsGetCommentResponseLinks;
    author_association: string;
    body: string;
    commit_id: string;
    created_at: string;
    diff_hunk: string;
    html_url: string;
    id: number;
    in_reply_to_id: number;
    line: number;
    node_id: string;
    original_commit_id: string;
    original_line: number;
    original_position: number;
    original_start_line: number;
    path: string;
    position: number;
    pull_request_review_id: number;
    pull_request_url: string;
    side: string;
    start_line: number;
    start_side: string;
    updated_at: string;
    url: string;
    user: PullsGetCommentResponseUser;
};
declare type PullsGetResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsGetResponseRequestedTeamsItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
};
declare type PullsGetResponseRequestedReviewersItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsGetResponseMilestoneCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsGetResponseMilestone = {
    closed_at: string;
    closed_issues: number;
    created_at: string;
    creator: PullsGetResponseMilestoneCreator;
    description: string;
    due_on: string;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    number: number;
    open_issues: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
};
declare type PullsGetResponseMergedBy = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsGetResponseLabelsItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
};
declare type PullsGetResponseHeadUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsGetResponseHeadRepoPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type PullsGetResponseHeadRepoOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsGetResponseHeadRepo = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: PullsGetResponseHeadRepoOwner;
    permissions: PullsGetResponseHeadRepoPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type PullsGetResponseHead = {
    label: string;
    ref: string;
    repo: PullsGetResponseHeadRepo;
    sha: string;
    user: PullsGetResponseHeadUser;
};
declare type PullsGetResponseBaseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsGetResponseBaseRepoPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type PullsGetResponseBaseRepoOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsGetResponseBaseRepo = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: PullsGetResponseBaseRepoOwner;
    permissions: PullsGetResponseBaseRepoPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type PullsGetResponseBase = {
    label: string;
    ref: string;
    repo: PullsGetResponseBaseRepo;
    sha: string;
    user: PullsGetResponseBaseUser;
};
declare type PullsGetResponseAssigneesItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsGetResponseAssignee = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsGetResponseLinksStatuses = {
    href: string;
};
declare type PullsGetResponseLinksSelf = {
    href: string;
};
declare type PullsGetResponseLinksReviewComments = {
    href: string;
};
declare type PullsGetResponseLinksReviewComment = {
    href: string;
};
declare type PullsGetResponseLinksIssue = {
    href: string;
};
declare type PullsGetResponseLinksHtml = {
    href: string;
};
declare type PullsGetResponseLinksCommits = {
    href: string;
};
declare type PullsGetResponseLinksComments = {
    href: string;
};
declare type PullsGetResponseLinks = {
    comments: PullsGetResponseLinksComments;
    commits: PullsGetResponseLinksCommits;
    html: PullsGetResponseLinksHtml;
    issue: PullsGetResponseLinksIssue;
    review_comment: PullsGetResponseLinksReviewComment;
    review_comments: PullsGetResponseLinksReviewComments;
    self: PullsGetResponseLinksSelf;
    statuses: PullsGetResponseLinksStatuses;
};
declare type PullsGetResponse = {
    _links: PullsGetResponseLinks;
    active_lock_reason: string;
    additions: number;
    assignee: PullsGetResponseAssignee;
    assignees: Array<PullsGetResponseAssigneesItem>;
    author_association: string;
    base: PullsGetResponseBase;
    body: string;
    changed_files: number;
    closed_at: string;
    comments: number;
    comments_url: string;
    commits: number;
    commits_url: string;
    created_at: string;
    deletions: number;
    diff_url: string;
    draft: boolean;
    head: PullsGetResponseHead;
    html_url: string;
    id: number;
    issue_url: string;
    labels: Array<PullsGetResponseLabelsItem>;
    locked: boolean;
    maintainer_can_modify: boolean;
    merge_commit_sha: string;
    mergeable: boolean;
    mergeable_state: string;
    merged: boolean;
    merged_at: string;
    merged_by: PullsGetResponseMergedBy;
    milestone: PullsGetResponseMilestone;
    node_id: string;
    number: number;
    patch_url: string;
    rebaseable: boolean;
    requested_reviewers: Array<PullsGetResponseRequestedReviewersItem>;
    requested_teams: Array<PullsGetResponseRequestedTeamsItem>;
    review_comment_url: string;
    review_comments: number;
    review_comments_url: string;
    state: string;
    statuses_url: string;
    title: string;
    updated_at: string;
    url: string;
    user: PullsGetResponseUser;
};
declare type PullsDismissReviewResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsDismissReviewResponseLinksPullRequest = {
    href: string;
};
declare type PullsDismissReviewResponseLinksHtml = {
    href: string;
};
declare type PullsDismissReviewResponseLinks = {
    html: PullsDismissReviewResponseLinksHtml;
    pull_request: PullsDismissReviewResponseLinksPullRequest;
};
declare type PullsDismissReviewResponse = {
    _links: PullsDismissReviewResponseLinks;
    body: string;
    commit_id: string;
    html_url: string;
    id: number;
    node_id: string;
    pull_request_url: string;
    state: string;
    user: PullsDismissReviewResponseUser;
};
declare type PullsDeletePendingReviewResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsDeletePendingReviewResponseLinksPullRequest = {
    href: string;
};
declare type PullsDeletePendingReviewResponseLinksHtml = {
    href: string;
};
declare type PullsDeletePendingReviewResponseLinks = {
    html: PullsDeletePendingReviewResponseLinksHtml;
    pull_request: PullsDeletePendingReviewResponseLinksPullRequest;
};
declare type PullsDeletePendingReviewResponse = {
    _links: PullsDeletePendingReviewResponseLinks;
    body: string;
    commit_id: string;
    html_url: string;
    id: number;
    node_id: string;
    pull_request_url: string;
    state: string;
    user: PullsDeletePendingReviewResponseUser;
};
declare type PullsCreateReviewRequestResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsCreateReviewRequestResponseRequestedTeamsItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
};
declare type PullsCreateReviewRequestResponseRequestedReviewersItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsCreateReviewRequestResponseMilestoneCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsCreateReviewRequestResponseMilestone = {
    closed_at: string;
    closed_issues: number;
    created_at: string;
    creator: PullsCreateReviewRequestResponseMilestoneCreator;
    description: string;
    due_on: string;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    number: number;
    open_issues: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
};
declare type PullsCreateReviewRequestResponseLabelsItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
};
declare type PullsCreateReviewRequestResponseHeadUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsCreateReviewRequestResponseHeadRepoPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type PullsCreateReviewRequestResponseHeadRepoOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsCreateReviewRequestResponseHeadRepo = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: PullsCreateReviewRequestResponseHeadRepoOwner;
    permissions: PullsCreateReviewRequestResponseHeadRepoPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type PullsCreateReviewRequestResponseHead = {
    label: string;
    ref: string;
    repo: PullsCreateReviewRequestResponseHeadRepo;
    sha: string;
    user: PullsCreateReviewRequestResponseHeadUser;
};
declare type PullsCreateReviewRequestResponseBaseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsCreateReviewRequestResponseBaseRepoPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type PullsCreateReviewRequestResponseBaseRepoOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsCreateReviewRequestResponseBaseRepo = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: PullsCreateReviewRequestResponseBaseRepoOwner;
    permissions: PullsCreateReviewRequestResponseBaseRepoPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type PullsCreateReviewRequestResponseBase = {
    label: string;
    ref: string;
    repo: PullsCreateReviewRequestResponseBaseRepo;
    sha: string;
    user: PullsCreateReviewRequestResponseBaseUser;
};
declare type PullsCreateReviewRequestResponseAssigneesItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsCreateReviewRequestResponseAssignee = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsCreateReviewRequestResponseLinksStatuses = {
    href: string;
};
declare type PullsCreateReviewRequestResponseLinksSelf = {
    href: string;
};
declare type PullsCreateReviewRequestResponseLinksReviewComments = {
    href: string;
};
declare type PullsCreateReviewRequestResponseLinksReviewComment = {
    href: string;
};
declare type PullsCreateReviewRequestResponseLinksIssue = {
    href: string;
};
declare type PullsCreateReviewRequestResponseLinksHtml = {
    href: string;
};
declare type PullsCreateReviewRequestResponseLinksCommits = {
    href: string;
};
declare type PullsCreateReviewRequestResponseLinksComments = {
    href: string;
};
declare type PullsCreateReviewRequestResponseLinks = {
    comments: PullsCreateReviewRequestResponseLinksComments;
    commits: PullsCreateReviewRequestResponseLinksCommits;
    html: PullsCreateReviewRequestResponseLinksHtml;
    issue: PullsCreateReviewRequestResponseLinksIssue;
    review_comment: PullsCreateReviewRequestResponseLinksReviewComment;
    review_comments: PullsCreateReviewRequestResponseLinksReviewComments;
    self: PullsCreateReviewRequestResponseLinksSelf;
    statuses: PullsCreateReviewRequestResponseLinksStatuses;
};
declare type PullsCreateReviewRequestResponse = {
    _links: PullsCreateReviewRequestResponseLinks;
    active_lock_reason: string;
    assignee: PullsCreateReviewRequestResponseAssignee;
    assignees: Array<PullsCreateReviewRequestResponseAssigneesItem>;
    author_association: string;
    base: PullsCreateReviewRequestResponseBase;
    body: string;
    closed_at: string;
    comments_url: string;
    commits_url: string;
    created_at: string;
    diff_url: string;
    draft: boolean;
    head: PullsCreateReviewRequestResponseHead;
    html_url: string;
    id: number;
    issue_url: string;
    labels: Array<PullsCreateReviewRequestResponseLabelsItem>;
    locked: boolean;
    merge_commit_sha: string;
    merged_at: string;
    milestone: PullsCreateReviewRequestResponseMilestone;
    node_id: string;
    number: number;
    patch_url: string;
    requested_reviewers: Array<PullsCreateReviewRequestResponseRequestedReviewersItem>;
    requested_teams: Array<PullsCreateReviewRequestResponseRequestedTeamsItem>;
    review_comment_url: string;
    review_comments_url: string;
    state: string;
    statuses_url: string;
    title: string;
    updated_at: string;
    url: string;
    user: PullsCreateReviewRequestResponseUser;
};
declare type PullsCreateReviewCommentReplyResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsCreateReviewCommentReplyResponseLinksSelf = {
    href: string;
};
declare type PullsCreateReviewCommentReplyResponseLinksPullRequest = {
    href: string;
};
declare type PullsCreateReviewCommentReplyResponseLinksHtml = {
    href: string;
};
declare type PullsCreateReviewCommentReplyResponseLinks = {
    html: PullsCreateReviewCommentReplyResponseLinksHtml;
    pull_request: PullsCreateReviewCommentReplyResponseLinksPullRequest;
    self: PullsCreateReviewCommentReplyResponseLinksSelf;
};
declare type PullsCreateReviewCommentReplyResponse = {
    _links: PullsCreateReviewCommentReplyResponseLinks;
    author_association: string;
    body: string;
    commit_id: string;
    created_at: string;
    diff_hunk: string;
    html_url: string;
    id: number;
    node_id: string;
    original_commit_id: string;
    original_position: number;
    path: string;
    position: number;
    pull_request_review_id: number;
    pull_request_url: string;
    updated_at: string;
    url: string;
    user: PullsCreateReviewCommentReplyResponseUser;
};
declare type PullsCreateReviewResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsCreateReviewResponseLinksPullRequest = {
    href: string;
};
declare type PullsCreateReviewResponseLinksHtml = {
    href: string;
};
declare type PullsCreateReviewResponseLinks = {
    html: PullsCreateReviewResponseLinksHtml;
    pull_request: PullsCreateReviewResponseLinksPullRequest;
};
declare type PullsCreateReviewResponse = {
    _links: PullsCreateReviewResponseLinks;
    body: string;
    commit_id: string;
    html_url: string;
    id: number;
    node_id: string;
    pull_request_url: string;
    state: string;
    user: PullsCreateReviewResponseUser;
};
declare type PullsCreateFromIssueResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsCreateFromIssueResponseRequestedTeamsItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
};
declare type PullsCreateFromIssueResponseRequestedReviewersItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsCreateFromIssueResponseMilestoneCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsCreateFromIssueResponseMilestone = {
    closed_at: string;
    closed_issues: number;
    created_at: string;
    creator: PullsCreateFromIssueResponseMilestoneCreator;
    description: string;
    due_on: string;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    number: number;
    open_issues: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
};
declare type PullsCreateFromIssueResponseMergedBy = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsCreateFromIssueResponseLabelsItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
};
declare type PullsCreateFromIssueResponseHeadUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsCreateFromIssueResponseHeadRepoPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type PullsCreateFromIssueResponseHeadRepoOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsCreateFromIssueResponseHeadRepo = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: PullsCreateFromIssueResponseHeadRepoOwner;
    permissions: PullsCreateFromIssueResponseHeadRepoPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type PullsCreateFromIssueResponseHead = {
    label: string;
    ref: string;
    repo: PullsCreateFromIssueResponseHeadRepo;
    sha: string;
    user: PullsCreateFromIssueResponseHeadUser;
};
declare type PullsCreateFromIssueResponseBaseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsCreateFromIssueResponseBaseRepoPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type PullsCreateFromIssueResponseBaseRepoOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsCreateFromIssueResponseBaseRepo = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: PullsCreateFromIssueResponseBaseRepoOwner;
    permissions: PullsCreateFromIssueResponseBaseRepoPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type PullsCreateFromIssueResponseBase = {
    label: string;
    ref: string;
    repo: PullsCreateFromIssueResponseBaseRepo;
    sha: string;
    user: PullsCreateFromIssueResponseBaseUser;
};
declare type PullsCreateFromIssueResponseAssigneesItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsCreateFromIssueResponseAssignee = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsCreateFromIssueResponseLinksStatuses = {
    href: string;
};
declare type PullsCreateFromIssueResponseLinksSelf = {
    href: string;
};
declare type PullsCreateFromIssueResponseLinksReviewComments = {
    href: string;
};
declare type PullsCreateFromIssueResponseLinksReviewComment = {
    href: string;
};
declare type PullsCreateFromIssueResponseLinksIssue = {
    href: string;
};
declare type PullsCreateFromIssueResponseLinksHtml = {
    href: string;
};
declare type PullsCreateFromIssueResponseLinksCommits = {
    href: string;
};
declare type PullsCreateFromIssueResponseLinksComments = {
    href: string;
};
declare type PullsCreateFromIssueResponseLinks = {
    comments: PullsCreateFromIssueResponseLinksComments;
    commits: PullsCreateFromIssueResponseLinksCommits;
    html: PullsCreateFromIssueResponseLinksHtml;
    issue: PullsCreateFromIssueResponseLinksIssue;
    review_comment: PullsCreateFromIssueResponseLinksReviewComment;
    review_comments: PullsCreateFromIssueResponseLinksReviewComments;
    self: PullsCreateFromIssueResponseLinksSelf;
    statuses: PullsCreateFromIssueResponseLinksStatuses;
};
declare type PullsCreateFromIssueResponse = {
    _links: PullsCreateFromIssueResponseLinks;
    active_lock_reason: string;
    additions: number;
    assignee: PullsCreateFromIssueResponseAssignee;
    assignees: Array<PullsCreateFromIssueResponseAssigneesItem>;
    author_association: string;
    base: PullsCreateFromIssueResponseBase;
    body: string;
    changed_files: number;
    closed_at: string;
    comments: number;
    comments_url: string;
    commits: number;
    commits_url: string;
    created_at: string;
    deletions: number;
    diff_url: string;
    draft: boolean;
    head: PullsCreateFromIssueResponseHead;
    html_url: string;
    id: number;
    issue_url: string;
    labels: Array<PullsCreateFromIssueResponseLabelsItem>;
    locked: boolean;
    maintainer_can_modify: boolean;
    merge_commit_sha: string;
    mergeable: boolean;
    mergeable_state: string;
    merged: boolean;
    merged_at: string;
    merged_by: PullsCreateFromIssueResponseMergedBy;
    milestone: PullsCreateFromIssueResponseMilestone;
    node_id: string;
    number: number;
    patch_url: string;
    rebaseable: boolean;
    requested_reviewers: Array<PullsCreateFromIssueResponseRequestedReviewersItem>;
    requested_teams: Array<PullsCreateFromIssueResponseRequestedTeamsItem>;
    review_comment_url: string;
    review_comments: number;
    review_comments_url: string;
    state: string;
    statuses_url: string;
    title: string;
    updated_at: string;
    url: string;
    user: PullsCreateFromIssueResponseUser;
};
declare type PullsCreateCommentReplyResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsCreateCommentReplyResponseLinksSelf = {
    href: string;
};
declare type PullsCreateCommentReplyResponseLinksPullRequest = {
    href: string;
};
declare type PullsCreateCommentReplyResponseLinksHtml = {
    href: string;
};
declare type PullsCreateCommentReplyResponseLinks = {
    html: PullsCreateCommentReplyResponseLinksHtml;
    pull_request: PullsCreateCommentReplyResponseLinksPullRequest;
    self: PullsCreateCommentReplyResponseLinksSelf;
};
declare type PullsCreateCommentReplyResponse = {
    _links: PullsCreateCommentReplyResponseLinks;
    author_association: string;
    body: string;
    commit_id: string;
    created_at: string;
    diff_hunk: string;
    html_url: string;
    id: number;
    in_reply_to_id: number;
    line: number;
    node_id: string;
    original_commit_id: string;
    original_line: number;
    original_position: number;
    original_start_line: number;
    path: string;
    position: number;
    pull_request_review_id: number;
    pull_request_url: string;
    side: string;
    start_line: number;
    start_side: string;
    updated_at: string;
    url: string;
    user: PullsCreateCommentReplyResponseUser;
};
declare type PullsCreateCommentResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsCreateCommentResponseLinksSelf = {
    href: string;
};
declare type PullsCreateCommentResponseLinksPullRequest = {
    href: string;
};
declare type PullsCreateCommentResponseLinksHtml = {
    href: string;
};
declare type PullsCreateCommentResponseLinks = {
    html: PullsCreateCommentResponseLinksHtml;
    pull_request: PullsCreateCommentResponseLinksPullRequest;
    self: PullsCreateCommentResponseLinksSelf;
};
declare type PullsCreateCommentResponse = {
    _links: PullsCreateCommentResponseLinks;
    author_association: string;
    body: string;
    commit_id: string;
    created_at: string;
    diff_hunk: string;
    html_url: string;
    id: number;
    in_reply_to_id: number;
    line: number;
    node_id: string;
    original_commit_id: string;
    original_line: number;
    original_position: number;
    original_start_line: number;
    path: string;
    position: number;
    pull_request_review_id: number;
    pull_request_url: string;
    side: string;
    start_line: number;
    start_side: string;
    updated_at: string;
    url: string;
    user: PullsCreateCommentResponseUser;
};
declare type PullsCreateResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsCreateResponseRequestedTeamsItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
};
declare type PullsCreateResponseRequestedReviewersItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsCreateResponseMilestoneCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsCreateResponseMilestone = {
    closed_at: string;
    closed_issues: number;
    created_at: string;
    creator: PullsCreateResponseMilestoneCreator;
    description: string;
    due_on: string;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    number: number;
    open_issues: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
};
declare type PullsCreateResponseMergedBy = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsCreateResponseLabelsItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
};
declare type PullsCreateResponseHeadUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsCreateResponseHeadRepoPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type PullsCreateResponseHeadRepoOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsCreateResponseHeadRepo = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: PullsCreateResponseHeadRepoOwner;
    permissions: PullsCreateResponseHeadRepoPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type PullsCreateResponseHead = {
    label: string;
    ref: string;
    repo: PullsCreateResponseHeadRepo;
    sha: string;
    user: PullsCreateResponseHeadUser;
};
declare type PullsCreateResponseBaseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsCreateResponseBaseRepoPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type PullsCreateResponseBaseRepoOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsCreateResponseBaseRepo = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: PullsCreateResponseBaseRepoOwner;
    permissions: PullsCreateResponseBaseRepoPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type PullsCreateResponseBase = {
    label: string;
    ref: string;
    repo: PullsCreateResponseBaseRepo;
    sha: string;
    user: PullsCreateResponseBaseUser;
};
declare type PullsCreateResponseAssigneesItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsCreateResponseAssignee = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type PullsCreateResponseLinksStatuses = {
    href: string;
};
declare type PullsCreateResponseLinksSelf = {
    href: string;
};
declare type PullsCreateResponseLinksReviewComments = {
    href: string;
};
declare type PullsCreateResponseLinksReviewComment = {
    href: string;
};
declare type PullsCreateResponseLinksIssue = {
    href: string;
};
declare type PullsCreateResponseLinksHtml = {
    href: string;
};
declare type PullsCreateResponseLinksCommits = {
    href: string;
};
declare type PullsCreateResponseLinksComments = {
    href: string;
};
declare type PullsCreateResponseLinks = {
    comments: PullsCreateResponseLinksComments;
    commits: PullsCreateResponseLinksCommits;
    html: PullsCreateResponseLinksHtml;
    issue: PullsCreateResponseLinksIssue;
    review_comment: PullsCreateResponseLinksReviewComment;
    review_comments: PullsCreateResponseLinksReviewComments;
    self: PullsCreateResponseLinksSelf;
    statuses: PullsCreateResponseLinksStatuses;
};
declare type PullsCreateResponse = {
    _links: PullsCreateResponseLinks;
    active_lock_reason: string;
    additions: number;
    assignee: PullsCreateResponseAssignee;
    assignees: Array<PullsCreateResponseAssigneesItem>;
    author_association: string;
    base: PullsCreateResponseBase;
    body: string;
    changed_files: number;
    closed_at: string;
    comments: number;
    comments_url: string;
    commits: number;
    commits_url: string;
    created_at: string;
    deletions: number;
    diff_url: string;
    draft: boolean;
    head: PullsCreateResponseHead;
    html_url: string;
    id: number;
    issue_url: string;
    labels: Array<PullsCreateResponseLabelsItem>;
    locked: boolean;
    maintainer_can_modify: boolean;
    merge_commit_sha: string;
    mergeable: boolean;
    mergeable_state: string;
    merged: boolean;
    merged_at: string;
    merged_by: PullsCreateResponseMergedBy;
    milestone: PullsCreateResponseMilestone;
    node_id: string;
    number: number;
    patch_url: string;
    rebaseable: boolean;
    requested_reviewers: Array<PullsCreateResponseRequestedReviewersItem>;
    requested_teams: Array<PullsCreateResponseRequestedTeamsItem>;
    review_comment_url: string;
    review_comments: number;
    review_comments_url: string;
    state: string;
    statuses_url: string;
    title: string;
    updated_at: string;
    url: string;
    user: PullsCreateResponseUser;
};
declare type ProjectsUpdateColumnResponse = {
    cards_url: string;
    created_at: string;
    id: number;
    name: string;
    node_id: string;
    project_url: string;
    updated_at: string;
    url: string;
};
declare type ProjectsUpdateCardResponseCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ProjectsUpdateCardResponse = {
    archived: boolean;
    column_url: string;
    content_url: string;
    created_at: string;
    creator: ProjectsUpdateCardResponseCreator;
    id: number;
    node_id: string;
    note: string;
    project_url: string;
    updated_at: string;
    url: string;
};
declare type ProjectsUpdateResponseCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ProjectsUpdateResponse = {
    body: string;
    columns_url: string;
    created_at: string;
    creator: ProjectsUpdateResponseCreator;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    number: number;
    owner_url: string;
    state: string;
    updated_at: string;
    url: string;
};
declare type ProjectsReviewUserPermissionLevelResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ProjectsReviewUserPermissionLevelResponse = {
    permission: string;
    user: ProjectsReviewUserPermissionLevelResponseUser;
};
declare type ProjectsListForUserResponseItemCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ProjectsListForUserResponseItem = {
    body: string;
    columns_url: string;
    created_at: string;
    creator: ProjectsListForUserResponseItemCreator;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    number: number;
    owner_url: string;
    state: string;
    updated_at: string;
    url: string;
};
declare type ProjectsListForRepoResponseItemCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ProjectsListForRepoResponseItem = {
    body: string;
    columns_url: string;
    created_at: string;
    creator: ProjectsListForRepoResponseItemCreator;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    number: number;
    owner_url: string;
    state: string;
    updated_at: string;
    url: string;
};
declare type ProjectsListForOrgResponseItemCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ProjectsListForOrgResponseItem = {
    body: string;
    columns_url: string;
    created_at: string;
    creator: ProjectsListForOrgResponseItemCreator;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    number: number;
    owner_url: string;
    state: string;
    updated_at: string;
    url: string;
};
declare type ProjectsListColumnsResponseItem = {
    cards_url: string;
    created_at: string;
    id: number;
    name: string;
    node_id: string;
    project_url: string;
    updated_at: string;
    url: string;
};
declare type ProjectsListCollaboratorsResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ProjectsListCardsResponseItemCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ProjectsListCardsResponseItem = {
    archived: boolean;
    column_url: string;
    content_url: string;
    created_at: string;
    creator: ProjectsListCardsResponseItemCreator;
    id: number;
    node_id: string;
    note: string;
    project_url: string;
    updated_at: string;
    url: string;
};
declare type ProjectsGetColumnResponse = {
    cards_url: string;
    created_at: string;
    id: number;
    name: string;
    node_id: string;
    project_url: string;
    updated_at: string;
    url: string;
};
declare type ProjectsGetCardResponseCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ProjectsGetCardResponse = {
    archived: boolean;
    column_url: string;
    content_url: string;
    created_at: string;
    creator: ProjectsGetCardResponseCreator;
    id: number;
    node_id: string;
    note: string;
    project_url: string;
    updated_at: string;
    url: string;
};
declare type ProjectsGetResponseCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ProjectsGetResponse = {
    body: string;
    columns_url: string;
    created_at: string;
    creator: ProjectsGetResponseCreator;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    number: number;
    owner_url: string;
    state: string;
    updated_at: string;
    url: string;
};
declare type ProjectsCreateForRepoResponseCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ProjectsCreateForRepoResponse = {
    body: string;
    columns_url: string;
    created_at: string;
    creator: ProjectsCreateForRepoResponseCreator;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    number: number;
    owner_url: string;
    state: string;
    updated_at: string;
    url: string;
};
declare type ProjectsCreateForOrgResponseCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ProjectsCreateForOrgResponse = {
    body: string;
    columns_url: string;
    created_at: string;
    creator: ProjectsCreateForOrgResponseCreator;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    number: number;
    owner_url: string;
    state: string;
    updated_at: string;
    url: string;
};
declare type ProjectsCreateForAuthenticatedUserResponseCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ProjectsCreateForAuthenticatedUserResponse = {
    body: string;
    columns_url: string;
    created_at: string;
    creator: ProjectsCreateForAuthenticatedUserResponseCreator;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    number: number;
    owner_url: string;
    state: string;
    updated_at: string;
    url: string;
};
declare type ProjectsCreateColumnResponse = {
    cards_url: string;
    created_at: string;
    id: number;
    name: string;
    node_id: string;
    project_url: string;
    updated_at: string;
    url: string;
};
declare type ProjectsCreateCardResponseCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ProjectsCreateCardResponse = {
    archived: boolean;
    column_url: string;
    content_url: string;
    created_at: string;
    creator: ProjectsCreateCardResponseCreator;
    id: number;
    node_id: string;
    note: string;
    project_url: string;
    updated_at: string;
    url: string;
};
declare type OrgsUpdateMembershipResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type OrgsUpdateMembershipResponseOrganization = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
};
declare type OrgsUpdateMembershipResponse = {
    organization: OrgsUpdateMembershipResponseOrganization;
    organization_url: string;
    role: string;
    state: string;
    url: string;
    user: OrgsUpdateMembershipResponseUser;
};
declare type OrgsUpdateHookResponseConfig = {
    content_type: string;
    url: string;
};
declare type OrgsUpdateHookResponse = {
    active: boolean;
    config: OrgsUpdateHookResponseConfig;
    created_at: string;
    events: Array<string>;
    id: number;
    name: string;
    ping_url: string;
    updated_at: string;
    url: string;
};
declare type OrgsUpdateResponsePlan = {
    name: string;
    private_repos: number;
    space: number;
};
declare type OrgsUpdateResponse = {
    avatar_url: string;
    billing_email: string;
    blog: string;
    collaborators: number;
    company: string;
    created_at: string;
    default_repository_permission: string;
    description: string;
    disk_usage: number;
    email: string;
    events_url: string;
    followers: number;
    following: number;
    has_organization_projects: boolean;
    has_repository_projects: boolean;
    hooks_url: string;
    html_url: string;
    id: number;
    is_verified: boolean;
    issues_url: string;
    location: string;
    login: string;
    members_allowed_repository_creation_type: string;
    members_can_create_internal_repositories: boolean;
    members_can_create_private_repositories: boolean;
    members_can_create_public_repositories: boolean;
    members_can_create_repositories: boolean;
    members_url: string;
    name: string;
    node_id: string;
    owned_private_repos: number;
    plan: OrgsUpdateResponsePlan;
    private_gists: number;
    public_gists: number;
    public_members_url: string;
    public_repos: number;
    repos_url: string;
    total_private_repos: number;
    two_factor_requirement_enabled: boolean;
    type: string;
    url: string;
};
declare type OrgsRemoveOutsideCollaboratorResponse = {
    documentation_url: string;
    message: string;
};
declare type OrgsListPublicMembersResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type OrgsListPendingInvitationsResponseItemInviter = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type OrgsListPendingInvitationsResponseItem = {
    created_at: string;
    email: string;
    id: number;
    invitation_team_url: string;
    inviter: OrgsListPendingInvitationsResponseItemInviter;
    login: string;
    role: string;
    team_count: number;
};
declare type OrgsListOutsideCollaboratorsResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type OrgsListMembershipsResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type OrgsListMembershipsResponseItemOrganization = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
};
declare type OrgsListMembershipsResponseItem = {
    organization: OrgsListMembershipsResponseItemOrganization;
    organization_url: string;
    role: string;
    state: string;
    url: string;
    user: OrgsListMembershipsResponseItemUser;
};
declare type OrgsListMembersResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type OrgsListInvitationTeamsResponseItem = {
    description: string;
    html_url: string;
    id: number;
    members_url: string;
    name: string;
    node_id: string;
    parent: null;
    permission: string;
    privacy: string;
    repositories_url: string;
    slug: string;
    url: string;
};
declare type OrgsListInstallationsResponseInstallationsItemPermissions = {
    deployments: string;
    metadata: string;
    pull_requests: string;
    statuses: string;
};
declare type OrgsListInstallationsResponseInstallationsItemAccount = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type OrgsListInstallationsResponseInstallationsItem = {
    access_tokens_url: string;
    account: OrgsListInstallationsResponseInstallationsItemAccount;
    app_id: number;
    created_at: string;
    events: Array<string>;
    html_url: string;
    id: number;
    permissions: OrgsListInstallationsResponseInstallationsItemPermissions;
    repositories_url: string;
    repository_selection: string;
    single_file_name: null;
    target_id: number;
    target_type: string;
    updated_at: string;
};
declare type OrgsListInstallationsResponse = {
    installations: Array<OrgsListInstallationsResponseInstallationsItem>;
    total_count: number;
};
declare type OrgsListHooksResponseItemConfig = {
    content_type: string;
    url: string;
};
declare type OrgsListHooksResponseItem = {
    active: boolean;
    config: OrgsListHooksResponseItemConfig;
    created_at: string;
    events: Array<string>;
    id: number;
    name: string;
    ping_url: string;
    updated_at: string;
    url: string;
};
declare type OrgsListForUserResponseItem = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
};
declare type OrgsListForAuthenticatedUserResponseItem = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
};
declare type OrgsListBlockedUsersResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type OrgsListResponseItem = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
};
declare type OrgsGetMembershipForAuthenticatedUserResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type OrgsGetMembershipForAuthenticatedUserResponseOrganization = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
};
declare type OrgsGetMembershipForAuthenticatedUserResponse = {
    organization: OrgsGetMembershipForAuthenticatedUserResponseOrganization;
    organization_url: string;
    role: string;
    state: string;
    url: string;
    user: OrgsGetMembershipForAuthenticatedUserResponseUser;
};
declare type OrgsGetMembershipResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type OrgsGetMembershipResponseOrganization = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
};
declare type OrgsGetMembershipResponse = {
    organization: OrgsGetMembershipResponseOrganization;
    organization_url: string;
    role: string;
    state: string;
    url: string;
    user: OrgsGetMembershipResponseUser;
};
declare type OrgsGetHookResponseConfig = {
    content_type: string;
    url: string;
};
declare type OrgsGetHookResponse = {
    active: boolean;
    config: OrgsGetHookResponseConfig;
    created_at: string;
    events: Array<string>;
    id: number;
    name: string;
    ping_url: string;
    updated_at: string;
    url: string;
};
declare type OrgsGetResponsePlan = {
    name: string;
    private_repos: number;
    space: number;
    filled_seats?: number;
    seats?: number;
};
declare type OrgsGetResponse = {
    avatar_url: string;
    billing_email?: string;
    blog: string;
    collaborators?: number;
    company: string;
    created_at: string;
    default_repository_permission?: string;
    description: string;
    disk_usage?: number;
    email: string;
    events_url: string;
    followers: number;
    following: number;
    has_organization_projects: boolean;
    has_repository_projects: boolean;
    hooks_url: string;
    html_url: string;
    id: number;
    is_verified: boolean;
    issues_url: string;
    location: string;
    login: string;
    members_allowed_repository_creation_type?: string;
    members_can_create_internal_repositories?: boolean;
    members_can_create_private_repositories?: boolean;
    members_can_create_public_repositories?: boolean;
    members_can_create_repositories?: boolean;
    members_url: string;
    name: string;
    node_id: string;
    owned_private_repos?: number;
    plan: OrgsGetResponsePlan;
    private_gists?: number;
    public_gists: number;
    public_members_url: string;
    public_repos: number;
    repos_url: string;
    total_private_repos?: number;
    two_factor_requirement_enabled?: boolean;
    type: string;
    url: string;
};
declare type OrgsCreateInvitationResponseInviter = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type OrgsCreateInvitationResponse = {
    created_at: string;
    email: string;
    id: number;
    invitation_team_url: string;
    inviter: OrgsCreateInvitationResponseInviter;
    login: string;
    role: string;
    team_count: number;
};
declare type OrgsCreateHookResponseConfig = {
    content_type: string;
    url: string;
};
declare type OrgsCreateHookResponse = {
    active: boolean;
    config: OrgsCreateHookResponseConfig;
    created_at: string;
    events: Array<string>;
    id: number;
    name: string;
    ping_url: string;
    updated_at: string;
    url: string;
};
declare type OrgsConvertMemberToOutsideCollaboratorResponse = {
    documentation_url: string;
    message: string;
};
declare type OrgsAddOrUpdateMembershipResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type OrgsAddOrUpdateMembershipResponseOrganization = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
};
declare type OrgsAddOrUpdateMembershipResponse = {
    organization: OrgsAddOrUpdateMembershipResponseOrganization;
    organization_url: string;
    role: string;
    state: string;
    url: string;
    user: OrgsAddOrUpdateMembershipResponseUser;
};
declare type OauthAuthorizationsUpdateAuthorizationResponseApp = {
    client_id: string;
    name: string;
    url: string;
};
declare type OauthAuthorizationsUpdateAuthorizationResponse = {
    app: OauthAuthorizationsUpdateAuthorizationResponseApp;
    created_at: string;
    fingerprint: string;
    hashed_token: string;
    id: number;
    note: string;
    note_url: string;
    scopes: Array<string>;
    token: string;
    token_last_eight: string;
    updated_at: string;
    url: string;
};
declare type OauthAuthorizationsResetAuthorizationResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type OauthAuthorizationsResetAuthorizationResponseApp = {
    client_id: string;
    name: string;
    url: string;
};
declare type OauthAuthorizationsResetAuthorizationResponse = {
    app: OauthAuthorizationsResetAuthorizationResponseApp;
    created_at: string;
    fingerprint: string;
    hashed_token: string;
    id: number;
    note: string;
    note_url: string;
    scopes: Array<string>;
    token: string;
    token_last_eight: string;
    updated_at: string;
    url: string;
    user: OauthAuthorizationsResetAuthorizationResponseUser;
};
declare type OauthAuthorizationsListGrantsResponseItemApp = {
    client_id: string;
    name: string;
    url: string;
};
declare type OauthAuthorizationsListGrantsResponseItem = {
    app: OauthAuthorizationsListGrantsResponseItemApp;
    created_at: string;
    id: number;
    scopes: Array<string>;
    updated_at: string;
    url: string;
};
declare type OauthAuthorizationsListAuthorizationsResponseItemApp = {
    client_id: string;
    name: string;
    url: string;
};
declare type OauthAuthorizationsListAuthorizationsResponseItem = {
    app: OauthAuthorizationsListAuthorizationsResponseItemApp;
    created_at: string;
    fingerprint: string;
    hashed_token: string;
    id: number;
    note: string;
    note_url: string;
    scopes: Array<string>;
    token: string;
    token_last_eight: string;
    updated_at: string;
    url: string;
};
declare type OauthAuthorizationsGetOrCreateAuthorizationForAppFingerprintResponseApp = {
    client_id: string;
    name: string;
    url: string;
};
declare type OauthAuthorizationsGetOrCreateAuthorizationForAppFingerprintResponse = {
    app: OauthAuthorizationsGetOrCreateAuthorizationForAppFingerprintResponseApp;
    created_at: string;
    fingerprint: string;
    hashed_token: string;
    id: number;
    note: string;
    note_url: string;
    scopes: Array<string>;
    token: string;
    token_last_eight: string;
    updated_at: string;
    url: string;
};
declare type OauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprintResponseApp = {
    client_id: string;
    name: string;
    url: string;
};
declare type OauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprintResponse = {
    app: OauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprintResponseApp;
    created_at: string;
    fingerprint: string;
    hashed_token: string;
    id: number;
    note: string;
    note_url: string;
    scopes: Array<string>;
    token: string;
    token_last_eight: string;
    updated_at: string;
    url: string;
};
declare type OauthAuthorizationsGetOrCreateAuthorizationForAppResponseApp = {
    client_id: string;
    name: string;
    url: string;
};
declare type OauthAuthorizationsGetOrCreateAuthorizationForAppResponse = {
    app: OauthAuthorizationsGetOrCreateAuthorizationForAppResponseApp;
    created_at: string;
    fingerprint: string;
    hashed_token: string;
    id: number;
    note: string;
    note_url: string;
    scopes: Array<string>;
    token: string;
    token_last_eight: string;
    updated_at: string;
    url: string;
};
declare type OauthAuthorizationsGetGrantResponseApp = {
    client_id: string;
    name: string;
    url: string;
};
declare type OauthAuthorizationsGetGrantResponse = {
    app: OauthAuthorizationsGetGrantResponseApp;
    created_at: string;
    id: number;
    scopes: Array<string>;
    updated_at: string;
    url: string;
};
declare type OauthAuthorizationsGetAuthorizationResponseApp = {
    client_id: string;
    name: string;
    url: string;
};
declare type OauthAuthorizationsGetAuthorizationResponse = {
    app: OauthAuthorizationsGetAuthorizationResponseApp;
    created_at: string;
    fingerprint: string;
    hashed_token: string;
    id: number;
    note: string;
    note_url: string;
    scopes: Array<string>;
    token: string;
    token_last_eight: string;
    updated_at: string;
    url: string;
};
declare type OauthAuthorizationsCreateAuthorizationResponseApp = {
    client_id: string;
    name: string;
    url: string;
};
declare type OauthAuthorizationsCreateAuthorizationResponse = {
    app: OauthAuthorizationsCreateAuthorizationResponseApp;
    created_at: string;
    fingerprint: string;
    hashed_token: string;
    id: number;
    note: string;
    note_url: string;
    scopes: Array<string>;
    token: string;
    token_last_eight: string;
    updated_at: string;
    url: string;
};
declare type OauthAuthorizationsCheckAuthorizationResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type OauthAuthorizationsCheckAuthorizationResponseApp = {
    client_id: string;
    name: string;
    url: string;
};
declare type OauthAuthorizationsCheckAuthorizationResponse = {
    app: OauthAuthorizationsCheckAuthorizationResponseApp;
    created_at: string;
    fingerprint: string;
    hashed_token: string;
    id: number;
    note: string;
    note_url: string;
    scopes: Array<string>;
    token: string;
    token_last_eight: string;
    updated_at: string;
    url: string;
    user: OauthAuthorizationsCheckAuthorizationResponseUser;
};
declare type MigrationsUpdateImportResponse = {
    authors_url: string;
    html_url: string;
    repository_url: string;
    status: string;
    url: string;
    use_lfs: string;
    vcs: string;
    vcs_url: string;
    authors_count?: number;
    commit_count?: number;
    has_large_files?: boolean;
    large_files_count?: number;
    large_files_size?: number;
    percent?: number;
    status_text?: string;
    tfvc_project?: string;
};
declare type MigrationsStartImportResponse = {
    authors_count: number;
    authors_url: string;
    commit_count: number;
    has_large_files: boolean;
    html_url: string;
    large_files_count: number;
    large_files_size: number;
    percent: number;
    repository_url: string;
    status: string;
    status_text: string;
    url: string;
    use_lfs: string;
    vcs: string;
    vcs_url: string;
};
declare type MigrationsStartForOrgResponseRepositoriesItemPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type MigrationsStartForOrgResponseRepositoriesItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type MigrationsStartForOrgResponseRepositoriesItem = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: MigrationsStartForOrgResponseRepositoriesItemOwner;
    permissions: MigrationsStartForOrgResponseRepositoriesItemPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type MigrationsStartForOrgResponseOwner = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
};
declare type MigrationsStartForOrgResponse = {
    created_at: string;
    exclude_attachments: boolean;
    guid: string;
    id: number;
    lock_repositories: boolean;
    owner: MigrationsStartForOrgResponseOwner;
    repositories: Array<MigrationsStartForOrgResponseRepositoriesItem>;
    state: string;
    updated_at: string;
    url: string;
};
declare type MigrationsStartForAuthenticatedUserResponseRepositoriesItemPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type MigrationsStartForAuthenticatedUserResponseRepositoriesItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type MigrationsStartForAuthenticatedUserResponseRepositoriesItem = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: MigrationsStartForAuthenticatedUserResponseRepositoriesItemOwner;
    permissions: MigrationsStartForAuthenticatedUserResponseRepositoriesItemPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type MigrationsStartForAuthenticatedUserResponseOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type MigrationsStartForAuthenticatedUserResponse = {
    created_at: string;
    exclude_attachments: boolean;
    guid: string;
    id: number;
    lock_repositories: boolean;
    owner: MigrationsStartForAuthenticatedUserResponseOwner;
    repositories: Array<MigrationsStartForAuthenticatedUserResponseRepositoriesItem>;
    state: string;
    updated_at: string;
    url: string;
};
declare type MigrationsSetLfsPreferenceResponse = {
    authors_count: number;
    authors_url: string;
    has_large_files: boolean;
    html_url: string;
    large_files_count: number;
    large_files_size: number;
    repository_url: string;
    status: string;
    status_text: string;
    url: string;
    use_lfs: string;
    vcs: string;
    vcs_url: string;
};
declare type MigrationsMapCommitAuthorResponse = {
    email: string;
    id: number;
    import_url: string;
    name: string;
    remote_id: string;
    remote_name: string;
    url: string;
};
declare type MigrationsListReposForUserResponseItemPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type MigrationsListReposForUserResponseItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type MigrationsListReposForUserResponseItemLicense = {
    key: string;
    name: string;
    node_id: string;
    spdx_id: string;
    url: string;
};
declare type MigrationsListReposForUserResponseItem = {
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    license: MigrationsListReposForUserResponseItemLicense;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: MigrationsListReposForUserResponseItemOwner;
    permissions: MigrationsListReposForUserResponseItemPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type MigrationsListReposForOrgResponseItemPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type MigrationsListReposForOrgResponseItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type MigrationsListReposForOrgResponseItemLicense = {
    key: string;
    name: string;
    node_id: string;
    spdx_id: string;
    url: string;
};
declare type MigrationsListReposForOrgResponseItem = {
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    license: MigrationsListReposForOrgResponseItemLicense;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: MigrationsListReposForOrgResponseItemOwner;
    permissions: MigrationsListReposForOrgResponseItemPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type MigrationsListForOrgResponseItemRepositoriesItemPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type MigrationsListForOrgResponseItemRepositoriesItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type MigrationsListForOrgResponseItemRepositoriesItem = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: MigrationsListForOrgResponseItemRepositoriesItemOwner;
    permissions: MigrationsListForOrgResponseItemRepositoriesItemPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type MigrationsListForOrgResponseItemOwner = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
};
declare type MigrationsListForOrgResponseItem = {
    created_at: string;
    exclude_attachments: boolean;
    guid: string;
    id: number;
    lock_repositories: boolean;
    owner: MigrationsListForOrgResponseItemOwner;
    repositories: Array<MigrationsListForOrgResponseItemRepositoriesItem>;
    state: string;
    updated_at: string;
    url: string;
};
declare type MigrationsListForAuthenticatedUserResponseItemRepositoriesItemPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type MigrationsListForAuthenticatedUserResponseItemRepositoriesItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type MigrationsListForAuthenticatedUserResponseItemRepositoriesItem = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: MigrationsListForAuthenticatedUserResponseItemRepositoriesItemOwner;
    permissions: MigrationsListForAuthenticatedUserResponseItemRepositoriesItemPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type MigrationsListForAuthenticatedUserResponseItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type MigrationsListForAuthenticatedUserResponseItem = {
    created_at: string;
    exclude_attachments: boolean;
    guid: string;
    id: number;
    lock_repositories: boolean;
    owner: MigrationsListForAuthenticatedUserResponseItemOwner;
    repositories: Array<MigrationsListForAuthenticatedUserResponseItemRepositoriesItem>;
    state: string;
    updated_at: string;
    url: string;
};
declare type MigrationsGetStatusForOrgResponseRepositoriesItemPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type MigrationsGetStatusForOrgResponseRepositoriesItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type MigrationsGetStatusForOrgResponseRepositoriesItem = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: MigrationsGetStatusForOrgResponseRepositoriesItemOwner;
    permissions: MigrationsGetStatusForOrgResponseRepositoriesItemPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type MigrationsGetStatusForOrgResponseOwner = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
};
declare type MigrationsGetStatusForOrgResponse = {
    created_at: string;
    exclude_attachments: boolean;
    guid: string;
    id: number;
    lock_repositories: boolean;
    owner: MigrationsGetStatusForOrgResponseOwner;
    repositories: Array<MigrationsGetStatusForOrgResponseRepositoriesItem>;
    state: string;
    updated_at: string;
    url: string;
};
declare type MigrationsGetStatusForAuthenticatedUserResponseRepositoriesItemPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type MigrationsGetStatusForAuthenticatedUserResponseRepositoriesItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type MigrationsGetStatusForAuthenticatedUserResponseRepositoriesItem = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: MigrationsGetStatusForAuthenticatedUserResponseRepositoriesItemOwner;
    permissions: MigrationsGetStatusForAuthenticatedUserResponseRepositoriesItemPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type MigrationsGetStatusForAuthenticatedUserResponseOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type MigrationsGetStatusForAuthenticatedUserResponse = {
    created_at: string;
    exclude_attachments: boolean;
    guid: string;
    id: number;
    lock_repositories: boolean;
    owner: MigrationsGetStatusForAuthenticatedUserResponseOwner;
    repositories: Array<MigrationsGetStatusForAuthenticatedUserResponseRepositoriesItem>;
    state: string;
    updated_at: string;
    url: string;
};
declare type MigrationsGetLargeFilesResponseItem = {
    oid: string;
    path: string;
    ref_name: string;
    size: number;
};
declare type MigrationsGetImportProgressResponse = {
    authors_count: number;
    authors_url: string;
    has_large_files: boolean;
    html_url: string;
    large_files_count: number;
    large_files_size: number;
    repository_url: string;
    status: string;
    status_text: string;
    url: string;
    use_lfs: string;
    vcs: string;
    vcs_url: string;
};
declare type MigrationsGetCommitAuthorsResponseItem = {
    email: string;
    id: number;
    import_url: string;
    name: string;
    remote_id: string;
    remote_name: string;
    url: string;
};
declare type MetaGetResponseSshKeyFingerprints = {
    MD5_DSA: string;
    MD5_RSA: string;
    SHA256_DSA: string;
    SHA256_RSA: string;
};
declare type MetaGetResponse = {
    api: Array<string>;
    git: Array<string>;
    hooks: Array<string>;
    importer: Array<string>;
    pages: Array<string>;
    ssh_key_fingerprints: MetaGetResponseSshKeyFingerprints;
    verifiable_password_authentication: boolean;
    web: Array<string>;
};
declare type LicensesListCommonlyUsedResponseItem = {
    key: string;
    name: string;
    node_id?: string;
    spdx_id: string;
    url: string;
};
declare type LicensesListResponseItem = {
    key: string;
    name: string;
    node_id?: string;
    spdx_id: string;
    url: string;
};
declare type LicensesGetForRepoResponseLicense = {
    key: string;
    name: string;
    node_id: string;
    spdx_id: string;
    url: string;
};
declare type LicensesGetForRepoResponseLinks = {
    git: string;
    html: string;
    self: string;
};
declare type LicensesGetForRepoResponse = {
    _links: LicensesGetForRepoResponseLinks;
    content: string;
    download_url: string;
    encoding: string;
    git_url: string;
    html_url: string;
    license: LicensesGetForRepoResponseLicense;
    name: string;
    path: string;
    sha: string;
    size: number;
    type: string;
    url: string;
};
declare type LicensesGetResponse = {
    body: string;
    conditions: Array<string>;
    description: string;
    featured: boolean;
    html_url: string;
    implementation: string;
    key: string;
    limitations: Array<string>;
    name: string;
    node_id: string;
    permissions: Array<string>;
    spdx_id: string;
    url: string;
};
declare type IssuesUpdateMilestoneResponseCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesUpdateMilestoneResponse = {
    closed_at: string;
    closed_issues: number;
    created_at: string;
    creator: IssuesUpdateMilestoneResponseCreator;
    description: string;
    due_on: string;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    number: number;
    open_issues: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
};
declare type IssuesUpdateLabelResponse = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
};
declare type IssuesUpdateCommentResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesUpdateCommentResponse = {
    body: string;
    created_at: string;
    html_url: string;
    id: number;
    node_id: string;
    updated_at: string;
    url: string;
    user: IssuesUpdateCommentResponseUser;
};
declare type IssuesUpdateResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesUpdateResponsePullRequest = {
    diff_url: string;
    html_url: string;
    patch_url: string;
    url: string;
};
declare type IssuesUpdateResponseMilestoneCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesUpdateResponseMilestone = {
    closed_at: string;
    closed_issues: number;
    created_at: string;
    creator: IssuesUpdateResponseMilestoneCreator;
    description: string;
    due_on: string;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    number: number;
    open_issues: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
};
declare type IssuesUpdateResponseLabelsItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
};
declare type IssuesUpdateResponseClosedBy = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesUpdateResponseAssigneesItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesUpdateResponseAssignee = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesUpdateResponse = {
    active_lock_reason: string;
    assignee: IssuesUpdateResponseAssignee;
    assignees: Array<IssuesUpdateResponseAssigneesItem>;
    body: string;
    closed_at: null;
    closed_by: IssuesUpdateResponseClosedBy;
    comments: number;
    comments_url: string;
    created_at: string;
    events_url: string;
    html_url: string;
    id: number;
    labels: Array<IssuesUpdateResponseLabelsItem>;
    labels_url: string;
    locked: boolean;
    milestone: IssuesUpdateResponseMilestone;
    node_id: string;
    number: number;
    pull_request: IssuesUpdateResponsePullRequest;
    repository_url: string;
    state: string;
    title: string;
    updated_at: string;
    url: string;
    user: IssuesUpdateResponseUser;
};
declare type IssuesReplaceLabelsResponseItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
};
declare type IssuesRemoveLabelResponseItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
};
declare type IssuesRemoveAssigneesResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesRemoveAssigneesResponsePullRequest = {
    diff_url: string;
    html_url: string;
    patch_url: string;
    url: string;
};
declare type IssuesRemoveAssigneesResponseMilestoneCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesRemoveAssigneesResponseMilestone = {
    closed_at: string;
    closed_issues: number;
    created_at: string;
    creator: IssuesRemoveAssigneesResponseMilestoneCreator;
    description: string;
    due_on: string;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    number: number;
    open_issues: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
};
declare type IssuesRemoveAssigneesResponseLabelsItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
};
declare type IssuesRemoveAssigneesResponseAssigneesItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesRemoveAssigneesResponseAssignee = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesRemoveAssigneesResponse = {
    active_lock_reason: string;
    assignee: IssuesRemoveAssigneesResponseAssignee;
    assignees: Array<IssuesRemoveAssigneesResponseAssigneesItem>;
    body: string;
    closed_at: null;
    comments: number;
    comments_url: string;
    created_at: string;
    events_url: string;
    html_url: string;
    id: number;
    labels: Array<IssuesRemoveAssigneesResponseLabelsItem>;
    labels_url: string;
    locked: boolean;
    milestone: IssuesRemoveAssigneesResponseMilestone;
    node_id: string;
    number: number;
    pull_request: IssuesRemoveAssigneesResponsePullRequest;
    repository_url: string;
    state: string;
    title: string;
    updated_at: string;
    url: string;
    user: IssuesRemoveAssigneesResponseUser;
};
declare type IssuesListMilestonesForRepoResponseItemCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesListMilestonesForRepoResponseItem = {
    closed_at: string;
    closed_issues: number;
    created_at: string;
    creator: IssuesListMilestonesForRepoResponseItemCreator;
    description: string;
    due_on: string;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    number: number;
    open_issues: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
};
declare type IssuesListLabelsOnIssueResponseItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
};
declare type IssuesListLabelsForRepoResponseItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
};
declare type IssuesListLabelsForMilestoneResponseItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
};
declare type IssuesListForRepoResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesListForRepoResponseItemPullRequest = {
    diff_url: string;
    html_url: string;
    patch_url: string;
    url: string;
};
declare type IssuesListForRepoResponseItemMilestoneCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesListForRepoResponseItemMilestone = {
    closed_at: string;
    closed_issues: number;
    created_at: string;
    creator: IssuesListForRepoResponseItemMilestoneCreator;
    description: string;
    due_on: string;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    number: number;
    open_issues: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
};
declare type IssuesListForRepoResponseItemLabelsItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
};
declare type IssuesListForRepoResponseItemAssigneesItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesListForRepoResponseItemAssignee = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesListForRepoResponseItem = {
    active_lock_reason: string;
    assignee: IssuesListForRepoResponseItemAssignee;
    assignees: Array<IssuesListForRepoResponseItemAssigneesItem>;
    body: string;
    closed_at: null;
    comments: number;
    comments_url: string;
    created_at: string;
    events_url: string;
    html_url: string;
    id: number;
    labels: Array<IssuesListForRepoResponseItemLabelsItem>;
    labels_url: string;
    locked: boolean;
    milestone: IssuesListForRepoResponseItemMilestone;
    node_id: string;
    number: number;
    pull_request: IssuesListForRepoResponseItemPullRequest;
    repository_url: string;
    state: string;
    title: string;
    updated_at: string;
    url: string;
    user: IssuesListForRepoResponseItemUser;
};
declare type IssuesListForOrgResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesListForOrgResponseItemRepositoryPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type IssuesListForOrgResponseItemRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesListForOrgResponseItemRepository = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: IssuesListForOrgResponseItemRepositoryOwner;
    permissions: IssuesListForOrgResponseItemRepositoryPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type IssuesListForOrgResponseItemPullRequest = {
    diff_url: string;
    html_url: string;
    patch_url: string;
    url: string;
};
declare type IssuesListForOrgResponseItemMilestoneCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesListForOrgResponseItemMilestone = {
    closed_at: string;
    closed_issues: number;
    created_at: string;
    creator: IssuesListForOrgResponseItemMilestoneCreator;
    description: string;
    due_on: string;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    number: number;
    open_issues: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
};
declare type IssuesListForOrgResponseItemLabelsItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
};
declare type IssuesListForOrgResponseItemAssigneesItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesListForOrgResponseItemAssignee = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesListForOrgResponseItem = {
    active_lock_reason: string;
    assignee: IssuesListForOrgResponseItemAssignee;
    assignees: Array<IssuesListForOrgResponseItemAssigneesItem>;
    body: string;
    closed_at: null;
    comments: number;
    comments_url: string;
    created_at: string;
    events_url: string;
    html_url: string;
    id: number;
    labels: Array<IssuesListForOrgResponseItemLabelsItem>;
    labels_url: string;
    locked: boolean;
    milestone: IssuesListForOrgResponseItemMilestone;
    node_id: string;
    number: number;
    pull_request: IssuesListForOrgResponseItemPullRequest;
    repository: IssuesListForOrgResponseItemRepository;
    repository_url: string;
    state: string;
    title: string;
    updated_at: string;
    url: string;
    user: IssuesListForOrgResponseItemUser;
};
declare type IssuesListForAuthenticatedUserResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesListForAuthenticatedUserResponseItemRepositoryPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type IssuesListForAuthenticatedUserResponseItemRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesListForAuthenticatedUserResponseItemRepository = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: IssuesListForAuthenticatedUserResponseItemRepositoryOwner;
    permissions: IssuesListForAuthenticatedUserResponseItemRepositoryPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type IssuesListForAuthenticatedUserResponseItemPullRequest = {
    diff_url: string;
    html_url: string;
    patch_url: string;
    url: string;
};
declare type IssuesListForAuthenticatedUserResponseItemMilestoneCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesListForAuthenticatedUserResponseItemMilestone = {
    closed_at: string;
    closed_issues: number;
    created_at: string;
    creator: IssuesListForAuthenticatedUserResponseItemMilestoneCreator;
    description: string;
    due_on: string;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    number: number;
    open_issues: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
};
declare type IssuesListForAuthenticatedUserResponseItemLabelsItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
};
declare type IssuesListForAuthenticatedUserResponseItemAssigneesItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesListForAuthenticatedUserResponseItemAssignee = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesListForAuthenticatedUserResponseItem = {
    active_lock_reason: string;
    assignee: IssuesListForAuthenticatedUserResponseItemAssignee;
    assignees: Array<IssuesListForAuthenticatedUserResponseItemAssigneesItem>;
    body: string;
    closed_at: null;
    comments: number;
    comments_url: string;
    created_at: string;
    events_url: string;
    html_url: string;
    id: number;
    labels: Array<IssuesListForAuthenticatedUserResponseItemLabelsItem>;
    labels_url: string;
    locked: boolean;
    milestone: IssuesListForAuthenticatedUserResponseItemMilestone;
    node_id: string;
    number: number;
    pull_request: IssuesListForAuthenticatedUserResponseItemPullRequest;
    repository: IssuesListForAuthenticatedUserResponseItemRepository;
    repository_url: string;
    state: string;
    title: string;
    updated_at: string;
    url: string;
    user: IssuesListForAuthenticatedUserResponseItemUser;
};
declare type IssuesListEventsForTimelineResponseItemActor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesListEventsForTimelineResponseItem = {
    actor: IssuesListEventsForTimelineResponseItemActor;
    commit_id: string;
    commit_url: string;
    created_at: string;
    event: string;
    id: number;
    node_id: string;
    url: string;
};
declare type IssuesListEventsForRepoResponseItemIssueUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesListEventsForRepoResponseItemIssuePullRequest = {
    diff_url: string;
    html_url: string;
    patch_url: string;
    url: string;
};
declare type IssuesListEventsForRepoResponseItemIssueMilestoneCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesListEventsForRepoResponseItemIssueMilestone = {
    closed_at: string;
    closed_issues: number;
    created_at: string;
    creator: IssuesListEventsForRepoResponseItemIssueMilestoneCreator;
    description: string;
    due_on: string;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    number: number;
    open_issues: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
};
declare type IssuesListEventsForRepoResponseItemIssueLabelsItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
};
declare type IssuesListEventsForRepoResponseItemIssueAssigneesItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesListEventsForRepoResponseItemIssueAssignee = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesListEventsForRepoResponseItemIssue = {
    active_lock_reason: string;
    assignee: IssuesListEventsForRepoResponseItemIssueAssignee;
    assignees: Array<IssuesListEventsForRepoResponseItemIssueAssigneesItem>;
    body: string;
    closed_at: null;
    comments: number;
    comments_url: string;
    created_at: string;
    events_url: string;
    html_url: string;
    id: number;
    labels: Array<IssuesListEventsForRepoResponseItemIssueLabelsItem>;
    labels_url: string;
    locked: boolean;
    milestone: IssuesListEventsForRepoResponseItemIssueMilestone;
    node_id: string;
    number: number;
    pull_request: IssuesListEventsForRepoResponseItemIssuePullRequest;
    repository_url: string;
    state: string;
    title: string;
    updated_at: string;
    url: string;
    user: IssuesListEventsForRepoResponseItemIssueUser;
};
declare type IssuesListEventsForRepoResponseItemActor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesListEventsForRepoResponseItem = {
    actor: IssuesListEventsForRepoResponseItemActor;
    commit_id: string;
    commit_url: string;
    created_at: string;
    event: string;
    id: number;
    issue: IssuesListEventsForRepoResponseItemIssue;
    node_id: string;
    url: string;
};
declare type IssuesListEventsResponseItemActor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesListEventsResponseItem = {
    actor: IssuesListEventsResponseItemActor;
    commit_id: string;
    commit_url: string;
    created_at: string;
    event: string;
    id: number;
    node_id: string;
    url: string;
};
declare type IssuesListCommentsForRepoResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesListCommentsForRepoResponseItem = {
    body: string;
    created_at: string;
    html_url: string;
    id: number;
    node_id: string;
    updated_at: string;
    url: string;
    user: IssuesListCommentsForRepoResponseItemUser;
};
declare type IssuesListCommentsResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesListCommentsResponseItem = {
    body: string;
    created_at: string;
    html_url: string;
    id: number;
    node_id: string;
    updated_at: string;
    url: string;
    user: IssuesListCommentsResponseItemUser;
};
declare type IssuesListAssigneesResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesListResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesListResponseItemRepositoryPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type IssuesListResponseItemRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesListResponseItemRepository = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: IssuesListResponseItemRepositoryOwner;
    permissions: IssuesListResponseItemRepositoryPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type IssuesListResponseItemPullRequest = {
    diff_url: string;
    html_url: string;
    patch_url: string;
    url: string;
};
declare type IssuesListResponseItemMilestoneCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesListResponseItemMilestone = {
    closed_at: string;
    closed_issues: number;
    created_at: string;
    creator: IssuesListResponseItemMilestoneCreator;
    description: string;
    due_on: string;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    number: number;
    open_issues: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
};
declare type IssuesListResponseItemLabelsItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
};
declare type IssuesListResponseItemAssigneesItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesListResponseItemAssignee = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesListResponseItem = {
    active_lock_reason: string;
    assignee: IssuesListResponseItemAssignee;
    assignees: Array<IssuesListResponseItemAssigneesItem>;
    body: string;
    closed_at: null;
    comments: number;
    comments_url: string;
    created_at: string;
    events_url: string;
    html_url: string;
    id: number;
    labels: Array<IssuesListResponseItemLabelsItem>;
    labels_url: string;
    locked: boolean;
    milestone: IssuesListResponseItemMilestone;
    node_id: string;
    number: number;
    pull_request: IssuesListResponseItemPullRequest;
    repository: IssuesListResponseItemRepository;
    repository_url: string;
    state: string;
    title: string;
    updated_at: string;
    url: string;
    user: IssuesListResponseItemUser;
};
declare type IssuesGetMilestoneResponseCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesGetMilestoneResponse = {
    closed_at: string;
    closed_issues: number;
    created_at: string;
    creator: IssuesGetMilestoneResponseCreator;
    description: string;
    due_on: string;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    number: number;
    open_issues: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
};
declare type IssuesGetLabelResponse = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
};
declare type IssuesGetEventResponseIssueUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesGetEventResponseIssuePullRequest = {
    diff_url: string;
    html_url: string;
    patch_url: string;
    url: string;
};
declare type IssuesGetEventResponseIssueMilestoneCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesGetEventResponseIssueMilestone = {
    closed_at: string;
    closed_issues: number;
    created_at: string;
    creator: IssuesGetEventResponseIssueMilestoneCreator;
    description: string;
    due_on: string;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    number: number;
    open_issues: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
};
declare type IssuesGetEventResponseIssueLabelsItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
};
declare type IssuesGetEventResponseIssueAssigneesItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesGetEventResponseIssueAssignee = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesGetEventResponseIssue = {
    active_lock_reason: string;
    assignee: IssuesGetEventResponseIssueAssignee;
    assignees: Array<IssuesGetEventResponseIssueAssigneesItem>;
    body: string;
    closed_at: null;
    comments: number;
    comments_url: string;
    created_at: string;
    events_url: string;
    html_url: string;
    id: number;
    labels: Array<IssuesGetEventResponseIssueLabelsItem>;
    labels_url: string;
    locked: boolean;
    milestone: IssuesGetEventResponseIssueMilestone;
    node_id: string;
    number: number;
    pull_request: IssuesGetEventResponseIssuePullRequest;
    repository_url: string;
    state: string;
    title: string;
    updated_at: string;
    url: string;
    user: IssuesGetEventResponseIssueUser;
};
declare type IssuesGetEventResponseActor = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesGetEventResponse = {
    actor: IssuesGetEventResponseActor;
    commit_id: string;
    commit_url: string;
    created_at: string;
    event: string;
    id: number;
    issue: IssuesGetEventResponseIssue;
    node_id: string;
    url: string;
};
declare type IssuesGetCommentResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesGetCommentResponse = {
    body: string;
    created_at: string;
    html_url: string;
    id: number;
    node_id: string;
    updated_at: string;
    url: string;
    user: IssuesGetCommentResponseUser;
};
declare type IssuesGetResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesGetResponsePullRequest = {
    diff_url: string;
    html_url: string;
    patch_url: string;
    url: string;
};
declare type IssuesGetResponseMilestoneCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesGetResponseMilestone = {
    closed_at: string;
    closed_issues: number;
    created_at: string;
    creator: IssuesGetResponseMilestoneCreator;
    description: string;
    due_on: string;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    number: number;
    open_issues: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
};
declare type IssuesGetResponseLabelsItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
};
declare type IssuesGetResponseClosedBy = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesGetResponseAssigneesItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesGetResponseAssignee = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesGetResponse = {
    active_lock_reason: string;
    assignee: IssuesGetResponseAssignee;
    assignees: Array<IssuesGetResponseAssigneesItem>;
    body: string;
    closed_at: null;
    closed_by: IssuesGetResponseClosedBy;
    comments: number;
    comments_url: string;
    created_at: string;
    events_url: string;
    html_url: string;
    id: number;
    labels: Array<IssuesGetResponseLabelsItem>;
    labels_url: string;
    locked: boolean;
    milestone: IssuesGetResponseMilestone;
    node_id: string;
    number: number;
    pull_request: IssuesGetResponsePullRequest;
    repository_url: string;
    state: string;
    title: string;
    updated_at: string;
    url: string;
    user: IssuesGetResponseUser;
};
declare type IssuesCreateMilestoneResponseCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesCreateMilestoneResponse = {
    closed_at: string;
    closed_issues: number;
    created_at: string;
    creator: IssuesCreateMilestoneResponseCreator;
    description: string;
    due_on: string;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    number: number;
    open_issues: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
};
declare type IssuesCreateLabelResponse = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
};
declare type IssuesCreateCommentResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesCreateCommentResponse = {
    body: string;
    created_at: string;
    html_url: string;
    id: number;
    node_id: string;
    updated_at: string;
    url: string;
    user: IssuesCreateCommentResponseUser;
};
declare type IssuesCreateResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesCreateResponsePullRequest = {
    diff_url: string;
    html_url: string;
    patch_url: string;
    url: string;
};
declare type IssuesCreateResponseMilestoneCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesCreateResponseMilestone = {
    closed_at: string;
    closed_issues: number;
    created_at: string;
    creator: IssuesCreateResponseMilestoneCreator;
    description: string;
    due_on: string;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    number: number;
    open_issues: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
};
declare type IssuesCreateResponseLabelsItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
};
declare type IssuesCreateResponseClosedBy = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesCreateResponseAssigneesItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesCreateResponseAssignee = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesCreateResponse = {
    active_lock_reason: string;
    assignee: IssuesCreateResponseAssignee;
    assignees: Array<IssuesCreateResponseAssigneesItem>;
    body: string;
    closed_at: null;
    closed_by: IssuesCreateResponseClosedBy;
    comments: number;
    comments_url: string;
    created_at: string;
    events_url: string;
    html_url: string;
    id: number;
    labels: Array<IssuesCreateResponseLabelsItem>;
    labels_url: string;
    locked: boolean;
    milestone: IssuesCreateResponseMilestone;
    node_id: string;
    number: number;
    pull_request: IssuesCreateResponsePullRequest;
    repository_url: string;
    state: string;
    title: string;
    updated_at: string;
    url: string;
    user: IssuesCreateResponseUser;
};
declare type IssuesAddLabelsResponseItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
};
declare type IssuesAddAssigneesResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesAddAssigneesResponsePullRequest = {
    diff_url: string;
    html_url: string;
    patch_url: string;
    url: string;
};
declare type IssuesAddAssigneesResponseMilestoneCreator = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesAddAssigneesResponseMilestone = {
    closed_at: string;
    closed_issues: number;
    created_at: string;
    creator: IssuesAddAssigneesResponseMilestoneCreator;
    description: string;
    due_on: string;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    number: number;
    open_issues: number;
    state: string;
    title: string;
    updated_at: string;
    url: string;
};
declare type IssuesAddAssigneesResponseLabelsItem = {
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
};
declare type IssuesAddAssigneesResponseAssigneesItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesAddAssigneesResponseAssignee = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type IssuesAddAssigneesResponse = {
    active_lock_reason: string;
    assignee: IssuesAddAssigneesResponseAssignee;
    assignees: Array<IssuesAddAssigneesResponseAssigneesItem>;
    body: string;
    closed_at: null;
    comments: number;
    comments_url: string;
    created_at: string;
    events_url: string;
    html_url: string;
    id: number;
    labels: Array<IssuesAddAssigneesResponseLabelsItem>;
    labels_url: string;
    locked: boolean;
    milestone: IssuesAddAssigneesResponseMilestone;
    node_id: string;
    number: number;
    pull_request: IssuesAddAssigneesResponsePullRequest;
    repository_url: string;
    state: string;
    title: string;
    updated_at: string;
    url: string;
    user: IssuesAddAssigneesResponseUser;
};
declare type InteractionsGetRestrictionsForRepoResponse = {
    expires_at: string;
    limit: string;
    origin: string;
};
declare type InteractionsGetRestrictionsForOrgResponse = {
    expires_at: string;
    limit: string;
    origin: string;
};
declare type InteractionsAddOrUpdateRestrictionsForRepoResponse = {
    expires_at: string;
    limit: string;
    origin: string;
};
declare type InteractionsAddOrUpdateRestrictionsForOrgResponse = {
    expires_at: string;
    limit: string;
    origin: string;
};
declare type GitignoreGetTemplateResponse = {
    name: string;
    source: string;
};
declare type GitUpdateRefResponseObject = {
    sha: string;
    type: string;
    url: string;
};
declare type GitUpdateRefResponse = {
    node_id: string;
    object: GitUpdateRefResponseObject;
    ref: string;
    url: string;
};
declare type GitListMatchingRefsResponseItemObject = {
    sha: string;
    type: string;
    url: string;
};
declare type GitListMatchingRefsResponseItem = {
    node_id: string;
    object: GitListMatchingRefsResponseItemObject;
    ref: string;
    url: string;
};
declare type GitGetTreeResponseTreeItem = {
    mode: string;
    path: string;
    sha: string;
    size?: number;
    type: string;
    url: string;
};
declare type GitGetTreeResponse = {
    sha: string;
    tree: Array<GitGetTreeResponseTreeItem>;
    truncated: boolean;
    url: string;
};
declare type GitGetTagResponseVerification = {
    payload: null;
    reason: string;
    signature: null;
    verified: boolean;
};
declare type GitGetTagResponseTagger = {
    date: string;
    email: string;
    name: string;
};
declare type GitGetTagResponseObject = {
    sha: string;
    type: string;
    url: string;
};
declare type GitGetTagResponse = {
    message: string;
    node_id: string;
    object: GitGetTagResponseObject;
    sha: string;
    tag: string;
    tagger: GitGetTagResponseTagger;
    url: string;
    verification: GitGetTagResponseVerification;
};
declare type GitGetRefResponseObject = {
    sha: string;
    type: string;
    url: string;
};
declare type GitGetRefResponse = {
    node_id: string;
    object: GitGetRefResponseObject;
    ref: string;
    url: string;
};
declare type GitGetCommitResponseVerification = {
    payload: null;
    reason: string;
    signature: null;
    verified: boolean;
};
declare type GitGetCommitResponseTree = {
    sha: string;
    url: string;
};
declare type GitGetCommitResponseParentsItem = {
    sha: string;
    url: string;
};
declare type GitGetCommitResponseCommitter = {
    date: string;
    email: string;
    name: string;
};
declare type GitGetCommitResponseAuthor = {
    date: string;
    email: string;
    name: string;
};
declare type GitGetCommitResponse = {
    author: GitGetCommitResponseAuthor;
    committer: GitGetCommitResponseCommitter;
    message: string;
    parents: Array<GitGetCommitResponseParentsItem>;
    sha: string;
    tree: GitGetCommitResponseTree;
    url: string;
    verification: GitGetCommitResponseVerification;
};
declare type GitGetBlobResponse = {
    content: string;
    encoding: string;
    sha: string;
    size: number;
    url: string;
};
declare type GitCreateTreeResponseTreeItem = {
    mode: string;
    path: string;
    sha: string;
    size: number;
    type: string;
    url: string;
};
declare type GitCreateTreeResponse = {
    sha: string;
    tree: Array<GitCreateTreeResponseTreeItem>;
    url: string;
};
declare type GitCreateTagResponseVerification = {
    payload: null;
    reason: string;
    signature: null;
    verified: boolean;
};
declare type GitCreateTagResponseTagger = {
    date: string;
    email: string;
    name: string;
};
declare type GitCreateTagResponseObject = {
    sha: string;
    type: string;
    url: string;
};
declare type GitCreateTagResponse = {
    message: string;
    node_id: string;
    object: GitCreateTagResponseObject;
    sha: string;
    tag: string;
    tagger: GitCreateTagResponseTagger;
    url: string;
    verification: GitCreateTagResponseVerification;
};
declare type GitCreateRefResponseObject = {
    sha: string;
    type: string;
    url: string;
};
declare type GitCreateRefResponse = {
    node_id: string;
    object: GitCreateRefResponseObject;
    ref: string;
    url: string;
};
declare type GitCreateCommitResponseVerification = {
    payload: null;
    reason: string;
    signature: null;
    verified: boolean;
};
declare type GitCreateCommitResponseTree = {
    sha: string;
    url: string;
};
declare type GitCreateCommitResponseParentsItem = {
    sha: string;
    url: string;
};
declare type GitCreateCommitResponseCommitter = {
    date: string;
    email: string;
    name: string;
};
declare type GitCreateCommitResponseAuthor = {
    date: string;
    email: string;
    name: string;
};
declare type GitCreateCommitResponse = {
    author: GitCreateCommitResponseAuthor;
    committer: GitCreateCommitResponseCommitter;
    message: string;
    node_id: string;
    parents: Array<GitCreateCommitResponseParentsItem>;
    sha: string;
    tree: GitCreateCommitResponseTree;
    url: string;
    verification: GitCreateCommitResponseVerification;
};
declare type GitCreateBlobResponse = {
    sha: string;
    url: string;
};
declare type GistsUpdateCommentResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type GistsUpdateCommentResponse = {
    body: string;
    created_at: string;
    id: number;
    node_id: string;
    updated_at: string;
    url: string;
    user: GistsUpdateCommentResponseUser;
};
declare type GistsUpdateResponseOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type GistsUpdateResponseHistoryItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type GistsUpdateResponseHistoryItemChangeStatus = {
    additions: number;
    deletions: number;
    total: number;
};
declare type GistsUpdateResponseHistoryItem = {
    change_status: GistsUpdateResponseHistoryItemChangeStatus;
    committed_at: string;
    url: string;
    user: GistsUpdateResponseHistoryItemUser;
    version: string;
};
declare type GistsUpdateResponseForksItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type GistsUpdateResponseForksItem = {
    created_at: string;
    id: string;
    updated_at: string;
    url: string;
    user: GistsUpdateResponseForksItemUser;
};
declare type GistsUpdateResponseFilesNewFileTxt = {
    content: string;
    filename: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    type: string;
};
declare type GistsUpdateResponseFilesHelloWorldRb = {
    content: string;
    filename: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    type: string;
};
declare type GistsUpdateResponseFilesHelloWorldPy = {
    content: string;
    filename: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    type: string;
};
declare type GistsUpdateResponseFilesHelloWorldMd = {
    content: string;
    filename: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    type: string;
};
declare type GistsUpdateResponseFiles = {
    "hello_world.md": GistsUpdateResponseFilesHelloWorldMd;
    "hello_world.py": GistsUpdateResponseFilesHelloWorldPy;
    "hello_world.rb": GistsUpdateResponseFilesHelloWorldRb;
    "new_file.txt": GistsUpdateResponseFilesNewFileTxt;
};
declare type GistsUpdateResponse = {
    comments: number;
    comments_url: string;
    commits_url: string;
    created_at: string;
    description: string;
    files: GistsUpdateResponseFiles;
    forks: Array<GistsUpdateResponseForksItem>;
    forks_url: string;
    git_pull_url: string;
    git_push_url: string;
    history: Array<GistsUpdateResponseHistoryItem>;
    html_url: string;
    id: string;
    node_id: string;
    owner: GistsUpdateResponseOwner;
    public: boolean;
    truncated: boolean;
    updated_at: string;
    url: string;
    user: null;
};
declare type GistsListStarredResponseItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type GistsListStarredResponseItemFilesHelloWorldRb = {
    filename: string;
    language: string;
    raw_url: string;
    size: number;
    type: string;
};
declare type GistsListStarredResponseItemFiles = {
    "hello_world.rb": GistsListStarredResponseItemFilesHelloWorldRb;
};
declare type GistsListStarredResponseItem = {
    comments: number;
    comments_url: string;
    commits_url: string;
    created_at: string;
    description: string;
    files: GistsListStarredResponseItemFiles;
    forks_url: string;
    git_pull_url: string;
    git_push_url: string;
    html_url: string;
    id: string;
    node_id: string;
    owner: GistsListStarredResponseItemOwner;
    public: boolean;
    truncated: boolean;
    updated_at: string;
    url: string;
    user: null;
};
declare type GistsListPublicForUserResponseItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type GistsListPublicForUserResponseItemFilesHelloWorldRb = {
    filename: string;
    language: string;
    raw_url: string;
    size: number;
    type: string;
};
declare type GistsListPublicForUserResponseItemFiles = {
    "hello_world.rb": GistsListPublicForUserResponseItemFilesHelloWorldRb;
};
declare type GistsListPublicForUserResponseItem = {
    comments: number;
    comments_url: string;
    commits_url: string;
    created_at: string;
    description: string;
    files: GistsListPublicForUserResponseItemFiles;
    forks_url: string;
    git_pull_url: string;
    git_push_url: string;
    html_url: string;
    id: string;
    node_id: string;
    owner: GistsListPublicForUserResponseItemOwner;
    public: boolean;
    truncated: boolean;
    updated_at: string;
    url: string;
    user: null;
};
declare type GistsListPublicResponseItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type GistsListPublicResponseItemFilesHelloWorldRb = {
    filename: string;
    language: string;
    raw_url: string;
    size: number;
    type: string;
};
declare type GistsListPublicResponseItemFiles = {
    "hello_world.rb": GistsListPublicResponseItemFilesHelloWorldRb;
};
declare type GistsListPublicResponseItem = {
    comments: number;
    comments_url: string;
    commits_url: string;
    created_at: string;
    description: string;
    files: GistsListPublicResponseItemFiles;
    forks_url: string;
    git_pull_url: string;
    git_push_url: string;
    html_url: string;
    id: string;
    node_id: string;
    owner: GistsListPublicResponseItemOwner;
    public: boolean;
    truncated: boolean;
    updated_at: string;
    url: string;
    user: null;
};
declare type GistsListForksResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type GistsListForksResponseItem = {
    created_at: string;
    id: string;
    updated_at: string;
    url: string;
    user: GistsListForksResponseItemUser;
};
declare type GistsListCommitsResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type GistsListCommitsResponseItemChangeStatus = {
    additions: number;
    deletions: number;
    total: number;
};
declare type GistsListCommitsResponseItem = {
    change_status: GistsListCommitsResponseItemChangeStatus;
    committed_at: string;
    url: string;
    user: GistsListCommitsResponseItemUser;
    version: string;
};
declare type GistsListCommentsResponseItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type GistsListCommentsResponseItem = {
    body: string;
    created_at: string;
    id: number;
    node_id: string;
    updated_at: string;
    url: string;
    user: GistsListCommentsResponseItemUser;
};
declare type GistsListResponseItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type GistsListResponseItemFilesHelloWorldRb = {
    filename: string;
    language: string;
    raw_url: string;
    size: number;
    type: string;
};
declare type GistsListResponseItemFiles = {
    "hello_world.rb": GistsListResponseItemFilesHelloWorldRb;
};
declare type GistsListResponseItem = {
    comments: number;
    comments_url: string;
    commits_url: string;
    created_at: string;
    description: string;
    files: GistsListResponseItemFiles;
    forks_url: string;
    git_pull_url: string;
    git_push_url: string;
    html_url: string;
    id: string;
    node_id: string;
    owner: GistsListResponseItemOwner;
    public: boolean;
    truncated: boolean;
    updated_at: string;
    url: string;
    user: null;
};
declare type GistsGetRevisionResponseOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type GistsGetRevisionResponseHistoryItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type GistsGetRevisionResponseHistoryItemChangeStatus = {
    additions: number;
    deletions: number;
    total: number;
};
declare type GistsGetRevisionResponseHistoryItem = {
    change_status: GistsGetRevisionResponseHistoryItemChangeStatus;
    committed_at: string;
    url: string;
    user: GistsGetRevisionResponseHistoryItemUser;
    version: string;
};
declare type GistsGetRevisionResponseForksItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type GistsGetRevisionResponseForksItem = {
    created_at: string;
    id: string;
    updated_at: string;
    url: string;
    user: GistsGetRevisionResponseForksItemUser;
};
declare type GistsGetRevisionResponseFilesHelloWorldRubyTxt = {
    content: string;
    filename: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    type: string;
};
declare type GistsGetRevisionResponseFilesHelloWorldPythonTxt = {
    content: string;
    filename: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    type: string;
};
declare type GistsGetRevisionResponseFilesHelloWorldRb = {
    content: string;
    filename: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    type: string;
};
declare type GistsGetRevisionResponseFilesHelloWorldPy = {
    content: string;
    filename: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    type: string;
};
declare type GistsGetRevisionResponseFiles = {
    "hello_world.py": GistsGetRevisionResponseFilesHelloWorldPy;
    "hello_world.rb": GistsGetRevisionResponseFilesHelloWorldRb;
    "hello_world_python.txt": GistsGetRevisionResponseFilesHelloWorldPythonTxt;
    "hello_world_ruby.txt": GistsGetRevisionResponseFilesHelloWorldRubyTxt;
};
declare type GistsGetRevisionResponse = {
    comments: number;
    comments_url: string;
    commits_url: string;
    created_at: string;
    description: string;
    files: GistsGetRevisionResponseFiles;
    forks: Array<GistsGetRevisionResponseForksItem>;
    forks_url: string;
    git_pull_url: string;
    git_push_url: string;
    history: Array<GistsGetRevisionResponseHistoryItem>;
    html_url: string;
    id: string;
    node_id: string;
    owner: GistsGetRevisionResponseOwner;
    public: boolean;
    truncated: boolean;
    updated_at: string;
    url: string;
    user: null;
};
declare type GistsGetCommentResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type GistsGetCommentResponse = {
    body: string;
    created_at: string;
    id: number;
    node_id: string;
    updated_at: string;
    url: string;
    user: GistsGetCommentResponseUser;
};
declare type GistsGetResponseOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type GistsGetResponseHistoryItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type GistsGetResponseHistoryItemChangeStatus = {
    additions: number;
    deletions: number;
    total: number;
};
declare type GistsGetResponseHistoryItem = {
    change_status: GistsGetResponseHistoryItemChangeStatus;
    committed_at: string;
    url: string;
    user: GistsGetResponseHistoryItemUser;
    version: string;
};
declare type GistsGetResponseForksItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type GistsGetResponseForksItem = {
    created_at: string;
    id: string;
    updated_at: string;
    url: string;
    user: GistsGetResponseForksItemUser;
};
declare type GistsGetResponseFilesHelloWorldRubyTxt = {
    content: string;
    filename: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    type: string;
};
declare type GistsGetResponseFilesHelloWorldPythonTxt = {
    content: string;
    filename: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    type: string;
};
declare type GistsGetResponseFilesHelloWorldRb = {
    content: string;
    filename: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    type: string;
};
declare type GistsGetResponseFilesHelloWorldPy = {
    content: string;
    filename: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    type: string;
};
declare type GistsGetResponseFiles = {
    "hello_world.py": GistsGetResponseFilesHelloWorldPy;
    "hello_world.rb": GistsGetResponseFilesHelloWorldRb;
    "hello_world_python.txt": GistsGetResponseFilesHelloWorldPythonTxt;
    "hello_world_ruby.txt": GistsGetResponseFilesHelloWorldRubyTxt;
};
declare type GistsGetResponse = {
    comments: number;
    comments_url: string;
    commits_url: string;
    created_at: string;
    description: string;
    files: GistsGetResponseFiles;
    forks: Array<GistsGetResponseForksItem>;
    forks_url: string;
    git_pull_url: string;
    git_push_url: string;
    history: Array<GistsGetResponseHistoryItem>;
    html_url: string;
    id: string;
    node_id: string;
    owner: GistsGetResponseOwner;
    public: boolean;
    truncated: boolean;
    updated_at: string;
    url: string;
    user: null;
};
declare type GistsForkResponseOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type GistsForkResponseFilesHelloWorldRb = {
    filename: string;
    language: string;
    raw_url: string;
    size: number;
    type: string;
};
declare type GistsForkResponseFiles = {
    "hello_world.rb": GistsForkResponseFilesHelloWorldRb;
};
declare type GistsForkResponse = {
    comments: number;
    comments_url: string;
    commits_url: string;
    created_at: string;
    description: string;
    files: GistsForkResponseFiles;
    forks_url: string;
    git_pull_url: string;
    git_push_url: string;
    html_url: string;
    id: string;
    node_id: string;
    owner: GistsForkResponseOwner;
    public: boolean;
    truncated: boolean;
    updated_at: string;
    url: string;
    user: null;
};
declare type GistsCreateCommentResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type GistsCreateCommentResponse = {
    body: string;
    created_at: string;
    id: number;
    node_id: string;
    updated_at: string;
    url: string;
    user: GistsCreateCommentResponseUser;
};
declare type GistsCreateResponseOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type GistsCreateResponseHistoryItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type GistsCreateResponseHistoryItemChangeStatus = {
    additions: number;
    deletions: number;
    total: number;
};
declare type GistsCreateResponseHistoryItem = {
    change_status: GistsCreateResponseHistoryItemChangeStatus;
    committed_at: string;
    url: string;
    user: GistsCreateResponseHistoryItemUser;
    version: string;
};
declare type GistsCreateResponseForksItemUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type GistsCreateResponseForksItem = {
    created_at: string;
    id: string;
    updated_at: string;
    url: string;
    user: GistsCreateResponseForksItemUser;
};
declare type GistsCreateResponseFilesHelloWorldRubyTxt = {
    content: string;
    filename: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    type: string;
};
declare type GistsCreateResponseFilesHelloWorldPythonTxt = {
    content: string;
    filename: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    type: string;
};
declare type GistsCreateResponseFilesHelloWorldRb = {
    content: string;
    filename: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    type: string;
};
declare type GistsCreateResponseFilesHelloWorldPy = {
    content: string;
    filename: string;
    language: string;
    raw_url: string;
    size: number;
    truncated: boolean;
    type: string;
};
declare type GistsCreateResponseFiles = {
    "hello_world.py": GistsCreateResponseFilesHelloWorldPy;
    "hello_world.rb": GistsCreateResponseFilesHelloWorldRb;
    "hello_world_python.txt": GistsCreateResponseFilesHelloWorldPythonTxt;
    "hello_world_ruby.txt": GistsCreateResponseFilesHelloWorldRubyTxt;
};
declare type GistsCreateResponse = {
    comments: number;
    comments_url: string;
    commits_url: string;
    created_at: string;
    description: string;
    files: GistsCreateResponseFiles;
    forks: Array<GistsCreateResponseForksItem>;
    forks_url: string;
    git_pull_url: string;
    git_push_url: string;
    history: Array<GistsCreateResponseHistoryItem>;
    html_url: string;
    id: string;
    node_id: string;
    owner: GistsCreateResponseOwner;
    public: boolean;
    truncated: boolean;
    updated_at: string;
    url: string;
    user: null;
};
declare type CodesOfConductListConductCodesResponseItem = {
    key: string;
    name: string;
    url: string;
};
declare type CodesOfConductGetForRepoResponse = {
    body: string;
    key: string;
    name: string;
    url: string;
};
declare type CodesOfConductGetConductCodeResponse = {
    body: string;
    key: string;
    name: string;
    url: string;
};
declare type ChecksUpdateResponsePullRequestsItemHeadRepo = {
    id: number;
    name: string;
    url: string;
};
declare type ChecksUpdateResponsePullRequestsItemHead = {
    ref: string;
    repo: ChecksUpdateResponsePullRequestsItemHeadRepo;
    sha: string;
};
declare type ChecksUpdateResponsePullRequestsItemBaseRepo = {
    id: number;
    name: string;
    url: string;
};
declare type ChecksUpdateResponsePullRequestsItemBase = {
    ref: string;
    repo: ChecksUpdateResponsePullRequestsItemBaseRepo;
    sha: string;
};
declare type ChecksUpdateResponsePullRequestsItem = {
    base: ChecksUpdateResponsePullRequestsItemBase;
    head: ChecksUpdateResponsePullRequestsItemHead;
    id: number;
    number: number;
    url: string;
};
declare type ChecksUpdateResponseOutput = {
    annotations_count: number;
    annotations_url: string;
    summary: string;
    text: string;
    title: string;
};
declare type ChecksUpdateResponseCheckSuite = {
    id: number;
};
declare type ChecksUpdateResponseAppPermissions = {
    contents: string;
    issues: string;
    metadata: string;
    single_file: string;
};
declare type ChecksUpdateResponseAppOwner = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
};
declare type ChecksUpdateResponseApp = {
    created_at: string;
    description: string;
    events: Array<string>;
    external_url: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    owner: ChecksUpdateResponseAppOwner;
    permissions: ChecksUpdateResponseAppPermissions;
    slug: string;
    updated_at: string;
};
declare type ChecksUpdateResponse = {
    app: ChecksUpdateResponseApp;
    check_suite: ChecksUpdateResponseCheckSuite;
    completed_at: string;
    conclusion: string;
    details_url: string;
    external_id: string;
    head_sha: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    output: ChecksUpdateResponseOutput;
    pull_requests: Array<ChecksUpdateResponsePullRequestsItem>;
    started_at: string;
    status: string;
    url: string;
};
declare type ChecksSetSuitesPreferencesResponseRepositoryPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type ChecksSetSuitesPreferencesResponseRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ChecksSetSuitesPreferencesResponseRepository = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: ChecksSetSuitesPreferencesResponseRepositoryOwner;
    permissions: ChecksSetSuitesPreferencesResponseRepositoryPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type ChecksSetSuitesPreferencesResponsePreferencesAutoTriggerChecksItem = {
    app_id: number;
    setting: boolean;
};
declare type ChecksSetSuitesPreferencesResponsePreferences = {
    auto_trigger_checks: Array<ChecksSetSuitesPreferencesResponsePreferencesAutoTriggerChecksItem>;
};
declare type ChecksSetSuitesPreferencesResponse = {
    preferences: ChecksSetSuitesPreferencesResponsePreferences;
    repository: ChecksSetSuitesPreferencesResponseRepository;
};
declare type ChecksListSuitesForRefResponseCheckSuitesItemRepositoryPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type ChecksListSuitesForRefResponseCheckSuitesItemRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ChecksListSuitesForRefResponseCheckSuitesItemRepository = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: ChecksListSuitesForRefResponseCheckSuitesItemRepositoryOwner;
    permissions: ChecksListSuitesForRefResponseCheckSuitesItemRepositoryPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type ChecksListSuitesForRefResponseCheckSuitesItemAppPermissions = {
    contents: string;
    issues: string;
    metadata: string;
    single_file: string;
};
declare type ChecksListSuitesForRefResponseCheckSuitesItemAppOwner = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
};
declare type ChecksListSuitesForRefResponseCheckSuitesItemApp = {
    created_at: string;
    description: string;
    events: Array<string>;
    external_url: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    owner: ChecksListSuitesForRefResponseCheckSuitesItemAppOwner;
    permissions: ChecksListSuitesForRefResponseCheckSuitesItemAppPermissions;
    slug: string;
    updated_at: string;
};
declare type ChecksListSuitesForRefResponseCheckSuitesItem = {
    after: string;
    app: ChecksListSuitesForRefResponseCheckSuitesItemApp;
    before: string;
    conclusion: string;
    head_branch: string;
    head_sha: string;
    id: number;
    node_id: string;
    pull_requests: Array<any>;
    repository: ChecksListSuitesForRefResponseCheckSuitesItemRepository;
    status: string;
    url: string;
};
declare type ChecksListSuitesForRefResponse = {
    check_suites: Array<ChecksListSuitesForRefResponseCheckSuitesItem>;
    total_count: number;
};
declare type ChecksListForSuiteResponseCheckRunsItemPullRequestsItemHeadRepo = {
    id: number;
    name: string;
    url: string;
};
declare type ChecksListForSuiteResponseCheckRunsItemPullRequestsItemHead = {
    ref: string;
    repo: ChecksListForSuiteResponseCheckRunsItemPullRequestsItemHeadRepo;
    sha: string;
};
declare type ChecksListForSuiteResponseCheckRunsItemPullRequestsItemBaseRepo = {
    id: number;
    name: string;
    url: string;
};
declare type ChecksListForSuiteResponseCheckRunsItemPullRequestsItemBase = {
    ref: string;
    repo: ChecksListForSuiteResponseCheckRunsItemPullRequestsItemBaseRepo;
    sha: string;
};
declare type ChecksListForSuiteResponseCheckRunsItemPullRequestsItem = {
    base: ChecksListForSuiteResponseCheckRunsItemPullRequestsItemBase;
    head: ChecksListForSuiteResponseCheckRunsItemPullRequestsItemHead;
    id: number;
    number: number;
    url: string;
};
declare type ChecksListForSuiteResponseCheckRunsItemOutput = {
    annotations_count: number;
    annotations_url: string;
    summary: string;
    text: string;
    title: string;
};
declare type ChecksListForSuiteResponseCheckRunsItemCheckSuite = {
    id: number;
};
declare type ChecksListForSuiteResponseCheckRunsItemAppPermissions = {
    contents: string;
    issues: string;
    metadata: string;
    single_file: string;
};
declare type ChecksListForSuiteResponseCheckRunsItemAppOwner = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
};
declare type ChecksListForSuiteResponseCheckRunsItemApp = {
    created_at: string;
    description: string;
    events: Array<string>;
    external_url: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    owner: ChecksListForSuiteResponseCheckRunsItemAppOwner;
    permissions: ChecksListForSuiteResponseCheckRunsItemAppPermissions;
    slug: string;
    updated_at: string;
};
declare type ChecksListForSuiteResponseCheckRunsItem = {
    app: ChecksListForSuiteResponseCheckRunsItemApp;
    check_suite: ChecksListForSuiteResponseCheckRunsItemCheckSuite;
    completed_at: string;
    conclusion: string;
    details_url: string;
    external_id: string;
    head_sha: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    output: ChecksListForSuiteResponseCheckRunsItemOutput;
    pull_requests: Array<ChecksListForSuiteResponseCheckRunsItemPullRequestsItem>;
    started_at: string;
    status: string;
    url: string;
};
declare type ChecksListForSuiteResponse = {
    check_runs: Array<ChecksListForSuiteResponseCheckRunsItem>;
    total_count: number;
};
declare type ChecksListForRefResponseCheckRunsItemPullRequestsItemHeadRepo = {
    id: number;
    name: string;
    url: string;
};
declare type ChecksListForRefResponseCheckRunsItemPullRequestsItemHead = {
    ref: string;
    repo: ChecksListForRefResponseCheckRunsItemPullRequestsItemHeadRepo;
    sha: string;
};
declare type ChecksListForRefResponseCheckRunsItemPullRequestsItemBaseRepo = {
    id: number;
    name: string;
    url: string;
};
declare type ChecksListForRefResponseCheckRunsItemPullRequestsItemBase = {
    ref: string;
    repo: ChecksListForRefResponseCheckRunsItemPullRequestsItemBaseRepo;
    sha: string;
};
declare type ChecksListForRefResponseCheckRunsItemPullRequestsItem = {
    base: ChecksListForRefResponseCheckRunsItemPullRequestsItemBase;
    head: ChecksListForRefResponseCheckRunsItemPullRequestsItemHead;
    id: number;
    number: number;
    url: string;
};
declare type ChecksListForRefResponseCheckRunsItemOutput = {
    annotations_count: number;
    annotations_url: string;
    summary: string;
    text: string;
    title: string;
};
declare type ChecksListForRefResponseCheckRunsItemCheckSuite = {
    id: number;
};
declare type ChecksListForRefResponseCheckRunsItemAppPermissions = {
    contents: string;
    issues: string;
    metadata: string;
    single_file: string;
};
declare type ChecksListForRefResponseCheckRunsItemAppOwner = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
};
declare type ChecksListForRefResponseCheckRunsItemApp = {
    created_at: string;
    description: string;
    events: Array<string>;
    external_url: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    owner: ChecksListForRefResponseCheckRunsItemAppOwner;
    permissions: ChecksListForRefResponseCheckRunsItemAppPermissions;
    slug: string;
    updated_at: string;
};
declare type ChecksListForRefResponseCheckRunsItem = {
    app: ChecksListForRefResponseCheckRunsItemApp;
    check_suite: ChecksListForRefResponseCheckRunsItemCheckSuite;
    completed_at: string;
    conclusion: string;
    details_url: string;
    external_id: string;
    head_sha: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    output: ChecksListForRefResponseCheckRunsItemOutput;
    pull_requests: Array<ChecksListForRefResponseCheckRunsItemPullRequestsItem>;
    started_at: string;
    status: string;
    url: string;
};
declare type ChecksListForRefResponse = {
    check_runs: Array<ChecksListForRefResponseCheckRunsItem>;
    total_count: number;
};
declare type ChecksListAnnotationsResponseItem = {
    annotation_level: string;
    end_column: number;
    end_line: number;
    message: string;
    path: string;
    raw_details: string;
    start_column: number;
    start_line: number;
    title: string;
};
declare type ChecksGetSuiteResponseRepositoryPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type ChecksGetSuiteResponseRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ChecksGetSuiteResponseRepository = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: ChecksGetSuiteResponseRepositoryOwner;
    permissions: ChecksGetSuiteResponseRepositoryPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type ChecksGetSuiteResponseAppPermissions = {
    contents: string;
    issues: string;
    metadata: string;
    single_file: string;
};
declare type ChecksGetSuiteResponseAppOwner = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
};
declare type ChecksGetSuiteResponseApp = {
    created_at: string;
    description: string;
    events: Array<string>;
    external_url: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    owner: ChecksGetSuiteResponseAppOwner;
    permissions: ChecksGetSuiteResponseAppPermissions;
    slug: string;
    updated_at: string;
};
declare type ChecksGetSuiteResponse = {
    after: string;
    app: ChecksGetSuiteResponseApp;
    before: string;
    conclusion: string;
    head_branch: string;
    head_sha: string;
    id: number;
    node_id: string;
    pull_requests: Array<any>;
    repository: ChecksGetSuiteResponseRepository;
    status: string;
    url: string;
};
declare type ChecksGetResponsePullRequestsItemHeadRepo = {
    id: number;
    name: string;
    url: string;
};
declare type ChecksGetResponsePullRequestsItemHead = {
    ref: string;
    repo: ChecksGetResponsePullRequestsItemHeadRepo;
    sha: string;
};
declare type ChecksGetResponsePullRequestsItemBaseRepo = {
    id: number;
    name: string;
    url: string;
};
declare type ChecksGetResponsePullRequestsItemBase = {
    ref: string;
    repo: ChecksGetResponsePullRequestsItemBaseRepo;
    sha: string;
};
declare type ChecksGetResponsePullRequestsItem = {
    base: ChecksGetResponsePullRequestsItemBase;
    head: ChecksGetResponsePullRequestsItemHead;
    id: number;
    number: number;
    url: string;
};
declare type ChecksGetResponseOutput = {
    annotations_count: number;
    annotations_url: string;
    summary: string;
    text: string;
    title: string;
};
declare type ChecksGetResponseCheckSuite = {
    id: number;
};
declare type ChecksGetResponseAppPermissions = {
    contents: string;
    issues: string;
    metadata: string;
    single_file: string;
};
declare type ChecksGetResponseAppOwner = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
};
declare type ChecksGetResponseApp = {
    created_at: string;
    description: string;
    events: Array<string>;
    external_url: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    owner: ChecksGetResponseAppOwner;
    permissions: ChecksGetResponseAppPermissions;
    slug: string;
    updated_at: string;
};
declare type ChecksGetResponse = {
    app: ChecksGetResponseApp;
    check_suite: ChecksGetResponseCheckSuite;
    completed_at: string;
    conclusion: string;
    details_url: string;
    external_id: string;
    head_sha: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    output: ChecksGetResponseOutput;
    pull_requests: Array<ChecksGetResponsePullRequestsItem>;
    started_at: string;
    status: string;
    url: string;
};
declare type ChecksCreateSuiteResponseRepositoryPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type ChecksCreateSuiteResponseRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ChecksCreateSuiteResponseRepository = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: ChecksCreateSuiteResponseRepositoryOwner;
    permissions: ChecksCreateSuiteResponseRepositoryPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type ChecksCreateSuiteResponseAppPermissions = {
    contents: string;
    issues: string;
    metadata: string;
    single_file: string;
};
declare type ChecksCreateSuiteResponseAppOwner = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
};
declare type ChecksCreateSuiteResponseApp = {
    created_at: string;
    description: string;
    events: Array<string>;
    external_url: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    owner: ChecksCreateSuiteResponseAppOwner;
    permissions: ChecksCreateSuiteResponseAppPermissions;
    slug: string;
    updated_at: string;
};
declare type ChecksCreateSuiteResponse = {
    after: string;
    app: ChecksCreateSuiteResponseApp;
    before: string;
    conclusion: string;
    head_branch: string;
    head_sha: string;
    id: number;
    node_id: string;
    pull_requests: Array<any>;
    repository: ChecksCreateSuiteResponseRepository;
    status: string;
    url: string;
};
declare type ChecksCreateResponsePullRequestsItemHeadRepo = {
    id: number;
    name: string;
    url: string;
};
declare type ChecksCreateResponsePullRequestsItemHead = {
    ref: string;
    repo: ChecksCreateResponsePullRequestsItemHeadRepo;
    sha: string;
};
declare type ChecksCreateResponsePullRequestsItemBaseRepo = {
    id: number;
    name: string;
    url: string;
};
declare type ChecksCreateResponsePullRequestsItemBase = {
    ref: string;
    repo: ChecksCreateResponsePullRequestsItemBaseRepo;
    sha: string;
};
declare type ChecksCreateResponsePullRequestsItem = {
    base: ChecksCreateResponsePullRequestsItemBase;
    head: ChecksCreateResponsePullRequestsItemHead;
    id: number;
    number: number;
    url: string;
};
declare type ChecksCreateResponseOutput = {
    summary: string;
    text: string;
    title: string;
    annotations_count?: number;
    annotations_url?: string;
};
declare type ChecksCreateResponseCheckSuite = {
    id: number;
};
declare type ChecksCreateResponseAppPermissions = {
    contents: string;
    issues: string;
    metadata: string;
    single_file: string;
};
declare type ChecksCreateResponseAppOwner = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
};
declare type ChecksCreateResponseApp = {
    created_at: string;
    description: string;
    events: Array<string>;
    external_url: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    owner: ChecksCreateResponseAppOwner;
    permissions: ChecksCreateResponseAppPermissions;
    slug: string;
    updated_at: string;
};
declare type ChecksCreateResponse = {
    app: ChecksCreateResponseApp;
    check_suite: ChecksCreateResponseCheckSuite;
    completed_at: null | string;
    conclusion: null | string;
    details_url: string;
    external_id: string;
    head_sha: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    output: ChecksCreateResponseOutput;
    pull_requests: Array<ChecksCreateResponsePullRequestsItem>;
    started_at: string;
    status: string;
    url: string;
};
declare type AppsResetTokenResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type AppsResetTokenResponseApp = {
    client_id: string;
    name: string;
    url: string;
};
declare type AppsResetTokenResponse = {
    app: AppsResetTokenResponseApp;
    created_at: string;
    fingerprint: string;
    hashed_token: string;
    id: number;
    note: string;
    note_url: string;
    scopes: Array<string>;
    token: string;
    token_last_eight: string;
    updated_at: string;
    url: string;
    user: AppsResetTokenResponseUser;
};
declare type AppsResetAuthorizationResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type AppsResetAuthorizationResponseApp = {
    client_id: string;
    name: string;
    url: string;
};
declare type AppsResetAuthorizationResponse = {
    app: AppsResetAuthorizationResponseApp;
    created_at: string;
    fingerprint: string;
    hashed_token: string;
    id: number;
    note: string;
    note_url: string;
    scopes: Array<string>;
    token: string;
    token_last_eight: string;
    updated_at: string;
    url: string;
    user: AppsResetAuthorizationResponseUser;
};
declare type AppsListReposResponseRepositoriesItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type AppsListReposResponseRepositoriesItem = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: AppsListReposResponseRepositoriesItemOwner;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type AppsListReposResponse = {
    repositories: Array<AppsListReposResponseRepositoriesItem>;
    total_count: number;
};
declare type AppsListPlansStubbedResponseItem = {
    accounts_url: string;
    bullets: Array<string>;
    description: string;
    has_free_trial: boolean;
    id: number;
    monthly_price_in_cents: number;
    name: string;
    number: number;
    price_model: string;
    state: string;
    unit_name: null;
    url: string;
    yearly_price_in_cents: number;
};
declare type AppsListPlansResponseItem = {
    accounts_url: string;
    bullets: Array<string>;
    description: string;
    has_free_trial: boolean;
    id: number;
    monthly_price_in_cents: number;
    name: string;
    number: number;
    price_model: string;
    state: string;
    unit_name: null;
    url: string;
    yearly_price_in_cents: number;
};
declare type AppsListMarketplacePurchasesForAuthenticatedUserStubbedResponseItemPlan = {
    accounts_url: string;
    bullets: Array<string>;
    description: string;
    has_free_trial: boolean;
    id: number;
    monthly_price_in_cents: number;
    name: string;
    number: number;
    price_model: string;
    state: string;
    unit_name: null;
    url: string;
    yearly_price_in_cents: number;
};
declare type AppsListMarketplacePurchasesForAuthenticatedUserStubbedResponseItemAccount = {
    email: null;
    id: number;
    login: string;
    organization_billing_email: string;
    type: string;
    url: string;
};
declare type AppsListMarketplacePurchasesForAuthenticatedUserStubbedResponseItem = {
    account: AppsListMarketplacePurchasesForAuthenticatedUserStubbedResponseItemAccount;
    billing_cycle: string;
    free_trial_ends_on: string;
    next_billing_date: string;
    on_free_trial: boolean;
    plan: AppsListMarketplacePurchasesForAuthenticatedUserStubbedResponseItemPlan;
    unit_count: null;
    updated_at: string;
};
declare type AppsListMarketplacePurchasesForAuthenticatedUserResponseItemPlan = {
    accounts_url: string;
    bullets: Array<string>;
    description: string;
    has_free_trial: boolean;
    id: number;
    monthly_price_in_cents: number;
    name: string;
    number: number;
    price_model: string;
    state: string;
    unit_name: null;
    url: string;
    yearly_price_in_cents: number;
};
declare type AppsListMarketplacePurchasesForAuthenticatedUserResponseItemAccount = {
    email: null;
    id: number;
    login: string;
    organization_billing_email: string;
    type: string;
    url: string;
};
declare type AppsListMarketplacePurchasesForAuthenticatedUserResponseItem = {
    account: AppsListMarketplacePurchasesForAuthenticatedUserResponseItemAccount;
    billing_cycle: string;
    free_trial_ends_on: string;
    next_billing_date: string;
    on_free_trial: boolean;
    plan: AppsListMarketplacePurchasesForAuthenticatedUserResponseItemPlan;
    unit_count: null;
    updated_at: string;
};
declare type AppsListInstallationsForAuthenticatedUserResponseInstallationsItemPermissions = {
    contents: string;
    issues: string;
    metadata: string;
    single_file: string;
};
declare type AppsListInstallationsForAuthenticatedUserResponseInstallationsItemAccount = {
    avatar_url: string;
    description?: string;
    events_url: string;
    hooks_url?: string;
    id: number;
    issues_url?: string;
    login: string;
    members_url?: string;
    node_id: string;
    public_members_url?: string;
    repos_url: string;
    url: string;
    followers_url?: string;
    following_url?: string;
    gists_url?: string;
    gravatar_id?: string;
    html_url?: string;
    organizations_url?: string;
    received_events_url?: string;
    site_admin?: boolean;
    starred_url?: string;
    subscriptions_url?: string;
    type?: string;
};
declare type AppsListInstallationsForAuthenticatedUserResponseInstallationsItem = {
    access_tokens_url: string;
    account: AppsListInstallationsForAuthenticatedUserResponseInstallationsItemAccount;
    app_id: number;
    events: Array<string>;
    html_url: string;
    id: number;
    permissions: AppsListInstallationsForAuthenticatedUserResponseInstallationsItemPermissions;
    repositories_url: string;
    single_file_name: string;
    target_id: number;
    target_type: string;
};
declare type AppsListInstallationsForAuthenticatedUserResponse = {
    installations: Array<AppsListInstallationsForAuthenticatedUserResponseInstallationsItem>;
    total_count: number;
};
declare type AppsListInstallationsResponseItemPermissions = {
    contents: string;
    issues: string;
    metadata: string;
    single_file: string;
};
declare type AppsListInstallationsResponseItemAccount = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
};
declare type AppsListInstallationsResponseItem = {
    access_tokens_url: string;
    account: AppsListInstallationsResponseItemAccount;
    app_id: number;
    events: Array<string>;
    html_url: string;
    id: number;
    permissions: AppsListInstallationsResponseItemPermissions;
    repositories_url: string;
    repository_selection: string;
    single_file_name: string;
    target_id: number;
    target_type: string;
};
declare type AppsListInstallationReposForAuthenticatedUserResponseRepositoriesItemPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type AppsListInstallationReposForAuthenticatedUserResponseRepositoriesItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type AppsListInstallationReposForAuthenticatedUserResponseRepositoriesItem = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: AppsListInstallationReposForAuthenticatedUserResponseRepositoriesItemOwner;
    permissions: AppsListInstallationReposForAuthenticatedUserResponseRepositoriesItemPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type AppsListInstallationReposForAuthenticatedUserResponse = {
    repositories: Array<AppsListInstallationReposForAuthenticatedUserResponseRepositoriesItem>;
    total_count: number;
};
declare type AppsListAccountsUserOrOrgOnPlanStubbedResponseItemMarketplacePurchasePlan = {
    accounts_url: string;
    bullets: Array<string>;
    description: string;
    has_free_trial: boolean;
    id: number;
    monthly_price_in_cents: number;
    name: string;
    number: number;
    price_model: string;
    state: string;
    unit_name: null;
    url: string;
    yearly_price_in_cents: number;
};
declare type AppsListAccountsUserOrOrgOnPlanStubbedResponseItemMarketplacePurchase = {
    billing_cycle: string;
    free_trial_ends_on: string;
    next_billing_date: string;
    on_free_trial: boolean;
    plan: AppsListAccountsUserOrOrgOnPlanStubbedResponseItemMarketplacePurchasePlan;
    unit_count: null;
    updated_at: string;
};
declare type AppsListAccountsUserOrOrgOnPlanStubbedResponseItemMarketplacePendingChangePlan = {
    accounts_url: string;
    bullets: Array<string>;
    description: string;
    has_free_trial: boolean;
    id: number;
    monthly_price_in_cents: number;
    name: string;
    number: number;
    price_model: string;
    state: string;
    unit_name: null;
    url: string;
    yearly_price_in_cents: number;
};
declare type AppsListAccountsUserOrOrgOnPlanStubbedResponseItemMarketplacePendingChange = {
    effective_date: string;
    id: number;
    plan: AppsListAccountsUserOrOrgOnPlanStubbedResponseItemMarketplacePendingChangePlan;
    unit_count: null;
};
declare type AppsListAccountsUserOrOrgOnPlanStubbedResponseItem = {
    email: null;
    id: number;
    login: string;
    marketplace_pending_change: AppsListAccountsUserOrOrgOnPlanStubbedResponseItemMarketplacePendingChange;
    marketplace_purchase: AppsListAccountsUserOrOrgOnPlanStubbedResponseItemMarketplacePurchase;
    organization_billing_email: string;
    type: string;
    url: string;
};
declare type AppsListAccountsUserOrOrgOnPlanResponseItemMarketplacePurchasePlan = {
    accounts_url: string;
    bullets: Array<string>;
    description: string;
    has_free_trial: boolean;
    id: number;
    monthly_price_in_cents: number;
    name: string;
    number: number;
    price_model: string;
    state: string;
    unit_name: null;
    url: string;
    yearly_price_in_cents: number;
};
declare type AppsListAccountsUserOrOrgOnPlanResponseItemMarketplacePurchase = {
    billing_cycle: string;
    free_trial_ends_on: string;
    next_billing_date: string;
    on_free_trial: boolean;
    plan: AppsListAccountsUserOrOrgOnPlanResponseItemMarketplacePurchasePlan;
    unit_count: null;
    updated_at: string;
};
declare type AppsListAccountsUserOrOrgOnPlanResponseItemMarketplacePendingChangePlan = {
    accounts_url: string;
    bullets: Array<string>;
    description: string;
    has_free_trial: boolean;
    id: number;
    monthly_price_in_cents: number;
    name: string;
    number: number;
    price_model: string;
    state: string;
    unit_name: null;
    url: string;
    yearly_price_in_cents: number;
};
declare type AppsListAccountsUserOrOrgOnPlanResponseItemMarketplacePendingChange = {
    effective_date: string;
    id: number;
    plan: AppsListAccountsUserOrOrgOnPlanResponseItemMarketplacePendingChangePlan;
    unit_count: null;
};
declare type AppsListAccountsUserOrOrgOnPlanResponseItem = {
    email: null;
    id: number;
    login: string;
    marketplace_pending_change: AppsListAccountsUserOrOrgOnPlanResponseItemMarketplacePendingChange;
    marketplace_purchase: AppsListAccountsUserOrOrgOnPlanResponseItemMarketplacePurchase;
    organization_billing_email: string;
    type: string;
    url: string;
};
declare type AppsGetUserInstallationResponsePermissions = {
    checks: string;
    contents: string;
    metadata: string;
};
declare type AppsGetUserInstallationResponseAccount = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type AppsGetUserInstallationResponse = {
    access_tokens_url: string;
    account: AppsGetUserInstallationResponseAccount;
    app_id: number;
    created_at: string;
    events: Array<string>;
    html_url: string;
    id: number;
    permissions: AppsGetUserInstallationResponsePermissions;
    repositories_url: string;
    repository_selection: string;
    single_file_name: null;
    target_id: number;
    target_type: string;
    updated_at: string;
};
declare type AppsGetRepoInstallationResponsePermissions = {
    checks: string;
    contents: string;
    metadata: string;
};
declare type AppsGetRepoInstallationResponseAccount = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type AppsGetRepoInstallationResponse = {
    access_tokens_url: string;
    account: AppsGetRepoInstallationResponseAccount;
    app_id: number;
    created_at: string;
    events: Array<string>;
    html_url: string;
    id: number;
    permissions: AppsGetRepoInstallationResponsePermissions;
    repositories_url: string;
    repository_selection: string;
    single_file_name: null;
    target_id: number;
    target_type: string;
    updated_at: string;
};
declare type AppsGetOrgInstallationResponsePermissions = {
    checks: string;
    contents: string;
    metadata: string;
};
declare type AppsGetOrgInstallationResponseAccount = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type AppsGetOrgInstallationResponse = {
    access_tokens_url: string;
    account: AppsGetOrgInstallationResponseAccount;
    app_id: number;
    created_at: string;
    events: Array<string>;
    html_url: string;
    id: number;
    permissions: AppsGetOrgInstallationResponsePermissions;
    repositories_url: string;
    repository_selection: string;
    single_file_name: null;
    target_id: number;
    target_type: string;
    updated_at: string;
};
declare type AppsGetInstallationResponsePermissions = {
    contents: string;
    issues: string;
    metadata: string;
    single_file: string;
};
declare type AppsGetInstallationResponseAccount = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
};
declare type AppsGetInstallationResponse = {
    access_tokens_url: string;
    account: AppsGetInstallationResponseAccount;
    app_id: number;
    events: Array<string>;
    html_url: string;
    id: number;
    permissions: AppsGetInstallationResponsePermissions;
    repositories_url: string;
    repository_selection: string;
    single_file_name: string;
    target_id: number;
    target_type: string;
};
declare type AppsGetBySlugResponsePermissions = {
    contents: string;
    issues: string;
    metadata: string;
    single_file: string;
};
declare type AppsGetBySlugResponseOwner = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
};
declare type AppsGetBySlugResponse = {
    created_at: string;
    description: string;
    events: Array<string>;
    external_url: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    owner: AppsGetBySlugResponseOwner;
    permissions: AppsGetBySlugResponsePermissions;
    slug: string;
    updated_at: string;
};
declare type AppsGetAuthenticatedResponsePermissions = {
    contents: string;
    issues: string;
    metadata: string;
    single_file: string;
};
declare type AppsGetAuthenticatedResponseOwner = {
    avatar_url: string;
    description: string;
    events_url: string;
    hooks_url: string;
    id: number;
    issues_url: string;
    login: string;
    members_url: string;
    node_id: string;
    public_members_url: string;
    repos_url: string;
    url: string;
};
declare type AppsGetAuthenticatedResponse = {
    created_at: string;
    description: string;
    events: Array<string>;
    external_url: string;
    html_url: string;
    id: number;
    installations_count: number;
    name: string;
    node_id: string;
    owner: AppsGetAuthenticatedResponseOwner;
    permissions: AppsGetAuthenticatedResponsePermissions;
    slug: string;
    updated_at: string;
};
declare type AppsFindUserInstallationResponsePermissions = {
    checks: string;
    contents: string;
    metadata: string;
};
declare type AppsFindUserInstallationResponseAccount = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type AppsFindUserInstallationResponse = {
    access_tokens_url: string;
    account: AppsFindUserInstallationResponseAccount;
    app_id: number;
    created_at: string;
    events: Array<string>;
    html_url: string;
    id: number;
    permissions: AppsFindUserInstallationResponsePermissions;
    repositories_url: string;
    repository_selection: string;
    single_file_name: null;
    target_id: number;
    target_type: string;
    updated_at: string;
};
declare type AppsFindRepoInstallationResponsePermissions = {
    checks: string;
    contents: string;
    metadata: string;
};
declare type AppsFindRepoInstallationResponseAccount = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type AppsFindRepoInstallationResponse = {
    access_tokens_url: string;
    account: AppsFindRepoInstallationResponseAccount;
    app_id: number;
    created_at: string;
    events: Array<string>;
    html_url: string;
    id: number;
    permissions: AppsFindRepoInstallationResponsePermissions;
    repositories_url: string;
    repository_selection: string;
    single_file_name: null;
    target_id: number;
    target_type: string;
    updated_at: string;
};
declare type AppsFindOrgInstallationResponsePermissions = {
    checks: string;
    contents: string;
    metadata: string;
};
declare type AppsFindOrgInstallationResponseAccount = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type AppsFindOrgInstallationResponse = {
    access_tokens_url: string;
    account: AppsFindOrgInstallationResponseAccount;
    app_id: number;
    created_at: string;
    events: Array<string>;
    html_url: string;
    id: number;
    permissions: AppsFindOrgInstallationResponsePermissions;
    repositories_url: string;
    repository_selection: string;
    single_file_name: null;
    target_id: number;
    target_type: string;
    updated_at: string;
};
declare type AppsCreateInstallationTokenResponseRepositoriesItemPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type AppsCreateInstallationTokenResponseRepositoriesItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type AppsCreateInstallationTokenResponseRepositoriesItem = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: AppsCreateInstallationTokenResponseRepositoriesItemOwner;
    permissions: AppsCreateInstallationTokenResponseRepositoriesItemPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type AppsCreateInstallationTokenResponsePermissions = {
    contents: string;
    issues: string;
};
declare type AppsCreateInstallationTokenResponse = {
    expires_at: string;
    permissions: AppsCreateInstallationTokenResponsePermissions;
    repositories: Array<AppsCreateInstallationTokenResponseRepositoriesItem>;
    token: string;
};
declare type AppsCreateFromManifestResponseOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type AppsCreateFromManifestResponse = {
    client_id: string;
    client_secret: string;
    created_at: string;
    description: null;
    external_url: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    owner: AppsCreateFromManifestResponseOwner;
    pem: string;
    updated_at: string;
    webhook_secret: string;
};
declare type AppsCreateContentAttachmentResponse = {
    body: string;
    id: number;
    title: string;
};
declare type AppsCheckTokenResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type AppsCheckTokenResponseApp = {
    client_id: string;
    name: string;
    url: string;
};
declare type AppsCheckTokenResponse = {
    app: AppsCheckTokenResponseApp;
    created_at: string;
    fingerprint: string;
    hashed_token: string;
    id: number;
    note: string;
    note_url: string;
    scopes: Array<string>;
    token: string;
    token_last_eight: string;
    updated_at: string;
    url: string;
    user: AppsCheckTokenResponseUser;
};
declare type AppsCheckAuthorizationResponseUser = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type AppsCheckAuthorizationResponseApp = {
    client_id: string;
    name: string;
    url: string;
};
declare type AppsCheckAuthorizationResponse = {
    app: AppsCheckAuthorizationResponseApp;
    created_at: string;
    fingerprint: string;
    hashed_token: string;
    id: number;
    note: string;
    note_url: string;
    scopes: Array<string>;
    token: string;
    token_last_eight: string;
    updated_at: string;
    url: string;
    user: AppsCheckAuthorizationResponseUser;
};
declare type AppsCheckAccountIsAssociatedWithAnyStubbedResponseMarketplacePurchasePlan = {
    accounts_url: string;
    bullets: Array<string>;
    description: string;
    has_free_trial: boolean;
    id: number;
    monthly_price_in_cents: number;
    name: string;
    number: number;
    price_model: string;
    state: string;
    unit_name: null;
    url: string;
    yearly_price_in_cents: number;
};
declare type AppsCheckAccountIsAssociatedWithAnyStubbedResponseMarketplacePurchase = {
    billing_cycle: string;
    free_trial_ends_on: string;
    next_billing_date: string;
    on_free_trial: boolean;
    plan: AppsCheckAccountIsAssociatedWithAnyStubbedResponseMarketplacePurchasePlan;
    unit_count: null;
    updated_at: string;
};
declare type AppsCheckAccountIsAssociatedWithAnyStubbedResponseMarketplacePendingChangePlan = {
    accounts_url: string;
    bullets: Array<string>;
    description: string;
    has_free_trial: boolean;
    id: number;
    monthly_price_in_cents: number;
    name: string;
    number: number;
    price_model: string;
    state: string;
    unit_name: null;
    url: string;
    yearly_price_in_cents: number;
};
declare type AppsCheckAccountIsAssociatedWithAnyStubbedResponseMarketplacePendingChange = {
    effective_date: string;
    id: number;
    plan: AppsCheckAccountIsAssociatedWithAnyStubbedResponseMarketplacePendingChangePlan;
    unit_count: null;
};
declare type AppsCheckAccountIsAssociatedWithAnyStubbedResponse = {
    email: null;
    id: number;
    login: string;
    marketplace_pending_change: AppsCheckAccountIsAssociatedWithAnyStubbedResponseMarketplacePendingChange;
    marketplace_purchase: AppsCheckAccountIsAssociatedWithAnyStubbedResponseMarketplacePurchase;
    organization_billing_email: string;
    type: string;
    url: string;
};
declare type AppsCheckAccountIsAssociatedWithAnyResponseMarketplacePurchasePlan = {
    accounts_url: string;
    bullets: Array<string>;
    description: string;
    has_free_trial: boolean;
    id: number;
    monthly_price_in_cents: number;
    name: string;
    number: number;
    price_model: string;
    state: string;
    unit_name: null;
    url: string;
    yearly_price_in_cents: number;
};
declare type AppsCheckAccountIsAssociatedWithAnyResponseMarketplacePurchase = {
    billing_cycle: string;
    free_trial_ends_on: string;
    next_billing_date: string;
    on_free_trial: boolean;
    plan: AppsCheckAccountIsAssociatedWithAnyResponseMarketplacePurchasePlan;
    unit_count: null;
    updated_at: string;
};
declare type AppsCheckAccountIsAssociatedWithAnyResponseMarketplacePendingChangePlan = {
    accounts_url: string;
    bullets: Array<string>;
    description: string;
    has_free_trial: boolean;
    id: number;
    monthly_price_in_cents: number;
    name: string;
    number: number;
    price_model: string;
    state: string;
    unit_name: null;
    url: string;
    yearly_price_in_cents: number;
};
declare type AppsCheckAccountIsAssociatedWithAnyResponseMarketplacePendingChange = {
    effective_date: string;
    id: number;
    plan: AppsCheckAccountIsAssociatedWithAnyResponseMarketplacePendingChangePlan;
    unit_count: null;
};
declare type AppsCheckAccountIsAssociatedWithAnyResponse = {
    email: null;
    id: number;
    login: string;
    marketplace_pending_change: AppsCheckAccountIsAssociatedWithAnyResponseMarketplacePendingChange;
    marketplace_purchase: AppsCheckAccountIsAssociatedWithAnyResponseMarketplacePurchase;
    organization_billing_email: string;
    type: string;
    url: string;
};
declare type ActivitySetThreadSubscriptionResponse = {
    created_at: string;
    ignored: boolean;
    reason: null;
    subscribed: boolean;
    thread_url: string;
    url: string;
};
declare type ActivitySetRepoSubscriptionResponse = {
    created_at: string;
    ignored: boolean;
    reason: null;
    repository_url: string;
    subscribed: boolean;
    url: string;
};
declare type ActivityListWatchersForRepoResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ActivityListWatchedReposForAuthenticatedUserResponseItemPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type ActivityListWatchedReposForAuthenticatedUserResponseItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ActivityListWatchedReposForAuthenticatedUserResponseItemLicense = {
    key: string;
    name: string;
    node_id: string;
    spdx_id: string;
    url: string;
};
declare type ActivityListWatchedReposForAuthenticatedUserResponseItem = {
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    license: ActivityListWatchedReposForAuthenticatedUserResponseItemLicense;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: ActivityListWatchedReposForAuthenticatedUserResponseItemOwner;
    permissions: ActivityListWatchedReposForAuthenticatedUserResponseItemPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type ActivityListStargazersForRepoResponseItem = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ActivityListReposWatchedByUserResponseItemPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type ActivityListReposWatchedByUserResponseItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ActivityListReposWatchedByUserResponseItemLicense = {
    key: string;
    name: string;
    node_id: string;
    spdx_id: string;
    url: string;
};
declare type ActivityListReposWatchedByUserResponseItem = {
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    license: ActivityListReposWatchedByUserResponseItemLicense;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: ActivityListReposWatchedByUserResponseItemOwner;
    permissions: ActivityListReposWatchedByUserResponseItemPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type ActivityListReposStarredByUserResponseItemPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type ActivityListReposStarredByUserResponseItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ActivityListReposStarredByUserResponseItem = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: ActivityListReposStarredByUserResponseItemOwner;
    permissions: ActivityListReposStarredByUserResponseItemPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type ActivityListReposStarredByAuthenticatedUserResponseItemPermissions = {
    admin: boolean;
    pull: boolean;
    push: boolean;
};
declare type ActivityListReposStarredByAuthenticatedUserResponseItemOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ActivityListReposStarredByAuthenticatedUserResponseItem = {
    allow_merge_commit: boolean;
    allow_rebase_merge: boolean;
    allow_squash_merge: boolean;
    archive_url: string;
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: string;
    default_branch: string;
    deployments_url: string;
    description: string;
    disabled: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    has_downloads: boolean;
    has_issues: boolean;
    has_pages: boolean;
    has_projects: boolean;
    has_wiki: boolean;
    homepage: string;
    hooks_url: string;
    html_url: string;
    id: number;
    is_template: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: null;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string;
    name: string;
    network_count: number;
    node_id: string;
    notifications_url: string;
    open_issues_count: number;
    owner: ActivityListReposStarredByAuthenticatedUserResponseItemOwner;
    permissions: ActivityListReposStarredByAuthenticatedUserResponseItemPermissions;
    private: boolean;
    pulls_url: string;
    pushed_at: string;
    releases_url: string;
    size: number;
    ssh_url: string;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_count: number;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    temp_clone_token: string;
    template_repository: null;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: string;
    watchers_count: number;
};
declare type ActivityListNotificationsForRepoResponseItemSubject = {
    latest_comment_url: string;
    title: string;
    type: string;
    url: string;
};
declare type ActivityListNotificationsForRepoResponseItemRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ActivityListNotificationsForRepoResponseItemRepository = {
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    description: string;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    html_url: string;
    id: number;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    name: string;
    node_id: string;
    notifications_url: string;
    owner: ActivityListNotificationsForRepoResponseItemRepositoryOwner;
    private: boolean;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    url: string;
};
declare type ActivityListNotificationsForRepoResponseItem = {
    id: string;
    last_read_at: string;
    reason: string;
    repository: ActivityListNotificationsForRepoResponseItemRepository;
    subject: ActivityListNotificationsForRepoResponseItemSubject;
    unread: boolean;
    updated_at: string;
    url: string;
};
declare type ActivityListNotificationsResponseItemSubject = {
    latest_comment_url: string;
    title: string;
    type: string;
    url: string;
};
declare type ActivityListNotificationsResponseItemRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ActivityListNotificationsResponseItemRepository = {
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    description: string;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    html_url: string;
    id: number;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    name: string;
    node_id: string;
    notifications_url: string;
    owner: ActivityListNotificationsResponseItemRepositoryOwner;
    private: boolean;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    url: string;
};
declare type ActivityListNotificationsResponseItem = {
    id: string;
    last_read_at: string;
    reason: string;
    repository: ActivityListNotificationsResponseItemRepository;
    subject: ActivityListNotificationsResponseItemSubject;
    unread: boolean;
    updated_at: string;
    url: string;
};
declare type ActivityListFeedsResponseLinksUser = {
    href: string;
    type: string;
};
declare type ActivityListFeedsResponseLinksTimeline = {
    href: string;
    type: string;
};
declare type ActivityListFeedsResponseLinksSecurityAdvisories = {
    href: string;
    type: string;
};
declare type ActivityListFeedsResponseLinksCurrentUserPublic = {
    href: string;
    type: string;
};
declare type ActivityListFeedsResponseLinksCurrentUserOrganizationsItem = {
    href: string;
    type: string;
};
declare type ActivityListFeedsResponseLinksCurrentUserOrganization = {
    href: string;
    type: string;
};
declare type ActivityListFeedsResponseLinksCurrentUserActor = {
    href: string;
    type: string;
};
declare type ActivityListFeedsResponseLinksCurrentUser = {
    href: string;
    type: string;
};
declare type ActivityListFeedsResponseLinks = {
    current_user: ActivityListFeedsResponseLinksCurrentUser;
    current_user_actor: ActivityListFeedsResponseLinksCurrentUserActor;
    current_user_organization: ActivityListFeedsResponseLinksCurrentUserOrganization;
    current_user_organizations: Array<ActivityListFeedsResponseLinksCurrentUserOrganizationsItem>;
    current_user_public: ActivityListFeedsResponseLinksCurrentUserPublic;
    security_advisories: ActivityListFeedsResponseLinksSecurityAdvisories;
    timeline: ActivityListFeedsResponseLinksTimeline;
    user: ActivityListFeedsResponseLinksUser;
};
declare type ActivityListFeedsResponse = {
    _links: ActivityListFeedsResponseLinks;
    current_user_actor_url: string;
    current_user_organization_url: string;
    current_user_organization_urls: Array<string>;
    current_user_public_url: string;
    current_user_url: string;
    security_advisories_url: string;
    timeline_url: string;
    user_url: string;
};
declare type ActivityGetThreadSubscriptionResponse = {
    created_at: string;
    ignored: boolean;
    reason: null;
    subscribed: boolean;
    thread_url: string;
    url: string;
};
declare type ActivityGetThreadResponseSubject = {
    latest_comment_url: string;
    title: string;
    type: string;
    url: string;
};
declare type ActivityGetThreadResponseRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ActivityGetThreadResponseRepository = {
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    description: string;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    html_url: string;
    id: number;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    name: string;
    node_id: string;
    notifications_url: string;
    owner: ActivityGetThreadResponseRepositoryOwner;
    private: boolean;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    url: string;
};
declare type ActivityGetThreadResponse = {
    id: string;
    last_read_at: string;
    reason: string;
    repository: ActivityGetThreadResponseRepository;
    subject: ActivityGetThreadResponseSubject;
    unread: boolean;
    updated_at: string;
    url: string;
};
declare type ActivityGetRepoSubscriptionResponse = {
    created_at: string;
    ignored: boolean;
    reason: null;
    repository_url: string;
    subscribed: boolean;
    url: string;
};
declare type ActionsListWorkflowRunsResponseWorkflowRunsItemRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ActionsListWorkflowRunsResponseWorkflowRunsItemRepository = {
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    description: string;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    html_url: string;
    id: number;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    name: string;
    node_id: string;
    notifications_url: string;
    owner: ActionsListWorkflowRunsResponseWorkflowRunsItemRepositoryOwner;
    private: boolean;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    url: string;
};
declare type ActionsListWorkflowRunsResponseWorkflowRunsItemHeadRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ActionsListWorkflowRunsResponseWorkflowRunsItemHeadRepository = {
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    description: null;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    hooks_url: string;
    html_url: string;
    id: number;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    name: string;
    node_id: string;
    notifications_url: string;
    owner: ActionsListWorkflowRunsResponseWorkflowRunsItemHeadRepositoryOwner;
    private: boolean;
    pulls_url: string;
    releases_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    url: string;
};
declare type ActionsListWorkflowRunsResponseWorkflowRunsItemHeadCommitCommitter = {
    email: string;
    name: string;
};
declare type ActionsListWorkflowRunsResponseWorkflowRunsItemHeadCommitAuthor = {
    email: string;
    name: string;
};
declare type ActionsListWorkflowRunsResponseWorkflowRunsItemHeadCommit = {
    author: ActionsListWorkflowRunsResponseWorkflowRunsItemHeadCommitAuthor;
    committer: ActionsListWorkflowRunsResponseWorkflowRunsItemHeadCommitCommitter;
    id: string;
    message: string;
    timestamp: string;
    tree_id: string;
};
declare type ActionsListWorkflowRunsResponseWorkflowRunsItem = {
    artifacts_url: string;
    cancel_url: string;
    check_suite_id: number;
    conclusion: null;
    created_at: string;
    event: string;
    head_branch: string;
    head_commit: ActionsListWorkflowRunsResponseWorkflowRunsItemHeadCommit;
    head_repository: ActionsListWorkflowRunsResponseWorkflowRunsItemHeadRepository;
    head_sha: string;
    html_url: string;
    id: number;
    jobs_url: string;
    logs_url: string;
    node_id: string;
    pull_requests: Array<any>;
    repository: ActionsListWorkflowRunsResponseWorkflowRunsItemRepository;
    rerun_url: string;
    run_number: number;
    status: string;
    updated_at: string;
    url: string;
    workflow_url: string;
};
declare type ActionsListWorkflowRunsResponse = {
    total_count: number;
    workflow_runs: Array<ActionsListWorkflowRunsResponseWorkflowRunsItem>;
};
declare type ActionsListWorkflowRunArtifactsResponseArtifactsItem = {
    archive_download_url: string;
    created_at: string;
    expired: string;
    expires_at: string;
    id: number;
    name: string;
    node_id: string;
    size_in_bytes: number;
};
declare type ActionsListWorkflowRunArtifactsResponse = {
    artifacts: Array<ActionsListWorkflowRunArtifactsResponseArtifactsItem>;
    total_count: number;
};
declare type ActionsListSelfHostedRunnersForRepoResponseItemItem = {
    id: number;
    name: string;
    os: string;
    status: string;
};
declare type ActionsListSecretsForRepoResponseSecretsItem = {
    created_at: string;
    name: string;
    updated_at: string;
};
declare type ActionsListSecretsForRepoResponse = {
    secrets: Array<ActionsListSecretsForRepoResponseSecretsItem>;
    total_count: number;
};
declare type ActionsListRepoWorkflowsResponseWorkflowsItem = {
    badge_url: string;
    created_at: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    path: string;
    state: string;
    updated_at: string;
    url: string;
};
declare type ActionsListRepoWorkflowsResponse = {
    total_count: number;
    workflows: Array<ActionsListRepoWorkflowsResponseWorkflowsItem>;
};
declare type ActionsListRepoWorkflowRunsResponseWorkflowRunsItemRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ActionsListRepoWorkflowRunsResponseWorkflowRunsItemRepository = {
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    description: string;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    html_url: string;
    id: number;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    name: string;
    node_id: string;
    notifications_url: string;
    owner: ActionsListRepoWorkflowRunsResponseWorkflowRunsItemRepositoryOwner;
    private: boolean;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    url: string;
};
declare type ActionsListRepoWorkflowRunsResponseWorkflowRunsItemHeadRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ActionsListRepoWorkflowRunsResponseWorkflowRunsItemHeadRepository = {
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    description: null;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    hooks_url: string;
    html_url: string;
    id: number;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    name: string;
    node_id: string;
    notifications_url: string;
    owner: ActionsListRepoWorkflowRunsResponseWorkflowRunsItemHeadRepositoryOwner;
    private: boolean;
    pulls_url: string;
    releases_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    url: string;
};
declare type ActionsListRepoWorkflowRunsResponseWorkflowRunsItemHeadCommitCommitter = {
    email: string;
    name: string;
};
declare type ActionsListRepoWorkflowRunsResponseWorkflowRunsItemHeadCommitAuthor = {
    email: string;
    name: string;
};
declare type ActionsListRepoWorkflowRunsResponseWorkflowRunsItemHeadCommit = {
    author: ActionsListRepoWorkflowRunsResponseWorkflowRunsItemHeadCommitAuthor;
    committer: ActionsListRepoWorkflowRunsResponseWorkflowRunsItemHeadCommitCommitter;
    id: string;
    message: string;
    timestamp: string;
    tree_id: string;
};
declare type ActionsListRepoWorkflowRunsResponseWorkflowRunsItem = {
    artifacts_url: string;
    cancel_url: string;
    check_suite_id: number;
    conclusion: null;
    created_at: string;
    event: string;
    head_branch: string;
    head_commit: ActionsListRepoWorkflowRunsResponseWorkflowRunsItemHeadCommit;
    head_repository: ActionsListRepoWorkflowRunsResponseWorkflowRunsItemHeadRepository;
    head_sha: string;
    html_url: string;
    id: number;
    jobs_url: string;
    logs_url: string;
    node_id: string;
    pull_requests: Array<any>;
    repository: ActionsListRepoWorkflowRunsResponseWorkflowRunsItemRepository;
    rerun_url: string;
    run_number: number;
    status: string;
    updated_at: string;
    url: string;
    workflow_url: string;
};
declare type ActionsListRepoWorkflowRunsResponse = {
    total_count: number;
    workflow_runs: Array<ActionsListRepoWorkflowRunsResponseWorkflowRunsItem>;
};
declare type ActionsListJobsForWorkflowRunResponseJobsItemStepsItem = {
    completed_at: string;
    conclusion: string;
    name: string;
    number: number;
    started_at: string;
    status: string;
};
declare type ActionsListJobsForWorkflowRunResponseJobsItem = {
    check_run_url: string;
    completed_at: string;
    conclusion: string;
    head_sha: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    run_id: number;
    run_url: string;
    started_at: string;
    status: string;
    steps: Array<ActionsListJobsForWorkflowRunResponseJobsItemStepsItem>;
    url: string;
};
declare type ActionsListJobsForWorkflowRunResponse = {
    jobs: Array<ActionsListJobsForWorkflowRunResponseJobsItem>;
    total_count: number;
};
declare type ActionsListDownloadsForSelfHostedRunnerApplicationResponseItem = {
    architecture: string;
    download_url: string;
    filename: string;
    os: string;
};
declare type ActionsGetWorkflowRunResponseRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ActionsGetWorkflowRunResponseRepository = {
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    description: string;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    html_url: string;
    id: number;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    name: string;
    node_id: string;
    notifications_url: string;
    owner: ActionsGetWorkflowRunResponseRepositoryOwner;
    private: boolean;
    pulls_url: string;
    releases_url: string;
    ssh_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    url: string;
};
declare type ActionsGetWorkflowRunResponseHeadRepositoryOwner = {
    avatar_url: string;
    events_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    gravatar_id: string;
    html_url: string;
    id: number;
    login: string;
    node_id: string;
    organizations_url: string;
    received_events_url: string;
    repos_url: string;
    site_admin: boolean;
    starred_url: string;
    subscriptions_url: string;
    type: string;
    url: string;
};
declare type ActionsGetWorkflowRunResponseHeadRepository = {
    archive_url: string;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    deployments_url: string;
    description: null;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    hooks_url: string;
    html_url: string;
    id: number;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    languages_url: string;
    merges_url: string;
    milestones_url: string;
    name: string;
    node_id: string;
    notifications_url: string;
    owner: ActionsGetWorkflowRunResponseHeadRepositoryOwner;
    private: boolean;
    pulls_url: string;
    releases_url: string;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    tags_url: string;
    teams_url: string;
    trees_url: string;
    url: string;
};
declare type ActionsGetWorkflowRunResponseHeadCommitCommitter = {
    email: string;
    name: string;
};
declare type ActionsGetWorkflowRunResponseHeadCommitAuthor = {
    email: string;
    name: string;
};
declare type ActionsGetWorkflowRunResponseHeadCommit = {
    author: ActionsGetWorkflowRunResponseHeadCommitAuthor;
    committer: ActionsGetWorkflowRunResponseHeadCommitCommitter;
    id: string;
    message: string;
    timestamp: string;
    tree_id: string;
};
declare type ActionsGetWorkflowRunResponse = {
    artifacts_url: string;
    cancel_url: string;
    check_suite_id: number;
    conclusion: null;
    created_at: string;
    event: string;
    head_branch: string;
    head_commit: ActionsGetWorkflowRunResponseHeadCommit;
    head_repository: ActionsGetWorkflowRunResponseHeadRepository;
    head_sha: string;
    html_url: string;
    id: number;
    jobs_url: string;
    logs_url: string;
    node_id: string;
    pull_requests: Array<any>;
    repository: ActionsGetWorkflowRunResponseRepository;
    rerun_url: string;
    run_number: number;
    status: string;
    updated_at: string;
    url: string;
    workflow_url: string;
};
declare type ActionsGetWorkflowJobResponseStepsItem = {
    completed_at: string;
    conclusion: string;
    name: string;
    number: number;
    started_at: string;
    status: string;
};
declare type ActionsGetWorkflowJobResponse = {
    check_run_url: string;
    completed_at: string;
    conclusion: string;
    head_sha: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    run_id: number;
    run_url: string;
    started_at: string;
    status: string;
    steps: Array<ActionsGetWorkflowJobResponseStepsItem>;
    url: string;
};
declare type ActionsGetWorkflowResponse = {
    badge_url: string;
    created_at: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    path: string;
    state: string;
    updated_at: string;
    url: string;
};
declare type ActionsGetSelfHostedRunnerResponse = {
    id: number;
    name: string;
    os: string;
    status: string;
};
declare type ActionsGetSecretResponse = {
    created_at: string;
    name: string;
    updated_at: string;
};
declare type ActionsGetPublicKeyResponse = {
    key: string;
    key_id: string;
};
declare type ActionsGetArtifactResponse = {
    archive_download_url: string;
    created_at: string;
    expired: string;
    expires_at: string;
    id: number;
    name: string;
    node_id: string;
    size_in_bytes: number;
};
declare type ActionsCreateRemoveTokenResponse = {
    expires_at: string;
    token: string;
};
declare type ActionsCreateRegistrationTokenResponse = {
    expires_at: string;
    token: string;
};
declare type ActionsListDownloadsForSelfHostedRunnerApplicationResponse = Array<ActionsListDownloadsForSelfHostedRunnerApplicationResponseItem>;
declare type ActionsListSelfHostedRunnersForRepoResponse = Array<Array<ActionsListSelfHostedRunnersForRepoResponseItemItem>>;
declare type ActivityListNotificationsResponse = Array<ActivityListNotificationsResponseItem>;
declare type ActivityListNotificationsForRepoResponse = Array<ActivityListNotificationsForRepoResponseItem>;
declare type ActivityListReposStarredByAuthenticatedUserResponse = Array<ActivityListReposStarredByAuthenticatedUserResponseItem>;
declare type ActivityListReposStarredByUserResponse = Array<ActivityListReposStarredByUserResponseItem>;
declare type ActivityListReposWatchedByUserResponse = Array<ActivityListReposWatchedByUserResponseItem>;
declare type ActivityListStargazersForRepoResponse = Array<ActivityListStargazersForRepoResponseItem>;
declare type ActivityListWatchedReposForAuthenticatedUserResponse = Array<ActivityListWatchedReposForAuthenticatedUserResponseItem>;
declare type ActivityListWatchersForRepoResponse = Array<ActivityListWatchersForRepoResponseItem>;
declare type AppsListAccountsUserOrOrgOnPlanResponse = Array<AppsListAccountsUserOrOrgOnPlanResponseItem>;
declare type AppsListAccountsUserOrOrgOnPlanStubbedResponse = Array<AppsListAccountsUserOrOrgOnPlanStubbedResponseItem>;
declare type AppsListInstallationsResponse = Array<AppsListInstallationsResponseItem>;
declare type AppsListMarketplacePurchasesForAuthenticatedUserResponse = Array<AppsListMarketplacePurchasesForAuthenticatedUserResponseItem>;
declare type AppsListMarketplacePurchasesForAuthenticatedUserStubbedResponse = Array<AppsListMarketplacePurchasesForAuthenticatedUserStubbedResponseItem>;
declare type AppsListPlansResponse = Array<AppsListPlansResponseItem>;
declare type AppsListPlansStubbedResponse = Array<AppsListPlansStubbedResponseItem>;
declare type ChecksListAnnotationsResponse = Array<ChecksListAnnotationsResponseItem>;
declare type CodesOfConductListConductCodesResponse = Array<CodesOfConductListConductCodesResponseItem>;
declare type GistsListResponse = Array<GistsListResponseItem>;
declare type GistsListCommentsResponse = Array<GistsListCommentsResponseItem>;
declare type GistsListCommitsResponse = Array<GistsListCommitsResponseItem>;
declare type GistsListForksResponse = Array<GistsListForksResponseItem>;
declare type GistsListPublicResponse = Array<GistsListPublicResponseItem>;
declare type GistsListPublicForUserResponse = Array<GistsListPublicForUserResponseItem>;
declare type GistsListStarredResponse = Array<GistsListStarredResponseItem>;
declare type GitListMatchingRefsResponse = Array<GitListMatchingRefsResponseItem>;
declare type GitignoreListTemplatesResponse = Array<string>;
declare type IssuesAddLabelsResponse = Array<IssuesAddLabelsResponseItem>;
declare type IssuesListResponse = Array<IssuesListResponseItem>;
declare type IssuesListAssigneesResponse = Array<IssuesListAssigneesResponseItem>;
declare type IssuesListCommentsResponse = Array<IssuesListCommentsResponseItem>;
declare type IssuesListCommentsForRepoResponse = Array<IssuesListCommentsForRepoResponseItem>;
declare type IssuesListEventsResponse = Array<IssuesListEventsResponseItem>;
declare type IssuesListEventsForRepoResponse = Array<IssuesListEventsForRepoResponseItem>;
declare type IssuesListEventsForTimelineResponse = Array<IssuesListEventsForTimelineResponseItem>;
declare type IssuesListForAuthenticatedUserResponse = Array<IssuesListForAuthenticatedUserResponseItem>;
declare type IssuesListForOrgResponse = Array<IssuesListForOrgResponseItem>;
declare type IssuesListForRepoResponse = Array<IssuesListForRepoResponseItem>;
declare type IssuesListLabelsForMilestoneResponse = Array<IssuesListLabelsForMilestoneResponseItem>;
declare type IssuesListLabelsForRepoResponse = Array<IssuesListLabelsForRepoResponseItem>;
declare type IssuesListLabelsOnIssueResponse = Array<IssuesListLabelsOnIssueResponseItem>;
declare type IssuesListMilestonesForRepoResponse = Array<IssuesListMilestonesForRepoResponseItem>;
declare type IssuesRemoveLabelResponse = Array<IssuesRemoveLabelResponseItem>;
declare type IssuesReplaceLabelsResponse = Array<IssuesReplaceLabelsResponseItem>;
declare type LicensesListResponse = Array<LicensesListResponseItem>;
declare type LicensesListCommonlyUsedResponse = Array<LicensesListCommonlyUsedResponseItem>;
declare type MigrationsGetCommitAuthorsResponse = Array<MigrationsGetCommitAuthorsResponseItem>;
declare type MigrationsGetLargeFilesResponse = Array<MigrationsGetLargeFilesResponseItem>;
declare type MigrationsListForAuthenticatedUserResponse = Array<MigrationsListForAuthenticatedUserResponseItem>;
declare type MigrationsListForOrgResponse = Array<MigrationsListForOrgResponseItem>;
declare type MigrationsListReposForOrgResponse = Array<MigrationsListReposForOrgResponseItem>;
declare type MigrationsListReposForUserResponse = Array<MigrationsListReposForUserResponseItem>;
declare type OauthAuthorizationsListAuthorizationsResponse = Array<OauthAuthorizationsListAuthorizationsResponseItem>;
declare type OauthAuthorizationsListGrantsResponse = Array<OauthAuthorizationsListGrantsResponseItem>;
declare type OrgsListResponse = Array<OrgsListResponseItem>;
declare type OrgsListBlockedUsersResponse = Array<OrgsListBlockedUsersResponseItem>;
declare type OrgsListForAuthenticatedUserResponse = Array<OrgsListForAuthenticatedUserResponseItem>;
declare type OrgsListForUserResponse = Array<OrgsListForUserResponseItem>;
declare type OrgsListHooksResponse = Array<OrgsListHooksResponseItem>;
declare type OrgsListInvitationTeamsResponse = Array<OrgsListInvitationTeamsResponseItem>;
declare type OrgsListMembersResponse = Array<OrgsListMembersResponseItem>;
declare type OrgsListMembershipsResponse = Array<OrgsListMembershipsResponseItem>;
declare type OrgsListOutsideCollaboratorsResponse = Array<OrgsListOutsideCollaboratorsResponseItem>;
declare type OrgsListPendingInvitationsResponse = Array<OrgsListPendingInvitationsResponseItem>;
declare type OrgsListPublicMembersResponse = Array<OrgsListPublicMembersResponseItem>;
declare type ProjectsListCardsResponse = Array<ProjectsListCardsResponseItem>;
declare type ProjectsListCollaboratorsResponse = Array<ProjectsListCollaboratorsResponseItem>;
declare type ProjectsListColumnsResponse = Array<ProjectsListColumnsResponseItem>;
declare type ProjectsListForOrgResponse = Array<ProjectsListForOrgResponseItem>;
declare type ProjectsListForRepoResponse = Array<ProjectsListForRepoResponseItem>;
declare type ProjectsListForUserResponse = Array<ProjectsListForUserResponseItem>;
declare type PullsGetCommentsForReviewResponse = Array<PullsGetCommentsForReviewResponseItem>;
declare type PullsListResponse = Array<PullsListResponseItem>;
declare type PullsListCommentsResponse = Array<PullsListCommentsResponseItem>;
declare type PullsListCommentsForRepoResponse = Array<PullsListCommentsForRepoResponseItem>;
declare type PullsListCommitsResponse = Array<PullsListCommitsResponseItem>;
declare type PullsListFilesResponse = Array<PullsListFilesResponseItem>;
declare type PullsListReviewsResponse = Array<PullsListReviewsResponseItem>;
declare type ReactionsListForCommitCommentResponse = Array<ReactionsListForCommitCommentResponseItem>;
declare type ReactionsListForIssueResponse = Array<ReactionsListForIssueResponseItem>;
declare type ReactionsListForIssueCommentResponse = Array<ReactionsListForIssueCommentResponseItem>;
declare type ReactionsListForPullRequestReviewCommentResponse = Array<ReactionsListForPullRequestReviewCommentResponseItem>;
declare type ReactionsListForTeamDiscussionResponse = Array<ReactionsListForTeamDiscussionResponseItem>;
declare type ReactionsListForTeamDiscussionCommentResponse = Array<ReactionsListForTeamDiscussionCommentResponseItem>;
declare type ReactionsListForTeamDiscussionCommentInOrgResponse = Array<ReactionsListForTeamDiscussionCommentInOrgResponseItem>;
declare type ReactionsListForTeamDiscussionCommentLegacyResponse = Array<ReactionsListForTeamDiscussionCommentLegacyResponseItem>;
declare type ReactionsListForTeamDiscussionInOrgResponse = Array<ReactionsListForTeamDiscussionInOrgResponseItem>;
declare type ReactionsListForTeamDiscussionLegacyResponse = Array<ReactionsListForTeamDiscussionLegacyResponseItem>;
declare type ReposAddProtectedBranchAppRestrictionsResponse = Array<ReposAddProtectedBranchAppRestrictionsResponseItem>;
declare type ReposAddProtectedBranchRequiredStatusChecksContextsResponse = Array<string>;
declare type ReposAddProtectedBranchTeamRestrictionsResponse = Array<ReposAddProtectedBranchTeamRestrictionsResponseItem>;
declare type ReposAddProtectedBranchUserRestrictionsResponse = Array<ReposAddProtectedBranchUserRestrictionsResponseItem>;
declare type ReposGetAppsWithAccessToProtectedBranchResponse = Array<ReposGetAppsWithAccessToProtectedBranchResponseItem>;
declare type ReposGetCodeFrequencyStatsResponse = Array<Array<number>>;
declare type ReposGetCommitActivityStatsResponse = Array<ReposGetCommitActivityStatsResponseItem>;
declare type ReposGetContributorsStatsResponse = Array<ReposGetContributorsStatsResponseItem>;
declare type ReposGetPunchCardStatsResponse = Array<Array<number>>;
declare type ReposGetTeamsWithAccessToProtectedBranchResponse = Array<ReposGetTeamsWithAccessToProtectedBranchResponseItem>;
declare type ReposGetTopPathsResponse = Array<ReposGetTopPathsResponseItem>;
declare type ReposGetTopReferrersResponse = Array<ReposGetTopReferrersResponseItem>;
declare type ReposGetUsersWithAccessToProtectedBranchResponse = Array<ReposGetUsersWithAccessToProtectedBranchResponseItem>;
declare type ReposListAppsWithAccessToProtectedBranchResponse = Array<ReposListAppsWithAccessToProtectedBranchResponseItem>;
declare type ReposListAssetsForReleaseResponse = Array<ReposListAssetsForReleaseResponseItem>;
declare type ReposListBranchesResponse = Array<ReposListBranchesResponseItem>;
declare type ReposListBranchesForHeadCommitResponse = Array<ReposListBranchesForHeadCommitResponseItem>;
declare type ReposListCollaboratorsResponse = Array<ReposListCollaboratorsResponseItem>;
declare type ReposListCommentsForCommitResponse = Array<ReposListCommentsForCommitResponseItem>;
declare type ReposListCommitCommentsResponse = Array<ReposListCommitCommentsResponseItem>;
declare type ReposListCommitsResponse = Array<ReposListCommitsResponseItem>;
declare type ReposListContributorsResponse = Array<ReposListContributorsResponseItem>;
declare type ReposListDeployKeysResponse = Array<ReposListDeployKeysResponseItem>;
declare type ReposListDeploymentStatusesResponse = Array<ReposListDeploymentStatusesResponseItem>;
declare type ReposListDeploymentsResponse = Array<ReposListDeploymentsResponseItem>;
declare type ReposListDownloadsResponse = Array<ReposListDownloadsResponseItem>;
declare type ReposListForOrgResponse = Array<ReposListForOrgResponseItem>;
declare type ReposListForksResponse = Array<ReposListForksResponseItem>;
declare type ReposListHooksResponse = Array<ReposListHooksResponseItem>;
declare type ReposListInvitationsResponse = Array<ReposListInvitationsResponseItem>;
declare type ReposListInvitationsForAuthenticatedUserResponse = Array<ReposListInvitationsForAuthenticatedUserResponseItem>;
declare type ReposListPagesBuildsResponse = Array<ReposListPagesBuildsResponseItem>;
declare type ReposListProtectedBranchRequiredStatusChecksContextsResponse = Array<string>;
declare type ReposListProtectedBranchTeamRestrictionsResponse = Array<ReposListProtectedBranchTeamRestrictionsResponseItem>;
declare type ReposListProtectedBranchUserRestrictionsResponse = Array<ReposListProtectedBranchUserRestrictionsResponseItem>;
declare type ReposListPublicResponse = Array<ReposListPublicResponseItem>;
declare type ReposListPullRequestsAssociatedWithCommitResponse = Array<ReposListPullRequestsAssociatedWithCommitResponseItem>;
declare type ReposListReleasesResponse = Array<ReposListReleasesResponseItem>;
declare type ReposListStatusesForRefResponse = Array<ReposListStatusesForRefResponseItem>;
declare type ReposListTagsResponse = Array<ReposListTagsResponseItem>;
declare type ReposListTeamsResponse = Array<ReposListTeamsResponseItem>;
declare type ReposListTeamsWithAccessToProtectedBranchResponse = Array<ReposListTeamsWithAccessToProtectedBranchResponseItem>;
declare type ReposListUsersWithAccessToProtectedBranchResponse = Array<ReposListUsersWithAccessToProtectedBranchResponseItem>;
declare type ReposRemoveProtectedBranchAppRestrictionsResponse = Array<ReposRemoveProtectedBranchAppRestrictionsResponseItem>;
declare type ReposRemoveProtectedBranchRequiredStatusChecksContextsResponse = Array<string>;
declare type ReposRemoveProtectedBranchTeamRestrictionsResponse = Array<ReposRemoveProtectedBranchTeamRestrictionsResponseItem>;
declare type ReposRemoveProtectedBranchUserRestrictionsResponse = Array<ReposRemoveProtectedBranchUserRestrictionsResponseItem>;
declare type ReposReplaceProtectedBranchAppRestrictionsResponse = Array<ReposReplaceProtectedBranchAppRestrictionsResponseItem>;
declare type ReposReplaceProtectedBranchRequiredStatusChecksContextsResponse = Array<string>;
declare type ReposReplaceProtectedBranchTeamRestrictionsResponse = Array<ReposReplaceProtectedBranchTeamRestrictionsResponseItem>;
declare type ReposReplaceProtectedBranchUserRestrictionsResponse = Array<ReposReplaceProtectedBranchUserRestrictionsResponseItem>;
declare type TeamsListResponse = Array<TeamsListResponseItem>;
declare type TeamsListChildResponse = Array<TeamsListChildResponseItem>;
declare type TeamsListChildInOrgResponse = Array<TeamsListChildInOrgResponseItem>;
declare type TeamsListChildLegacyResponse = Array<TeamsListChildLegacyResponseItem>;
declare type TeamsListDiscussionCommentsResponse = Array<TeamsListDiscussionCommentsResponseItem>;
declare type TeamsListDiscussionCommentsInOrgResponse = Array<TeamsListDiscussionCommentsInOrgResponseItem>;
declare type TeamsListDiscussionCommentsLegacyResponse = Array<TeamsListDiscussionCommentsLegacyResponseItem>;
declare type TeamsListDiscussionsResponse = Array<TeamsListDiscussionsResponseItem>;
declare type TeamsListDiscussionsInOrgResponse = Array<TeamsListDiscussionsInOrgResponseItem>;
declare type TeamsListDiscussionsLegacyResponse = Array<TeamsListDiscussionsLegacyResponseItem>;
declare type TeamsListForAuthenticatedUserResponse = Array<TeamsListForAuthenticatedUserResponseItem>;
declare type TeamsListMembersResponse = Array<TeamsListMembersResponseItem>;
declare type TeamsListMembersInOrgResponse = Array<TeamsListMembersInOrgResponseItem>;
declare type TeamsListMembersLegacyResponse = Array<TeamsListMembersLegacyResponseItem>;
declare type TeamsListPendingInvitationsResponse = Array<TeamsListPendingInvitationsResponseItem>;
declare type TeamsListPendingInvitationsInOrgResponse = Array<TeamsListPendingInvitationsInOrgResponseItem>;
declare type TeamsListPendingInvitationsLegacyResponse = Array<TeamsListPendingInvitationsLegacyResponseItem>;
declare type TeamsListProjectsResponse = Array<TeamsListProjectsResponseItem>;
declare type TeamsListProjectsInOrgResponse = Array<TeamsListProjectsInOrgResponseItem>;
declare type TeamsListProjectsLegacyResponse = Array<TeamsListProjectsLegacyResponseItem>;
declare type TeamsListReposResponse = Array<TeamsListReposResponseItem>;
declare type TeamsListReposInOrgResponse = Array<TeamsListReposInOrgResponseItem>;
declare type TeamsListReposLegacyResponse = Array<TeamsListReposLegacyResponseItem>;
declare type UsersAddEmailsResponse = Array<UsersAddEmailsResponseItem>;
declare type UsersListResponse = Array<UsersListResponseItem>;
declare type UsersListBlockedResponse = Array<UsersListBlockedResponseItem>;
declare type UsersListEmailsResponse = Array<UsersListEmailsResponseItem>;
declare type UsersListFollowersForAuthenticatedUserResponse = Array<UsersListFollowersForAuthenticatedUserResponseItem>;
declare type UsersListFollowersForUserResponse = Array<UsersListFollowersForUserResponseItem>;
declare type UsersListFollowingForAuthenticatedUserResponse = Array<UsersListFollowingForAuthenticatedUserResponseItem>;
declare type UsersListFollowingForUserResponse = Array<UsersListFollowingForUserResponseItem>;
declare type UsersListGpgKeysResponse = Array<UsersListGpgKeysResponseItem>;
declare type UsersListGpgKeysForUserResponse = Array<UsersListGpgKeysForUserResponseItem>;
declare type UsersListPublicEmailsResponse = Array<UsersListPublicEmailsResponseItem>;
declare type UsersListPublicKeysResponse = Array<UsersListPublicKeysResponseItem>;
declare type UsersListPublicKeysForUserResponse = Array<UsersListPublicKeysForUserResponseItem>;
declare type UsersTogglePrimaryEmailVisibilityResponse = Array<UsersTogglePrimaryEmailVisibilityResponseItem>;
export declare type ActionsCancelWorkflowRunParams = {
    owner: string;
    repo: string;
    run_id: number;
};
export declare type ActionsCreateOrUpdateSecretForRepoParams = {
    /**
     * Value for your secret, encrypted with [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages) using the public key retrieved from the [Get your public key](https://developer.github.com/v3/actions/secrets/#get-your-public-key) endpoint.
     */
    encrypted_value?: string;
    /**
     * ID of the key you used to encrypt the secret.
     */
    key_id?: string;
    name: string;
    owner: string;
    repo: string;
};
export declare type ActionsCreateRegistrationTokenParams = {
    owner: string;
    repo: string;
};
export declare type ActionsCreateRemoveTokenParams = {
    owner: string;
    repo: string;
};
export declare type ActionsDeleteArtifactParams = {
    artifact_id: number;
    owner: string;
    repo: string;
};
export declare type ActionsDeleteSecretFromRepoParams = {
    name: string;
    owner: string;
    repo: string;
};
export declare type ActionsDownloadArtifactParams = {
    archive_format: string;
    artifact_id: number;
    owner: string;
    repo: string;
};
export declare type ActionsGetArtifactParams = {
    artifact_id: number;
    owner: string;
    repo: string;
};
export declare type ActionsGetPublicKeyParams = {
    owner: string;
    repo: string;
};
export declare type ActionsGetSecretParams = {
    name: string;
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
};
export declare type ActionsGetSelfHostedRunnerParams = {
    owner: string;
    repo: string;
    runner_id: number;
};
export declare type ActionsGetWorkflowParams = {
    owner: string;
    repo: string;
    workflow_id: number;
};
export declare type ActionsGetWorkflowJobParams = {
    job_id: number;
    owner: string;
    repo: string;
};
export declare type ActionsGetWorkflowRunParams = {
    owner: string;
    repo: string;
    run_id: number;
};
export declare type ActionsListDownloadsForSelfHostedRunnerApplicationParams = {
    owner: string;
    repo: string;
};
export declare type ActionsListJobsForWorkflowRunParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
    run_id: number;
};
export declare type ActionsListRepoWorkflowRunsParams = {
    /**
     * Returns someone's workflow runs. Use the login for the user who created the `push` associated with the check suite or workflow run.
     */
    actor?: string;
    /**
     * Returns workflow runs associated with a branch. Use the name of the branch of the `push`.
     */
    branch?: string;
    /**
     * Returns workflow run triggered by the event you specify. For example, `push`, `pull_request` or `issue`. For more information, see "[Events that trigger workflows](https://help.github.com/en/actions/automating-your-workflow-with-github-actions/events-that-trigger-workflows)" in the GitHub Help documentation.
     */
    event?: string;
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
    /**
     * Returns workflow runs associated with the check run `status` or `conclusion` you specify. For example, a conclusion can be `success` or a status can be `completed`. For more information, see the `status` and `conclusion` options available in "[Create a check run](https://developer.github.com/v3/checks/runs/#create-a-check-run)."
     */
    status?: "completed" | "status" | "conclusion";
};
export declare type ActionsListRepoWorkflowsParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
};
export declare type ActionsListSecretsForRepoParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
};
export declare type ActionsListSelfHostedRunnersForRepoParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
};
export declare type ActionsListWorkflowJobLogsParams = {
    job_id: number;
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
};
export declare type ActionsListWorkflowRunArtifactsParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
    run_id: number;
};
export declare type ActionsListWorkflowRunLogsParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
    run_id: number;
};
export declare type ActionsListWorkflowRunsParams = {
    /**
     * Returns someone's workflow runs. Use the login for the user who created the `push` associated with the check suite or workflow run.
     */
    actor?: string;
    /**
     * Returns workflow runs associated with a branch. Use the name of the branch of the `push`.
     */
    branch?: string;
    /**
     * Returns workflow run triggered by the event you specify. For example, `push`, `pull_request` or `issue`. For more information, see "[Events that trigger workflows](https://help.github.com/en/actions/automating-your-workflow-with-github-actions/events-that-trigger-workflows)" in the GitHub Help documentation.
     */
    event?: string;
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
    /**
     * Returns workflow runs associated with the check run `status` or `conclusion` you specify. For example, a conclusion can be `success` or a status can be `completed`. For more information, see the `status` and `conclusion` options available in "[Create a check run](https://developer.github.com/v3/checks/runs/#create-a-check-run)."
     */
    status?: "completed" | "status" | "conclusion";
    workflow_id: number;
};
export declare type ActionsReRunWorkflowParams = {
    owner: string;
    repo: string;
    run_id: number;
};
export declare type ActionsRemoveSelfHostedRunnerParams = {
    owner: string;
    repo: string;
    runner_id: number;
};
export declare type ActivityCheckStarringRepoParams = {
    owner: string;
    repo: string;
};
export declare type ActivityCheckWatchingRepoLegacyParams = {
    owner: string;
    repo: string;
};
export declare type ActivityDeleteRepoSubscriptionParams = {
    owner: string;
    repo: string;
};
export declare type ActivityDeleteThreadSubscriptionParams = {
    thread_id: number;
};
export declare type ActivityGetRepoSubscriptionParams = {
    owner: string;
    repo: string;
};
export declare type ActivityGetThreadParams = {
    thread_id: number;
};
export declare type ActivityGetThreadSubscriptionParams = {
    thread_id: number;
};
export declare type ActivityListEventsForOrgParams = {
    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    username: string;
};
export declare type ActivityListEventsForUserParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    username: string;
};
export declare type ActivityListNotificationsParams = {
    /**
     * If `true`, show notifications marked as read.
     */
    all?: boolean;
    /**
     * Only show notifications updated before the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    before?: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * If `true`, only shows notifications in which the user is directly participating or mentioned.
     */
    participating?: boolean;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
};
export declare type ActivityListNotificationsForRepoParams = {
    /**
     * If `true`, show notifications marked as read.
     */
    all?: boolean;
    /**
     * Only show notifications updated before the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    before?: string;
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * If `true`, only shows notifications in which the user is directly participating or mentioned.
     */
    participating?: boolean;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
    /**
     * Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
};
export declare type ActivityListPublicEventsParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
};
export declare type ActivityListPublicEventsForOrgParams = {
    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
};
export declare type ActivityListPublicEventsForRepoNetworkParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
};
export declare type ActivityListPublicEventsForUserParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    username: string;
};
export declare type ActivityListReceivedEventsForUserParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    username: string;
};
export declare type ActivityListReceivedPublicEventsForUserParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    username: string;
};
export declare type ActivityListRepoEventsParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
};
export declare type ActivityListReposStarredByAuthenticatedUserParams = {
    /**
     * One of `asc` (ascending) or `desc` (descending).
     */
    direction?: "asc" | "desc";
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * One of `created` (when the repository was starred) or `updated` (when it was last pushed to).
     */
    sort?: "created" | "updated";
};
export declare type ActivityListReposStarredByUserParams = {
    /**
     * One of `asc` (ascending) or `desc` (descending).
     */
    direction?: "asc" | "desc";
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * One of `created` (when the repository was starred) or `updated` (when it was last pushed to).
     */
    sort?: "created" | "updated";
    username: string;
};
export declare type ActivityListReposWatchedByUserParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    username: string;
};
export declare type ActivityListStargazersForRepoParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
};
export declare type ActivityListWatchedReposForAuthenticatedUserParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
};
export declare type ActivityListWatchersForRepoParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
};
export declare type ActivityMarkAsReadParams = {
    /**
     * Describes the last point that notifications were checked. Anything updated since this time will not be updated. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Default: The current timestamp.
     */
    last_read_at?: string;
};
export declare type ActivityMarkNotificationsAsReadForRepoParams = {
    /**
     * Describes the last point that notifications were checked. Anything updated since this time will not be updated. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Default: The current timestamp.
     */
    last_read_at?: string;
    owner: string;
    repo: string;
};
export declare type ActivityMarkThreadAsReadParams = {
    thread_id: number;
};
export declare type ActivitySetRepoSubscriptionParams = {
    /**
     * Determines if all notifications should be blocked from this repository.
     */
    ignored?: boolean;
    owner: string;
    repo: string;
    /**
     * Determines if notifications should be received from this repository.
     */
    subscribed?: boolean;
};
export declare type ActivitySetThreadSubscriptionParams = {
    /**
     * Unsubscribes and subscribes you to a conversation. Set `ignored` to `true` to block all notifications from this thread.
     */
    ignored?: boolean;
    thread_id: number;
};
export declare type ActivityStarRepoParams = {
    owner: string;
    repo: string;
};
export declare type ActivityStopWatchingRepoLegacyParams = {
    owner: string;
    repo: string;
};
export declare type ActivityUnstarRepoParams = {
    owner: string;
    repo: string;
};
export declare type ActivityWatchRepoLegacyParams = {
    owner: string;
    repo: string;
};
export declare type AppsAddRepoToInstallationParams = {
    installation_id: number;
    repository_id: number;
};
export declare type AppsCheckAccountIsAssociatedWithAnyParams = {
    account_id: number;
};
export declare type AppsCheckAccountIsAssociatedWithAnyStubbedParams = {
    account_id: number;
};
export declare type AppsCheckAuthorizationParams = {
    access_token: string;
    client_id: string;
};
export declare type AppsCheckTokenParams = {
    /**
     * The OAuth access token used to authenticate to the GitHub API.
     */
    access_token?: string;
    client_id: string;
};
export declare type AppsCreateContentAttachmentParams = {
    /**
     * The body text of the content attachment displayed in the body or comment of an issue or pull request. This parameter supports markdown.
     */
    body: string;
    content_reference_id: number;
    /**
     * The title of the content attachment displayed in the body or comment of an issue or pull request.
     */
    title: string;
};
export declare type AppsCreateFromManifestParams = {
    code: string;
};
export declare type AppsCreateInstallationTokenParams = {
    installation_id: number;
    /**
     * The permissions granted to the access token. The permissions object includes the permission names and their access type. For a complete list of permissions and allowable values, see "[GitHub App permissions](https://developer.github.com/apps/building-github-apps/creating-github-apps-using-url-parameters/#github-app-permissions)."
     */
    permissions?: AppsCreateInstallationTokenParamsPermissions;
    /**
     * The `id`s of the repositories that the installation token can access. Providing repository `id`s restricts the access of an installation token to specific repositories. You can use the "[List repositories](https://developer.github.com/v3/apps/installations/#list-repositories)" endpoint to get the `id` of all repositories that an installation can access. For example, you can select specific repositories when creating an installation token to restrict the number of repositories that can be cloned using the token.
     */
    repository_ids?: number[];
};
export declare type AppsDeleteAuthorizationParams = {
    /**
     * The OAuth access token used to authenticate to the GitHub API.
     */
    access_token?: string;
    client_id: string;
};
export declare type AppsDeleteInstallationParams = {
    installation_id: number;
};
export declare type AppsDeleteTokenParams = {
    /**
     * The OAuth access token used to authenticate to the GitHub API.
     */
    access_token?: string;
    client_id: string;
};
export declare type AppsFindOrgInstallationParams = {
    org: string;
};
export declare type AppsFindRepoInstallationParams = {
    owner: string;
    repo: string;
};
export declare type AppsFindUserInstallationParams = {
    username: string;
};
export declare type AppsGetBySlugParams = {
    app_slug: string;
};
export declare type AppsGetInstallationParams = {
    installation_id: number;
};
export declare type AppsGetOrgInstallationParams = {
    org: string;
};
export declare type AppsGetRepoInstallationParams = {
    owner: string;
    repo: string;
};
export declare type AppsGetUserInstallationParams = {
    username: string;
};
export declare type AppsListAccountsUserOrOrgOnPlanParams = {
    /**
     * To return the oldest accounts first, set to `asc`. Can be one of `asc` or `desc`. Ignored without the `sort` parameter.
     */
    direction?: "asc" | "desc";
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    plan_id: number;
    /**
     * Sorts the GitHub accounts by the date they were created or last updated. Can be one of `created` or `updated`.
     */
    sort?: "created" | "updated";
};
export declare type AppsListAccountsUserOrOrgOnPlanStubbedParams = {
    /**
     * To return the oldest accounts first, set to `asc`. Can be one of `asc` or `desc`. Ignored without the `sort` parameter.
     */
    direction?: "asc" | "desc";
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    plan_id: number;
    /**
     * Sorts the GitHub accounts by the date they were created or last updated. Can be one of `created` or `updated`.
     */
    sort?: "created" | "updated";
};
export declare type AppsListInstallationReposForAuthenticatedUserParams = {
    installation_id: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
};
export declare type AppsListInstallationsParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
};
export declare type AppsListInstallationsForAuthenticatedUserParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
};
export declare type AppsListMarketplacePurchasesForAuthenticatedUserParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
};
export declare type AppsListMarketplacePurchasesForAuthenticatedUserStubbedParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
};
export declare type AppsListPlansParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
};
export declare type AppsListPlansStubbedParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
};
export declare type AppsListReposParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
};
export declare type AppsRemoveRepoFromInstallationParams = {
    installation_id: number;
    repository_id: number;
};
export declare type AppsResetAuthorizationParams = {
    access_token: string;
    client_id: string;
};
export declare type AppsResetTokenParams = {
    /**
     * The OAuth access token used to authenticate to the GitHub API.
     */
    access_token?: string;
    client_id: string;
};
export declare type AppsRevokeAuthorizationForApplicationParams = {
    access_token: string;
    client_id: string;
};
export declare type AppsRevokeGrantForApplicationParams = {
    access_token: string;
    client_id: string;
};
export declare type ChecksCreateParams = {
    /**
     * Displays a button on GitHub that can be clicked to alert your app to do additional tasks. For example, a code linting app can display a button that automatically fixes detected errors. The button created in this object is displayed after the check run completes. When a user clicks the button, GitHub sends the [`check_run.requested_action` webhook](https://developer.github.com/v3/activity/events/types/#checkrunevent) to your app. Each action includes a `label`, `identifier` and `description`. A maximum of three actions are accepted. See the [`actions` object](https://developer.github.com/v3/checks/runs/#actions-object) description. To learn more about check runs and requested actions, see "[Check runs and requested actions](https://developer.github.com/v3/checks/runs/#check-runs-and-requested-actions)." To learn more about check runs and requested actions, see "[Check runs and requested actions](https://developer.github.com/v3/checks/runs/#check-runs-and-requested-actions)."
     */
    actions?: ChecksCreateParamsActions[];
    /**
     * The time the check completed. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    completed_at?: string;
    /**
     * **Required if you provide `completed_at` or a `status` of `completed`**. The final conclusion of the check. Can be one of `success`, `failure`, `neutral`, `cancelled`, `timed_out`, or `action_required`. When the conclusion is `action_required`, additional details should be provided on the site specified by `details_url`.
     * **Note:** Providing `conclusion` will automatically set the `status` parameter to `completed`.
     */
    conclusion?: "success" | "failure" | "neutral" | "cancelled" | "timed_out" | "action_required";
    /**
     * The URL of the integrator's site that has the full details of the check.
     */
    details_url?: string;
    /**
     * A reference for the run on the integrator's system.
     */
    external_id?: string;
    /**
     * The SHA of the commit.
     */
    head_sha: string;
    /**
     * The name of the check. For example, "code-coverage".
     */
    name: string;
    /**
     * Check runs can accept a variety of data in the `output` object, including a `title` and `summary` and can optionally provide descriptive details about the run. See the [`output` object](https://developer.github.com/v3/checks/runs/#output-object) description.
     */
    output?: ChecksCreateParamsOutput;
    owner: string;
    repo: string;
    /**
     * The time that the check run began. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    started_at?: string;
    /**
     * The current status. Can be one of `queued`, `in_progress`, or `completed`.
     */
    status?: "queued" | "in_progress" | "completed";
};
export declare type ChecksCreateSuiteParams = {
    /**
     * The sha of the head commit.
     */
    head_sha: string;
    owner: string;
    repo: string;
};
export declare type ChecksGetParams = {
    check_run_id: number;
    owner: string;
    repo: string;
};
export declare type ChecksGetSuiteParams = {
    check_suite_id: number;
    owner: string;
    repo: string;
};
export declare type ChecksListAnnotationsParams = {
    check_run_id: number;
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
};
export declare type ChecksListForRefParams = {
    /**
     * Returns check runs with the specified `name`.
     */
    check_name?: string;
    /**
     * Filters check runs by their `completed_at` timestamp. Can be one of `latest` (returning the most recent check runs) or `all`.
     */
    filter?: "latest" | "all";
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    ref: string;
    repo: string;
    /**
     * Returns check runs with the specified `status`. Can be one of `queued`, `in_progress`, or `completed`.
     */
    status?: "queued" | "in_progress" | "completed";
};
export declare type ChecksListForSuiteParams = {
    /**
     * Returns check runs with the specified `name`.
     */
    check_name?: string;
    check_suite_id: number;
    /**
     * Filters check runs by their `completed_at` timestamp. Can be one of `latest` (returning the most recent check runs) or `all`.
     */
    filter?: "latest" | "all";
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
    /**
     * Returns check runs with the specified `status`. Can be one of `queued`, `in_progress`, or `completed`.
     */
    status?: "queued" | "in_progress" | "completed";
};
export declare type ChecksListSuitesForRefParams = {
    /**
     * Filters check suites by GitHub App `id`.
     */
    app_id?: number;
    /**
     * Filters checks suites by the name of the [check run](https://developer.github.com/v3/checks/runs/).
     */
    check_name?: string;
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    ref: string;
    repo: string;
};
export declare type ChecksRerequestSuiteParams = {
    check_suite_id: number;
    owner: string;
    repo: string;
};
export declare type ChecksSetSuitesPreferencesParams = {
    /**
     * Enables or disables automatic creation of CheckSuite events upon pushes to the repository. Enabled by default. See the [`auto_trigger_checks` object](https://developer.github.com/v3/checks/suites/#auto_trigger_checks-object) description for details.
     */
    auto_trigger_checks?: ChecksSetSuitesPreferencesParamsAutoTriggerChecks[];
    owner: string;
    repo: string;
};
export declare type ChecksUpdateParams = {
    /**
     * Possible further actions the integrator can perform, which a user may trigger. Each action includes a `label`, `identifier` and `description`. A maximum of three actions are accepted. See the [`actions` object](https://developer.github.com/v3/checks/runs/#actions-object) description. To learn more about check runs and requested actions, see "[Check runs and requested actions](https://developer.github.com/v3/checks/runs/#check-runs-and-requested-actions)."
     */
    actions?: ChecksUpdateParamsActions[];
    check_run_id: number;
    /**
     * The time the check completed. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    completed_at?: string;
    /**
     * **Required if you provide `completed_at` or a `status` of `completed`**. The final conclusion of the check. Can be one of `success`, `failure`, `neutral`, `cancelled`, `timed_out`, or `action_required`.
     * **Note:** Providing `conclusion` will automatically set the `status` parameter to `completed`.
     */
    conclusion?: "success" | "failure" | "neutral" | "cancelled" | "timed_out" | "action_required";
    /**
     * The URL of the integrator's site that has the full details of the check.
     */
    details_url?: string;
    /**
     * A reference for the run on the integrator's system.
     */
    external_id?: string;
    /**
     * The name of the check. For example, "code-coverage".
     */
    name?: string;
    /**
     * Check runs can accept a variety of data in the `output` object, including a `title` and `summary` and can optionally provide descriptive details about the run. See the [`output` object](https://developer.github.com/v3/checks/runs/#output-object-1) description.
     */
    output?: ChecksUpdateParamsOutput;
    owner: string;
    repo: string;
    /**
     * This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    started_at?: string;
    /**
     * The current status. Can be one of `queued`, `in_progress`, or `completed`.
     */
    status?: "queued" | "in_progress" | "completed";
};
export declare type CodesOfConductGetConductCodeParams = {
    key: string;
};
export declare type CodesOfConductGetForRepoParams = {
    owner: string;
    repo: string;
};
export declare type GistsCheckIsStarredParams = {
    gist_id: string;
};
export declare type GistsCreateParams = {
    /**
     * A descriptive name for this gist.
     */
    description?: string;
    /**
     * The filenames and content of each file in the gist. The keys in the `files` object represent the filename and have the type `string`.
     */
    files: GistsCreateParamsFiles;
    /**
     * When `true`, the gist will be public and available for anyone to see.
     */
    public?: boolean;
};
export declare type GistsCreateCommentParams = {
    /**
     * The comment text.
     */
    body: string;
    gist_id: string;
};
export declare type GistsDeleteParams = {
    gist_id: string;
};
export declare type GistsDeleteCommentParams = {
    comment_id: number;
    gist_id: string;
};
export declare type GistsForkParams = {
    gist_id: string;
};
export declare type GistsGetParams = {
    gist_id: string;
};
export declare type GistsGetCommentParams = {
    comment_id: number;
    gist_id: string;
};
export declare type GistsGetRevisionParams = {
    gist_id: string;
    sha: string;
};
export declare type GistsListParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Only gists updated at or after this time are returned.
     */
    since?: string;
};
export declare type GistsListCommentsParams = {
    gist_id: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
};
export declare type GistsListCommitsParams = {
    gist_id: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
};
export declare type GistsListForksParams = {
    gist_id: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
};
export declare type GistsListPublicParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Only gists updated at or after this time are returned.
     */
    since?: string;
};
export declare type GistsListPublicForUserParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Only gists updated at or after this time are returned.
     */
    since?: string;
    username: string;
};
export declare type GistsListStarredParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Only gists updated at or after this time are returned.
     */
    since?: string;
};
export declare type GistsStarParams = {
    gist_id: string;
};
export declare type GistsUnstarParams = {
    gist_id: string;
};
export declare type GistsUpdateParams = {
    /**
     * A descriptive name for this gist.
     */
    description?: string;
    /**
     * The filenames and content that make up this gist.
     */
    files?: GistsUpdateParamsFiles;
    gist_id: string;
};
export declare type GistsUpdateCommentParams = {
    /**
     * The comment text.
     */
    body: string;
    comment_id: number;
    gist_id: string;
};
export declare type GitCreateBlobParams = {
    /**
     * The new blob's content.
     */
    content: string;
    /**
     * The encoding used for `content`. Currently, `"utf-8"` and `"base64"` are supported.
     */
    encoding?: string;
    owner: string;
    repo: string;
};
export declare type GitCreateCommitParams = {
    /**
     * Information about the author of the commit. By default, the `author` will be the authenticated user and the current date. See the `author` and `committer` object below for details.
     */
    author?: GitCreateCommitParamsAuthor;
    /**
     * Information about the person who is making the commit. By default, `committer` will use the information set in `author`. See the `author` and `committer` object below for details.
     */
    committer?: GitCreateCommitParamsCommitter;
    /**
     * The commit message
     */
    message: string;
    owner: string;
    /**
     * The SHAs of the commits that were the parents of this commit. If omitted or empty, the commit will be written as a root commit. For a single parent, an array of one SHA should be provided; for a merge commit, an array of more than one should be provided.
     */
    parents: string[];
    repo: string;
    /**
     * The [PGP signature](https://en.wikipedia.org/wiki/Pretty_Good_Privacy) of the commit. GitHub adds the signature to the `gpgsig` header of the created commit. For a commit signature to be verifiable by Git or GitHub, it must be an ASCII-armored detached PGP signature over the string commit as it would be written to the object database. To pass a `signature` parameter, you need to first manually create a valid PGP signature, which can be complicated. You may find it easier to [use the command line](https://git-scm.com/book/id/v2/Git-Tools-Signing-Your-Work) to create signed commits.
     */
    signature?: string;
    /**
     * The SHA of the tree object this commit points to
     */
    tree: string;
};
export declare type GitCreateRefParams = {
    owner: string;
    /**
     * The name of the fully qualified reference (ie: `refs/heads/master`). If it doesn't start with 'refs' and have at least two slashes, it will be rejected.
     */
    ref: string;
    repo: string;
    /**
     * The SHA1 value for this reference.
     */
    sha: string;
};
export declare type GitCreateTagParams = {
    /**
     * The tag message.
     */
    message: string;
    /**
     * The SHA of the git object this is tagging.
     */
    object: string;
    owner: string;
    repo: string;
    /**
     * The tag's name. This is typically a version (e.g., "v0.0.1").
     */
    tag: string;
    /**
     * An object with information about the individual creating the tag.
     */
    tagger?: GitCreateTagParamsTagger;
    /**
     * The type of the object we're tagging. Normally this is a `commit` but it can also be a `tree` or a `blob`.
     */
    type: "commit" | "tree" | "blob";
};
export declare type GitCreateTreeParams = {
    /**
     * The SHA1 of the tree you want to update with new data. If you don't set this, the commit will be created on top of everything; however, it will only contain your change, the rest of your files will show up as deleted.
     */
    base_tree?: string;
    owner: string;
    repo: string;
    /**
     * Objects (of `path`, `mode`, `type`, and `sha`) specifying a tree structure.
     */
    tree: GitCreateTreeParamsTree[];
};
export declare type GitDeleteRefParams = {
    owner: string;
    ref: string;
    repo: string;
};
export declare type GitGetBlobParams = {
    file_sha: string;
    owner: string;
    repo: string;
};
export declare type GitGetCommitParams = {
    commit_sha: string;
    owner: string;
    repo: string;
};
export declare type GitGetRefParams = {
    owner: string;
    ref: string;
    repo: string;
};
export declare type GitGetTagParams = {
    owner: string;
    repo: string;
    tag_sha: string;
};
export declare type GitGetTreeParams = {
    owner: string;
    recursive?: "1";
    repo: string;
    tree_sha: string;
};
export declare type GitListMatchingRefsParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    ref: string;
    repo: string;
};
export declare type GitListRefsParams = {
    /**
     * Filter by sub-namespace (reference prefix). Most commen examples would be `'heads/'` and `'tags/'` to retrieve branches or tags
     */
    namespace?: string;
    owner: string;
    page?: number;
    per_page?: number;
    repo: string;
};
export declare type GitUpdateRefParams = {
    /**
     * Indicates whether to force the update or to make sure the update is a fast-forward update. Leaving this out or setting it to `false` will make sure you're not overwriting work.
     */
    force?: boolean;
    owner: string;
    ref: string;
    repo: string;
    /**
     * The SHA1 value to set this reference to
     */
    sha: string;
};
export declare type GitignoreGetTemplateParams = {
    name: string;
};
export declare type InteractionsAddOrUpdateRestrictionsForOrgParams = {
    /**
     * Specifies the group of GitHub users who can comment, open issues, or create pull requests in public repositories for the given organization. Must be one of: `existing_users`, `contributors_only`, or `collaborators_only`.
     */
    limit: "existing_users" | "contributors_only" | "collaborators_only";
    org: string;
};
export declare type InteractionsAddOrUpdateRestrictionsForRepoParams = {
    /**
     * Specifies the group of GitHub users who can comment, open issues, or create pull requests for the given repository. Must be one of: `existing_users`, `contributors_only`, or `collaborators_only`.
     */
    limit: "existing_users" | "contributors_only" | "collaborators_only";
    owner: string;
    repo: string;
};
export declare type InteractionsGetRestrictionsForOrgParams = {
    org: string;
};
export declare type InteractionsGetRestrictionsForRepoParams = {
    owner: string;
    repo: string;
};
export declare type InteractionsRemoveRestrictionsForOrgParams = {
    org: string;
};
export declare type InteractionsRemoveRestrictionsForRepoParams = {
    owner: string;
    repo: string;
};
export declare type IssuesAddAssigneesParamsDeprecatedNumber = {
    /**
     * Usernames of people to assign this issue to. _NOTE: Only users with push access can add assignees to an issue. Assignees are silently ignored otherwise._
     */
    assignees?: string[];
    /**
     * @deprecated "number" parameter renamed to "issue_number"
     */
    number: number;
    owner: string;
    repo: string;
};
export declare type IssuesAddAssigneesParams = {
    /**
     * Usernames of people to assign this issue to. _NOTE: Only users with push access can add assignees to an issue. Assignees are silently ignored otherwise._
     */
    assignees?: string[];
    issue_number: number;
    owner: string;
    repo: string;
};
export declare type IssuesAddLabelsParamsDeprecatedNumber = {
    /**
     * The name of the label to add to the issue. Must contain at least one label. **Note:** Alternatively, you can pass a single label as a `string` or an `array` of labels directly, but GitHub recommends passing an object with the `labels` key.
     */
    labels: string[];
    /**
     * @deprecated "number" parameter renamed to "issue_number"
     */
    number: number;
    owner: string;
    repo: string;
};
export declare type IssuesAddLabelsParams = {
    issue_number: number;
    /**
     * The name of the label to add to the issue. Must contain at least one label. **Note:** Alternatively, you can pass a single label as a `string` or an `array` of labels directly, but GitHub recommends passing an object with the `labels` key.
     */
    labels: string[];
    owner: string;
    repo: string;
};
export declare type IssuesCheckAssigneeParams = {
    assignee: string;
    owner: string;
    repo: string;
};
export declare type IssuesCreateParamsDeprecatedAssignee = {
    /**
     * Login for the user that this issue should be assigned to. _NOTE: Only users with push access can set the assignee for new issues. The assignee is silently dropped otherwise. **This field is deprecated.**_
     * @deprecated "assignee" parameter has been deprecated and will be removed in future
     */
    assignee?: string;
    /**
     * Logins for Users to assign to this issue. _NOTE: Only users with push access can set assignees for new issues. Assignees are silently dropped otherwise._
     */
    assignees?: string[];
    /**
     * The contents of the issue.
     */
    body?: string;
    /**
     * Labels to associate with this issue. _NOTE: Only users with push access can set labels for new issues. Labels are silently dropped otherwise._
     */
    labels?: string[];
    /**
     * The `number` of the milestone to associate this issue with. _NOTE: Only users with push access can set the milestone for new issues. The milestone is silently dropped otherwise._
     */
    milestone?: number;
    owner: string;
    repo: string;
    /**
     * The title of the issue.
     */
    title: string;
};
export declare type IssuesCreateParams = {
    /**
     * Logins for Users to assign to this issue. _NOTE: Only users with push access can set assignees for new issues. Assignees are silently dropped otherwise._
     */
    assignees?: string[];
    /**
     * The contents of the issue.
     */
    body?: string;
    /**
     * Labels to associate with this issue. _NOTE: Only users with push access can set labels for new issues. Labels are silently dropped otherwise._
     */
    labels?: string[];
    /**
     * The `number` of the milestone to associate this issue with. _NOTE: Only users with push access can set the milestone for new issues. The milestone is silently dropped otherwise._
     */
    milestone?: number;
    owner: string;
    repo: string;
    /**
     * The title of the issue.
     */
    title: string;
};
export declare type IssuesCreateCommentParamsDeprecatedNumber = {
    /**
     * The contents of the comment.
     */
    body: string;
    /**
     * @deprecated "number" parameter renamed to "issue_number"
     */
    number: number;
    owner: string;
    repo: string;
};
export declare type IssuesCreateCommentParams = {
    /**
     * The contents of the comment.
     */
    body: string;
    issue_number: number;
    owner: string;
    repo: string;
};
export declare type IssuesCreateLabelParams = {
    /**
     * The [hexadecimal color code](http://www.color-hex.com/) for the label, without the leading `#`.
     */
    color: string;
    /**
     * A short description of the label.
     */
    description?: string;
    /**
     * The name of the label. Emoji can be added to label names, using either native emoji or colon-style markup. For example, typing `:strawberry:` will render the emoji ![:strawberry:](https://github.githubassets.com/images/icons/emoji/unicode/1f353.png ":strawberry:"). For a full list of available emoji and codes, see [emoji-cheat-sheet.com](http://emoji-cheat-sheet.com/).
     */
    name: string;
    owner: string;
    repo: string;
};
export declare type IssuesCreateMilestoneParams = {
    /**
     * A description of the milestone.
     */
    description?: string;
    /**
     * The milestone due date. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    due_on?: string;
    owner: string;
    repo: string;
    /**
     * The state of the milestone. Either `open` or `closed`.
     */
    state?: "open" | "closed";
    /**
     * The title of the milestone.
     */
    title: string;
};
export declare type IssuesDeleteCommentParams = {
    comment_id: number;
    owner: string;
    repo: string;
};
export declare type IssuesDeleteLabelParams = {
    name: string;
    owner: string;
    repo: string;
};
export declare type IssuesDeleteMilestoneParamsDeprecatedNumber = {
    /**
     * @deprecated "number" parameter renamed to "milestone_number"
     */
    number: number;
    owner: string;
    repo: string;
};
export declare type IssuesDeleteMilestoneParams = {
    milestone_number: number;
    owner: string;
    repo: string;
};
export declare type IssuesGetParamsDeprecatedNumber = {
    /**
     * @deprecated "number" parameter renamed to "issue_number"
     */
    number: number;
    owner: string;
    repo: string;
};
export declare type IssuesGetParams = {
    issue_number: number;
    owner: string;
    repo: string;
};
export declare type IssuesGetCommentParams = {
    comment_id: number;
    owner: string;
    repo: string;
};
export declare type IssuesGetEventParams = {
    event_id: number;
    owner: string;
    repo: string;
};
export declare type IssuesGetLabelParams = {
    name: string;
    owner: string;
    repo: string;
};
export declare type IssuesGetMilestoneParamsDeprecatedNumber = {
    /**
     * @deprecated "number" parameter renamed to "milestone_number"
     */
    number: number;
    owner: string;
    repo: string;
};
export declare type IssuesGetMilestoneParams = {
    milestone_number: number;
    owner: string;
    repo: string;
};
export declare type IssuesListParams = {
    /**
     * The direction of the sort. Can be either `asc` or `desc`.
     */
    direction?: "asc" | "desc";
    /**
     * Indicates which sorts of issues to return. Can be one of:
     * \* `assigned`: Issues assigned to you
     * \* `created`: Issues created by you
     * \* `mentioned`: Issues mentioning you
     * \* `subscribed`: Issues you're subscribed to updates for
     * \* `all`: All issues the authenticated user can see, regardless of participation or creation
     */
    filter?: "assigned" | "created" | "mentioned" | "subscribed" | "all";
    /**
     * A list of comma separated label names. Example: `bug,ui,@high`
     */
    labels?: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Only issues updated at or after this time are returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
    /**
     * What to sort results by. Can be either `created`, `updated`, `comments`.
     */
    sort?: "created" | "updated" | "comments";
    /**
     * Indicates the state of the issues to return. Can be either `open`, `closed`, or `all`.
     */
    state?: "open" | "closed" | "all";
};
export declare type IssuesListAssigneesParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
};
export declare type IssuesListCommentsParamsDeprecatedNumber = {
    /**
     * @deprecated "number" parameter renamed to "issue_number"
     */
    number: number;
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
    /**
     * Only comments updated at or after this time are returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
};
export declare type IssuesListCommentsParams = {
    issue_number: number;
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
    /**
     * Only comments updated at or after this time are returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
};
export declare type IssuesListCommentsForRepoParams = {
    /**
     * Either `asc` or `desc`. Ignored without the `sort` parameter.
     */
    direction?: "asc" | "desc";
    owner: string;
    repo: string;
    /**
     * Only comments updated at or after this time are returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
    /**
     * Either `created` or `updated`.
     */
    sort?: "created" | "updated";
};
export declare type IssuesListEventsParamsDeprecatedNumber = {
    /**
     * @deprecated "number" parameter renamed to "issue_number"
     */
    number: number;
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
};
export declare type IssuesListEventsParams = {
    issue_number: number;
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
};
export declare type IssuesListEventsForRepoParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
};
export declare type IssuesListEventsForTimelineParamsDeprecatedNumber = {
    /**
     * @deprecated "number" parameter renamed to "issue_number"
     */
    number: number;
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
};
export declare type IssuesListEventsForTimelineParams = {
    issue_number: number;
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
};
export declare type IssuesListForAuthenticatedUserParams = {
    /**
     * The direction of the sort. Can be either `asc` or `desc`.
     */
    direction?: "asc" | "desc";
    /**
     * Indicates which sorts of issues to return. Can be one of:
     * \* `assigned`: Issues assigned to you
     * \* `created`: Issues created by you
     * \* `mentioned`: Issues mentioning you
     * \* `subscribed`: Issues you're subscribed to updates for
     * \* `all`: All issues the authenticated user can see, regardless of participation or creation
     */
    filter?: "assigned" | "created" | "mentioned" | "subscribed" | "all";
    /**
     * A list of comma separated label names. Example: `bug,ui,@high`
     */
    labels?: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Only issues updated at or after this time are returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
    /**
     * What to sort results by. Can be either `created`, `updated`, `comments`.
     */
    sort?: "created" | "updated" | "comments";
    /**
     * Indicates the state of the issues to return. Can be either `open`, `closed`, or `all`.
     */
    state?: "open" | "closed" | "all";
};
export declare type IssuesListForOrgParams = {
    /**
     * The direction of the sort. Can be either `asc` or `desc`.
     */
    direction?: "asc" | "desc";
    /**
     * Indicates which sorts of issues to return. Can be one of:
     * \* `assigned`: Issues assigned to you
     * \* `created`: Issues created by you
     * \* `mentioned`: Issues mentioning you
     * \* `subscribed`: Issues you're subscribed to updates for
     * \* `all`: All issues the authenticated user can see, regardless of participation or creation
     */
    filter?: "assigned" | "created" | "mentioned" | "subscribed" | "all";
    /**
     * A list of comma separated label names. Example: `bug,ui,@high`
     */
    labels?: string;
    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Only issues updated at or after this time are returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
    /**
     * What to sort results by. Can be either `created`, `updated`, `comments`.
     */
    sort?: "created" | "updated" | "comments";
    /**
     * Indicates the state of the issues to return. Can be either `open`, `closed`, or `all`.
     */
    state?: "open" | "closed" | "all";
};
export declare type IssuesListForRepoParams = {
    /**
     * Can be the name of a user. Pass in `none` for issues with no assigned user, and `*` for issues assigned to any user.
     */
    assignee?: string;
    /**
     * The user that created the issue.
     */
    creator?: string;
    /**
     * The direction of the sort. Can be either `asc` or `desc`.
     */
    direction?: "asc" | "desc";
    /**
     * A list of comma separated label names. Example: `bug,ui,@high`
     */
    labels?: string;
    /**
     * A user that's mentioned in the issue.
     */
    mentioned?: string;
    /**
     * If an `integer` is passed, it should refer to a milestone by its `number` field. If the string `*` is passed, issues with any milestone are accepted. If the string `none` is passed, issues without milestones are returned.
     */
    milestone?: string;
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
    /**
     * Only issues updated at or after this time are returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
    /**
     * What to sort results by. Can be either `created`, `updated`, `comments`.
     */
    sort?: "created" | "updated" | "comments";
    /**
     * Indicates the state of the issues to return. Can be either `open`, `closed`, or `all`.
     */
    state?: "open" | "closed" | "all";
};
export declare type IssuesListLabelsForMilestoneParamsDeprecatedNumber = {
    /**
     * @deprecated "number" parameter renamed to "milestone_number"
     */
    number: number;
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
};
export declare type IssuesListLabelsForMilestoneParams = {
    milestone_number: number;
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
};
export declare type IssuesListLabelsForRepoParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
};
export declare type IssuesListLabelsOnIssueParamsDeprecatedNumber = {
    /**
     * @deprecated "number" parameter renamed to "issue_number"
     */
    number: number;
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
};
export declare type IssuesListLabelsOnIssueParams = {
    issue_number: number;
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
};
export declare type IssuesListMilestonesForRepoParams = {
    /**
     * The direction of the sort. Either `asc` or `desc`.
     */
    direction?: "asc" | "desc";
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
    /**
     * What to sort results by. Either `due_on` or `completeness`.
     */
    sort?: "due_on" | "completeness";
    /**
     * The state of the milestone. Either `open`, `closed`, or `all`.
     */
    state?: "open" | "closed" | "all";
};
export declare type IssuesLockParamsDeprecatedNumber = {
    /**
     * The reason for locking the issue or pull request conversation. Lock will fail if you don't use one of these reasons:
     * \* `off-topic`
     * \* `too heated`
     * \* `resolved`
     * \* `spam`
     */
    lock_reason?: "off-topic" | "too heated" | "resolved" | "spam";
    /**
     * @deprecated "number" parameter renamed to "issue_number"
     */
    number: number;
    owner: string;
    repo: string;
};
export declare type IssuesLockParams = {
    issue_number: number;
    /**
     * The reason for locking the issue or pull request conversation. Lock will fail if you don't use one of these reasons:
     * \* `off-topic`
     * \* `too heated`
     * \* `resolved`
     * \* `spam`
     */
    lock_reason?: "off-topic" | "too heated" | "resolved" | "spam";
    owner: string;
    repo: string;
};
export declare type IssuesRemoveAssigneesParamsDeprecatedNumber = {
    /**
     * Usernames of assignees to remove from an issue. _NOTE: Only users with push access can remove assignees from an issue. Assignees are silently ignored otherwise._
     */
    assignees?: string[];
    /**
     * @deprecated "number" parameter renamed to "issue_number"
     */
    number: number;
    owner: string;
    repo: string;
};
export declare type IssuesRemoveAssigneesParams = {
    /**
     * Usernames of assignees to remove from an issue. _NOTE: Only users with push access can remove assignees from an issue. Assignees are silently ignored otherwise._
     */
    assignees?: string[];
    issue_number: number;
    owner: string;
    repo: string;
};
export declare type IssuesRemoveLabelParamsDeprecatedNumber = {
    name: string;
    /**
     * @deprecated "number" parameter renamed to "issue_number"
     */
    number: number;
    owner: string;
    repo: string;
};
export declare type IssuesRemoveLabelParams = {
    issue_number: number;
    name: string;
    owner: string;
    repo: string;
};
export declare type IssuesRemoveLabelsParamsDeprecatedNumber = {
    /**
     * @deprecated "number" parameter renamed to "issue_number"
     */
    number: number;
    owner: string;
    repo: string;
};
export declare type IssuesRemoveLabelsParams = {
    issue_number: number;
    owner: string;
    repo: string;
};
export declare type IssuesReplaceLabelsParamsDeprecatedNumber = {
    /**
     * The names of the labels to add to the issue. You can pass an empty array to remove all labels. **Note:** Alternatively, you can pass a single label as a `string` or an `array` of labels directly, but GitHub recommends passing an object with the `labels` key.
     */
    labels?: string[];
    /**
     * @deprecated "number" parameter renamed to "issue_number"
     */
    number: number;
    owner: string;
    repo: string;
};
export declare type IssuesReplaceLabelsParams = {
    issue_number: number;
    /**
     * The names of the labels to add to the issue. You can pass an empty array to remove all labels. **Note:** Alternatively, you can pass a single label as a `string` or an `array` of labels directly, but GitHub recommends passing an object with the `labels` key.
     */
    labels?: string[];
    owner: string;
    repo: string;
};
export declare type IssuesUnlockParamsDeprecatedNumber = {
    /**
     * @deprecated "number" parameter renamed to "issue_number"
     */
    number: number;
    owner: string;
    repo: string;
};
export declare type IssuesUnlockParams = {
    issue_number: number;
    owner: string;
    repo: string;
};
export declare type IssuesUpdateParamsDeprecatedNumber = {
    /**
     * Logins for Users to assign to this issue. Pass one or more user logins to _replace_ the set of assignees on this Issue. Send an empty array (`[]`) to clear all assignees from the Issue. _NOTE: Only users with push access can set assignees for new issues. Assignees are silently dropped otherwise._
     */
    assignees?: string[];
    /**
     * The contents of the issue.
     */
    body?: string;
    /**
     * Labels to associate with this issue. Pass one or more Labels to _replace_ the set of Labels on this Issue. Send an empty array (`[]`) to clear all Labels from the Issue. _NOTE: Only users with push access can set labels for issues. Labels are silently dropped otherwise._
     */
    labels?: string[];
    /**
     * The `number` of the milestone to associate this issue with or `null` to remove current. _NOTE: Only users with push access can set the milestone for issues. The milestone is silently dropped otherwise._
     */
    milestone?: number | null;
    /**
     * @deprecated "number" parameter renamed to "issue_number"
     */
    number: number;
    owner: string;
    repo: string;
    /**
     * State of the issue. Either `open` or `closed`.
     */
    state?: "open" | "closed";
    /**
     * The title of the issue.
     */
    title?: string;
};
export declare type IssuesUpdateParamsDeprecatedAssignee = {
    /**
     * Login for the user that this issue should be assigned to. **This field is deprecated.**
     * @deprecated "assignee" parameter has been deprecated and will be removed in future
     */
    assignee?: string;
    /**
     * Logins for Users to assign to this issue. Pass one or more user logins to _replace_ the set of assignees on this Issue. Send an empty array (`[]`) to clear all assignees from the Issue. _NOTE: Only users with push access can set assignees for new issues. Assignees are silently dropped otherwise._
     */
    assignees?: string[];
    /**
     * The contents of the issue.
     */
    body?: string;
    issue_number: number;
    /**
     * Labels to associate with this issue. Pass one or more Labels to _replace_ the set of Labels on this Issue. Send an empty array (`[]`) to clear all Labels from the Issue. _NOTE: Only users with push access can set labels for issues. Labels are silently dropped otherwise._
     */
    labels?: string[];
    /**
     * The `number` of the milestone to associate this issue with or `null` to remove current. _NOTE: Only users with push access can set the milestone for issues. The milestone is silently dropped otherwise._
     */
    milestone?: number | null;
    owner: string;
    repo: string;
    /**
     * State of the issue. Either `open` or `closed`.
     */
    state?: "open" | "closed";
    /**
     * The title of the issue.
     */
    title?: string;
};
export declare type IssuesUpdateParams = {
    /**
     * Logins for Users to assign to this issue. Pass one or more user logins to _replace_ the set of assignees on this Issue. Send an empty array (`[]`) to clear all assignees from the Issue. _NOTE: Only users with push access can set assignees for new issues. Assignees are silently dropped otherwise._
     */
    assignees?: string[];
    /**
     * The contents of the issue.
     */
    body?: string;
    issue_number: number;
    /**
     * Labels to associate with this issue. Pass one or more Labels to _replace_ the set of Labels on this Issue. Send an empty array (`[]`) to clear all Labels from the Issue. _NOTE: Only users with push access can set labels for issues. Labels are silently dropped otherwise._
     */
    labels?: string[];
    /**
     * The `number` of the milestone to associate this issue with or `null` to remove current. _NOTE: Only users with push access can set the milestone for issues. The milestone is silently dropped otherwise._
     */
    milestone?: number | null;
    owner: string;
    repo: string;
    /**
     * State of the issue. Either `open` or `closed`.
     */
    state?: "open" | "closed";
    /**
     * The title of the issue.
     */
    title?: string;
};
export declare type IssuesUpdateCommentParams = {
    /**
     * The contents of the comment.
     */
    body: string;
    comment_id: number;
    owner: string;
    repo: string;
};
export declare type IssuesUpdateLabelParams = {
    /**
     * The [hexadecimal color code](http://www.color-hex.com/) for the label, without the leading `#`.
     */
    color?: string;
    current_name: string;
    /**
     * A short description of the label.
     */
    description?: string;
    /**
     * The new name of the label. Emoji can be added to label names, using either native emoji or colon-style markup. For example, typing `:strawberry:` will render the emoji ![:strawberry:](https://github.githubassets.com/images/icons/emoji/unicode/1f353.png ":strawberry:"). For a full list of available emoji and codes, see [emoji-cheat-sheet.com](http://emoji-cheat-sheet.com/).
     */
    name?: string;
    owner: string;
    repo: string;
};
export declare type IssuesUpdateMilestoneParamsDeprecatedNumber = {
    /**
     * A description of the milestone.
     */
    description?: string;
    /**
     * The milestone due date. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    due_on?: string;
    /**
     * @deprecated "number" parameter renamed to "milestone_number"
     */
    number: number;
    owner: string;
    repo: string;
    /**
     * The state of the milestone. Either `open` or `closed`.
     */
    state?: "open" | "closed";
    /**
     * The title of the milestone.
     */
    title?: string;
};
export declare type IssuesUpdateMilestoneParams = {
    /**
     * A description of the milestone.
     */
    description?: string;
    /**
     * The milestone due date. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    due_on?: string;
    milestone_number: number;
    owner: string;
    repo: string;
    /**
     * The state of the milestone. Either `open` or `closed`.
     */
    state?: "open" | "closed";
    /**
     * The title of the milestone.
     */
    title?: string;
};
export declare type LicensesGetParams = {
    license: string;
};
export declare type LicensesGetForRepoParams = {
    owner: string;
    repo: string;
};
export declare type MarkdownRenderParams = {
    /**
     * The repository context to use when creating references in `gfm` mode. Omit this parameter when using `markdown` mode.
     */
    context?: string;
    /**
     * The rendering mode. Can be either:
     * \* `markdown` to render a document in plain Markdown, just like README.md files are rendered.
     * \* `gfm` to render a document in [GitHub Flavored Markdown](https://github.github.com/gfm/), which creates links for user mentions as well as references to SHA-1 hashes, issues, and pull requests.
     */
    mode?: "markdown" | "gfm";
    /**
     * The Markdown text to render in HTML. Markdown content must be 400 KB or less.
     */
    text: string;
};
export declare type MarkdownRenderRawParams = {
    data: string;
};
export declare type MigrationsCancelImportParams = {
    owner: string;
    repo: string;
};
export declare type MigrationsDeleteArchiveForAuthenticatedUserParams = {
    migration_id: number;
};
export declare type MigrationsDeleteArchiveForOrgParams = {
    migration_id: number;
    org: string;
};
export declare type MigrationsDownloadArchiveForOrgParams = {
    migration_id: number;
    org: string;
};
export declare type MigrationsGetArchiveForAuthenticatedUserParams = {
    migration_id: number;
};
export declare type MigrationsGetArchiveForOrgParams = {
    migration_id: number;
    org: string;
};
export declare type MigrationsGetCommitAuthorsParams = {
    owner: string;
    repo: string;
    /**
     * Only authors found after this id are returned. Provide the highest author ID you've seen so far. New authors may be added to the list at any point while the importer is performing the `raw` step.
     */
    since?: string;
};
export declare type MigrationsGetImportProgressParams = {
    owner: string;
    repo: string;
};
export declare type MigrationsGetLargeFilesParams = {
    owner: string;
    repo: string;
};
export declare type MigrationsGetStatusForAuthenticatedUserParams = {
    migration_id: number;
};
export declare type MigrationsGetStatusForOrgParams = {
    migration_id: number;
    org: string;
};
export declare type MigrationsListForAuthenticatedUserParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
};
export declare type MigrationsListForOrgParams = {
    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
};
export declare type MigrationsListReposForOrgParams = {
    migration_id: number;
    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
};
export declare type MigrationsListReposForUserParams = {
    migration_id: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
};
export declare type MigrationsMapCommitAuthorParams = {
    author_id: number;
    /**
     * The new Git author email.
     */
    email?: string;
    /**
     * The new Git author name.
     */
    name?: string;
    owner: string;
    repo: string;
};
export declare type MigrationsSetLfsPreferenceParams = {
    owner: string;
    repo: string;
    /**
     * Can be one of `opt_in` (large files will be stored using Git LFS) or `opt_out` (large files will be removed during the import).
     */
    use_lfs: "opt_in" | "opt_out";
};
export declare type MigrationsStartForAuthenticatedUserParams = {
    /**
     * Does not include attachments uploaded to GitHub.com in the migration data when set to `true`. Excluding attachments will reduce the migration archive file size.
     */
    exclude_attachments?: boolean;
    /**
     * Locks the `repositories` to prevent changes during the migration when set to `true`.
     */
    lock_repositories?: boolean;
    /**
     * An array of repositories to include in the migration.
     */
    repositories: string[];
};
export declare type MigrationsStartForOrgParams = {
    /**
     * Indicates whether attachments should be excluded from the migration (to reduce migration archive file size).
     */
    exclude_attachments?: boolean;
    /**
     * Indicates whether repositories should be locked (to prevent manipulation) while migrating data.
     */
    lock_repositories?: boolean;
    org: string;
    /**
     * A list of arrays indicating which repositories should be migrated.
     */
    repositories: string[];
};
export declare type MigrationsStartImportParams = {
    owner: string;
    repo: string;
    /**
     * For a tfvc import, the name of the project that is being imported.
     */
    tfvc_project?: string;
    /**
     * The originating VCS type. Can be one of `subversion`, `git`, `mercurial`, or `tfvc`. Please be aware that without this parameter, the import job will take additional time to detect the VCS type before beginning the import. This detection step will be reflected in the response.
     */
    vcs?: "subversion" | "git" | "mercurial" | "tfvc";
    /**
     * If authentication is required, the password to provide to `vcs_url`.
     */
    vcs_password?: string;
    /**
     * The URL of the originating repository.
     */
    vcs_url: string;
    /**
     * If authentication is required, the username to provide to `vcs_url`.
     */
    vcs_username?: string;
};
export declare type MigrationsUnlockRepoForAuthenticatedUserParams = {
    migration_id: number;
    repo_name: string;
};
export declare type MigrationsUnlockRepoForOrgParams = {
    migration_id: number;
    org: string;
    repo_name: string;
};
export declare type MigrationsUpdateImportParams = {
    owner: string;
    repo: string;
    /**
     * The password to provide to the originating repository.
     */
    vcs_password?: string;
    /**
     * The username to provide to the originating repository.
     */
    vcs_username?: string;
};
export declare type OauthAuthorizationsCheckAuthorizationParams = {
    access_token: string;
    client_id: string;
};
export declare type OauthAuthorizationsCreateAuthorizationParams = {
    /**
     * The 20 character OAuth app client key for which to create the token.
     */
    client_id?: string;
    /**
     * The 40 character OAuth app client secret for which to create the token.
     */
    client_secret?: string;
    /**
     * A unique string to distinguish an authorization from others created for the same client ID and user.
     */
    fingerprint?: string;
    /**
     * A note to remind you what the OAuth token is for. Tokens not associated with a specific OAuth application (i.e. personal access tokens) must have a unique note.
     */
    note: string;
    /**
     * A URL to remind you what app the OAuth token is for.
     */
    note_url?: string;
    /**
     * A list of scopes that this authorization is in.
     */
    scopes?: string[];
};
export declare type OauthAuthorizationsDeleteAuthorizationParams = {
    authorization_id: number;
};
export declare type OauthAuthorizationsDeleteGrantParams = {
    grant_id: number;
};
export declare type OauthAuthorizationsGetAuthorizationParams = {
    authorization_id: number;
};
export declare type OauthAuthorizationsGetGrantParams = {
    grant_id: number;
};
export declare type OauthAuthorizationsGetOrCreateAuthorizationForAppParams = {
    client_id: string;
    /**
     * The 40 character OAuth app client secret associated with the client ID specified in the URL.
     */
    client_secret: string;
    /**
     * A unique string to distinguish an authorization from others created for the same client and user. If provided, this API is functionally equivalent to [Get-or-create an authorization for a specific app and fingerprint](https://developer.github.com/v3/oauth_authorizations/#get-or-create-an-authorization-for-a-specific-app-and-fingerprint).
     */
    fingerprint?: string;
    /**
     * A note to remind you what the OAuth token is for.
     */
    note?: string;
    /**
     * A URL to remind you what app the OAuth token is for.
     */
    note_url?: string;
    /**
     * A list of scopes that this authorization is in.
     */
    scopes?: string[];
};
export declare type OauthAuthorizationsGetOrCreateAuthorizationForAppAndFingerprintParams = {
    client_id: string;
    /**
     * The 40 character OAuth app client secret associated with the client ID specified in the URL.
     */
    client_secret: string;
    fingerprint: string;
    /**
     * A note to remind you what the OAuth token is for.
     */
    note?: string;
    /**
     * A URL to remind you what app the OAuth token is for.
     */
    note_url?: string;
    /**
     * A list of scopes that this authorization is in.
     */
    scopes?: string[];
};
export declare type OauthAuthorizationsGetOrCreateAuthorizationForAppFingerprintParams = {
    client_id: string;
    /**
     * The 40 character OAuth app client secret associated with the client ID specified in the URL.
     */
    client_secret: string;
    fingerprint: string;
    /**
     * A note to remind you what the OAuth token is for.
     */
    note?: string;
    /**
     * A URL to remind you what app the OAuth token is for.
     */
    note_url?: string;
    /**
     * A list of scopes that this authorization is in.
     */
    scopes?: string[];
};
export declare type OauthAuthorizationsListAuthorizationsParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
};
export declare type OauthAuthorizationsListGrantsParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
};
export declare type OauthAuthorizationsResetAuthorizationParams = {
    access_token: string;
    client_id: string;
};
export declare type OauthAuthorizationsRevokeAuthorizationForApplicationParams = {
    access_token: string;
    client_id: string;
};
export declare type OauthAuthorizationsRevokeGrantForApplicationParams = {
    access_token: string;
    client_id: string;
};
export declare type OauthAuthorizationsUpdateAuthorizationParams = {
    /**
     * A list of scopes to add to this authorization.
     */
    add_scopes?: string[];
    authorization_id: number;
    /**
     * A unique string to distinguish an authorization from others created for the same client ID and user.
     */
    fingerprint?: string;
    /**
     * A note to remind you what the OAuth token is for. Tokens not associated with a specific OAuth application (i.e. personal access tokens) must have a unique note.
     */
    note?: string;
    /**
     * A URL to remind you what app the OAuth token is for.
     */
    note_url?: string;
    /**
     * A list of scopes to remove from this authorization.
     */
    remove_scopes?: string[];
    /**
     * Replaces the authorization scopes with these.
     */
    scopes?: string[];
};
export declare type OrgsAddOrUpdateMembershipParams = {
    org: string;
    /**
     * The role to give the user in the organization. Can be one of:
     * \* `admin` - The user will become an owner of the organization.
     * \* `member` - The user will become a non-owner member of the organization.
     */
    role?: "admin" | "member";
    username: string;
};
export declare type OrgsBlockUserParams = {
    org: string;
    username: string;
};
export declare type OrgsCheckBlockedUserParams = {
    org: string;
    username: string;
};
export declare type OrgsCheckMembershipParams = {
    org: string;
    username: string;
};
export declare type OrgsCheckPublicMembershipParams = {
    org: string;
    username: string;
};
export declare type OrgsConcealMembershipParams = {
    org: string;
    username: string;
};
export declare type OrgsConvertMemberToOutsideCollaboratorParams = {
    org: string;
    username: string;
};
export declare type OrgsCreateHookParams = {
    /**
     * Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.
     */
    active?: boolean;
    /**
     * Key/value pairs to provide settings for this webhook. [These are defined below](https://developer.github.com/v3/orgs/hooks/#create-hook-config-params).
     */
    config: OrgsCreateHookParamsConfig;
    /**
     * Determines what [events](https://developer.github.com/v3/activity/events/types/) the hook is triggered for.
     */
    events?: string[];
    /**
     * Must be passed as "web".
     */
    name: string;
    org: string;
};
export declare type OrgsCreateInvitationParams = {
    /**
     * **Required unless you provide `invitee_id`**. Email address of the person you are inviting, which can be an existing GitHub user.
     */
    email?: string;
    /**
     * **Required unless you provide `email`**. GitHub user ID for the person you are inviting.
     */
    invitee_id?: number;
    org: string;
    /**
     * Specify role for new member. Can be one of:
     * \* `admin` - Organization owners with full administrative rights to the organization and complete access to all repositories and teams.
     * \* `direct_member` - Non-owner organization members with ability to see other members and join teams by invitation.
     * \* `billing_manager` - Non-owner organization members with ability to manage the billing settings of your organization.
     */
    role?: "admin" | "direct_member" | "billing_manager";
    /**
     * Specify IDs for the teams you want to invite new members to.
     */
    team_ids?: number[];
};
export declare type OrgsDeleteHookParams = {
    hook_id: number;
    org: string;
};
export declare type OrgsGetParams = {
    org: string;
};
export declare type OrgsGetHookParams = {
    hook_id: number;
    org: string;
};
export declare type OrgsGetMembershipParams = {
    org: string;
    username: string;
};
export declare type OrgsGetMembershipForAuthenticatedUserParams = {
    org: string;
};
export declare type OrgsListParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * The integer ID of the last organization that you've seen.
     */
    since?: number;
};
export declare type OrgsListBlockedUsersParams = {
    org: string;
};
export declare type OrgsListForAuthenticatedUserParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
};
export declare type OrgsListForUserParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    username: string;
};
export declare type OrgsListHooksParams = {
    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
};
export declare type OrgsListInstallationsParams = {
    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
};
export declare type OrgsListInvitationTeamsParams = {
    invitation_id: number;
    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
};
export declare type OrgsListMembersParams = {
    /**
     * Filter members returned in the list. Can be one of:
     * \* `2fa_disabled` - Members without [two-factor authentication](https://github.com/blog/1614-two-factor-authentication) enabled. Available for organization owners.
     * \* `all` - All members the authenticated user can see.
     */
    filter?: "2fa_disabled" | "all";
    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Filter members returned by their role. Can be one of:
     * \* `all` - All members of the organization, regardless of role.
     * \* `admin` - Organization owners.
     * \* `member` - Non-owner organization members.
     */
    role?: "all" | "admin" | "member";
};
export declare type OrgsListMembershipsParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Indicates the state of the memberships to return. Can be either `active` or `pending`. If not specified, the API returns both active and pending memberships.
     */
    state?: "active" | "pending";
};
export declare type OrgsListOutsideCollaboratorsParams = {
    /**
     * Filter the list of outside collaborators. Can be one of:
     * \* `2fa_disabled`: Outside collaborators without [two-factor authentication](https://github.com/blog/1614-two-factor-authentication) enabled.
     * \* `all`: All outside collaborators.
     */
    filter?: "2fa_disabled" | "all";
    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
};
export declare type OrgsListPendingInvitationsParams = {
    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
};
export declare type OrgsListPublicMembersParams = {
    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
};
export declare type OrgsPingHookParams = {
    hook_id: number;
    org: string;
};
export declare type OrgsPublicizeMembershipParams = {
    org: string;
    username: string;
};
export declare type OrgsRemoveMemberParams = {
    org: string;
    username: string;
};
export declare type OrgsRemoveMembershipParams = {
    org: string;
    username: string;
};
export declare type OrgsRemoveOutsideCollaboratorParams = {
    org: string;
    username: string;
};
export declare type OrgsUnblockUserParams = {
    org: string;
    username: string;
};
export declare type OrgsUpdateParamsDeprecatedMembersAllowedRepositoryCreationType = {
    /**
     * Billing email address. This address is not publicized.
     */
    billing_email?: string;
    /**
     * The company name.
     */
    company?: string;
    /**
     * Default permission level members have for organization repositories:
     * \* `read` - can pull, but not push to or administer this repository.
     * \* `write` - can pull and push, but not administer this repository.
     * \* `admin` - can pull, push, and administer this repository.
     * \* `none` - no permissions granted by default.
     */
    default_repository_permission?: "read" | "write" | "admin" | "none";
    /**
     * The description of the company.
     */
    description?: string;
    /**
     * The publicly visible email address.
     */
    email?: string;
    /**
     * Toggles whether an organization can use organization projects.
     */
    has_organization_projects?: boolean;
    /**
     * Toggles whether repositories that belong to the organization can use repository projects.
     */
    has_repository_projects?: boolean;
    /**
     * The location.
     */
    location?: string;
    /**
     * Specifies which types of repositories non-admin organization members can create. Can be one of:
     * \* `all` - all organization members can create public and private repositories.
     * \* `private` - members can create private repositories. This option is only available to repositories that are part of an organization on GitHub Enterprise Cloud.
     * \* `none` - only admin members can create repositories.
     * **Note:** This parameter is deprecated and will be removed in the future. Its return value ignores internal repositories. Using this parameter overrides values set in `members_can_create_repositories`. See [this note](https://developer.github.com/v3/orgs/#members_can_create_repositories) for details.
     * @deprecated "members_allowed_repository_creation_type" parameter has been deprecated and will be removed in future
     */
    members_allowed_repository_creation_type?: string;
    /**
     * Toggles whether organization members can create internal repositories, which are visible to all enterprise members. You can only allow members to create internal repositories if your organization is associated with an enterprise account using GitHub Enterprise Cloud. Can be one of:
     * \* `true` - all organization members can create internal repositories.
     * \* `false` - only organization owners can create internal repositories.
     * Default: `true`. For more information, see "[Restricting repository creation in your organization](https://help.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)" in the GitHub Help documentation.
     */
    members_can_create_internal_repositories?: boolean;
    /**
     * Toggles whether organization members can create private repositories, which are visible to organization members with permission. Can be one of:
     * \* `true` - all organization members can create private repositories.
     * \* `false` - only organization owners can create private repositories.
     * Default: `true`. For more information, see "[Restricting repository creation in your organization](https://help.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)" in the GitHub Help documentation.
     */
    members_can_create_private_repositories?: boolean;
    /**
     * Toggles whether organization members can create public repositories, which are visible to anyone. Can be one of:
     * \* `true` - all organization members can create public repositories.
     * \* `false` - only organization owners can create public repositories.
     * Default: `true`. For more information, see "[Restricting repository creation in your organization](https://help.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)" in the GitHub Help documentation.
     */
    members_can_create_public_repositories?: boolean;
    /**
     * Toggles the ability of non-admin organization members to create repositories. Can be one of:
     * \* `true` - all organization members can create repositories.
     * \* `false` - only organization owners can create repositories.
     * Default: `true`
     * **Note:** A parameter can override this parameter. See `members_allowed_repository_creation_type` in this table for details. **Note:** A parameter can override this parameter. See `members_allowed_repository_creation_type` in this table for details.
     */
    members_can_create_repositories?: boolean;
    /**
     * The shorthand name of the company.
     */
    name?: string;
    org: string;
};
export declare type OrgsUpdateParams = {
    /**
     * Billing email address. This address is not publicized.
     */
    billing_email?: string;
    /**
     * The company name.
     */
    company?: string;
    /**
     * Default permission level members have for organization repositories:
     * \* `read` - can pull, but not push to or administer this repository.
     * \* `write` - can pull and push, but not administer this repository.
     * \* `admin` - can pull, push, and administer this repository.
     * \* `none` - no permissions granted by default.
     */
    default_repository_permission?: "read" | "write" | "admin" | "none";
    /**
     * The description of the company.
     */
    description?: string;
    /**
     * The publicly visible email address.
     */
    email?: string;
    /**
     * Toggles whether an organization can use organization projects.
     */
    has_organization_projects?: boolean;
    /**
     * Toggles whether repositories that belong to the organization can use repository projects.
     */
    has_repository_projects?: boolean;
    /**
     * The location.
     */
    location?: string;
    /**
     * Toggles whether organization members can create internal repositories, which are visible to all enterprise members. You can only allow members to create internal repositories if your organization is associated with an enterprise account using GitHub Enterprise Cloud. Can be one of:
     * \* `true` - all organization members can create internal repositories.
     * \* `false` - only organization owners can create internal repositories.
     * Default: `true`. For more information, see "[Restricting repository creation in your organization](https://help.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)" in the GitHub Help documentation.
     */
    members_can_create_internal_repositories?: boolean;
    /**
     * Toggles whether organization members can create private repositories, which are visible to organization members with permission. Can be one of:
     * \* `true` - all organization members can create private repositories.
     * \* `false` - only organization owners can create private repositories.
     * Default: `true`. For more information, see "[Restricting repository creation in your organization](https://help.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)" in the GitHub Help documentation.
     */
    members_can_create_private_repositories?: boolean;
    /**
     * Toggles whether organization members can create public repositories, which are visible to anyone. Can be one of:
     * \* `true` - all organization members can create public repositories.
     * \* `false` - only organization owners can create public repositories.
     * Default: `true`. For more information, see "[Restricting repository creation in your organization](https://help.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)" in the GitHub Help documentation.
     */
    members_can_create_public_repositories?: boolean;
    /**
     * Toggles the ability of non-admin organization members to create repositories. Can be one of:
     * \* `true` - all organization members can create repositories.
     * \* `false` - only organization owners can create repositories.
     * Default: `true`
     * **Note:** A parameter can override this parameter. See `members_allowed_repository_creation_type` in this table for details. **Note:** A parameter can override this parameter. See `members_allowed_repository_creation_type` in this table for details.
     */
    members_can_create_repositories?: boolean;
    /**
     * The shorthand name of the company.
     */
    name?: string;
    org: string;
};
export declare type OrgsUpdateHookParams = {
    /**
     * Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.
     */
    active?: boolean;
    /**
     * Key/value pairs to provide settings for this webhook. [These are defined below](https://developer.github.com/v3/orgs/hooks/#update-hook-config-params).
     */
    config?: OrgsUpdateHookParamsConfig;
    /**
     * Determines what [events](https://developer.github.com/v3/activity/events/types/) the hook is triggered for.
     */
    events?: string[];
    hook_id: number;
    org: string;
};
export declare type OrgsUpdateMembershipParams = {
    org: string;
    /**
     * The state that the membership should be in. Only `"active"` will be accepted.
     */
    state: "active";
};
export declare type ProjectsAddCollaboratorParams = {
    /**
     * The permission to grant the collaborator. Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://developer.github.com/v3/#http-verbs)." Can be one of:
     * \* `read` - can read, but not write to or administer this project.
     * \* `write` - can read and write, but not administer this project.
     * \* `admin` - can read, write and administer this project.
     */
    permission?: "read" | "write" | "admin";
    project_id: number;
    username: string;
};
export declare type ProjectsCreateCardParams = {
    column_id: number;
    /**
     * The issue or pull request id you want to associate with this card. You can use the [List issues for a repository](https://developer.github.com/v3/issues/#list-issues-for-a-repository) and [List pull requests](https://developer.github.com/v3/pulls/#list-pull-requests) endpoints to find this id.
     * **Note:** Depending on whether you use the issue id or pull request id, you will need to specify `Issue` or `PullRequest` as the `content_type`.
     */
    content_id?: number;
    /**
     * **Required if you provide `content_id`**. The type of content you want to associate with this card. Use `Issue` when `content_id` is an issue id and use `PullRequest` when `content_id` is a pull request id.
     */
    content_type?: string;
    /**
     * The card's note content. Only valid for cards without another type of content, so you must omit when specifying `content_id` and `content_type`.
     */
    note?: string;
};
export declare type ProjectsCreateColumnParams = {
    /**
     * The name of the column.
     */
    name: string;
    project_id: number;
};
export declare type ProjectsCreateForAuthenticatedUserParams = {
    /**
     * The description of the project.
     */
    body?: string;
    /**
     * The name of the project.
     */
    name: string;
};
export declare type ProjectsCreateForOrgParams = {
    /**
     * The description of the project.
     */
    body?: string;
    /**
     * The name of the project.
     */
    name: string;
    org: string;
};
export declare type ProjectsCreateForRepoParams = {
    /**
     * The description of the project.
     */
    body?: string;
    /**
     * The name of the project.
     */
    name: string;
    owner: string;
    repo: string;
};
export declare type ProjectsDeleteParams = {
    project_id: number;
};
export declare type ProjectsDeleteCardParams = {
    card_id: number;
};
export declare type ProjectsDeleteColumnParams = {
    column_id: number;
};
export declare type ProjectsGetParams = {
    project_id: number;
};
export declare type ProjectsGetCardParams = {
    card_id: number;
};
export declare type ProjectsGetColumnParams = {
    column_id: number;
};
export declare type ProjectsListCardsParams = {
    /**
     * Filters the project cards that are returned by the card's state. Can be one of `all`,`archived`, or `not_archived`.
     */
    archived_state?: "all" | "archived" | "not_archived";
    column_id: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
};
export declare type ProjectsListCollaboratorsParams = {
    /**
     * Filters the collaborators by their affiliation. Can be one of:
     * \* `outside`: Outside collaborators of a project that are not a member of the project's organization.
     * \* `direct`: Collaborators with permissions to a project, regardless of organization membership status.
     * \* `all`: All collaborators the authenticated user can see.
     */
    affiliation?: "outside" | "direct" | "all";
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    project_id: number;
};
export declare type ProjectsListColumnsParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    project_id: number;
};
export declare type ProjectsListForOrgParams = {
    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Indicates the state of the projects to return. Can be either `open`, `closed`, or `all`.
     */
    state?: "open" | "closed" | "all";
};
export declare type ProjectsListForRepoParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
    /**
     * Indicates the state of the projects to return. Can be either `open`, `closed`, or `all`.
     */
    state?: "open" | "closed" | "all";
};
export declare type ProjectsListForUserParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Indicates the state of the projects to return. Can be either `open`, `closed`, or `all`.
     */
    state?: "open" | "closed" | "all";
    username: string;
};
export declare type ProjectsMoveCardParams = {
    card_id: number;
    /**
     * The `id` value of a column in the same project.
     */
    column_id?: number;
    /**
     * Can be one of `top`, `bottom`, or `after:<card_id>`, where `<card_id>` is the `id` value of a card in the same column, or in the new column specified by `column_id`.
     */
    position: string;
};
export declare type ProjectsMoveColumnParams = {
    column_id: number;
    /**
     * Can be one of `first`, `last`, or `after:<column_id>`, where `<column_id>` is the `id` value of a column in the same project.
     */
    position: string;
};
export declare type ProjectsRemoveCollaboratorParams = {
    project_id: number;
    username: string;
};
export declare type ProjectsReviewUserPermissionLevelParams = {
    project_id: number;
    username: string;
};
export declare type ProjectsUpdateParams = {
    /**
     * The description of the project.
     */
    body?: string;
    /**
     * The name of the project.
     */
    name?: string;
    /**
     * The permission level that determines whether all members of the project's organization can see and/or make changes to the project. Setting `organization_permission` is only available for organization projects. If an organization member belongs to a team with a higher level of access or is a collaborator with a higher level of access, their permission level is not lowered by `organization_permission`. For information on changing access for a team or collaborator, see [Add or update team project](https://developer.github.com/v3/teams/#add-or-update-team-project) or [Add user as a collaborator](https://developer.github.com/v3/projects/collaborators/#add-user-as-a-collaborator).
     *
     * **Note:** Updating a project's `organization_permission` requires `admin` access to the project.
     *
     * Can be one of:
     * \* `read` - Organization members can read, but not write to or administer this project.
     * \* `write` - Organization members can read and write, but not administer this project.
     * \* `admin` - Organization members can read, write and administer this project.
     * \* `none` - Organization members can only see this project if it is public.
     */
    organization_permission?: string;
    /**
     * Sets the visibility of a project board. Setting `private` is only available for organization and user projects. **Note:** Updating a project's visibility requires `admin` access to the project.
     *
     * Can be one of:
     * \* `false` - Anyone can see the project.
     * \* `true` - Only the user can view a project board created on a user account. Organization members with the appropriate `organization_permission` can see project boards in an organization account.
     */
    private?: boolean;
    project_id: number;
    /**
     * State of the project. Either `open` or `closed`.
     */
    state?: "open" | "closed";
};
export declare type ProjectsUpdateCardParams = {
    /**
     * Use `true` to archive a project card. Specify `false` if you need to restore a previously archived project card.
     */
    archived?: boolean;
    card_id: number;
    /**
     * The card's note content. Only valid for cards without another type of content, so this cannot be specified if the card already has a `content_id` and `content_type`.
     */
    note?: string;
};
export declare type ProjectsUpdateColumnParams = {
    column_id: number;
    /**
     * The new name of the column.
     */
    name: string;
};
export declare type PullsCheckIfMergedParamsDeprecatedNumber = {
    /**
     * @deprecated "number" parameter renamed to "pull_number"
     */
    number: number;
    owner: string;
    repo: string;
};
export declare type PullsCheckIfMergedParams = {
    owner: string;
    pull_number: number;
    repo: string;
};
export declare type PullsCreateParams = {
    /**
     * The name of the branch you want the changes pulled into. This should be an existing branch on the current repository. You cannot submit a pull request to one repository that requests a merge to a base of another repository.
     */
    base: string;
    /**
     * The contents of the pull request.
     */
    body?: string;
    /**
     * Indicates whether the pull request is a draft. See "[Draft Pull Requests](https://help.github.com/en/articles/about-pull-requests#draft-pull-requests)" in the GitHub Help documentation to learn more.
     */
    draft?: boolean;
    /**
     * The name of the branch where your changes are implemented. For cross-repository pull requests in the same network, namespace `head` with a user like this: `username:branch`.
     */
    head: string;
    /**
     * Indicates whether [maintainers can modify](https://help.github.com/articles/allowing-changes-to-a-pull-request-branch-created-from-a-fork/) the pull request.
     */
    maintainer_can_modify?: boolean;
    owner: string;
    repo: string;
    /**
     * The title of the new pull request.
     */
    title: string;
};
export declare type PullsCreateCommentParamsDeprecatedNumber = {
    /**
     * The text of the review comment.
     */
    body: string;
    /**
     * The SHA of the commit needing a comment. Not using the latest commit SHA may render your comment outdated if a subsequent commit modifies the line you specify as the `position`.
     */
    commit_id: string;
    /**
     * **Required with `comfort-fade` preview**. The line of the blob in the pull request diff that the comment applies to. For a multi-line comment, the last line of the range that your comment applies to.
     */
    line?: number;
    /**
     * @deprecated "number" parameter renamed to "pull_number"
     */
    number: number;
    owner: string;
    /**
     * The relative path to the file that necessitates a comment.
     */
    path: string;
    /**
     * **Required without `comfort-fade` preview**. The position in the diff where you want to add a review comment. Note this value is not the same as the line number in the file. For help finding the position value, read the note above.
     */
    position?: number;
    repo: string;
    /**
     * **Required with `comfort-fade` preview**. In a split diff view, the side of the diff that the pull request's changes appear on. Can be `LEFT` or `RIGHT`. Use `LEFT` for deletions that appear in red. Use `RIGHT` for additions that appear in green or unchanged lines that appear in white and are shown for context. For a multi-line comment, side represents whether the last line of the comment range is a deletion or addition. For more information, see "[Diff view options](https://help.github.com/en/articles/about-comparing-branches-in-pull-requests#diff-view-options)" in the GitHub Help documentation.
     */
    side?: "LEFT" | "RIGHT";
    /**
     * **Required when using multi-line comments**. To create multi-line comments, you must use the `comfort-fade` preview header. The `start_line` is the first line in the pull request diff that your multi-line comment applies to. To learn more about multi-line comments, see "[Commenting on a pull request](https://help.github.com/en/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)" in the GitHub Help documentation.
     */
    start_line?: number;
    /**
     * **Required when using multi-line comments**. To create multi-line comments, you must use the `comfort-fade` preview header. The `start_side` is the starting side of the diff that the comment applies to. Can be `LEFT` or `RIGHT`. To learn more about multi-line comments, see "[Commenting on a pull request](https://help.github.com/en/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)" in the GitHub Help documentation. See `side` in this table for additional context.
     */
    start_side?: "LEFT" | "RIGHT" | "side";
};
export declare type PullsCreateCommentParamsDeprecatedInReplyTo = {
    /**
     * The text of the review comment.
     */
    body: string;
    /**
     * The SHA of the commit needing a comment. Not using the latest commit SHA may render your comment outdated if a subsequent commit modifies the line you specify as the `position`.
     */
    commit_id: string;
    /**
     * The comment ID to reply to. **Note**: This must be the ID of a top-level comment, not a reply to that comment. Replies to replies are not supported.
     * @deprecated "in_reply_to" parameter has been deprecated and will be removed in future
     */
    in_reply_to?: number;
    /**
     * **Required with `comfort-fade` preview**. The line of the blob in the pull request diff that the comment applies to. For a multi-line comment, the last line of the range that your comment applies to.
     */
    line?: number;
    owner: string;
    /**
     * The relative path to the file that necessitates a comment.
     */
    path: string;
    /**
     * **Required without `comfort-fade` preview**. The position in the diff where you want to add a review comment. Note this value is not the same as the line number in the file. For help finding the position value, read the note above.
     */
    position?: number;
    pull_number: number;
    repo: string;
    /**
     * **Required with `comfort-fade` preview**. In a split diff view, the side of the diff that the pull request's changes appear on. Can be `LEFT` or `RIGHT`. Use `LEFT` for deletions that appear in red. Use `RIGHT` for additions that appear in green or unchanged lines that appear in white and are shown for context. For a multi-line comment, side represents whether the last line of the comment range is a deletion or addition. For more information, see "[Diff view options](https://help.github.com/en/articles/about-comparing-branches-in-pull-requests#diff-view-options)" in the GitHub Help documentation.
     */
    side?: "LEFT" | "RIGHT";
    /**
     * **Required when using multi-line comments**. To create multi-line comments, you must use the `comfort-fade` preview header. The `start_line` is the first line in the pull request diff that your multi-line comment applies to. To learn more about multi-line comments, see "[Commenting on a pull request](https://help.github.com/en/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)" in the GitHub Help documentation.
     */
    start_line?: number;
    /**
     * **Required when using multi-line comments**. To create multi-line comments, you must use the `comfort-fade` preview header. The `start_side` is the starting side of the diff that the comment applies to. Can be `LEFT` or `RIGHT`. To learn more about multi-line comments, see "[Commenting on a pull request](https://help.github.com/en/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)" in the GitHub Help documentation. See `side` in this table for additional context.
     */
    start_side?: "LEFT" | "RIGHT" | "side";
};
export declare type PullsCreateCommentParams = {
    /**
     * The text of the review comment.
     */
    body: string;
    /**
     * The SHA of the commit needing a comment. Not using the latest commit SHA may render your comment outdated if a subsequent commit modifies the line you specify as the `position`.
     */
    commit_id: string;
    /**
     * **Required with `comfort-fade` preview**. The line of the blob in the pull request diff that the comment applies to. For a multi-line comment, the last line of the range that your comment applies to.
     */
    line?: number;
    owner: string;
    /**
     * The relative path to the file that necessitates a comment.
     */
    path: string;
    /**
     * **Required without `comfort-fade` preview**. The position in the diff where you want to add a review comment. Note this value is not the same as the line number in the file. For help finding the position value, read the note above.
     */
    position?: number;
    pull_number: number;
    repo: string;
    /**
     * **Required with `comfort-fade` preview**. In a split diff view, the side of the diff that the pull request's changes appear on. Can be `LEFT` or `RIGHT`. Use `LEFT` for deletions that appear in red. Use `RIGHT` for additions that appear in green or unchanged lines that appear in white and are shown for context. For a multi-line comment, side represents whether the last line of the comment range is a deletion or addition. For more information, see "[Diff view options](https://help.github.com/en/articles/about-comparing-branches-in-pull-requests#diff-view-options)" in the GitHub Help documentation.
     */
    side?: "LEFT" | "RIGHT";
    /**
     * **Required when using multi-line comments**. To create multi-line comments, you must use the `comfort-fade` preview header. The `start_line` is the first line in the pull request diff that your multi-line comment applies to. To learn more about multi-line comments, see "[Commenting on a pull request](https://help.github.com/en/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)" in the GitHub Help documentation.
     */
    start_line?: number;
    /**
     * **Required when using multi-line comments**. To create multi-line comments, you must use the `comfort-fade` preview header. The `start_side` is the starting side of the diff that the comment applies to. Can be `LEFT` or `RIGHT`. To learn more about multi-line comments, see "[Commenting on a pull request](https://help.github.com/en/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)" in the GitHub Help documentation. See `side` in this table for additional context.
     */
    start_side?: "LEFT" | "RIGHT" | "side";
};
export declare type PullsCreateCommentReplyParamsDeprecatedNumber = {
    /**
     * The text of the review comment.
     */
    body: string;
    /**
     * The SHA of the commit needing a comment. Not using the latest commit SHA may render your comment outdated if a subsequent commit modifies the line you specify as the `position`.
     */
    commit_id: string;
    /**
     * **Required with `comfort-fade` preview**. The line of the blob in the pull request diff that the comment applies to. For a multi-line comment, the last line of the range that your comment applies to.
     */
    line?: number;
    /**
     * @deprecated "number" parameter renamed to "pull_number"
     */
    number: number;
    owner: string;
    /**
     * The relative path to the file that necessitates a comment.
     */
    path: string;
    /**
     * **Required without `comfort-fade` preview**. The position in the diff where you want to add a review comment. Note this value is not the same as the line number in the file. For help finding the position value, read the note above.
     */
    position?: number;
    repo: string;
    /**
     * **Required with `comfort-fade` preview**. In a split diff view, the side of the diff that the pull request's changes appear on. Can be `LEFT` or `RIGHT`. Use `LEFT` for deletions that appear in red. Use `RIGHT` for additions that appear in green or unchanged lines that appear in white and are shown for context. For a multi-line comment, side represents whether the last line of the comment range is a deletion or addition. For more information, see "[Diff view options](https://help.github.com/en/articles/about-comparing-branches-in-pull-requests#diff-view-options)" in the GitHub Help documentation.
     */
    side?: "LEFT" | "RIGHT";
    /**
     * **Required when using multi-line comments**. To create multi-line comments, you must use the `comfort-fade` preview header. The `start_line` is the first line in the pull request diff that your multi-line comment applies to. To learn more about multi-line comments, see "[Commenting on a pull request](https://help.github.com/en/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)" in the GitHub Help documentation.
     */
    start_line?: number;
    /**
     * **Required when using multi-line comments**. To create multi-line comments, you must use the `comfort-fade` preview header. The `start_side` is the starting side of the diff that the comment applies to. Can be `LEFT` or `RIGHT`. To learn more about multi-line comments, see "[Commenting on a pull request](https://help.github.com/en/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)" in the GitHub Help documentation. See `side` in this table for additional context.
     */
    start_side?: "LEFT" | "RIGHT" | "side";
};
export declare type PullsCreateCommentReplyParamsDeprecatedInReplyTo = {
    /**
     * The text of the review comment.
     */
    body: string;
    /**
     * The SHA of the commit needing a comment. Not using the latest commit SHA may render your comment outdated if a subsequent commit modifies the line you specify as the `position`.
     */
    commit_id: string;
    /**
     * The comment ID to reply to. **Note**: This must be the ID of a top-level comment, not a reply to that comment. Replies to replies are not supported.
     * @deprecated "in_reply_to" parameter has been deprecated and will be removed in future
     */
    in_reply_to?: number;
    /**
     * **Required with `comfort-fade` preview**. The line of the blob in the pull request diff that the comment applies to. For a multi-line comment, the last line of the range that your comment applies to.
     */
    line?: number;
    owner: string;
    /**
     * The relative path to the file that necessitates a comment.
     */
    path: string;
    /**
     * **Required without `comfort-fade` preview**. The position in the diff where you want to add a review comment. Note this value is not the same as the line number in the file. For help finding the position value, read the note above.
     */
    position?: number;
    pull_number: number;
    repo: string;
    /**
     * **Required with `comfort-fade` preview**. In a split diff view, the side of the diff that the pull request's changes appear on. Can be `LEFT` or `RIGHT`. Use `LEFT` for deletions that appear in red. Use `RIGHT` for additions that appear in green or unchanged lines that appear in white and are shown for context. For a multi-line comment, side represents whether the last line of the comment range is a deletion or addition. For more information, see "[Diff view options](https://help.github.com/en/articles/about-comparing-branches-in-pull-requests#diff-view-options)" in the GitHub Help documentation.
     */
    side?: "LEFT" | "RIGHT";
    /**
     * **Required when using multi-line comments**. To create multi-line comments, you must use the `comfort-fade` preview header. The `start_line` is the first line in the pull request diff that your multi-line comment applies to. To learn more about multi-line comments, see "[Commenting on a pull request](https://help.github.com/en/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)" in the GitHub Help documentation.
     */
    start_line?: number;
    /**
     * **Required when using multi-line comments**. To create multi-line comments, you must use the `comfort-fade` preview header. The `start_side` is the starting side of the diff that the comment applies to. Can be `LEFT` or `RIGHT`. To learn more about multi-line comments, see "[Commenting on a pull request](https://help.github.com/en/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)" in the GitHub Help documentation. See `side` in this table for additional context.
     */
    start_side?: "LEFT" | "RIGHT" | "side";
};
export declare type PullsCreateCommentReplyParams = {
    /**
     * The text of the review comment.
     */
    body: string;
    /**
     * The SHA of the commit needing a comment. Not using the latest commit SHA may render your comment outdated if a subsequent commit modifies the line you specify as the `position`.
     */
    commit_id: string;
    /**
     * **Required with `comfort-fade` preview**. The line of the blob in the pull request diff that the comment applies to. For a multi-line comment, the last line of the range that your comment applies to.
     */
    line?: number;
    owner: string;
    /**
     * The relative path to the file that necessitates a comment.
     */
    path: string;
    /**
     * **Required without `comfort-fade` preview**. The position in the diff where you want to add a review comment. Note this value is not the same as the line number in the file. For help finding the position value, read the note above.
     */
    position?: number;
    pull_number: number;
    repo: string;
    /**
     * **Required with `comfort-fade` preview**. In a split diff view, the side of the diff that the pull request's changes appear on. Can be `LEFT` or `RIGHT`. Use `LEFT` for deletions that appear in red. Use `RIGHT` for additions that appear in green or unchanged lines that appear in white and are shown for context. For a multi-line comment, side represents whether the last line of the comment range is a deletion or addition. For more information, see "[Diff view options](https://help.github.com/en/articles/about-comparing-branches-in-pull-requests#diff-view-options)" in the GitHub Help documentation.
     */
    side?: "LEFT" | "RIGHT";
    /**
     * **Required when using multi-line comments**. To create multi-line comments, you must use the `comfort-fade` preview header. The `start_line` is the first line in the pull request diff that your multi-line comment applies to. To learn more about multi-line comments, see "[Commenting on a pull request](https://help.github.com/en/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)" in the GitHub Help documentation.
     */
    start_line?: number;
    /**
     * **Required when using multi-line comments**. To create multi-line comments, you must use the `comfort-fade` preview header. The `start_side` is the starting side of the diff that the comment applies to. Can be `LEFT` or `RIGHT`. To learn more about multi-line comments, see "[Commenting on a pull request](https://help.github.com/en/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)" in the GitHub Help documentation. See `side` in this table for additional context.
     */
    start_side?: "LEFT" | "RIGHT" | "side";
};
export declare type PullsCreateFromIssueParams = {
    base: string;
    draft?: boolean;
    head: string;
    issue: number;
    maintainer_can_modify?: boolean;
    owner: string;
    repo: string;
};
export declare type PullsCreateReviewParamsDeprecatedNumber = {
    /**
     * **Required** when using `REQUEST_CHANGES` or `COMMENT` for the `event` parameter. The body text of the pull request review.
     */
    body?: string;
    /**
     * Use the following table to specify the location, destination, and contents of the draft review comment.
     */
    comments?: PullsCreateReviewParamsComments[];
    /**
     * The SHA of the commit that needs a review. Not using the latest commit SHA may render your review comment outdated if a subsequent commit modifies the line you specify as the `position`. Defaults to the most recent commit in the pull request when you do not specify a value.
     */
    commit_id?: string;
    /**
     * The review action you want to perform. The review actions include: `APPROVE`, `REQUEST_CHANGES`, or `COMMENT`. By leaving this blank, you set the review action state to `PENDING`, which means you will need to [submit the pull request review](https://developer.github.com/v3/pulls/reviews/#submit-a-pull-request-review) when you are ready.
     */
    event?: "APPROVE" | "REQUEST_CHANGES" | "COMMENT";
    /**
     * @deprecated "number" parameter renamed to "pull_number"
     */
    number: number;
    owner: string;
    repo: string;
};
export declare type PullsCreateReviewParams = {
    /**
     * **Required** when using `REQUEST_CHANGES` or `COMMENT` for the `event` parameter. The body text of the pull request review.
     */
    body?: string;
    /**
     * Use the following table to specify the location, destination, and contents of the draft review comment.
     */
    comments?: PullsCreateReviewParamsComments[];
    /**
     * The SHA of the commit that needs a review. Not using the latest commit SHA may render your review comment outdated if a subsequent commit modifies the line you specify as the `position`. Defaults to the most recent commit in the pull request when you do not specify a value.
     */
    commit_id?: string;
    /**
     * The review action you want to perform. The review actions include: `APPROVE`, `REQUEST_CHANGES`, or `COMMENT`. By leaving this blank, you set the review action state to `PENDING`, which means you will need to [submit the pull request review](https://developer.github.com/v3/pulls/reviews/#submit-a-pull-request-review) when you are ready.
     */
    event?: "APPROVE" | "REQUEST_CHANGES" | "COMMENT";
    owner: string;
    pull_number: number;
    repo: string;
};
export declare type PullsCreateReviewCommentReplyParams = {
    /**
     * The text of the review comment.
     */
    body: string;
    comment_id: number;
    owner: string;
    pull_number: number;
    repo: string;
};
export declare type PullsCreateReviewRequestParamsDeprecatedNumber = {
    /**
     * @deprecated "number" parameter renamed to "pull_number"
     */
    number: number;
    owner: string;
    repo: string;
    /**
     * An array of user `login`s that will be requested.
     */
    reviewers?: string[];
    /**
     * An array of team `slug`s that will be requested.
     */
    team_reviewers?: string[];
};
export declare type PullsCreateReviewRequestParams = {
    owner: string;
    pull_number: number;
    repo: string;
    /**
     * An array of user `login`s that will be requested.
     */
    reviewers?: string[];
    /**
     * An array of team `slug`s that will be requested.
     */
    team_reviewers?: string[];
};
export declare type PullsDeleteCommentParams = {
    comment_id: number;
    owner: string;
    repo: string;
};
export declare type PullsDeletePendingReviewParamsDeprecatedNumber = {
    /**
     * @deprecated "number" parameter renamed to "pull_number"
     */
    number: number;
    owner: string;
    repo: string;
    review_id: number;
};
export declare type PullsDeletePendingReviewParams = {
    owner: string;
    pull_number: number;
    repo: string;
    review_id: number;
};
export declare type PullsDeleteReviewRequestParamsDeprecatedNumber = {
    /**
     * @deprecated "number" parameter renamed to "pull_number"
     */
    number: number;
    owner: string;
    repo: string;
    /**
     * An array of user `login`s that will be removed.
     */
    reviewers?: string[];
    /**
     * An array of team `slug`s that will be removed.
     */
    team_reviewers?: string[];
};
export declare type PullsDeleteReviewRequestParams = {
    owner: string;
    pull_number: number;
    repo: string;
    /**
     * An array of user `login`s that will be removed.
     */
    reviewers?: string[];
    /**
     * An array of team `slug`s that will be removed.
     */
    team_reviewers?: string[];
};
export declare type PullsDismissReviewParamsDeprecatedNumber = {
    /**
     * The message for the pull request review dismissal
     */
    message: string;
    /**
     * @deprecated "number" parameter renamed to "pull_number"
     */
    number: number;
    owner: string;
    repo: string;
    review_id: number;
};
export declare type PullsDismissReviewParams = {
    /**
     * The message for the pull request review dismissal
     */
    message: string;
    owner: string;
    pull_number: number;
    repo: string;
    review_id: number;
};
export declare type PullsGetParamsDeprecatedNumber = {
    /**
     * @deprecated "number" parameter renamed to "pull_number"
     */
    number: number;
    owner: string;
    repo: string;
};
export declare type PullsGetParams = {
    owner: string;
    pull_number: number;
    repo: string;
};
export declare type PullsGetCommentParams = {
    comment_id: number;
    owner: string;
    repo: string;
};
export declare type PullsGetCommentsForReviewParamsDeprecatedNumber = {
    /**
     * @deprecated "number" parameter renamed to "pull_number"
     */
    number: number;
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
    review_id: number;
};
export declare type PullsGetCommentsForReviewParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    pull_number: number;
    repo: string;
    review_id: number;
};
export declare type PullsGetReviewParamsDeprecatedNumber = {
    /**
     * @deprecated "number" parameter renamed to "pull_number"
     */
    number: number;
    owner: string;
    repo: string;
    review_id: number;
};
export declare type PullsGetReviewParams = {
    owner: string;
    pull_number: number;
    repo: string;
    review_id: number;
};
export declare type PullsListParams = {
    /**
     * Filter pulls by base branch name. Example: `gh-pages`.
     */
    base?: string;
    /**
     * The direction of the sort. Can be either `asc` or `desc`. Default: `desc` when sort is `created` or sort is not specified, otherwise `asc`.
     */
    direction?: "asc" | "desc";
    /**
     * Filter pulls by head user or head organization and branch name in the format of `user:ref-name` or `organization:ref-name`. For example: `github:new-script-format` or `octocat:test-branch`.
     */
    head?: string;
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
    /**
     * What to sort results by. Can be either `created`, `updated`, `popularity` (comment count) or `long-running` (age, filtering by pulls updated in the last month).
     */
    sort?: "created" | "updated" | "popularity" | "long-running";
    /**
     * Either `open`, `closed`, or `all` to filter by state.
     */
    state?: "open" | "closed" | "all";
};
export declare type PullsListCommentsParamsDeprecatedNumber = {
    /**
     * Can be either `asc` or `desc`. Ignored without `sort` parameter.
     */
    direction?: "asc" | "desc";
    /**
     * @deprecated "number" parameter renamed to "pull_number"
     */
    number: number;
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
    /**
     * This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Only returns comments `updated` at or after this time.
     */
    since?: string;
    /**
     * Can be either `created` or `updated` comments.
     */
    sort?: "created" | "updated";
};
export declare type PullsListCommentsParams = {
    /**
     * Can be either `asc` or `desc`. Ignored without `sort` parameter.
     */
    direction?: "asc" | "desc";
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    pull_number: number;
    repo: string;
    /**
     * This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Only returns comments `updated` at or after this time.
     */
    since?: string;
    /**
     * Can be either `created` or `updated` comments.
     */
    sort?: "created" | "updated";
};
export declare type PullsListCommentsForRepoParams = {
    /**
     * Can be either `asc` or `desc`. Ignored without `sort` parameter.
     */
    direction?: "asc" | "desc";
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
    /**
     * This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Only returns comments `updated` at or after this time.
     */
    since?: string;
    /**
     * Can be either `created` or `updated` comments.
     */
    sort?: "created" | "updated";
};
export declare type PullsListCommitsParamsDeprecatedNumber = {
    /**
     * @deprecated "number" parameter renamed to "pull_number"
     */
    number: number;
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
};
export declare type PullsListCommitsParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    pull_number: number;
    repo: string;
};
export declare type PullsListFilesParamsDeprecatedNumber = {
    /**
     * @deprecated "number" parameter renamed to "pull_number"
     */
    number: number;
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
};
export declare type PullsListFilesParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    pull_number: number;
    repo: string;
};
export declare type PullsListReviewRequestsParamsDeprecatedNumber = {
    /**
     * @deprecated "number" parameter renamed to "pull_number"
     */
    number: number;
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
};
export declare type PullsListReviewRequestsParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    pull_number: number;
    repo: string;
};
export declare type PullsListReviewsParamsDeprecatedNumber = {
    /**
     * @deprecated "number" parameter renamed to "pull_number"
     */
    number: number;
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
};
export declare type PullsListReviewsParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    pull_number: number;
    repo: string;
};
export declare type PullsMergeParamsDeprecatedNumber = {
    /**
     * Extra detail to append to automatic commit message.
     */
    commit_message?: string;
    /**
     * Title for the automatic commit message.
     */
    commit_title?: string;
    /**
     * Merge method to use. Possible values are `merge`, `squash` or `rebase`. Default is `merge`.
     */
    merge_method?: "merge" | "squash" | "rebase";
    /**
     * @deprecated "number" parameter renamed to "pull_number"
     */
    number: number;
    owner: string;
    repo: string;
    /**
     * SHA that pull request head must match to allow merge.
     */
    sha?: string;
};
export declare type PullsMergeParams = {
    /**
     * Extra detail to append to automatic commit message.
     */
    commit_message?: string;
    /**
     * Title for the automatic commit message.
     */
    commit_title?: string;
    /**
     * Merge method to use. Possible values are `merge`, `squash` or `rebase`. Default is `merge`.
     */
    merge_method?: "merge" | "squash" | "rebase";
    owner: string;
    pull_number: number;
    repo: string;
    /**
     * SHA that pull request head must match to allow merge.
     */
    sha?: string;
};
export declare type PullsSubmitReviewParamsDeprecatedNumber = {
    /**
     * The body text of the pull request review
     */
    body?: string;
    /**
     * The review action you want to perform. The review actions include: `APPROVE`, `REQUEST_CHANGES`, or `COMMENT`. When you leave this blank, the API returns _HTTP 422 (Unrecognizable entity)_ and sets the review action state to `PENDING`, which means you will need to re-submit the pull request review using a review action.
     */
    event: "APPROVE" | "REQUEST_CHANGES" | "COMMENT";
    /**
     * @deprecated "number" parameter renamed to "pull_number"
     */
    number: number;
    owner: string;
    repo: string;
    review_id: number;
};
export declare type PullsSubmitReviewParams = {
    /**
     * The body text of the pull request review
     */
    body?: string;
    /**
     * The review action you want to perform. The review actions include: `APPROVE`, `REQUEST_CHANGES`, or `COMMENT`. When you leave this blank, the API returns _HTTP 422 (Unrecognizable entity)_ and sets the review action state to `PENDING`, which means you will need to re-submit the pull request review using a review action.
     */
    event: "APPROVE" | "REQUEST_CHANGES" | "COMMENT";
    owner: string;
    pull_number: number;
    repo: string;
    review_id: number;
};
export declare type PullsUpdateParamsDeprecatedNumber = {
    /**
     * The name of the branch you want your changes pulled into. This should be an existing branch on the current repository. You cannot update the base branch on a pull request to point to another repository.
     */
    base?: string;
    /**
     * The contents of the pull request.
     */
    body?: string;
    /**
     * Indicates whether [maintainers can modify](https://help.github.com/articles/allowing-changes-to-a-pull-request-branch-created-from-a-fork/) the pull request.
     */
    maintainer_can_modify?: boolean;
    /**
     * @deprecated "number" parameter renamed to "pull_number"
     */
    number: number;
    owner: string;
    repo: string;
    /**
     * State of this Pull Request. Either `open` or `closed`.
     */
    state?: "open" | "closed";
    /**
     * The title of the pull request.
     */
    title?: string;
};
export declare type PullsUpdateParams = {
    /**
     * The name of the branch you want your changes pulled into. This should be an existing branch on the current repository. You cannot update the base branch on a pull request to point to another repository.
     */
    base?: string;
    /**
     * The contents of the pull request.
     */
    body?: string;
    /**
     * Indicates whether [maintainers can modify](https://help.github.com/articles/allowing-changes-to-a-pull-request-branch-created-from-a-fork/) the pull request.
     */
    maintainer_can_modify?: boolean;
    owner: string;
    pull_number: number;
    repo: string;
    /**
     * State of this Pull Request. Either `open` or `closed`.
     */
    state?: "open" | "closed";
    /**
     * The title of the pull request.
     */
    title?: string;
};
export declare type PullsUpdateBranchParams = {
    /**
     * The expected SHA of the pull request's HEAD ref. This is the most recent commit on the pull request's branch. If the expected SHA does not match the pull request's HEAD, you will receive a `422 Unprocessable Entity` status. You can use the "[List commits on a repository](https://developer.github.com/v3/repos/commits/#list-commits-on-a-repository)" endpoint to find the most recent commit SHA. Default: SHA of the pull request's current HEAD ref.
     */
    expected_head_sha?: string;
    owner: string;
    pull_number: number;
    repo: string;
};
export declare type PullsUpdateCommentParams = {
    /**
     * The text of the reply to the review comment.
     */
    body: string;
    comment_id: number;
    owner: string;
    repo: string;
};
export declare type PullsUpdateReviewParamsDeprecatedNumber = {
    /**
     * The body text of the pull request review.
     */
    body: string;
    /**
     * @deprecated "number" parameter renamed to "pull_number"
     */
    number: number;
    owner: string;
    repo: string;
    review_id: number;
};
export declare type PullsUpdateReviewParams = {
    /**
     * The body text of the pull request review.
     */
    body: string;
    owner: string;
    pull_number: number;
    repo: string;
    review_id: number;
};
export declare type ReactionsCreateForCommitCommentParams = {
    comment_id: number;
    /**
     * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the commit comment.
     */
    content: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
    owner: string;
    repo: string;
};
export declare type ReactionsCreateForIssueParamsDeprecatedNumber = {
    /**
     * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the issue.
     */
    content: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
    /**
     * @deprecated "number" parameter renamed to "issue_number"
     */
    number: number;
    owner: string;
    repo: string;
};
export declare type ReactionsCreateForIssueParams = {
    /**
     * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the issue.
     */
    content: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
    issue_number: number;
    owner: string;
    repo: string;
};
export declare type ReactionsCreateForIssueCommentParams = {
    comment_id: number;
    /**
     * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the issue comment.
     */
    content: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
    owner: string;
    repo: string;
};
export declare type ReactionsCreateForPullRequestReviewCommentParams = {
    comment_id: number;
    /**
     * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the pull request review comment.
     */
    content: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
    owner: string;
    repo: string;
};
export declare type ReactionsCreateForTeamDiscussionParams = {
    /**
     * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the team discussion.
     */
    content: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
    discussion_number: number;
    team_id: number;
};
export declare type ReactionsCreateForTeamDiscussionCommentParams = {
    comment_number: number;
    /**
     * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the team discussion comment.
     */
    content: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
    discussion_number: number;
    team_id: number;
};
export declare type ReactionsCreateForTeamDiscussionCommentInOrgParams = {
    comment_number: number;
    /**
     * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the team discussion comment.
     */
    content: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
    discussion_number: number;
    org: string;
    team_slug: string;
};
export declare type ReactionsCreateForTeamDiscussionCommentLegacyParams = {
    comment_number: number;
    /**
     * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the team discussion comment.
     */
    content: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
    discussion_number: number;
    team_id: number;
};
export declare type ReactionsCreateForTeamDiscussionInOrgParams = {
    /**
     * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the team discussion.
     */
    content: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
    discussion_number: number;
    org: string;
    team_slug: string;
};
export declare type ReactionsCreateForTeamDiscussionLegacyParams = {
    /**
     * The [reaction type](https://developer.github.com/v3/reactions/#reaction-types) to add to the team discussion.
     */
    content: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
    discussion_number: number;
    team_id: number;
};
export declare type ReactionsDeleteParams = {
    reaction_id: number;
};
export declare type ReactionsListForCommitCommentParams = {
    comment_id: number;
    /**
     * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to a commit comment.
     */
    content?: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
};
export declare type ReactionsListForIssueParamsDeprecatedNumber = {
    /**
     * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to an issue.
     */
    content?: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
    /**
     * @deprecated "number" parameter renamed to "issue_number"
     */
    number: number;
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
};
export declare type ReactionsListForIssueParams = {
    /**
     * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to an issue.
     */
    content?: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
    issue_number: number;
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
};
export declare type ReactionsListForIssueCommentParams = {
    comment_id: number;
    /**
     * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to an issue comment.
     */
    content?: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
};
export declare type ReactionsListForPullRequestReviewCommentParams = {
    comment_id: number;
    /**
     * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to a pull request review comment.
     */
    content?: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
};
export declare type ReactionsListForTeamDiscussionParams = {
    /**
     * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to a team discussion.
     */
    content?: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
    discussion_number: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    team_id: number;
};
export declare type ReactionsListForTeamDiscussionCommentParams = {
    comment_number: number;
    /**
     * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to a team discussion comment.
     */
    content?: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
    discussion_number: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    team_id: number;
};
export declare type ReactionsListForTeamDiscussionCommentInOrgParams = {
    comment_number: number;
    /**
     * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to a team discussion comment.
     */
    content?: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
    discussion_number: number;
    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    team_slug: string;
};
export declare type ReactionsListForTeamDiscussionCommentLegacyParams = {
    comment_number: number;
    /**
     * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to a team discussion comment.
     */
    content?: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
    discussion_number: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    team_id: number;
};
export declare type ReactionsListForTeamDiscussionInOrgParams = {
    /**
     * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to a team discussion.
     */
    content?: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
    discussion_number: number;
    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    team_slug: string;
};
export declare type ReactionsListForTeamDiscussionLegacyParams = {
    /**
     * Returns a single [reaction type](https://developer.github.com/v3/reactions/#reaction-types). Omit this parameter to list all reactions to a team discussion.
     */
    content?: "+1" | "-1" | "laugh" | "confused" | "heart" | "hooray" | "rocket" | "eyes";
    discussion_number: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    team_id: number;
};
export declare type ReposAcceptInvitationParams = {
    invitation_id: number;
};
export declare type ReposAddCollaboratorParams = {
    owner: string;
    /**
     * The permission to grant the collaborator. **Only valid on organization-owned repositories.** Can be one of:
     * \* `pull` - can pull, but not push to or administer this repository.
     * \* `push` - can pull and push, but not administer this repository.
     * \* `admin` - can pull, push and administer this repository.
     */
    permission?: "pull" | "push" | "admin";
    repo: string;
    username: string;
};
export declare type ReposAddDeployKeyParams = {
    /**
     * The contents of the key.
     */
    key: string;
    owner: string;
    /**
     * If `true`, the key will only be able to read repository contents. Otherwise, the key will be able to read and write.
     *
     * Deploy keys with write access can perform the same actions as an organization member with admin access, or a collaborator on a personal repository. For more information, see "[Repository permission levels for an organization](https://help.github.com/articles/repository-permission-levels-for-an-organization/)" and "[Permission levels for a user account repository](https://help.github.com/articles/permission-levels-for-a-user-account-repository/)."
     */
    read_only?: boolean;
    repo: string;
    /**
     * A name for the key.
     */
    title?: string;
};
export declare type ReposAddProtectedBranchAdminEnforcementParams = {
    branch: string;
    owner: string;
    repo: string;
};
export declare type ReposAddProtectedBranchAppRestrictionsParams = {
    apps: string[];
    branch: string;
    owner: string;
    repo: string;
};
export declare type ReposAddProtectedBranchRequiredSignaturesParams = {
    branch: string;
    owner: string;
    repo: string;
};
export declare type ReposAddProtectedBranchRequiredStatusChecksContextsParams = {
    branch: string;
    contexts: string[];
    owner: string;
    repo: string;
};
export declare type ReposAddProtectedBranchTeamRestrictionsParams = {
    branch: string;
    owner: string;
    repo: string;
    teams: string[];
};
export declare type ReposAddProtectedBranchUserRestrictionsParams = {
    branch: string;
    owner: string;
    repo: string;
    users: string[];
};
export declare type ReposCheckCollaboratorParams = {
    owner: string;
    repo: string;
    username: string;
};
export declare type ReposCheckVulnerabilityAlertsParams = {
    owner: string;
    repo: string;
};
export declare type ReposCompareCommitsParams = {
    base: string;
    head: string;
    owner: string;
    repo: string;
};
export declare type ReposCreateCommitCommentParamsDeprecatedSha = {
    /**
     * The contents of the comment.
     */
    body: string;
    owner: string;
    /**
     * Relative path of the file to comment on.
     */
    path?: string;
    /**
     * Line index in the diff to comment on.
     */
    position?: number;
    repo: string;
    /**
     * @deprecated "sha" parameter renamed to "commit_sha"
     */
    sha: string;
};
export declare type ReposCreateCommitCommentParamsDeprecatedLine = {
    /**
     * The contents of the comment.
     */
    body: string;
    commit_sha: string;
    /**
     * **Deprecated**. Use **position** parameter instead. Line number in the file to comment on.
     * @deprecated "line" parameter has been deprecated and will be removed in future
     */
    line?: number;
    owner: string;
    /**
     * Relative path of the file to comment on.
     */
    path?: string;
    /**
     * Line index in the diff to comment on.
     */
    position?: number;
    repo: string;
};
export declare type ReposCreateCommitCommentParams = {
    /**
     * The contents of the comment.
     */
    body: string;
    commit_sha: string;
    owner: string;
    /**
     * Relative path of the file to comment on.
     */
    path?: string;
    /**
     * Line index in the diff to comment on.
     */
    position?: number;
    repo: string;
};
export declare type ReposCreateDeploymentParams = {
    /**
     * Attempts to automatically merge the default branch into the requested ref, if it's behind the default branch.
     */
    auto_merge?: boolean;
    /**
     * Short description of the deployment.
     */
    description?: string;
    /**
     * Name for the target deployment environment (e.g., `production`, `staging`, `qa`).
     */
    environment?: string;
    owner: string;
    /**
     * JSON payload with extra information about the deployment.
     */
    payload?: string;
    /**
     * Specifies if the given environment is one that end-users directly interact with. Default: `true` when `environment` is `production` and `false` otherwise.
     * **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type.
     */
    production_environment?: boolean;
    /**
     * The ref to deploy. This can be a branch, tag, or SHA.
     */
    ref: string;
    repo: string;
    /**
     * The [status](https://developer.github.com/v3/repos/statuses/) contexts to verify against commit status checks. If you omit this parameter, GitHub verifies all unique contexts before creating a deployment. To bypass checking entirely, pass an empty array. Defaults to all unique contexts.
     */
    required_contexts?: string[];
    /**
     * Specifies a task to execute (e.g., `deploy` or `deploy:migrations`).
     */
    task?: string;
    /**
     * Specifies if the given environment is specific to the deployment and will no longer exist at some point in the future. Default: `false`
     * **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type. **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type.
     */
    transient_environment?: boolean;
};
export declare type ReposCreateDeploymentStatusParams = {
    /**
     * Adds a new `inactive` status to all prior non-transient, non-production environment deployments with the same repository and `environment` name as the created status's deployment. An `inactive` status is only added to deployments that had a `success` state. Default: `true`
     * **Note:** To add an `inactive` status to `production` environments, you must use the [`application/vnd.github.flash-preview+json`](https://developer.github.com/v3/previews/#deployment-statuses) custom media type.
     * **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type.
     */
    auto_inactive?: boolean;
    deployment_id: number;
    /**
     * A short description of the status. The maximum description length is 140 characters.
     */
    description?: string;
    /**
     * Name for the target deployment environment, which can be changed when setting a deploy status. For example, `production`, `staging`, or `qa`. **Note:** This parameter requires you to use the [`application/vnd.github.flash-preview+json`](https://developer.github.com/v3/previews/#deployment-statuses) custom media type.
     */
    environment?: "production" | "staging" | "qa";
    /**
     * Sets the URL for accessing your environment. Default: `""`
     * **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type. **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type.
     */
    environment_url?: string;
    /**
     * The full URL of the deployment's output. This parameter replaces `target_url`. We will continue to accept `target_url` to support legacy uses, but we recommend replacing `target_url` with `log_url`. Setting `log_url` will automatically set `target_url` to the same value. Default: `""`
     * **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type. **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type.
     */
    log_url?: string;
    owner: string;
    repo: string;
    /**
     * The state of the status. Can be one of `error`, `failure`, `inactive`, `in_progress`, `queued` `pending`, or `success`. **Note:** To use the `inactive` state, you must provide the [`application/vnd.github.ant-man-preview+json`](https://developer.github.com/v3/previews/#enhanced-deployments) custom media type. To use the `in_progress` and `queued` states, you must provide the [`application/vnd.github.flash-preview+json`](https://developer.github.com/v3/previews/#deployment-statuses) custom media type.
     */
    state: "error" | "failure" | "inactive" | "in_progress" | "queued" | "pending" | "success";
    /**
     * The target URL to associate with this status. This URL should contain output to keep the user updated while the task is running or serve as historical information for what happened in the deployment. **Note:** It's recommended to use the `log_url` parameter, which replaces `target_url`.
     */
    target_url?: string;
};
export declare type ReposCreateDispatchEventParams = {
    /**
     * JSON payload with extra information about the webhook event that your action or worklow may use.
     */
    client_payload?: ReposCreateDispatchEventParamsClientPayload;
    /**
     * **Required:** A custom webhook event name.
     */
    event_type?: string;
    owner: string;
    repo: string;
};
export declare type ReposCreateFileParams = {
    /**
     * The author of the file. Default: The `committer` or the authenticated user if you omit `committer`.
     */
    author?: ReposCreateFileParamsAuthor;
    /**
     * The branch name. Default: the repository’s default branch (usually `master`)
     */
    branch?: string;
    /**
     * The person that committed the file. Default: the authenticated user.
     */
    committer?: ReposCreateFileParamsCommitter;
    /**
     * The new file content, using Base64 encoding.
     */
    content: string;
    /**
     * The commit message.
     */
    message: string;
    owner: string;
    path: string;
    repo: string;
    /**
     * **Required if you are updating a file**. The blob SHA of the file being replaced.
     */
    sha?: string;
};
export declare type ReposCreateForAuthenticatedUserParams = {
    /**
     * Either `true` to allow merging pull requests with a merge commit, or `false` to prevent merging pull requests with merge commits.
     */
    allow_merge_commit?: boolean;
    /**
     * Either `true` to allow rebase-merging pull requests, or `false` to prevent rebase-merging.
     */
    allow_rebase_merge?: boolean;
    /**
     * Either `true` to allow squash-merging pull requests, or `false` to prevent squash-merging.
     */
    allow_squash_merge?: boolean;
    /**
     * Pass `true` to create an initial commit with empty README.
     */
    auto_init?: boolean;
    /**
     * Either `true` to allow automatically deleting head branches when pull requests are merged, or `false` to prevent automatic deletion.
     */
    delete_branch_on_merge?: boolean;
    /**
     * A short description of the repository.
     */
    description?: string;
    /**
     * Desired language or platform [.gitignore template](https://github.com/github/gitignore) to apply. Use the name of the template without the extension. For example, "Haskell".
     */
    gitignore_template?: string;
    /**
     * Either `true` to enable issues for this repository or `false` to disable them.
     */
    has_issues?: boolean;
    /**
     * Either `true` to enable projects for this repository or `false` to disable them. **Note:** If you're creating a repository in an organization that has disabled repository projects, the default is `false`, and if you pass `true`, the API returns an error.
     */
    has_projects?: boolean;
    /**
     * Either `true` to enable the wiki for this repository or `false` to disable it.
     */
    has_wiki?: boolean;
    /**
     * A URL with more information about the repository.
     */
    homepage?: string;
    /**
     * Either `true` to make this repo available as a template repository or `false` to prevent it.
     */
    is_template?: boolean;
    /**
     * Choose an [open source license template](https://choosealicense.com/) that best suits your needs, and then use the [license keyword](https://help.github.com/articles/licensing-a-repository/#searching-github-by-license-type) as the `license_template` string. For example, "mit" or "mpl-2.0".
     */
    license_template?: string;
    /**
     * The name of the repository.
     */
    name: string;
    /**
     * Either `true` to create a private repository or `false` to create a public one. Creating private repositories requires a paid GitHub account.
     */
    private?: boolean;
    /**
     * The id of the team that will be granted access to this repository. This is only valid when creating a repository in an organization.
     */
    team_id?: number;
    /**
     * Can be `public` or `private`. If your organization is associated with an enterprise account using GitHub Enterprise Cloud, `visibility` can also be `internal`. For more information, see "[Creating an internal repository](https://help.github.com/github/creating-cloning-and-archiving-repositories/creating-an-internal-repository)" in the GitHub Help documentation.
     * The `visibility` parameter overrides the `private` parameter when you use both parameters with the `nebula-preview` preview header.
     */
    visibility?: "public" | "private" | "visibility" | "internal";
};
export declare type ReposCreateForkParams = {
    /**
     * Optional parameter to specify the organization name if forking into an organization.
     */
    organization?: string;
    owner: string;
    repo: string;
};
export declare type ReposCreateHookParams = {
    /**
     * Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.
     */
    active?: boolean;
    /**
     * Key/value pairs to provide settings for this webhook. [These are defined below](https://developer.github.com/v3/repos/hooks/#create-hook-config-params).
     */
    config: ReposCreateHookParamsConfig;
    /**
     * Determines what [events](https://developer.github.com/v3/activity/events/types/) the hook is triggered for.
     */
    events?: string[];
    /**
     * Use `web` to create a webhook. Default: `web`. This parameter only accepts the value `web`.
     */
    name?: string;
    owner: string;
    repo: string;
};
export declare type ReposCreateInOrgParams = {
    /**
     * Either `true` to allow merging pull requests with a merge commit, or `false` to prevent merging pull requests with merge commits.
     */
    allow_merge_commit?: boolean;
    /**
     * Either `true` to allow rebase-merging pull requests, or `false` to prevent rebase-merging.
     */
    allow_rebase_merge?: boolean;
    /**
     * Either `true` to allow squash-merging pull requests, or `false` to prevent squash-merging.
     */
    allow_squash_merge?: boolean;
    /**
     * Pass `true` to create an initial commit with empty README.
     */
    auto_init?: boolean;
    /**
     * Either `true` to allow automatically deleting head branches when pull requests are merged, or `false` to prevent automatic deletion.
     */
    delete_branch_on_merge?: boolean;
    /**
     * A short description of the repository.
     */
    description?: string;
    /**
     * Desired language or platform [.gitignore template](https://github.com/github/gitignore) to apply. Use the name of the template without the extension. For example, "Haskell".
     */
    gitignore_template?: string;
    /**
     * Either `true` to enable issues for this repository or `false` to disable them.
     */
    has_issues?: boolean;
    /**
     * Either `true` to enable projects for this repository or `false` to disable them. **Note:** If you're creating a repository in an organization that has disabled repository projects, the default is `false`, and if you pass `true`, the API returns an error.
     */
    has_projects?: boolean;
    /**
     * Either `true` to enable the wiki for this repository or `false` to disable it.
     */
    has_wiki?: boolean;
    /**
     * A URL with more information about the repository.
     */
    homepage?: string;
    /**
     * Either `true` to make this repo available as a template repository or `false` to prevent it.
     */
    is_template?: boolean;
    /**
     * Choose an [open source license template](https://choosealicense.com/) that best suits your needs, and then use the [license keyword](https://help.github.com/articles/licensing-a-repository/#searching-github-by-license-type) as the `license_template` string. For example, "mit" or "mpl-2.0".
     */
    license_template?: string;
    /**
     * The name of the repository.
     */
    name: string;
    org: string;
    /**
     * Either `true` to create a private repository or `false` to create a public one. Creating private repositories requires a paid GitHub account.
     */
    private?: boolean;
    /**
     * The id of the team that will be granted access to this repository. This is only valid when creating a repository in an organization.
     */
    team_id?: number;
    /**
     * Can be `public` or `private`. If your organization is associated with an enterprise account using GitHub Enterprise Cloud, `visibility` can also be `internal`. For more information, see "[Creating an internal repository](https://help.github.com/github/creating-cloning-and-archiving-repositories/creating-an-internal-repository)" in the GitHub Help documentation.
     * The `visibility` parameter overrides the `private` parameter when you use both parameters with the `nebula-preview` preview header.
     */
    visibility?: "public" | "private" | "visibility" | "internal";
};
export declare type ReposCreateOrUpdateFileParams = {
    /**
     * The author of the file. Default: The `committer` or the authenticated user if you omit `committer`.
     */
    author?: ReposCreateOrUpdateFileParamsAuthor;
    /**
     * The branch name. Default: the repository’s default branch (usually `master`)
     */
    branch?: string;
    /**
     * The person that committed the file. Default: the authenticated user.
     */
    committer?: ReposCreateOrUpdateFileParamsCommitter;
    /**
     * The new file content, using Base64 encoding.
     */
    content: string;
    /**
     * The commit message.
     */
    message: string;
    owner: string;
    path: string;
    repo: string;
    /**
     * **Required if you are updating a file**. The blob SHA of the file being replaced.
     */
    sha?: string;
};
export declare type ReposCreateReleaseParams = {
    /**
     * Text describing the contents of the tag.
     */
    body?: string;
    /**
     * `true` to create a draft (unpublished) release, `false` to create a published one.
     */
    draft?: boolean;
    /**
     * The name of the release.
     */
    name?: string;
    owner: string;
    /**
     * `true` to identify the release as a prerelease. `false` to identify the release as a full release.
     */
    prerelease?: boolean;
    repo: string;
    /**
     * The name of the tag.
     */
    tag_name: string;
    /**
     * Specifies the commitish value that determines where the Git tag is created from. Can be any branch or commit SHA. Unused if the Git tag already exists. Default: the repository's default branch (usually `master`).
     */
    target_commitish?: string;
};
export declare type ReposCreateStatusParams = {
    /**
     * A string label to differentiate this status from the status of other systems.
     */
    context?: string;
    /**
     * A short description of the status.
     */
    description?: string;
    owner: string;
    repo: string;
    sha: string;
    /**
     * The state of the status. Can be one of `error`, `failure`, `pending`, or `success`.
     */
    state: "error" | "failure" | "pending" | "success";
    /**
     * The target URL to associate with this status. This URL will be linked from the GitHub UI to allow users to easily see the source of the status.
     * For example, if your continuous integration system is posting build status, you would want to provide the deep link for the build output for this specific SHA:
     * `http://ci.example.com/user/repo/build/sha`
     */
    target_url?: string;
};
export declare type ReposCreateUsingTemplateParams = {
    /**
     * A short description of the new repository.
     */
    description?: string;
    /**
     * The name of the new repository.
     */
    name: string;
    /**
     * The organization or person who will own the new repository. To create a new repository in an organization, the authenticated user must be a member of the specified organization.
     */
    owner?: string;
    /**
     * Either `true` to create a new private repository or `false` to create a new public one.
     */
    private?: boolean;
    template_owner: string;
    template_repo: string;
};
export declare type ReposDeclineInvitationParams = {
    invitation_id: number;
};
export declare type ReposDeleteParams = {
    owner: string;
    repo: string;
};
export declare type ReposDeleteCommitCommentParams = {
    comment_id: number;
    owner: string;
    repo: string;
};
export declare type ReposDeleteDownloadParams = {
    download_id: number;
    owner: string;
    repo: string;
};
export declare type ReposDeleteFileParams = {
    /**
     * object containing information about the author.
     */
    author?: ReposDeleteFileParamsAuthor;
    /**
     * The branch name. Default: the repository’s default branch (usually `master`)
     */
    branch?: string;
    /**
     * object containing information about the committer.
     */
    committer?: ReposDeleteFileParamsCommitter;
    /**
     * The commit message.
     */
    message: string;
    owner: string;
    path: string;
    repo: string;
    /**
     * The blob SHA of the file being replaced.
     */
    sha: string;
};
export declare type ReposDeleteHookParams = {
    hook_id: number;
    owner: string;
    repo: string;
};
export declare type ReposDeleteInvitationParams = {
    invitation_id: number;
    owner: string;
    repo: string;
};
export declare type ReposDeleteReleaseParams = {
    owner: string;
    release_id: number;
    repo: string;
};
export declare type ReposDeleteReleaseAssetParams = {
    asset_id: number;
    owner: string;
    repo: string;
};
export declare type ReposDisableAutomatedSecurityFixesParams = {
    owner: string;
    repo: string;
};
export declare type ReposDisablePagesSiteParams = {
    owner: string;
    repo: string;
};
export declare type ReposDisableVulnerabilityAlertsParams = {
    owner: string;
    repo: string;
};
export declare type ReposEnableAutomatedSecurityFixesParams = {
    owner: string;
    repo: string;
};
export declare type ReposEnablePagesSiteParams = {
    owner: string;
    repo: string;
    source?: ReposEnablePagesSiteParamsSource;
};
export declare type ReposEnableVulnerabilityAlertsParams = {
    owner: string;
    repo: string;
};
export declare type ReposGetParams = {
    owner: string;
    repo: string;
};
export declare type ReposGetAppsWithAccessToProtectedBranchParams = {
    branch: string;
    owner: string;
    repo: string;
};
export declare type ReposGetArchiveLinkParams = {
    archive_format: string;
    owner: string;
    ref: string;
    repo: string;
};
export declare type ReposGetBranchParams = {
    branch: string;
    owner: string;
    repo: string;
};
export declare type ReposGetBranchProtectionParams = {
    branch: string;
    owner: string;
    repo: string;
};
export declare type ReposGetClonesParams = {
    owner: string;
    /**
     * Must be one of: `day`, `week`.
     */
    per?: "day" | "week";
    repo: string;
};
export declare type ReposGetCodeFrequencyStatsParams = {
    owner: string;
    repo: string;
};
export declare type ReposGetCollaboratorPermissionLevelParams = {
    owner: string;
    repo: string;
    username: string;
};
export declare type ReposGetCombinedStatusForRefParams = {
    owner: string;
    ref: string;
    repo: string;
};
export declare type ReposGetCommitParamsDeprecatedSha = {
    owner: string;
    repo: string;
    /**
     * @deprecated "sha" parameter renamed to "ref"
     */
    sha: string;
};
export declare type ReposGetCommitParamsDeprecatedCommitSha = {
    /**
     * @deprecated "commit_sha" parameter renamed to "ref"
     */
    commit_sha: string;
    owner: string;
    repo: string;
};
export declare type ReposGetCommitParams = {
    owner: string;
    ref: string;
    repo: string;
};
export declare type ReposGetCommitActivityStatsParams = {
    owner: string;
    repo: string;
};
export declare type ReposGetCommitCommentParams = {
    comment_id: number;
    owner: string;
    repo: string;
};
export declare type ReposGetCommitRefShaParams = {
    owner: string;
    ref: string;
    repo: string;
};
export declare type ReposGetContentsParams = {
    owner: string;
    path: string;
    /**
     * The name of the commit/branch/tag. Default: the repository’s default branch (usually `master`)
     */
    ref?: string;
    repo: string;
};
export declare type ReposGetContributorsStatsParams = {
    owner: string;
    repo: string;
};
export declare type ReposGetDeployKeyParams = {
    key_id: number;
    owner: string;
    repo: string;
};
export declare type ReposGetDeploymentParams = {
    deployment_id: number;
    owner: string;
    repo: string;
};
export declare type ReposGetDeploymentStatusParams = {
    deployment_id: number;
    owner: string;
    repo: string;
    status_id: number;
};
export declare type ReposGetDownloadParams = {
    download_id: number;
    owner: string;
    repo: string;
};
export declare type ReposGetHookParams = {
    hook_id: number;
    owner: string;
    repo: string;
};
export declare type ReposGetLatestPagesBuildParams = {
    owner: string;
    repo: string;
};
export declare type ReposGetLatestReleaseParams = {
    owner: string;
    repo: string;
};
export declare type ReposGetPagesParams = {
    owner: string;
    repo: string;
};
export declare type ReposGetPagesBuildParams = {
    build_id: number;
    owner: string;
    repo: string;
};
export declare type ReposGetParticipationStatsParams = {
    owner: string;
    repo: string;
};
export declare type ReposGetProtectedBranchAdminEnforcementParams = {
    branch: string;
    owner: string;
    repo: string;
};
export declare type ReposGetProtectedBranchPullRequestReviewEnforcementParams = {
    branch: string;
    owner: string;
    repo: string;
};
export declare type ReposGetProtectedBranchRequiredSignaturesParams = {
    branch: string;
    owner: string;
    repo: string;
};
export declare type ReposGetProtectedBranchRequiredStatusChecksParams = {
    branch: string;
    owner: string;
    repo: string;
};
export declare type ReposGetProtectedBranchRestrictionsParams = {
    branch: string;
    owner: string;
    repo: string;
};
export declare type ReposGetPunchCardStatsParams = {
    owner: string;
    repo: string;
};
export declare type ReposGetReadmeParams = {
    owner: string;
    /**
     * The name of the commit/branch/tag. Default: the repository’s default branch (usually `master`)
     */
    ref?: string;
    repo: string;
};
export declare type ReposGetReleaseParams = {
    owner: string;
    release_id: number;
    repo: string;
};
export declare type ReposGetReleaseAssetParams = {
    asset_id: number;
    owner: string;
    repo: string;
};
export declare type ReposGetReleaseByTagParams = {
    owner: string;
    repo: string;
    tag: string;
};
export declare type ReposGetTeamsWithAccessToProtectedBranchParams = {
    branch: string;
    owner: string;
    repo: string;
};
export declare type ReposGetTopPathsParams = {
    owner: string;
    repo: string;
};
export declare type ReposGetTopReferrersParams = {
    owner: string;
    repo: string;
};
export declare type ReposGetUsersWithAccessToProtectedBranchParams = {
    branch: string;
    owner: string;
    repo: string;
};
export declare type ReposGetViewsParams = {
    owner: string;
    /**
     * Must be one of: `day`, `week`.
     */
    per?: "day" | "week";
    repo: string;
};
export declare type ReposListParams = {
    /**
     * Comma-separated list of values. Can include:
     * \* `owner`: Repositories that are owned by the authenticated user.
     * \* `collaborator`: Repositories that the user has been added to as a collaborator.
     * \* `organization_member`: Repositories that the user has access to through being a member of an organization. This includes every repository on every team that the user is on.
     */
    affiliation?: string;
    /**
     * Can be one of `asc` or `desc`. Default: `asc` when using `full_name`, otherwise `desc`
     */
    direction?: "asc" | "desc";
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Can be one of `created`, `updated`, `pushed`, `full_name`.
     */
    sort?: "created" | "updated" | "pushed" | "full_name";
    /**
     * Can be one of `all`, `owner`, `public`, `private`, `member`. Default: `all`
     *
     * Will cause a `422` error if used in the same request as **visibility** or **affiliation**. Will cause a `422` error if used in the same request as **visibility** or **affiliation**.
     */
    type?: "all" | "owner" | "public" | "private" | "member";
    /**
     * Can be one of `all`, `public`, or `private`.
     */
    visibility?: "all" | "public" | "private";
};
export declare type ReposListAppsWithAccessToProtectedBranchParams = {
    branch: string;
    owner: string;
    repo: string;
};
export declare type ReposListAssetsForReleaseParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    release_id: number;
    repo: string;
};
export declare type ReposListBranchesParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Setting to `true` returns only protected branches. When set to `false`, only unprotected branches are returned. Omitting this parameter returns all branches.
     */
    protected?: boolean;
    repo: string;
};
export declare type ReposListBranchesForHeadCommitParams = {
    commit_sha: string;
    owner: string;
    repo: string;
};
export declare type ReposListCollaboratorsParams = {
    /**
     * Filter collaborators returned by their affiliation. Can be one of:
     * \* `outside`: All outside collaborators of an organization-owned repository.
     * \* `direct`: All collaborators with permissions to an organization-owned repository, regardless of organization membership status.
     * \* `all`: All collaborators the authenticated user can see.
     */
    affiliation?: "outside" | "direct" | "all";
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
};
export declare type ReposListCommentsForCommitParamsDeprecatedRef = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * @deprecated "ref" parameter renamed to "commit_sha"
     */
    ref: string;
    repo: string;
};
export declare type ReposListCommentsForCommitParams = {
    commit_sha: string;
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
};
export declare type ReposListCommitCommentsParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
};
export declare type ReposListCommitsParams = {
    /**
     * GitHub login or email address by which to filter by commit author.
     */
    author?: string;
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Only commits containing this file path will be returned.
     */
    path?: string;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
    /**
     * SHA or branch to start listing commits from. Default: the repository’s default branch (usually `master`).
     */
    sha?: string;
    /**
     * Only commits after this date will be returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since?: string;
    /**
     * Only commits before this date will be returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    until?: string;
};
export declare type ReposListContributorsParams = {
    /**
     * Set to `1` or `true` to include anonymous contributors in results.
     */
    anon?: string;
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
};
export declare type ReposListDeployKeysParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
};
export declare type ReposListDeploymentStatusesParams = {
    deployment_id: number;
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
};
export declare type ReposListDeploymentsParams = {
    /**
     * The name of the environment that was deployed to (e.g., `staging` or `production`).
     */
    environment?: string;
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * The name of the ref. This can be a branch, tag, or SHA.
     */
    ref?: string;
    repo: string;
    /**
     * The SHA recorded at creation time.
     */
    sha?: string;
    /**
     * The name of the task for the deployment (e.g., `deploy` or `deploy:migrations`).
     */
    task?: string;
};
export declare type ReposListDownloadsParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
};
export declare type ReposListForOrgParams = {
    /**
     * Can be one of `asc` or `desc`. Default: when using `full_name`: `asc`, otherwise `desc`
     */
    direction?: "asc" | "desc";
    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Can be one of `created`, `updated`, `pushed`, `full_name`.
     */
    sort?: "created" | "updated" | "pushed" | "full_name";
    /**
     * Specifies the types of repositories you want returned. Can be one of `all`, `public`, `private`, `forks`, `sources`, `member`, `internal`. Default: `all`. If your organization is associated with an enterprise account using GitHub Enterprise Cloud, `type` can also be `internal`.
     */
    type?: "all" | "public" | "private" | "forks" | "sources" | "member" | "internal";
};
export declare type ReposListForUserParams = {
    /**
     * Can be one of `asc` or `desc`. Default: `asc` when using `full_name`, otherwise `desc`
     */
    direction?: "asc" | "desc";
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Can be one of `created`, `updated`, `pushed`, `full_name`.
     */
    sort?: "created" | "updated" | "pushed" | "full_name";
    /**
     * Can be one of `all`, `owner`, `member`.
     */
    type?: "all" | "owner" | "member";
    username: string;
};
export declare type ReposListForksParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
    /**
     * The sort order. Can be either `newest`, `oldest`, or `stargazers`.
     */
    sort?: "newest" | "oldest" | "stargazers";
};
export declare type ReposListHooksParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
};
export declare type ReposListInvitationsParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
};
export declare type ReposListInvitationsForAuthenticatedUserParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
};
export declare type ReposListLanguagesParams = {
    owner: string;
    repo: string;
};
export declare type ReposListPagesBuildsParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
};
export declare type ReposListProtectedBranchRequiredStatusChecksContextsParams = {
    branch: string;
    owner: string;
    repo: string;
};
export declare type ReposListProtectedBranchTeamRestrictionsParams = {
    branch: string;
    owner: string;
    repo: string;
};
export declare type ReposListProtectedBranchUserRestrictionsParams = {
    branch: string;
    owner: string;
    repo: string;
};
export declare type ReposListPublicParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * The integer ID of the last repository that you've seen.
     */
    since?: number;
};
export declare type ReposListPullRequestsAssociatedWithCommitParams = {
    commit_sha: string;
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
};
export declare type ReposListReleasesParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
};
export declare type ReposListStatusesForRefParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    ref: string;
    repo: string;
};
export declare type ReposListTagsParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
};
export declare type ReposListTeamsParams = {
    owner: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    repo: string;
};
export declare type ReposListTeamsWithAccessToProtectedBranchParams = {
    branch: string;
    owner: string;
    repo: string;
};
export declare type ReposListTopicsParams = {
    owner: string;
    repo: string;
};
export declare type ReposListUsersWithAccessToProtectedBranchParams = {
    branch: string;
    owner: string;
    repo: string;
};
export declare type ReposMergeParams = {
    /**
     * The name of the base branch that the head will be merged into.
     */
    base: string;
    /**
     * Commit message to use for the merge commit. If omitted, a default message will be used.
     */
    commit_message?: string;
    /**
     * The head to merge. This can be a branch name or a commit SHA1.
     */
    head: string;
    owner: string;
    repo: string;
};
export declare type ReposPingHookParams = {
    hook_id: number;
    owner: string;
    repo: string;
};
export declare type ReposRemoveBranchProtectionParams = {
    branch: string;
    owner: string;
    repo: string;
};
export declare type ReposRemoveCollaboratorParams = {
    owner: string;
    repo: string;
    username: string;
};
export declare type ReposRemoveDeployKeyParams = {
    key_id: number;
    owner: string;
    repo: string;
};
export declare type ReposRemoveProtectedBranchAdminEnforcementParams = {
    branch: string;
    owner: string;
    repo: string;
};
export declare type ReposRemoveProtectedBranchAppRestrictionsParams = {
    apps: string[];
    branch: string;
    owner: string;
    repo: string;
};
export declare type ReposRemoveProtectedBranchPullRequestReviewEnforcementParams = {
    branch: string;
    owner: string;
    repo: string;
};
export declare type ReposRemoveProtectedBranchRequiredSignaturesParams = {
    branch: string;
    owner: string;
    repo: string;
};
export declare type ReposRemoveProtectedBranchRequiredStatusChecksParams = {
    branch: string;
    owner: string;
    repo: string;
};
export declare type ReposRemoveProtectedBranchRequiredStatusChecksContextsParams = {
    branch: string;
    contexts: string[];
    owner: string;
    repo: string;
};
export declare type ReposRemoveProtectedBranchRestrictionsParams = {
    branch: string;
    owner: string;
    repo: string;
};
export declare type ReposRemoveProtectedBranchTeamRestrictionsParams = {
    branch: string;
    owner: string;
    repo: string;
    teams: string[];
};
export declare type ReposRemoveProtectedBranchUserRestrictionsParams = {
    branch: string;
    owner: string;
    repo: string;
    users: string[];
};
export declare type ReposReplaceProtectedBranchAppRestrictionsParams = {
    apps: string[];
    branch: string;
    owner: string;
    repo: string;
};
export declare type ReposReplaceProtectedBranchRequiredStatusChecksContextsParams = {
    branch: string;
    contexts: string[];
    owner: string;
    repo: string;
};
export declare type ReposReplaceProtectedBranchTeamRestrictionsParams = {
    branch: string;
    owner: string;
    repo: string;
    teams: string[];
};
export declare type ReposReplaceProtectedBranchUserRestrictionsParams = {
    branch: string;
    owner: string;
    repo: string;
    users: string[];
};
export declare type ReposReplaceTopicsParams = {
    /**
     * An array of topics to add to the repository. Pass one or more topics to _replace_ the set of existing topics. Send an empty array (`[]`) to clear all topics from the repository. **Note:** Topic `names` cannot contain uppercase letters.
     */
    names: string[];
    owner: string;
    repo: string;
};
export declare type ReposRequestPageBuildParams = {
    owner: string;
    repo: string;
};
export declare type ReposRetrieveCommunityProfileMetricsParams = {
    owner: string;
    repo: string;
};
export declare type ReposTestPushHookParams = {
    hook_id: number;
    owner: string;
    repo: string;
};
export declare type ReposTransferParams = {
    /**
     * **Required:** The username or organization name the repository will be transferred to.
     */
    new_owner?: string;
    owner: string;
    repo: string;
    /**
     * ID of the team or teams to add to the repository. Teams can only be added to organization-owned repositories.
     */
    team_ids?: number[];
};
export declare type ReposUpdateParams = {
    /**
     * Either `true` to allow merging pull requests with a merge commit, or `false` to prevent merging pull requests with merge commits.
     */
    allow_merge_commit?: boolean;
    /**
     * Either `true` to allow rebase-merging pull requests, or `false` to prevent rebase-merging.
     */
    allow_rebase_merge?: boolean;
    /**
     * Either `true` to allow squash-merging pull requests, or `false` to prevent squash-merging.
     */
    allow_squash_merge?: boolean;
    /**
     * `true` to archive this repository. **Note**: You cannot unarchive repositories through the API.
     */
    archived?: boolean;
    /**
     * Updates the default branch for this repository.
     */
    default_branch?: string;
    /**
     * Either `true` to allow automatically deleting head branches when pull requests are merged, or `false` to prevent automatic deletion.
     */
    delete_branch_on_merge?: boolean;
    /**
     * A short description of the repository.
     */
    description?: string;
    /**
     * Either `true` to enable issues for this repository or `false` to disable them.
     */
    has_issues?: boolean;
    /**
     * Either `true` to enable projects for this repository or `false` to disable them. **Note:** If you're creating a repository in an organization that has disabled repository projects, the default is `false`, and if you pass `true`, the API returns an error.
     */
    has_projects?: boolean;
    /**
     * Either `true` to enable the wiki for this repository or `false` to disable it.
     */
    has_wiki?: boolean;
    /**
     * A URL with more information about the repository.
     */
    homepage?: string;
    /**
     * Either `true` to make this repo available as a template repository or `false` to prevent it.
     */
    is_template?: boolean;
    /**
     * The name of the repository.
     */
    name?: string;
    owner: string;
    /**
     * Either `true` to make the repository private or `false` to make it public. Creating private repositories requires a paid GitHub account. Default: `false`.
     * **Note**: You will get a `422` error if the organization restricts [changing repository visibility](https://help.github.com/articles/repository-permission-levels-for-an-organization#changing-the-visibility-of-repositories) to organization owners and a non-owner tries to change the value of private. **Note**: You will get a `422` error if the organization restricts [changing repository visibility](https://help.github.com/articles/repository-permission-levels-for-an-organization#changing-the-visibility-of-repositories) to organization owners and a non-owner tries to change the value of private.
     */
    private?: boolean;
    repo: string;
    /**
     * Can be `public` or `private`. If your organization is associated with an enterprise account using GitHub Enterprise Cloud, `visibility` can also be `internal`. The `visibility` parameter overrides the `private` parameter when you use both along with the `nebula-preview` preview header.
     */
    visibility?: "public" | "private" | "visibility" | "internal";
};
export declare type ReposUpdateBranchProtectionParams = {
    /**
     * Allows deletion of the protected branch by anyone with write access to the repository. Set to `false` to prevent deletion of the protected branch. Default: `false`. For more information, see "[Enabling force pushes to a protected branch](https://help.github.com/en/github/administering-a-repository/enabling-force-pushes-to-a-protected-branch)" in the GitHub Help documentation.
     */
    allow_deletions?: boolean;
    /**
     * Permits force pushes to the protected branch by anyone with write access to the repository. Set to `true` to allow force pushes. Set to `false` or `null` to block force pushes. Default: `false`. For more information, see "[Enabling force pushes to a protected branch](https://help.github.com/en/github/administering-a-repository/enabling-force-pushes-to-a-protected-branch)" in the GitHub Help documentation."
     */
    allow_force_pushes?: boolean | null;
    branch: string;
    /**
     * Enforce all configured restrictions for administrators. Set to `true` to enforce required status checks for repository administrators. Set to `null` to disable.
     */
    enforce_admins: boolean | null;
    owner: string;
    repo: string;
    /**
     * Enforces a linear commit Git history, which prevents anyone from pushing merge commits to a branch. Set to `true` to enforce a linear commit history. Set to `false` to disable a linear commit Git history. Your repository must allow squash merging or rebase merging before you can enable a linear commit history. Default: `false`. For more information, see "[Requiring a linear commit history](https://help.github.com/github/administering-a-repository/requiring-a-linear-commit-history)" in the GitHub Help documentation.
     */
    required_linear_history?: boolean;
    /**
     * Require at least one approving review on a pull request, before merging. Set to `null` to disable.
     */
    required_pull_request_reviews: ReposUpdateBranchProtectionParamsRequiredPullRequestReviews | null;
    /**
     * Require status checks to pass before merging. Set to `null` to disable.
     */
    required_status_checks: ReposUpdateBranchProtectionParamsRequiredStatusChecks | null;
    /**
     * Restrict who can push to the protected branch. User, app, and team `restrictions` are only available for organization-owned repositories. Set to `null` to disable.
     */
    restrictions: ReposUpdateBranchProtectionParamsRestrictions | null;
};
export declare type ReposUpdateCommitCommentParams = {
    /**
     * The contents of the comment
     */
    body: string;
    comment_id: number;
    owner: string;
    repo: string;
};
export declare type ReposUpdateFileParams = {
    /**
     * The author of the file. Default: The `committer` or the authenticated user if you omit `committer`.
     */
    author?: ReposUpdateFileParamsAuthor;
    /**
     * The branch name. Default: the repository’s default branch (usually `master`)
     */
    branch?: string;
    /**
     * The person that committed the file. Default: the authenticated user.
     */
    committer?: ReposUpdateFileParamsCommitter;
    /**
     * The new file content, using Base64 encoding.
     */
    content: string;
    /**
     * The commit message.
     */
    message: string;
    owner: string;
    path: string;
    repo: string;
    /**
     * **Required if you are updating a file**. The blob SHA of the file being replaced.
     */
    sha?: string;
};
export declare type ReposUpdateHookParams = {
    /**
     * Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.
     */
    active?: boolean;
    /**
     * Determines a list of events to be added to the list of events that the Hook triggers for.
     */
    add_events?: string[];
    /**
     * Key/value pairs to provide settings for this webhook. [These are defined below](https://developer.github.com/v3/repos/hooks/#create-hook-config-params).
     */
    config?: ReposUpdateHookParamsConfig;
    /**
     * Determines what [events](https://developer.github.com/v3/activity/events/types/) the hook is triggered for. This replaces the entire array of events.
     */
    events?: string[];
    hook_id: number;
    owner: string;
    /**
     * Determines a list of events to be removed from the list of events that the Hook triggers for.
     */
    remove_events?: string[];
    repo: string;
};
export declare type ReposUpdateInformationAboutPagesSiteParams = {
    /**
     * Specify a custom domain for the repository. Sending a `null` value will remove the custom domain. For more about custom domains, see "[Using a custom domain with GitHub Pages](https://help.github.com/articles/using-a-custom-domain-with-github-pages/)."
     */
    cname?: string;
    owner: string;
    repo: string;
    /**
     * Update the source for the repository. Must include the branch name, and may optionally specify the subdirectory `/docs`. Possible values are `"gh-pages"`, `"master"`, and `"master /docs"`.
     */
    source?: '"gh-pages"' | '"master"' | '"master /docs"';
};
export declare type ReposUpdateInvitationParams = {
    invitation_id: number;
    owner: string;
    /**
     * The permissions that the associated user will have on the repository. Valid values are `read`, `write`, and `admin`.
     */
    permissions?: "read" | "write" | "admin";
    repo: string;
};
export declare type ReposUpdateProtectedBranchPullRequestReviewEnforcementParams = {
    branch: string;
    /**
     * Set to `true` if you want to automatically dismiss approving reviews when someone pushes a new commit.
     */
    dismiss_stale_reviews?: boolean;
    /**
     * Specify which users and teams can dismiss pull request reviews. Pass an empty `dismissal_restrictions` object to disable. User and team `dismissal_restrictions` are only available for organization-owned repositories. Omit this parameter for personal repositories.
     */
    dismissal_restrictions?: ReposUpdateProtectedBranchPullRequestReviewEnforcementParamsDismissalRestrictions;
    owner: string;
    repo: string;
    /**
     * Blocks merging pull requests until [code owners](https://help.github.com/articles/about-code-owners/) have reviewed.
     */
    require_code_owner_reviews?: boolean;
    /**
     * Specifies the number of reviewers required to approve pull requests. Use a number between 1 and 6.
     */
    required_approving_review_count?: number;
};
export declare type ReposUpdateProtectedBranchRequiredStatusChecksParams = {
    branch: string;
    /**
     * The list of status checks to require in order to merge into this branch
     */
    contexts?: string[];
    owner: string;
    repo: string;
    /**
     * Require branches to be up to date before merging.
     */
    strict?: boolean;
};
export declare type ReposUpdateReleaseParams = {
    /**
     * Text describing the contents of the tag.
     */
    body?: string;
    /**
     * `true` makes the release a draft, and `false` publishes the release.
     */
    draft?: boolean;
    /**
     * The name of the release.
     */
    name?: string;
    owner: string;
    /**
     * `true` to identify the release as a prerelease, `false` to identify the release as a full release.
     */
    prerelease?: boolean;
    release_id: number;
    repo: string;
    /**
     * The name of the tag.
     */
    tag_name?: string;
    /**
     * Specifies the commitish value that determines where the Git tag is created from. Can be any branch or commit SHA. Unused if the Git tag already exists. Default: the repository's default branch (usually `master`).
     */
    target_commitish?: string;
};
export declare type ReposUpdateReleaseAssetParams = {
    asset_id: number;
    /**
     * An alternate short description of the asset. Used in place of the filename.
     */
    label?: string;
    /**
     * The file name of the asset.
     */
    name?: string;
    owner: string;
    repo: string;
};
export declare type ReposUploadReleaseAssetParamsDeprecatedFile = {
    /**
     * @deprecated "file" parameter renamed to "data"
     */
    file: string | object;
    headers: ReposUploadReleaseAssetParamsHeaders;
    /**
     * An alternate short description of the asset. Used in place of the filename. This should be set in a URI query parameter.
     */
    label?: string;
    /**
     * The file name of the asset. This should be set in a URI query parameter.
     */
    name: string;
    /**
     * The `upload_url` key returned from creating or getting a release
     */
    url: string;
};
export declare type ReposUploadReleaseAssetParams = {
    data: string | object;
    headers: ReposUploadReleaseAssetParamsHeaders;
    /**
     * An alternate short description of the asset. Used in place of the filename. This should be set in a URI query parameter.
     */
    label?: string;
    /**
     * The file name of the asset. This should be set in a URI query parameter.
     */
    name: string;
    /**
     * The `upload_url` key returned from creating or getting a release
     */
    url: string;
};
export declare type SearchCodeParams = {
    /**
     * Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
     */
    order?: "desc" | "asc";
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as GitHub.com. To learn more about the format of the query, see [Constructing a search query](https://developer.github.com/v3/search/#constructing-a-search-query). See "[Searching code](https://help.github.com/articles/searching-code/)" for a detailed list of qualifiers.
     */
    q: string;
    /**
     * Sorts the results of your query. Can only be `indexed`, which indicates how recently a file has been indexed by the GitHub search infrastructure. Default: [best match](https://developer.github.com/v3/search/#ranking-search-results)
     */
    sort?: "indexed";
};
export declare type SearchCommitsParams = {
    /**
     * Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
     */
    order?: "desc" | "asc";
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as GitHub.com. To learn more about the format of the query, see [Constructing a search query](https://developer.github.com/v3/search/#constructing-a-search-query). See "[Searching commits](https://help.github.com/articles/searching-commits/)" for a detailed list of qualifiers.
     */
    q: string;
    /**
     * Sorts the results of your query by `author-date` or `committer-date`. Default: [best match](https://developer.github.com/v3/search/#ranking-search-results)
     */
    sort?: "author-date" | "committer-date";
};
export declare type SearchEmailLegacyParams = {
    /**
     * The email address.
     */
    email: string;
};
export declare type SearchIssuesParams = {
    /**
     * Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
     */
    order?: "desc" | "asc";
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as GitHub.com. To learn more about the format of the query, see [Constructing a search query](https://developer.github.com/v3/search/#constructing-a-search-query). See "[Searching issues and pull requests](https://help.github.com/articles/searching-issues-and-pull-requests/)" for a detailed list of qualifiers.
     */
    q: string;
    /**
     * Sorts the results of your query by the number of `comments`, `reactions`, `reactions-+1`, `reactions--1`, `reactions-smile`, `reactions-thinking_face`, `reactions-heart`, `reactions-tada`, or `interactions`. You can also sort results by how recently the items were `created` or `updated`, Default: [best match](https://developer.github.com/v3/search/#ranking-search-results)
     */
    sort?: "comments" | "reactions" | "reactions-+1" | "reactions--1" | "reactions-smile" | "reactions-thinking_face" | "reactions-heart" | "reactions-tada" | "interactions" | "created" | "updated";
};
export declare type SearchIssuesAndPullRequestsParams = {
    /**
     * Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
     */
    order?: "desc" | "asc";
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as GitHub.com. To learn more about the format of the query, see [Constructing a search query](https://developer.github.com/v3/search/#constructing-a-search-query). See "[Searching issues and pull requests](https://help.github.com/articles/searching-issues-and-pull-requests/)" for a detailed list of qualifiers.
     */
    q: string;
    /**
     * Sorts the results of your query by the number of `comments`, `reactions`, `reactions-+1`, `reactions--1`, `reactions-smile`, `reactions-thinking_face`, `reactions-heart`, `reactions-tada`, or `interactions`. You can also sort results by how recently the items were `created` or `updated`, Default: [best match](https://developer.github.com/v3/search/#ranking-search-results)
     */
    sort?: "comments" | "reactions" | "reactions-+1" | "reactions--1" | "reactions-smile" | "reactions-thinking_face" | "reactions-heart" | "reactions-tada" | "interactions" | "created" | "updated";
};
export declare type SearchIssuesLegacyParams = {
    /**
     * The search term.
     */
    keyword: string;
    owner: string;
    repository: string;
    /**
     * Indicates the state of the issues to return. Can be either `open` or `closed`.
     */
    state: "open" | "closed";
};
export declare type SearchLabelsParams = {
    /**
     * Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
     */
    order?: "desc" | "asc";
    /**
     * The search keywords. This endpoint does not accept qualifiers in the query. To learn more about the format of the query, see [Constructing a search query](https://developer.github.com/v3/search/#constructing-a-search-query).
     */
    q: string;
    /**
     * The id of the repository.
     */
    repository_id: number;
    /**
     * Sorts the results of your query by when the label was `created` or `updated`. Default: [best match](https://developer.github.com/v3/search/#ranking-search-results)
     */
    sort?: "created" | "updated";
};
export declare type SearchReposParams = {
    /**
     * Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
     */
    order?: "desc" | "asc";
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as GitHub.com. To learn more about the format of the query, see [Constructing a search query](https://developer.github.com/v3/search/#constructing-a-search-query). See "[Searching for repositories](https://help.github.com/articles/searching-for-repositories/)" for a detailed list of qualifiers.
     */
    q: string;
    /**
     * Sorts the results of your query by number of `stars`, `forks`, or `help-wanted-issues` or how recently the items were `updated`. Default: [best match](https://developer.github.com/v3/search/#ranking-search-results)
     */
    sort?: "stars" | "forks" | "help-wanted-issues" | "updated";
};
export declare type SearchReposLegacyParams = {
    /**
     * The search term.
     */
    keyword: string;
    /**
     * Filter results by language.
     */
    language?: string;
    /**
     * The sort field. if `sort` param is provided. Can be either `asc` or `desc`.
     */
    order?: "asc" | "desc";
    /**
     * The sort field. One of `stars`, `forks`, or `updated`. Default: results are sorted by best match.
     */
    sort?: "stars" | "forks" | "updated";
    /**
     * The page number to fetch.
     */
    start_page?: string;
};
export declare type SearchTopicsParams = {
    /**
     * The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as GitHub.com. To learn more about the format of the query, see [Constructing a search query](https://developer.github.com/v3/search/#constructing-a-search-query).
     */
    q: string;
};
export declare type SearchUsersParams = {
    /**
     * Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
     */
    order?: "desc" | "asc";
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as GitHub.com. To learn more about the format of the query, see [Constructing a search query](https://developer.github.com/v3/search/#constructing-a-search-query). See "[Searching users](https://help.github.com/articles/searching-users/)" for a detailed list of qualifiers.
     */
    q: string;
    /**
     * Sorts the results of your query by number of `followers` or `repositories`, or when the person `joined` GitHub. Default: [best match](https://developer.github.com/v3/search/#ranking-search-results)
     */
    sort?: "followers" | "repositories" | "joined";
};
export declare type SearchUsersLegacyParams = {
    /**
     * The search term.
     */
    keyword: string;
    /**
     * The sort field. if `sort` param is provided. Can be either `asc` or `desc`.
     */
    order?: "asc" | "desc";
    /**
     * The sort field. One of `stars`, `forks`, or `updated`. Default: results are sorted by best match.
     */
    sort?: "stars" | "forks" | "updated";
    /**
     * The page number to fetch.
     */
    start_page?: string;
};
export declare type TeamsAddMemberParams = {
    team_id: number;
    username: string;
};
export declare type TeamsAddMemberLegacyParams = {
    team_id: number;
    username: string;
};
export declare type TeamsAddOrUpdateMembershipParams = {
    /**
     * The role that this user should have in the team. Can be one of:
     * \* `member` - a normal member of the team.
     * \* `maintainer` - a team maintainer. Able to add/remove other team members, promote other team members to team maintainer, and edit the team's name and description.
     */
    role?: "member" | "maintainer";
    team_id: number;
    username: string;
};
export declare type TeamsAddOrUpdateMembershipInOrgParams = {
    org: string;
    /**
     * The role that this user should have in the team. Can be one of:
     * \* `member` - a normal member of the team.
     * \* `maintainer` - a team maintainer. Able to add/remove other team members, promote other team members to team maintainer, and edit the team's name and description.
     */
    role?: "member" | "maintainer";
    team_slug: string;
    username: string;
};
export declare type TeamsAddOrUpdateMembershipLegacyParams = {
    /**
     * The role that this user should have in the team. Can be one of:
     * \* `member` - a normal member of the team.
     * \* `maintainer` - a team maintainer. Able to add/remove other team members, promote other team members to team maintainer, and edit the team's name and description.
     */
    role?: "member" | "maintainer";
    team_id: number;
    username: string;
};
export declare type TeamsAddOrUpdateProjectParams = {
    /**
     * The permission to grant to the team for this project. Can be one of:
     * \* `read` - team members can read, but not write to or administer this project.
     * \* `write` - team members can read and write, but not administer this project.
     * \* `admin` - team members can read, write and administer this project.
     * Default: the team's `permission` attribute will be used to determine what permission to grant the team on this project. Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://developer.github.com/v3/#http-verbs)."
     */
    permission?: "read" | "write" | "admin";
    project_id: number;
    team_id: number;
};
export declare type TeamsAddOrUpdateProjectInOrgParams = {
    org: string;
    /**
     * The permission to grant to the team for this project. Can be one of:
     * \* `read` - team members can read, but not write to or administer this project.
     * \* `write` - team members can read and write, but not administer this project.
     * \* `admin` - team members can read, write and administer this project.
     * Default: the team's `permission` attribute will be used to determine what permission to grant the team on this project. Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://developer.github.com/v3/#http-verbs)."
     */
    permission?: "read" | "write" | "admin";
    project_id: number;
    team_slug: string;
};
export declare type TeamsAddOrUpdateProjectLegacyParams = {
    /**
     * The permission to grant to the team for this project. Can be one of:
     * \* `read` - team members can read, but not write to or administer this project.
     * \* `write` - team members can read and write, but not administer this project.
     * \* `admin` - team members can read, write and administer this project.
     * Default: the team's `permission` attribute will be used to determine what permission to grant the team on this project. Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://developer.github.com/v3/#http-verbs)."
     */
    permission?: "read" | "write" | "admin";
    project_id: number;
    team_id: number;
};
export declare type TeamsAddOrUpdateRepoParams = {
    owner: string;
    /**
     * The permission to grant the team on this repository. Can be one of:
     * \* `pull` - team members can pull, but not push to or administer this repository.
     * \* `push` - team members can pull and push, but not administer this repository.
     * \* `admin` - team members can pull, push and administer this repository.
     *
     * If no permission is specified, the team's `permission` attribute will be used to determine what permission to grant the team on this repository.
     */
    permission?: "pull" | "push" | "admin";
    repo: string;
    team_id: number;
};
export declare type TeamsAddOrUpdateRepoInOrgParams = {
    org: string;
    owner: string;
    /**
     * The permission to grant the team on this repository. Can be one of:
     * \* `pull` - team members can pull, but not push to or administer this repository.
     * \* `push` - team members can pull and push, but not administer this repository.
     * \* `admin` - team members can pull, push and administer this repository.
     *
     * If no permission is specified, the team's `permission` attribute will be used to determine what permission to grant the team on this repository.
     */
    permission?: "pull" | "push" | "admin";
    repo: string;
    team_slug: string;
};
export declare type TeamsAddOrUpdateRepoLegacyParams = {
    owner: string;
    /**
     * The permission to grant the team on this repository. Can be one of:
     * \* `pull` - team members can pull, but not push to or administer this repository.
     * \* `push` - team members can pull and push, but not administer this repository.
     * \* `admin` - team members can pull, push and administer this repository.
     *
     * If no permission is specified, the team's `permission` attribute will be used to determine what permission to grant the team on this repository.
     */
    permission?: "pull" | "push" | "admin";
    repo: string;
    team_id: number;
};
export declare type TeamsCheckManagesRepoParams = {
    owner: string;
    repo: string;
    team_id: number;
};
export declare type TeamsCheckManagesRepoInOrgParams = {
    org: string;
    owner: string;
    repo: string;
    team_slug: string;
};
export declare type TeamsCheckManagesRepoLegacyParams = {
    owner: string;
    repo: string;
    team_id: number;
};
export declare type TeamsCreateParamsDeprecatedPermission = {
    /**
     * The description of the team.
     */
    description?: string;
    /**
     * List GitHub IDs for organization members who will become team maintainers.
     */
    maintainers?: string[];
    /**
     * The name of the team.
     */
    name: string;
    org: string;
    /**
     * The ID of a team to set as the parent team.
     */
    parent_team_id?: number;
    /**
     * **Deprecated**. The permission that new repositories will be added to the team with when none is specified. Can be one of:
     * \* `pull` - team members can pull, but not push to or administer newly-added repositories.
     * \* `push` - team members can pull and push, but not administer newly-added repositories.
     * \* `admin` - team members can pull, push and administer newly-added repositories.
     * @deprecated "permission" parameter has been deprecated and will be removed in future
     */
    permission?: string;
    /**
     * The level of privacy this team should have. The options are:
     * **For a non-nested team:**
     * \* `secret` - only visible to organization owners and members of this team.
     * \* `closed` - visible to all members of this organization.
     * Default: `secret`
     * **For a parent or child team:**
     * \* `closed` - visible to all members of this organization.
     * Default for child team: `closed`
     */
    privacy?: "secret" | "closed";
    /**
     * The full name (e.g., "organization-name/repository-name") of repositories to add the team to.
     */
    repo_names?: string[];
};
export declare type TeamsCreateParams = {
    /**
     * The description of the team.
     */
    description?: string;
    /**
     * List GitHub IDs for organization members who will become team maintainers.
     */
    maintainers?: string[];
    /**
     * The name of the team.
     */
    name: string;
    org: string;
    /**
     * The ID of a team to set as the parent team.
     */
    parent_team_id?: number;
    /**
     * The level of privacy this team should have. The options are:
     * **For a non-nested team:**
     * \* `secret` - only visible to organization owners and members of this team.
     * \* `closed` - visible to all members of this organization.
     * Default: `secret`
     * **For a parent or child team:**
     * \* `closed` - visible to all members of this organization.
     * Default for child team: `closed`
     */
    privacy?: "secret" | "closed";
    /**
     * The full name (e.g., "organization-name/repository-name") of repositories to add the team to.
     */
    repo_names?: string[];
};
export declare type TeamsCreateDiscussionParams = {
    /**
     * The discussion post's body text.
     */
    body: string;
    /**
     * Private posts are only visible to team members, organization owners, and team maintainers. Public posts are visible to all members of the organization. Set to `true` to create a private post.
     */
    private?: boolean;
    team_id: number;
    /**
     * The discussion post's title.
     */
    title: string;
};
export declare type TeamsCreateDiscussionCommentParams = {
    /**
     * The discussion comment's body text.
     */
    body: string;
    discussion_number: number;
    team_id: number;
};
export declare type TeamsCreateDiscussionCommentInOrgParams = {
    /**
     * The discussion comment's body text.
     */
    body: string;
    discussion_number: number;
    org: string;
    team_slug: string;
};
export declare type TeamsCreateDiscussionCommentLegacyParams = {
    /**
     * The discussion comment's body text.
     */
    body: string;
    discussion_number: number;
    team_id: number;
};
export declare type TeamsCreateDiscussionInOrgParams = {
    /**
     * The discussion post's body text.
     */
    body: string;
    org: string;
    /**
     * Private posts are only visible to team members, organization owners, and team maintainers. Public posts are visible to all members of the organization. Set to `true` to create a private post.
     */
    private?: boolean;
    team_slug: string;
    /**
     * The discussion post's title.
     */
    title: string;
};
export declare type TeamsCreateDiscussionLegacyParams = {
    /**
     * The discussion post's body text.
     */
    body: string;
    /**
     * Private posts are only visible to team members, organization owners, and team maintainers. Public posts are visible to all members of the organization. Set to `true` to create a private post.
     */
    private?: boolean;
    team_id: number;
    /**
     * The discussion post's title.
     */
    title: string;
};
export declare type TeamsDeleteParams = {
    team_id: number;
};
export declare type TeamsDeleteDiscussionParams = {
    discussion_number: number;
    team_id: number;
};
export declare type TeamsDeleteDiscussionCommentParams = {
    comment_number: number;
    discussion_number: number;
    team_id: number;
};
export declare type TeamsDeleteDiscussionCommentInOrgParams = {
    comment_number: number;
    discussion_number: number;
    org: string;
    team_slug: string;
};
export declare type TeamsDeleteDiscussionCommentLegacyParams = {
    comment_number: number;
    discussion_number: number;
    team_id: number;
};
export declare type TeamsDeleteDiscussionInOrgParams = {
    discussion_number: number;
    org: string;
    team_slug: string;
};
export declare type TeamsDeleteDiscussionLegacyParams = {
    discussion_number: number;
    team_id: number;
};
export declare type TeamsDeleteInOrgParams = {
    org: string;
    team_slug: string;
};
export declare type TeamsDeleteLegacyParams = {
    team_id: number;
};
export declare type TeamsGetParams = {
    team_id: number;
};
export declare type TeamsGetByNameParams = {
    org: string;
    team_slug: string;
};
export declare type TeamsGetDiscussionParams = {
    discussion_number: number;
    team_id: number;
};
export declare type TeamsGetDiscussionCommentParams = {
    comment_number: number;
    discussion_number: number;
    team_id: number;
};
export declare type TeamsGetDiscussionCommentInOrgParams = {
    comment_number: number;
    discussion_number: number;
    org: string;
    team_slug: string;
};
export declare type TeamsGetDiscussionCommentLegacyParams = {
    comment_number: number;
    discussion_number: number;
    team_id: number;
};
export declare type TeamsGetDiscussionInOrgParams = {
    discussion_number: number;
    org: string;
    team_slug: string;
};
export declare type TeamsGetDiscussionLegacyParams = {
    discussion_number: number;
    team_id: number;
};
export declare type TeamsGetLegacyParams = {
    team_id: number;
};
export declare type TeamsGetMemberParams = {
    team_id: number;
    username: string;
};
export declare type TeamsGetMemberLegacyParams = {
    team_id: number;
    username: string;
};
export declare type TeamsGetMembershipParams = {
    team_id: number;
    username: string;
};
export declare type TeamsGetMembershipInOrgParams = {
    org: string;
    team_slug: string;
    username: string;
};
export declare type TeamsGetMembershipLegacyParams = {
    team_id: number;
    username: string;
};
export declare type TeamsListParams = {
    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
};
export declare type TeamsListChildParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    team_id: number;
};
export declare type TeamsListChildInOrgParams = {
    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    team_slug: string;
};
export declare type TeamsListChildLegacyParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    team_id: number;
};
export declare type TeamsListDiscussionCommentsParams = {
    /**
     * Sorts the discussion comments by the date they were created. To return the oldest comments first, set to `asc`. Can be one of `asc` or `desc`.
     */
    direction?: "asc" | "desc";
    discussion_number: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    team_id: number;
};
export declare type TeamsListDiscussionCommentsInOrgParams = {
    /**
     * Sorts the discussion comments by the date they were created. To return the oldest comments first, set to `asc`. Can be one of `asc` or `desc`.
     */
    direction?: "asc" | "desc";
    discussion_number: number;
    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    team_slug: string;
};
export declare type TeamsListDiscussionCommentsLegacyParams = {
    /**
     * Sorts the discussion comments by the date they were created. To return the oldest comments first, set to `asc`. Can be one of `asc` or `desc`.
     */
    direction?: "asc" | "desc";
    discussion_number: number;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    team_id: number;
};
export declare type TeamsListDiscussionsParams = {
    /**
     * Sorts the discussion comments by the date they were created. To return the oldest comments first, set to `asc`. Can be one of `asc` or `desc`.
     */
    direction?: "asc" | "desc";
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    team_id: number;
};
export declare type TeamsListDiscussionsInOrgParams = {
    /**
     * Sorts the discussion comments by the date they were created. To return the oldest comments first, set to `asc`. Can be one of `asc` or `desc`.
     */
    direction?: "asc" | "desc";
    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    team_slug: string;
};
export declare type TeamsListDiscussionsLegacyParams = {
    /**
     * Sorts the discussion comments by the date they were created. To return the oldest comments first, set to `asc`. Can be one of `asc` or `desc`.
     */
    direction?: "asc" | "desc";
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    team_id: number;
};
export declare type TeamsListForAuthenticatedUserParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
};
export declare type TeamsListMembersParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Filters members returned by their role in the team. Can be one of:
     * \* `member` - normal members of the team.
     * \* `maintainer` - team maintainers.
     * \* `all` - all members of the team.
     */
    role?: "member" | "maintainer" | "all";
    team_id: number;
};
export declare type TeamsListMembersInOrgParams = {
    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Filters members returned by their role in the team. Can be one of:
     * \* `member` - normal members of the team.
     * \* `maintainer` - team maintainers.
     * \* `all` - all members of the team.
     */
    role?: "member" | "maintainer" | "all";
    team_slug: string;
};
export declare type TeamsListMembersLegacyParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * Filters members returned by their role in the team. Can be one of:
     * \* `member` - normal members of the team.
     * \* `maintainer` - team maintainers.
     * \* `all` - all members of the team.
     */
    role?: "member" | "maintainer" | "all";
    team_id: number;
};
export declare type TeamsListPendingInvitationsParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    team_id: number;
};
export declare type TeamsListPendingInvitationsInOrgParams = {
    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    team_slug: string;
};
export declare type TeamsListPendingInvitationsLegacyParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    team_id: number;
};
export declare type TeamsListProjectsParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    team_id: number;
};
export declare type TeamsListProjectsInOrgParams = {
    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    team_slug: string;
};
export declare type TeamsListProjectsLegacyParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    team_id: number;
};
export declare type TeamsListReposParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    team_id: number;
};
export declare type TeamsListReposInOrgParams = {
    org: string;
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    team_slug: string;
};
export declare type TeamsListReposLegacyParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    team_id: number;
};
export declare type TeamsRemoveMemberParams = {
    team_id: number;
    username: string;
};
export declare type TeamsRemoveMemberLegacyParams = {
    team_id: number;
    username: string;
};
export declare type TeamsRemoveMembershipParams = {
    team_id: number;
    username: string;
};
export declare type TeamsRemoveMembershipInOrgParams = {
    org: string;
    team_slug: string;
    username: string;
};
export declare type TeamsRemoveMembershipLegacyParams = {
    team_id: number;
    username: string;
};
export declare type TeamsRemoveProjectParams = {
    project_id: number;
    team_id: number;
};
export declare type TeamsRemoveProjectInOrgParams = {
    org: string;
    project_id: number;
    team_slug: string;
};
export declare type TeamsRemoveProjectLegacyParams = {
    project_id: number;
    team_id: number;
};
export declare type TeamsRemoveRepoParams = {
    owner: string;
    repo: string;
    team_id: number;
};
export declare type TeamsRemoveRepoInOrgParams = {
    org: string;
    owner: string;
    repo: string;
    team_slug: string;
};
export declare type TeamsRemoveRepoLegacyParams = {
    owner: string;
    repo: string;
    team_id: number;
};
export declare type TeamsReviewProjectParams = {
    project_id: number;
    team_id: number;
};
export declare type TeamsReviewProjectInOrgParams = {
    org: string;
    project_id: number;
    team_slug: string;
};
export declare type TeamsReviewProjectLegacyParams = {
    project_id: number;
    team_id: number;
};
export declare type TeamsUpdateParamsDeprecatedPermission = {
    /**
     * The description of the team.
     */
    description?: string;
    /**
     * The name of the team.
     */
    name: string;
    /**
     * The ID of a team to set as the parent team.
     */
    parent_team_id?: number;
    /**
     * **Deprecated**. The permission that new repositories will be added to the team with when none is specified. Can be one of:
     * \* `pull` - team members can pull, but not push to or administer newly-added repositories.
     * \* `push` - team members can pull and push, but not administer newly-added repositories.
     * \* `admin` - team members can pull, push and administer newly-added repositories.
     * @deprecated "permission" parameter has been deprecated and will be removed in future
     */
    permission?: string;
    /**
     * The level of privacy this team should have. Editing teams without specifying this parameter leaves `privacy` intact. The options are:
     * **For a non-nested team:**
     * \* `secret` - only visible to organization owners and members of this team.
     * \* `closed` - visible to all members of this organization.
     * **For a parent or child team:**
     * \* `closed` - visible to all members of this organization.
     */
    privacy?: "secret" | "closed";
    team_id: number;
};
export declare type TeamsUpdateParams = {
    /**
     * The description of the team.
     */
    description?: string;
    /**
     * The name of the team.
     */
    name: string;
    /**
     * The ID of a team to set as the parent team.
     */
    parent_team_id?: number;
    /**
     * The level of privacy this team should have. Editing teams without specifying this parameter leaves `privacy` intact. The options are:
     * **For a non-nested team:**
     * \* `secret` - only visible to organization owners and members of this team.
     * \* `closed` - visible to all members of this organization.
     * **For a parent or child team:**
     * \* `closed` - visible to all members of this organization.
     */
    privacy?: "secret" | "closed";
    team_id: number;
};
export declare type TeamsUpdateDiscussionParams = {
    /**
     * The discussion post's body text.
     */
    body?: string;
    discussion_number: number;
    team_id: number;
    /**
     * The discussion post's title.
     */
    title?: string;
};
export declare type TeamsUpdateDiscussionCommentParams = {
    /**
     * The discussion comment's body text.
     */
    body: string;
    comment_number: number;
    discussion_number: number;
    team_id: number;
};
export declare type TeamsUpdateDiscussionCommentInOrgParams = {
    /**
     * The discussion comment's body text.
     */
    body: string;
    comment_number: number;
    discussion_number: number;
    org: string;
    team_slug: string;
};
export declare type TeamsUpdateDiscussionCommentLegacyParams = {
    /**
     * The discussion comment's body text.
     */
    body: string;
    comment_number: number;
    discussion_number: number;
    team_id: number;
};
export declare type TeamsUpdateDiscussionInOrgParams = {
    /**
     * The discussion post's body text.
     */
    body?: string;
    discussion_number: number;
    org: string;
    team_slug: string;
    /**
     * The discussion post's title.
     */
    title?: string;
};
export declare type TeamsUpdateDiscussionLegacyParams = {
    /**
     * The discussion post's body text.
     */
    body?: string;
    discussion_number: number;
    team_id: number;
    /**
     * The discussion post's title.
     */
    title?: string;
};
export declare type TeamsUpdateInOrgParamsDeprecatedPermission = {
    /**
     * The description of the team.
     */
    description?: string;
    /**
     * The name of the team.
     */
    name: string;
    org: string;
    /**
     * The ID of a team to set as the parent team.
     */
    parent_team_id?: number;
    /**
     * **Deprecated**. The permission that new repositories will be added to the team with when none is specified. Can be one of:
     * \* `pull` - team members can pull, but not push to or administer newly-added repositories.
     * \* `push` - team members can pull and push, but not administer newly-added repositories.
     * \* `admin` - team members can pull, push and administer newly-added repositories.
     * @deprecated "permission" parameter has been deprecated and will be removed in future
     */
    permission?: string;
    /**
     * The level of privacy this team should have. Editing teams without specifying this parameter leaves `privacy` intact. When a team is nested, the `privacy` for parent teams cannot be `secret`. The options are:
     * **For a non-nested team:**
     * \* `secret` - only visible to organization owners and members of this team.
     * \* `closed` - visible to all members of this organization.
     * **For a parent or child team:**
     * \* `closed` - visible to all members of this organization.
     */
    privacy?: "secret" | "closed";
    team_slug: string;
};
export declare type TeamsUpdateInOrgParams = {
    /**
     * The description of the team.
     */
    description?: string;
    /**
     * The name of the team.
     */
    name: string;
    org: string;
    /**
     * The ID of a team to set as the parent team.
     */
    parent_team_id?: number;
    /**
     * The level of privacy this team should have. Editing teams without specifying this parameter leaves `privacy` intact. When a team is nested, the `privacy` for parent teams cannot be `secret`. The options are:
     * **For a non-nested team:**
     * \* `secret` - only visible to organization owners and members of this team.
     * \* `closed` - visible to all members of this organization.
     * **For a parent or child team:**
     * \* `closed` - visible to all members of this organization.
     */
    privacy?: "secret" | "closed";
    team_slug: string;
};
export declare type TeamsUpdateLegacyParamsDeprecatedPermission = {
    /**
     * The description of the team.
     */
    description?: string;
    /**
     * The name of the team.
     */
    name: string;
    /**
     * The ID of a team to set as the parent team.
     */
    parent_team_id?: number;
    /**
     * **Deprecated**. The permission that new repositories will be added to the team with when none is specified. Can be one of:
     * \* `pull` - team members can pull, but not push to or administer newly-added repositories.
     * \* `push` - team members can pull and push, but not administer newly-added repositories.
     * \* `admin` - team members can pull, push and administer newly-added repositories.
     * @deprecated "permission" parameter has been deprecated and will be removed in future
     */
    permission?: string;
    /**
     * The level of privacy this team should have. Editing teams without specifying this parameter leaves `privacy` intact. The options are:
     * **For a non-nested team:**
     * \* `secret` - only visible to organization owners and members of this team.
     * \* `closed` - visible to all members of this organization.
     * **For a parent or child team:**
     * \* `closed` - visible to all members of this organization.
     */
    privacy?: "secret" | "closed";
    team_id: number;
};
export declare type TeamsUpdateLegacyParams = {
    /**
     * The description of the team.
     */
    description?: string;
    /**
     * The name of the team.
     */
    name: string;
    /**
     * The ID of a team to set as the parent team.
     */
    parent_team_id?: number;
    /**
     * The level of privacy this team should have. Editing teams without specifying this parameter leaves `privacy` intact. The options are:
     * **For a non-nested team:**
     * \* `secret` - only visible to organization owners and members of this team.
     * \* `closed` - visible to all members of this organization.
     * **For a parent or child team:**
     * \* `closed` - visible to all members of this organization.
     */
    privacy?: "secret" | "closed";
    team_id: number;
};
export declare type UsersAddEmailsParams = {
    /**
     * Adds one or more email addresses to your GitHub account. Must contain at least one email address. **Note:** Alternatively, you can pass a single email address or an `array` of emails addresses directly, but we recommend that you pass an object using the `emails` key.
     */
    emails: string[];
};
export declare type UsersBlockParams = {
    username: string;
};
export declare type UsersCheckBlockedParams = {
    username: string;
};
export declare type UsersCheckFollowingParams = {
    username: string;
};
export declare type UsersCheckFollowingForUserParams = {
    target_user: string;
    username: string;
};
export declare type UsersCreateGpgKeyParams = {
    /**
     * Your GPG key, generated in ASCII-armored format. See "[Generating a new GPG key](https://help.github.com/articles/generating-a-new-gpg-key/)" for help creating a GPG key.
     */
    armored_public_key?: string;
};
export declare type UsersCreatePublicKeyParams = {
    /**
     * The public SSH key to add to your GitHub account. See "[Generating a new SSH key](https://help.github.com/articles/generating-a-new-ssh-key-and-adding-it-to-the-ssh-agent/)" for guidance on how to create a public SSH key.
     */
    key?: string;
    /**
     * A descriptive name for the new key. Use a name that will help you recognize this key in your GitHub account. For example, if you're using a personal Mac, you might call this key "Personal MacBook Air".
     */
    title?: string;
};
export declare type UsersDeleteEmailsParams = {
    /**
     * Deletes one or more email addresses from your GitHub account. Must contain at least one email address. **Note:** Alternatively, you can pass a single email address or an `array` of emails addresses directly, but we recommend that you pass an object using the `emails` key.
     */
    emails: string[];
};
export declare type UsersDeleteGpgKeyParams = {
    gpg_key_id: number;
};
export declare type UsersDeletePublicKeyParams = {
    key_id: number;
};
export declare type UsersFollowParams = {
    username: string;
};
export declare type UsersGetByUsernameParams = {
    username: string;
};
export declare type UsersGetContextForUserParams = {
    /**
     * Uses the ID for the `subject_type` you specified. **Required** when using `subject_type`.
     */
    subject_id?: string;
    /**
     * Identifies which additional information you'd like to receive about the person's hovercard. Can be `organization`, `repository`, `issue`, `pull_request`. **Required** when using `subject_id`.
     */
    subject_type?: "organization" | "repository" | "issue" | "pull_request";
    username: string;
};
export declare type UsersGetGpgKeyParams = {
    gpg_key_id: number;
};
export declare type UsersGetPublicKeyParams = {
    key_id: number;
};
export declare type UsersListParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    /**
     * The integer ID of the last User that you've seen.
     */
    since?: string;
};
export declare type UsersListEmailsParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
};
export declare type UsersListFollowersForAuthenticatedUserParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
};
export declare type UsersListFollowersForUserParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    username: string;
};
export declare type UsersListFollowingForAuthenticatedUserParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
};
export declare type UsersListFollowingForUserParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    username: string;
};
export declare type UsersListGpgKeysParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
};
export declare type UsersListGpgKeysForUserParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    username: string;
};
export declare type UsersListPublicEmailsParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
};
export declare type UsersListPublicKeysParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
};
export declare type UsersListPublicKeysForUserParams = {
    /**
     * Page number of the results to fetch.
     */
    page?: number;
    /**
     * Results per page (max 100)
     */
    per_page?: number;
    username: string;
};
export declare type UsersTogglePrimaryEmailVisibilityParams = {
    /**
     * Specify the _primary_ email address that needs a visibility change.
     */
    email: string;
    /**
     * Use `public` to enable an authenticated user to view the specified email address, or use `private` so this primary email address cannot be seen publicly.
     */
    visibility: string;
};
export declare type UsersUnblockParams = {
    username: string;
};
export declare type UsersUnfollowParams = {
    username: string;
};
export declare type UsersUpdateAuthenticatedParams = {
    /**
     * The new short biography of the user.
     */
    bio?: string;
    /**
     * The new blog URL of the user.
     */
    blog?: string;
    /**
     * The new company of the user.
     */
    company?: string;
    /**
     * The publicly visible email address of the user.
     */
    email?: string;
    /**
     * The new hiring availability of the user.
     */
    hireable?: boolean;
    /**
     * The new location of the user.
     */
    location?: string;
    /**
     * The new name of the user.
     */
    name?: string;
};
export declare type AppsCreateInstallationTokenParamsPermissions = {};
export declare type ChecksCreateParamsActions = {
    /**
     * A short explanation of what this action would do. The maximum size is 40 characters.
     */
    description: string;
    /**
     * A reference for the action on the integrator's system. The maximum size is 20 characters.
     */
    identifier: string;
    /**
     * The text to be displayed on a button in the web UI. The maximum size is 20 characters.
     */
    label: string;
};
export declare type ChecksCreateParamsOutput = {
    /**
     * Adds information from your analysis to specific lines of code. Annotations are visible on GitHub in the **Checks** and **Files changed** tab of the pull request. The Checks API limits the number of annotations to a maximum of 50 per API request. To create more than 50 annotations, you have to make multiple requests to the [Update a check run](https://developer.github.com/v3/checks/runs/#update-a-check-run) endpoint. Each time you update the check run, annotations are appended to the list of annotations that already exist for the check run. For details about how you can view annotations on GitHub, see "[About status checks](https://help.github.com/articles/about-status-checks#checks)". See the [`annotations` object](https://developer.github.com/v3/checks/runs/#annotations-object) description for details about how to use this parameter.
     */
    annotations?: ChecksCreateParamsOutputAnnotations[];
    /**
     * Adds images to the output displayed in the GitHub pull request UI. See the [`images` object](https://developer.github.com/v3/checks/runs/#images-object) description for details.
     */
    images?: ChecksCreateParamsOutputImages[];
    /**
     * The summary of the check run. This parameter supports Markdown.
     */
    summary: string;
    /**
     * The details of the check run. This parameter supports Markdown.
     */
    text?: string;
    /**
     * The title of the check run.
     */
    title: string;
};
export declare type ChecksCreateParamsOutputAnnotations = {
    /**
     * The level of the annotation. Can be one of `notice`, `warning`, or `failure`.
     */
    annotation_level: "notice" | "warning" | "failure";
    /**
     * The end column of the annotation. Annotations only support `start_column` and `end_column` on the same line. Omit this parameter if `start_line` and `end_line` have different values.
     */
    end_column?: number;
    /**
     * The end line of the annotation.
     */
    end_line: number;
    /**
     * A short description of the feedback for these lines of code. The maximum size is 64 KB.
     */
    message: string;
    /**
     * The path of the file to add an annotation to. For example, `assets/css/main.css`.
     */
    path: string;
    /**
     * Details about this annotation. The maximum size is 64 KB.
     */
    raw_details?: string;
    /**
     * The start column of the annotation. Annotations only support `start_column` and `end_column` on the same line. Omit this parameter if `start_line` and `end_line` have different values.
     */
    start_column?: number;
    /**
     * The start line of the annotation.
     */
    start_line: number;
    /**
     * The title that represents the annotation. The maximum size is 255 characters.
     */
    title?: string;
};
export declare type ChecksCreateParamsOutputImages = {
    /**
     * The alternative text for the image.
     */
    alt: string;
    /**
     * A short image description.
     */
    caption?: string;
    /**
     * The full URL of the image.
     */
    image_url: string;
};
export declare type ChecksSetSuitesPreferencesParamsAutoTriggerChecks = {
    /**
     * The `id` of the GitHub App.
     */
    app_id: number;
    /**
     * Set to `true` to enable automatic creation of CheckSuite events upon pushes to the repository, or `false` to disable them.
     */
    setting: boolean;
};
export declare type ChecksUpdateParamsActions = {
    /**
     * A short explanation of what this action would do. The maximum size is 40 characters.
     */
    description: string;
    /**
     * A reference for the action on the integrator's system. The maximum size is 20 characters.
     */
    identifier: string;
    /**
     * The text to be displayed on a button in the web UI. The maximum size is 20 characters.
     */
    label: string;
};
export declare type ChecksUpdateParamsOutput = {
    /**
     * Adds information from your analysis to specific lines of code. Annotations are visible in GitHub's pull request UI. Annotations are visible in GitHub's pull request UI. The Checks API limits the number of annotations to a maximum of 50 per API request. To create more than 50 annotations, you have to make multiple requests to the [Update a check run](https://developer.github.com/v3/checks/runs/#update-a-check-run) endpoint. Each time you update the check run, annotations are appended to the list of annotations that already exist for the check run. For details about annotations in the UI, see "[About status checks](https://help.github.com/articles/about-status-checks#checks)". See the [`annotations` object](https://developer.github.com/v3/checks/runs/#annotations-object-1) description for details.
     */
    annotations?: ChecksUpdateParamsOutputAnnotations[];
    /**
     * Adds images to the output displayed in the GitHub pull request UI. See the [`images` object](https://developer.github.com/v3/checks/runs/#annotations-object-1) description for details.
     */
    images?: ChecksUpdateParamsOutputImages[];
    /**
     * Can contain Markdown.
     */
    summary: string;
    /**
     * Can contain Markdown.
     */
    text?: string;
    /**
     * **Required**.
     */
    title?: string;
};
export declare type ChecksUpdateParamsOutputAnnotations = {
    /**
     * The level of the annotation. Can be one of `notice`, `warning`, or `failure`.
     */
    annotation_level: "notice" | "warning" | "failure";
    /**
     * The end column of the annotation. Annotations only support `start_column` and `end_column` on the same line. Omit this parameter if `start_line` and `end_line` have different values.
     */
    end_column?: number;
    /**
     * The end line of the annotation.
     */
    end_line: number;
    /**
     * A short description of the feedback for these lines of code. The maximum size is 64 KB.
     */
    message: string;
    /**
     * The path of the file to add an annotation to. For example, `assets/css/main.css`.
     */
    path: string;
    /**
     * Details about this annotation. The maximum size is 64 KB.
     */
    raw_details?: string;
    /**
     * The start column of the annotation. Annotations only support `start_column` and `end_column` on the same line. Omit this parameter if `start_line` and `end_line` have different values.
     */
    start_column?: number;
    /**
     * The start line of the annotation.
     */
    start_line: number;
    /**
     * The title that represents the annotation. The maximum size is 255 characters.
     */
    title?: string;
};
export declare type ChecksUpdateParamsOutputImages = {
    /**
     * The alternative text for the image.
     */
    alt: string;
    /**
     * A short image description.
     */
    caption?: string;
    /**
     * The full URL of the image.
     */
    image_url: string;
};
export declare type GistsCreateParamsFiles = {
    /**
     * The content of the file.
     */
    content?: string;
};
export declare type GistsUpdateParamsFiles = {
    /**
     * The updated content of the file.
     */
    content?: string;
    /**
     * The new name for this file. To delete a file, set the value of the filename to `null`.
     */
    filename?: string;
};
export declare type GitCreateCommitParamsAuthor = {
    /**
     * Indicates when this commit was authored (or committed). This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    date?: string;
    /**
     * The email of the author (or committer) of the commit
     */
    email?: string;
    /**
     * The name of the author (or committer) of the commit
     */
    name?: string;
};
export declare type GitCreateCommitParamsCommitter = {
    /**
     * Indicates when this commit was authored (or committed). This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    date?: string;
    /**
     * The email of the author (or committer) of the commit
     */
    email?: string;
    /**
     * The name of the author (or committer) of the commit
     */
    name?: string;
};
export declare type GitCreateTagParamsTagger = {
    /**
     * When this object was tagged. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    date?: string;
    /**
     * The email of the author of the tag
     */
    email?: string;
    /**
     * The name of the author of the tag
     */
    name?: string;
};
export declare type GitCreateTreeParamsTree = {
    /**
     * The content you want this file to have. GitHub will write this blob out and use that SHA for this entry. Use either this, or `tree.sha`.
     *
     * **Note:** Use either `tree.sha` or `content` to specify the contents of the entry. Using both `tree.sha` and `content` will return an error.
     */
    content?: string;
    /**
     * The file mode; one of `100644` for file (blob), `100755` for executable (blob), `040000` for subdirectory (tree), `160000` for submodule (commit), or `120000` for a blob that specifies the path of a symlink.
     */
    mode?: "100644" | "100755" | "040000" | "160000" | "120000";
    /**
     * The file referenced in the tree.
     */
    path?: string;
    /**
     * The SHA1 checksum ID of the object in the tree. Also called `tree.sha`. If the value is `null` then the file will be deleted.
     *
     * **Note:** Use either `tree.sha` or `content` to specify the contents of the entry. Using both `tree.sha` and `content` will return an error.
     */
    sha?: string | null;
    /**
     * Either `blob`, `tree`, or `commit`.
     */
    type?: "blob" | "tree" | "commit";
};
export declare type OrgsCreateHookParamsConfig = {
    /**
     * The media type used to serialize the payloads. Supported values include `json` and `form`. The default is `form`.
     */
    content_type?: string;
    /**
     * Determines whether the SSL certificate of the host for `url` will be verified when delivering payloads. Supported values include `0` (verification is performed) and `1` (verification is not performed). The default is `0`. **We strongly recommend not setting this to `1` as you are subject to man-in-the-middle and other attacks.**
     */
    insecure_ssl?: string;
    /**
     * If provided, the `secret` will be used as the `key` to generate the HMAC hex digest value in the [`X-Hub-Signature`](https://developer.github.com/webhooks/#delivery-headers) header.
     */
    secret?: string;
    /**
     * The URL to which the payloads will be delivered.
     */
    url: string;
};
export declare type OrgsUpdateHookParamsConfig = {
    /**
     * The media type used to serialize the payloads. Supported values include `json` and `form`. The default is `form`.
     */
    content_type?: string;
    /**
     * Determines whether the SSL certificate of the host for `url` will be verified when delivering payloads. Supported values include `0` (verification is performed) and `1` (verification is not performed). The default is `0`. **We strongly recommend not setting this to `1` as you are subject to man-in-the-middle and other attacks.**
     */
    insecure_ssl?: string;
    /**
     * If provided, the `secret` will be used as the `key` to generate the HMAC hex digest value in the [`X-Hub-Signature`](https://developer.github.com/webhooks/#delivery-headers) header.
     */
    secret?: string;
    /**
     * The URL to which the payloads will be delivered.
     */
    url: string;
};
export declare type PullsCreateReviewParamsComments = {
    /**
     * Text of the review comment.
     */
    body: string;
    /**
     * The relative path to the file that necessitates a review comment.
     */
    path: string;
    /**
     * The position in the diff where you want to add a review comment. Note this value is not the same as the line number in the file. For help finding the position value, read the note below.
     */
    position: number;
};
export declare type ReposCreateDispatchEventParamsClientPayload = {};
export declare type ReposCreateFileParamsAuthor = {
    /**
     * The email of the author or committer of the commit. You'll receive a `422` status code if `email` is omitted.
     */
    email: string;
    /**
     * The name of the author or committer of the commit. You'll receive a `422` status code if `name` is omitted.
     */
    name: string;
};
export declare type ReposCreateFileParamsCommitter = {
    /**
     * The email of the author or committer of the commit. You'll receive a `422` status code if `email` is omitted.
     */
    email: string;
    /**
     * The name of the author or committer of the commit. You'll receive a `422` status code if `name` is omitted.
     */
    name: string;
};
export declare type ReposCreateHookParamsConfig = {
    /**
     * The media type used to serialize the payloads. Supported values include `json` and `form`. The default is `form`.
     */
    content_type?: string;
    /**
     * Determines whether the SSL certificate of the host for `url` will be verified when delivering payloads. Supported values include `0` (verification is performed) and `1` (verification is not performed). The default is `0`. **We strongly recommend not setting this to `1` as you are subject to man-in-the-middle and other attacks.**
     */
    insecure_ssl?: string;
    /**
     * If provided, the `secret` will be used as the `key` to generate the HMAC hex digest value in the [`X-Hub-Signature`](https://developer.github.com/webhooks/#delivery-headers) header.
     */
    secret?: string;
    /**
     * The URL to which the payloads will be delivered.
     */
    url: string;
};
export declare type ReposCreateOrUpdateFileParamsAuthor = {
    /**
     * The email of the author or committer of the commit. You'll receive a `422` status code if `email` is omitted.
     */
    email: string;
    /**
     * The name of the author or committer of the commit. You'll receive a `422` status code if `name` is omitted.
     */
    name: string;
};
export declare type ReposCreateOrUpdateFileParamsCommitter = {
    /**
     * The email of the author or committer of the commit. You'll receive a `422` status code if `email` is omitted.
     */
    email: string;
    /**
     * The name of the author or committer of the commit. You'll receive a `422` status code if `name` is omitted.
     */
    name: string;
};
export declare type ReposDeleteFileParamsAuthor = {
    /**
     * The email of the author (or committer) of the commit
     */
    email?: string;
    /**
     * The name of the author (or committer) of the commit
     */
    name?: string;
};
export declare type ReposDeleteFileParamsCommitter = {
    /**
     * The email of the author (or committer) of the commit
     */
    email?: string;
    /**
     * The name of the author (or committer) of the commit
     */
    name?: string;
};
export declare type ReposEnablePagesSiteParamsSource = {
    /**
     * The repository branch used to publish your [site's source files](https://help.github.com/articles/configuring-a-publishing-source-for-github-pages/). Can be either `master` or `gh-pages`.
     */
    branch?: "master" | "gh-pages";
    /**
     * The repository directory that includes the source files for the Pages site. When `branch` is `master`, you can change `path` to `/docs`. When `branch` is `gh-pages`, you are unable to specify a `path` other than `/`.
     */
    path?: string;
};
export declare type ReposUpdateBranchProtectionParamsRequiredPullRequestReviews = {
    /**
     * Set to `true` if you want to automatically dismiss approving reviews when someone pushes a new commit.
     */
    dismiss_stale_reviews?: boolean;
    /**
     * Specify which users and teams can dismiss pull request reviews. Pass an empty `dismissal_restrictions` object to disable. User and team `dismissal_restrictions` are only available for organization-owned repositories. Omit this parameter for personal repositories.
     */
    dismissal_restrictions?: ReposUpdateBranchProtectionParamsRequiredPullRequestReviewsDismissalRestrictions;
    /**
     * Blocks merging pull requests until [code owners](https://help.github.com/articles/about-code-owners/) review them.
     */
    require_code_owner_reviews?: boolean;
    /**
     * Specify the number of reviewers required to approve pull requests. Use a number between 1 and 6.
     */
    required_approving_review_count?: number;
};
export declare type ReposUpdateBranchProtectionParamsRequiredPullRequestReviewsDismissalRestrictions = {
    /**
     * The list of team `slug`s with dismissal access
     */
    teams?: string[];
    /**
     * The list of user `login`s with dismissal access
     */
    users?: string[];
};
export declare type ReposUpdateBranchProtectionParamsRequiredStatusChecks = {
    /**
     * The list of status checks to require in order to merge into this branch
     */
    contexts: string[];
    /**
     * Require branches to be up to date before merging.
     */
    strict: boolean;
};
export declare type ReposUpdateBranchProtectionParamsRestrictions = {
    /**
     * The list of app `slug`s with push access
     */
    apps?: string[];
    /**
     * The list of team `slug`s with push access
     */
    teams: string[];
    /**
     * The list of user `login`s with push access
     */
    users: string[];
};
export declare type ReposUpdateFileParamsAuthor = {
    /**
     * The email of the author or committer of the commit. You'll receive a `422` status code if `email` is omitted.
     */
    email: string;
    /**
     * The name of the author or committer of the commit. You'll receive a `422` status code if `name` is omitted.
     */
    name: string;
};
export declare type ReposUpdateFileParamsCommitter = {
    /**
     * The email of the author or committer of the commit. You'll receive a `422` status code if `email` is omitted.
     */
    email: string;
    /**
     * The name of the author or committer of the commit. You'll receive a `422` status code if `name` is omitted.
     */
    name: string;
};
export declare type ReposUpdateHookParamsConfig = {
    /**
     * The media type used to serialize the payloads. Supported values include `json` and `form`. The default is `form`.
     */
    content_type?: string;
    /**
     * Determines whether the SSL certificate of the host for `url` will be verified when delivering payloads. Supported values include `0` (verification is performed) and `1` (verification is not performed). The default is `0`. **We strongly recommend not setting this to `1` as you are subject to man-in-the-middle and other attacks.**
     */
    insecure_ssl?: string;
    /**
     * If provided, the `secret` will be used as the `key` to generate the HMAC hex digest value in the [`X-Hub-Signature`](https://developer.github.com/webhooks/#delivery-headers) header.
     */
    secret?: string;
    /**
     * The URL to which the payloads will be delivered.
     */
    url: string;
};
export declare type ReposUpdateProtectedBranchPullRequestReviewEnforcementParamsDismissalRestrictions = {
    /**
     * The list of team `slug`s with dismissal access
     */
    teams?: string[];
    /**
     * The list of user `login`s with dismissal access
     */
    users?: string[];
};
export declare type ReposUploadReleaseAssetParamsHeaders = {
    "content-length": number;
    "content-type": string;
};
export declare type RestEndpointMethods = {
    actions: {
        /**
         * Cancels a workflow run using its `id`. Anyone with write access to the repository can use this endpoint. GitHub Apps must have the `actions` permission to use this endpoint.
         */
        cancelWorkflowRun: {
            (params?: RequestParameters & ActionsCancelWorkflowRunParams): Promise<AnyResponse>;
            endpoint: EndpointInterface;
        };
        /**
         * Creates or updates a secret with an encrypted value. Encrypt your secret using [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). Anyone with write access to the repository can use this endpoint. GitHub Apps must have the `secrets` permission to use this endpoint.
         *
         * Encrypt your secret using the [tweetsodium](https://github.com/mastahyeti/tweetsodium) library.
         *
         *
         *
         * Encrypt your secret using [pynacl](https://pynacl.readthedocs.io/en/stable/public/#nacl-public-sealedbox) with Python 3.
         *
         *
         *
         * Encrypt your secret using the [Sodium.Core](https://www.nuget.org/packages/Sodium.Core/) package.
         *
         *
         *
         * Encrypt your secret using the [rbnacl](https://github.com/RubyCrypto/rbnacl) gem.
         */
        createOrUpdateSecretForRepo: {
            (params?: RequestParameters & ActionsCreateOrUpdateSecretForRepoParams): Promise<AnyResponse>;
            endpoint: EndpointInterface;
        };
        /**
         * Returns a token that you can pass to the `config` script. The token expires after one hour. Anyone with admin access to the repository can use this endpoint. GitHub Apps must have the `administration` permission to use this endpoint.
         *
         * Configure your self-hosted runner, replacing TOKEN with the registration token provided by this endpoint.
         */
        createRegistrationToken: {
            (params?: RequestParameters & ActionsCreateRegistrationTokenParams): Promise<OctokitResponse<ActionsCreateRegistrationTokenResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * Returns a token that you can pass to remove a self-hosted runner from a repository. The token expires after one hour. Anyone with admin access to the repository can use this endpoint. GitHub Apps must have the `administration` permission to use this endpoint.
         *
         * Remove your self-hosted runner from a repository, replacing TOKEN with the remove token provided by this endpoint.
         */
        createRemoveToken: {
            (params?: RequestParameters & ActionsCreateRemoveTokenParams): Promise<OctokitResponse<ActionsCreateRemoveTokenResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * Deletes an artifact for a workflow run. Anyone with write access to the repository can use this endpoint. GitHub Apps must have the `actions` permission to use this endpoint.
         */
        deleteArtifact: {
            (params?: RequestParameters & ActionsDeleteArtifactParams): Promise<AnyResponse>;
            endpoint: EndpointInterface;
        };
        /**
         * Deletes a secret in a repository using the secret name. Anyone with write access to the repository can use this endpoint. GitHub Apps must have the `secrets` permission to use this endpoint.
         */
        deleteSecretFromRepo: {
            (params?: RequestParameters & ActionsDeleteSecretFromRepoParams): Promise<AnyResponse>;
            endpoint: EndpointInterface;
        };
        /**
         * Gets a redirect URL to download an archive for a repository. This URL expires after 1 minute. Look for `Location:` in the response header to find the URL for the download. The `:archive_format` must be `zip`. Anyone with read access to the repository can use this endpoint. GitHub Apps must have the `actions` permission to use this endpoint.
         *
         * Call this endpoint using the `-v` flag, which enables verbose output and allows you to see the download URL in the header. To download the file into the current working directory, specify the filename using the `-o` flag.
         */
        downloadArtifact: {
            (params?: RequestParameters & ActionsDownloadArtifactParams): Promise<AnyResponse>;
            endpoint: EndpointInterface;
        };
        /**
         * Gets a specific artifact for a workflow run. Anyone with read access to the repository can use this endpoint. GitHub Apps must have the `actions` permission to use this endpoint.
         */
        getArtifact: {
            (params?: RequestParameters & ActionsGetArtifactParams): Promise<OctokitResponse<ActionsGetArtifactResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * Gets your public key, which you must store. You need your public key to use other secrets endpoints. Use the returned `key` to encrypt your secrets. Anyone with read access to the repository can use this endpoint. GitHub Apps must have the `secrets` permission to use this endpoint.
         */
        getPublicKey: {
            (params?: RequestParameters & ActionsGetPublicKeyParams): Promise<OctokitResponse<ActionsGetPublicKeyResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * Gets a single secret without revealing its encrypted value. Anyone with write access to the repository can use this endpoint. GitHub Apps must have the `secrets` permission to use this endpoint.
         */
        getSecret: {
            (params?: RequestParameters & ActionsGetSecretParams): Promise<OctokitResponse<ActionsGetSecretResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * Gets a specific self-hosted runner. Anyone with admin access to the repository can use this endpoint. GitHub Apps must have the `administration` permission to use this endpoint.
         */
        getSelfHostedRunner: {
            (params?: RequestParameters & ActionsGetSelfHostedRunnerParams): Promise<OctokitResponse<ActionsGetSelfHostedRunnerResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * Gets a specific workflow. You can also replace `:workflow_id` with `:workflow_file_name`. For example, you could use `main.yml`. Anyone with read access to the repository can use this endpoint. GitHub Apps must have the `actions` permission to use this endpoint.
         */
        getWorkflow: {
            (params?: RequestParameters & ActionsGetWorkflowParams): Promise<OctokitResponse<ActionsGetWorkflowResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * Gets a specific job in a workflow run. Anyone with read access to the repository can use this endpoint. GitHub Apps must have the `actions` permission to use this endpoint.
         */
        getWorkflowJob: {
            (params?: RequestParameters & ActionsGetWorkflowJobParams): Promise<OctokitResponse<ActionsGetWorkflowJobResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * Gets a specific workflow run. Anyone with read access to the repository can use this endpoint. GitHub Apps must have the `actions` permission to use this endpoint.
         */
        getWorkflowRun: {
            (params?: RequestParameters & ActionsGetWorkflowRunParams): Promise<OctokitResponse<ActionsGetWorkflowRunResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * Lists binaries for the self-hosted runner application that you can download and run. Anyone with admin access to the repository can use this endpoint. GitHub Apps must have the `administration` permission to use this endpoint.
         */
        listDownloadsForSelfHostedRunnerApplication: {
            (params?: RequestParameters & ActionsListDownloadsForSelfHostedRunnerApplicationParams): Promise<OctokitResponse<ActionsListDownloadsForSelfHostedRunnerApplicationResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * Lists jobs for a workflow run. Anyone with read access to the repository can use this endpoint. GitHub Apps must have the `actions` permission to use this endpoint.
         */
        listJobsForWorkflowRun: {
            (params?: RequestParameters & ActionsListJobsForWorkflowRunParams): Promise<OctokitResponse<ActionsListJobsForWorkflowRunResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * Lists all workflow runs for a repository. You can use parameters to narrow the list of results. For more information about using parameters, see [Parameters](https://developer.github.com/v3/#parameters).
         *
         * Anyone with read access to the repository can use this endpoint. GitHub Apps must have the `actions` permission to use this endpoint.
         */
        listRepoWorkflowRuns: {
            (params?: RequestParameters & ActionsListRepoWorkflowRunsParams): Promise<OctokitResponse<ActionsListRepoWorkflowRunsResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * Lists the workflows in a repository. Anyone with read access to the repository can use this endpoint. GitHub Apps must have the `actions` permission to use this endpoint.
         */
        listRepoWorkflows: {
            (params?: RequestParameters & ActionsListRepoWorkflowsParams): Promise<OctokitResponse<ActionsListRepoWorkflowsResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * Lists all secrets available in a repository without revealing their encrypted values. Anyone with write access to the repository can use this endpoint. GitHub Apps must have the `secrets` permission to use this endpoint.
         */
        listSecretsForRepo: {
            (params?: RequestParameters & ActionsListSecretsForRepoParams): Promise<OctokitResponse<ActionsListSecretsForRepoResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * Lists all self-hosted runners for a repository. Anyone with admin access to the repository can use this endpoint. GitHub Apps must have the `administration` permission to use this endpoint.
         */
        listSelfHostedRunnersForRepo: {
            (params?: RequestParameters & ActionsListSelfHostedRunnersForRepoParams): Promise<OctokitResponse<ActionsListSelfHostedRunnersForRepoResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * Gets a redirect URL to download a plain text file of logs for a workflow job. This link expires after 1 minute. Look for `Location:` in the response header to find the URL for the download. Anyone with read access to the repository can use this endpoint. GitHub Apps must have the `actions` permission to use this endpoint.
         *
         * Call this endpoint using the `-v` flag, which enables verbose output and allows you to see the download URL in the header. To download the file into the current working directory, specify the filename using the `-o` flag.
         */
        listWorkflowJobLogs: {
            (params?: RequestParameters & ActionsListWorkflowJobLogsParams): Promise<AnyResponse>;
            endpoint: EndpointInterface;
        };
        /**
         * Lists artifacts for a workflow run. Anyone with read access to the repository can use this endpoint. GitHub Apps must have the `actions` permission to use this endpoint.
         */
        listWorkflowRunArtifacts: {
            (params?: RequestParameters & ActionsListWorkflowRunArtifactsParams): Promise<OctokitResponse<ActionsListWorkflowRunArtifactsResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * Gets a redirect URL to download an archive of log files for a workflow run. This link expires after 1 minute. Look for `Location:` in the response header to find the URL for the download. Anyone with read access to the repository can use this endpoint. GitHub Apps must have the `actions` permission to use this endpoint.
         *
         * Call this endpoint using the `-v` flag, which enables verbose output and allows you to see the download URL in the header. To download the file into the current working directory, specify the filename using the `-o` flag.
         */
        listWorkflowRunLogs: {
            (params?: RequestParameters & ActionsListWorkflowRunLogsParams): Promise<AnyResponse>;
            endpoint: EndpointInterface;
        };
        /**
         * List all workflow runs for a workflow. You can also replace `:workflow_id` with `:workflow_file_name`. For example, you could use `main.yml`. You can use parameters to narrow the list of results. For more information about using parameters, see [Parameters](https://developer.github.com/v3/#parameters).
         *
         * Anyone with read access to the repository can use this endpoint.
         */
        listWorkflowRuns: {
            (params?: RequestParameters & ActionsListWorkflowRunsParams): Promise<OctokitResponse<ActionsListWorkflowRunsResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * Re-runs your workflow run using its `id`. Anyone with write access to the repository can use this endpoint. GitHub Apps must have the `actions` permission to use this endpoint.
         */
        reRunWorkflow: {
            (params?: RequestParameters & ActionsReRunWorkflowParams): Promise<AnyResponse>;
            endpoint: EndpointInterface;
        };
        /**
         * Forces the removal of a self-hosted runner from a repository. You can use this endpoint to completely remove the runner when the machine you were using no longer exists. Anyone with admin access to the repository can use this endpoint. GitHub Apps must have the `administration` permission to use this endpoint.
         */
        removeSelfHostedRunner: {
            (params?: RequestParameters & ActionsRemoveSelfHostedRunnerParams): Promise<AnyResponse>;
            endpoint: EndpointInterface;
        };
    };
    activity: {
        /**
         * Requires for the user to be authenticated.
         */
        checkStarringRepo: {
            (params?: RequestParameters & ActivityCheckStarringRepoParams): Promise<AnyResponse>;
            endpoint: EndpointInterface;
        };
        /**
         * Requires for the user to be authenticated.
         */
        checkWatchingRepoLegacy: {
            (params?: RequestParameters & ActivityCheckWatchingRepoLegacyParams): Promise<AnyResponse>;
            endpoint: EndpointInterface;
        };
        /**
         * This endpoint should only be used to stop watching a repository. To control whether or not you wish to receive notifications from a repository, [set the repository's subscription manually](https://developer.github.com/v3/activity/watching/#set-a-repository-subscription).
         */
        deleteRepoSubscription: {
            (params?: RequestParameters & ActivityDeleteRepoSubscriptionParams): Promise<AnyResponse>;
            endpoint: EndpointInterface;
        };
        /**
         * Mutes all future notifications for a conversation until you comment on the thread or get **@mention**ed.
         */
        deleteThreadSubscription: {
            (params?: RequestParameters & ActivityDeleteThreadSubscriptionParams): Promise<AnyResponse>;
            endpoint: EndpointInterface;
        };
        getRepoSubscription: {
            (params?: RequestParameters & ActivityGetRepoSubscriptionParams): Promise<OctokitResponse<ActivityGetRepoSubscriptionResponse>>;
            endpoint: EndpointInterface;
        };
        getThread: {
            (params?: RequestParameters & ActivityGetThreadParams): Promise<OctokitResponse<ActivityGetThreadResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * This checks to see if the current user is subscribed to a thread. You can also [get a repository subscription](https://developer.github.com/v3/activity/watching/#get-a-repository-subscription).
         *
         * Note that subscriptions are only generated if a user is participating in a conversation--for example, they've replied to the thread, were **@mentioned**, or manually subscribe to a thread.
         */
        getThreadSubscription: {
            (params?: RequestParameters & ActivityGetThreadSubscriptionParams): Promise<OctokitResponse<ActivityGetThreadSubscriptionResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * This is the user's organization dashboard. You must be authenticated as the user to view this.
         */
        listEventsForOrg: {
            (params?: RequestParameters & ActivityListEventsForOrgParams): Promise<AnyResponse>;
            endpoint: EndpointInterface;
        };
        /**
         * If you are authenticated as the given user, you will see your private events. Otherwise, you'll only see public events.
         */
        listEventsForUser: {
            (params?: RequestParameters & ActivityListEventsForUserParams): Promise<AnyResponse>;
            endpoint: EndpointInterface;
        };
        /**
         * GitHub provides several timeline resources in [Atom](http://en.wikipedia.org/wiki/Atom_(standard)) format. The Feeds API lists all the feeds available to the authenticated user:
         *
         * *   **Timeline**: The GitHub global public timeline
         * *   **User**: The public timeline for any user, using [URI template](https://developer.github.com/v3/#hypermedia)
         * *   **Current user public**: The public timeline for the authenticated user
         * *   **Current user**: The private timeline for the authenticated user
         * *   **Current user actor**: The private timeline for activity created by the authenticated user
         * *   **Current user organizations**: The private timeline for the organizations the authenticated user is a member of.
         * *   **Security advisories**: A collection of public announcements that provide information about security-related vulnerabilities in software on GitHub.
         *
         * **Note**: Private feeds are only returned when [authenticating via Basic Auth](https://developer.github.com/v3/#basic-authentication) since current feed URIs use the older, non revocable auth tokens.
         */
        listFeeds: {
            (params?: RequestParameters & EmptyParams): Promise<OctokitResponse<ActivityListFeedsResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * List all notifications for the current user, sorted by most recently updated.
         *
         * The following example uses the `since` parameter to list notifications that have been updated after the specified time.
         */
        listNotifications: {
            (params?: RequestParameters & ActivityListNotificationsParams): Promise<OctokitResponse<ActivityListNotificationsResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * List all notifications for the current user.
         */
        listNotificationsForRepo: {
            (params?: RequestParameters & ActivityListNotificationsForRepoParams): Promise<OctokitResponse<ActivityListNotificationsForRepoResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * We delay the public events feed by five minutes, which means the most recent event returned by the public events API actually occurred at least five minutes ago.
         */
        listPublicEvents: {
            (params?: RequestParameters & ActivityListPublicEventsParams): Promise<AnyResponse>;
            endpoint: EndpointInterface;
        };
        listPublicEventsForOrg: {
            (params?: RequestParameters & ActivityListPublicEventsForOrgParams): Promise<AnyResponse>;
            endpoint: EndpointInterface;
        };
        listPublicEventsForRepoNetwork: {
            (params?: RequestParameters & ActivityListPublicEventsForRepoNetworkParams): Promise<AnyResponse>;
            endpoint: EndpointInterface;
        };
        listPublicEventsForUser: {
            (params?: RequestParameters & ActivityListPublicEventsForUserParams): Promise<AnyResponse>;
            endpoint: EndpointInterface;
        };
        /**
         * These are events that you've received by watching repos and following users. If you are authenticated as the given user, you will see private events. Otherwise, you'll only see public events.
         */
        listReceivedEventsForUser: {
            (params?: RequestParameters & ActivityListReceivedEventsForUserParams): Promise<AnyResponse>;
            endpoint: EndpointInterface;
        };
        listReceivedPublicEventsForUser: {
            (params?: RequestParameters & ActivityListReceivedPublicEventsForUserParams): Promise<AnyResponse>;
            endpoint: EndpointInterface;
        };
        listRepoEvents: {
            (params?: RequestParameters & ActivityListRepoEventsParams): Promise<AnyResponse>;
            endpoint: EndpointInterface;
        };
        /**
         * You can also find out _when_ stars were created by passing the following custom [media type](https://developer.github.com/v3/media/) via the `Accept` header:
         */
        listReposStarredByAuthenticatedUser: {
            (params?: RequestParameters & ActivityListReposStarredByAuthenticatedUserParams): Promise<OctokitResponse<ActivityListReposStarredByAuthenticatedUserResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * You can also find out _when_ stars were created by passing the following custom [media type](https://developer.github.com/v3/media/) via the `Accept` header:
         */
        listReposStarredByUser: {
            (params?: RequestParameters & ActivityListReposStarredByUserParams): Promise<OctokitResponse<ActivityListReposStarredByUserResponse>>;
            endpoint: EndpointInterface;
        };
        listReposWatchedByUser: {
            (params?: RequestParameters & ActivityListReposWatchedByUserParams): Promise<OctokitResponse<ActivityListReposWatchedByUserResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * You can also find out _when_ stars were created by passing the following custom [media type](https://developer.github.com/v3/media/) via the `Accept` header:
         */
        listStargazersForRepo: {
            (params?: RequestParameters & ActivityListStargazersForRepoParams): Promise<OctokitResponse<ActivityListStargazersForRepoResponse>>;
            endpoint: EndpointInterface;
        };
        listWatchedReposForAuthenticatedUser: {
            (params?: RequestParameters & ActivityListWatchedReposForAuthenticatedUserParams): Promise<OctokitResponse<ActivityListWatchedReposForAuthenticatedUserResponse>>;
            endpoint: EndpointInterface;
        };
        listWatchersForRepo: {
            (params?: RequestParameters & ActivityListWatchersForRepoParams): Promise<OctokitResponse<ActivityListWatchersForRepoResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * Marks a notification as "read" removes it from the [default view on GitHub](https://github.com/notifications). If the number of notifications is too large to complete in one request, you will receive a `202 Accepted` status and GitHub will run an asynchronous process to mark notifications as "read." To check whether any "unread" notifications remain, you can use the [List your notifications](https://developer.github.com/v3/activity/notifications/#list-your-notifications) endpoint and pass the query parameter `all=false`.
         */
        markAsRead: {
            (params?: RequestParameters & ActivityMarkAsReadParams): Promise<AnyResponse>;
            endpoint: EndpointInterface;
        };
        /**
         * Marks all notifications in a repository as "read" removes them from the [default view on GitHub](https://github.com/notifications). If the number of notifications is too large to complete in one request, you will receive a `202 Accepted` status and GitHub will run an asynchronous process to mark notifications as "read." To check whether any "unread" notifications remain, you can use the [List your notifications in a repository](https://developer.github.com/v3/activity/notifications/#list-your-notifications-in-a-repository) endpoint and pass the query parameter `all=false`.
         */
        markNotificationsAsReadForRepo: {
            (params?: RequestParameters & ActivityMarkNotificationsAsReadForRepoParams): Promise<AnyResponse>;
            endpoint: EndpointInterface;
        };
        markThreadAsRead: {
            (params?: RequestParameters & ActivityMarkThreadAsReadParams): Promise<AnyResponse>;
            endpoint: EndpointInterface;
        };
        /**
         * If you would like to watch a repository, set `subscribed` to `true`. If you would like to ignore notifications made within a repository, set `ignored` to `true`. If you would like to stop watching a repository, [delete the repository's subscription](https://developer.github.com/v3/activity/watching/#delete-a-repository-subscription) completely.
         */
        setRepoSubscription: {
            (params?: RequestParameters & ActivitySetRepoSubscriptionParams): Promise<OctokitResponse<ActivitySetRepoSubscriptionResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * This lets you subscribe or unsubscribe from a conversation.
         */
        setThreadSubscription: {
            (params?: RequestParameters & ActivitySetThreadSubscriptionParams): Promise<OctokitResponse<ActivitySetThreadSubscriptionResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * Requires for the user to be authenticated.
         *
         * Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://developer.github.com/v3/#http-verbs)."
         */
        starRepo: {
            (params?: RequestParameters & ActivityStarRepoParams): Promise<AnyResponse>;
            endpoint: EndpointInterface;
        };
        /**
         * Requires for the user to be authenticated.
         */
        stopWatchingRepoLegacy: {
            (params?: RequestParameters & ActivityStopWatchingRepoLegacyParams): Promise<AnyResponse>;
            endpoint: EndpointInterface;
        };
        /**
         * Requires for the user to be authenticated.
         */
        unstarRepo: {
            (params?: RequestParameters & ActivityUnstarRepoParams): Promise<AnyResponse>;
            endpoint: EndpointInterface;
        };
        /**
         * Requires the user to be authenticated.
         *
         * Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://developer.github.com/v3/#http-verbs)."
         */
        watchRepoLegacy: {
            (params?: RequestParameters & ActivityWatchRepoLegacyParams): Promise<AnyResponse>;
            endpoint: EndpointInterface;
        };
    };
    apps: {
        /**
         * Add a single repository to an installation. The authenticated user must have admin access to the repository.
         *
         * You must use a personal access token (which you can create via the [command line](https://help.github.com/articles/creating-a-personal-access-token-for-the-command-line/) or the [OAuth Authorizations API](https://developer.github.com/v3/oauth_authorizations/#create-a-new-authorization)) or [Basic Authentication](https://developer.github.com/v3/auth/#basic-authentication) to access this endpoint.
         */
        addRepoToInstallation: {
            (params?: RequestParameters & AppsAddRepoToInstallationParams): Promise<AnyResponse>;
            endpoint: EndpointInterface;
        };
        /**
         * Shows whether the user or organization account actively subscribes to a plan listed by the authenticated GitHub App. When someone submits a plan change that won't be processed until the end of their billing cycle, you will also see the upcoming pending change.
         *
         * GitHub Apps must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://developer.github.com/v3/auth/#basic-authentication) with their client ID and client secret to access this endpoint.
         */
        checkAccountIsAssociatedWithAny: {
            (params?: RequestParameters & AppsCheckAccountIsAssociatedWithAnyParams): Promise<OctokitResponse<AppsCheckAccountIsAssociatedWithAnyResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * Shows whether the user or organization account actively subscribes to a plan listed by the authenticated GitHub App. When someone submits a plan change that won't be processed until the end of their billing cycle, you will also see the upcoming pending change.
         *
         * GitHub Apps must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://developer.github.com/v3/auth/#basic-authentication) with their client ID and client secret to access this endpoint.
         */
        checkAccountIsAssociatedWithAnyStubbed: {
            (params?: RequestParameters & AppsCheckAccountIsAssociatedWithAnyStubbedParams): Promise<OctokitResponse<AppsCheckAccountIsAssociatedWithAnyStubbedResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * **Deprecation Notice:** GitHub will replace and discontinue OAuth endpoints containing `access_token` in the path parameter. We are introducing new endpoints that allow you to securely manage tokens for OAuth Apps by using `access_token` as an input parameter. For more information, see the [blog post](https://developer.github.com/changes/2019-11-05-deprecated-passwords-and-authorizations-api).
         *
         * OAuth applications can use a special API method for checking OAuth token validity without exceeding the normal rate limits for failed login attempts. Authentication works differently with this particular endpoint. You must use [Basic Authentication](https://developer.github.com/v3/auth#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password. Invalid tokens will return `404 NOT FOUND`.
         * @deprecated octokit.apps.checkAuthorization() is deprecated, see https://developer.github.com/v3/apps/oauth_applications/#check-an-authorization
         */
        checkAuthorization: {
            (params?: RequestParameters & AppsCheckAuthorizationParams): Promise<OctokitResponse<AppsCheckAuthorizationResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * OAuth applications can use a special API method for checking OAuth token validity without exceeding the normal rate limits for failed login attempts. Authentication works differently with this particular endpoint. You must use [Basic Authentication](https://developer.github.com/v3/auth#basic-authentication) to use this endpoint, where the username is the OAuth application `client_id` and the password is its `client_secret`. Invalid tokens will return `404 NOT FOUND`.
         */
        checkToken: {
            (params?: RequestParameters & AppsCheckTokenParams): Promise<OctokitResponse<AppsCheckTokenResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * Creates an attachment under a content reference URL in the body or comment of an issue or pull request. Use the `id` of the content reference from the [`content_reference` event](https://developer.github.com/v3/activity/events/types/#contentreferenceevent) to create an attachment.
         *
         * The app must create a content attachment within six hours of the content reference URL being posted. See "[Using content attachments](https://developer.github.com/apps/using-content-attachments/)" for details about content attachments.
         *
         * You must use an [installation access token](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-an-installation) to access this endpoint.
         *
         * This example creates a content attachment for the domain `https://errors.ai/`.
         */
        createContentAttachment: {
            (params?: RequestParameters & AppsCreateContentAttachmentParams): Promise<OctokitResponse<AppsCreateContentAttachmentResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * Use this endpoint to complete the handshake necessary when implementing the [GitHub App Manifest flow](https://developer.github.com/apps/building-github-apps/creating-github-apps-from-a-manifest/). When you create a GitHub App with the manifest flow, you receive a temporary `code` used to retrieve the GitHub App's `id`, `pem` (private key), and `webhook_secret`.
         */
        createFromManifest: {
            (params?: RequestParameters & AppsCreateFromManifestParams): Promise<OctokitResponse<AppsCreateFromManifestResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * Creates an installation access token that enables a GitHub App to make authenticated API requests for the app's installation on an organization or individual account. Installation tokens expire one hour from the time you create them. Using an expired token produces a status code of `401 - Unauthorized`, and requires creating a new installation token. By default the installation token has access to all repositories that the installation can access. To restrict the access to specific repositories, you can provide the `repository_ids` when creating the token. When you omit `repository_ids`, the response does not contain the `repositories` key.
         *
         * You must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
         *
         * This example grants the token "Read and write" permission to `issues` and "Read" permission to `contents`, and restricts the token's access to the repository with an `id` of 1296269.
         */
        createInstallationToken: {
            (params?: RequestParameters & AppsCreateInstallationTokenParams): Promise<OctokitResponse<AppsCreateInstallationTokenResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * OAuth application owners can revoke a grant for their OAuth application and a specific user. You must use [Basic Authentication](https://developer.github.com/v3/auth#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password. You must also provide a valid OAuth `access_token` as an input parameter and the grant for the token's owner will be deleted.
         *
         * Deleting an OAuth application's grant will also delete all OAuth tokens associated with the application for the user. Once deleted, the application will have no access to the user's account and will no longer be listed on [the application authorizations settings screen within GitHub](https://github.com/settings/applications#authorized).
         */
        deleteAuthorization: {
            (params?: RequestParameters & AppsDeleteAuthorizationParams): Promise<AnyResponse>;
            endpoint: EndpointInterface;
        };
        /**
         * Uninstalls a GitHub App on a user, organization, or business account.
         *
         * You must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
         */
        deleteInstallation: {
            (params?: RequestParameters & AppsDeleteInstallationParams): Promise<AnyResponse>;
            endpoint: EndpointInterface;
        };
        /**
         * OAuth application owners can revoke a single token for an OAuth application. You must use [Basic Authentication](https://developer.github.com/v3/auth#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password.
         */
        deleteToken: {
            (params?: RequestParameters & AppsDeleteTokenParams): Promise<AnyResponse>;
            endpoint: EndpointInterface;
        };
        /**
         * Enables an authenticated GitHub App to find the organization's installation information.
         *
         * You must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
         * @deprecated octokit.apps.findOrgInstallation() has been renamed to octokit.apps.getOrgInstallation() (2019-04-10)
         */
        findOrgInstallation: {
            (params?: RequestParameters & AppsFindOrgInstallationParams): Promise<OctokitResponse<AppsFindOrgInstallationResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * Enables an authenticated GitHub App to find the repository's installation information. The installation's account type will be either an organization or a user account, depending which account the repository belongs to.
         *
         * You must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
         * @deprecated octokit.apps.findRepoInstallation() has been renamed to octokit.apps.getRepoInstallation() (2019-04-10)
         */
        findRepoInstallation: {
            (params?: RequestParameters & AppsFindRepoInstallationParams): Promise<OctokitResponse<AppsFindRepoInstallationResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * Enables an authenticated GitHub App to find the user’s installation information.
         *
         * You must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
         * @deprecated octokit.apps.findUserInstallation() has been renamed to octokit.apps.getUserInstallation() (2019-04-10)
         */
        findUserInstallation: {
            (params?: RequestParameters & AppsFindUserInstallationParams): Promise<OctokitResponse<AppsFindUserInstallationResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * Returns the GitHub App associated with the authentication credentials used. To see how many app installations are associated with this GitHub App, see the `installations_count` in the response. For more details about your app's installations, see the "[List installations](https://developer.github.com/v3/apps/#list-installations)" endpoint.
         *
         * You must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
         */
        getAuthenticated: {
            (params?: RequestParameters & EmptyParams): Promise<OctokitResponse<AppsGetAuthenticatedResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * **Note**: The `:app_slug` is just the URL-friendly name of your GitHub App. You can find this on the settings page for your GitHub App (e.g., `https://github.com/settings/apps/:app_slug`).
         *
         * If the GitHub App you specify is public, you can access this endpoint without authenticating. If the GitHub App you specify is private, you must authenticate with a [personal access token](https://help.github.com/articles/creating-a-personal-access-token-for-the-command-line/) or an [installation access token](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-an-installation) to access this endpoint.
         */
        getBySlug: {
            (params?: RequestParameters & AppsGetBySlugParams): Promise<OctokitResponse<AppsGetBySlugResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * You must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
         */
        getInstallation: {
            (params?: RequestParameters & AppsGetInstallationParams): Promise<OctokitResponse<AppsGetInstallationResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * Enables an authenticated GitHub App to find the organization's installation information.
         *
         * You must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
         */
        getOrgInstallation: {
            (params?: RequestParameters & AppsGetOrgInstallationParams): Promise<OctokitResponse<AppsGetOrgInstallationResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * Enables an authenticated GitHub App to find the repository's installation information. The installation's account type will be either an organization or a user account, depending which account the repository belongs to.
         *
         * You must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
         */
        getRepoInstallation: {
            (params?: RequestParameters & AppsGetRepoInstallationParams): Promise<OctokitResponse<AppsGetRepoInstallationResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * Enables an authenticated GitHub App to find the user’s installation information.
         *
         * You must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
         */
        getUserInstallation: {
            (params?: RequestParameters & AppsGetUserInstallationParams): Promise<OctokitResponse<AppsGetUserInstallationResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * Returns any accounts associated with a plan, including free plans. For per-seat pricing, you see the list of accounts that have purchased the plan, including the number of seats purchased. When someone submits a plan change that won't be processed until the end of their billing cycle, you will also see the upcoming pending change.
         *
         * GitHub Apps must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://developer.github.com/v3/auth/#basic-authentication) with their client ID and client secret to access this endpoint.
         */
        listAccountsUserOrOrgOnPlan: {
            (params?: RequestParameters & AppsListAccountsUserOrOrgOnPlanParams): Promise<OctokitResponse<AppsListAccountsUserOrOrgOnPlanResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * Returns any accounts associated with a plan, including free plans. For per-seat pricing, you see the list of accounts that have purchased the plan, including the number of seats purchased. When someone submits a plan change that won't be processed until the end of their billing cycle, you will also see the upcoming pending change.
         *
         * GitHub Apps must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://developer.github.com/v3/auth/#basic-authentication) with their client ID and client secret to access this endpoint.
         */
        listAccountsUserOrOrgOnPlanStubbed: {
            (params?: RequestParameters & AppsListAccountsUserOrOrgOnPlanStubbedParams): Promise<OctokitResponse<AppsListAccountsUserOrOrgOnPlanStubbedResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * List repositories that the authenticated user has explicit permission (`:read`, `:write`, or `:admin`) to access for an installation.
         *
         * The authenticated user has explicit permission to access repositories they own, repositories where they are a collaborator, and repositories that they can access through an organization membership.
         *
         * You must use a [user-to-server OAuth access token](https://developer.github.com/apps/building-github-apps/identifying-and-authorizing-users-for-github-apps/#identifying-users-on-your-site), created for a user who has authorized your GitHub App, to access this endpoint.
         *
         * The access the user has to each repository is included in the hash under the `permissions` key.
         */
        listInstallationReposForAuthenticatedUser: {
            (params?: RequestParameters & AppsListInstallationReposForAuthenticatedUserParams): Promise<OctokitResponse<AppsListInstallationReposForAuthenticatedUserResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * You must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
         *
         * The permissions the installation has are included under the `permissions` key.
         */
        listInstallations: {
            (params?: RequestParameters & AppsListInstallationsParams): Promise<OctokitResponse<AppsListInstallationsResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * Lists installations of your GitHub App that the authenticated user has explicit permission (`:read`, `:write`, or `:admin`) to access.
         *
         * You must use a [user-to-server OAuth access token](https://developer.github.com/apps/building-github-apps/identifying-and-authorizing-users-for-github-apps/#identifying-users-on-your-site), created for a user who has authorized your GitHub App, to access this endpoint.
         *
         * The authenticated user has explicit permission to access repositories they own, repositories where they are a collaborator, and repositories that they can access through an organization membership.
         *
         * You can find the permissions for the installation under the `permissions` key.
         */
        listInstallationsForAuthenticatedUser: {
            (params?: RequestParameters & AppsListInstallationsForAuthenticatedUserParams): Promise<OctokitResponse<AppsListInstallationsForAuthenticatedUserResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * Returns only active subscriptions. You must use a [user-to-server OAuth access token](https://developer.github.com/apps/building-github-apps/identifying-and-authorizing-users-for-github-apps/#identifying-users-on-your-site), created for a user who has authorized your GitHub App, to access this endpoint. . OAuth Apps must authenticate using an [OAuth token](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/).
         */
        listMarketplacePurchasesForAuthenticatedUser: {
            (params?: RequestParameters & AppsListMarketplacePurchasesForAuthenticatedUserParams): Promise<OctokitResponse<AppsListMarketplacePurchasesForAuthenticatedUserResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * Returns only active subscriptions. You must use a [user-to-server OAuth access token](https://developer.github.com/apps/building-github-apps/identifying-and-authorizing-users-for-github-apps/#identifying-users-on-your-site), created for a user who has authorized your GitHub App, to access this endpoint. . OAuth Apps must authenticate using an [OAuth token](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/).
         */
        listMarketplacePurchasesForAuthenticatedUserStubbed: {
            (params?: RequestParameters & AppsListMarketplacePurchasesForAuthenticatedUserStubbedParams): Promise<OctokitResponse<AppsListMarketplacePurchasesForAuthenticatedUserStubbedResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * GitHub Apps must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://developer.github.com/v3/auth/#basic-authentication) with their client ID and client secret to access this endpoint.
         */
        listPlans: {
            (params?: RequestParameters & AppsListPlansParams): Promise<OctokitResponse<AppsListPlansResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * GitHub Apps must use a [JWT](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://developer.github.com/v3/auth/#basic-authentication) with their client ID and client secret to access this endpoint.
         */
        listPlansStubbed: {
            (params?: RequestParameters & AppsListPlansStubbedParams): Promise<OctokitResponse<AppsListPlansStubbedResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * List repositories that an installation can access.
         *
         * You must use an [installation access token](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-an-installation) to access this endpoint.
         */
        listRepos: {
            (params?: RequestParameters & AppsListReposParams): Promise<OctokitResponse<AppsListReposResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * Remove a single repository from an installation. The authenticated user must have admin access to the repository.
         *
         * You must use a personal access token (which you can create via the [command line](https://help.github.com/articles/creating-a-personal-access-token-for-the-command-line/) or the [OAuth Authorizations API](https://developer.github.com/v3/oauth_authorizations/#create-a-new-authorization)) or [Basic Authentication](https://developer.github.com/v3/auth/#basic-authentication) to access this endpoint.
         */
        removeRepoFromInstallation: {
            (params?: RequestParameters & AppsRemoveRepoFromInstallationParams): Promise<AnyResponse>;
            endpoint: EndpointInterface;
        };
        /**
         * **Deprecation Notice:** GitHub will replace and discontinue OAuth endpoints containing `access_token` in the path parameter. We are introducing new endpoints that allow you to securely manage tokens for OAuth Apps by using `access_token` as an input parameter. For more information, see the [blog post](https://developer.github.com/changes/2019-11-05-deprecated-passwords-and-authorizations-api).
         *
         * OAuth applications can use this API method to reset a valid OAuth token without end-user involvement. Applications must save the "token" property in the response because changes take effect immediately. You must use [Basic Authentication](https://developer.github.com/v3/auth#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password. Invalid tokens will return `404 NOT FOUND`.
         * @deprecated octokit.apps.resetAuthorization() is deprecated, see https://developer.github.com/v3/apps/oauth_applications/#reset-an-authorization
         */
        resetAuthorization: {
            (params?: RequestParameters & AppsResetAuthorizationParams): Promise<OctokitResponse<AppsResetAuthorizationResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * OAuth applications can use this API method to reset a valid OAuth token without end-user involvement. Applications must save the "token" property in the response because changes take effect immediately. You must use [Basic Authentication](https://developer.github.com/v3/auth#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password. Invalid tokens will return `404 NOT FOUND`.
         */
        resetToken: {
            (params?: RequestParameters & AppsResetTokenParams): Promise<OctokitResponse<AppsResetTokenResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * **Deprecation Notice:** GitHub will replace and discontinue OAuth endpoints containing `access_token` in the path parameter. We are introducing new endpoints that allow you to securely manage tokens for OAuth Apps by using `access_token` as an input parameter. For more information, see the [blog post](https://developer.github.com/changes/2019-11-05-deprecated-passwords-and-authorizations-api).
         *
         * OAuth application owners can revoke a single token for an OAuth application. You must use [Basic Authentication](https://developer.github.com/v3/auth#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password.
         * @deprecated octokit.apps.revokeAuthorizationForApplication() is deprecated, see https://developer.github.com/v3/apps/oauth_applications/#revoke-an-authorization-for-an-application
         */
        revokeAuthorizationForApplication: {
            (params?: RequestParameters & AppsRevokeAuthorizationForApplicationParams): Promise<AnyResponse>;
            endpoint: EndpointInterface;
        };
        /**
         * **Deprecation Notice:** GitHub will replace and discontinue OAuth endpoints containing `access_token` in the path parameter. We are introducing new endpoints that allow you to securely manage tokens for OAuth Apps by using `access_token` as an input parameter. For more information, see the [blog post](https://developer.github.com/changes/2019-11-05-deprecated-passwords-and-authorizations-api).
         *
         * OAuth application owners can revoke a grant for their OAuth application and a specific user. You must use [Basic Authentication](https://developer.github.com/v3/auth#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password. You must also provide a valid token as `:access_token` and the grant for the token's owner will be deleted.
         *
         * Deleting an OAuth application's grant will also delete all OAuth tokens associated with the application for the user. Once deleted, the application will have no access to the user's account and will no longer be listed on [the Applications settings page under "Authorized OAuth Apps" on GitHub](https://github.com/settings/applications#authorized).
         * @deprecated octokit.apps.revokeGrantForApplication() is deprecated, see https://developer.github.com/v3/apps/oauth_applications/#revoke-a-grant-for-an-application
         */
        revokeGrantForApplication: {
            (params?: RequestParameters & AppsRevokeGrantForApplicationParams): Promise<AnyResponse>;
            endpoint: EndpointInterface;
        };
        /**
         * Revokes the installation token you're using to authenticate as an installation and access this endpoint.
         *
         * Once an installation token is revoked, the token is invalidated and cannot be used. Other endpoints that require the revoked installation token must have a new installation token to work. You can create a new token using the "[Create a new installation token](https://developer.github.com/v3/apps/#create-a-new-installation-token)" endpoint.
         *
         * You must use an [installation access token](https://developer.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-an-installation) to access this endpoint.
         */
        revokeInstallationToken: {
            (params?: RequestParameters & EmptyParams): Promise<AnyResponse>;
            endpoint: EndpointInterface;
        };
    };
    checks: {
        /**
         * **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
         *
         * Creates a new check run for a specific commit in a repository. Your GitHub App must have the `checks:write` permission to create check runs.
         */
        create: {
            (params?: RequestParameters & ChecksCreateParams): Promise<OctokitResponse<ChecksCreateResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array and a `null` value for `head_branch`.
         *
         * By default, check suites are automatically created when you create a [check run](https://developer.github.com/v3/checks/runs/). You only need to use this endpoint for manually creating check suites when you've disabled automatic creation using "[Set preferences for check suites on a repository](https://developer.github.com/v3/checks/suites/#set-preferences-for-check-suites-on-a-repository)". Your GitHub App must have the `checks:write` permission to create check suites.
         */
        createSuite: {
            (params?: RequestParameters & ChecksCreateSuiteParams): Promise<OctokitResponse<ChecksCreateSuiteResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
         *
         * Gets a single check run using its `id`. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to get check runs. OAuth Apps and authenticated users must have the `repo` scope to get check runs in a private repository.
         */
        get: {
            (params?: RequestParameters & ChecksGetParams): Promise<OctokitResponse<ChecksGetResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array and a `null` value for `head_branch`.
         *
         * Gets a single check suite using its `id`. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to get check suites. OAuth Apps and authenticated users must have the `repo` scope to get check suites in a private repository.
         */
        getSuite: {
            (params?: RequestParameters & ChecksGetSuiteParams): Promise<OctokitResponse<ChecksGetSuiteResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * Lists annotations for a check run using the annotation `id`. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to get annotations for a check run. OAuth Apps and authenticated users must have the `repo` scope to get annotations for a check run in a private repository.
         */
        listAnnotations: {
            (params?: RequestParameters & ChecksListAnnotationsParams): Promise<OctokitResponse<ChecksListAnnotationsResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
         *
         * Lists check runs for a commit ref. The `ref` can be a SHA, branch name, or a tag name. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to get check runs. OAuth Apps and authenticated users must have the `repo` scope to get check runs in a private repository.
         */
        listForRef: {
            (params?: RequestParameters & ChecksListForRefParams): Promise<OctokitResponse<ChecksListForRefResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
         *
         * Lists check runs for a check suite using its `id`. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to get check runs. OAuth Apps and authenticated users must have the `repo` scope to get check runs in a private repository.
         */
        listForSuite: {
            (params?: RequestParameters & ChecksListForSuiteParams): Promise<OctokitResponse<ChecksListForSuiteResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array and a `null` value for `head_branch`.
         *
         * Lists check suites for a commit `ref`. The `ref` can be a SHA, branch name, or a tag name. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to list check suites. OAuth Apps and authenticated users must have the `repo` scope to get check suites in a private repository.
         */
        listSuitesForRef: {
            (params?: RequestParameters & ChecksListSuitesForRefParams): Promise<OctokitResponse<ChecksListSuitesForRefResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * Triggers GitHub to rerequest an existing check suite, without pushing new code to a repository. This endpoint will trigger the [`check_suite` webhook](https://developer.github.com/v3/activity/events/types/#checksuiteevent) event with the action `rerequested`. When a check suite is `rerequested`, its `status` is reset to `queued` and the `conclusion` is cleared.
         *
         * To rerequest a check suite, your GitHub App must have the `checks:read` permission on a private repository or pull access to a public repository.
         */
        rerequestSuite: {
            (params?: RequestParameters & ChecksRerequestSuiteParams): Promise<AnyResponse>;
            endpoint: EndpointInterface;
        };
        /**
         * Changes the default automatic flow when creating check suites. By default, the CheckSuiteEvent is automatically created each time code is pushed to a repository. When you disable the automatic creation of check suites, you can manually [Create a check suite](https://developer.github.com/v3/checks/suites/#create-a-check-suite). You must have admin permissions in the repository to set preferences for check suites.
         */
        setSuitesPreferences: {
            (params?: RequestParameters & ChecksSetSuitesPreferencesParams): Promise<OctokitResponse<ChecksSetSuitesPreferencesResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
         *
         * Updates a check run for a specific commit in a repository. Your GitHub App must have the `checks:write` permission to edit check runs.
         */
        update: {
            (params?: RequestParameters & ChecksUpdateParams): Promise<OctokitResponse<ChecksUpdateResponse>>;
            endpoint: EndpointInterface;
        };
    };
    codesOfConduct: {
        getConductCode: {
            (params?: RequestParameters & CodesOfConductGetConductCodeParams): Promise<OctokitResponse<CodesOfConductGetConductCodeResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * This method returns the contents of the repository's code of conduct file, if one is detected.
         */
        getForRepo: {
            (params?: RequestParameters & CodesOfConductGetForRepoParams): Promise<OctokitResponse<CodesOfConductGetForRepoResponse>>;
            endpoint: EndpointInterface;
        };
        listConductCodes: {
            (params?: RequestParameters & EmptyParams): Promise<OctokitResponse<CodesOfConductListConductCodesResponse>>;
            endpoint: EndpointInterface;
        };
    };
    emojis: {
        /**
         * Lists all the emojis available to use on GitHub.
         */
        get: {
            (params?: RequestParameters & EmptyParams): Promise<AnyResponse>;
            endpoint: EndpointInterface;
        };
    };
    gists: {
        checkIsStarred: {
            (params?: RequestParameters & GistsCheckIsStarredParams): Promise<AnyResponse>;
            endpoint: EndpointInterface;
        };
        /**
         * Allows you to add a new gist with one or more files.
         *
         * **Note:** Don't name your files "gistfile" with a numerical suffix. This is the format of the automatic naming scheme that Gist uses internally.
         */
        create: {
            (params?: RequestParameters & GistsCreateParams): Promise<OctokitResponse<GistsCreateResponse>>;
            endpoint: EndpointInterface;
        };
        createComment: {
            (params?: RequestParameters & GistsCreateCommentParams): Promise<OctokitResponse<GistsCreateCommentResponse>>;
            endpoint: EndpointInterface;
        };
        delete: {
            (params?: RequestParameters & GistsDeleteParams): Promise<AnyResponse>;
            endpoint: EndpointInterface;
        };
        deleteComment: {
            (params?: RequestParameters & GistsDeleteCommentParams): Promise<AnyResponse>;
            endpoint: EndpointInterface;
        };
        /**
         * **Note**: This was previously `/gists/:gist_id/fork`.
         */
        fork: {
            (params?: RequestParameters & GistsForkParams): Promise<OctokitResponse<GistsForkResponse>>;
            endpoint: EndpointInterface;
        };
        get: {
            (params?: RequestParameters & GistsGetParams): Promise<OctokitResponse<GistsGetResponse>>;
            endpoint: EndpointInterface;
        };
        getComment: {
            (params?: RequestParameters & GistsGetCommentParams): Promise<OctokitResponse<GistsGetCommentResponse>>;
            endpoint: EndpointInterface;
        };
        getRevision: {
            (params?: RequestParameters & GistsGetRevisionParams): Promise<OctokitResponse<GistsGetRevisionResponse>>;
            endpoint: EndpointInterface;
        };
        list: {
            (params?: RequestParameters & GistsListParams): Promise<OctokitResponse<GistsListResponse>>;
            endpoint: EndpointInterface;
        };
        listComments: {
            (params?: RequestParameters & GistsListCommentsParams): Promise<OctokitResponse<GistsListCommentsResponse>>;
            endpoint: EndpointInterface;
        };
        listCommits: {
            (params?: RequestParameters & GistsListCommitsParams): Promise<OctokitResponse<GistsListCommitsResponse>>;
            endpoint: EndpointInterface;
        };
        listForks: {
            (params?: RequestParameters & GistsListForksParams): Promise<OctokitResponse<GistsListForksResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * List all public gists sorted by most recently updated to least recently updated.
         *
         * Note: With [pagination](https://developer.github.com/v3/#pagination), you can fetch up to 3000 gists. For example, you can fetch 100 pages with 30 gists per page or 30 pages with 100 gists per page.
         */
        listPublic: {
            (params?: RequestParameters & GistsListPublicParams): Promise<OctokitResponse<GistsListPublicResponse>>;
            endpoint: EndpointInterface;
        };
        listPublicForUser: {
            (params?: RequestParameters & GistsListPublicForUserParams): Promise<OctokitResponse<GistsListPublicForUserResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * List the authenticated user's starred gists:
         */
        listStarred: {
            (params?: RequestParameters & GistsListStarredParams): Promise<OctokitResponse<GistsListStarredResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://developer.github.com/v3/#http-verbs)."
         */
        star: {
            (params?: RequestParameters & GistsStarParams): Promise<AnyResponse>;
            endpoint: EndpointInterface;
        };
        unstar: {
            (params?: RequestParameters & GistsUnstarParams): Promise<AnyResponse>;
            endpoint: EndpointInterface;
        };
        /**
         * Allows you to update or delete a gist file and rename gist files. Files from the previous version of the gist that aren't explicitly changed during an edit are unchanged.
         */
        update: {
            (params?: RequestParameters & GistsUpdateParams): Promise<OctokitResponse<GistsUpdateResponse>>;
            endpoint: EndpointInterface;
        };
        updateComment: {
            (params?: RequestParameters & GistsUpdateCommentParams): Promise<OctokitResponse<GistsUpdateCommentResponse>>;
            endpoint: EndpointInterface;
        };
    };
    git: {
        createBlob: {
            (params?: RequestParameters & GitCreateBlobParams): Promise<OctokitResponse<GitCreateBlobResponse>>;
            endpoint: EndpointInterface;
        };
        /**
         * Creates a new Git [commit object](https://git-scm.com/book/en/v1/Git-Internals-Git-Objects#Commit-Objects).
         *
         * In this example, the payload of the signature would be:
         *
         *
         *
         * **Signature verification object**
         *
         * The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
         *
         * These are the possible values for `reason` in the `verification` object:
         *
         * | Value                    | Description                                                                                                                       |
         * | ------------------------ | --------------------------------------------------------------------------------------------------------------------------------- |
         * | `expired_key`            | The key that made the signature is expired.                                                                                       |
         * | `not_signing_key`        | The "signing" flag is not among the usage flags in the GPG key that made the signature.                                           |
         * | `gpgverify_error`        | There was an error communicating with the signature verification service.                                                         |
         * | `gpgverify_unavailable`  | The signature verification service is currently unavailable.                                                                      |
         * | `unsigned`               | The object does not include a signature.                                                                                          |
         * | `unknown_signature_type` | A non-PGP signature was found in the commit.                                                                                      |
         * | `no_user`                | No user was associated with the `committer` email address in the commit.                                                          |
         * | `unverified_email`       | The `committer` email address in the commit was associa