# -*- coding: utf-8 -*-
"""Initial migration of the outflow.management plugin

Revision ID: outflow_management_0001
Revises:
Create Date: 2019-01-24 15:18:53.705836

"""
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql
from outflow.core.db.alembic.helpers import (
    create_table,
    create_schema,
    execute,
    drop_table,
    get_login_info,
)  # added by hand

# revision identifiers, used by Alembic.
revision = "outflow_management_0001"
down_revision = None
branch_labels = "outflow_management"
depends_on = None


def upgrade():
    create_schema("outflow")  # added by hand

    create_table(
        "job_log",
        sa.Column("id_job_log", sa.BIGINT(), nullable=False),
        sa.Column("job_plugin", sa.String(), nullable=False),
        sa.Column("job_task", sa.String(), nullable=False),
        sa.Column("job_name", sa.String(length=256), nullable=False),
        sa.Column("job_uuid", postgresql.UUID(), nullable=False),
        sa.Column("job_starttime", postgresql.TIMESTAMP(), nullable=False),
        sa.Column("job_endtime", postgresql.TIMESTAMP(), nullable=False),
        sa.Column("job_category", sa.String(length=256), nullable=False),
        sa.Column("job_descr", sa.String(length=256), nullable=False),
        sa.Column(
            "job_state",
            postgresql.ENUM("Pending", "Terminated", "Running", name="job_state_type"),
            nullable=False,
        ),
        sa.Column(
            "job_status",
            postgresql.ENUM("OK", "WARNING", "ERROR", name="job_status_type"),
            nullable=False,
        ),
        sa.Column("job_status_descr", sa.String(), nullable=False),
        sa.Column("job_parent_id", sa.BIGINT(), nullable=True),
        sa.ForeignKeyConstraint(["job_parent_id"], ["outflow.job_log.id_job_log"],),
        sa.PrimaryKeyConstraint("id_job_log"),
        sa.UniqueConstraint("job_uuid"),
        schema="outflow",
    )

    create_table(
        "job_exception",
        sa.Column("id_job_exception", sa.BIGINT(), nullable=False),
        sa.Column("job_log_id", sa.BIGINT(), nullable=False),
        sa.Column(
            "exception_type",
            postgresql.ENUM("OK", "WARNING", "ERROR", name="exception_type_type"),
            nullable=False,
        ),
        sa.Column(
            "exception_level",
            postgresql.ENUM(
                "Low", "Normal", "High", "Critical", name="exception_level_type"
            ),
            nullable=False,
        ),
        sa.Column("exception_msg", sa.String(), nullable=False),
        sa.ForeignKeyConstraint(["job_log_id"], ["outflow.job_log.id_job_log"],),
        sa.PrimaryKeyConstraint("id_job_exception"),
        schema="outflow",
    )

    # ### end Alembic commands ###

    _, user = get_login_info()
    grant_user_seq_outflow = (
        "GRANT USAGE, SELECT ON ALL SEQUENCES IN " "SCHEMA outflow TO {0}".format(user)
    )

    execute(grant_user_seq_outflow)


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    drop_table("job_exception", schema="outflow")
    drop_table("job_log", schema="outflow")
    # ### end Alembic commands ###
