# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import Dict, List


class ActivateSmartAccessGatewayRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        return self


class ActivateSmartAccessGatewayResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ActivateSmartAccessGatewayResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ActivateSmartAccessGatewayResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ActivateSmartAccessGatewayResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ActiveFlowLogRequest(TeaModel):
    def __init__(
        self,
        flow_log_id: str = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.flow_log_id = flow_log_id
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flow_log_id is not None:
            result['FlowLogId'] = self.flow_log_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FlowLogId') is not None:
            self.flow_log_id = m.get('FlowLogId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class ActiveFlowLogResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ActiveFlowLogResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ActiveFlowLogResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ActiveFlowLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddACLRuleRequest(TeaModel):
    def __init__(
        self,
        acl_id: str = None,
        description: str = None,
        dest_cidr: str = None,
        dest_port_range: str = None,
        direction: str = None,
        dpi_group_ids: List[str] = None,
        dpi_signature_ids: List[str] = None,
        ip_protocol: str = None,
        name: str = None,
        owner_account: str = None,
        owner_id: int = None,
        policy: str = None,
        priority: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        source_cidr: str = None,
        source_port_range: str = None,
        type: str = None,
    ):
        self.acl_id = acl_id
        self.description = description
        self.dest_cidr = dest_cidr
        self.dest_port_range = dest_port_range
        self.direction = direction
        self.dpi_group_ids = dpi_group_ids
        self.dpi_signature_ids = dpi_signature_ids
        self.ip_protocol = ip_protocol
        self.name = name
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.policy = policy
        self.priority = priority
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.source_cidr = source_cidr
        self.source_port_range = source_port_range
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_id is not None:
            result['AclId'] = self.acl_id
        if self.description is not None:
            result['Description'] = self.description
        if self.dest_cidr is not None:
            result['DestCidr'] = self.dest_cidr
        if self.dest_port_range is not None:
            result['DestPortRange'] = self.dest_port_range
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.dpi_group_ids is not None:
            result['DpiGroupIds'] = self.dpi_group_ids
        if self.dpi_signature_ids is not None:
            result['DpiSignatureIds'] = self.dpi_signature_ids
        if self.ip_protocol is not None:
            result['IpProtocol'] = self.ip_protocol
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_cidr is not None:
            result['SourceCidr'] = self.source_cidr
        if self.source_port_range is not None:
            result['SourcePortRange'] = self.source_port_range
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclId') is not None:
            self.acl_id = m.get('AclId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DestCidr') is not None:
            self.dest_cidr = m.get('DestCidr')
        if m.get('DestPortRange') is not None:
            self.dest_port_range = m.get('DestPortRange')
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('DpiGroupIds') is not None:
            self.dpi_group_ids = m.get('DpiGroupIds')
        if m.get('DpiSignatureIds') is not None:
            self.dpi_signature_ids = m.get('DpiSignatureIds')
        if m.get('IpProtocol') is not None:
            self.ip_protocol = m.get('IpProtocol')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceCidr') is not None:
            self.source_cidr = m.get('SourceCidr')
        if m.get('SourcePortRange') is not None:
            self.source_port_range = m.get('SourcePortRange')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class AddACLRuleResponseBodyDpiGroupIds(TeaModel):
    def __init__(
        self,
        dpi_group_id: List[str] = None,
    ):
        self.dpi_group_id = dpi_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dpi_group_id is not None:
            result['DpiGroupId'] = self.dpi_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DpiGroupId') is not None:
            self.dpi_group_id = m.get('DpiGroupId')
        return self


class AddACLRuleResponseBodyDpiSignatureIds(TeaModel):
    def __init__(
        self,
        dpi_signature_id: List[str] = None,
    ):
        self.dpi_signature_id = dpi_signature_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dpi_signature_id is not None:
            result['DpiSignatureId'] = self.dpi_signature_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DpiSignatureId') is not None:
            self.dpi_signature_id = m.get('DpiSignatureId')
        return self


class AddACLRuleResponseBody(TeaModel):
    def __init__(
        self,
        acl_id: str = None,
        acr_id: str = None,
        description: str = None,
        dest_cidr: str = None,
        dest_port_range: str = None,
        direction: str = None,
        dpi_group_ids: AddACLRuleResponseBodyDpiGroupIds = None,
        dpi_signature_ids: AddACLRuleResponseBodyDpiSignatureIds = None,
        gmt_create: int = None,
        ip_protocol: str = None,
        name: str = None,
        policy: str = None,
        priority: int = None,
        request_id: str = None,
        source_cidr: str = None,
        source_port_range: str = None,
        type: str = None,
    ):
        self.acl_id = acl_id
        self.acr_id = acr_id
        self.description = description
        self.dest_cidr = dest_cidr
        self.dest_port_range = dest_port_range
        self.direction = direction
        self.dpi_group_ids = dpi_group_ids
        self.dpi_signature_ids = dpi_signature_ids
        self.gmt_create = gmt_create
        self.ip_protocol = ip_protocol
        self.name = name
        self.policy = policy
        self.priority = priority
        self.request_id = request_id
        self.source_cidr = source_cidr
        self.source_port_range = source_port_range
        self.type = type

    def validate(self):
        if self.dpi_group_ids:
            self.dpi_group_ids.validate()
        if self.dpi_signature_ids:
            self.dpi_signature_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_id is not None:
            result['AclId'] = self.acl_id
        if self.acr_id is not None:
            result['AcrId'] = self.acr_id
        if self.description is not None:
            result['Description'] = self.description
        if self.dest_cidr is not None:
            result['DestCidr'] = self.dest_cidr
        if self.dest_port_range is not None:
            result['DestPortRange'] = self.dest_port_range
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.dpi_group_ids is not None:
            result['DpiGroupIds'] = self.dpi_group_ids.to_map()
        if self.dpi_signature_ids is not None:
            result['DpiSignatureIds'] = self.dpi_signature_ids.to_map()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.ip_protocol is not None:
            result['IpProtocol'] = self.ip_protocol
        if self.name is not None:
            result['Name'] = self.name
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.source_cidr is not None:
            result['SourceCidr'] = self.source_cidr
        if self.source_port_range is not None:
            result['SourcePortRange'] = self.source_port_range
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclId') is not None:
            self.acl_id = m.get('AclId')
        if m.get('AcrId') is not None:
            self.acr_id = m.get('AcrId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DestCidr') is not None:
            self.dest_cidr = m.get('DestCidr')
        if m.get('DestPortRange') is not None:
            self.dest_port_range = m.get('DestPortRange')
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('DpiGroupIds') is not None:
            temp_model = AddACLRuleResponseBodyDpiGroupIds()
            self.dpi_group_ids = temp_model.from_map(m['DpiGroupIds'])
        if m.get('DpiSignatureIds') is not None:
            temp_model = AddACLRuleResponseBodyDpiSignatureIds()
            self.dpi_signature_ids = temp_model.from_map(m['DpiSignatureIds'])
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('IpProtocol') is not None:
            self.ip_protocol = m.get('IpProtocol')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SourceCidr') is not None:
            self.source_cidr = m.get('SourceCidr')
        if m.get('SourcePortRange') is not None:
            self.source_port_range = m.get('SourcePortRange')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class AddACLRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddACLRuleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddACLRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddDnatEntryRequest(TeaModel):
    def __init__(
        self,
        external_ip: str = None,
        external_port: str = None,
        internal_ip: str = None,
        internal_port: str = None,
        ip_protocol: str = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        sag_id: str = None,
        type: str = None,
    ):
        self.external_ip = external_ip
        self.external_port = external_port
        self.internal_ip = internal_ip
        self.internal_port = internal_port
        self.ip_protocol = ip_protocol
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.sag_id = sag_id
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.external_ip is not None:
            result['ExternalIp'] = self.external_ip
        if self.external_port is not None:
            result['ExternalPort'] = self.external_port
        if self.internal_ip is not None:
            result['InternalIp'] = self.internal_ip
        if self.internal_port is not None:
            result['InternalPort'] = self.internal_port
        if self.ip_protocol is not None:
            result['IpProtocol'] = self.ip_protocol
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.sag_id is not None:
            result['SagId'] = self.sag_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExternalIp') is not None:
            self.external_ip = m.get('ExternalIp')
        if m.get('ExternalPort') is not None:
            self.external_port = m.get('ExternalPort')
        if m.get('InternalIp') is not None:
            self.internal_ip = m.get('InternalIp')
        if m.get('InternalPort') is not None:
            self.internal_port = m.get('InternalPort')
        if m.get('IpProtocol') is not None:
            self.ip_protocol = m.get('IpProtocol')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SagId') is not None:
            self.sag_id = m.get('SagId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class AddDnatEntryResponseBody(TeaModel):
    def __init__(
        self,
        dnat_entry_id: str = None,
        request_id: str = None,
    ):
        self.dnat_entry_id = dnat_entry_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dnat_entry_id is not None:
            result['DnatEntryId'] = self.dnat_entry_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DnatEntryId') is not None:
            self.dnat_entry_id = m.get('DnatEntryId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddDnatEntryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddDnatEntryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddDnatEntryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddSnatEntryRequest(TeaModel):
    def __init__(
        self,
        cidr_block: str = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        snat_ip: str = None,
    ):
        self.cidr_block = cidr_block
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.snat_ip = snat_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cidr_block is not None:
            result['CidrBlock'] = self.cidr_block
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.snat_ip is not None:
            result['SnatIp'] = self.snat_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CidrBlock') is not None:
            self.cidr_block = m.get('CidrBlock')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SnatIp') is not None:
            self.snat_ip = m.get('SnatIp')
        return self


class AddSnatEntryResponseBody(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        request_id: str = None,
    ):
        self.instance_id = instance_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddSnatEntryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddSnatEntryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddSnatEntryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AssociateACLRequest(TeaModel):
    def __init__(
        self,
        acl_id: str = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
    ):
        self.acl_id = acl_id
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_id is not None:
            result['AclId'] = self.acl_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclId') is not None:
            self.acl_id = m.get('AclId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        return self


class AssociateACLResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AssociateACLResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AssociateACLResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AssociateACLResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AssociateFlowLogRequest(TeaModel):
    def __init__(
        self,
        flow_log_id: str = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
    ):
        self.flow_log_id = flow_log_id
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flow_log_id is not None:
            result['FlowLogId'] = self.flow_log_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FlowLogId') is not None:
            self.flow_log_id = m.get('FlowLogId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        return self


class AssociateFlowLogResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AssociateFlowLogResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AssociateFlowLogResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AssociateFlowLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AssociateQosRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        qos_id: str = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.qos_id = qos_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.qos_id is not None:
            result['QosId'] = self.qos_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('QosId') is not None:
            self.qos_id = m.get('QosId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        return self


class AssociateQosResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AssociateQosResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AssociateQosResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AssociateQosResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindSerialNumberRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        serial_number: str = None,
        smart_agid: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.serial_number = serial_number
        self.smart_agid = smart_agid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.serial_number is not None:
            result['SerialNumber'] = self.serial_number
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SerialNumber') is not None:
            self.serial_number = m.get('SerialNumber')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        return self


class BindSerialNumberResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BindSerialNumberResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BindSerialNumberResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BindSerialNumberResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindSmartAccessGatewayRequest(TeaModel):
    def __init__(
        self,
        ccn_id: str = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        smart_aguid: int = None,
    ):
        self.ccn_id = ccn_id
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.smart_aguid = smart_aguid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ccn_id is not None:
            result['CcnId'] = self.ccn_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_aguid is not None:
            result['SmartAGUid'] = self.smart_aguid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CcnId') is not None:
            self.ccn_id = m.get('CcnId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGUid') is not None:
            self.smart_aguid = m.get('SmartAGUid')
        return self


class BindSmartAccessGatewayResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BindSmartAccessGatewayResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BindSmartAccessGatewayResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BindSmartAccessGatewayResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindVbrRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        smart_aguid: int = None,
        vbr_id: str = None,
        vbr_region_id: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.smart_aguid = smart_aguid
        self.vbr_id = vbr_id
        self.vbr_region_id = vbr_region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_aguid is not None:
            result['SmartAGUid'] = self.smart_aguid
        if self.vbr_id is not None:
            result['VbrId'] = self.vbr_id
        if self.vbr_region_id is not None:
            result['VbrRegionId'] = self.vbr_region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGUid') is not None:
            self.smart_aguid = m.get('SmartAGUid')
        if m.get('VbrId') is not None:
            self.vbr_id = m.get('VbrId')
        if m.get('VbrRegionId') is not None:
            self.vbr_region_id = m.get('VbrRegionId')
        return self


class BindVbrResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BindVbrResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: BindVbrResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = BindVbrResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ClearSagCipherRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        sag_id: str = None,
        sn_number: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.sag_id = sag_id
        self.sn_number = sn_number

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.sag_id is not None:
            result['SagId'] = self.sag_id
        if self.sn_number is not None:
            result['SnNumber'] = self.sn_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SagId') is not None:
            self.sag_id = m.get('SagId')
        if m.get('SnNumber') is not None:
            self.sn_number = m.get('SnNumber')
        return self


class ClearSagCipherResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ClearSagCipherResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ClearSagCipherResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ClearSagCipherResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ClearSagRouteableAddressRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        sag_id: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.sag_id = sag_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.sag_id is not None:
            result['SagId'] = self.sag_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SagId') is not None:
            self.sag_id = m.get('SagId')
        return self


class ClearSagRouteableAddressResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ClearSagRouteableAddressResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ClearSagRouteableAddressResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ClearSagRouteableAddressResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateACLRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.name = name
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class CreateACLResponseBody(TeaModel):
    def __init__(
        self,
        acl_id: str = None,
        request_id: str = None,
        resource_group_id: str = None,
    ):
        self.acl_id = acl_id
        self.request_id = request_id
        self.resource_group_id = resource_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_id is not None:
            result['AclId'] = self.acl_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclId') is not None:
            self.acl_id = m.get('AclId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class CreateACLResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateACLResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateACLResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCloudConnectNetworkRequest(TeaModel):
    def __init__(
        self,
        cidr_block: str = None,
        description: str = None,
        name: str = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        snat_cidr_block: str = None,
    ):
        self.cidr_block = cidr_block
        self.description = description
        self.name = name
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.snat_cidr_block = snat_cidr_block

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cidr_block is not None:
            result['CidrBlock'] = self.cidr_block
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.snat_cidr_block is not None:
            result['SnatCidrBlock'] = self.snat_cidr_block
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CidrBlock') is not None:
            self.cidr_block = m.get('CidrBlock')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SnatCidrBlock') is not None:
            self.snat_cidr_block = m.get('SnatCidrBlock')
        return self


class CreateCloudConnectNetworkResponseBody(TeaModel):
    def __init__(
        self,
        ccn_id: str = None,
        cidr_block: str = None,
        description: str = None,
        name: str = None,
        request_id: str = None,
        resource_group_id: str = None,
        snat_cidr_block: str = None,
        status: str = None,
    ):
        self.ccn_id = ccn_id
        self.cidr_block = cidr_block
        self.description = description
        self.name = name
        self.request_id = request_id
        self.resource_group_id = resource_group_id
        self.snat_cidr_block = snat_cidr_block
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ccn_id is not None:
            result['CcnId'] = self.ccn_id
        if self.cidr_block is not None:
            result['CidrBlock'] = self.cidr_block
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.snat_cidr_block is not None:
            result['SnatCidrBlock'] = self.snat_cidr_block
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CcnId') is not None:
            self.ccn_id = m.get('CcnId')
        if m.get('CidrBlock') is not None:
            self.cidr_block = m.get('CidrBlock')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SnatCidrBlock') is not None:
            self.snat_cidr_block = m.get('SnatCidrBlock')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class CreateCloudConnectNetworkResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateCloudConnectNetworkResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateCloudConnectNetworkResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateEnterpriseCodeRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        enterprise_code: str = None,
        region_id: str = None,
    ):
        self.client_token = client_token
        self.enterprise_code = enterprise_code
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.enterprise_code is not None:
            result['EnterpriseCode'] = self.enterprise_code
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('EnterpriseCode') is not None:
            self.enterprise_code = m.get('EnterpriseCode')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateEnterpriseCodeResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateEnterpriseCodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateEnterpriseCodeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateEnterpriseCodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFlowLogRequest(TeaModel):
    def __init__(
        self,
        active_aging: int = None,
        description: str = None,
        inactive_aging: int = None,
        logstore_name: str = None,
        name: str = None,
        netflow_server_ip: str = None,
        netflow_server_port: int = None,
        netflow_version: str = None,
        output_type: str = None,
        owner_account: str = None,
        owner_id: int = None,
        project_name: str = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        sls_region_id: str = None,
    ):
        self.active_aging = active_aging
        self.description = description
        self.inactive_aging = inactive_aging
        self.logstore_name = logstore_name
        self.name = name
        self.netflow_server_ip = netflow_server_ip
        self.netflow_server_port = netflow_server_port
        self.netflow_version = netflow_version
        self.output_type = output_type
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.project_name = project_name
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.sls_region_id = sls_region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active_aging is not None:
            result['ActiveAging'] = self.active_aging
        if self.description is not None:
            result['Description'] = self.description
        if self.inactive_aging is not None:
            result['InactiveAging'] = self.inactive_aging
        if self.logstore_name is not None:
            result['LogstoreName'] = self.logstore_name
        if self.name is not None:
            result['Name'] = self.name
        if self.netflow_server_ip is not None:
            result['NetflowServerIp'] = self.netflow_server_ip
        if self.netflow_server_port is not None:
            result['NetflowServerPort'] = self.netflow_server_port
        if self.netflow_version is not None:
            result['NetflowVersion'] = self.netflow_version
        if self.output_type is not None:
            result['OutputType'] = self.output_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.sls_region_id is not None:
            result['SlsRegionId'] = self.sls_region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ActiveAging') is not None:
            self.active_aging = m.get('ActiveAging')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InactiveAging') is not None:
            self.inactive_aging = m.get('InactiveAging')
        if m.get('LogstoreName') is not None:
            self.logstore_name = m.get('LogstoreName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NetflowServerIp') is not None:
            self.netflow_server_ip = m.get('NetflowServerIp')
        if m.get('NetflowServerPort') is not None:
            self.netflow_server_port = m.get('NetflowServerPort')
        if m.get('NetflowVersion') is not None:
            self.netflow_version = m.get('NetflowVersion')
        if m.get('OutputType') is not None:
            self.output_type = m.get('OutputType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SlsRegionId') is not None:
            self.sls_region_id = m.get('SlsRegionId')
        return self


class CreateFlowLogResponseBody(TeaModel):
    def __init__(
        self,
        flow_log_id: str = None,
        request_id: str = None,
        resource_group_id: str = None,
    ):
        self.flow_log_id = flow_log_id
        self.request_id = request_id
        self.resource_group_id = resource_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flow_log_id is not None:
            result['FlowLogId'] = self.flow_log_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FlowLogId') is not None:
            self.flow_log_id = m.get('FlowLogId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class CreateFlowLogResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateFlowLogResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateFlowLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateHealthCheckRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        dst_ip_addr: str = None,
        dst_port: int = None,
        fail_count_threshold: int = None,
        name: str = None,
        owner_account: str = None,
        owner_id: int = None,
        probe_count: int = None,
        probe_interval: int = None,
        probe_timeout: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        rtt_fail_threshold: int = None,
        rtt_threshold: int = None,
        smart_agid: str = None,
        src_ip_addr: str = None,
        src_port: int = None,
        type: str = None,
    ):
        self.description = description
        self.dst_ip_addr = dst_ip_addr
        self.dst_port = dst_port
        self.fail_count_threshold = fail_count_threshold
        self.name = name
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.probe_count = probe_count
        self.probe_interval = probe_interval
        self.probe_timeout = probe_timeout
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.rtt_fail_threshold = rtt_fail_threshold
        self.rtt_threshold = rtt_threshold
        self.smart_agid = smart_agid
        self.src_ip_addr = src_ip_addr
        self.src_port = src_port
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.dst_ip_addr is not None:
            result['DstIpAddr'] = self.dst_ip_addr
        if self.dst_port is not None:
            result['DstPort'] = self.dst_port
        if self.fail_count_threshold is not None:
            result['FailCountThreshold'] = self.fail_count_threshold
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.probe_count is not None:
            result['ProbeCount'] = self.probe_count
        if self.probe_interval is not None:
            result['ProbeInterval'] = self.probe_interval
        if self.probe_timeout is not None:
            result['ProbeTimeout'] = self.probe_timeout
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.rtt_fail_threshold is not None:
            result['RttFailThreshold'] = self.rtt_fail_threshold
        if self.rtt_threshold is not None:
            result['RttThreshold'] = self.rtt_threshold
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.src_ip_addr is not None:
            result['SrcIpAddr'] = self.src_ip_addr
        if self.src_port is not None:
            result['SrcPort'] = self.src_port
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DstIpAddr') is not None:
            self.dst_ip_addr = m.get('DstIpAddr')
        if m.get('DstPort') is not None:
            self.dst_port = m.get('DstPort')
        if m.get('FailCountThreshold') is not None:
            self.fail_count_threshold = m.get('FailCountThreshold')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ProbeCount') is not None:
            self.probe_count = m.get('ProbeCount')
        if m.get('ProbeInterval') is not None:
            self.probe_interval = m.get('ProbeInterval')
        if m.get('ProbeTimeout') is not None:
            self.probe_timeout = m.get('ProbeTimeout')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RttFailThreshold') is not None:
            self.rtt_fail_threshold = m.get('RttFailThreshold')
        if m.get('RttThreshold') is not None:
            self.rtt_threshold = m.get('RttThreshold')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SrcIpAddr') is not None:
            self.src_ip_addr = m.get('SrcIpAddr')
        if m.get('SrcPort') is not None:
            self.src_port = m.get('SrcPort')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateHealthCheckResponseBody(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        request_id: str = None,
    ):
        self.instance_id = instance_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateHealthCheckResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateHealthCheckResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateHealthCheckResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateQosRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        qos_description: str = None,
        qos_name: str = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.qos_description = qos_description
        self.qos_name = qos_name
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.qos_description is not None:
            result['QosDescription'] = self.qos_description
        if self.qos_name is not None:
            result['QosName'] = self.qos_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('QosDescription') is not None:
            self.qos_description = m.get('QosDescription')
        if m.get('QosName') is not None:
            self.qos_name = m.get('QosName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class CreateQosResponseBody(TeaModel):
    def __init__(
        self,
        qos_id: str = None,
        request_id: str = None,
        resource_group_id: str = None,
    ):
        self.qos_id = qos_id
        self.request_id = request_id
        self.resource_group_id = resource_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.qos_id is not None:
            result['QosId'] = self.qos_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('QosId') is not None:
            self.qos_id = m.get('QosId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class CreateQosResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateQosResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateQosResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateQosCarRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        limit_type: str = None,
        max_bandwidth_abs: int = None,
        max_bandwidth_percent: int = None,
        min_bandwidth_abs: int = None,
        min_bandwidth_percent: int = None,
        name: str = None,
        owner_account: str = None,
        owner_id: int = None,
        percent_source_type: str = None,
        priority: int = None,
        qos_id: str = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.description = description
        self.limit_type = limit_type
        self.max_bandwidth_abs = max_bandwidth_abs
        self.max_bandwidth_percent = max_bandwidth_percent
        self.min_bandwidth_abs = min_bandwidth_abs
        self.min_bandwidth_percent = min_bandwidth_percent
        self.name = name
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.percent_source_type = percent_source_type
        self.priority = priority
        self.qos_id = qos_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.limit_type is not None:
            result['LimitType'] = self.limit_type
        if self.max_bandwidth_abs is not None:
            result['MaxBandwidthAbs'] = self.max_bandwidth_abs
        if self.max_bandwidth_percent is not None:
            result['MaxBandwidthPercent'] = self.max_bandwidth_percent
        if self.min_bandwidth_abs is not None:
            result['MinBandwidthAbs'] = self.min_bandwidth_abs
        if self.min_bandwidth_percent is not None:
            result['MinBandwidthPercent'] = self.min_bandwidth_percent
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.percent_source_type is not None:
            result['PercentSourceType'] = self.percent_source_type
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.qos_id is not None:
            result['QosId'] = self.qos_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('LimitType') is not None:
            self.limit_type = m.get('LimitType')
        if m.get('MaxBandwidthAbs') is not None:
            self.max_bandwidth_abs = m.get('MaxBandwidthAbs')
        if m.get('MaxBandwidthPercent') is not None:
            self.max_bandwidth_percent = m.get('MaxBandwidthPercent')
        if m.get('MinBandwidthAbs') is not None:
            self.min_bandwidth_abs = m.get('MinBandwidthAbs')
        if m.get('MinBandwidthPercent') is not None:
            self.min_bandwidth_percent = m.get('MinBandwidthPercent')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PercentSourceType') is not None:
            self.percent_source_type = m.get('PercentSourceType')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('QosId') is not None:
            self.qos_id = m.get('QosId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class CreateQosCarResponseBody(TeaModel):
    def __init__(
        self,
        description: str = None,
        limit_type: str = None,
        max_bandwidth_abs: int = None,
        max_bandwidth_percent: int = None,
        min_bandwidth_abs: int = None,
        min_bandwidth_percent: int = None,
        percent_source_type: str = None,
        priority: int = None,
        qos_car_id: str = None,
        qos_id: str = None,
        request_id: str = None,
    ):
        self.description = description
        self.limit_type = limit_type
        self.max_bandwidth_abs = max_bandwidth_abs
        self.max_bandwidth_percent = max_bandwidth_percent
        self.min_bandwidth_abs = min_bandwidth_abs
        self.min_bandwidth_percent = min_bandwidth_percent
        self.percent_source_type = percent_source_type
        self.priority = priority
        self.qos_car_id = qos_car_id
        self.qos_id = qos_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.limit_type is not None:
            result['LimitType'] = self.limit_type
        if self.max_bandwidth_abs is not None:
            result['MaxBandwidthAbs'] = self.max_bandwidth_abs
        if self.max_bandwidth_percent is not None:
            result['MaxBandwidthPercent'] = self.max_bandwidth_percent
        if self.min_bandwidth_abs is not None:
            result['MinBandwidthAbs'] = self.min_bandwidth_abs
        if self.min_bandwidth_percent is not None:
            result['MinBandwidthPercent'] = self.min_bandwidth_percent
        if self.percent_source_type is not None:
            result['PercentSourceType'] = self.percent_source_type
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.qos_car_id is not None:
            result['QosCarId'] = self.qos_car_id
        if self.qos_id is not None:
            result['QosId'] = self.qos_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('LimitType') is not None:
            self.limit_type = m.get('LimitType')
        if m.get('MaxBandwidthAbs') is not None:
            self.max_bandwidth_abs = m.get('MaxBandwidthAbs')
        if m.get('MaxBandwidthPercent') is not None:
            self.max_bandwidth_percent = m.get('MaxBandwidthPercent')
        if m.get('MinBandwidthAbs') is not None:
            self.min_bandwidth_abs = m.get('MinBandwidthAbs')
        if m.get('MinBandwidthPercent') is not None:
            self.min_bandwidth_percent = m.get('MinBandwidthPercent')
        if m.get('PercentSourceType') is not None:
            self.percent_source_type = m.get('PercentSourceType')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('QosCarId') is not None:
            self.qos_car_id = m.get('QosCarId')
        if m.get('QosId') is not None:
            self.qos_id = m.get('QosId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateQosCarResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateQosCarResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateQosCarResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateQosPolicyRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        dest_cidr: str = None,
        dest_port_range: str = None,
        dpi_group_ids: List[str] = None,
        dpi_signature_ids: List[str] = None,
        end_time: str = None,
        ip_protocol: str = None,
        name: str = None,
        owner_account: str = None,
        owner_id: int = None,
        priority: int = None,
        qos_id: str = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        source_cidr: str = None,
        source_port_range: str = None,
        start_time: str = None,
    ):
        self.description = description
        self.dest_cidr = dest_cidr
        self.dest_port_range = dest_port_range
        self.dpi_group_ids = dpi_group_ids
        self.dpi_signature_ids = dpi_signature_ids
        self.end_time = end_time
        self.ip_protocol = ip_protocol
        self.name = name
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.priority = priority
        self.qos_id = qos_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.source_cidr = source_cidr
        self.source_port_range = source_port_range
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.dest_cidr is not None:
            result['DestCidr'] = self.dest_cidr
        if self.dest_port_range is not None:
            result['DestPortRange'] = self.dest_port_range
        if self.dpi_group_ids is not None:
            result['DpiGroupIds'] = self.dpi_group_ids
        if self.dpi_signature_ids is not None:
            result['DpiSignatureIds'] = self.dpi_signature_ids
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.ip_protocol is not None:
            result['IpProtocol'] = self.ip_protocol
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.qos_id is not None:
            result['QosId'] = self.qos_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_cidr is not None:
            result['SourceCidr'] = self.source_cidr
        if self.source_port_range is not None:
            result['SourcePortRange'] = self.source_port_range
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DestCidr') is not None:
            self.dest_cidr = m.get('DestCidr')
        if m.get('DestPortRange') is not None:
            self.dest_port_range = m.get('DestPortRange')
        if m.get('DpiGroupIds') is not None:
            self.dpi_group_ids = m.get('DpiGroupIds')
        if m.get('DpiSignatureIds') is not None:
            self.dpi_signature_ids = m.get('DpiSignatureIds')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('IpProtocol') is not None:
            self.ip_protocol = m.get('IpProtocol')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('QosId') is not None:
            self.qos_id = m.get('QosId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceCidr') is not None:
            self.source_cidr = m.get('SourceCidr')
        if m.get('SourcePortRange') is not None:
            self.source_port_range = m.get('SourcePortRange')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class CreateQosPolicyResponseBodyDpiGroupIds(TeaModel):
    def __init__(
        self,
        dpi_group_id: List[str] = None,
    ):
        self.dpi_group_id = dpi_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dpi_group_id is not None:
            result['DpiGroupId'] = self.dpi_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DpiGroupId') is not None:
            self.dpi_group_id = m.get('DpiGroupId')
        return self


class CreateQosPolicyResponseBodyDpiSignatureIds(TeaModel):
    def __init__(
        self,
        dpi_signature_id: List[str] = None,
    ):
        self.dpi_signature_id = dpi_signature_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dpi_signature_id is not None:
            result['DpiSignatureId'] = self.dpi_signature_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DpiSignatureId') is not None:
            self.dpi_signature_id = m.get('DpiSignatureId')
        return self


class CreateQosPolicyResponseBody(TeaModel):
    def __init__(
        self,
        description: str = None,
        dest_cidr: str = None,
        dest_port_range: str = None,
        dpi_group_ids: CreateQosPolicyResponseBodyDpiGroupIds = None,
        dpi_signature_ids: CreateQosPolicyResponseBodyDpiSignatureIds = None,
        end_time: str = None,
        ip_protocol: str = None,
        name: str = None,
        priority: int = None,
        qos_id: str = None,
        qos_policy_id: str = None,
        request_id: str = None,
        source_cidr: str = None,
        source_port_range: str = None,
        start_time: str = None,
    ):
        self.description = description
        self.dest_cidr = dest_cidr
        self.dest_port_range = dest_port_range
        self.dpi_group_ids = dpi_group_ids
        self.dpi_signature_ids = dpi_signature_ids
        self.end_time = end_time
        self.ip_protocol = ip_protocol
        self.name = name
        self.priority = priority
        self.qos_id = qos_id
        self.qos_policy_id = qos_policy_id
        self.request_id = request_id
        self.source_cidr = source_cidr
        self.source_port_range = source_port_range
        self.start_time = start_time

    def validate(self):
        if self.dpi_group_ids:
            self.dpi_group_ids.validate()
        if self.dpi_signature_ids:
            self.dpi_signature_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.dest_cidr is not None:
            result['DestCidr'] = self.dest_cidr
        if self.dest_port_range is not None:
            result['DestPortRange'] = self.dest_port_range
        if self.dpi_group_ids is not None:
            result['DpiGroupIds'] = self.dpi_group_ids.to_map()
        if self.dpi_signature_ids is not None:
            result['DpiSignatureIds'] = self.dpi_signature_ids.to_map()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.ip_protocol is not None:
            result['IpProtocol'] = self.ip_protocol
        if self.name is not None:
            result['Name'] = self.name
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.qos_id is not None:
            result['QosId'] = self.qos_id
        if self.qos_policy_id is not None:
            result['QosPolicyId'] = self.qos_policy_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.source_cidr is not None:
            result['SourceCidr'] = self.source_cidr
        if self.source_port_range is not None:
            result['SourcePortRange'] = self.source_port_range
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DestCidr') is not None:
            self.dest_cidr = m.get('DestCidr')
        if m.get('DestPortRange') is not None:
            self.dest_port_range = m.get('DestPortRange')
        if m.get('DpiGroupIds') is not None:
            temp_model = CreateQosPolicyResponseBodyDpiGroupIds()
            self.dpi_group_ids = temp_model.from_map(m['DpiGroupIds'])
        if m.get('DpiSignatureIds') is not None:
            temp_model = CreateQosPolicyResponseBodyDpiSignatureIds()
            self.dpi_signature_ids = temp_model.from_map(m['DpiSignatureIds'])
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('IpProtocol') is not None:
            self.ip_protocol = m.get('IpProtocol')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('QosId') is not None:
            self.qos_id = m.get('QosId')
        if m.get('QosPolicyId') is not None:
            self.qos_policy_id = m.get('QosPolicyId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SourceCidr') is not None:
            self.source_cidr = m.get('SourceCidr')
        if m.get('SourcePortRange') is not None:
            self.source_port_range = m.get('SourcePortRange')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class CreateQosPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateQosPolicyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateQosPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSagExpressConnectInterfaceRequest(TeaModel):
    def __init__(
        self,
        ip: str = None,
        mask: str = None,
        owner_account: str = None,
        owner_id: int = None,
        port_name: str = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        smart_agsn: str = None,
        vlan: str = None,
    ):
        self.ip = ip
        self.mask = mask
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.port_name = port_name
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.smart_agsn = smart_agsn
        self.vlan = vlan

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip is not None:
            result['IP'] = self.ip
        if self.mask is not None:
            result['Mask'] = self.mask
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.port_name is not None:
            result['PortName'] = self.port_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_agsn is not None:
            result['SmartAGSn'] = self.smart_agsn
        if self.vlan is not None:
            result['Vlan'] = self.vlan
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IP') is not None:
            self.ip = m.get('IP')
        if m.get('Mask') is not None:
            self.mask = m.get('Mask')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PortName') is not None:
            self.port_name = m.get('PortName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGSn') is not None:
            self.smart_agsn = m.get('SmartAGSn')
        if m.get('Vlan') is not None:
            self.vlan = m.get('Vlan')
        return self


class CreateSagExpressConnectInterfaceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateSagExpressConnectInterfaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateSagExpressConnectInterfaceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateSagExpressConnectInterfaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSagStaticRouteRequest(TeaModel):
    def __init__(
        self,
        destination_cidr: str = None,
        next_hop: str = None,
        owner_account: str = None,
        owner_id: int = None,
        port_name: str = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        smart_agsn: str = None,
        vlan: str = None,
    ):
        self.destination_cidr = destination_cidr
        self.next_hop = next_hop
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.port_name = port_name
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.smart_agsn = smart_agsn
        self.vlan = vlan

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.destination_cidr is not None:
            result['DestinationCidr'] = self.destination_cidr
        if self.next_hop is not None:
            result['NextHop'] = self.next_hop
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.port_name is not None:
            result['PortName'] = self.port_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_agsn is not None:
            result['SmartAGSn'] = self.smart_agsn
        if self.vlan is not None:
            result['Vlan'] = self.vlan
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DestinationCidr') is not None:
            self.destination_cidr = m.get('DestinationCidr')
        if m.get('NextHop') is not None:
            self.next_hop = m.get('NextHop')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PortName') is not None:
            self.port_name = m.get('PortName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGSn') is not None:
            self.smart_agsn = m.get('SmartAGSn')
        if m.get('Vlan') is not None:
            self.vlan = m.get('Vlan')
        return self


class CreateSagStaticRouteResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateSagStaticRouteResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateSagStaticRouteResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateSagStaticRouteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSmartAccessGatewayRequest(TeaModel):
    def __init__(
        self,
        already_have_sag: bool = None,
        auto_pay: bool = None,
        buyer_message: str = None,
        cpeversion: str = None,
        charge_type: str = None,
        description: str = None,
        ha_type: str = None,
        hard_ware_spec: str = None,
        max_band_width: int = None,
        name: str = None,
        owner_account: str = None,
        owner_id: int = None,
        period: int = None,
        receiver_address: str = None,
        receiver_city: str = None,
        receiver_country: str = None,
        receiver_district: str = None,
        receiver_email: str = None,
        receiver_mobile: str = None,
        receiver_name: str = None,
        receiver_phone: str = None,
        receiver_state: str = None,
        receiver_town: str = None,
        receiver_zip: str = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.already_have_sag = already_have_sag
        self.auto_pay = auto_pay
        self.buyer_message = buyer_message
        self.cpeversion = cpeversion
        self.charge_type = charge_type
        self.description = description
        self.ha_type = ha_type
        self.hard_ware_spec = hard_ware_spec
        self.max_band_width = max_band_width
        self.name = name
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.period = period
        self.receiver_address = receiver_address
        self.receiver_city = receiver_city
        self.receiver_country = receiver_country
        self.receiver_district = receiver_district
        self.receiver_email = receiver_email
        self.receiver_mobile = receiver_mobile
        self.receiver_name = receiver_name
        self.receiver_phone = receiver_phone
        self.receiver_state = receiver_state
        self.receiver_town = receiver_town
        self.receiver_zip = receiver_zip
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.already_have_sag is not None:
            result['AlreadyHaveSag'] = self.already_have_sag
        if self.auto_pay is not None:
            result['AutoPay'] = self.auto_pay
        if self.buyer_message is not None:
            result['BuyerMessage'] = self.buyer_message
        if self.cpeversion is not None:
            result['CPEVersion'] = self.cpeversion
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.description is not None:
            result['Description'] = self.description
        if self.ha_type is not None:
            result['HaType'] = self.ha_type
        if self.hard_ware_spec is not None:
            result['HardWareSpec'] = self.hard_ware_spec
        if self.max_band_width is not None:
            result['MaxBandWidth'] = self.max_band_width
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.period is not None:
            result['Period'] = self.period
        if self.receiver_address is not None:
            result['ReceiverAddress'] = self.receiver_address
        if self.receiver_city is not None:
            result['ReceiverCity'] = self.receiver_city
        if self.receiver_country is not None:
            result['ReceiverCountry'] = self.receiver_country
        if self.receiver_district is not None:
            result['ReceiverDistrict'] = self.receiver_district
        if self.receiver_email is not None:
            result['ReceiverEmail'] = self.receiver_email
        if self.receiver_mobile is not None:
            result['ReceiverMobile'] = self.receiver_mobile
        if self.receiver_name is not None:
            result['ReceiverName'] = self.receiver_name
        if self.receiver_phone is not None:
            result['ReceiverPhone'] = self.receiver_phone
        if self.receiver_state is not None:
            result['ReceiverState'] = self.receiver_state
        if self.receiver_town is not None:
            result['ReceiverTown'] = self.receiver_town
        if self.receiver_zip is not None:
            result['ReceiverZip'] = self.receiver_zip
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlreadyHaveSag') is not None:
            self.already_have_sag = m.get('AlreadyHaveSag')
        if m.get('AutoPay') is not None:
            self.auto_pay = m.get('AutoPay')
        if m.get('BuyerMessage') is not None:
            self.buyer_message = m.get('BuyerMessage')
        if m.get('CPEVersion') is not None:
            self.cpeversion = m.get('CPEVersion')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('HaType') is not None:
            self.ha_type = m.get('HaType')
        if m.get('HardWareSpec') is not None:
            self.hard_ware_spec = m.get('HardWareSpec')
        if m.get('MaxBandWidth') is not None:
            self.max_band_width = m.get('MaxBandWidth')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('ReceiverAddress') is not None:
            self.receiver_address = m.get('ReceiverAddress')
        if m.get('ReceiverCity') is not None:
            self.receiver_city = m.get('ReceiverCity')
        if m.get('ReceiverCountry') is not None:
            self.receiver_country = m.get('ReceiverCountry')
        if m.get('ReceiverDistrict') is not None:
            self.receiver_district = m.get('ReceiverDistrict')
        if m.get('ReceiverEmail') is not None:
            self.receiver_email = m.get('ReceiverEmail')
        if m.get('ReceiverMobile') is not None:
            self.receiver_mobile = m.get('ReceiverMobile')
        if m.get('ReceiverName') is not None:
            self.receiver_name = m.get('ReceiverName')
        if m.get('ReceiverPhone') is not None:
            self.receiver_phone = m.get('ReceiverPhone')
        if m.get('ReceiverState') is not None:
            self.receiver_state = m.get('ReceiverState')
        if m.get('ReceiverTown') is not None:
            self.receiver_town = m.get('ReceiverTown')
        if m.get('ReceiverZip') is not None:
            self.receiver_zip = m.get('ReceiverZip')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class CreateSmartAccessGatewayResponseBody(TeaModel):
    def __init__(
        self,
        description: str = None,
        name: str = None,
        order_id: str = None,
        request_id: str = None,
        resource_group_id: str = None,
        smart_agid: str = None,
    ):
        self.description = description
        self.name = name
        self.order_id = order_id
        self.request_id = request_id
        self.resource_group_id = resource_group_id
        self.smart_agid = smart_agid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        return self


class CreateSmartAccessGatewayResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateSmartAccessGatewayResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateSmartAccessGatewayResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSmartAccessGatewayClientUserRequest(TeaModel):
    def __init__(
        self,
        bandwidth: int = None,
        client_ip: str = None,
        owner_account: str = None,
        owner_id: int = None,
        password: str = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        user_mail: str = None,
        user_name: str = None,
    ):
        self.bandwidth = bandwidth
        self.client_ip = client_ip
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.password = password
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.user_mail = user_mail
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.client_ip is not None:
            result['ClientIp'] = self.client_ip
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.password is not None:
            result['Password'] = self.password
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.user_mail is not None:
            result['UserMail'] = self.user_mail
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('ClientIp') is not None:
            self.client_ip = m.get('ClientIp')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('UserMail') is not None:
            self.user_mail = m.get('UserMail')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class CreateSmartAccessGatewayClientUserResponseBody(TeaModel):
    def __init__(
        self,
        bandwidth: int = None,
        client_ip: str = None,
        request_id: str = None,
        user_mail: str = None,
        user_name: str = None,
    ):
        self.bandwidth = bandwidth
        self.client_ip = client_ip
        self.request_id = request_id
        self.user_mail = user_mail
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.client_ip is not None:
            result['ClientIp'] = self.client_ip
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.user_mail is not None:
            result['UserMail'] = self.user_mail
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('ClientIp') is not None:
            self.client_ip = m.get('ClientIp')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UserMail') is not None:
            self.user_mail = m.get('UserMail')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class CreateSmartAccessGatewayClientUserResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateSmartAccessGatewayClientUserResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateSmartAccessGatewayClientUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSmartAccessGatewaySoftwareRequest(TeaModel):
    def __init__(
        self,
        auto_pay: bool = None,
        charge_type: str = None,
        data_plan: int = None,
        owner_account: str = None,
        owner_id: int = None,
        period: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        user_count: int = None,
    ):
        self.auto_pay = auto_pay
        self.charge_type = charge_type
        self.data_plan = data_plan
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.period = period
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.user_count = user_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_pay is not None:
            result['AutoPay'] = self.auto_pay
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.data_plan is not None:
            result['DataPlan'] = self.data_plan
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.period is not None:
            result['Period'] = self.period
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.user_count is not None:
            result['UserCount'] = self.user_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoPay') is not None:
            self.auto_pay = m.get('AutoPay')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('DataPlan') is not None:
            self.data_plan = m.get('DataPlan')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('UserCount') is not None:
            self.user_count = m.get('UserCount')
        return self


class CreateSmartAccessGatewaySoftwareResponseBody(TeaModel):
    def __init__(
        self,
        order_id: str = None,
        request_id: str = None,
        resource_group_id: str = None,
        smart_agid: str = None,
    ):
        self.order_id = order_id
        self.request_id = request_id
        self.resource_group_id = resource_group_id
        self.smart_agid = smart_agid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        return self


class CreateSmartAccessGatewaySoftwareResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateSmartAccessGatewaySoftwareResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateSmartAccessGatewaySoftwareResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeactiveFlowLogRequest(TeaModel):
    def __init__(
        self,
        flow_log_id: str = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.flow_log_id = flow_log_id
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flow_log_id is not None:
            result['FlowLogId'] = self.flow_log_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FlowLogId') is not None:
            self.flow_log_id = m.get('FlowLogId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeactiveFlowLogResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeactiveFlowLogResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeactiveFlowLogResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeactiveFlowLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteACLRequest(TeaModel):
    def __init__(
        self,
        acl_id: str = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.acl_id = acl_id
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_id is not None:
            result['AclId'] = self.acl_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclId') is not None:
            self.acl_id = m.get('AclId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteACLResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteACLResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteACLResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteACLResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteACLRuleRequest(TeaModel):
    def __init__(
        self,
        acl_id: str = None,
        acr_id: str = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.acl_id = acl_id
        self.acr_id = acr_id
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_id is not None:
            result['AclId'] = self.acl_id
        if self.acr_id is not None:
            result['AcrId'] = self.acr_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclId') is not None:
            self.acl_id = m.get('AclId')
        if m.get('AcrId') is not None:
            self.acr_id = m.get('AcrId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteACLRuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteACLRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteACLRuleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteACLRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCloudConnectNetworkRequest(TeaModel):
    def __init__(
        self,
        ccn_id: str = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.ccn_id = ccn_id
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ccn_id is not None:
            result['CcnId'] = self.ccn_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CcnId') is not None:
            self.ccn_id = m.get('CcnId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteCloudConnectNetworkResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCloudConnectNetworkResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteCloudConnectNetworkResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteCloudConnectNetworkResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDnatEntryRequest(TeaModel):
    def __init__(
        self,
        dnat_entry_id: str = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        sag_id: str = None,
    ):
        self.dnat_entry_id = dnat_entry_id
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.sag_id = sag_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dnat_entry_id is not None:
            result['DnatEntryId'] = self.dnat_entry_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.sag_id is not None:
            result['SagId'] = self.sag_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DnatEntryId') is not None:
            self.dnat_entry_id = m.get('DnatEntryId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SagId') is not None:
            self.sag_id = m.get('SagId')
        return self


class DeleteDnatEntryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDnatEntryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteDnatEntryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteDnatEntryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteEnterpriseCodeRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        enterprise_code: str = None,
        region_id: str = None,
    ):
        self.client_token = client_token
        self.enterprise_code = enterprise_code
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.enterprise_code is not None:
            result['EnterpriseCode'] = self.enterprise_code
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('EnterpriseCode') is not None:
            self.enterprise_code = m.get('EnterpriseCode')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteEnterpriseCodeResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteEnterpriseCodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteEnterpriseCodeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteEnterpriseCodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteFlowLogRequest(TeaModel):
    def __init__(
        self,
        flow_log_id: str = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.flow_log_id = flow_log_id
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flow_log_id is not None:
            result['FlowLogId'] = self.flow_log_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FlowLogId') is not None:
            self.flow_log_id = m.get('FlowLogId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteFlowLogResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteFlowLogResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteFlowLogResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteFlowLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteHealthCheckRequest(TeaModel):
    def __init__(
        self,
        hc_instance_id: str = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.hc_instance_id = hc_instance_id
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hc_instance_id is not None:
            result['HcInstanceId'] = self.hc_instance_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HcInstanceId') is not None:
            self.hc_instance_id = m.get('HcInstanceId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteHealthCheckResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteHealthCheckResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteHealthCheckResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteHealthCheckResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteQosRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        qos_id: str = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.qos_id = qos_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.qos_id is not None:
            result['QosId'] = self.qos_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('QosId') is not None:
            self.qos_id = m.get('QosId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteQosResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteQosResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteQosResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteQosResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteQosCarRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        qos_car_id: str = None,
        qos_id: str = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.qos_car_id = qos_car_id
        self.qos_id = qos_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.qos_car_id is not None:
            result['QosCarId'] = self.qos_car_id
        if self.qos_id is not None:
            result['QosId'] = self.qos_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('QosCarId') is not None:
            self.qos_car_id = m.get('QosCarId')
        if m.get('QosId') is not None:
            self.qos_id = m.get('QosId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteQosCarResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteQosCarResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteQosCarResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteQosCarResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteQosPolicyRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        qos_id: str = None,
        qos_policy_id: str = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.qos_id = qos_id
        self.qos_policy_id = qos_policy_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.qos_id is not None:
            result['QosId'] = self.qos_id
        if self.qos_policy_id is not None:
            result['QosPolicyId'] = self.qos_policy_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('QosId') is not None:
            self.qos_id = m.get('QosId')
        if m.get('QosPolicyId') is not None:
            self.qos_policy_id = m.get('QosPolicyId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteQosPolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteQosPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteQosPolicyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteQosPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRouteDistributionStrategyRequest(TeaModel):
    def __init__(
        self,
        dest_cidr_block: str = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        route_source: str = None,
        smart_agid: str = None,
        source_type: str = None,
    ):
        self.dest_cidr_block = dest_cidr_block
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.route_source = route_source
        self.smart_agid = smart_agid
        self.source_type = source_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dest_cidr_block is not None:
            result['DestCidrBlock'] = self.dest_cidr_block
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.route_source is not None:
            result['RouteSource'] = self.route_source
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DestCidrBlock') is not None:
            self.dest_cidr_block = m.get('DestCidrBlock')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RouteSource') is not None:
            self.route_source = m.get('RouteSource')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        return self


class DeleteRouteDistributionStrategyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteRouteDistributionStrategyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteRouteDistributionStrategyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteRouteDistributionStrategyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSagExpressConnectInterfaceRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        port_name: str = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        smart_agsn: str = None,
        vlan: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.port_name = port_name
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.smart_agsn = smart_agsn
        self.vlan = vlan

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.port_name is not None:
            result['PortName'] = self.port_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_agsn is not None:
            result['SmartAGSn'] = self.smart_agsn
        if self.vlan is not None:
            result['Vlan'] = self.vlan
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PortName') is not None:
            self.port_name = m.get('PortName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGSn') is not None:
            self.smart_agsn = m.get('SmartAGSn')
        if m.get('Vlan') is not None:
            self.vlan = m.get('Vlan')
        return self


class DeleteSagExpressConnectInterfaceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSagExpressConnectInterfaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteSagExpressConnectInterfaceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteSagExpressConnectInterfaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSagStaticRouteRequest(TeaModel):
    def __init__(
        self,
        destination_cidr: str = None,
        owner_account: str = None,
        owner_id: int = None,
        port_name: str = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        smart_agsn: str = None,
        vlan: str = None,
    ):
        self.destination_cidr = destination_cidr
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.port_name = port_name
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.smart_agsn = smart_agsn
        self.vlan = vlan

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.destination_cidr is not None:
            result['DestinationCidr'] = self.destination_cidr
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.port_name is not None:
            result['PortName'] = self.port_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_agsn is not None:
            result['SmartAGSn'] = self.smart_agsn
        if self.vlan is not None:
            result['Vlan'] = self.vlan
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DestinationCidr') is not None:
            self.destination_cidr = m.get('DestinationCidr')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PortName') is not None:
            self.port_name = m.get('PortName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGSn') is not None:
            self.smart_agsn = m.get('SmartAGSn')
        if m.get('Vlan') is not None:
            self.vlan = m.get('Vlan')
        return self


class DeleteSagStaticRouteResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSagStaticRouteResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteSagStaticRouteResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteSagStaticRouteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSmartAccessGatewayRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        region_id: str = None,
        resource_owner_id: int = None,
    ):
        self.instance_id = instance_id
        self.region_id = region_id
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteSmartAccessGatewayResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSmartAccessGatewayResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteSmartAccessGatewayResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteSmartAccessGatewayResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSmartAccessGatewayClientUserRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        user_name: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class DeleteSmartAccessGatewayClientUserResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSmartAccessGatewayClientUserResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteSmartAccessGatewayClientUserResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteSmartAccessGatewayClientUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSnatEntryRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
    ):
        self.instance_id = instance_id
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        return self


class DeleteSnatEntryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSnatEntryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteSnatEntryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteSnatEntryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeACLAttributeRequest(TeaModel):
    def __init__(
        self,
        acl_id: str = None,
        direction: str = None,
        name: str = None,
        order: str = None,
        owner_account: str = None,
        owner_id: int = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.acl_id = acl_id
        self.direction = direction
        self.name = name
        self.order = order
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.page_number = page_number
        self.page_size = page_size
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_id is not None:
            result['AclId'] = self.acl_id
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.name is not None:
            result['Name'] = self.name
        if self.order is not None:
            result['Order'] = self.order
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclId') is not None:
            self.acl_id = m.get('AclId')
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Order') is not None:
            self.order = m.get('Order')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeACLAttributeResponseBodyAcrsAcrDpiGroupIds(TeaModel):
    def __init__(
        self,
        dpi_group_id: List[str] = None,
    ):
        self.dpi_group_id = dpi_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dpi_group_id is not None:
            result['DpiGroupId'] = self.dpi_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DpiGroupId') is not None:
            self.dpi_group_id = m.get('DpiGroupId')
        return self


class DescribeACLAttributeResponseBodyAcrsAcrDpiSignatureIds(TeaModel):
    def __init__(
        self,
        dpi_signature_id: List[str] = None,
    ):
        self.dpi_signature_id = dpi_signature_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dpi_signature_id is not None:
            result['DpiSignatureId'] = self.dpi_signature_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DpiSignatureId') is not None:
            self.dpi_signature_id = m.get('DpiSignatureId')
        return self


class DescribeACLAttributeResponseBodyAcrsAcr(TeaModel):
    def __init__(
        self,
        acl_id: str = None,
        acr_id: str = None,
        description: str = None,
        dest_cidr: str = None,
        dest_port_range: str = None,
        direction: str = None,
        dpi_group_ids: DescribeACLAttributeResponseBodyAcrsAcrDpiGroupIds = None,
        dpi_signature_ids: DescribeACLAttributeResponseBodyAcrsAcrDpiSignatureIds = None,
        gmt_create: int = None,
        ip_protocol: str = None,
        name: str = None,
        policy: str = None,
        priority: int = None,
        source_cidr: str = None,
        source_port_range: str = None,
        type: str = None,
    ):
        self.acl_id = acl_id
        self.acr_id = acr_id
        self.description = description
        self.dest_cidr = dest_cidr
        self.dest_port_range = dest_port_range
        self.direction = direction
        self.dpi_group_ids = dpi_group_ids
        self.dpi_signature_ids = dpi_signature_ids
        self.gmt_create = gmt_create
        self.ip_protocol = ip_protocol
        self.name = name
        self.policy = policy
        self.priority = priority
        self.source_cidr = source_cidr
        self.source_port_range = source_port_range
        self.type = type

    def validate(self):
        if self.dpi_group_ids:
            self.dpi_group_ids.validate()
        if self.dpi_signature_ids:
            self.dpi_signature_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_id is not None:
            result['AclId'] = self.acl_id
        if self.acr_id is not None:
            result['AcrId'] = self.acr_id
        if self.description is not None:
            result['Description'] = self.description
        if self.dest_cidr is not None:
            result['DestCidr'] = self.dest_cidr
        if self.dest_port_range is not None:
            result['DestPortRange'] = self.dest_port_range
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.dpi_group_ids is not None:
            result['DpiGroupIds'] = self.dpi_group_ids.to_map()
        if self.dpi_signature_ids is not None:
            result['DpiSignatureIds'] = self.dpi_signature_ids.to_map()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.ip_protocol is not None:
            result['IpProtocol'] = self.ip_protocol
        if self.name is not None:
            result['Name'] = self.name
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.source_cidr is not None:
            result['SourceCidr'] = self.source_cidr
        if self.source_port_range is not None:
            result['SourcePortRange'] = self.source_port_range
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclId') is not None:
            self.acl_id = m.get('AclId')
        if m.get('AcrId') is not None:
            self.acr_id = m.get('AcrId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DestCidr') is not None:
            self.dest_cidr = m.get('DestCidr')
        if m.get('DestPortRange') is not None:
            self.dest_port_range = m.get('DestPortRange')
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('DpiGroupIds') is not None:
            temp_model = DescribeACLAttributeResponseBodyAcrsAcrDpiGroupIds()
            self.dpi_group_ids = temp_model.from_map(m['DpiGroupIds'])
        if m.get('DpiSignatureIds') is not None:
            temp_model = DescribeACLAttributeResponseBodyAcrsAcrDpiSignatureIds()
            self.dpi_signature_ids = temp_model.from_map(m['DpiSignatureIds'])
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('IpProtocol') is not None:
            self.ip_protocol = m.get('IpProtocol')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('SourceCidr') is not None:
            self.source_cidr = m.get('SourceCidr')
        if m.get('SourcePortRange') is not None:
            self.source_port_range = m.get('SourcePortRange')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeACLAttributeResponseBodyAcrs(TeaModel):
    def __init__(
        self,
        acr: List[DescribeACLAttributeResponseBodyAcrsAcr] = None,
    ):
        self.acr = acr

    def validate(self):
        if self.acr:
            for k in self.acr:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Acr'] = []
        if self.acr is not None:
            for k in self.acr:
                result['Acr'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.acr = []
        if m.get('Acr') is not None:
            for k in m.get('Acr'):
                temp_model = DescribeACLAttributeResponseBodyAcrsAcr()
                self.acr.append(temp_model.from_map(k))
        return self


class DescribeACLAttributeResponseBody(TeaModel):
    def __init__(
        self,
        acrs: DescribeACLAttributeResponseBodyAcrs = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.acrs = acrs
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.acrs:
            self.acrs.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acrs is not None:
            result['Acrs'] = self.acrs.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Acrs') is not None:
            temp_model = DescribeACLAttributeResponseBodyAcrs()
            self.acrs = temp_model.from_map(m['Acrs'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeACLAttributeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeACLAttributeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeACLAttributeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeACLsRequest(TeaModel):
    def __init__(
        self,
        acl_ids: str = None,
        name: str = None,
        owner_account: str = None,
        owner_id: int = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.acl_ids = acl_ids
        self.name = name
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.page_number = page_number
        self.page_size = page_size
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_ids is not None:
            result['AclIds'] = self.acl_ids
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclIds') is not None:
            self.acl_ids = m.get('AclIds')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeACLsResponseBodyAclsAcl(TeaModel):
    def __init__(
        self,
        acl_id: str = None,
        name: str = None,
        resource_group_id: str = None,
        sag_count: str = None,
    ):
        self.acl_id = acl_id
        self.name = name
        self.resource_group_id = resource_group_id
        self.sag_count = sag_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_id is not None:
            result['AclId'] = self.acl_id
        if self.name is not None:
            result['Name'] = self.name
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.sag_count is not None:
            result['SagCount'] = self.sag_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclId') is not None:
            self.acl_id = m.get('AclId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SagCount') is not None:
            self.sag_count = m.get('SagCount')
        return self


class DescribeACLsResponseBodyAcls(TeaModel):
    def __init__(
        self,
        acl: List[DescribeACLsResponseBodyAclsAcl] = None,
    ):
        self.acl = acl

    def validate(self):
        if self.acl:
            for k in self.acl:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Acl'] = []
        if self.acl is not None:
            for k in self.acl:
                result['Acl'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.acl = []
        if m.get('Acl') is not None:
            for k in m.get('Acl'):
                temp_model = DescribeACLsResponseBodyAclsAcl()
                self.acl.append(temp_model.from_map(k))
        return self


class DescribeACLsResponseBody(TeaModel):
    def __init__(
        self,
        acls: DescribeACLsResponseBodyAcls = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.acls = acls
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.acls:
            self.acls.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acls is not None:
            result['Acls'] = self.acls.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Acls') is not None:
            temp_model = DescribeACLsResponseBodyAcls()
            self.acls = temp_model.from_map(m['Acls'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeACLsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeACLsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeACLsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBindableSmartAccessGatewaysRequest(TeaModel):
    def __init__(
        self,
        ccn_id: str = None,
        cross_account: bool = None,
        name: str = None,
        owner_account: str = None,
        owner_id: int = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
    ):
        self.ccn_id = ccn_id
        self.cross_account = cross_account
        self.name = name
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.page_number = page_number
        self.page_size = page_size
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ccn_id is not None:
            result['CcnId'] = self.ccn_id
        if self.cross_account is not None:
            result['CrossAccount'] = self.cross_account
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CcnId') is not None:
            self.ccn_id = m.get('CcnId')
        if m.get('CrossAccount') is not None:
            self.cross_account = m.get('CrossAccount')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        return self


class DescribeBindableSmartAccessGatewaysResponseBodySmartAccessGatewaysSmartAccessGateway(TeaModel):
    def __init__(
        self,
        name: str = None,
        smart_agid: str = None,
        smart_aguid: int = None,
    ):
        self.name = name
        self.smart_agid = smart_agid
        self.smart_aguid = smart_aguid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_aguid is not None:
            result['SmartAGUid'] = self.smart_aguid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGUid') is not None:
            self.smart_aguid = m.get('SmartAGUid')
        return self


class DescribeBindableSmartAccessGatewaysResponseBodySmartAccessGateways(TeaModel):
    def __init__(
        self,
        smart_access_gateway: List[DescribeBindableSmartAccessGatewaysResponseBodySmartAccessGatewaysSmartAccessGateway] = None,
    ):
        self.smart_access_gateway = smart_access_gateway

    def validate(self):
        if self.smart_access_gateway:
            for k in self.smart_access_gateway:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SmartAccessGateway'] = []
        if self.smart_access_gateway is not None:
            for k in self.smart_access_gateway:
                result['SmartAccessGateway'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.smart_access_gateway = []
        if m.get('SmartAccessGateway') is not None:
            for k in m.get('SmartAccessGateway'):
                temp_model = DescribeBindableSmartAccessGatewaysResponseBodySmartAccessGatewaysSmartAccessGateway()
                self.smart_access_gateway.append(temp_model.from_map(k))
        return self


class DescribeBindableSmartAccessGatewaysResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        smart_access_gateways: DescribeBindableSmartAccessGatewaysResponseBodySmartAccessGateways = None,
        total_count: int = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.smart_access_gateways = smart_access_gateways
        self.total_count = total_count

    def validate(self):
        if self.smart_access_gateways:
            self.smart_access_gateways.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.smart_access_gateways is not None:
            result['SmartAccessGateways'] = self.smart_access_gateways.to_map()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SmartAccessGateways') is not None:
            temp_model = DescribeBindableSmartAccessGatewaysResponseBodySmartAccessGateways()
            self.smart_access_gateways = temp_model.from_map(m['SmartAccessGateways'])
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeBindableSmartAccessGatewaysResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeBindableSmartAccessGatewaysResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeBindableSmartAccessGatewaysResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeClientUserDNSRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        return self


class DescribeClientUserDNSResponseBody(TeaModel):
    def __init__(
        self,
        app_dns: List[str] = None,
        recovered_dns: List[str] = None,
        request_id: str = None,
    ):
        self.app_dns = app_dns
        self.recovered_dns = recovered_dns
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_dns is not None:
            result['AppDNS'] = self.app_dns
        if self.recovered_dns is not None:
            result['RecoveredDNS'] = self.recovered_dns
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppDNS') is not None:
            self.app_dns = m.get('AppDNS')
        if m.get('RecoveredDNS') is not None:
            self.recovered_dns = m.get('RecoveredDNS')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeClientUserDNSResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeClientUserDNSResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeClientUserDNSResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCloudConnectNetworksRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeCloudConnectNetworksRequest(TeaModel):
    def __init__(
        self,
        ccn_id: str = None,
        name: str = None,
        owner_account: str = None,
        owner_id: int = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        tag: List[DescribeCloudConnectNetworksRequestTag] = None,
    ):
        self.ccn_id = ccn_id
        self.name = name
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.page_number = page_number
        self.page_size = page_size
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ccn_id is not None:
            result['CcnId'] = self.ccn_id
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CcnId') is not None:
            self.ccn_id = m.get('CcnId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeCloudConnectNetworksRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeCloudConnectNetworksResponseBodyCloudConnectNetworksCloudConnectNetworkTagsTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeCloudConnectNetworksResponseBodyCloudConnectNetworksCloudConnectNetworkTags(TeaModel):
    def __init__(
        self,
        tag: List[DescribeCloudConnectNetworksResponseBodyCloudConnectNetworksCloudConnectNetworkTagsTag] = None,
    ):
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeCloudConnectNetworksResponseBodyCloudConnectNetworksCloudConnectNetworkTagsTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeCloudConnectNetworksResponseBodyCloudConnectNetworksCloudConnectNetwork(TeaModel):
    def __init__(
        self,
        associated_cen_id: str = None,
        associated_cen_owner_id: str = None,
        associated_cloud_box_count: str = None,
        available_cloud_box_count: str = None,
        ccn_id: str = None,
        cidr_block: str = None,
        create_time: int = None,
        description: str = None,
        interworking_status: str = None,
        name: str = None,
        resource_group_id: str = None,
        snat_cidr_block: str = None,
        tags: DescribeCloudConnectNetworksResponseBodyCloudConnectNetworksCloudConnectNetworkTags = None,
    ):
        self.associated_cen_id = associated_cen_id
        self.associated_cen_owner_id = associated_cen_owner_id
        self.associated_cloud_box_count = associated_cloud_box_count
        self.available_cloud_box_count = available_cloud_box_count
        self.ccn_id = ccn_id
        self.cidr_block = cidr_block
        self.create_time = create_time
        self.description = description
        self.interworking_status = interworking_status
        self.name = name
        self.resource_group_id = resource_group_id
        self.snat_cidr_block = snat_cidr_block
        self.tags = tags

    def validate(self):
        if self.tags:
            self.tags.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.associated_cen_id is not None:
            result['AssociatedCenId'] = self.associated_cen_id
        if self.associated_cen_owner_id is not None:
            result['AssociatedCenOwnerId'] = self.associated_cen_owner_id
        if self.associated_cloud_box_count is not None:
            result['AssociatedCloudBoxCount'] = self.associated_cloud_box_count
        if self.available_cloud_box_count is not None:
            result['AvailableCloudBoxCount'] = self.available_cloud_box_count
        if self.ccn_id is not None:
            result['CcnId'] = self.ccn_id
        if self.cidr_block is not None:
            result['CidrBlock'] = self.cidr_block
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.interworking_status is not None:
            result['InterworkingStatus'] = self.interworking_status
        if self.name is not None:
            result['Name'] = self.name
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.snat_cidr_block is not None:
            result['SnatCidrBlock'] = self.snat_cidr_block
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AssociatedCenId') is not None:
            self.associated_cen_id = m.get('AssociatedCenId')
        if m.get('AssociatedCenOwnerId') is not None:
            self.associated_cen_owner_id = m.get('AssociatedCenOwnerId')
        if m.get('AssociatedCloudBoxCount') is not None:
            self.associated_cloud_box_count = m.get('AssociatedCloudBoxCount')
        if m.get('AvailableCloudBoxCount') is not None:
            self.available_cloud_box_count = m.get('AvailableCloudBoxCount')
        if m.get('CcnId') is not None:
            self.ccn_id = m.get('CcnId')
        if m.get('CidrBlock') is not None:
            self.cidr_block = m.get('CidrBlock')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InterworkingStatus') is not None:
            self.interworking_status = m.get('InterworkingStatus')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SnatCidrBlock') is not None:
            self.snat_cidr_block = m.get('SnatCidrBlock')
        if m.get('Tags') is not None:
            temp_model = DescribeCloudConnectNetworksResponseBodyCloudConnectNetworksCloudConnectNetworkTags()
            self.tags = temp_model.from_map(m['Tags'])
        return self


class DescribeCloudConnectNetworksResponseBodyCloudConnectNetworks(TeaModel):
    def __init__(
        self,
        cloud_connect_network: List[DescribeCloudConnectNetworksResponseBodyCloudConnectNetworksCloudConnectNetwork] = None,
    ):
        self.cloud_connect_network = cloud_connect_network

    def validate(self):
        if self.cloud_connect_network:
            for k in self.cloud_connect_network:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CloudConnectNetwork'] = []
        if self.cloud_connect_network is not None:
            for k in self.cloud_connect_network:
                result['CloudConnectNetwork'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cloud_connect_network = []
        if m.get('CloudConnectNetwork') is not None:
            for k in m.get('CloudConnectNetwork'):
                temp_model = DescribeCloudConnectNetworksResponseBodyCloudConnectNetworksCloudConnectNetwork()
                self.cloud_connect_network.append(temp_model.from_map(k))
        return self


class DescribeCloudConnectNetworksResponseBody(TeaModel):
    def __init__(
        self,
        cloud_connect_networks: DescribeCloudConnectNetworksResponseBodyCloudConnectNetworks = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.cloud_connect_networks = cloud_connect_networks
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.cloud_connect_networks:
            self.cloud_connect_networks.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cloud_connect_networks is not None:
            result['CloudConnectNetworks'] = self.cloud_connect_networks.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CloudConnectNetworks') is not None:
            temp_model = DescribeCloudConnectNetworksResponseBodyCloudConnectNetworks()
            self.cloud_connect_networks = temp_model.from_map(m['CloudConnectNetworks'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeCloudConnectNetworksResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeCloudConnectNetworksResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCloudConnectNetworksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDeviceAutoUpgradePolicyRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        serial_number: str = None,
        smart_agid: str = None,
        version_type: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.serial_number = serial_number
        self.smart_agid = smart_agid
        self.version_type = version_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.serial_number is not None:
            result['SerialNumber'] = self.serial_number
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.version_type is not None:
            result['VersionType'] = self.version_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SerialNumber') is not None:
            self.serial_number = m.get('SerialNumber')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('VersionType') is not None:
            self.version_type = m.get('VersionType')
        return self


class DescribeDeviceAutoUpgradePolicyResponseBody(TeaModel):
    def __init__(
        self,
        cron_expression: str = None,
        duration: str = None,
        jitter: str = None,
        request_id: str = None,
        serial_number: str = None,
        smart_agid: str = None,
        time_zone: str = None,
        upgrade_type: str = None,
    ):
        self.cron_expression = cron_expression
        self.duration = duration
        self.jitter = jitter
        self.request_id = request_id
        self.serial_number = serial_number
        self.smart_agid = smart_agid
        self.time_zone = time_zone
        self.upgrade_type = upgrade_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cron_expression is not None:
            result['CronExpression'] = self.cron_expression
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.jitter is not None:
            result['Jitter'] = self.jitter
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.serial_number is not None:
            result['SerialNumber'] = self.serial_number
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.time_zone is not None:
            result['TimeZone'] = self.time_zone
        if self.upgrade_type is not None:
            result['UpgradeType'] = self.upgrade_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CronExpression') is not None:
            self.cron_expression = m.get('CronExpression')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('Jitter') is not None:
            self.jitter = m.get('Jitter')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SerialNumber') is not None:
            self.serial_number = m.get('SerialNumber')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('TimeZone') is not None:
            self.time_zone = m.get('TimeZone')
        if m.get('UpgradeType') is not None:
            self.upgrade_type = m.get('UpgradeType')
        return self


class DescribeDeviceAutoUpgradePolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDeviceAutoUpgradePolicyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDeviceAutoUpgradePolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDnatEntriesRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        sag_id: str = None,
        type: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.page_number = page_number
        self.page_size = page_size
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.sag_id = sag_id
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.sag_id is not None:
            result['SagId'] = self.sag_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SagId') is not None:
            self.sag_id = m.get('SagId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeDnatEntriesResponseBodyDnatEntriesDnatEntry(TeaModel):
    def __init__(
        self,
        dnat_entry_id: str = None,
        external_ip: str = None,
        external_port: str = None,
        internal_ip: str = None,
        internal_port: str = None,
        ip_protocol: str = None,
        sag_id: str = None,
        type: str = None,
    ):
        self.dnat_entry_id = dnat_entry_id
        self.external_ip = external_ip
        self.external_port = external_port
        self.internal_ip = internal_ip
        self.internal_port = internal_port
        self.ip_protocol = ip_protocol
        self.sag_id = sag_id
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dnat_entry_id is not None:
            result['DnatEntryId'] = self.dnat_entry_id
        if self.external_ip is not None:
            result['ExternalIp'] = self.external_ip
        if self.external_port is not None:
            result['ExternalPort'] = self.external_port
        if self.internal_ip is not None:
            result['InternalIp'] = self.internal_ip
        if self.internal_port is not None:
            result['InternalPort'] = self.internal_port
        if self.ip_protocol is not None:
            result['IpProtocol'] = self.ip_protocol
        if self.sag_id is not None:
            result['SagId'] = self.sag_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DnatEntryId') is not None:
            self.dnat_entry_id = m.get('DnatEntryId')
        if m.get('ExternalIp') is not None:
            self.external_ip = m.get('ExternalIp')
        if m.get('ExternalPort') is not None:
            self.external_port = m.get('ExternalPort')
        if m.get('InternalIp') is not None:
            self.internal_ip = m.get('InternalIp')
        if m.get('InternalPort') is not None:
            self.internal_port = m.get('InternalPort')
        if m.get('IpProtocol') is not None:
            self.ip_protocol = m.get('IpProtocol')
        if m.get('SagId') is not None:
            self.sag_id = m.get('SagId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeDnatEntriesResponseBodyDnatEntries(TeaModel):
    def __init__(
        self,
        dnat_entry: List[DescribeDnatEntriesResponseBodyDnatEntriesDnatEntry] = None,
    ):
        self.dnat_entry = dnat_entry

    def validate(self):
        if self.dnat_entry:
            for k in self.dnat_entry:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DnatEntry'] = []
        if self.dnat_entry is not None:
            for k in self.dnat_entry:
                result['DnatEntry'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dnat_entry = []
        if m.get('DnatEntry') is not None:
            for k in m.get('DnatEntry'):
                temp_model = DescribeDnatEntriesResponseBodyDnatEntriesDnatEntry()
                self.dnat_entry.append(temp_model.from_map(k))
        return self


class DescribeDnatEntriesResponseBody(TeaModel):
    def __init__(
        self,
        dnat_entries: DescribeDnatEntriesResponseBodyDnatEntries = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.dnat_entries = dnat_entries
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.dnat_entries:
            self.dnat_entries.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dnat_entries is not None:
            result['DnatEntries'] = self.dnat_entries.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DnatEntries') is not None:
            temp_model = DescribeDnatEntriesResponseBodyDnatEntries()
            self.dnat_entries = temp_model.from_map(m['DnatEntries'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDnatEntriesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDnatEntriesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDnatEntriesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFlowLogSagsRequest(TeaModel):
    def __init__(
        self,
        flow_log_id: str = None,
        owner_account: str = None,
        owner_id: int = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.flow_log_id = flow_log_id
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.page_number = page_number
        self.page_size = page_size
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flow_log_id is not None:
            result['FlowLogId'] = self.flow_log_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FlowLogId') is not None:
            self.flow_log_id = m.get('FlowLogId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeFlowLogSagsResponseBodySagsSag(TeaModel):
    def __init__(
        self,
        description: str = None,
        name: str = None,
        smart_agid: str = None,
    ):
        self.description = description
        self.name = name
        self.smart_agid = smart_agid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        return self


class DescribeFlowLogSagsResponseBodySags(TeaModel):
    def __init__(
        self,
        sag: List[DescribeFlowLogSagsResponseBodySagsSag] = None,
    ):
        self.sag = sag

    def validate(self):
        if self.sag:
            for k in self.sag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Sag'] = []
        if self.sag is not None:
            for k in self.sag:
                result['Sag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.sag = []
        if m.get('Sag') is not None:
            for k in m.get('Sag'):
                temp_model = DescribeFlowLogSagsResponseBodySagsSag()
                self.sag.append(temp_model.from_map(k))
        return self


class DescribeFlowLogSagsResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        sags: DescribeFlowLogSagsResponseBodySags = None,
        total_count: int = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.sags = sags
        self.total_count = total_count

    def validate(self):
        if self.sags:
            self.sags.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sags is not None:
            result['Sags'] = self.sags.to_map()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Sags') is not None:
            temp_model = DescribeFlowLogSagsResponseBodySags()
            self.sags = temp_model.from_map(m['Sags'])
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeFlowLogSagsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeFlowLogSagsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeFlowLogSagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFlowLogsRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        flow_log_id: str = None,
        flow_log_name: str = None,
        output_type: str = None,
        owner_account: str = None,
        owner_id: int = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        status: str = None,
    ):
        self.description = description
        self.flow_log_id = flow_log_id
        self.flow_log_name = flow_log_name
        self.output_type = output_type
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.page_number = page_number
        self.page_size = page_size
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.flow_log_id is not None:
            result['FlowLogId'] = self.flow_log_id
        if self.flow_log_name is not None:
            result['FlowLogName'] = self.flow_log_name
        if self.output_type is not None:
            result['OutputType'] = self.output_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('FlowLogId') is not None:
            self.flow_log_id = m.get('FlowLogId')
        if m.get('FlowLogName') is not None:
            self.flow_log_name = m.get('FlowLogName')
        if m.get('OutputType') is not None:
            self.output_type = m.get('OutputType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeFlowLogsResponseBodyFlowLogsFlowLogSetType(TeaModel):
    def __init__(
        self,
        active_aging: int = None,
        description: str = None,
        flow_log_id: str = None,
        inactive_aging: int = None,
        logstore_name: str = None,
        name: str = None,
        netflow_server_ip: str = None,
        netflow_server_port: str = None,
        netflow_version: str = None,
        output_type: str = None,
        project_name: str = None,
        resource_group_id: str = None,
        sls_region_id: str = None,
        status: str = None,
        total_sag_num: int = None,
    ):
        self.active_aging = active_aging
        self.description = description
        self.flow_log_id = flow_log_id
        self.inactive_aging = inactive_aging
        self.logstore_name = logstore_name
        self.name = name
        self.netflow_server_ip = netflow_server_ip
        self.netflow_server_port = netflow_server_port
        self.netflow_version = netflow_version
        self.output_type = output_type
        self.project_name = project_name
        self.resource_group_id = resource_group_id
        self.sls_region_id = sls_region_id
        self.status = status
        self.total_sag_num = total_sag_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active_aging is not None:
            result['ActiveAging'] = self.active_aging
        if self.description is not None:
            result['Description'] = self.description
        if self.flow_log_id is not None:
            result['FlowLogId'] = self.flow_log_id
        if self.inactive_aging is not None:
            result['InactiveAging'] = self.inactive_aging
        if self.logstore_name is not None:
            result['LogstoreName'] = self.logstore_name
        if self.name is not None:
            result['Name'] = self.name
        if self.netflow_server_ip is not None:
            result['NetflowServerIp'] = self.netflow_server_ip
        if self.netflow_server_port is not None:
            result['NetflowServerPort'] = self.netflow_server_port
        if self.netflow_version is not None:
            result['NetflowVersion'] = self.netflow_version
        if self.output_type is not None:
            result['OutputType'] = self.output_type
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.sls_region_id is not None:
            result['SlsRegionId'] = self.sls_region_id
        if self.status is not None:
            result['Status'] = self.status
        if self.total_sag_num is not None:
            result['TotalSagNum'] = self.total_sag_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ActiveAging') is not None:
            self.active_aging = m.get('ActiveAging')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('FlowLogId') is not None:
            self.flow_log_id = m.get('FlowLogId')
        if m.get('InactiveAging') is not None:
            self.inactive_aging = m.get('InactiveAging')
        if m.get('LogstoreName') is not None:
            self.logstore_name = m.get('LogstoreName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NetflowServerIp') is not None:
            self.netflow_server_ip = m.get('NetflowServerIp')
        if m.get('NetflowServerPort') is not None:
            self.netflow_server_port = m.get('NetflowServerPort')
        if m.get('NetflowVersion') is not None:
            self.netflow_version = m.get('NetflowVersion')
        if m.get('OutputType') is not None:
            self.output_type = m.get('OutputType')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SlsRegionId') is not None:
            self.sls_region_id = m.get('SlsRegionId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TotalSagNum') is not None:
            self.total_sag_num = m.get('TotalSagNum')
        return self


class DescribeFlowLogsResponseBodyFlowLogs(TeaModel):
    def __init__(
        self,
        flow_log_set_type: List[DescribeFlowLogsResponseBodyFlowLogsFlowLogSetType] = None,
    ):
        self.flow_log_set_type = flow_log_set_type

    def validate(self):
        if self.flow_log_set_type:
            for k in self.flow_log_set_type:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FlowLogSetType'] = []
        if self.flow_log_set_type is not None:
            for k in self.flow_log_set_type:
                result['FlowLogSetType'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.flow_log_set_type = []
        if m.get('FlowLogSetType') is not None:
            for k in m.get('FlowLogSetType'):
                temp_model = DescribeFlowLogsResponseBodyFlowLogsFlowLogSetType()
                self.flow_log_set_type.append(temp_model.from_map(k))
        return self


class DescribeFlowLogsResponseBody(TeaModel):
    def __init__(
        self,
        flow_logs: DescribeFlowLogsResponseBodyFlowLogs = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.flow_logs = flow_logs
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.flow_logs:
            self.flow_logs.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flow_logs is not None:
            result['FlowLogs'] = self.flow_logs.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FlowLogs') is not None:
            temp_model = DescribeFlowLogsResponseBodyFlowLogs()
            self.flow_logs = temp_model.from_map(m['FlowLogs'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeFlowLogsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeFlowLogsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeFlowLogsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGrantRulesRequest(TeaModel):
    def __init__(
        self,
        associated_ccn_id: str = None,
        owner_account: str = None,
        owner_id: int = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.associated_ccn_id = associated_ccn_id
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.page_number = page_number
        self.page_size = page_size
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.associated_ccn_id is not None:
            result['AssociatedCcnId'] = self.associated_ccn_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AssociatedCcnId') is not None:
            self.associated_ccn_id = m.get('AssociatedCcnId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeGrantRulesResponseBodyGrantRulesGrantRule(TeaModel):
    def __init__(
        self,
        ccn_instance_id: str = None,
        ccn_uid: int = None,
        cen_instance_id: str = None,
        cen_uid: int = None,
        gmt_create: int = None,
        gmt_modified: int = None,
        grant_rule_id: str = None,
        grant_traffic_service: bool = None,
        region_id: str = None,
    ):
        self.ccn_instance_id = ccn_instance_id
        self.ccn_uid = ccn_uid
        self.cen_instance_id = cen_instance_id
        self.cen_uid = cen_uid
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.grant_rule_id = grant_rule_id
        self.grant_traffic_service = grant_traffic_service
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ccn_instance_id is not None:
            result['CcnInstanceId'] = self.ccn_instance_id
        if self.ccn_uid is not None:
            result['CcnUid'] = self.ccn_uid
        if self.cen_instance_id is not None:
            result['CenInstanceId'] = self.cen_instance_id
        if self.cen_uid is not None:
            result['CenUid'] = self.cen_uid
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.grant_rule_id is not None:
            result['GrantRuleId'] = self.grant_rule_id
        if self.grant_traffic_service is not None:
            result['GrantTrafficService'] = self.grant_traffic_service
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CcnInstanceId') is not None:
            self.ccn_instance_id = m.get('CcnInstanceId')
        if m.get('CcnUid') is not None:
            self.ccn_uid = m.get('CcnUid')
        if m.get('CenInstanceId') is not None:
            self.cen_instance_id = m.get('CenInstanceId')
        if m.get('CenUid') is not None:
            self.cen_uid = m.get('CenUid')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('GrantRuleId') is not None:
            self.grant_rule_id = m.get('GrantRuleId')
        if m.get('GrantTrafficService') is not None:
            self.grant_traffic_service = m.get('GrantTrafficService')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeGrantRulesResponseBodyGrantRules(TeaModel):
    def __init__(
        self,
        grant_rule: List[DescribeGrantRulesResponseBodyGrantRulesGrantRule] = None,
    ):
        self.grant_rule = grant_rule

    def validate(self):
        if self.grant_rule:
            for k in self.grant_rule:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['GrantRule'] = []
        if self.grant_rule is not None:
            for k in self.grant_rule:
                result['GrantRule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.grant_rule = []
        if m.get('GrantRule') is not None:
            for k in m.get('GrantRule'):
                temp_model = DescribeGrantRulesResponseBodyGrantRulesGrantRule()
                self.grant_rule.append(temp_model.from_map(k))
        return self


class DescribeGrantRulesResponseBody(TeaModel):
    def __init__(
        self,
        grant_rules: DescribeGrantRulesResponseBodyGrantRules = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.grant_rules = grant_rules
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.grant_rules:
            self.grant_rules.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.grant_rules is not None:
            result['GrantRules'] = self.grant_rules.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GrantRules') is not None:
            temp_model = DescribeGrantRulesResponseBodyGrantRules()
            self.grant_rules = temp_model.from_map(m['GrantRules'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeGrantRulesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeGrantRulesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeGrantRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGrantSagRulesRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.page_number = page_number
        self.page_size = page_size
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        return self


class DescribeGrantSagRulesResponseBodyGrantRulesGrantRule(TeaModel):
    def __init__(
        self,
        ccn_instance_id: str = None,
        ccn_uid: int = None,
        create_time: int = None,
        grant_traffic_service: bool = None,
        instance_id: str = None,
        smart_agid: str = None,
    ):
        self.ccn_instance_id = ccn_instance_id
        self.ccn_uid = ccn_uid
        self.create_time = create_time
        self.grant_traffic_service = grant_traffic_service
        self.instance_id = instance_id
        self.smart_agid = smart_agid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ccn_instance_id is not None:
            result['CcnInstanceId'] = self.ccn_instance_id
        if self.ccn_uid is not None:
            result['CcnUid'] = self.ccn_uid
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.grant_traffic_service is not None:
            result['GrantTrafficService'] = self.grant_traffic_service
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CcnInstanceId') is not None:
            self.ccn_instance_id = m.get('CcnInstanceId')
        if m.get('CcnUid') is not None:
            self.ccn_uid = m.get('CcnUid')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('GrantTrafficService') is not None:
            self.grant_traffic_service = m.get('GrantTrafficService')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        return self


class DescribeGrantSagRulesResponseBodyGrantRules(TeaModel):
    def __init__(
        self,
        grant_rule: List[DescribeGrantSagRulesResponseBodyGrantRulesGrantRule] = None,
    ):
        self.grant_rule = grant_rule

    def validate(self):
        if self.grant_rule:
            for k in self.grant_rule:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['GrantRule'] = []
        if self.grant_rule is not None:
            for k in self.grant_rule:
                result['GrantRule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.grant_rule = []
        if m.get('GrantRule') is not None:
            for k in m.get('GrantRule'):
                temp_model = DescribeGrantSagRulesResponseBodyGrantRulesGrantRule()
                self.grant_rule.append(temp_model.from_map(k))
        return self


class DescribeGrantSagRulesResponseBody(TeaModel):
    def __init__(
        self,
        grant_rules: DescribeGrantSagRulesResponseBodyGrantRules = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.grant_rules = grant_rules
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.grant_rules:
            self.grant_rules.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.grant_rules is not None:
            result['GrantRules'] = self.grant_rules.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GrantRules') is not None:
            temp_model = DescribeGrantSagRulesResponseBodyGrantRules()
            self.grant_rules = temp_model.from_map(m['GrantRules'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeGrantSagRulesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeGrantSagRulesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeGrantSagRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGrantSagVbrRulesRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        vbr_instance_id: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.page_number = page_number
        self.page_size = page_size
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.vbr_instance_id = vbr_instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.vbr_instance_id is not None:
            result['VbrInstanceId'] = self.vbr_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('VbrInstanceId') is not None:
            self.vbr_instance_id = m.get('VbrInstanceId')
        return self


class DescribeGrantSagVbrRulesResponseBodyGrantRulesGrantRule(TeaModel):
    def __init__(
        self,
        bound: bool = None,
        create_time: int = None,
        instance_id: str = None,
        smart_agid: str = None,
        smart_aguid: int = None,
        vbr_instance_id: str = None,
        vbr_region_id: str = None,
        vbr_uid: int = None,
    ):
        self.bound = bound
        self.create_time = create_time
        self.instance_id = instance_id
        self.smart_agid = smart_agid
        self.smart_aguid = smart_aguid
        self.vbr_instance_id = vbr_instance_id
        self.vbr_region_id = vbr_region_id
        self.vbr_uid = vbr_uid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bound is not None:
            result['Bound'] = self.bound
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_aguid is not None:
            result['SmartAGUid'] = self.smart_aguid
        if self.vbr_instance_id is not None:
            result['VbrInstanceId'] = self.vbr_instance_id
        if self.vbr_region_id is not None:
            result['VbrRegionId'] = self.vbr_region_id
        if self.vbr_uid is not None:
            result['VbrUid'] = self.vbr_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bound') is not None:
            self.bound = m.get('Bound')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGUid') is not None:
            self.smart_aguid = m.get('SmartAGUid')
        if m.get('VbrInstanceId') is not None:
            self.vbr_instance_id = m.get('VbrInstanceId')
        if m.get('VbrRegionId') is not None:
            self.vbr_region_id = m.get('VbrRegionId')
        if m.get('VbrUid') is not None:
            self.vbr_uid = m.get('VbrUid')
        return self


class DescribeGrantSagVbrRulesResponseBodyGrantRules(TeaModel):
    def __init__(
        self,
        grant_rule: List[DescribeGrantSagVbrRulesResponseBodyGrantRulesGrantRule] = None,
    ):
        self.grant_rule = grant_rule

    def validate(self):
        if self.grant_rule:
            for k in self.grant_rule:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['GrantRule'] = []
        if self.grant_rule is not None:
            for k in self.grant_rule:
                result['GrantRule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.grant_rule = []
        if m.get('GrantRule') is not None:
            for k in m.get('GrantRule'):
                temp_model = DescribeGrantSagVbrRulesResponseBodyGrantRulesGrantRule()
                self.grant_rule.append(temp_model.from_map(k))
        return self


class DescribeGrantSagVbrRulesResponseBody(TeaModel):
    def __init__(
        self,
        grant_rules: DescribeGrantSagVbrRulesResponseBodyGrantRules = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.grant_rules = grant_rules
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.grant_rules:
            self.grant_rules.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.grant_rules is not None:
            result['GrantRules'] = self.grant_rules.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GrantRules') is not None:
            temp_model = DescribeGrantSagVbrRulesResponseBodyGrantRules()
            self.grant_rules = temp_model.from_map(m['GrantRules'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeGrantSagVbrRulesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeGrantSagVbrRulesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeGrantSagVbrRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHealthCheckAttributeRequest(TeaModel):
    def __init__(
        self,
        hc_instance_id: str = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
    ):
        self.hc_instance_id = hc_instance_id
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hc_instance_id is not None:
            result['HcInstanceId'] = self.hc_instance_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HcInstanceId') is not None:
            self.hc_instance_id = m.get('HcInstanceId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        return self


class DescribeHealthCheckAttributeResponseBody(TeaModel):
    def __init__(
        self,
        create_time: int = None,
        description: str = None,
        dst_ip_addr: str = None,
        dst_port: int = None,
        fail_count_threshold: int = None,
        hc_instance_id: str = None,
        name: str = None,
        probe_count: int = None,
        probe_interval: int = None,
        probe_timeout: int = None,
        request_id: str = None,
        rtt_fail_threshold: int = None,
        rtt_threshold: int = None,
        smart_agid: str = None,
        src_ip_addr: str = None,
        src_port: int = None,
        type: str = None,
    ):
        self.create_time = create_time
        self.description = description
        self.dst_ip_addr = dst_ip_addr
        self.dst_port = dst_port
        self.fail_count_threshold = fail_count_threshold
        self.hc_instance_id = hc_instance_id
        self.name = name
        self.probe_count = probe_count
        self.probe_interval = probe_interval
        self.probe_timeout = probe_timeout
        self.request_id = request_id
        self.rtt_fail_threshold = rtt_fail_threshold
        self.rtt_threshold = rtt_threshold
        self.smart_agid = smart_agid
        self.src_ip_addr = src_ip_addr
        self.src_port = src_port
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.dst_ip_addr is not None:
            result['DstIpAddr'] = self.dst_ip_addr
        if self.dst_port is not None:
            result['DstPort'] = self.dst_port
        if self.fail_count_threshold is not None:
            result['FailCountThreshold'] = self.fail_count_threshold
        if self.hc_instance_id is not None:
            result['HcInstanceId'] = self.hc_instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.probe_count is not None:
            result['ProbeCount'] = self.probe_count
        if self.probe_interval is not None:
            result['ProbeInterval'] = self.probe_interval
        if self.probe_timeout is not None:
            result['ProbeTimeout'] = self.probe_timeout
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.rtt_fail_threshold is not None:
            result['RttFailThreshold'] = self.rtt_fail_threshold
        if self.rtt_threshold is not None:
            result['RttThreshold'] = self.rtt_threshold
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.src_ip_addr is not None:
            result['SrcIpAddr'] = self.src_ip_addr
        if self.src_port is not None:
            result['SrcPort'] = self.src_port
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DstIpAddr') is not None:
            self.dst_ip_addr = m.get('DstIpAddr')
        if m.get('DstPort') is not None:
            self.dst_port = m.get('DstPort')
        if m.get('FailCountThreshold') is not None:
            self.fail_count_threshold = m.get('FailCountThreshold')
        if m.get('HcInstanceId') is not None:
            self.hc_instance_id = m.get('HcInstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ProbeCount') is not None:
            self.probe_count = m.get('ProbeCount')
        if m.get('ProbeInterval') is not None:
            self.probe_interval = m.get('ProbeInterval')
        if m.get('ProbeTimeout') is not None:
            self.probe_timeout = m.get('ProbeTimeout')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RttFailThreshold') is not None:
            self.rtt_fail_threshold = m.get('RttFailThreshold')
        if m.get('RttThreshold') is not None:
            self.rtt_threshold = m.get('RttThreshold')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SrcIpAddr') is not None:
            self.src_ip_addr = m.get('SrcIpAddr')
        if m.get('SrcPort') is not None:
            self.src_port = m.get('SrcPort')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeHealthCheckAttributeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeHealthCheckAttributeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeHealthCheckAttributeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHealthChecksRequest(TeaModel):
    def __init__(
        self,
        hc_instance_id: str = None,
        name: str = None,
        owner_account: str = None,
        owner_id: int = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
    ):
        self.hc_instance_id = hc_instance_id
        self.name = name
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.page_number = page_number
        self.page_size = page_size
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hc_instance_id is not None:
            result['HcInstanceId'] = self.hc_instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HcInstanceId') is not None:
            self.hc_instance_id = m.get('HcInstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        return self


class DescribeHealthChecksResponseBodyHealthChecksHealthCheck(TeaModel):
    def __init__(
        self,
        description: str = None,
        dst_ip_addr: str = None,
        dst_port: int = None,
        fail_count_threshold: int = None,
        hc_instance_id: str = None,
        name: str = None,
        probe_count: int = None,
        probe_interval: int = None,
        probe_timeout: int = None,
        relation_count: int = None,
        rtt_fail_threshold: int = None,
        rtt_threshold: int = None,
        smart_agid: str = None,
        src_ip_addr: str = None,
        src_port: int = None,
        status: str = None,
        type: str = None,
    ):
        self.description = description
        self.dst_ip_addr = dst_ip_addr
        self.dst_port = dst_port
        self.fail_count_threshold = fail_count_threshold
        self.hc_instance_id = hc_instance_id
        self.name = name
        self.probe_count = probe_count
        self.probe_interval = probe_interval
        self.probe_timeout = probe_timeout
        self.relation_count = relation_count
        self.rtt_fail_threshold = rtt_fail_threshold
        self.rtt_threshold = rtt_threshold
        self.smart_agid = smart_agid
        self.src_ip_addr = src_ip_addr
        self.src_port = src_port
        self.status = status
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.dst_ip_addr is not None:
            result['DstIpAddr'] = self.dst_ip_addr
        if self.dst_port is not None:
            result['DstPort'] = self.dst_port
        if self.fail_count_threshold is not None:
            result['FailCountThreshold'] = self.fail_count_threshold
        if self.hc_instance_id is not None:
            result['HcInstanceId'] = self.hc_instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.probe_count is not None:
            result['ProbeCount'] = self.probe_count
        if self.probe_interval is not None:
            result['ProbeInterval'] = self.probe_interval
        if self.probe_timeout is not None:
            result['ProbeTimeout'] = self.probe_timeout
        if self.relation_count is not None:
            result['RelationCount'] = self.relation_count
        if self.rtt_fail_threshold is not None:
            result['RttFailThreshold'] = self.rtt_fail_threshold
        if self.rtt_threshold is not None:
            result['RttThreshold'] = self.rtt_threshold
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.src_ip_addr is not None:
            result['SrcIpAddr'] = self.src_ip_addr
        if self.src_port is not None:
            result['SrcPort'] = self.src_port
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DstIpAddr') is not None:
            self.dst_ip_addr = m.get('DstIpAddr')
        if m.get('DstPort') is not None:
            self.dst_port = m.get('DstPort')
        if m.get('FailCountThreshold') is not None:
            self.fail_count_threshold = m.get('FailCountThreshold')
        if m.get('HcInstanceId') is not None:
            self.hc_instance_id = m.get('HcInstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ProbeCount') is not None:
            self.probe_count = m.get('ProbeCount')
        if m.get('ProbeInterval') is not None:
            self.probe_interval = m.get('ProbeInterval')
        if m.get('ProbeTimeout') is not None:
            self.probe_timeout = m.get('ProbeTimeout')
        if m.get('RelationCount') is not None:
            self.relation_count = m.get('RelationCount')
        if m.get('RttFailThreshold') is not None:
            self.rtt_fail_threshold = m.get('RttFailThreshold')
        if m.get('RttThreshold') is not None:
            self.rtt_threshold = m.get('RttThreshold')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SrcIpAddr') is not None:
            self.src_ip_addr = m.get('SrcIpAddr')
        if m.get('SrcPort') is not None:
            self.src_port = m.get('SrcPort')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeHealthChecksResponseBodyHealthChecks(TeaModel):
    def __init__(
        self,
        health_check: List[DescribeHealthChecksResponseBodyHealthChecksHealthCheck] = None,
    ):
        self.health_check = health_check

    def validate(self):
        if self.health_check:
            for k in self.health_check:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['HealthCheck'] = []
        if self.health_check is not None:
            for k in self.health_check:
                result['HealthCheck'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.health_check = []
        if m.get('HealthCheck') is not None:
            for k in m.get('HealthCheck'):
                temp_model = DescribeHealthChecksResponseBodyHealthChecksHealthCheck()
                self.health_check.append(temp_model.from_map(k))
        return self


class DescribeHealthChecksResponseBody(TeaModel):
    def __init__(
        self,
        health_checks: DescribeHealthChecksResponseBodyHealthChecks = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.health_checks = health_checks
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.health_checks:
            self.health_checks.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.health_checks is not None:
            result['HealthChecks'] = self.health_checks.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HealthChecks') is not None:
            temp_model = DescribeHealthChecksResponseBodyHealthChecks()
            self.health_checks = temp_model.from_map(m['HealthChecks'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeHealthChecksResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeHealthChecksResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeHealthChecksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeQosCarsRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        order: str = None,
        owner_account: str = None,
        owner_id: int = None,
        page_number: int = None,
        page_size: int = None,
        qos_car_id: str = None,
        qos_id: str = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.description = description
        self.order = order
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.page_number = page_number
        self.page_size = page_size
        self.qos_car_id = qos_car_id
        self.qos_id = qos_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.order is not None:
            result['Order'] = self.order
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.qos_car_id is not None:
            result['QosCarId'] = self.qos_car_id
        if self.qos_id is not None:
            result['QosId'] = self.qos_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Order') is not None:
            self.order = m.get('Order')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('QosCarId') is not None:
            self.qos_car_id = m.get('QosCarId')
        if m.get('QosId') is not None:
            self.qos_id = m.get('QosId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeQosCarsResponseBodyQosCarsQosCar(TeaModel):
    def __init__(
        self,
        description: str = None,
        limit_type: str = None,
        max_bandwidth_abs: int = None,
        max_bandwidth_percent: int = None,
        min_bandwidth_abs: int = None,
        min_bandwidth_percent: int = None,
        name: str = None,
        percent_source_type: str = None,
        priority: int = None,
        qos_car_id: str = None,
        qos_id: str = None,
    ):
        self.description = description
        self.limit_type = limit_type
        self.max_bandwidth_abs = max_bandwidth_abs
        self.max_bandwidth_percent = max_bandwidth_percent
        self.min_bandwidth_abs = min_bandwidth_abs
        self.min_bandwidth_percent = min_bandwidth_percent
        self.name = name
        self.percent_source_type = percent_source_type
        self.priority = priority
        self.qos_car_id = qos_car_id
        self.qos_id = qos_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.limit_type is not None:
            result['LimitType'] = self.limit_type
        if self.max_bandwidth_abs is not None:
            result['MaxBandwidthAbs'] = self.max_bandwidth_abs
        if self.max_bandwidth_percent is not None:
            result['MaxBandwidthPercent'] = self.max_bandwidth_percent
        if self.min_bandwidth_abs is not None:
            result['MinBandwidthAbs'] = self.min_bandwidth_abs
        if self.min_bandwidth_percent is not None:
            result['MinBandwidthPercent'] = self.min_bandwidth_percent
        if self.name is not None:
            result['Name'] = self.name
        if self.percent_source_type is not None:
            result['PercentSourceType'] = self.percent_source_type
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.qos_car_id is not None:
            result['QosCarId'] = self.qos_car_id
        if self.qos_id is not None:
            result['QosId'] = self.qos_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('LimitType') is not None:
            self.limit_type = m.get('LimitType')
        if m.get('MaxBandwidthAbs') is not None:
            self.max_bandwidth_abs = m.get('MaxBandwidthAbs')
        if m.get('MaxBandwidthPercent') is not None:
            self.max_bandwidth_percent = m.get('MaxBandwidthPercent')
        if m.get('MinBandwidthAbs') is not None:
            self.min_bandwidth_abs = m.get('MinBandwidthAbs')
        if m.get('MinBandwidthPercent') is not None:
            self.min_bandwidth_percent = m.get('MinBandwidthPercent')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PercentSourceType') is not None:
            self.percent_source_type = m.get('PercentSourceType')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('QosCarId') is not None:
            self.qos_car_id = m.get('QosCarId')
        if m.get('QosId') is not None:
            self.qos_id = m.get('QosId')
        return self


class DescribeQosCarsResponseBodyQosCars(TeaModel):
    def __init__(
        self,
        qos_car: List[DescribeQosCarsResponseBodyQosCarsQosCar] = None,
    ):
        self.qos_car = qos_car

    def validate(self):
        if self.qos_car:
            for k in self.qos_car:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['QosCar'] = []
        if self.qos_car is not None:
            for k in self.qos_car:
                result['QosCar'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.qos_car = []
        if m.get('QosCar') is not None:
            for k in m.get('QosCar'):
                temp_model = DescribeQosCarsResponseBodyQosCarsQosCar()
                self.qos_car.append(temp_model.from_map(k))
        return self


class DescribeQosCarsResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        qos_cars: DescribeQosCarsResponseBodyQosCars = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.qos_cars = qos_cars
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.qos_cars:
            self.qos_cars.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.qos_cars is not None:
            result['QosCars'] = self.qos_cars.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('QosCars') is not None:
            temp_model = DescribeQosCarsResponseBodyQosCars()
            self.qos_cars = temp_model.from_map(m['QosCars'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeQosCarsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeQosCarsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeQosCarsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeQosPoliciesRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        owner_account: str = None,
        owner_id: int = None,
        page_number: int = None,
        page_size: int = None,
        priority: int = None,
        qos_id: str = None,
        qos_policy_id: str = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.description = description
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.page_number = page_number
        self.page_size = page_size
        self.priority = priority
        self.qos_id = qos_id
        self.qos_policy_id = qos_policy_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.qos_id is not None:
            result['QosId'] = self.qos_id
        if self.qos_policy_id is not None:
            result['QosPolicyId'] = self.qos_policy_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('QosId') is not None:
            self.qos_id = m.get('QosId')
        if m.get('QosPolicyId') is not None:
            self.qos_policy_id = m.get('QosPolicyId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeQosPoliciesResponseBodyQosPoliciesQosPolicyDpiGroupIds(TeaModel):
    def __init__(
        self,
        dpi_group_id: List[str] = None,
    ):
        self.dpi_group_id = dpi_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dpi_group_id is not None:
            result['DpiGroupId'] = self.dpi_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DpiGroupId') is not None:
            self.dpi_group_id = m.get('DpiGroupId')
        return self


class DescribeQosPoliciesResponseBodyQosPoliciesQosPolicyDpiSignatureIds(TeaModel):
    def __init__(
        self,
        dpi_signature_id: List[str] = None,
    ):
        self.dpi_signature_id = dpi_signature_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dpi_signature_id is not None:
            result['DpiSignatureId'] = self.dpi_signature_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DpiSignatureId') is not None:
            self.dpi_signature_id = m.get('DpiSignatureId')
        return self


class DescribeQosPoliciesResponseBodyQosPoliciesQosPolicy(TeaModel):
    def __init__(
        self,
        description: str = None,
        dest_cidr: str = None,
        dest_port_range: str = None,
        dpi_group_ids: DescribeQosPoliciesResponseBodyQosPoliciesQosPolicyDpiGroupIds = None,
        dpi_signature_ids: DescribeQosPoliciesResponseBodyQosPoliciesQosPolicyDpiSignatureIds = None,
        end_time: str = None,
        ip_protocol: str = None,
        name: str = None,
        priority: int = None,
        qos_id: str = None,
        qos_policy_id: str = None,
        source_cidr: str = None,
        source_port_range: str = None,
        start_time: str = None,
    ):
        self.description = description
        self.dest_cidr = dest_cidr
        self.dest_port_range = dest_port_range
        self.dpi_group_ids = dpi_group_ids
        self.dpi_signature_ids = dpi_signature_ids
        self.end_time = end_time
        self.ip_protocol = ip_protocol
        self.name = name
        self.priority = priority
        self.qos_id = qos_id
        self.qos_policy_id = qos_policy_id
        self.source_cidr = source_cidr
        self.source_port_range = source_port_range
        self.start_time = start_time

    def validate(self):
        if self.dpi_group_ids:
            self.dpi_group_ids.validate()
        if self.dpi_signature_ids:
            self.dpi_signature_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.dest_cidr is not None:
            result['DestCidr'] = self.dest_cidr
        if self.dest_port_range is not None:
            result['DestPortRange'] = self.dest_port_range
        if self.dpi_group_ids is not None:
            result['DpiGroupIds'] = self.dpi_group_ids.to_map()
        if self.dpi_signature_ids is not None:
            result['DpiSignatureIds'] = self.dpi_signature_ids.to_map()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.ip_protocol is not None:
            result['IpProtocol'] = self.ip_protocol
        if self.name is not None:
            result['Name'] = self.name
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.qos_id is not None:
            result['QosId'] = self.qos_id
        if self.qos_policy_id is not None:
            result['QosPolicyId'] = self.qos_policy_id
        if self.source_cidr is not None:
            result['SourceCidr'] = self.source_cidr
        if self.source_port_range is not None:
            result['SourcePortRange'] = self.source_port_range
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DestCidr') is not None:
            self.dest_cidr = m.get('DestCidr')
        if m.get('DestPortRange') is not None:
            self.dest_port_range = m.get('DestPortRange')
        if m.get('DpiGroupIds') is not None:
            temp_model = DescribeQosPoliciesResponseBodyQosPoliciesQosPolicyDpiGroupIds()
            self.dpi_group_ids = temp_model.from_map(m['DpiGroupIds'])
        if m.get('DpiSignatureIds') is not None:
            temp_model = DescribeQosPoliciesResponseBodyQosPoliciesQosPolicyDpiSignatureIds()
            self.dpi_signature_ids = temp_model.from_map(m['DpiSignatureIds'])
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('IpProtocol') is not None:
            self.ip_protocol = m.get('IpProtocol')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('QosId') is not None:
            self.qos_id = m.get('QosId')
        if m.get('QosPolicyId') is not None:
            self.qos_policy_id = m.get('QosPolicyId')
        if m.get('SourceCidr') is not None:
            self.source_cidr = m.get('SourceCidr')
        if m.get('SourcePortRange') is not None:
            self.source_port_range = m.get('SourcePortRange')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeQosPoliciesResponseBodyQosPolicies(TeaModel):
    def __init__(
        self,
        qos_policy: List[DescribeQosPoliciesResponseBodyQosPoliciesQosPolicy] = None,
    ):
        self.qos_policy = qos_policy

    def validate(self):
        if self.qos_policy:
            for k in self.qos_policy:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['QosPolicy'] = []
        if self.qos_policy is not None:
            for k in self.qos_policy:
                result['QosPolicy'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.qos_policy = []
        if m.get('QosPolicy') is not None:
            for k in m.get('QosPolicy'):
                temp_model = DescribeQosPoliciesResponseBodyQosPoliciesQosPolicy()
                self.qos_policy.append(temp_model.from_map(k))
        return self


class DescribeQosPoliciesResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        qos_policies: DescribeQosPoliciesResponseBodyQosPolicies = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.qos_policies = qos_policies
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.qos_policies:
            self.qos_policies.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.qos_policies is not None:
            result['QosPolicies'] = self.qos_policies.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('QosPolicies') is not None:
            temp_model = DescribeQosPoliciesResponseBodyQosPolicies()
            self.qos_policies = temp_model.from_map(m['QosPolicies'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeQosPoliciesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeQosPoliciesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeQosPoliciesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeQosesRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        page_number: int = None,
        page_size: int = None,
        qos_ids: str = None,
        qos_name: str = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.page_number = page_number
        self.page_size = page_size
        self.qos_ids = qos_ids
        self.qos_name = qos_name
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.qos_ids is not None:
            result['QosIds'] = self.qos_ids
        if self.qos_name is not None:
            result['QosName'] = self.qos_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('QosIds') is not None:
            self.qos_ids = m.get('QosIds')
        if m.get('QosName') is not None:
            self.qos_name = m.get('QosName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeQosesResponseBodyQosesQos(TeaModel):
    def __init__(
        self,
        qos_description: str = None,
        qos_id: str = None,
        qos_name: str = None,
        resource_group_id: str = None,
        sag_count: str = None,
        smart_agids: str = None,
    ):
        self.qos_description = qos_description
        self.qos_id = qos_id
        self.qos_name = qos_name
        self.resource_group_id = resource_group_id
        self.sag_count = sag_count
        self.smart_agids = smart_agids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.qos_description is not None:
            result['QosDescription'] = self.qos_description
        if self.qos_id is not None:
            result['QosId'] = self.qos_id
        if self.qos_name is not None:
            result['QosName'] = self.qos_name
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.sag_count is not None:
            result['SagCount'] = self.sag_count
        if self.smart_agids is not None:
            result['SmartAGIds'] = self.smart_agids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('QosDescription') is not None:
            self.qos_description = m.get('QosDescription')
        if m.get('QosId') is not None:
            self.qos_id = m.get('QosId')
        if m.get('QosName') is not None:
            self.qos_name = m.get('QosName')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SagCount') is not None:
            self.sag_count = m.get('SagCount')
        if m.get('SmartAGIds') is not None:
            self.smart_agids = m.get('SmartAGIds')
        return self


class DescribeQosesResponseBodyQoses(TeaModel):
    def __init__(
        self,
        qos: List[DescribeQosesResponseBodyQosesQos] = None,
    ):
        self.qos = qos

    def validate(self):
        if self.qos:
            for k in self.qos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Qos'] = []
        if self.qos is not None:
            for k in self.qos:
                result['Qos'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.qos = []
        if m.get('Qos') is not None:
            for k in m.get('Qos'):
                temp_model = DescribeQosesResponseBodyQosesQos()
                self.qos.append(temp_model.from_map(k))
        return self


class DescribeQosesResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        qoses: DescribeQosesResponseBodyQoses = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.qoses = qoses
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.qoses:
            self.qoses.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.qoses is not None:
            result['Qoses'] = self.qoses.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Qoses') is not None:
            temp_model = DescribeQosesResponseBodyQoses()
            self.qoses = temp_model.from_map(m['Qoses'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeQosesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeQosesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeQosesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRegionsRequest(TeaModel):
    def __init__(
        self,
        accept_language: str = None,
        owner_account: str = None,
        owner_id: int = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.accept_language = accept_language
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accept_language is not None:
            result['AcceptLanguage'] = self.accept_language
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcceptLanguage') is not None:
            self.accept_language = m.get('AcceptLanguage')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeRegionsResponseBodyRegionsRegion(TeaModel):
    def __init__(
        self,
        local_name: str = None,
        region_endpoint: str = None,
        region_id: str = None,
    ):
        self.local_name = local_name
        self.region_endpoint = region_endpoint
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.local_name is not None:
            result['LocalName'] = self.local_name
        if self.region_endpoint is not None:
            result['RegionEndpoint'] = self.region_endpoint
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LocalName') is not None:
            self.local_name = m.get('LocalName')
        if m.get('RegionEndpoint') is not None:
            self.region_endpoint = m.get('RegionEndpoint')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeRegionsResponseBodyRegions(TeaModel):
    def __init__(
        self,
        region: List[DescribeRegionsResponseBodyRegionsRegion] = None,
    ):
        self.region = region

    def validate(self):
        if self.region:
            for k in self.region:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Region'] = []
        if self.region is not None:
            for k in self.region:
                result['Region'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.region = []
        if m.get('Region') is not None:
            for k in m.get('Region'):
                temp_model = DescribeRegionsResponseBodyRegionsRegion()
                self.region.append(temp_model.from_map(k))
        return self


class DescribeRegionsResponseBody(TeaModel):
    def __init__(
        self,
        regions: DescribeRegionsResponseBodyRegions = None,
        request_id: str = None,
    ):
        self.regions = regions
        self.request_id = request_id

    def validate(self):
        if self.regions:
            self.regions.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.regions is not None:
            result['Regions'] = self.regions.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Regions') is not None:
            temp_model = DescribeRegionsResponseBodyRegions()
            self.regions = temp_model.from_map(m['Regions'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeRegionsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeRegionsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRegionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRouteDistributionStrategiesRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        source_type: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.page_number = page_number
        self.page_size = page_size
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.source_type = source_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        return self


class DescribeRouteDistributionStrategiesResponseBodyStrategiesStrategy(TeaModel):
    def __init__(
        self,
        conflict_info: str = None,
        create_time: int = None,
        dest_cidr_block: str = None,
        hc_instance_id: str = None,
        is_conflict: bool = None,
        route_distribution: str = None,
        route_source: str = None,
        smart_agid: str = None,
        source_type: str = None,
        status: str = None,
        strategy_publish_status: str = None,
    ):
        self.conflict_info = conflict_info
        self.create_time = create_time
        self.dest_cidr_block = dest_cidr_block
        self.hc_instance_id = hc_instance_id
        self.is_conflict = is_conflict
        self.route_distribution = route_distribution
        self.route_source = route_source
        self.smart_agid = smart_agid
        self.source_type = source_type
        self.status = status
        self.strategy_publish_status = strategy_publish_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.conflict_info is not None:
            result['ConflictInfo'] = self.conflict_info
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.dest_cidr_block is not None:
            result['DestCidrBlock'] = self.dest_cidr_block
        if self.hc_instance_id is not None:
            result['HcInstanceId'] = self.hc_instance_id
        if self.is_conflict is not None:
            result['IsConflict'] = self.is_conflict
        if self.route_distribution is not None:
            result['RouteDistribution'] = self.route_distribution
        if self.route_source is not None:
            result['RouteSource'] = self.route_source
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.status is not None:
            result['Status'] = self.status
        if self.strategy_publish_status is not None:
            result['StrategyPublishStatus'] = self.strategy_publish_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConflictInfo') is not None:
            self.conflict_info = m.get('ConflictInfo')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DestCidrBlock') is not None:
            self.dest_cidr_block = m.get('DestCidrBlock')
        if m.get('HcInstanceId') is not None:
            self.hc_instance_id = m.get('HcInstanceId')
        if m.get('IsConflict') is not None:
            self.is_conflict = m.get('IsConflict')
        if m.get('RouteDistribution') is not None:
            self.route_distribution = m.get('RouteDistribution')
        if m.get('RouteSource') is not None:
            self.route_source = m.get('RouteSource')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StrategyPublishStatus') is not None:
            self.strategy_publish_status = m.get('StrategyPublishStatus')
        return self


class DescribeRouteDistributionStrategiesResponseBodyStrategies(TeaModel):
    def __init__(
        self,
        strategy: List[DescribeRouteDistributionStrategiesResponseBodyStrategiesStrategy] = None,
    ):
        self.strategy = strategy

    def validate(self):
        if self.strategy:
            for k in self.strategy:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Strategy'] = []
        if self.strategy is not None:
            for k in self.strategy:
                result['Strategy'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.strategy = []
        if m.get('Strategy') is not None:
            for k in m.get('Strategy'):
                temp_model = DescribeRouteDistributionStrategiesResponseBodyStrategiesStrategy()
                self.strategy.append(temp_model.from_map(k))
        return self


class DescribeRouteDistributionStrategiesResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        strategies: DescribeRouteDistributionStrategiesResponseBodyStrategies = None,
        total_count: int = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.strategies = strategies
        self.total_count = total_count

    def validate(self):
        if self.strategies:
            self.strategies.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.strategies is not None:
            result['Strategies'] = self.strategies.to_map()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Strategies') is not None:
            temp_model = DescribeRouteDistributionStrategiesResponseBodyStrategies()
            self.strategies = temp_model.from_map(m['Strategies'])
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeRouteDistributionStrategiesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeRouteDistributionStrategiesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRouteDistributionStrategiesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSAGDeviceInfoRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        smart_agsn: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.smart_agsn = smart_agsn

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_agsn is not None:
            result['SmartAGSn'] = self.smart_agsn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGSn') is not None:
            self.smart_agsn = m.get('SmartAGSn')
        return self


class DescribeSAGDeviceInfoResponseBody(TeaModel):
    def __init__(
        self,
        controller_state: str = None,
        last_connected_controller_time: str = None,
        request_id: str = None,
        resettable_status: str = None,
        service_ip: str = None,
        smart_agtype: str = None,
        startup_time: str = None,
        syn_status: str = None,
        version: str = None,
        vpn_state: str = None,
    ):
        self.controller_state = controller_state
        self.last_connected_controller_time = last_connected_controller_time
        self.request_id = request_id
        self.resettable_status = resettable_status
        self.service_ip = service_ip
        self.smart_agtype = smart_agtype
        self.startup_time = startup_time
        self.syn_status = syn_status
        self.version = version
        self.vpn_state = vpn_state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.controller_state is not None:
            result['ControllerState'] = self.controller_state
        if self.last_connected_controller_time is not None:
            result['LastConnectedControllerTime'] = self.last_connected_controller_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resettable_status is not None:
            result['ResettableStatus'] = self.resettable_status
        if self.service_ip is not None:
            result['ServiceIP'] = self.service_ip
        if self.smart_agtype is not None:
            result['SmartAGType'] = self.smart_agtype
        if self.startup_time is not None:
            result['StartupTime'] = self.startup_time
        if self.syn_status is not None:
            result['SynStatus'] = self.syn_status
        if self.version is not None:
            result['Version'] = self.version
        if self.vpn_state is not None:
            result['VpnState'] = self.vpn_state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ControllerState') is not None:
            self.controller_state = m.get('ControllerState')
        if m.get('LastConnectedControllerTime') is not None:
            self.last_connected_controller_time = m.get('LastConnectedControllerTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResettableStatus') is not None:
            self.resettable_status = m.get('ResettableStatus')
        if m.get('ServiceIP') is not None:
            self.service_ip = m.get('ServiceIP')
        if m.get('SmartAGType') is not None:
            self.smart_agtype = m.get('SmartAGType')
        if m.get('StartupTime') is not None:
            self.startup_time = m.get('StartupTime')
        if m.get('SynStatus') is not None:
            self.syn_status = m.get('SynStatus')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        if m.get('VpnState') is not None:
            self.vpn_state = m.get('VpnState')
        return self


class DescribeSAGDeviceInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSAGDeviceInfoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSAGDeviceInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSagCurrentDnsRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        smart_agsn: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.smart_agsn = smart_agsn

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_agsn is not None:
            result['SmartAGSn'] = self.smart_agsn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGSn') is not None:
            self.smart_agsn = m.get('SmartAGSn')
        return self


class DescribeSagCurrentDnsResponseBody(TeaModel):
    def __init__(
        self,
        master_dns: str = None,
        request_id: str = None,
        slave_dns: str = None,
    ):
        self.master_dns = master_dns
        self.request_id = request_id
        self.slave_dns = slave_dns

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.master_dns is not None:
            result['MasterDns'] = self.master_dns
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.slave_dns is not None:
            result['SlaveDns'] = self.slave_dns
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MasterDns') is not None:
            self.master_dns = m.get('MasterDns')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SlaveDns') is not None:
            self.slave_dns = m.get('SlaveDns')
        return self


class DescribeSagCurrentDnsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSagCurrentDnsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSagCurrentDnsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSagDropTopNRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        size: int = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.size = size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.size is not None:
            result['Size'] = self.size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        return self


class DescribeSagDropTopNResponseBodyDropTopN(TeaModel):
    def __init__(
        self,
        drop_rate: str = None,
        instance_id: str = None,
        name: str = None,
        region_id: str = None,
    ):
        self.drop_rate = drop_rate
        self.instance_id = instance_id
        self.name = name
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drop_rate is not None:
            result['DropRate'] = self.drop_rate
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DropRate') is not None:
            self.drop_rate = m.get('DropRate')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeSagDropTopNResponseBody(TeaModel):
    def __init__(
        self,
        drop_top_n: List[DescribeSagDropTopNResponseBodyDropTopN] = None,
        request_id: str = None,
    ):
        self.drop_top_n = drop_top_n
        self.request_id = request_id

    def validate(self):
        if self.drop_top_n:
            for k in self.drop_top_n:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DropTopN'] = []
        if self.drop_top_n is not None:
            for k in self.drop_top_n:
                result['DropTopN'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.drop_top_n = []
        if m.get('DropTopN') is not None:
            for k in m.get('DropTopN'):
                temp_model = DescribeSagDropTopNResponseBodyDropTopN()
                self.drop_top_n.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeSagDropTopNResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSagDropTopNResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSagDropTopNResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSagExpressConnectInterfaceListRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        port_name: str = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        smart_agsn: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.port_name = port_name
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.smart_agsn = smart_agsn

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.port_name is not None:
            result['PortName'] = self.port_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_agsn is not None:
            result['SmartAGSn'] = self.smart_agsn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PortName') is not None:
            self.port_name = m.get('PortName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGSn') is not None:
            self.smart_agsn = m.get('SmartAGSn')
        return self


class DescribeSagExpressConnectInterfaceListResponseBodyInterfaces(TeaModel):
    def __init__(
        self,
        ip: str = None,
        mask: str = None,
        vlan: str = None,
    ):
        self.ip = ip
        self.mask = mask
        self.vlan = vlan

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip is not None:
            result['IP'] = self.ip
        if self.mask is not None:
            result['Mask'] = self.mask
        if self.vlan is not None:
            result['Vlan'] = self.vlan
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IP') is not None:
            self.ip = m.get('IP')
        if m.get('Mask') is not None:
            self.mask = m.get('Mask')
        if m.get('Vlan') is not None:
            self.vlan = m.get('Vlan')
        return self


class DescribeSagExpressConnectInterfaceListResponseBodyTaskStates(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        error_code: str = None,
        error_message: str = None,
        state: str = None,
    ):
        self.create_time = create_time
        self.error_code = error_code
        self.error_message = error_message
        self.state = state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class DescribeSagExpressConnectInterfaceListResponseBody(TeaModel):
    def __init__(
        self,
        interfaces: List[DescribeSagExpressConnectInterfaceListResponseBodyInterfaces] = None,
        request_id: str = None,
        task_states: List[DescribeSagExpressConnectInterfaceListResponseBodyTaskStates] = None,
    ):
        self.interfaces = interfaces
        self.request_id = request_id
        self.task_states = task_states

    def validate(self):
        if self.interfaces:
            for k in self.interfaces:
                if k:
                    k.validate()
        if self.task_states:
            for k in self.task_states:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Interfaces'] = []
        if self.interfaces is not None:
            for k in self.interfaces:
                result['Interfaces'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['TaskStates'] = []
        if self.task_states is not None:
            for k in self.task_states:
                result['TaskStates'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.interfaces = []
        if m.get('Interfaces') is not None:
            for k in m.get('Interfaces'):
                temp_model = DescribeSagExpressConnectInterfaceListResponseBodyInterfaces()
                self.interfaces.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.task_states = []
        if m.get('TaskStates') is not None:
            for k in m.get('TaskStates'):
                temp_model = DescribeSagExpressConnectInterfaceListResponseBodyTaskStates()
                self.task_states.append(temp_model.from_map(k))
        return self


class DescribeSagExpressConnectInterfaceListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSagExpressConnectInterfaceListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSagExpressConnectInterfaceListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSagGlobalRouteProtocolRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        smart_agsn: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.smart_agsn = smart_agsn

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_agsn is not None:
            result['SmartAGSn'] = self.smart_agsn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGSn') is not None:
            self.smart_agsn = m.get('SmartAGSn')
        return self


class DescribeSagGlobalRouteProtocolResponseBodyTaskStates(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        error_code: str = None,
        error_message: str = None,
        state: str = None,
    ):
        self.create_time = create_time
        self.error_code = error_code
        self.error_message = error_message
        self.state = state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class DescribeSagGlobalRouteProtocolResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        route_protocol: str = None,
        task_states: List[DescribeSagGlobalRouteProtocolResponseBodyTaskStates] = None,
    ):
        self.request_id = request_id
        self.route_protocol = route_protocol
        self.task_states = task_states

    def validate(self):
        if self.task_states:
            for k in self.task_states:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.route_protocol is not None:
            result['RouteProtocol'] = self.route_protocol
        result['TaskStates'] = []
        if self.task_states is not None:
            for k in self.task_states:
                result['TaskStates'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RouteProtocol') is not None:
            self.route_protocol = m.get('RouteProtocol')
        self.task_states = []
        if m.get('TaskStates') is not None:
            for k in m.get('TaskStates'):
                temp_model = DescribeSagGlobalRouteProtocolResponseBodyTaskStates()
                self.task_states.append(temp_model.from_map(k))
        return self


class DescribeSagGlobalRouteProtocolResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSagGlobalRouteProtocolResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSagGlobalRouteProtocolResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSagHaRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        smart_agsn: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.smart_agsn = smart_agsn

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_agsn is not None:
            result['SmartAGSn'] = self.smart_agsn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGSn') is not None:
            self.smart_agsn = m.get('SmartAGSn')
        return self


class DescribeSagHaResponseBodyPorts(TeaModel):
    def __init__(
        self,
        port_name: str = None,
        virtual_ip: str = None,
    ):
        self.port_name = port_name
        self.virtual_ip = virtual_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.port_name is not None:
            result['PortName'] = self.port_name
        if self.virtual_ip is not None:
            result['VirtualIp'] = self.virtual_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PortName') is not None:
            self.port_name = m.get('PortName')
        if m.get('VirtualIp') is not None:
            self.virtual_ip = m.get('VirtualIp')
        return self


class DescribeSagHaResponseBodyTaskStates(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        error_code: str = None,
        error_message: str = None,
        state: str = None,
    ):
        self.create_time = create_time
        self.error_code = error_code
        self.error_message = error_message
        self.state = state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class DescribeSagHaResponseBody(TeaModel):
    def __init__(
        self,
        mode: str = None,
        ports: List[DescribeSagHaResponseBodyPorts] = None,
        request_id: str = None,
        task_states: List[DescribeSagHaResponseBodyTaskStates] = None,
    ):
        self.mode = mode
        self.ports = ports
        self.request_id = request_id
        self.task_states = task_states

    def validate(self):
        if self.ports:
            for k in self.ports:
                if k:
                    k.validate()
        if self.task_states:
            for k in self.task_states:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mode is not None:
            result['Mode'] = self.mode
        result['Ports'] = []
        if self.ports is not None:
            for k in self.ports:
                result['Ports'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['TaskStates'] = []
        if self.task_states is not None:
            for k in self.task_states:
                result['TaskStates'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        self.ports = []
        if m.get('Ports') is not None:
            for k in m.get('Ports'):
                temp_model = DescribeSagHaResponseBodyPorts()
                self.ports.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.task_states = []
        if m.get('TaskStates') is not None:
            for k in m.get('TaskStates'):
                temp_model = DescribeSagHaResponseBodyTaskStates()
                self.task_states.append(temp_model.from_map(k))
        return self


class DescribeSagHaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSagHaResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSagHaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSagLanListRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        smart_agsn: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.smart_agsn = smart_agsn

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_agsn is not None:
            result['SmartAGSn'] = self.smart_agsn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGSn') is not None:
            self.smart_agsn = m.get('SmartAGSn')
        return self


class DescribeSagLanListResponseBodyLans(TeaModel):
    def __init__(
        self,
        end_ip: str = None,
        ip: str = None,
        iptype: str = None,
        lease: str = None,
        mask: str = None,
        port_name: str = None,
        start_ip: str = None,
    ):
        self.end_ip = end_ip
        self.ip = ip
        self.iptype = iptype
        self.lease = lease
        self.mask = mask
        self.port_name = port_name
        self.start_ip = start_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_ip is not None:
            result['EndIp'] = self.end_ip
        if self.ip is not None:
            result['IP'] = self.ip
        if self.iptype is not None:
            result['IPType'] = self.iptype
        if self.lease is not None:
            result['Lease'] = self.lease
        if self.mask is not None:
            result['Mask'] = self.mask
        if self.port_name is not None:
            result['PortName'] = self.port_name
        if self.start_ip is not None:
            result['StartIp'] = self.start_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndIp') is not None:
            self.end_ip = m.get('EndIp')
        if m.get('IP') is not None:
            self.ip = m.get('IP')
        if m.get('IPType') is not None:
            self.iptype = m.get('IPType')
        if m.get('Lease') is not None:
            self.lease = m.get('Lease')
        if m.get('Mask') is not None:
            self.mask = m.get('Mask')
        if m.get('PortName') is not None:
            self.port_name = m.get('PortName')
        if m.get('StartIp') is not None:
            self.start_ip = m.get('StartIp')
        return self


class DescribeSagLanListResponseBodyTaskStates(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        error_code: str = None,
        error_message: str = None,
        state: str = None,
    ):
        self.create_time = create_time
        self.error_code = error_code
        self.error_message = error_message
        self.state = state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class DescribeSagLanListResponseBody(TeaModel):
    def __init__(
        self,
        lans: List[DescribeSagLanListResponseBodyLans] = None,
        request_id: str = None,
        task_states: List[DescribeSagLanListResponseBodyTaskStates] = None,
    ):
        self.lans = lans
        self.request_id = request_id
        self.task_states = task_states

    def validate(self):
        if self.lans:
            for k in self.lans:
                if k:
                    k.validate()
        if self.task_states:
            for k in self.task_states:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Lans'] = []
        if self.lans is not None:
            for k in self.lans:
                result['Lans'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['TaskStates'] = []
        if self.task_states is not None:
            for k in self.task_states:
                result['TaskStates'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.lans = []
        if m.get('Lans') is not None:
            for k in m.get('Lans'):
                temp_model = DescribeSagLanListResponseBodyLans()
                self.lans.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.task_states = []
        if m.get('TaskStates') is not None:
            for k in m.get('TaskStates'):
                temp_model = DescribeSagLanListResponseBodyTaskStates()
                self.task_states.append(temp_model.from_map(k))
        return self


class DescribeSagLanListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSagLanListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSagLanListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSagManagementPortRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        smart_agsn: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.smart_agsn = smart_agsn

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_agsn is not None:
            result['SmartAGSn'] = self.smart_agsn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGSn') is not None:
            self.smart_agsn = m.get('SmartAGSn')
        return self


class DescribeSagManagementPortResponseBodyTaskStates(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        error_code: str = None,
        error_message: str = None,
        state: str = None,
    ):
        self.create_time = create_time
        self.error_code = error_code
        self.error_message = error_message
        self.state = state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class DescribeSagManagementPortResponseBody(TeaModel):
    def __init__(
        self,
        gateway: str = None,
        ip: str = None,
        mask: str = None,
        request_id: str = None,
        task_states: List[DescribeSagManagementPortResponseBodyTaskStates] = None,
    ):
        self.gateway = gateway
        self.ip = ip
        self.mask = mask
        self.request_id = request_id
        self.task_states = task_states

    def validate(self):
        if self.task_states:
            for k in self.task_states:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gateway is not None:
            result['Gateway'] = self.gateway
        if self.ip is not None:
            result['IP'] = self.ip
        if self.mask is not None:
            result['Mask'] = self.mask
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['TaskStates'] = []
        if self.task_states is not None:
            for k in self.task_states:
                result['TaskStates'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Gateway') is not None:
            self.gateway = m.get('Gateway')
        if m.get('IP') is not None:
            self.ip = m.get('IP')
        if m.get('Mask') is not None:
            self.mask = m.get('Mask')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.task_states = []
        if m.get('TaskStates') is not None:
            for k in m.get('TaskStates'):
                temp_model = DescribeSagManagementPortResponseBodyTaskStates()
                self.task_states.append(temp_model.from_map(k))
        return self


class DescribeSagManagementPortResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSagManagementPortResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSagManagementPortResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSagOnlineClientStatisticsRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agids: List[str] = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agids = smart_agids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agids is not None:
            result['SmartAGIds'] = self.smart_agids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGIds') is not None:
            self.smart_agids = m.get('SmartAGIds')
        return self


class DescribeSagOnlineClientStatisticsResponseBodySagStatisticsStatistics(TeaModel):
    def __init__(
        self,
        online_count: str = None,
        smart_agid: str = None,
    ):
        self.online_count = online_count
        self.smart_agid = smart_agid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.online_count is not None:
            result['OnlineCount'] = self.online_count
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OnlineCount') is not None:
            self.online_count = m.get('OnlineCount')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        return self


class DescribeSagOnlineClientStatisticsResponseBodySagStatistics(TeaModel):
    def __init__(
        self,
        statistics: List[DescribeSagOnlineClientStatisticsResponseBodySagStatisticsStatistics] = None,
    ):
        self.statistics = statistics

    def validate(self):
        if self.statistics:
            for k in self.statistics:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Statistics'] = []
        if self.statistics is not None:
            for k in self.statistics:
                result['Statistics'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.statistics = []
        if m.get('Statistics') is not None:
            for k in m.get('Statistics'):
                temp_model = DescribeSagOnlineClientStatisticsResponseBodySagStatisticsStatistics()
                self.statistics.append(temp_model.from_map(k))
        return self


class DescribeSagOnlineClientStatisticsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        sag_statistics: DescribeSagOnlineClientStatisticsResponseBodySagStatistics = None,
    ):
        self.request_id = request_id
        self.sag_statistics = sag_statistics

    def validate(self):
        if self.sag_statistics:
            self.sag_statistics.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sag_statistics is not None:
            result['SagStatistics'] = self.sag_statistics.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SagStatistics') is not None:
            temp_model = DescribeSagOnlineClientStatisticsResponseBodySagStatistics()
            self.sag_statistics = temp_model.from_map(m['SagStatistics'])
        return self


class DescribeSagOnlineClientStatisticsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSagOnlineClientStatisticsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSagOnlineClientStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSagPortListRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        smart_agsn: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.smart_agsn = smart_agsn

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_agsn is not None:
            result['SmartAGSn'] = self.smart_agsn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGSn') is not None:
            self.smart_agsn = m.get('SmartAGSn')
        return self


class DescribeSagPortListResponseBodyPorts(TeaModel):
    def __init__(
        self,
        mac: str = None,
        port_name: str = None,
        role: str = None,
        status: str = None,
    ):
        self.mac = mac
        self.port_name = port_name
        self.role = role
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mac is not None:
            result['Mac'] = self.mac
        if self.port_name is not None:
            result['PortName'] = self.port_name
        if self.role is not None:
            result['Role'] = self.role
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Mac') is not None:
            self.mac = m.get('Mac')
        if m.get('PortName') is not None:
            self.port_name = m.get('PortName')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeSagPortListResponseBodyTaskStates(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        error_code: str = None,
        error_message: str = None,
        state: str = None,
    ):
        self.create_time = create_time
        self.error_code = error_code
        self.error_message = error_message
        self.state = state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class DescribeSagPortListResponseBody(TeaModel):
    def __init__(
        self,
        ports: List[DescribeSagPortListResponseBodyPorts] = None,
        request_id: str = None,
        task_states: List[DescribeSagPortListResponseBodyTaskStates] = None,
    ):
        self.ports = ports
        self.request_id = request_id
        self.task_states = task_states

    def validate(self):
        if self.ports:
            for k in self.ports:
                if k:
                    k.validate()
        if self.task_states:
            for k in self.task_states:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Ports'] = []
        if self.ports is not None:
            for k in self.ports:
                result['Ports'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['TaskStates'] = []
        if self.task_states is not None:
            for k in self.task_states:
                result['TaskStates'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ports = []
        if m.get('Ports') is not None:
            for k in m.get('Ports'):
                temp_model = DescribeSagPortListResponseBodyPorts()
                self.ports.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.task_states = []
        if m.get('TaskStates') is not None:
            for k in m.get('TaskStates'):
                temp_model = DescribeSagPortListResponseBodyTaskStates()
                self.task_states.append(temp_model.from_map(k))
        return self


class DescribeSagPortListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSagPortListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSagPortListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSagPortRouteProtocolListRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        smart_agsn: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.smart_agsn = smart_agsn

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_agsn is not None:
            result['SmartAGSn'] = self.smart_agsn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGSn') is not None:
            self.smart_agsn = m.get('SmartAGSn')
        return self


class DescribeSagPortRouteProtocolListResponseBodyPorts(TeaModel):
    def __init__(
        self,
        neighbor_ip: str = None,
        port_name: str = None,
        remote_as: str = None,
        remote_ip: str = None,
        route_protocol: str = None,
        status: str = None,
        vlan: str = None,
    ):
        self.neighbor_ip = neighbor_ip
        self.port_name = port_name
        self.remote_as = remote_as
        self.remote_ip = remote_ip
        self.route_protocol = route_protocol
        self.status = status
        self.vlan = vlan

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.neighbor_ip is not None:
            result['NeighborIp'] = self.neighbor_ip
        if self.port_name is not None:
            result['PortName'] = self.port_name
        if self.remote_as is not None:
            result['RemoteAs'] = self.remote_as
        if self.remote_ip is not None:
            result['RemoteIp'] = self.remote_ip
        if self.route_protocol is not None:
            result['RouteProtocol'] = self.route_protocol
        if self.status is not None:
            result['Status'] = self.status
        if self.vlan is not None:
            result['Vlan'] = self.vlan
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NeighborIp') is not None:
            self.neighbor_ip = m.get('NeighborIp')
        if m.get('PortName') is not None:
            self.port_name = m.get('PortName')
        if m.get('RemoteAs') is not None:
            self.remote_as = m.get('RemoteAs')
        if m.get('RemoteIp') is not None:
            self.remote_ip = m.get('RemoteIp')
        if m.get('RouteProtocol') is not None:
            self.route_protocol = m.get('RouteProtocol')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Vlan') is not None:
            self.vlan = m.get('Vlan')
        return self


class DescribeSagPortRouteProtocolListResponseBodyTaskStates(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        error_code: str = None,
        error_message: str = None,
        state: str = None,
    ):
        self.create_time = create_time
        self.error_code = error_code
        self.error_message = error_message
        self.state = state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class DescribeSagPortRouteProtocolListResponseBody(TeaModel):
    def __init__(
        self,
        ports: List[DescribeSagPortRouteProtocolListResponseBodyPorts] = None,
        request_id: str = None,
        task_states: List[DescribeSagPortRouteProtocolListResponseBodyTaskStates] = None,
    ):
        self.ports = ports
        self.request_id = request_id
        self.task_states = task_states

    def validate(self):
        if self.ports:
            for k in self.ports:
                if k:
                    k.validate()
        if self.task_states:
            for k in self.task_states:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Ports'] = []
        if self.ports is not None:
            for k in self.ports:
                result['Ports'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['TaskStates'] = []
        if self.task_states is not None:
            for k in self.task_states:
                result['TaskStates'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ports = []
        if m.get('Ports') is not None:
            for k in m.get('Ports'):
                temp_model = DescribeSagPortRouteProtocolListResponseBodyPorts()
                self.ports.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.task_states = []
        if m.get('TaskStates') is not None:
            for k in m.get('TaskStates'):
                temp_model = DescribeSagPortRouteProtocolListResponseBodyTaskStates()
                self.task_states.append(temp_model.from_map(k))
        return self


class DescribeSagPortRouteProtocolListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSagPortRouteProtocolListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSagPortRouteProtocolListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSagRemoteAccessRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        serial_number: str = None,
        smart_agid: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.serial_number = serial_number
        self.smart_agid = smart_agid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.serial_number is not None:
            result['SerialNumber'] = self.serial_number
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SerialNumber') is not None:
            self.serial_number = m.get('SerialNumber')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        return self


class DescribeSagRemoteAccessResponseBodyRemoteAccessesRemoteAccess(TeaModel):
    def __init__(
        self,
        remote_access_ip: str = None,
        serial_number: str = None,
    ):
        self.remote_access_ip = remote_access_ip
        self.serial_number = serial_number

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.remote_access_ip is not None:
            result['RemoteAccessIp'] = self.remote_access_ip
        if self.serial_number is not None:
            result['SerialNumber'] = self.serial_number
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RemoteAccessIp') is not None:
            self.remote_access_ip = m.get('RemoteAccessIp')
        if m.get('SerialNumber') is not None:
            self.serial_number = m.get('SerialNumber')
        return self


class DescribeSagRemoteAccessResponseBodyRemoteAccesses(TeaModel):
    def __init__(
        self,
        remote_access: List[DescribeSagRemoteAccessResponseBodyRemoteAccessesRemoteAccess] = None,
    ):
        self.remote_access = remote_access

    def validate(self):
        if self.remote_access:
            for k in self.remote_access:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RemoteAccess'] = []
        if self.remote_access is not None:
            for k in self.remote_access:
                result['RemoteAccess'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.remote_access = []
        if m.get('RemoteAccess') is not None:
            for k in m.get('RemoteAccess'):
                temp_model = DescribeSagRemoteAccessResponseBodyRemoteAccessesRemoteAccess()
                self.remote_access.append(temp_model.from_map(k))
        return self


class DescribeSagRemoteAccessResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        remote_accesses: DescribeSagRemoteAccessResponseBodyRemoteAccesses = None,
        request_id: str = None,
        smart_agid: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.remote_accesses = remote_accesses
        self.request_id = request_id
        self.smart_agid = smart_agid
        self.success = success

    def validate(self):
        if self.remote_accesses:
            self.remote_accesses.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.remote_accesses is not None:
            result['RemoteAccesses'] = self.remote_accesses.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RemoteAccesses') is not None:
            temp_model = DescribeSagRemoteAccessResponseBodyRemoteAccesses()
            self.remote_accesses = temp_model.from_map(m['RemoteAccesses'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeSagRemoteAccessResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSagRemoteAccessResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSagRemoteAccessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSagRouteListRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        smart_agsn: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.smart_agsn = smart_agsn

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_agsn is not None:
            result['SmartAGSn'] = self.smart_agsn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGSn') is not None:
            self.smart_agsn = m.get('SmartAGSn')
        return self


class DescribeSagRouteListResponseBodyRoutes(TeaModel):
    def __init__(
        self,
        conflict_cidrs: List[str] = None,
        cost: str = None,
        destination_cidr: str = None,
        next_hop: str = None,
        port_name: str = None,
        route_protocol: str = None,
    ):
        self.conflict_cidrs = conflict_cidrs
        self.cost = cost
        self.destination_cidr = destination_cidr
        self.next_hop = next_hop
        self.port_name = port_name
        self.route_protocol = route_protocol

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.conflict_cidrs is not None:
            result['ConflictCidrs'] = self.conflict_cidrs
        if self.cost is not None:
            result['Cost'] = self.cost
        if self.destination_cidr is not None:
            result['DestinationCidr'] = self.destination_cidr
        if self.next_hop is not None:
            result['NextHop'] = self.next_hop
        if self.port_name is not None:
            result['PortName'] = self.port_name
        if self.route_protocol is not None:
            result['RouteProtocol'] = self.route_protocol
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConflictCidrs') is not None:
            self.conflict_cidrs = m.get('ConflictCidrs')
        if m.get('Cost') is not None:
            self.cost = m.get('Cost')
        if m.get('DestinationCidr') is not None:
            self.destination_cidr = m.get('DestinationCidr')
        if m.get('NextHop') is not None:
            self.next_hop = m.get('NextHop')
        if m.get('PortName') is not None:
            self.port_name = m.get('PortName')
        if m.get('RouteProtocol') is not None:
            self.route_protocol = m.get('RouteProtocol')
        return self


class DescribeSagRouteListResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        routes: List[DescribeSagRouteListResponseBodyRoutes] = None,
    ):
        self.request_id = request_id
        self.routes = routes

    def validate(self):
        if self.routes:
            for k in self.routes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Routes'] = []
        if self.routes is not None:
            for k in self.routes:
                result['Routes'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.routes = []
        if m.get('Routes') is not None:
            for k in m.get('Routes'):
                temp_model = DescribeSagRouteListResponseBodyRoutes()
                self.routes.append(temp_model.from_map(k))
        return self


class DescribeSagRouteListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSagRouteListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSagRouteListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSagRouteProtocolBgpRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        smart_agsn: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.smart_agsn = smart_agsn

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_agsn is not None:
            result['SmartAGSn'] = self.smart_agsn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGSn') is not None:
            self.smart_agsn = m.get('SmartAGSn')
        return self


class DescribeSagRouteProtocolBgpResponseBodyTaskStates(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        error_code: str = None,
        error_message: str = None,
        state: str = None,
    ):
        self.create_time = create_time
        self.error_code = error_code
        self.error_message = error_message
        self.state = state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class DescribeSagRouteProtocolBgpResponseBody(TeaModel):
    def __init__(
        self,
        hold_time: int = None,
        keep_alive: int = None,
        local_as: int = None,
        request_id: str = None,
        router_id: str = None,
        task_states: List[DescribeSagRouteProtocolBgpResponseBodyTaskStates] = None,
    ):
        self.hold_time = hold_time
        self.keep_alive = keep_alive
        self.local_as = local_as
        self.request_id = request_id
        self.router_id = router_id
        self.task_states = task_states

    def validate(self):
        if self.task_states:
            for k in self.task_states:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hold_time is not None:
            result['HoldTime'] = self.hold_time
        if self.keep_alive is not None:
            result['KeepAlive'] = self.keep_alive
        if self.local_as is not None:
            result['LocalAs'] = self.local_as
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.router_id is not None:
            result['RouterId'] = self.router_id
        result['TaskStates'] = []
        if self.task_states is not None:
            for k in self.task_states:
                result['TaskStates'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HoldTime') is not None:
            self.hold_time = m.get('HoldTime')
        if m.get('KeepAlive') is not None:
            self.keep_alive = m.get('KeepAlive')
        if m.get('LocalAs') is not None:
            self.local_as = m.get('LocalAs')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RouterId') is not None:
            self.router_id = m.get('RouterId')
        self.task_states = []
        if m.get('TaskStates') is not None:
            for k in m.get('TaskStates'):
                temp_model = DescribeSagRouteProtocolBgpResponseBodyTaskStates()
                self.task_states.append(temp_model.from_map(k))
        return self


class DescribeSagRouteProtocolBgpResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSagRouteProtocolBgpResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSagRouteProtocolBgpResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSagRouteProtocolOspfRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        smart_agsn: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.smart_agsn = smart_agsn

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_agsn is not None:
            result['SmartAGSn'] = self.smart_agsn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGSn') is not None:
            self.smart_agsn = m.get('SmartAGSn')
        return self


class DescribeSagRouteProtocolOspfResponseBodyTaskStates(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        error_code: str = None,
        error_message: str = None,
        state: str = None,
    ):
        self.create_time = create_time
        self.error_code = error_code
        self.error_message = error_message
        self.state = state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class DescribeSagRouteProtocolOspfResponseBody(TeaModel):
    def __init__(
        self,
        area_id: str = None,
        area_type: str = None,
        authentication_type: str = None,
        dead_time: int = None,
        hello_time: int = None,
        md_5key: str = None,
        md_5key_id: int = None,
        request_id: str = None,
        router_id: str = None,
        task_states: List[DescribeSagRouteProtocolOspfResponseBodyTaskStates] = None,
    ):
        self.area_id = area_id
        self.area_type = area_type
        self.authentication_type = authentication_type
        self.dead_time = dead_time
        self.hello_time = hello_time
        self.md_5key = md_5key
        self.md_5key_id = md_5key_id
        self.request_id = request_id
        self.router_id = router_id
        self.task_states = task_states

    def validate(self):
        if self.task_states:
            for k in self.task_states:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.area_id is not None:
            result['AreaId'] = self.area_id
        if self.area_type is not None:
            result['AreaType'] = self.area_type
        if self.authentication_type is not None:
            result['AuthenticationType'] = self.authentication_type
        if self.dead_time is not None:
            result['DeadTime'] = self.dead_time
        if self.hello_time is not None:
            result['HelloTime'] = self.hello_time
        if self.md_5key is not None:
            result['Md5Key'] = self.md_5key
        if self.md_5key_id is not None:
            result['Md5KeyId'] = self.md_5key_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.router_id is not None:
            result['RouterId'] = self.router_id
        result['TaskStates'] = []
        if self.task_states is not None:
            for k in self.task_states:
                result['TaskStates'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AreaId') is not None:
            self.area_id = m.get('AreaId')
        if m.get('AreaType') is not None:
            self.area_type = m.get('AreaType')
        if m.get('AuthenticationType') is not None:
            self.authentication_type = m.get('AuthenticationType')
        if m.get('DeadTime') is not None:
            self.dead_time = m.get('DeadTime')
        if m.get('HelloTime') is not None:
            self.hello_time = m.get('HelloTime')
        if m.get('Md5Key') is not None:
            self.md_5key = m.get('Md5Key')
        if m.get('Md5KeyId') is not None:
            self.md_5key_id = m.get('Md5KeyId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RouterId') is not None:
            self.router_id = m.get('RouterId')
        self.task_states = []
        if m.get('TaskStates') is not None:
            for k in m.get('TaskStates'):
                temp_model = DescribeSagRouteProtocolOspfResponseBodyTaskStates()
                self.task_states.append(temp_model.from_map(k))
        return self


class DescribeSagRouteProtocolOspfResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSagRouteProtocolOspfResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSagRouteProtocolOspfResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSagStaticRouteListRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        smart_agsn: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.smart_agsn = smart_agsn

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_agsn is not None:
            result['SmartAGSn'] = self.smart_agsn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGSn') is not None:
            self.smart_agsn = m.get('SmartAGSn')
        return self


class DescribeSagStaticRouteListResponseBodyStaticRoutes(TeaModel):
    def __init__(
        self,
        destination_cidr: str = None,
        next_hop: str = None,
        port_name: str = None,
        vlan: str = None,
    ):
        self.destination_cidr = destination_cidr
        self.next_hop = next_hop
        self.port_name = port_name
        self.vlan = vlan

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.destination_cidr is not None:
            result['DestinationCidr'] = self.destination_cidr
        if self.next_hop is not None:
            result['NextHop'] = self.next_hop
        if self.port_name is not None:
            result['PortName'] = self.port_name
        if self.vlan is not None:
            result['Vlan'] = self.vlan
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DestinationCidr') is not None:
            self.destination_cidr = m.get('DestinationCidr')
        if m.get('NextHop') is not None:
            self.next_hop = m.get('NextHop')
        if m.get('PortName') is not None:
            self.port_name = m.get('PortName')
        if m.get('Vlan') is not None:
            self.vlan = m.get('Vlan')
        return self


class DescribeSagStaticRouteListResponseBodyTaskStates(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        error_code: str = None,
        error_message: str = None,
        state: str = None,
    ):
        self.create_time = create_time
        self.error_code = error_code
        self.error_message = error_message
        self.state = state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class DescribeSagStaticRouteListResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        static_routes: List[DescribeSagStaticRouteListResponseBodyStaticRoutes] = None,
        task_states: List[DescribeSagStaticRouteListResponseBodyTaskStates] = None,
    ):
        self.request_id = request_id
        self.static_routes = static_routes
        self.task_states = task_states

    def validate(self):
        if self.static_routes:
            for k in self.static_routes:
                if k:
                    k.validate()
        if self.task_states:
            for k in self.task_states:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['StaticRoutes'] = []
        if self.static_routes is not None:
            for k in self.static_routes:
                result['StaticRoutes'].append(k.to_map() if k else None)
        result['TaskStates'] = []
        if self.task_states is not None:
            for k in self.task_states:
                result['TaskStates'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.static_routes = []
        if m.get('StaticRoutes') is not None:
            for k in m.get('StaticRoutes'):
                temp_model = DescribeSagStaticRouteListResponseBodyStaticRoutes()
                self.static_routes.append(temp_model.from_map(k))
        self.task_states = []
        if m.get('TaskStates') is not None:
            for k in m.get('TaskStates'):
                temp_model = DescribeSagStaticRouteListResponseBodyTaskStates()
                self.task_states.append(temp_model.from_map(k))
        return self


class DescribeSagStaticRouteListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSagStaticRouteListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSagStaticRouteListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSagTrafficTopNRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        size: int = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.size = size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.size is not None:
            result['Size'] = self.size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        return self


class DescribeSagTrafficTopNResponseBodyTrafficTopN(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        name: str = None,
        region_id: str = None,
        traffic_rate: str = None,
    ):
        self.instance_id = instance_id
        self.name = name
        self.region_id = region_id
        self.traffic_rate = traffic_rate

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.traffic_rate is not None:
            result['TrafficRate'] = self.traffic_rate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TrafficRate') is not None:
            self.traffic_rate = m.get('TrafficRate')
        return self


class DescribeSagTrafficTopNResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        traffic_top_n: List[DescribeSagTrafficTopNResponseBodyTrafficTopN] = None,
    ):
        self.request_id = request_id
        self.traffic_top_n = traffic_top_n

    def validate(self):
        if self.traffic_top_n:
            for k in self.traffic_top_n:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['TrafficTopN'] = []
        if self.traffic_top_n is not None:
            for k in self.traffic_top_n:
                result['TrafficTopN'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.traffic_top_n = []
        if m.get('TrafficTopN') is not None:
            for k in m.get('TrafficTopN'):
                temp_model = DescribeSagTrafficTopNResponseBodyTrafficTopN()
                self.traffic_top_n.append(temp_model.from_map(k))
        return self


class DescribeSagTrafficTopNResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSagTrafficTopNResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSagTrafficTopNResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSagUserDnsRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        smart_agsn: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.smart_agsn = smart_agsn

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_agsn is not None:
            result['SmartAGSn'] = self.smart_agsn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGSn') is not None:
            self.smart_agsn = m.get('SmartAGSn')
        return self


class DescribeSagUserDnsResponseBodyTaskStates(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        error_code: str = None,
        error_message: str = None,
        state: str = None,
    ):
        self.create_time = create_time
        self.error_code = error_code
        self.error_message = error_message
        self.state = state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class DescribeSagUserDnsResponseBody(TeaModel):
    def __init__(
        self,
        master_dns: str = None,
        request_id: str = None,
        slave_dns: str = None,
        task_states: List[DescribeSagUserDnsResponseBodyTaskStates] = None,
    ):
        self.master_dns = master_dns
        self.request_id = request_id
        self.slave_dns = slave_dns
        self.task_states = task_states

    def validate(self):
        if self.task_states:
            for k in self.task_states:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.master_dns is not None:
            result['MasterDns'] = self.master_dns
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.slave_dns is not None:
            result['SlaveDns'] = self.slave_dns
        result['TaskStates'] = []
        if self.task_states is not None:
            for k in self.task_states:
                result['TaskStates'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MasterDns') is not None:
            self.master_dns = m.get('MasterDns')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SlaveDns') is not None:
            self.slave_dns = m.get('SlaveDns')
        self.task_states = []
        if m.get('TaskStates') is not None:
            for k in m.get('TaskStates'):
                temp_model = DescribeSagUserDnsResponseBodyTaskStates()
                self.task_states.append(temp_model.from_map(k))
        return self


class DescribeSagUserDnsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSagUserDnsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSagUserDnsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSagVbrRelationsRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        vbr_instance_ids: List[str] = None,
        vbr_region_id: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.vbr_instance_ids = vbr_instance_ids
        self.vbr_region_id = vbr_region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.vbr_instance_ids is not None:
            result['VbrInstanceIds'] = self.vbr_instance_ids
        if self.vbr_region_id is not None:
            result['VbrRegionId'] = self.vbr_region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('VbrInstanceIds') is not None:
            self.vbr_instance_ids = m.get('VbrInstanceIds')
        if m.get('VbrRegionId') is not None:
            self.vbr_region_id = m.get('VbrRegionId')
        return self


class DescribeSagVbrRelationsResponseBodySagVbrRelations(TeaModel):
    def __init__(
        self,
        sag_instance_id: str = None,
        sag_uid: str = None,
        vbr_instance_id: str = None,
    ):
        self.sag_instance_id = sag_instance_id
        self.sag_uid = sag_uid
        self.vbr_instance_id = vbr_instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sag_instance_id is not None:
            result['SagInstanceId'] = self.sag_instance_id
        if self.sag_uid is not None:
            result['SagUid'] = self.sag_uid
        if self.vbr_instance_id is not None:
            result['VbrInstanceId'] = self.vbr_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SagInstanceId') is not None:
            self.sag_instance_id = m.get('SagInstanceId')
        if m.get('SagUid') is not None:
            self.sag_uid = m.get('SagUid')
        if m.get('VbrInstanceId') is not None:
            self.vbr_instance_id = m.get('VbrInstanceId')
        return self


class DescribeSagVbrRelationsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        sag_vbr_relations: List[DescribeSagVbrRelationsResponseBodySagVbrRelations] = None,
    ):
        self.request_id = request_id
        self.sag_vbr_relations = sag_vbr_relations

    def validate(self):
        if self.sag_vbr_relations:
            for k in self.sag_vbr_relations:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['SagVbrRelations'] = []
        if self.sag_vbr_relations is not None:
            for k in self.sag_vbr_relations:
                result['SagVbrRelations'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.sag_vbr_relations = []
        if m.get('SagVbrRelations') is not None:
            for k in m.get('SagVbrRelations'):
                temp_model = DescribeSagVbrRelationsResponseBodySagVbrRelations()
                self.sag_vbr_relations.append(temp_model.from_map(k))
        return self


class DescribeSagVbrRelationsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSagVbrRelationsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSagVbrRelationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSagWan4GRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        smart_agsn: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.smart_agsn = smart_agsn

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_agsn is not None:
            result['SmartAGSn'] = self.smart_agsn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGSn') is not None:
            self.smart_agsn = m.get('SmartAGSn')
        return self


class DescribeSagWan4GResponseBody(TeaModel):
    def __init__(
        self,
        ip: str = None,
        mac: str = None,
        priority: int = None,
        request_id: str = None,
        status: str = None,
        strength: str = None,
        traffic_state: str = None,
    ):
        self.ip = ip
        self.mac = mac
        self.priority = priority
        self.request_id = request_id
        self.status = status
        self.strength = strength
        self.traffic_state = traffic_state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.mac is not None:
            result['Mac'] = self.mac
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        if self.strength is not None:
            result['Strength'] = self.strength
        if self.traffic_state is not None:
            result['TrafficState'] = self.traffic_state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Mac') is not None:
            self.mac = m.get('Mac')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Strength') is not None:
            self.strength = m.get('Strength')
        if m.get('TrafficState') is not None:
            self.traffic_state = m.get('TrafficState')
        return self


class DescribeSagWan4GResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSagWan4GResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSagWan4GResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSagWanListRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        smart_agsn: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.smart_agsn = smart_agsn

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_agsn is not None:
            result['SmartAGSn'] = self.smart_agsn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGSn') is not None:
            self.smart_agsn = m.get('SmartAGSn')
        return self


class DescribeSagWanListResponseBodyTaskStates(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        error_code: str = None,
        error_message: str = None,
        state: str = None,
    ):
        self.create_time = create_time
        self.error_code = error_code
        self.error_message = error_message
        self.state = state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class DescribeSagWanListResponseBodyWans(TeaModel):
    def __init__(
        self,
        band_width: int = None,
        gateway: str = None,
        ip: str = None,
        iptype: str = None,
        isp: str = None,
        mask: str = None,
        port_name: str = None,
        priority: int = None,
        traffic_state: str = None,
        username: str = None,
        weight: int = None,
    ):
        self.band_width = band_width
        self.gateway = gateway
        self.ip = ip
        self.iptype = iptype
        self.isp = isp
        self.mask = mask
        self.port_name = port_name
        self.priority = priority
        self.traffic_state = traffic_state
        self.username = username
        self.weight = weight

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.band_width is not None:
            result['BandWidth'] = self.band_width
        if self.gateway is not None:
            result['Gateway'] = self.gateway
        if self.ip is not None:
            result['IP'] = self.ip
        if self.iptype is not None:
            result['IPType'] = self.iptype
        if self.isp is not None:
            result['ISP'] = self.isp
        if self.mask is not None:
            result['Mask'] = self.mask
        if self.port_name is not None:
            result['PortName'] = self.port_name
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.traffic_state is not None:
            result['TrafficState'] = self.traffic_state
        if self.username is not None:
            result['Username'] = self.username
        if self.weight is not None:
            result['Weight'] = self.weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BandWidth') is not None:
            self.band_width = m.get('BandWidth')
        if m.get('Gateway') is not None:
            self.gateway = m.get('Gateway')
        if m.get('IP') is not None:
            self.ip = m.get('IP')
        if m.get('IPType') is not None:
            self.iptype = m.get('IPType')
        if m.get('ISP') is not None:
            self.isp = m.get('ISP')
        if m.get('Mask') is not None:
            self.mask = m.get('Mask')
        if m.get('PortName') is not None:
            self.port_name = m.get('PortName')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('TrafficState') is not None:
            self.traffic_state = m.get('TrafficState')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        return self


class DescribeSagWanListResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        task_states: List[DescribeSagWanListResponseBodyTaskStates] = None,
        wans: List[DescribeSagWanListResponseBodyWans] = None,
    ):
        self.request_id = request_id
        self.task_states = task_states
        self.wans = wans

    def validate(self):
        if self.task_states:
            for k in self.task_states:
                if k:
                    k.validate()
        if self.wans:
            for k in self.wans:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['TaskStates'] = []
        if self.task_states is not None:
            for k in self.task_states:
                result['TaskStates'].append(k.to_map() if k else None)
        result['Wans'] = []
        if self.wans is not None:
            for k in self.wans:
                result['Wans'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.task_states = []
        if m.get('TaskStates') is not None:
            for k in m.get('TaskStates'):
                temp_model = DescribeSagWanListResponseBodyTaskStates()
                self.task_states.append(temp_model.from_map(k))
        self.wans = []
        if m.get('Wans') is not None:
            for k in m.get('Wans'):
                temp_model = DescribeSagWanListResponseBodyWans()
                self.wans.append(temp_model.from_map(k))
        return self


class DescribeSagWanListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSagWanListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSagWanListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSagWanSnatRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        smart_agsn: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.smart_agsn = smart_agsn

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_agsn is not None:
            result['SmartAGSn'] = self.smart_agsn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGSn') is not None:
            self.smart_agsn = m.get('SmartAGSn')
        return self


class DescribeSagWanSnatResponseBodyTaskStates(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        error_code: str = None,
        error_message: str = None,
        state: str = None,
    ):
        self.create_time = create_time
        self.error_code = error_code
        self.error_message = error_message
        self.state = state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class DescribeSagWanSnatResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        snat: str = None,
        task_states: List[DescribeSagWanSnatResponseBodyTaskStates] = None,
    ):
        self.request_id = request_id
        self.snat = snat
        self.task_states = task_states

    def validate(self):
        if self.task_states:
            for k in self.task_states:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.snat is not None:
            result['Snat'] = self.snat
        result['TaskStates'] = []
        if self.task_states is not None:
            for k in self.task_states:
                result['TaskStates'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Snat') is not None:
            self.snat = m.get('Snat')
        self.task_states = []
        if m.get('TaskStates') is not None:
            for k in m.get('TaskStates'):
                temp_model = DescribeSagWanSnatResponseBodyTaskStates()
                self.task_states.append(temp_model.from_map(k))
        return self


class DescribeSagWanSnatResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSagWanSnatResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSagWanSnatResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSagWifiRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        smart_agsn: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.smart_agsn = smart_agsn

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_agsn is not None:
            result['SmartAGSn'] = self.smart_agsn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGSn') is not None:
            self.smart_agsn = m.get('SmartAGSn')
        return self


class DescribeSagWifiResponseBodyTaskStates(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        error_code: str = None,
        error_message: str = None,
        state: str = None,
    ):
        self.create_time = create_time
        self.error_code = error_code
        self.error_message = error_message
        self.state = state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class DescribeSagWifiResponseBody(TeaModel):
    def __init__(
        self,
        authentication_type: str = None,
        bandwidth: str = None,
        channel: str = None,
        encrypt_algorithm: str = None,
        is_auth: str = None,
        is_broadcast: str = None,
        is_enable: str = None,
        request_id: str = None,
        ssid: str = None,
        task_states: List[DescribeSagWifiResponseBodyTaskStates] = None,
    ):
        self.authentication_type = authentication_type
        self.bandwidth = bandwidth
        self.channel = channel
        self.encrypt_algorithm = encrypt_algorithm
        self.is_auth = is_auth
        self.is_broadcast = is_broadcast
        self.is_enable = is_enable
        self.request_id = request_id
        self.ssid = ssid
        self.task_states = task_states

    def validate(self):
        if self.task_states:
            for k in self.task_states:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.authentication_type is not None:
            result['AuthenticationType'] = self.authentication_type
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.channel is not None:
            result['Channel'] = self.channel
        if self.encrypt_algorithm is not None:
            result['EncryptAlgorithm'] = self.encrypt_algorithm
        if self.is_auth is not None:
            result['IsAuth'] = self.is_auth
        if self.is_broadcast is not None:
            result['IsBroadcast'] = self.is_broadcast
        if self.is_enable is not None:
            result['IsEnable'] = self.is_enable
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.ssid is not None:
            result['Ssid'] = self.ssid
        result['TaskStates'] = []
        if self.task_states is not None:
            for k in self.task_states:
                result['TaskStates'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthenticationType') is not None:
            self.authentication_type = m.get('AuthenticationType')
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('Channel') is not None:
            self.channel = m.get('Channel')
        if m.get('EncryptAlgorithm') is not None:
            self.encrypt_algorithm = m.get('EncryptAlgorithm')
        if m.get('IsAuth') is not None:
            self.is_auth = m.get('IsAuth')
        if m.get('IsBroadcast') is not None:
            self.is_broadcast = m.get('IsBroadcast')
        if m.get('IsEnable') is not None:
            self.is_enable = m.get('IsEnable')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Ssid') is not None:
            self.ssid = m.get('Ssid')
        self.task_states = []
        if m.get('TaskStates') is not None:
            for k in m.get('TaskStates'):
                temp_model = DescribeSagWifiResponseBodyTaskStates()
                self.task_states.append(temp_model.from_map(k))
        return self


class DescribeSagWifiResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSagWifiResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSagWifiResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSmartAccessGatewayAttributeRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        return self


class DescribeSmartAccessGatewayAttributeResponseBodyAclIds(TeaModel):
    def __init__(
        self,
        acl_id: List[str] = None,
    ):
        self.acl_id = acl_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_id is not None:
            result['AclId'] = self.acl_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclId') is not None:
            self.acl_id = m.get('AclId')
        return self


class DescribeSmartAccessGatewayAttributeResponseBodyApplicationBandwidthPackageOperationLocks(TeaModel):
    def __init__(
        self,
        lock_reason: str = None,
        lock_type: str = None,
    ):
        self.lock_reason = lock_reason
        self.lock_type = lock_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lock_reason is not None:
            result['LockReason'] = self.lock_reason
        if self.lock_type is not None:
            result['LockType'] = self.lock_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LockReason') is not None:
            self.lock_reason = m.get('LockReason')
        if m.get('LockType') is not None:
            self.lock_type = m.get('LockType')
        return self


class DescribeSmartAccessGatewayAttributeResponseBodyDevicesDevice(TeaModel):
    def __init__(
        self,
        distribute_sk_status: int = None,
        dpi_signature_db_version: str = None,
        ha_state: str = None,
        hc_state: str = None,
        monitor_version: str = None,
        secret_key: str = None,
        serial_number: str = None,
        software_version: str = None,
    ):
        self.distribute_sk_status = distribute_sk_status
        self.dpi_signature_db_version = dpi_signature_db_version
        self.ha_state = ha_state
        self.hc_state = hc_state
        self.monitor_version = monitor_version
        self.secret_key = secret_key
        self.serial_number = serial_number
        self.software_version = software_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.distribute_sk_status is not None:
            result['DistributeSkStatus'] = self.distribute_sk_status
        if self.dpi_signature_db_version is not None:
            result['DpiSignatureDbVersion'] = self.dpi_signature_db_version
        if self.ha_state is not None:
            result['HaState'] = self.ha_state
        if self.hc_state is not None:
            result['HcState'] = self.hc_state
        if self.monitor_version is not None:
            result['MonitorVersion'] = self.monitor_version
        if self.secret_key is not None:
            result['SecretKey'] = self.secret_key
        if self.serial_number is not None:
            result['SerialNumber'] = self.serial_number
        if self.software_version is not None:
            result['SoftwareVersion'] = self.software_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DistributeSkStatus') is not None:
            self.distribute_sk_status = m.get('DistributeSkStatus')
        if m.get('DpiSignatureDbVersion') is not None:
            self.dpi_signature_db_version = m.get('DpiSignatureDbVersion')
        if m.get('HaState') is not None:
            self.ha_state = m.get('HaState')
        if m.get('HcState') is not None:
            self.hc_state = m.get('HcState')
        if m.get('MonitorVersion') is not None:
            self.monitor_version = m.get('MonitorVersion')
        if m.get('SecretKey') is not None:
            self.secret_key = m.get('SecretKey')
        if m.get('SerialNumber') is not None:
            self.serial_number = m.get('SerialNumber')
        if m.get('SoftwareVersion') is not None:
            self.software_version = m.get('SoftwareVersion')
        return self


class DescribeSmartAccessGatewayAttributeResponseBodyDevices(TeaModel):
    def __init__(
        self,
        device: List[DescribeSmartAccessGatewayAttributeResponseBodyDevicesDevice] = None,
    ):
        self.device = device

    def validate(self):
        if self.device:
            for k in self.device:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Device'] = []
        if self.device is not None:
            for k in self.device:
                result['Device'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.device = []
        if m.get('Device') is not None:
            for k in m.get('Device'):
                temp_model = DescribeSmartAccessGatewayAttributeResponseBodyDevicesDevice()
                self.device.append(temp_model.from_map(k))
        return self


class DescribeSmartAccessGatewayAttributeResponseBodyFlowLogIds(TeaModel):
    def __init__(
        self,
        flow_log_id: List[str] = None,
    ):
        self.flow_log_id = flow_log_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flow_log_id is not None:
            result['FlowLogId'] = self.flow_log_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FlowLogId') is not None:
            self.flow_log_id = m.get('FlowLogId')
        return self


class DescribeSmartAccessGatewayAttributeResponseBodyLinksLink(TeaModel):
    def __init__(
        self,
        bandwidth: str = None,
        commodity_type: str = None,
        end_time: int = None,
        health_check_target_ip: str = None,
        instance_id: str = None,
        relate_instance_id: str = None,
        relate_instance_region_id: str = None,
        status: str = None,
        type: str = None,
    ):
        self.bandwidth = bandwidth
        self.commodity_type = commodity_type
        self.end_time = end_time
        self.health_check_target_ip = health_check_target_ip
        self.instance_id = instance_id
        self.relate_instance_id = relate_instance_id
        self.relate_instance_region_id = relate_instance_region_id
        self.status = status
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.commodity_type is not None:
            result['CommodityType'] = self.commodity_type
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.health_check_target_ip is not None:
            result['HealthCheckTargetIp'] = self.health_check_target_ip
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.relate_instance_id is not None:
            result['RelateInstanceId'] = self.relate_instance_id
        if self.relate_instance_region_id is not None:
            result['RelateInstanceRegionId'] = self.relate_instance_region_id
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('CommodityType') is not None:
            self.commodity_type = m.get('CommodityType')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('HealthCheckTargetIp') is not None:
            self.health_check_target_ip = m.get('HealthCheckTargetIp')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RelateInstanceId') is not None:
            self.relate_instance_id = m.get('RelateInstanceId')
        if m.get('RelateInstanceRegionId') is not None:
            self.relate_instance_region_id = m.get('RelateInstanceRegionId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeSmartAccessGatewayAttributeResponseBodyLinks(TeaModel):
    def __init__(
        self,
        link: List[DescribeSmartAccessGatewayAttributeResponseBodyLinksLink] = None,
    ):
        self.link = link

    def validate(self):
        if self.link:
            for k in self.link:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Link'] = []
        if self.link is not None:
            for k in self.link:
                result['Link'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.link = []
        if m.get('Link') is not None:
            for k in m.get('Link'):
                temp_model = DescribeSmartAccessGatewayAttributeResponseBodyLinksLink()
                self.link.append(temp_model.from_map(k))
        return self


class DescribeSmartAccessGatewayAttributeResponseBodyQosIds(TeaModel):
    def __init__(
        self,
        qos_id: List[str] = None,
    ):
        self.qos_id = qos_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.qos_id is not None:
            result['QosId'] = self.qos_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('QosId') is not None:
            self.qos_id = m.get('QosId')
        return self


class DescribeSmartAccessGatewayAttributeResponseBody(TeaModel):
    def __init__(
        self,
        accelerate_bandwidth: int = None,
        access_point_id: str = None,
        acl_ids: DescribeSmartAccessGatewayAttributeResponseBodyAclIds = None,
        application_bandwidth_package_bussiness_status: str = None,
        application_bandwidth_package_id: str = None,
        application_bandwidth_package_name: str = None,
        application_bandwidth_package_operation_locks: DescribeSmartAccessGatewayAttributeResponseBodyApplicationBandwidthPackageOperationLocks = None,
        associated_ccn_id: str = None,
        associated_ccn_name: str = None,
        backup_box_controller_ip: str = None,
        box_controller_ip: str = None,
        cidr_block: str = None,
        city: str = None,
        create_time: int = None,
        data_plan: int = None,
        description: str = None,
        devices: DescribeSmartAccessGatewayAttributeResponseBodyDevices = None,
        enable_optimization: bool = None,
        end_time: int = None,
        flow_log_ids: DescribeSmartAccessGatewayAttributeResponseBodyFlowLogIds = None,
        instance_type: str = None,
        ipsec_status: str = None,
        links: DescribeSmartAccessGatewayAttributeResponseBodyLinks = None,
        max_bandwidth: str = None,
        name: str = None,
        optimization_type: bool = None,
        qos_ids: DescribeSmartAccessGatewayAttributeResponseBodyQosIds = None,
        request_id: str = None,
        reseller_instance_id: str = None,
        reseller_uid: str = None,
        resource_group_id: str = None,
        routing_strategy: str = None,
        security_lock_threshold: int = None,
        serial_number: str = None,
        smart_agid: str = None,
        status: str = None,
        traffic_master_sn: str = None,
        up_bandwidth_4g: int = None,
        up_bandwidth_wan: int = None,
        user_count: int = None,
        vpn_status: str = None,
    ):
        self.accelerate_bandwidth = accelerate_bandwidth
        self.access_point_id = access_point_id
        self.acl_ids = acl_ids
        self.application_bandwidth_package_bussiness_status = application_bandwidth_package_bussiness_status
        self.application_bandwidth_package_id = application_bandwidth_package_id
        self.application_bandwidth_package_name = application_bandwidth_package_name
        self.application_bandwidth_package_operation_locks = application_bandwidth_package_operation_locks
        self.associated_ccn_id = associated_ccn_id
        self.associated_ccn_name = associated_ccn_name
        self.backup_box_controller_ip = backup_box_controller_ip
        self.box_controller_ip = box_controller_ip
        self.cidr_block = cidr_block
        self.city = city
        self.create_time = create_time
        self.data_plan = data_plan
        self.description = description
        self.devices = devices
        self.enable_optimization = enable_optimization
        self.end_time = end_time
        self.flow_log_ids = flow_log_ids
        self.instance_type = instance_type
        self.ipsec_status = ipsec_status
        self.links = links
        self.max_bandwidth = max_bandwidth
        self.name = name
        self.optimization_type = optimization_type
        self.qos_ids = qos_ids
        self.request_id = request_id
        self.reseller_instance_id = reseller_instance_id
        self.reseller_uid = reseller_uid
        self.resource_group_id = resource_group_id
        self.routing_strategy = routing_strategy
        self.security_lock_threshold = security_lock_threshold
        self.serial_number = serial_number
        self.smart_agid = smart_agid
        self.status = status
        self.traffic_master_sn = traffic_master_sn
        self.up_bandwidth_4g = up_bandwidth_4g
        self.up_bandwidth_wan = up_bandwidth_wan
        self.user_count = user_count
        self.vpn_status = vpn_status

    def validate(self):
        if self.acl_ids:
            self.acl_ids.validate()
        if self.application_bandwidth_package_operation_locks:
            self.application_bandwidth_package_operation_locks.validate()
        if self.devices:
            self.devices.validate()
        if self.flow_log_ids:
            self.flow_log_ids.validate()
        if self.links:
            self.links.validate()
        if self.qos_ids:
            self.qos_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accelerate_bandwidth is not None:
            result['AccelerateBandwidth'] = self.accelerate_bandwidth
        if self.access_point_id is not None:
            result['AccessPointId'] = self.access_point_id
        if self.acl_ids is not None:
            result['AclIds'] = self.acl_ids.to_map()
        if self.application_bandwidth_package_bussiness_status is not None:
            result['ApplicationBandwidthPackageBussinessStatus'] = self.application_bandwidth_package_bussiness_status
        if self.application_bandwidth_package_id is not None:
            result['ApplicationBandwidthPackageId'] = self.application_bandwidth_package_id
        if self.application_bandwidth_package_name is not None:
            result['ApplicationBandwidthPackageName'] = self.application_bandwidth_package_name
        if self.application_bandwidth_package_operation_locks is not None:
            result['ApplicationBandwidthPackageOperationLocks'] = self.application_bandwidth_package_operation_locks.to_map()
        if self.associated_ccn_id is not None:
            result['AssociatedCcnId'] = self.associated_ccn_id
        if self.associated_ccn_name is not None:
            result['AssociatedCcnName'] = self.associated_ccn_name
        if self.backup_box_controller_ip is not None:
            result['BackupBoxControllerIp'] = self.backup_box_controller_ip
        if self.box_controller_ip is not None:
            result['BoxControllerIp'] = self.box_controller_ip
        if self.cidr_block is not None:
            result['CidrBlock'] = self.cidr_block
        if self.city is not None:
            result['City'] = self.city
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.data_plan is not None:
            result['DataPlan'] = self.data_plan
        if self.description is not None:
            result['Description'] = self.description
        if self.devices is not None:
            result['Devices'] = self.devices.to_map()
        if self.enable_optimization is not None:
            result['EnableOptimization'] = self.enable_optimization
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.flow_log_ids is not None:
            result['FlowLogIds'] = self.flow_log_ids.to_map()
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.ipsec_status is not None:
            result['IpsecStatus'] = self.ipsec_status
        if self.links is not None:
            result['Links'] = self.links.to_map()
        if self.max_bandwidth is not None:
            result['MaxBandwidth'] = self.max_bandwidth
        if self.name is not None:
            result['Name'] = self.name
        if self.optimization_type is not None:
            result['OptimizationType'] = self.optimization_type
        if self.qos_ids is not None:
            result['QosIds'] = self.qos_ids.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.reseller_instance_id is not None:
            result['ResellerInstanceId'] = self.reseller_instance_id
        if self.reseller_uid is not None:
            result['ResellerUid'] = self.reseller_uid
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.routing_strategy is not None:
            result['RoutingStrategy'] = self.routing_strategy
        if self.security_lock_threshold is not None:
            result['SecurityLockThreshold'] = self.security_lock_threshold
        if self.serial_number is not None:
            result['SerialNumber'] = self.serial_number
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.status is not None:
            result['Status'] = self.status
        if self.traffic_master_sn is not None:
            result['TrafficMasterSn'] = self.traffic_master_sn
        if self.up_bandwidth_4g is not None:
            result['UpBandwidth4G'] = self.up_bandwidth_4g
        if self.up_bandwidth_wan is not None:
            result['UpBandwidthWan'] = self.up_bandwidth_wan
        if self.user_count is not None:
            result['UserCount'] = self.user_count
        if self.vpn_status is not None:
            result['VpnStatus'] = self.vpn_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccelerateBandwidth') is not None:
            self.accelerate_bandwidth = m.get('AccelerateBandwidth')
        if m.get('AccessPointId') is not None:
            self.access_point_id = m.get('AccessPointId')
        if m.get('AclIds') is not None:
            temp_model = DescribeSmartAccessGatewayAttributeResponseBodyAclIds()
            self.acl_ids = temp_model.from_map(m['AclIds'])
        if m.get('ApplicationBandwidthPackageBussinessStatus') is not None:
            self.application_bandwidth_package_bussiness_status = m.get('ApplicationBandwidthPackageBussinessStatus')
        if m.get('ApplicationBandwidthPackageId') is not None:
            self.application_bandwidth_package_id = m.get('ApplicationBandwidthPackageId')
        if m.get('ApplicationBandwidthPackageName') is not None:
            self.application_bandwidth_package_name = m.get('ApplicationBandwidthPackageName')
        if m.get('ApplicationBandwidthPackageOperationLocks') is not None:
            temp_model = DescribeSmartAccessGatewayAttributeResponseBodyApplicationBandwidthPackageOperationLocks()
            self.application_bandwidth_package_operation_locks = temp_model.from_map(m['ApplicationBandwidthPackageOperationLocks'])
        if m.get('AssociatedCcnId') is not None:
            self.associated_ccn_id = m.get('AssociatedCcnId')
        if m.get('AssociatedCcnName') is not None:
            self.associated_ccn_name = m.get('AssociatedCcnName')
        if m.get('BackupBoxControllerIp') is not None:
            self.backup_box_controller_ip = m.get('BackupBoxControllerIp')
        if m.get('BoxControllerIp') is not None:
            self.box_controller_ip = m.get('BoxControllerIp')
        if m.get('CidrBlock') is not None:
            self.cidr_block = m.get('CidrBlock')
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DataPlan') is not None:
            self.data_plan = m.get('DataPlan')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Devices') is not None:
            temp_model = DescribeSmartAccessGatewayAttributeResponseBodyDevices()
            self.devices = temp_model.from_map(m['Devices'])
        if m.get('EnableOptimization') is not None:
            self.enable_optimization = m.get('EnableOptimization')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('FlowLogIds') is not None:
            temp_model = DescribeSmartAccessGatewayAttributeResponseBodyFlowLogIds()
            self.flow_log_ids = temp_model.from_map(m['FlowLogIds'])
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('IpsecStatus') is not None:
            self.ipsec_status = m.get('IpsecStatus')
        if m.get('Links') is not None:
            temp_model = DescribeSmartAccessGatewayAttributeResponseBodyLinks()
            self.links = temp_model.from_map(m['Links'])
        if m.get('MaxBandwidth') is not None:
            self.max_bandwidth = m.get('MaxBandwidth')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OptimizationType') is not None:
            self.optimization_type = m.get('OptimizationType')
        if m.get('QosIds') is not None:
            temp_model = DescribeSmartAccessGatewayAttributeResponseBodyQosIds()
            self.qos_ids = temp_model.from_map(m['QosIds'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResellerInstanceId') is not None:
            self.reseller_instance_id = m.get('ResellerInstanceId')
        if m.get('ResellerUid') is not None:
            self.reseller_uid = m.get('ResellerUid')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('RoutingStrategy') is not None:
            self.routing_strategy = m.get('RoutingStrategy')
        if m.get('SecurityLockThreshold') is not None:
            self.security_lock_threshold = m.get('SecurityLockThreshold')
        if m.get('SerialNumber') is not None:
            self.serial_number = m.get('SerialNumber')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TrafficMasterSn') is not None:
            self.traffic_master_sn = m.get('TrafficMasterSn')
        if m.get('UpBandwidth4G') is not None:
            self.up_bandwidth_4g = m.get('UpBandwidth4G')
        if m.get('UpBandwidthWan') is not None:
            self.up_bandwidth_wan = m.get('UpBandwidthWan')
        if m.get('UserCount') is not None:
            self.user_count = m.get('UserCount')
        if m.get('VpnStatus') is not None:
            self.vpn_status = m.get('VpnStatus')
        return self


class DescribeSmartAccessGatewayAttributeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSmartAccessGatewayAttributeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSmartAccessGatewayAttributeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSmartAccessGatewayClientUsersRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        user_mail: str = None,
        user_name: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.page_number = page_number
        self.page_size = page_size
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.user_mail = user_mail
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.user_mail is not None:
            result['UserMail'] = self.user_mail
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('UserMail') is not None:
            self.user_mail = m.get('UserMail')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class DescribeSmartAccessGatewayClientUsersResponseBodyUsersUser(TeaModel):
    def __init__(
        self,
        accelerate_bandwidth: int = None,
        bandwidth: int = None,
        client_ip: str = None,
        is_static_ip: int = None,
        state: int = None,
        user_mail: str = None,
        user_name: str = None,
    ):
        self.accelerate_bandwidth = accelerate_bandwidth
        self.bandwidth = bandwidth
        self.client_ip = client_ip
        self.is_static_ip = is_static_ip
        self.state = state
        self.user_mail = user_mail
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accelerate_bandwidth is not None:
            result['AccelerateBandwidth'] = self.accelerate_bandwidth
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.client_ip is not None:
            result['ClientIp'] = self.client_ip
        if self.is_static_ip is not None:
            result['IsStaticIp'] = self.is_static_ip
        if self.state is not None:
            result['State'] = self.state
        if self.user_mail is not None:
            result['UserMail'] = self.user_mail
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccelerateBandwidth') is not None:
            self.accelerate_bandwidth = m.get('AccelerateBandwidth')
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('ClientIp') is not None:
            self.client_ip = m.get('ClientIp')
        if m.get('IsStaticIp') is not None:
            self.is_static_ip = m.get('IsStaticIp')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('UserMail') is not None:
            self.user_mail = m.get('UserMail')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class DescribeSmartAccessGatewayClientUsersResponseBodyUsers(TeaModel):
    def __init__(
        self,
        user: List[DescribeSmartAccessGatewayClientUsersResponseBodyUsersUser] = None,
    ):
        self.user = user

    def validate(self):
        if self.user:
            for k in self.user:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['User'] = []
        if self.user is not None:
            for k in self.user:
                result['User'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.user = []
        if m.get('User') is not None:
            for k in m.get('User'):
                temp_model = DescribeSmartAccessGatewayClientUsersResponseBodyUsersUser()
                self.user.append(temp_model.from_map(k))
        return self


class DescribeSmartAccessGatewayClientUsersResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
        users: DescribeSmartAccessGatewayClientUsersResponseBodyUsers = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.total_count = total_count
        self.users = users

    def validate(self):
        if self.users:
            self.users.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.users is not None:
            result['Users'] = self.users.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Users') is not None:
            temp_model = DescribeSmartAccessGatewayClientUsersResponseBodyUsers()
            self.users = temp_model.from_map(m['Users'])
        return self


class DescribeSmartAccessGatewayClientUsersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSmartAccessGatewayClientUsersResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSmartAccessGatewayClientUsersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSmartAccessGatewayHaRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        return self


class DescribeSmartAccessGatewayHaResponseBodyLinkBackupInfoListLinkBackupInfoList(TeaModel):
    def __init__(
        self,
        backup_link_id: str = None,
        backup_link_state: str = None,
        link_level_backup_state: str = None,
        link_level_backup_type: str = None,
        main_link_id: str = None,
        main_link_state: str = None,
    ):
        self.backup_link_id = backup_link_id
        self.backup_link_state = backup_link_state
        self.link_level_backup_state = link_level_backup_state
        self.link_level_backup_type = link_level_backup_type
        self.main_link_id = main_link_id
        self.main_link_state = main_link_state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_link_id is not None:
            result['BackupLinkId'] = self.backup_link_id
        if self.backup_link_state is not None:
            result['BackupLinkState'] = self.backup_link_state
        if self.link_level_backup_state is not None:
            result['LinkLevelBackupState'] = self.link_level_backup_state
        if self.link_level_backup_type is not None:
            result['LinkLevelBackupType'] = self.link_level_backup_type
        if self.main_link_id is not None:
            result['MainLinkId'] = self.main_link_id
        if self.main_link_state is not None:
            result['MainLinkState'] = self.main_link_state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BackupLinkId') is not None:
            self.backup_link_id = m.get('BackupLinkId')
        if m.get('BackupLinkState') is not None:
            self.backup_link_state = m.get('BackupLinkState')
        if m.get('LinkLevelBackupState') is not None:
            self.link_level_backup_state = m.get('LinkLevelBackupState')
        if m.get('LinkLevelBackupType') is not None:
            self.link_level_backup_type = m.get('LinkLevelBackupType')
        if m.get('MainLinkId') is not None:
            self.main_link_id = m.get('MainLinkId')
        if m.get('MainLinkState') is not None:
            self.main_link_state = m.get('MainLinkState')
        return self


class DescribeSmartAccessGatewayHaResponseBodyLinkBackupInfoList(TeaModel):
    def __init__(
        self,
        link_backup_info_list: List[DescribeSmartAccessGatewayHaResponseBodyLinkBackupInfoListLinkBackupInfoList] = None,
    ):
        self.link_backup_info_list = link_backup_info_list

    def validate(self):
        if self.link_backup_info_list:
            for k in self.link_backup_info_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LinkBackupInfoList'] = []
        if self.link_backup_info_list is not None:
            for k in self.link_backup_info_list:
                result['LinkBackupInfoList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.link_backup_info_list = []
        if m.get('LinkBackupInfoList') is not None:
            for k in m.get('LinkBackupInfoList'):
                temp_model = DescribeSmartAccessGatewayHaResponseBodyLinkBackupInfoListLinkBackupInfoList()
                self.link_backup_info_list.append(temp_model.from_map(k))
        return self


class DescribeSmartAccessGatewayHaResponseBody(TeaModel):
    def __init__(
        self,
        backup_device_id: str = None,
        device_level_backup_state: str = None,
        device_level_backup_type: str = None,
        link_backup_info_list: DescribeSmartAccessGatewayHaResponseBodyLinkBackupInfoList = None,
        main_device_id: str = None,
        request_id: str = None,
        smart_agid: str = None,
    ):
        self.backup_device_id = backup_device_id
        self.device_level_backup_state = device_level_backup_state
        self.device_level_backup_type = device_level_backup_type
        self.link_backup_info_list = link_backup_info_list
        self.main_device_id = main_device_id
        self.request_id = request_id
        self.smart_agid = smart_agid

    def validate(self):
        if self.link_backup_info_list:
            self.link_backup_info_list.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_device_id is not None:
            result['BackupDeviceId'] = self.backup_device_id
        if self.device_level_backup_state is not None:
            result['DeviceLevelBackupState'] = self.device_level_backup_state
        if self.device_level_backup_type is not None:
            result['DeviceLevelBackupType'] = self.device_level_backup_type
        if self.link_backup_info_list is not None:
            result['LinkBackupInfoList'] = self.link_backup_info_list.to_map()
        if self.main_device_id is not None:
            result['MainDeviceId'] = self.main_device_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BackupDeviceId') is not None:
            self.backup_device_id = m.get('BackupDeviceId')
        if m.get('DeviceLevelBackupState') is not None:
            self.device_level_backup_state = m.get('DeviceLevelBackupState')
        if m.get('DeviceLevelBackupType') is not None:
            self.device_level_backup_type = m.get('DeviceLevelBackupType')
        if m.get('LinkBackupInfoList') is not None:
            temp_model = DescribeSmartAccessGatewayHaResponseBodyLinkBackupInfoList()
            self.link_backup_info_list = temp_model.from_map(m['LinkBackupInfoList'])
        if m.get('MainDeviceId') is not None:
            self.main_device_id = m.get('MainDeviceId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        return self


class DescribeSmartAccessGatewayHaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSmartAccessGatewayHaResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSmartAccessGatewayHaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSmartAccessGatewayVersionsRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        smart_agsn: str = None,
        version_type: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.smart_agsn = smart_agsn
        self.version_type = version_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_agsn is not None:
            result['SmartAGSn'] = self.smart_agsn
        if self.version_type is not None:
            result['VersionType'] = self.version_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGSn') is not None:
            self.smart_agsn = m.get('SmartAGSn')
        if m.get('VersionType') is not None:
            self.version_type = m.get('VersionType')
        return self


class DescribeSmartAccessGatewayVersionsResponseBodySmartAGVersionsSmartAGVersion(TeaModel):
    def __init__(
        self,
        create_time: int = None,
        type: str = None,
        version_code: str = None,
        version_name: str = None,
    ):
        self.create_time = create_time
        self.type = type
        self.version_code = version_code
        self.version_name = version_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.type is not None:
            result['Type'] = self.type
        if self.version_code is not None:
            result['VersionCode'] = self.version_code
        if self.version_name is not None:
            result['VersionName'] = self.version_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('VersionCode') is not None:
            self.version_code = m.get('VersionCode')
        if m.get('VersionName') is not None:
            self.version_name = m.get('VersionName')
        return self


class DescribeSmartAccessGatewayVersionsResponseBodySmartAGVersions(TeaModel):
    def __init__(
        self,
        smart_agversion: List[DescribeSmartAccessGatewayVersionsResponseBodySmartAGVersionsSmartAGVersion] = None,
    ):
        self.smart_agversion = smart_agversion

    def validate(self):
        if self.smart_agversion:
            for k in self.smart_agversion:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SmartAGVersion'] = []
        if self.smart_agversion is not None:
            for k in self.smart_agversion:
                result['SmartAGVersion'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.smart_agversion = []
        if m.get('SmartAGVersion') is not None:
            for k in m.get('SmartAGVersion'):
                temp_model = DescribeSmartAccessGatewayVersionsResponseBodySmartAGVersionsSmartAGVersion()
                self.smart_agversion.append(temp_model.from_map(k))
        return self


class DescribeSmartAccessGatewayVersionsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        smart_agversions: DescribeSmartAccessGatewayVersionsResponseBodySmartAGVersions = None,
    ):
        self.request_id = request_id
        self.smart_agversions = smart_agversions

    def validate(self):
        if self.smart_agversions:
            self.smart_agversions.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.smart_agversions is not None:
            result['SmartAGVersions'] = self.smart_agversions.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SmartAGVersions') is not None:
            temp_model = DescribeSmartAccessGatewayVersionsResponseBodySmartAGVersions()
            self.smart_agversions = temp_model.from_map(m['SmartAGVersions'])
        return self


class DescribeSmartAccessGatewayVersionsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSmartAccessGatewayVersionsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSmartAccessGatewayVersionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSmartAccessGatewaysRequest(TeaModel):
    def __init__(
        self,
        acl_ids: str = None,
        associated_ccn_id: str = None,
        business_state: str = None,
        can_associate_qos: bool = None,
        hardware_type: str = None,
        instance_type: str = None,
        name: str = None,
        owner_account: str = None,
        owner_id: int = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        resource_group_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        serial_number: str = None,
        smart_agid: str = None,
        smart_agids: List[str] = None,
        software_version: str = None,
        status: str = None,
        unbound_acl_ids: str = None,
        version_comparator: str = None,
    ):
        self.acl_ids = acl_ids
        self.associated_ccn_id = associated_ccn_id
        self.business_state = business_state
        self.can_associate_qos = can_associate_qos
        self.hardware_type = hardware_type
        self.instance_type = instance_type
        self.name = name
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.page_number = page_number
        self.page_size = page_size
        self.region_id = region_id
        self.resource_group_id = resource_group_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.serial_number = serial_number
        self.smart_agid = smart_agid
        self.smart_agids = smart_agids
        self.software_version = software_version
        self.status = status
        self.unbound_acl_ids = unbound_acl_ids
        self.version_comparator = version_comparator

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_ids is not None:
            result['AclIds'] = self.acl_ids
        if self.associated_ccn_id is not None:
            result['AssociatedCcnId'] = self.associated_ccn_id
        if self.business_state is not None:
            result['BusinessState'] = self.business_state
        if self.can_associate_qos is not None:
            result['CanAssociateQos'] = self.can_associate_qos
        if self.hardware_type is not None:
            result['HardwareType'] = self.hardware_type
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.serial_number is not None:
            result['SerialNumber'] = self.serial_number
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_agids is not None:
            result['SmartAGIds'] = self.smart_agids
        if self.software_version is not None:
            result['SoftwareVersion'] = self.software_version
        if self.status is not None:
            result['Status'] = self.status
        if self.unbound_acl_ids is not None:
            result['UnboundAclIds'] = self.unbound_acl_ids
        if self.version_comparator is not None:
            result['VersionComparator'] = self.version_comparator
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclIds') is not None:
            self.acl_ids = m.get('AclIds')
        if m.get('AssociatedCcnId') is not None:
            self.associated_ccn_id = m.get('AssociatedCcnId')
        if m.get('BusinessState') is not None:
            self.business_state = m.get('BusinessState')
        if m.get('CanAssociateQos') is not None:
            self.can_associate_qos = m.get('CanAssociateQos')
        if m.get('HardwareType') is not None:
            self.hardware_type = m.get('HardwareType')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SerialNumber') is not None:
            self.serial_number = m.get('SerialNumber')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGIds') is not None:
            self.smart_agids = m.get('SmartAGIds')
        if m.get('SoftwareVersion') is not None:
            self.software_version = m.get('SoftwareVersion')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UnboundAclIds') is not None:
            self.unbound_acl_ids = m.get('UnboundAclIds')
        if m.get('VersionComparator') is not None:
            self.version_comparator = m.get('VersionComparator')
        return self


class DescribeSmartAccessGatewaysResponseBodySmartAccessGatewaysSmartAccessGatewayLinksLink(TeaModel):
    def __init__(
        self,
        bandwidth: str = None,
        commodity_type: str = None,
        end_time: int = None,
        instance_id: str = None,
        relate_instance_id: str = None,
        relate_instance_region_id: str = None,
        status: str = None,
        type: str = None,
    ):
        self.bandwidth = bandwidth
        self.commodity_type = commodity_type
        self.end_time = end_time
        self.instance_id = instance_id
        self.relate_instance_id = relate_instance_id
        self.relate_instance_region_id = relate_instance_region_id
        self.status = status
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.commodity_type is not None:
            result['CommodityType'] = self.commodity_type
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.relate_instance_id is not None:
            result['RelateInstanceId'] = self.relate_instance_id
        if self.relate_instance_region_id is not None:
            result['RelateInstanceRegionId'] = self.relate_instance_region_id
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('CommodityType') is not None:
            self.commodity_type = m.get('CommodityType')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RelateInstanceId') is not None:
            self.relate_instance_id = m.get('RelateInstanceId')
        if m.get('RelateInstanceRegionId') is not None:
            self.relate_instance_region_id = m.get('RelateInstanceRegionId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeSmartAccessGatewaysResponseBodySmartAccessGatewaysSmartAccessGatewayLinks(TeaModel):
    def __init__(
        self,
        link: List[DescribeSmartAccessGatewaysResponseBodySmartAccessGatewaysSmartAccessGatewayLinksLink] = None,
    ):
        self.link = link

    def validate(self):
        if self.link:
            for k in self.link:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Link'] = []
        if self.link is not None:
            for k in self.link:
                result['Link'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.link = []
        if m.get('Link') is not None:
            for k in m.get('Link'):
                temp_model = DescribeSmartAccessGatewaysResponseBodySmartAccessGatewaysSmartAccessGatewayLinksLink()
                self.link.append(temp_model.from_map(k))
        return self


class DescribeSmartAccessGatewaysResponseBodySmartAccessGatewaysSmartAccessGateway(TeaModel):
    def __init__(
        self,
        accelerate_bandwidth: int = None,
        access_point_id: str = None,
        acl_ids: str = None,
        application_bandwidth_package_id: str = None,
        associated_ccn_id: str = None,
        associated_ccn_name: str = None,
        backup_software_version: str = None,
        backup_status: str = None,
        cidr_block: str = None,
        city: str = None,
        create_time: int = None,
        data_plan: int = None,
        description: str = None,
        dpi_monitor_status: str = None,
        dpi_status: str = None,
        end_time: int = None,
        enterprise_code: str = None,
        hardware_version: str = None,
        idaas_application_id: str = None,
        idaas_id: str = None,
        ipsec_status: str = None,
        links: DescribeSmartAccessGatewaysResponseBodySmartAccessGatewaysSmartAccessGatewayLinks = None,
        max_bandwidth: str = None,
        name: str = None,
        qos_ids: str = None,
        reseller_instance_id: str = None,
        reseller_uid: str = None,
        resource_group_id: str = None,
        routing_strategy: str = None,
        security_lock_threshold: int = None,
        serial_number: str = None,
        smart_agid: str = None,
        smart_aguid: int = None,
        software_version: str = None,
        status: str = None,
        up_bandwidth_4g: int = None,
        up_bandwidth_wan: int = None,
        user_count: int = None,
        vpn_status: str = None,
    ):
        self.accelerate_bandwidth = accelerate_bandwidth
        self.access_point_id = access_point_id
        self.acl_ids = acl_ids
        self.application_bandwidth_package_id = application_bandwidth_package_id
        self.associated_ccn_id = associated_ccn_id
        self.associated_ccn_name = associated_ccn_name
        self.backup_software_version = backup_software_version
        self.backup_status = backup_status
        self.cidr_block = cidr_block
        self.city = city
        self.create_time = create_time
        self.data_plan = data_plan
        self.description = description
        self.dpi_monitor_status = dpi_monitor_status
        self.dpi_status = dpi_status
        self.end_time = end_time
        self.enterprise_code = enterprise_code
        self.hardware_version = hardware_version
        self.idaas_application_id = idaas_application_id
        self.idaas_id = idaas_id
        self.ipsec_status = ipsec_status
        self.links = links
        self.max_bandwidth = max_bandwidth
        self.name = name
        self.qos_ids = qos_ids
        self.reseller_instance_id = reseller_instance_id
        self.reseller_uid = reseller_uid
        self.resource_group_id = resource_group_id
        self.routing_strategy = routing_strategy
        self.security_lock_threshold = security_lock_threshold
        self.serial_number = serial_number
        self.smart_agid = smart_agid
        self.smart_aguid = smart_aguid
        self.software_version = software_version
        self.status = status
        self.up_bandwidth_4g = up_bandwidth_4g
        self.up_bandwidth_wan = up_bandwidth_wan
        self.user_count = user_count
        self.vpn_status = vpn_status

    def validate(self):
        if self.links:
            self.links.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accelerate_bandwidth is not None:
            result['AccelerateBandwidth'] = self.accelerate_bandwidth
        if self.access_point_id is not None:
            result['AccessPointId'] = self.access_point_id
        if self.acl_ids is not None:
            result['AclIds'] = self.acl_ids
        if self.application_bandwidth_package_id is not None:
            result['ApplicationBandwidthPackageId'] = self.application_bandwidth_package_id
        if self.associated_ccn_id is not None:
            result['AssociatedCcnId'] = self.associated_ccn_id
        if self.associated_ccn_name is not None:
            result['AssociatedCcnName'] = self.associated_ccn_name
        if self.backup_software_version is not None:
            result['BackupSoftwareVersion'] = self.backup_software_version
        if self.backup_status is not None:
            result['BackupStatus'] = self.backup_status
        if self.cidr_block is not None:
            result['CidrBlock'] = self.cidr_block
        if self.city is not None:
            result['City'] = self.city
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.data_plan is not None:
            result['DataPlan'] = self.data_plan
        if self.description is not None:
            result['Description'] = self.description
        if self.dpi_monitor_status is not None:
            result['DpiMonitorStatus'] = self.dpi_monitor_status
        if self.dpi_status is not None:
            result['DpiStatus'] = self.dpi_status
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.enterprise_code is not None:
            result['EnterpriseCode'] = self.enterprise_code
        if self.hardware_version is not None:
            result['HardwareVersion'] = self.hardware_version
        if self.idaas_application_id is not None:
            result['IdaasApplicationId'] = self.idaas_application_id
        if self.idaas_id is not None:
            result['IdaasId'] = self.idaas_id
        if self.ipsec_status is not None:
            result['IpsecStatus'] = self.ipsec_status
        if self.links is not None:
            result['Links'] = self.links.to_map()
        if self.max_bandwidth is not None:
            result['MaxBandwidth'] = self.max_bandwidth
        if self.name is not None:
            result['Name'] = self.name
        if self.qos_ids is not None:
            result['QosIds'] = self.qos_ids
        if self.reseller_instance_id is not None:
            result['ResellerInstanceId'] = self.reseller_instance_id
        if self.reseller_uid is not None:
            result['ResellerUid'] = self.reseller_uid
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.routing_strategy is not None:
            result['RoutingStrategy'] = self.routing_strategy
        if self.security_lock_threshold is not None:
            result['SecurityLockThreshold'] = self.security_lock_threshold
        if self.serial_number is not None:
            result['SerialNumber'] = self.serial_number
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_aguid is not None:
            result['SmartAGUid'] = self.smart_aguid
        if self.software_version is not None:
            result['SoftwareVersion'] = self.software_version
        if self.status is not None:
            result['Status'] = self.status
        if self.up_bandwidth_4g is not None:
            result['UpBandwidth4G'] = self.up_bandwidth_4g
        if self.up_bandwidth_wan is not None:
            result['UpBandwidthWan'] = self.up_bandwidth_wan
        if self.user_count is not None:
            result['UserCount'] = self.user_count
        if self.vpn_status is not None:
            result['VpnStatus'] = self.vpn_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccelerateBandwidth') is not None:
            self.accelerate_bandwidth = m.get('AccelerateBandwidth')
        if m.get('AccessPointId') is not None:
            self.access_point_id = m.get('AccessPointId')
        if m.get('AclIds') is not None:
            self.acl_ids = m.get('AclIds')
        if m.get('ApplicationBandwidthPackageId') is not None:
            self.application_bandwidth_package_id = m.get('ApplicationBandwidthPackageId')
        if m.get('AssociatedCcnId') is not None:
            self.associated_ccn_id = m.get('AssociatedCcnId')
        if m.get('AssociatedCcnName') is not None:
            self.associated_ccn_name = m.get('AssociatedCcnName')
        if m.get('BackupSoftwareVersion') is not None:
            self.backup_software_version = m.get('BackupSoftwareVersion')
        if m.get('BackupStatus') is not None:
            self.backup_status = m.get('BackupStatus')
        if m.get('CidrBlock') is not None:
            self.cidr_block = m.get('CidrBlock')
        if m.get('City') is not None:
            self.city = m.get('City')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DataPlan') is not None:
            self.data_plan = m.get('DataPlan')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DpiMonitorStatus') is not None:
            self.dpi_monitor_status = m.get('DpiMonitorStatus')
        if m.get('DpiStatus') is not None:
            self.dpi_status = m.get('DpiStatus')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EnterpriseCode') is not None:
            self.enterprise_code = m.get('EnterpriseCode')
        if m.get('HardwareVersion') is not None:
            self.hardware_version = m.get('HardwareVersion')
        if m.get('IdaasApplicationId') is not None:
            self.idaas_application_id = m.get('IdaasApplicationId')
        if m.get('IdaasId') is not None:
            self.idaas_id = m.get('IdaasId')
        if m.get('IpsecStatus') is not None:
            self.ipsec_status = m.get('IpsecStatus')
        if m.get('Links') is not None:
            temp_model = DescribeSmartAccessGatewaysResponseBodySmartAccessGatewaysSmartAccessGatewayLinks()
            self.links = temp_model.from_map(m['Links'])
        if m.get('MaxBandwidth') is not None:
            self.max_bandwidth = m.get('MaxBandwidth')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('QosIds') is not None:
            self.qos_ids = m.get('QosIds')
        if m.get('ResellerInstanceId') is not None:
            self.reseller_instance_id = m.get('ResellerInstanceId')
        if m.get('ResellerUid') is not None:
            self.reseller_uid = m.get('ResellerUid')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('RoutingStrategy') is not None:
            self.routing_strategy = m.get('RoutingStrategy')
        if m.get('SecurityLockThreshold') is not None:
            self.security_lock_threshold = m.get('SecurityLockThreshold')
        if m.get('SerialNumber') is not None:
            self.serial_number = m.get('SerialNumber')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGUid') is not None:
            self.smart_aguid = m.get('SmartAGUid')
        if m.get('SoftwareVersion') is not None:
            self.software_version = m.get('SoftwareVersion')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UpBandwidth4G') is not None:
            self.up_bandwidth_4g = m.get('UpBandwidth4G')
        if m.get('UpBandwidthWan') is not None:
            self.up_bandwidth_wan = m.get('UpBandwidthWan')
        if m.get('UserCount') is not None:
            self.user_count = m.get('UserCount')
        if m.get('VpnStatus') is not None:
            self.vpn_status = m.get('VpnStatus')
        return self


class DescribeSmartAccessGatewaysResponseBodySmartAccessGateways(TeaModel):
    def __init__(
        self,
        smart_access_gateway: List[DescribeSmartAccessGatewaysResponseBodySmartAccessGatewaysSmartAccessGateway] = None,
    ):
        self.smart_access_gateway = smart_access_gateway

    def validate(self):
        if self.smart_access_gateway:
            for k in self.smart_access_gateway:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SmartAccessGateway'] = []
        if self.smart_access_gateway is not None:
            for k in self.smart_access_gateway:
                result['SmartAccessGateway'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.smart_access_gateway = []
        if m.get('SmartAccessGateway') is not None:
            for k in m.get('SmartAccessGateway'):
                temp_model = DescribeSmartAccessGatewaysResponseBodySmartAccessGatewaysSmartAccessGateway()
                self.smart_access_gateway.append(temp_model.from_map(k))
        return self


class DescribeSmartAccessGatewaysResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        smart_access_gateways: DescribeSmartAccessGatewaysResponseBodySmartAccessGateways = None,
        total_count: int = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.smart_access_gateways = smart_access_gateways
        self.total_count = total_count

    def validate(self):
        if self.smart_access_gateways:
            self.smart_access_gateways.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.smart_access_gateways is not None:
            result['SmartAccessGateways'] = self.smart_access_gateways.to_map()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SmartAccessGateways') is not None:
            temp_model = DescribeSmartAccessGatewaysResponseBodySmartAccessGateways()
            self.smart_access_gateways = temp_model.from_map(m['SmartAccessGateways'])
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeSmartAccessGatewaysResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSmartAccessGatewaysResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSmartAccessGatewaysResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSnatEntriesRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.page_number = page_number
        self.page_size = page_size
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        return self


class DescribeSnatEntriesResponseBodySnatEntriesSnatEntry(TeaModel):
    def __init__(
        self,
        cidr_block: str = None,
        create_time: int = None,
        instance_id: str = None,
        snat_ip: str = None,
    ):
        self.cidr_block = cidr_block
        self.create_time = create_time
        self.instance_id = instance_id
        self.snat_ip = snat_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cidr_block is not None:
            result['CidrBlock'] = self.cidr_block
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.snat_ip is not None:
            result['SnatIp'] = self.snat_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CidrBlock') is not None:
            self.cidr_block = m.get('CidrBlock')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SnatIp') is not None:
            self.snat_ip = m.get('SnatIp')
        return self


class DescribeSnatEntriesResponseBodySnatEntries(TeaModel):
    def __init__(
        self,
        snat_entry: List[DescribeSnatEntriesResponseBodySnatEntriesSnatEntry] = None,
    ):
        self.snat_entry = snat_entry

    def validate(self):
        if self.snat_entry:
            for k in self.snat_entry:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SnatEntry'] = []
        if self.snat_entry is not None:
            for k in self.snat_entry:
                result['SnatEntry'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.snat_entry = []
        if m.get('SnatEntry') is not None:
            for k in m.get('SnatEntry'):
                temp_model = DescribeSnatEntriesResponseBodySnatEntriesSnatEntry()
                self.snat_entry.append(temp_model.from_map(k))
        return self


class DescribeSnatEntriesResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        snat_entries: DescribeSnatEntriesResponseBodySnatEntries = None,
        total_count: int = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.snat_entries = snat_entries
        self.total_count = total_count

    def validate(self):
        if self.snat_entries:
            self.snat_entries.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.snat_entries is not None:
            result['SnatEntries'] = self.snat_entries.to_map()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SnatEntries') is not None:
            temp_model = DescribeSnatEntriesResponseBodySnatEntries()
            self.snat_entries = temp_model.from_map(m['SnatEntries'])
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeSnatEntriesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSnatEntriesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSnatEntriesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeUnbindFlowLogSagsRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeUnbindFlowLogSagsResponseBodySagsSag(TeaModel):
    def __init__(
        self,
        description: str = None,
        name: str = None,
        smart_agid: str = None,
    ):
        self.description = description
        self.name = name
        self.smart_agid = smart_agid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        return self


class DescribeUnbindFlowLogSagsResponseBodySags(TeaModel):
    def __init__(
        self,
        sag: List[DescribeUnbindFlowLogSagsResponseBodySagsSag] = None,
    ):
        self.sag = sag

    def validate(self):
        if self.sag:
            for k in self.sag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Sag'] = []
        if self.sag is not None:
            for k in self.sag:
                result['Sag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.sag = []
        if m.get('Sag') is not None:
            for k in m.get('Sag'):
                temp_model = DescribeUnbindFlowLogSagsResponseBodySagsSag()
                self.sag.append(temp_model.from_map(k))
        return self


class DescribeUnbindFlowLogSagsResponseBody(TeaModel):
    def __init__(
        self,
        count: int = None,
        request_id: str = None,
        sags: DescribeUnbindFlowLogSagsResponseBodySags = None,
    ):
        self.count = count
        self.request_id = request_id
        self.sags = sags

    def validate(self):
        if self.sags:
            self.sags.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sags is not None:
            result['Sags'] = self.sags.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Sags') is not None:
            temp_model = DescribeUnbindFlowLogSagsResponseBodySags()
            self.sags = temp_model.from_map(m['Sags'])
        return self


class DescribeUnbindFlowLogSagsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeUnbindFlowLogSagsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeUnbindFlowLogSagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeUserFlowStatisticsRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        statistics_date: str = None,
        user_names: List[str] = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.statistics_date = statistics_date
        self.user_names = user_names

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.statistics_date is not None:
            result['StatisticsDate'] = self.statistics_date
        if self.user_names is not None:
            result['UserNames'] = self.user_names
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('StatisticsDate') is not None:
            self.statistics_date = m.get('StatisticsDate')
        if m.get('UserNames') is not None:
            self.user_names = m.get('UserNames')
        return self


class DescribeUserFlowStatisticsResponseBodySagStatisticsStatistics(TeaModel):
    def __init__(
        self,
        total_bytes: str = None,
        user_name: str = None,
    ):
        self.total_bytes = total_bytes
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_bytes is not None:
            result['TotalBytes'] = self.total_bytes
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalBytes') is not None:
            self.total_bytes = m.get('TotalBytes')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class DescribeUserFlowStatisticsResponseBodySagStatistics(TeaModel):
    def __init__(
        self,
        statistics: List[DescribeUserFlowStatisticsResponseBodySagStatisticsStatistics] = None,
    ):
        self.statistics = statistics

    def validate(self):
        if self.statistics:
            for k in self.statistics:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Statistics'] = []
        if self.statistics is not None:
            for k in self.statistics:
                result['Statistics'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.statistics = []
        if m.get('Statistics') is not None:
            for k in m.get('Statistics'):
                temp_model = DescribeUserFlowStatisticsResponseBodySagStatisticsStatistics()
                self.statistics.append(temp_model.from_map(k))
        return self


class DescribeUserFlowStatisticsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        sag_statistics: DescribeUserFlowStatisticsResponseBodySagStatistics = None,
    ):
        self.request_id = request_id
        self.sag_statistics = sag_statistics

    def validate(self):
        if self.sag_statistics:
            self.sag_statistics.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sag_statistics is not None:
            result['SagStatistics'] = self.sag_statistics.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SagStatistics') is not None:
            temp_model = DescribeUserFlowStatisticsResponseBodySagStatistics()
            self.sag_statistics = temp_model.from_map(m['SagStatistics'])
        return self


class DescribeUserFlowStatisticsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeUserFlowStatisticsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeUserFlowStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeUserOnlineClientStatisticsRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        user_names: List[str] = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.user_names = user_names

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.user_names is not None:
            result['UserNames'] = self.user_names
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('UserNames') is not None:
            self.user_names = m.get('UserNames')
        return self


class DescribeUserOnlineClientStatisticsResponseBodyUserStatisticsStatistics(TeaModel):
    def __init__(
        self,
        online_count: str = None,
        user_name: str = None,
    ):
        self.online_count = online_count
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.online_count is not None:
            result['OnlineCount'] = self.online_count
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OnlineCount') is not None:
            self.online_count = m.get('OnlineCount')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class DescribeUserOnlineClientStatisticsResponseBodyUserStatistics(TeaModel):
    def __init__(
        self,
        statistics: List[DescribeUserOnlineClientStatisticsResponseBodyUserStatisticsStatistics] = None,
    ):
        self.statistics = statistics

    def validate(self):
        if self.statistics:
            for k in self.statistics:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Statistics'] = []
        if self.statistics is not None:
            for k in self.statistics:
                result['Statistics'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.statistics = []
        if m.get('Statistics') is not None:
            for k in m.get('Statistics'):
                temp_model = DescribeUserOnlineClientStatisticsResponseBodyUserStatisticsStatistics()
                self.statistics.append(temp_model.from_map(k))
        return self


class DescribeUserOnlineClientStatisticsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        user_statistics: DescribeUserOnlineClientStatisticsResponseBodyUserStatistics = None,
    ):
        self.request_id = request_id
        self.user_statistics = user_statistics

    def validate(self):
        if self.user_statistics:
            self.user_statistics.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.user_statistics is not None:
            result['UserStatistics'] = self.user_statistics.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UserStatistics') is not None:
            temp_model = DescribeUserOnlineClientStatisticsResponseBodyUserStatistics()
            self.user_statistics = temp_model.from_map(m['UserStatistics'])
        return self


class DescribeUserOnlineClientStatisticsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeUserOnlineClientStatisticsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeUserOnlineClientStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeUserOnlineClientsRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        user_name: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class DescribeUserOnlineClientsResponseBodyUsersUser(TeaModel):
    def __init__(
        self,
        client_ip: str = None,
        online_time: str = None,
    ):
        self.client_ip = client_ip
        self.online_time = online_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_ip is not None:
            result['ClientIp'] = self.client_ip
        if self.online_time is not None:
            result['OnlineTime'] = self.online_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientIp') is not None:
            self.client_ip = m.get('ClientIp')
        if m.get('OnlineTime') is not None:
            self.online_time = m.get('OnlineTime')
        return self


class DescribeUserOnlineClientsResponseBodyUsers(TeaModel):
    def __init__(
        self,
        user: List[DescribeUserOnlineClientsResponseBodyUsersUser] = None,
    ):
        self.user = user

    def validate(self):
        if self.user:
            for k in self.user:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['User'] = []
        if self.user is not None:
            for k in self.user:
                result['User'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.user = []
        if m.get('User') is not None:
            for k in m.get('User'):
                temp_model = DescribeUserOnlineClientsResponseBodyUsersUser()
                self.user.append(temp_model.from_map(k))
        return self


class DescribeUserOnlineClientsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        users: DescribeUserOnlineClientsResponseBodyUsers = None,
    ):
        self.request_id = request_id
        self.users = users

    def validate(self):
        if self.users:
            self.users.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.users is not None:
            result['Users'] = self.users.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Users') is not None:
            temp_model = DescribeUserOnlineClientsResponseBodyUsers()
            self.users = temp_model.from_map(m['Users'])
        return self


class DescribeUserOnlineClientsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeUserOnlineClientsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeUserOnlineClientsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DiagnoseSmartAccessGatewayRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        smart_agsn: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.smart_agsn = smart_agsn

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_agsn is not None:
            result['SmartAGSn'] = self.smart_agsn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGSn') is not None:
            self.smart_agsn = m.get('SmartAGSn')
        return self


class DiagnoseSmartAccessGatewayResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DiagnoseSmartAccessGatewayResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DiagnoseSmartAccessGatewayResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DiagnoseSmartAccessGatewayResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableSmartAGDpiMonitorRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        dry_run: bool = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
    ):
        self.client_token = client_token
        self.dry_run = dry_run
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        return self


class DisableSmartAGDpiMonitorResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DisableSmartAGDpiMonitorResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DisableSmartAGDpiMonitorResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DisableSmartAGDpiMonitorResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableSmartAccessGatewayUserRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        user_name: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class DisableSmartAccessGatewayUserResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DisableSmartAccessGatewayUserResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DisableSmartAccessGatewayUserResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DisableSmartAccessGatewayUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisassociateACLRequest(TeaModel):
    def __init__(
        self,
        acl_id: str = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
    ):
        self.acl_id = acl_id
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_id is not None:
            result['AclId'] = self.acl_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclId') is not None:
            self.acl_id = m.get('AclId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        return self


class DisassociateACLResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DisassociateACLResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DisassociateACLResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DisassociateACLResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisassociateFlowLogRequest(TeaModel):
    def __init__(
        self,
        flow_log_id: str = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
    ):
        self.flow_log_id = flow_log_id
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flow_log_id is not None:
            result['FlowLogId'] = self.flow_log_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FlowLogId') is not None:
            self.flow_log_id = m.get('FlowLogId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        return self


class DisassociateFlowLogResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DisassociateFlowLogResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DisassociateFlowLogResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DisassociateFlowLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisassociateQosRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        qos_id: str = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.qos_id = qos_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.qos_id is not None:
            result['QosId'] = self.qos_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('QosId') is not None:
            self.qos_id = m.get('QosId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        return self


class DisassociateQosResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DisassociateQosResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DisassociateQosResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DisassociateQosResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DiscribeSmartAccessGatewayDiagnosisReportRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        smart_agsn: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.smart_agsn = smart_agsn

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_agsn is not None:
            result['SmartAGSn'] = self.smart_agsn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGSn') is not None:
            self.smart_agsn = m.get('SmartAGSn')
        return self


class DiscribeSmartAccessGatewayDiagnosisReportResponseBodyDiagnoseResultDetailsItemsCN(TeaModel):
    def __init__(
        self,
        advice: List[str] = None,
        details: List[str] = None,
        item_level: str = None,
        item_name: str = None,
        item_type: str = None,
    ):
        self.advice = advice
        self.details = details
        self.item_level = item_level
        self.item_name = item_name
        self.item_type = item_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.advice is not None:
            result['Advice'] = self.advice
        if self.details is not None:
            result['Details'] = self.details
        if self.item_level is not None:
            result['ItemLevel'] = self.item_level
        if self.item_name is not None:
            result['ItemName'] = self.item_name
        if self.item_type is not None:
            result['ItemType'] = self.item_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Advice') is not None:
            self.advice = m.get('Advice')
        if m.get('Details') is not None:
            self.details = m.get('Details')
        if m.get('ItemLevel') is not None:
            self.item_level = m.get('ItemLevel')
        if m.get('ItemName') is not None:
            self.item_name = m.get('ItemName')
        if m.get('ItemType') is not None:
            self.item_type = m.get('ItemType')
        return self


class DiscribeSmartAccessGatewayDiagnosisReportResponseBodyDiagnoseResultDetailsItemsEN(TeaModel):
    def __init__(
        self,
        advice: List[str] = None,
        details: List[str] = None,
        item_level: str = None,
        item_name: str = None,
        item_type: str = None,
    ):
        self.advice = advice
        self.details = details
        self.item_level = item_level
        self.item_name = item_name
        self.item_type = item_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.advice is not None:
            result['Advice'] = self.advice
        if self.details is not None:
            result['Details'] = self.details
        if self.item_level is not None:
            result['ItemLevel'] = self.item_level
        if self.item_name is not None:
            result['ItemName'] = self.item_name
        if self.item_type is not None:
            result['ItemType'] = self.item_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Advice') is not None:
            self.advice = m.get('Advice')
        if m.get('Details') is not None:
            self.details = m.get('Details')
        if m.get('ItemLevel') is not None:
            self.item_level = m.get('ItemLevel')
        if m.get('ItemName') is not None:
            self.item_name = m.get('ItemName')
        if m.get('ItemType') is not None:
            self.item_type = m.get('ItemType')
        return self


class DiscribeSmartAccessGatewayDiagnosisReportResponseBodyDiagnoseResultDetailsItems(TeaModel):
    def __init__(
        self,
        cn: DiscribeSmartAccessGatewayDiagnosisReportResponseBodyDiagnoseResultDetailsItemsCN = None,
        en: DiscribeSmartAccessGatewayDiagnosisReportResponseBodyDiagnoseResultDetailsItemsEN = None,
        end_time: int = None,
        item_name: str = None,
        level: str = None,
        start_time: int = None,
        type: str = None,
    ):
        self.cn = cn
        self.en = en
        self.end_time = end_time
        self.item_name = item_name
        self.level = level
        self.start_time = start_time
        self.type = type

    def validate(self):
        if self.cn:
            self.cn.validate()
        if self.en:
            self.en.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cn is not None:
            result['CN'] = self.cn.to_map()
        if self.en is not None:
            result['EN'] = self.en.to_map()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.item_name is not None:
            result['ItemName'] = self.item_name
        if self.level is not None:
            result['Level'] = self.level
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CN') is not None:
            temp_model = DiscribeSmartAccessGatewayDiagnosisReportResponseBodyDiagnoseResultDetailsItemsCN()
            self.cn = temp_model.from_map(m['CN'])
        if m.get('EN') is not None:
            temp_model = DiscribeSmartAccessGatewayDiagnosisReportResponseBodyDiagnoseResultDetailsItemsEN()
            self.en = temp_model.from_map(m['EN'])
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('ItemName') is not None:
            self.item_name = m.get('ItemName')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DiscribeSmartAccessGatewayDiagnosisReportResponseBodyDiagnoseResultDetailsStatistics(TeaModel):
    def __init__(
        self,
        error: int = None,
        info: int = None,
        total: int = None,
        warning: int = None,
    ):
        self.error = error
        self.info = info
        self.total = total
        self.warning = warning

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error is not None:
            result['Error'] = self.error
        if self.info is not None:
            result['Info'] = self.info
        if self.total is not None:
            result['Total'] = self.total
        if self.warning is not None:
            result['Warning'] = self.warning
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Error') is not None:
            self.error = m.get('Error')
        if m.get('Info') is not None:
            self.info = m.get('Info')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Warning') is not None:
            self.warning = m.get('Warning')
        return self


class DiscribeSmartAccessGatewayDiagnosisReportResponseBodyDiagnoseResultDetails(TeaModel):
    def __init__(
        self,
        items: List[DiscribeSmartAccessGatewayDiagnosisReportResponseBodyDiagnoseResultDetailsItems] = None,
        statistics: DiscribeSmartAccessGatewayDiagnosisReportResponseBodyDiagnoseResultDetailsStatistics = None,
        type: str = None,
    ):
        self.items = items
        self.statistics = statistics
        self.type = type

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()
        if self.statistics:
            self.statistics.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        if self.statistics is not None:
            result['Statistics'] = self.statistics.to_map()
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = DiscribeSmartAccessGatewayDiagnosisReportResponseBodyDiagnoseResultDetailsItems()
                self.items.append(temp_model.from_map(k))
        if m.get('Statistics') is not None:
            temp_model = DiscribeSmartAccessGatewayDiagnosisReportResponseBodyDiagnoseResultDetailsStatistics()
            self.statistics = temp_model.from_map(m['Statistics'])
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DiscribeSmartAccessGatewayDiagnosisReportResponseBodyDiagnoseResultLevel(TeaModel):
    def __init__(
        self,
        biz: str = None,
        configuration: str = None,
        total: str = None,
    ):
        self.biz = biz
        self.configuration = configuration
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz is not None:
            result['Biz'] = self.biz
        if self.configuration is not None:
            result['Configuration'] = self.configuration
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Biz') is not None:
            self.biz = m.get('Biz')
        if m.get('Configuration') is not None:
            self.configuration = m.get('Configuration')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DiscribeSmartAccessGatewayDiagnosisReportResponseBodyDiagnoseResultStatistics(TeaModel):
    def __init__(
        self,
        error: int = None,
        info: int = None,
        total: int = None,
        warning: int = None,
    ):
        self.error = error
        self.info = info
        self.total = total
        self.warning = warning

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error is not None:
            result['Error'] = self.error
        if self.info is not None:
            result['Info'] = self.info
        if self.total is not None:
            result['Total'] = self.total
        if self.warning is not None:
            result['Warning'] = self.warning
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Error') is not None:
            self.error = m.get('Error')
        if m.get('Info') is not None:
            self.info = m.get('Info')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        if m.get('Warning') is not None:
            self.warning = m.get('Warning')
        return self


class DiscribeSmartAccessGatewayDiagnosisReportResponseBodyDiagnoseResult(TeaModel):
    def __init__(
        self,
        box_type: str = None,
        box_version: str = None,
        details: List[DiscribeSmartAccessGatewayDiagnosisReportResponseBodyDiagnoseResultDetails] = None,
        diagnose_id: str = None,
        end_time: int = None,
        finished_number: int = None,
        instance_id: str = None,
        level: DiscribeSmartAccessGatewayDiagnosisReportResponseBodyDiagnoseResultLevel = None,
        monitor_version: str = None,
        percent: int = None,
        report_slssuccess: int = None,
        sn: str = None,
        start_time: int = None,
        state: str = None,
        statistics: DiscribeSmartAccessGatewayDiagnosisReportResponseBodyDiagnoseResultStatistics = None,
        store_type: str = None,
        total_number: int = None,
        uid: str = None,
        user_level: str = None,
    ):
        self.box_type = box_type
        self.box_version = box_version
        self.details = details
        self.diagnose_id = diagnose_id
        self.end_time = end_time
        self.finished_number = finished_number
        self.instance_id = instance_id
        self.level = level
        self.monitor_version = monitor_version
        self.percent = percent
        self.report_slssuccess = report_slssuccess
        self.sn = sn
        self.start_time = start_time
        self.state = state
        self.statistics = statistics
        self.store_type = store_type
        self.total_number = total_number
        self.uid = uid
        self.user_level = user_level

    def validate(self):
        if self.details:
            for k in self.details:
                if k:
                    k.validate()
        if self.level:
            self.level.validate()
        if self.statistics:
            self.statistics.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.box_type is not None:
            result['BoxType'] = self.box_type
        if self.box_version is not None:
            result['BoxVersion'] = self.box_version
        result['Details'] = []
        if self.details is not None:
            for k in self.details:
                result['Details'].append(k.to_map() if k else None)
        if self.diagnose_id is not None:
            result['DiagnoseId'] = self.diagnose_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.finished_number is not None:
            result['FinishedNumber'] = self.finished_number
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.level is not None:
            result['Level'] = self.level.to_map()
        if self.monitor_version is not None:
            result['MonitorVersion'] = self.monitor_version
        if self.percent is not None:
            result['Percent'] = self.percent
        if self.report_slssuccess is not None:
            result['ReportSLSSuccess'] = self.report_slssuccess
        if self.sn is not None:
            result['SN'] = self.sn
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.state is not None:
            result['State'] = self.state
        if self.statistics is not None:
            result['Statistics'] = self.statistics.to_map()
        if self.store_type is not None:
            result['StoreType'] = self.store_type
        if self.total_number is not None:
            result['TotalNumber'] = self.total_number
        if self.uid is not None:
            result['UId'] = self.uid
        if self.user_level is not None:
            result['UserLevel'] = self.user_level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BoxType') is not None:
            self.box_type = m.get('BoxType')
        if m.get('BoxVersion') is not None:
            self.box_version = m.get('BoxVersion')
        self.details = []
        if m.get('Details') is not None:
            for k in m.get('Details'):
                temp_model = DiscribeSmartAccessGatewayDiagnosisReportResponseBodyDiagnoseResultDetails()
                self.details.append(temp_model.from_map(k))
        if m.get('DiagnoseId') is not None:
            self.diagnose_id = m.get('DiagnoseId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('FinishedNumber') is not None:
            self.finished_number = m.get('FinishedNumber')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Level') is not None:
            temp_model = DiscribeSmartAccessGatewayDiagnosisReportResponseBodyDiagnoseResultLevel()
            self.level = temp_model.from_map(m['Level'])
        if m.get('MonitorVersion') is not None:
            self.monitor_version = m.get('MonitorVersion')
        if m.get('Percent') is not None:
            self.percent = m.get('Percent')
        if m.get('ReportSLSSuccess') is not None:
            self.report_slssuccess = m.get('ReportSLSSuccess')
        if m.get('SN') is not None:
            self.sn = m.get('SN')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Statistics') is not None:
            temp_model = DiscribeSmartAccessGatewayDiagnosisReportResponseBodyDiagnoseResultStatistics()
            self.statistics = temp_model.from_map(m['Statistics'])
        if m.get('StoreType') is not None:
            self.store_type = m.get('StoreType')
        if m.get('TotalNumber') is not None:
            self.total_number = m.get('TotalNumber')
        if m.get('UId') is not None:
            self.uid = m.get('UId')
        if m.get('UserLevel') is not None:
            self.user_level = m.get('UserLevel')
        return self


class DiscribeSmartAccessGatewayDiagnosisReportResponseBody(TeaModel):
    def __init__(
        self,
        diagnose_result: DiscribeSmartAccessGatewayDiagnosisReportResponseBodyDiagnoseResult = None,
        request_id: str = None,
    ):
        self.diagnose_result = diagnose_result
        self.request_id = request_id

    def validate(self):
        if self.diagnose_result:
            self.diagnose_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.diagnose_result is not None:
            result['DiagnoseResult'] = self.diagnose_result.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DiagnoseResult') is not None:
            temp_model = DiscribeSmartAccessGatewayDiagnosisReportResponseBodyDiagnoseResult()
            self.diagnose_result = temp_model.from_map(m['DiagnoseResult'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DiscribeSmartAccessGatewayDiagnosisReportResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DiscribeSmartAccessGatewayDiagnosisReportResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DiscribeSmartAccessGatewayDiagnosisReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DowngradeSmartAccessGatewayRequest(TeaModel):
    def __init__(
        self,
        auto_pay: bool = None,
        band_width_spec: int = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
    ):
        self.auto_pay = auto_pay
        self.band_width_spec = band_width_spec
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_pay is not None:
            result['AutoPay'] = self.auto_pay
        if self.band_width_spec is not None:
            result['BandWidthSpec'] = self.band_width_spec
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoPay') is not None:
            self.auto_pay = m.get('AutoPay')
        if m.get('BandWidthSpec') is not None:
            self.band_width_spec = m.get('BandWidthSpec')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        return self


class DowngradeSmartAccessGatewayResponseBody(TeaModel):
    def __init__(
        self,
        order_id: str = None,
        request_id: str = None,
    ):
        self.order_id = order_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DowngradeSmartAccessGatewayResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DowngradeSmartAccessGatewayResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DowngradeSmartAccessGatewayResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DowngradeSmartAccessGatewaySoftwareRequest(TeaModel):
    def __init__(
        self,
        auto_pay: bool = None,
        data_plan: int = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        user_count: int = None,
    ):
        self.auto_pay = auto_pay
        self.data_plan = data_plan
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.user_count = user_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_pay is not None:
            result['AutoPay'] = self.auto_pay
        if self.data_plan is not None:
            result['DataPlan'] = self.data_plan
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.user_count is not None:
            result['UserCount'] = self.user_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AutoPay') is not None:
            self.auto_pay = m.get('AutoPay')
        if m.get('DataPlan') is not None:
            self.data_plan = m.get('DataPlan')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('UserCount') is not None:
            self.user_count = m.get('UserCount')
        return self


class DowngradeSmartAccessGatewaySoftwareResponseBody(TeaModel):
    def __init__(
        self,
        order_id: str = None,
        request_id: str = None,
    ):
        self.order_id = order_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DowngradeSmartAccessGatewaySoftwareResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DowngradeSmartAccessGatewaySoftwareResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DowngradeSmartAccessGatewaySoftwareResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EnableSmartAGDpiMonitorRequest(TeaModel):
    def __init__(
        self,
        client_token: str = None,
        dry_run: bool = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        sls_log_store: str = None,
        sls_project_name: str = None,
        smart_agid: str = None,
    ):
        self.client_token = client_token
        self.dry_run = dry_run
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.sls_log_store = sls_log_store
        self.sls_project_name = sls_project_name
        self.smart_agid = smart_agid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.sls_log_store is not None:
            result['SlsLogStore'] = self.sls_log_store
        if self.sls_project_name is not None:
            result['SlsProjectName'] = self.sls_project_name
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SlsLogStore') is not None:
            self.sls_log_store = m.get('SlsLogStore')
        if m.get('SlsProjectName') is not None:
            self.sls_project_name = m.get('SlsProjectName')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        return self


class EnableSmartAGDpiMonitorResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class EnableSmartAGDpiMonitorResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: EnableSmartAGDpiMonitorResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = EnableSmartAGDpiMonitorResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EnableSmartAccessGatewayUserRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        user_name: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class EnableSmartAccessGatewayUserResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class EnableSmartAccessGatewayUserResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: EnableSmartAccessGatewayUserResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = EnableSmartAccessGatewayUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAclAttributeRequest(TeaModel):
    def __init__(
        self,
        acl_id: str = None,
        region_id: str = None,
    ):
        self.acl_id = acl_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_id is not None:
            result['AclId'] = self.acl_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclId') is not None:
            self.acl_id = m.get('AclId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class GetAclAttributeResponseBody(TeaModel):
    def __init__(
        self,
        acl_id: str = None,
        acl_name: str = None,
        error_config_smart_agcount: int = None,
        request_id: str = None,
    ):
        self.acl_id = acl_id
        self.acl_name = acl_name
        self.error_config_smart_agcount = error_config_smart_agcount
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_id is not None:
            result['AclId'] = self.acl_id
        if self.acl_name is not None:
            result['AclName'] = self.acl_name
        if self.error_config_smart_agcount is not None:
            result['ErrorConfigSmartAGCount'] = self.error_config_smart_agcount
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclId') is not None:
            self.acl_id = m.get('AclId')
        if m.get('AclName') is not None:
            self.acl_name = m.get('AclName')
        if m.get('ErrorConfigSmartAGCount') is not None:
            self.error_config_smart_agcount = m.get('ErrorConfigSmartAGCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetAclAttributeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetAclAttributeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetAclAttributeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetCloudConnectNetworkUseLimitRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class GetCloudConnectNetworkUseLimitResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        total_amount: int = None,
        used_amount: int = None,
    ):
        self.request_id = request_id
        self.total_amount = total_amount
        self.used_amount = used_amount

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_amount is not None:
            result['TotalAmount'] = self.total_amount
        if self.used_amount is not None:
            result['UsedAmount'] = self.used_amount
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalAmount') is not None:
            self.total_amount = m.get('TotalAmount')
        if m.get('UsedAmount') is not None:
            self.used_amount = m.get('UsedAmount')
        return self


class GetCloudConnectNetworkUseLimitResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetCloudConnectNetworkUseLimitResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetCloudConnectNetworkUseLimitResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetQosAttributeRequest(TeaModel):
    def __init__(
        self,
        qos_id: str = None,
        region_id: str = None,
    ):
        self.qos_id = qos_id
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.qos_id is not None:
            result['QosId'] = self.qos_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('QosId') is not None:
            self.qos_id = m.get('QosId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class GetQosAttributeResponseBodyQosCars(TeaModel):
    def __init__(
        self,
        limit_type: str = None,
        max_bandwidth_abs: int = None,
        max_bandwidth_percent: int = None,
        min_bandwidth_abs: int = None,
        min_bandwidth_percent: int = None,
        percent_source_type: str = None,
        priority: int = None,
        qos_car_description: str = None,
        qos_car_id: str = None,
        qos_car_name: str = None,
    ):
        self.limit_type = limit_type
        self.max_bandwidth_abs = max_bandwidth_abs
        self.max_bandwidth_percent = max_bandwidth_percent
        self.min_bandwidth_abs = min_bandwidth_abs
        self.min_bandwidth_percent = min_bandwidth_percent
        self.percent_source_type = percent_source_type
        self.priority = priority
        self.qos_car_description = qos_car_description
        self.qos_car_id = qos_car_id
        self.qos_car_name = qos_car_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.limit_type is not None:
            result['LimitType'] = self.limit_type
        if self.max_bandwidth_abs is not None:
            result['MaxBandwidthAbs'] = self.max_bandwidth_abs
        if self.max_bandwidth_percent is not None:
            result['MaxBandwidthPercent'] = self.max_bandwidth_percent
        if self.min_bandwidth_abs is not None:
            result['MinBandwidthAbs'] = self.min_bandwidth_abs
        if self.min_bandwidth_percent is not None:
            result['MinBandwidthPercent'] = self.min_bandwidth_percent
        if self.percent_source_type is not None:
            result['PercentSourceType'] = self.percent_source_type
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.qos_car_description is not None:
            result['QosCarDescription'] = self.qos_car_description
        if self.qos_car_id is not None:
            result['QosCarId'] = self.qos_car_id
        if self.qos_car_name is not None:
            result['QosCarName'] = self.qos_car_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LimitType') is not None:
            self.limit_type = m.get('LimitType')
        if m.get('MaxBandwidthAbs') is not None:
            self.max_bandwidth_abs = m.get('MaxBandwidthAbs')
        if m.get('MaxBandwidthPercent') is not None:
            self.max_bandwidth_percent = m.get('MaxBandwidthPercent')
        if m.get('MinBandwidthAbs') is not None:
            self.min_bandwidth_abs = m.get('MinBandwidthAbs')
        if m.get('MinBandwidthPercent') is not None:
            self.min_bandwidth_percent = m.get('MinBandwidthPercent')
        if m.get('PercentSourceType') is not None:
            self.percent_source_type = m.get('PercentSourceType')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('QosCarDescription') is not None:
            self.qos_car_description = m.get('QosCarDescription')
        if m.get('QosCarId') is not None:
            self.qos_car_id = m.get('QosCarId')
        if m.get('QosCarName') is not None:
            self.qos_car_name = m.get('QosCarName')
        return self


class GetQosAttributeResponseBodyQosPolicies(TeaModel):
    def __init__(
        self,
        dest_cidr: str = None,
        dest_port_range: str = None,
        end_time: int = None,
        ip_protocol: str = None,
        priority: int = None,
        qos_policie_description: str = None,
        qos_policie_name: str = None,
        source_cidr: str = None,
        source_port_range: str = None,
        start_time: int = None,
    ):
        self.dest_cidr = dest_cidr
        self.dest_port_range = dest_port_range
        self.end_time = end_time
        self.ip_protocol = ip_protocol
        self.priority = priority
        self.qos_policie_description = qos_policie_description
        self.qos_policie_name = qos_policie_name
        self.source_cidr = source_cidr
        self.source_port_range = source_port_range
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dest_cidr is not None:
            result['DestCidr'] = self.dest_cidr
        if self.dest_port_range is not None:
            result['DestPortRange'] = self.dest_port_range
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.ip_protocol is not None:
            result['IpProtocol'] = self.ip_protocol
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.qos_policie_description is not None:
            result['QosPolicieDescription'] = self.qos_policie_description
        if self.qos_policie_name is not None:
            result['QosPolicieName'] = self.qos_policie_name
        if self.source_cidr is not None:
            result['SourceCidr'] = self.source_cidr
        if self.source_port_range is not None:
            result['SourcePortRange'] = self.source_port_range
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DestCidr') is not None:
            self.dest_cidr = m.get('DestCidr')
        if m.get('DestPortRange') is not None:
            self.dest_port_range = m.get('DestPortRange')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('IpProtocol') is not None:
            self.ip_protocol = m.get('IpProtocol')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('QosPolicieDescription') is not None:
            self.qos_policie_description = m.get('QosPolicieDescription')
        if m.get('QosPolicieName') is not None:
            self.qos_policie_name = m.get('QosPolicieName')
        if m.get('SourceCidr') is not None:
            self.source_cidr = m.get('SourceCidr')
        if m.get('SourcePortRange') is not None:
            self.source_port_range = m.get('SourcePortRange')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class GetQosAttributeResponseBody(TeaModel):
    def __init__(
        self,
        error_config_smart_agcount: int = None,
        qos_cars: List[GetQosAttributeResponseBodyQosCars] = None,
        qos_description: str = None,
        qos_name: str = None,
        qos_policies: List[GetQosAttributeResponseBodyQosPolicies] = None,
        request_id: str = None,
    ):
        self.error_config_smart_agcount = error_config_smart_agcount
        self.qos_cars = qos_cars
        self.qos_description = qos_description
        self.qos_name = qos_name
        self.qos_policies = qos_policies
        self.request_id = request_id

    def validate(self):
        if self.qos_cars:
            for k in self.qos_cars:
                if k:
                    k.validate()
        if self.qos_policies:
            for k in self.qos_policies:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_config_smart_agcount is not None:
            result['ErrorConfigSmartAGCount'] = self.error_config_smart_agcount
        result['QosCars'] = []
        if self.qos_cars is not None:
            for k in self.qos_cars:
                result['QosCars'].append(k.to_map() if k else None)
        if self.qos_description is not None:
            result['QosDescription'] = self.qos_description
        if self.qos_name is not None:
            result['QosName'] = self.qos_name
        result['QosPolicies'] = []
        if self.qos_policies is not None:
            for k in self.qos_policies:
                result['QosPolicies'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorConfigSmartAGCount') is not None:
            self.error_config_smart_agcount = m.get('ErrorConfigSmartAGCount')
        self.qos_cars = []
        if m.get('QosCars') is not None:
            for k in m.get('QosCars'):
                temp_model = GetQosAttributeResponseBodyQosCars()
                self.qos_cars.append(temp_model.from_map(k))
        if m.get('QosDescription') is not None:
            self.qos_description = m.get('QosDescription')
        if m.get('QosName') is not None:
            self.qos_name = m.get('QosName')
        self.qos_policies = []
        if m.get('QosPolicies') is not None:
            for k in m.get('QosPolicies'):
                temp_model = GetQosAttributeResponseBodyQosPolicies()
                self.qos_policies.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetQosAttributeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetQosAttributeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetQosAttributeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSmartAGDpiAttributeRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        return self


class GetSmartAGDpiAttributeResponseBody(TeaModel):
    def __init__(
        self,
        dpi_monitor_status: str = None,
        dpi_status: str = None,
        logstore_name: str = None,
        project_name: str = None,
        request_id: str = None,
        sls_region: str = None,
    ):
        self.dpi_monitor_status = dpi_monitor_status
        self.dpi_status = dpi_status
        self.logstore_name = logstore_name
        self.project_name = project_name
        self.request_id = request_id
        self.sls_region = sls_region

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dpi_monitor_status is not None:
            result['DpiMonitorStatus'] = self.dpi_monitor_status
        if self.dpi_status is not None:
            result['DpiStatus'] = self.dpi_status
        if self.logstore_name is not None:
            result['LogstoreName'] = self.logstore_name
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sls_region is not None:
            result['SlsRegion'] = self.sls_region
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DpiMonitorStatus') is not None:
            self.dpi_monitor_status = m.get('DpiMonitorStatus')
        if m.get('DpiStatus') is not None:
            self.dpi_status = m.get('DpiStatus')
        if m.get('LogstoreName') is not None:
            self.logstore_name = m.get('LogstoreName')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SlsRegion') is not None:
            self.sls_region = m.get('SlsRegion')
        return self


class GetSmartAGDpiAttributeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetSmartAGDpiAttributeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetSmartAGDpiAttributeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSmartAccessGatewayUseLimitRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class GetSmartAccessGatewayUseLimitResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        total_amount: int = None,
        used_amount: int = None,
    ):
        self.request_id = request_id
        self.total_amount = total_amount
        self.used_amount = used_amount

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_amount is not None:
            result['TotalAmount'] = self.total_amount
        if self.used_amount is not None:
            result['UsedAmount'] = self.used_amount
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalAmount') is not None:
            self.total_amount = m.get('TotalAmount')
        if m.get('UsedAmount') is not None:
            self.used_amount = m.get('UsedAmount')
        return self


class GetSmartAccessGatewayUseLimitResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetSmartAccessGatewayUseLimitResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetSmartAccessGatewayUseLimitResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GrantInstanceToCbnRequest(TeaModel):
    def __init__(
        self,
        ccn_instance_id: str = None,
        cen_instance_id: str = None,
        cen_uid: int = None,
        grant_traffic_service: bool = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.ccn_instance_id = ccn_instance_id
        self.cen_instance_id = cen_instance_id
        self.cen_uid = cen_uid
        self.grant_traffic_service = grant_traffic_service
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ccn_instance_id is not None:
            result['CcnInstanceId'] = self.ccn_instance_id
        if self.cen_instance_id is not None:
            result['CenInstanceId'] = self.cen_instance_id
        if self.cen_uid is not None:
            result['CenUid'] = self.cen_uid
        if self.grant_traffic_service is not None:
            result['GrantTrafficService'] = self.grant_traffic_service
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CcnInstanceId') is not None:
            self.ccn_instance_id = m.get('CcnInstanceId')
        if m.get('CenInstanceId') is not None:
            self.cen_instance_id = m.get('CenInstanceId')
        if m.get('CenUid') is not None:
            self.cen_uid = m.get('CenUid')
        if m.get('GrantTrafficService') is not None:
            self.grant_traffic_service = m.get('GrantTrafficService')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class GrantInstanceToCbnResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GrantInstanceToCbnResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GrantInstanceToCbnResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GrantInstanceToCbnResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GrantSagInstanceToCcnRequest(TeaModel):
    def __init__(
        self,
        ccn_instance_id: str = None,
        ccn_uid: int = None,
        grant_traffic_service: bool = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
    ):
        self.ccn_instance_id = ccn_instance_id
        self.ccn_uid = ccn_uid
        self.grant_traffic_service = grant_traffic_service
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ccn_instance_id is not None:
            result['CcnInstanceId'] = self.ccn_instance_id
        if self.ccn_uid is not None:
            result['CcnUid'] = self.ccn_uid
        if self.grant_traffic_service is not None:
            result['GrantTrafficService'] = self.grant_traffic_service
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CcnInstanceId') is not None:
            self.ccn_instance_id = m.get('CcnInstanceId')
        if m.get('CcnUid') is not None:
            self.ccn_uid = m.get('CcnUid')
        if m.get('GrantTrafficService') is not None:
            self.grant_traffic_service = m.get('GrantTrafficService')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        return self


class GrantSagInstanceToCcnResponseBody(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        request_id: str = None,
    ):
        self.instance_id = instance_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GrantSagInstanceToCcnResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GrantSagInstanceToCcnResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GrantSagInstanceToCcnResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GrantSagInstanceToVbrRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        vbr_instance_id: str = None,
        vbr_region_id: str = None,
        vbr_uid: int = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.vbr_instance_id = vbr_instance_id
        self.vbr_region_id = vbr_region_id
        self.vbr_uid = vbr_uid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.vbr_instance_id is not None:
            result['VbrInstanceId'] = self.vbr_instance_id
        if self.vbr_region_id is not None:
            result['VbrRegionId'] = self.vbr_region_id
        if self.vbr_uid is not None:
            result['VbrUid'] = self.vbr_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('VbrInstanceId') is not None:
            self.vbr_instance_id = m.get('VbrInstanceId')
        if m.get('VbrRegionId') is not None:
            self.vbr_region_id = m.get('VbrRegionId')
        if m.get('VbrUid') is not None:
            self.vbr_uid = m.get('VbrUid')
        return self


class GrantSagInstanceToVbrResponseBody(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        request_id: str = None,
    ):
        self.instance_id = instance_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GrantSagInstanceToVbrResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GrantSagInstanceToVbrResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GrantSagInstanceToVbrResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class KickOutClientsRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        username: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.username = username

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.username is not None:
            result['Username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        return self


class KickOutClientsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class KickOutClientsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: KickOutClientsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = KickOutClientsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAccessPointNetworkQualitiesRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        return self


class ListAccessPointNetworkQualitiesResponseBodyAccessPointNetworkQualities(TeaModel):
    def __init__(
        self,
        id: int = None,
        loss: str = None,
        rtt: str = None,
    ):
        self.id = id
        self.loss = loss
        self.rtt = rtt

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.loss is not None:
            result['Loss'] = self.loss
        if self.rtt is not None:
            result['Rtt'] = self.rtt
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Loss') is not None:
            self.loss = m.get('Loss')
        if m.get('Rtt') is not None:
            self.rtt = m.get('Rtt')
        return self


class ListAccessPointNetworkQualitiesResponseBody(TeaModel):
    def __init__(
        self,
        access_point_network_qualities: List[ListAccessPointNetworkQualitiesResponseBodyAccessPointNetworkQualities] = None,
        request_id: str = None,
    ):
        self.access_point_network_qualities = access_point_network_qualities
        self.request_id = request_id

    def validate(self):
        if self.access_point_network_qualities:
            for k in self.access_point_network_qualities:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AccessPointNetworkQualities'] = []
        if self.access_point_network_qualities is not None:
            for k in self.access_point_network_qualities:
                result['AccessPointNetworkQualities'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.access_point_network_qualities = []
        if m.get('AccessPointNetworkQualities') is not None:
            for k in m.get('AccessPointNetworkQualities'):
                temp_model = ListAccessPointNetworkQualitiesResponseBodyAccessPointNetworkQualities()
                self.access_point_network_qualities.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListAccessPointNetworkQualitiesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListAccessPointNetworkQualitiesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListAccessPointNetworkQualitiesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAccessPointsRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.page_number = page_number
        self.page_size = page_size
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        return self


class ListAccessPointsResponseBodyAccessPoints(TeaModel):
    def __init__(
        self,
        access_point_id: int = None,
        active_smart_agcount: int = None,
        inactive_smart_agcount: int = None,
        latitude: str = None,
        longitude: str = None,
    ):
        self.access_point_id = access_point_id
        self.active_smart_agcount = active_smart_agcount
        self.inactive_smart_agcount = inactive_smart_agcount
        self.latitude = latitude
        self.longitude = longitude

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_point_id is not None:
            result['AccessPointId'] = self.access_point_id
        if self.active_smart_agcount is not None:
            result['ActiveSmartAGCount'] = self.active_smart_agcount
        if self.inactive_smart_agcount is not None:
            result['InactiveSmartAGCount'] = self.inactive_smart_agcount
        if self.latitude is not None:
            result['Latitude'] = self.latitude
        if self.longitude is not None:
            result['Longitude'] = self.longitude
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessPointId') is not None:
            self.access_point_id = m.get('AccessPointId')
        if m.get('ActiveSmartAGCount') is not None:
            self.active_smart_agcount = m.get('ActiveSmartAGCount')
        if m.get('InactiveSmartAGCount') is not None:
            self.inactive_smart_agcount = m.get('InactiveSmartAGCount')
        if m.get('Latitude') is not None:
            self.latitude = m.get('Latitude')
        if m.get('Longitude') is not None:
            self.longitude = m.get('Longitude')
        return self


class ListAccessPointsResponseBody(TeaModel):
    def __init__(
        self,
        access_points: List[ListAccessPointsResponseBodyAccessPoints] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.access_points = access_points
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.access_points:
            for k in self.access_points:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AccessPoints'] = []
        if self.access_points is not None:
            for k in self.access_points:
                result['AccessPoints'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.access_points = []
        if m.get('AccessPoints') is not None:
            for k in m.get('AccessPoints'):
                temp_model = ListAccessPointsResponseBodyAccessPoints()
                self.access_points.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListAccessPointsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListAccessPointsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListAccessPointsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDpiConfigErrorRequest(TeaModel):
    def __init__(
        self,
        dpi_config_type: str = None,
        max_results: int = None,
        next_token: str = None,
        region_id: str = None,
        rule_instance_id: str = None,
        smart_agid: str = None,
    ):
        self.dpi_config_type = dpi_config_type
        self.max_results = max_results
        self.next_token = next_token
        self.region_id = region_id
        self.rule_instance_id = rule_instance_id
        self.smart_agid = smart_agid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dpi_config_type is not None:
            result['DpiConfigType'] = self.dpi_config_type
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_instance_id is not None:
            result['RuleInstanceId'] = self.rule_instance_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DpiConfigType') is not None:
            self.dpi_config_type = m.get('DpiConfigType')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleInstanceId') is not None:
            self.rule_instance_id = m.get('RuleInstanceId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        return self


class ListDpiConfigErrorResponseBodyDpiConfigErrorRuleConfigErrorList(TeaModel):
    def __init__(
        self,
        dpi_group_ids: List[str] = None,
        dpi_signature_ids: List[str] = None,
        rule_id: str = None,
    ):
        self.dpi_group_ids = dpi_group_ids
        self.dpi_signature_ids = dpi_signature_ids
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dpi_group_ids is not None:
            result['DpiGroupIds'] = self.dpi_group_ids
        if self.dpi_signature_ids is not None:
            result['DpiSignatureIds'] = self.dpi_signature_ids
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DpiGroupIds') is not None:
            self.dpi_group_ids = m.get('DpiGroupIds')
        if m.get('DpiSignatureIds') is not None:
            self.dpi_signature_ids = m.get('DpiSignatureIds')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class ListDpiConfigErrorResponseBodyDpiConfigError(TeaModel):
    def __init__(
        self,
        error_type: str = None,
        rule_config_error_list: List[ListDpiConfigErrorResponseBodyDpiConfigErrorRuleConfigErrorList] = None,
        sn: str = None,
        smart_agid: str = None,
    ):
        self.error_type = error_type
        self.rule_config_error_list = rule_config_error_list
        self.sn = sn
        self.smart_agid = smart_agid

    def validate(self):
        if self.rule_config_error_list:
            for k in self.rule_config_error_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_type is not None:
            result['ErrorType'] = self.error_type
        result['RuleConfigErrorList'] = []
        if self.rule_config_error_list is not None:
            for k in self.rule_config_error_list:
                result['RuleConfigErrorList'].append(k.to_map() if k else None)
        if self.sn is not None:
            result['SN'] = self.sn
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorType') is not None:
            self.error_type = m.get('ErrorType')
        self.rule_config_error_list = []
        if m.get('RuleConfigErrorList') is not None:
            for k in m.get('RuleConfigErrorList'):
                temp_model = ListDpiConfigErrorResponseBodyDpiConfigErrorRuleConfigErrorList()
                self.rule_config_error_list.append(temp_model.from_map(k))
        if m.get('SN') is not None:
            self.sn = m.get('SN')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        return self


class ListDpiConfigErrorResponseBody(TeaModel):
    def __init__(
        self,
        dpi_config_error: List[ListDpiConfigErrorResponseBodyDpiConfigError] = None,
        max_results: int = None,
        next_token: str = None,
        request_id: str = None,
        total: int = None,
    ):
        self.dpi_config_error = dpi_config_error
        self.max_results = max_results
        self.next_token = next_token
        self.request_id = request_id
        self.total = total

    def validate(self):
        if self.dpi_config_error:
            for k in self.dpi_config_error:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DpiConfigError'] = []
        if self.dpi_config_error is not None:
            for k in self.dpi_config_error:
                result['DpiConfigError'].append(k.to_map() if k else None)
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dpi_config_error = []
        if m.get('DpiConfigError') is not None:
            for k in m.get('DpiConfigError'):
                temp_model = ListDpiConfigErrorResponseBodyDpiConfigError()
                self.dpi_config_error.append(temp_model.from_map(k))
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListDpiConfigErrorResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListDpiConfigErrorResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListDpiConfigErrorResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDpiGroupsRequest(TeaModel):
    def __init__(
        self,
        dpi_group_ids: List[str] = None,
        dpi_group_names: List[str] = None,
        max_results: int = None,
        next_token: str = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.dpi_group_ids = dpi_group_ids
        self.dpi_group_names = dpi_group_names
        self.max_results = max_results
        self.next_token = next_token
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dpi_group_ids is not None:
            result['DpiGroupIds'] = self.dpi_group_ids
        if self.dpi_group_names is not None:
            result['DpiGroupNames'] = self.dpi_group_names
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DpiGroupIds') is not None:
            self.dpi_group_ids = m.get('DpiGroupIds')
        if m.get('DpiGroupNames') is not None:
            self.dpi_group_names = m.get('DpiGroupNames')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class ListDpiGroupsResponseBodyDpiGroup(TeaModel):
    def __init__(
        self,
        dpi_group_id: str = None,
        dpi_group_name: str = None,
        min_engine_version: str = None,
        min_signature_db_version: str = None,
    ):
        self.dpi_group_id = dpi_group_id
        self.dpi_group_name = dpi_group_name
        self.min_engine_version = min_engine_version
        self.min_signature_db_version = min_signature_db_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dpi_group_id is not None:
            result['DpiGroupId'] = self.dpi_group_id
        if self.dpi_group_name is not None:
            result['DpiGroupName'] = self.dpi_group_name
        if self.min_engine_version is not None:
            result['MinEngineVersion'] = self.min_engine_version
        if self.min_signature_db_version is not None:
            result['MinSignatureDbVersion'] = self.min_signature_db_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DpiGroupId') is not None:
            self.dpi_group_id = m.get('DpiGroupId')
        if m.get('DpiGroupName') is not None:
            self.dpi_group_name = m.get('DpiGroupName')
        if m.get('MinEngineVersion') is not None:
            self.min_engine_version = m.get('MinEngineVersion')
        if m.get('MinSignatureDbVersion') is not None:
            self.min_signature_db_version = m.get('MinSignatureDbVersion')
        return self


class ListDpiGroupsResponseBody(TeaModel):
    def __init__(
        self,
        dpi_group: List[ListDpiGroupsResponseBodyDpiGroup] = None,
        next_token: str = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.dpi_group = dpi_group
        self.next_token = next_token
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.dpi_group:
            for k in self.dpi_group:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DpiGroup'] = []
        if self.dpi_group is not None:
            for k in self.dpi_group:
                result['DpiGroup'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dpi_group = []
        if m.get('DpiGroup') is not None:
            for k in m.get('DpiGroup'):
                temp_model = ListDpiGroupsResponseBodyDpiGroup()
                self.dpi_group.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListDpiGroupsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListDpiGroupsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListDpiGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDpiSignaturesRequest(TeaModel):
    def __init__(
        self,
        dpi_group_id: str = None,
        dpi_signature_ids: List[str] = None,
        dpi_signature_names: List[str] = None,
        max_results: int = None,
        next_token: str = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.dpi_group_id = dpi_group_id
        self.dpi_signature_ids = dpi_signature_ids
        self.dpi_signature_names = dpi_signature_names
        self.max_results = max_results
        self.next_token = next_token
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dpi_group_id is not None:
            result['DpiGroupId'] = self.dpi_group_id
        if self.dpi_signature_ids is not None:
            result['DpiSignatureIds'] = self.dpi_signature_ids
        if self.dpi_signature_names is not None:
            result['DpiSignatureNames'] = self.dpi_signature_names
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DpiGroupId') is not None:
            self.dpi_group_id = m.get('DpiGroupId')
        if m.get('DpiSignatureIds') is not None:
            self.dpi_signature_ids = m.get('DpiSignatureIds')
        if m.get('DpiSignatureNames') is not None:
            self.dpi_signature_names = m.get('DpiSignatureNames')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class ListDpiSignaturesResponseBodyDpiSignature(TeaModel):
    def __init__(
        self,
        dpi_group_id: str = None,
        dpi_signature_id: str = None,
        dpi_signature_name: str = None,
        min_engine_version: str = None,
        min_signature_db_version: str = None,
    ):
        self.dpi_group_id = dpi_group_id
        self.dpi_signature_id = dpi_signature_id
        self.dpi_signature_name = dpi_signature_name
        self.min_engine_version = min_engine_version
        self.min_signature_db_version = min_signature_db_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dpi_group_id is not None:
            result['DpiGroupId'] = self.dpi_group_id
        if self.dpi_signature_id is not None:
            result['DpiSignatureId'] = self.dpi_signature_id
        if self.dpi_signature_name is not None:
            result['DpiSignatureName'] = self.dpi_signature_name
        if self.min_engine_version is not None:
            result['MinEngineVersion'] = self.min_engine_version
        if self.min_signature_db_version is not None:
            result['MinSignatureDbVersion'] = self.min_signature_db_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DpiGroupId') is not None:
            self.dpi_group_id = m.get('DpiGroupId')
        if m.get('DpiSignatureId') is not None:
            self.dpi_signature_id = m.get('DpiSignatureId')
        if m.get('DpiSignatureName') is not None:
            self.dpi_signature_name = m.get('DpiSignatureName')
        if m.get('MinEngineVersion') is not None:
            self.min_engine_version = m.get('MinEngineVersion')
        if m.get('MinSignatureDbVersion') is not None:
            self.min_signature_db_version = m.get('MinSignatureDbVersion')
        return self


class ListDpiSignaturesResponseBody(TeaModel):
    def __init__(
        self,
        dpi_signature: List[ListDpiSignaturesResponseBodyDpiSignature] = None,
        next_token: str = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.dpi_signature = dpi_signature
        self.next_token = next_token
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.dpi_signature:
            for k in self.dpi_signature:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DpiSignature'] = []
        if self.dpi_signature is not None:
            for k in self.dpi_signature:
                result['DpiSignature'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dpi_signature = []
        if m.get('DpiSignature') is not None:
            for k in m.get('DpiSignature'):
                temp_model = ListDpiSignaturesResponseBodyDpiSignature()
                self.dpi_signature.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListDpiSignaturesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListDpiSignaturesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListDpiSignaturesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListEnterpriseCodeRequest(TeaModel):
    def __init__(
        self,
        enterprise_code: str = None,
        is_default: bool = None,
        max_results: int = None,
        next_token: str = None,
        region_id: str = None,
    ):
        self.enterprise_code = enterprise_code
        self.is_default = is_default
        self.max_results = max_results
        self.next_token = next_token
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enterprise_code is not None:
            result['EnterpriseCode'] = self.enterprise_code
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnterpriseCode') is not None:
            self.enterprise_code = m.get('EnterpriseCode')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class ListEnterpriseCodeResponseBodyEnterpriseCodes(TeaModel):
    def __init__(
        self,
        enterprise_code: str = None,
        is_default: bool = None,
    ):
        self.enterprise_code = enterprise_code
        self.is_default = is_default

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enterprise_code is not None:
            result['EnterpriseCode'] = self.enterprise_code
        if self.is_default is not None:
            result['IsDefault'] = self.is_default
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnterpriseCode') is not None:
            self.enterprise_code = m.get('EnterpriseCode')
        if m.get('IsDefault') is not None:
            self.is_default = m.get('IsDefault')
        return self


class ListEnterpriseCodeResponseBody(TeaModel):
    def __init__(
        self,
        enterprise_codes: List[ListEnterpriseCodeResponseBodyEnterpriseCodes] = None,
        max_results: int = None,
        next_token: str = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.enterprise_codes = enterprise_codes
        self.max_results = max_results
        self.next_token = next_token
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.enterprise_codes:
            for k in self.enterprise_codes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EnterpriseCodes'] = []
        if self.enterprise_codes is not None:
            for k in self.enterprise_codes:
                result['EnterpriseCodes'].append(k.to_map() if k else None)
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.enterprise_codes = []
        if m.get('EnterpriseCodes') is not None:
            for k in m.get('EnterpriseCodes'):
                temp_model = ListEnterpriseCodeResponseBodyEnterpriseCodes()
                self.enterprise_codes.append(temp_model.from_map(k))
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListEnterpriseCodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListEnterpriseCodeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListEnterpriseCodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListSmartAGApiUnsupportedFeatureRequest(TeaModel):
    def __init__(
        self,
        open_api_name: str = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        serial_number: str = None,
        smart_agid: str = None,
    ):
        self.open_api_name = open_api_name
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.serial_number = serial_number
        self.smart_agid = smart_agid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.open_api_name is not None:
            result['OpenApiName'] = self.open_api_name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.serial_number is not None:
            result['SerialNumber'] = self.serial_number
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OpenApiName') is not None:
            self.open_api_name = m.get('OpenApiName')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SerialNumber') is not None:
            self.serial_number = m.get('SerialNumber')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        return self


class ListSmartAGApiUnsupportedFeatureResponseBodyFeatures(TeaModel):
    def __init__(
        self,
        feature: str = None,
    ):
        self.feature = feature

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.feature is not None:
            result['Feature'] = self.feature
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Feature') is not None:
            self.feature = m.get('Feature')
        return self


class ListSmartAGApiUnsupportedFeatureResponseBody(TeaModel):
    def __init__(
        self,
        features: List[ListSmartAGApiUnsupportedFeatureResponseBodyFeatures] = None,
        request_id: str = None,
    ):
        self.features = features
        self.request_id = request_id

    def validate(self):
        if self.features:
            for k in self.features:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Features'] = []
        if self.features is not None:
            for k in self.features:
                result['Features'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.features = []
        if m.get('Features') is not None:
            for k in m.get('Features'):
                temp_model = ListSmartAGApiUnsupportedFeatureResponseBodyFeatures()
                self.features.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListSmartAGApiUnsupportedFeatureResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListSmartAGApiUnsupportedFeatureResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListSmartAGApiUnsupportedFeatureResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListSmartAGByAccessPointRequest(TeaModel):
    def __init__(
        self,
        access_point_id: int = None,
        owner_account: str = None,
        owner_id: int = None,
        page_number: int = None,
        page_size: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agstatus: str = None,
    ):
        self.access_point_id = access_point_id
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.page_number = page_number
        self.page_size = page_size
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agstatus = smart_agstatus

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_point_id is not None:
            result['AccessPointId'] = self.access_point_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agstatus is not None:
            result['SmartAGStatus'] = self.smart_agstatus
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessPointId') is not None:
            self.access_point_id = m.get('AccessPointId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGStatus') is not None:
            self.smart_agstatus = m.get('SmartAGStatus')
        return self


class ListSmartAGByAccessPointResponseBodySmartAccessGateways(TeaModel):
    def __init__(
        self,
        associated_ccn_id: str = None,
        hardware_version: str = None,
        routing_strategy: str = None,
        smart_agdescription: str = None,
        smart_agid: str = None,
        smart_agname: str = None,
        smart_agstatus: str = None,
    ):
        self.associated_ccn_id = associated_ccn_id
        self.hardware_version = hardware_version
        self.routing_strategy = routing_strategy
        self.smart_agdescription = smart_agdescription
        self.smart_agid = smart_agid
        self.smart_agname = smart_agname
        self.smart_agstatus = smart_agstatus

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.associated_ccn_id is not None:
            result['AssociatedCcnId'] = self.associated_ccn_id
        if self.hardware_version is not None:
            result['HardwareVersion'] = self.hardware_version
        if self.routing_strategy is not None:
            result['RoutingStrategy'] = self.routing_strategy
        if self.smart_agdescription is not None:
            result['SmartAGDescription'] = self.smart_agdescription
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_agname is not None:
            result['SmartAGName'] = self.smart_agname
        if self.smart_agstatus is not None:
            result['SmartAGStatus'] = self.smart_agstatus
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AssociatedCcnId') is not None:
            self.associated_ccn_id = m.get('AssociatedCcnId')
        if m.get('HardwareVersion') is not None:
            self.hardware_version = m.get('HardwareVersion')
        if m.get('RoutingStrategy') is not None:
            self.routing_strategy = m.get('RoutingStrategy')
        if m.get('SmartAGDescription') is not None:
            self.smart_agdescription = m.get('SmartAGDescription')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGName') is not None:
            self.smart_agname = m.get('SmartAGName')
        if m.get('SmartAGStatus') is not None:
            self.smart_agstatus = m.get('SmartAGStatus')
        return self


class ListSmartAGByAccessPointResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        smart_access_gateways: List[ListSmartAGByAccessPointResponseBodySmartAccessGateways] = None,
        total_count: int = None,
    ):
        self.request_id = request_id
        self.smart_access_gateways = smart_access_gateways
        self.total_count = total_count

    def validate(self):
        if self.smart_access_gateways:
            for k in self.smart_access_gateways:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['SmartAccessGateways'] = []
        if self.smart_access_gateways is not None:
            for k in self.smart_access_gateways:
                result['SmartAccessGateways'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.smart_access_gateways = []
        if m.get('SmartAccessGateways') is not None:
            for k in m.get('SmartAccessGateways'):
                temp_model = ListSmartAGByAccessPointResponseBodySmartAccessGateways()
                self.smart_access_gateways.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListSmartAGByAccessPointResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ListSmartAGByAccessPointResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ListSmartAGByAccessPointResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyACLRequest(TeaModel):
    def __init__(
        self,
        acl_id: str = None,
        name: str = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.acl_id = acl_id
        self.name = name
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_id is not None:
            result['AclId'] = self.acl_id
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclId') is not None:
            self.acl_id = m.get('AclId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class ModifyACLResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyACLResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifyACLResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyACLResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyACLRuleRequest(TeaModel):
    def __init__(
        self,
        acl_id: str = None,
        acr_id: str = None,
        description: str = None,
        dest_cidr: str = None,
        dest_port_range: str = None,
        direction: str = None,
        dpi_group_ids: List[str] = None,
        dpi_signature_ids: List[str] = None,
        ip_protocol: str = None,
        name: str = None,
        owner_account: str = None,
        owner_id: int = None,
        policy: str = None,
        priority: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        source_cidr: str = None,
        source_port_range: str = None,
        type: str = None,
    ):
        self.acl_id = acl_id
        self.acr_id = acr_id
        self.description = description
        self.dest_cidr = dest_cidr
        self.dest_port_range = dest_port_range
        self.direction = direction
        self.dpi_group_ids = dpi_group_ids
        self.dpi_signature_ids = dpi_signature_ids
        self.ip_protocol = ip_protocol
        self.name = name
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.policy = policy
        self.priority = priority
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.source_cidr = source_cidr
        self.source_port_range = source_port_range
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_id is not None:
            result['AclId'] = self.acl_id
        if self.acr_id is not None:
            result['AcrId'] = self.acr_id
        if self.description is not None:
            result['Description'] = self.description
        if self.dest_cidr is not None:
            result['DestCidr'] = self.dest_cidr
        if self.dest_port_range is not None:
            result['DestPortRange'] = self.dest_port_range
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.dpi_group_ids is not None:
            result['DpiGroupIds'] = self.dpi_group_ids
        if self.dpi_signature_ids is not None:
            result['DpiSignatureIds'] = self.dpi_signature_ids
        if self.ip_protocol is not None:
            result['IpProtocol'] = self.ip_protocol
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_cidr is not None:
            result['SourceCidr'] = self.source_cidr
        if self.source_port_range is not None:
            result['SourcePortRange'] = self.source_port_range
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclId') is not None:
            self.acl_id = m.get('AclId')
        if m.get('AcrId') is not None:
            self.acr_id = m.get('AcrId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DestCidr') is not None:
            self.dest_cidr = m.get('DestCidr')
        if m.get('DestPortRange') is not None:
            self.dest_port_range = m.get('DestPortRange')
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('DpiGroupIds') is not None:
            self.dpi_group_ids = m.get('DpiGroupIds')
        if m.get('DpiSignatureIds') is not None:
            self.dpi_signature_ids = m.get('DpiSignatureIds')
        if m.get('IpProtocol') is not None:
            self.ip_protocol = m.get('IpProtocol')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceCidr') is not None:
            self.source_cidr = m.get('SourceCidr')
        if m.get('SourcePortRange') is not None:
            self.source_port_range = m.get('SourcePortRange')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ModifyACLRuleResponseBodyDpiGroupIds(TeaModel):
    def __init__(
        self,
        dpi_group_id: List[str] = None,
    ):
        self.dpi_group_id = dpi_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dpi_group_id is not None:
            result['DpiGroupId'] = self.dpi_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DpiGroupId') is not None:
            self.dpi_group_id = m.get('DpiGroupId')
        return self


class ModifyACLRuleResponseBodyDpiSignatureIds(TeaModel):
    def __init__(
        self,
        dpi_signature_id: List[str] = None,
    ):
        self.dpi_signature_id = dpi_signature_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dpi_signature_id is not None:
            result['DpiSignatureId'] = self.dpi_signature_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DpiSignatureId') is not None:
            self.dpi_signature_id = m.get('DpiSignatureId')
        return self


class ModifyACLRuleResponseBody(TeaModel):
    def __init__(
        self,
        acl_id: str = None,
        acr_id: str = None,
        description: str = None,
        dest_cidr: str = None,
        dest_port_range: str = None,
        direction: str = None,
        dpi_group_ids: ModifyACLRuleResponseBodyDpiGroupIds = None,
        dpi_signature_ids: ModifyACLRuleResponseBodyDpiSignatureIds = None,
        gmt_create: int = None,
        ip_protocol: str = None,
        name: str = None,
        policy: str = None,
        priority: int = None,
        request_id: str = None,
        source_cidr: str = None,
        source_port_range: str = None,
    ):
        self.acl_id = acl_id
        self.acr_id = acr_id
        self.description = description
        self.dest_cidr = dest_cidr
        self.dest_port_range = dest_port_range
        self.direction = direction
        self.dpi_group_ids = dpi_group_ids
        self.dpi_signature_ids = dpi_signature_ids
        self.gmt_create = gmt_create
        self.ip_protocol = ip_protocol
        self.name = name
        self.policy = policy
        self.priority = priority
        self.request_id = request_id
        self.source_cidr = source_cidr
        self.source_port_range = source_port_range

    def validate(self):
        if self.dpi_group_ids:
            self.dpi_group_ids.validate()
        if self.dpi_signature_ids:
            self.dpi_signature_ids.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_id is not None:
            result['AclId'] = self.acl_id
        if self.acr_id is not None:
            result['AcrId'] = self.acr_id
        if self.description is not None:
            result['Description'] = self.description
        if self.dest_cidr is not None:
            result['DestCidr'] = self.dest_cidr
        if self.dest_port_range is not None:
            result['DestPortRange'] = self.dest_port_range
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.dpi_group_ids is not None:
            result['DpiGroupIds'] = self.dpi_group_ids.to_map()
        if self.dpi_signature_ids is not None:
            result['DpiSignatureIds'] = self.dpi_signature_ids.to_map()
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.ip_protocol is not None:
            result['IpProtocol'] = self.ip_protocol
        if self.name is not None:
            result['Name'] = self.name
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.source_cidr is not None:
            result['SourceCidr'] = self.source_cidr
        if self.source_port_range is not None:
            result['SourcePortRange'] = self.source_port_range
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclId') is not None:
            self.acl_id = m.get('AclId')
        if m.get('AcrId') is not None:
            self.acr_id = m.get('AcrId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DestCidr') is not None:
            self.dest_cidr = m.get('DestCidr')
        if m.get('DestPortRange') is not None:
            self.dest_port_range = m.get('DestPortRange')
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('DpiGroupIds') is not None:
            temp_model = ModifyACLRuleResponseBodyDpiGroupIds()
            self.dpi_group_ids = temp_model.from_map(m['DpiGroupIds'])
        if m.get('DpiSignatureIds') is not None:
            temp_model = ModifyACLRuleResponseBodyDpiSignatureIds()
            self.dpi_signature_ids = temp_model.from_map(m['DpiSignatureIds'])
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('IpProtocol') is not None:
            self.ip_protocol = m.get('IpProtocol')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SourceCidr') is not None:
            self.source_cidr = m.get('SourceCidr')
        if m.get('SourcePortRange') is not None:
            self.source_port_range = m.get('SourcePortRange')
        return self


class ModifyACLRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifyACLRuleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyACLRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyClientUserDNSRequest(TeaModel):
    def __init__(
        self,
        app_dns: List[str] = None,
        owner_account: str = None,
        owner_id: int = None,
        recovered_dns: List[str] = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
    ):
        self.app_dns = app_dns
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.recovered_dns = recovered_dns
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_dns is not None:
            result['AppDNS'] = self.app_dns
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.recovered_dns is not None:
            result['RecoveredDNS'] = self.recovered_dns
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppDNS') is not None:
            self.app_dns = m.get('AppDNS')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RecoveredDNS') is not None:
            self.recovered_dns = m.get('RecoveredDNS')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        return self


class ModifyClientUserDNSResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyClientUserDNSResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifyClientUserDNSResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyClientUserDNSResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyCloudConnectNetworkRequest(TeaModel):
    def __init__(
        self,
        ccn_id: str = None,
        cidr_block: str = None,
        description: str = None,
        interworking_status: str = None,
        name: str = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.ccn_id = ccn_id
        self.cidr_block = cidr_block
        self.description = description
        self.interworking_status = interworking_status
        self.name = name
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ccn_id is not None:
            result['CcnId'] = self.ccn_id
        if self.cidr_block is not None:
            result['CidrBlock'] = self.cidr_block
        if self.description is not None:
            result['Description'] = self.description
        if self.interworking_status is not None:
            result['InterworkingStatus'] = self.interworking_status
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CcnId') is not None:
            self.ccn_id = m.get('CcnId')
        if m.get('CidrBlock') is not None:
            self.cidr_block = m.get('CidrBlock')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InterworkingStatus') is not None:
            self.interworking_status = m.get('InterworkingStatus')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class ModifyCloudConnectNetworkResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyCloudConnectNetworkResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifyCloudConnectNetworkResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyCloudConnectNetworkResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyDeviceAutoUpgradePolicyRequest(TeaModel):
    def __init__(
        self,
        cron_expression: str = None,
        duration: int = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        serial_number: str = None,
        smart_agid: str = None,
        time_zone: str = None,
        upgrade_type: str = None,
        version_type: str = None,
    ):
        self.cron_expression = cron_expression
        self.duration = duration
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.serial_number = serial_number
        self.smart_agid = smart_agid
        self.time_zone = time_zone
        self.upgrade_type = upgrade_type
        self.version_type = version_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cron_expression is not None:
            result['CronExpression'] = self.cron_expression
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.serial_number is not None:
            result['SerialNumber'] = self.serial_number
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.time_zone is not None:
            result['TimeZone'] = self.time_zone
        if self.upgrade_type is not None:
            result['UpgradeType'] = self.upgrade_type
        if self.version_type is not None:
            result['VersionType'] = self.version_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CronExpression') is not None:
            self.cron_expression = m.get('CronExpression')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SerialNumber') is not None:
            self.serial_number = m.get('SerialNumber')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('TimeZone') is not None:
            self.time_zone = m.get('TimeZone')
        if m.get('UpgradeType') is not None:
            self.upgrade_type = m.get('UpgradeType')
        if m.get('VersionType') is not None:
            self.version_type = m.get('VersionType')
        return self


class ModifyDeviceAutoUpgradePolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyDeviceAutoUpgradePolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifyDeviceAutoUpgradePolicyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyDeviceAutoUpgradePolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyFlowLogAttributeRequest(TeaModel):
    def __init__(
        self,
        active_aging: int = None,
        description: str = None,
        flow_log_id: str = None,
        inactive_aging: int = None,
        logstore_name: str = None,
        name: str = None,
        netflow_server_ip: str = None,
        netflow_server_port: int = None,
        netflow_version: str = None,
        output_type: str = None,
        owner_account: str = None,
        owner_id: int = None,
        project_name: str = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        sls_region_id: str = None,
    ):
        self.active_aging = active_aging
        self.description = description
        self.flow_log_id = flow_log_id
        self.inactive_aging = inactive_aging
        self.logstore_name = logstore_name
        self.name = name
        self.netflow_server_ip = netflow_server_ip
        self.netflow_server_port = netflow_server_port
        self.netflow_version = netflow_version
        self.output_type = output_type
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.project_name = project_name
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.sls_region_id = sls_region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active_aging is not None:
            result['ActiveAging'] = self.active_aging
        if self.description is not None:
            result['Description'] = self.description
        if self.flow_log_id is not None:
            result['FlowLogId'] = self.flow_log_id
        if self.inactive_aging is not None:
            result['InactiveAging'] = self.inactive_aging
        if self.logstore_name is not None:
            result['LogstoreName'] = self.logstore_name
        if self.name is not None:
            result['Name'] = self.name
        if self.netflow_server_ip is not None:
            result['NetflowServerIp'] = self.netflow_server_ip
        if self.netflow_server_port is not None:
            result['NetflowServerPort'] = self.netflow_server_port
        if self.netflow_version is not None:
            result['NetflowVersion'] = self.netflow_version
        if self.output_type is not None:
            result['OutputType'] = self.output_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.sls_region_id is not None:
            result['SlsRegionId'] = self.sls_region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ActiveAging') is not None:
            self.active_aging = m.get('ActiveAging')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('FlowLogId') is not None:
            self.flow_log_id = m.get('FlowLogId')
        if m.get('InactiveAging') is not None:
            self.inactive_aging = m.get('InactiveAging')
        if m.get('LogstoreName') is not None:
            self.logstore_name = m.get('LogstoreName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NetflowServerIp') is not None:
            self.netflow_server_ip = m.get('NetflowServerIp')
        if m.get('NetflowServerPort') is not None:
            self.netflow_server_port = m.get('NetflowServerPort')
        if m.get('NetflowVersion') is not None:
            self.netflow_version = m.get('NetflowVersion')
        if m.get('OutputType') is not None:
            self.output_type = m.get('OutputType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SlsRegionId') is not None:
            self.sls_region_id = m.get('SlsRegionId')
        return self


class ModifyFlowLogAttributeResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyFlowLogAttributeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifyFlowLogAttributeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyFlowLogAttributeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyHealthCheckRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        dst_ip_addr: str = None,
        dst_port: int = None,
        fail_count_threshold: int = None,
        hc_instance_id: str = None,
        name: str = None,
        owner_account: str = None,
        owner_id: int = None,
        probe_count: int = None,
        probe_interval: int = None,
        probe_timeout: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        rtt_fail_threshold: int = None,
        rtt_threshold: int = None,
        smart_agid: str = None,
        src_ip_addr: str = None,
        src_port: int = None,
        type: str = None,
    ):
        self.description = description
        self.dst_ip_addr = dst_ip_addr
        self.dst_port = dst_port
        self.fail_count_threshold = fail_count_threshold
        self.hc_instance_id = hc_instance_id
        self.name = name
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.probe_count = probe_count
        self.probe_interval = probe_interval
        self.probe_timeout = probe_timeout
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.rtt_fail_threshold = rtt_fail_threshold
        self.rtt_threshold = rtt_threshold
        self.smart_agid = smart_agid
        self.src_ip_addr = src_ip_addr
        self.src_port = src_port
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.dst_ip_addr is not None:
            result['DstIpAddr'] = self.dst_ip_addr
        if self.dst_port is not None:
            result['DstPort'] = self.dst_port
        if self.fail_count_threshold is not None:
            result['FailCountThreshold'] = self.fail_count_threshold
        if self.hc_instance_id is not None:
            result['HcInstanceId'] = self.hc_instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.probe_count is not None:
            result['ProbeCount'] = self.probe_count
        if self.probe_interval is not None:
            result['ProbeInterval'] = self.probe_interval
        if self.probe_timeout is not None:
            result['ProbeTimeout'] = self.probe_timeout
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.rtt_fail_threshold is not None:
            result['RttFailThreshold'] = self.rtt_fail_threshold
        if self.rtt_threshold is not None:
            result['RttThreshold'] = self.rtt_threshold
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.src_ip_addr is not None:
            result['SrcIpAddr'] = self.src_ip_addr
        if self.src_port is not None:
            result['SrcPort'] = self.src_port
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DstIpAddr') is not None:
            self.dst_ip_addr = m.get('DstIpAddr')
        if m.get('DstPort') is not None:
            self.dst_port = m.get('DstPort')
        if m.get('FailCountThreshold') is not None:
            self.fail_count_threshold = m.get('FailCountThreshold')
        if m.get('HcInstanceId') is not None:
            self.hc_instance_id = m.get('HcInstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ProbeCount') is not None:
            self.probe_count = m.get('ProbeCount')
        if m.get('ProbeInterval') is not None:
            self.probe_interval = m.get('ProbeInterval')
        if m.get('ProbeTimeout') is not None:
            self.probe_timeout = m.get('ProbeTimeout')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RttFailThreshold') is not None:
            self.rtt_fail_threshold = m.get('RttFailThreshold')
        if m.get('RttThreshold') is not None:
            self.rtt_threshold = m.get('RttThreshold')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SrcIpAddr') is not None:
            self.src_ip_addr = m.get('SrcIpAddr')
        if m.get('SrcPort') is not None:
            self.src_port = m.get('SrcPort')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ModifyHealthCheckResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyHealthCheckResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifyHealthCheckResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyHealthCheckResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyQosRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        qos_description: str = None,
        qos_id: str = None,
        qos_name: str = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.qos_description = qos_description
        self.qos_id = qos_id
        self.qos_name = qos_name
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.qos_description is not None:
            result['QosDescription'] = self.qos_description
        if self.qos_id is not None:
            result['QosId'] = self.qos_id
        if self.qos_name is not None:
            result['QosName'] = self.qos_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('QosDescription') is not None:
            self.qos_description = m.get('QosDescription')
        if m.get('QosId') is not None:
            self.qos_id = m.get('QosId')
        if m.get('QosName') is not None:
            self.qos_name = m.get('QosName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class ModifyQosResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyQosResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifyQosResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyQosResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyQosCarRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        limit_type: str = None,
        max_bandwidth_abs: int = None,
        max_bandwidth_percent: int = None,
        min_bandwidth_abs: int = None,
        min_bandwidth_percent: int = None,
        name: str = None,
        owner_account: str = None,
        owner_id: int = None,
        percent_source_type: str = None,
        priority: int = None,
        qos_car_id: str = None,
        qos_id: str = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
    ):
        self.description = description
        self.limit_type = limit_type
        self.max_bandwidth_abs = max_bandwidth_abs
        self.max_bandwidth_percent = max_bandwidth_percent
        self.min_bandwidth_abs = min_bandwidth_abs
        self.min_bandwidth_percent = min_bandwidth_percent
        self.name = name
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.percent_source_type = percent_source_type
        self.priority = priority
        self.qos_car_id = qos_car_id
        self.qos_id = qos_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.limit_type is not None:
            result['LimitType'] = self.limit_type
        if self.max_bandwidth_abs is not None:
            result['MaxBandwidthAbs'] = self.max_bandwidth_abs
        if self.max_bandwidth_percent is not None:
            result['MaxBandwidthPercent'] = self.max_bandwidth_percent
        if self.min_bandwidth_abs is not None:
            result['MinBandwidthAbs'] = self.min_bandwidth_abs
        if self.min_bandwidth_percent is not None:
            result['MinBandwidthPercent'] = self.min_bandwidth_percent
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.percent_source_type is not None:
            result['PercentSourceType'] = self.percent_source_type
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.qos_car_id is not None:
            result['QosCarId'] = self.qos_car_id
        if self.qos_id is not None:
            result['QosId'] = self.qos_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('LimitType') is not None:
            self.limit_type = m.get('LimitType')
        if m.get('MaxBandwidthAbs') is not None:
            self.max_bandwidth_abs = m.get('MaxBandwidthAbs')
        if m.get('MaxBandwidthPercent') is not None:
            self.max_bandwidth_percent = m.get('MaxBandwidthPercent')
        if m.get('MinBandwidthAbs') is not None:
            self.min_bandwidth_abs = m.get('MinBandwidthAbs')
        if m.get('MinBandwidthPercent') is not None:
            self.min_bandwidth_percent = m.get('MinBandwidthPercent')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PercentSourceType') is not None:
            self.percent_source_type = m.get('PercentSourceType')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('QosCarId') is not None:
            self.qos_car_id = m.get('QosCarId')
        if m.get('QosId') is not None:
            self.qos_id = m.get('QosId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class ModifyQosCarResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyQosCarResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifyQosCarResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyQosCarResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyQosPolicyRequest(TeaModel):
    def __init__(
        self,
        description: str = None,
        dest_cidr: str = None,
        dest_port_range: str = None,
        dpi_group_ids: List[str] = None,
        dpi_signature_ids: List[str] = None,
        end_time: str = None,
        ip_protocol: str = None,
        name: str = None,
        owner_account: str = None,
        owner_id: int = None,
        priority: int = None,
        qos_id: str = None,
        qos_policy_id: str = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        source_cidr: str = None,
        source_port_range: str = None,
        start_time: str = None,
    ):
        self.description = description
        self.dest_cidr = dest_cidr
        self.dest_port_range = dest_port_range
        self.dpi_group_ids = dpi_group_ids
        self.dpi_signature_ids = dpi_signature_ids
        self.end_time = end_time
        self.ip_protocol = ip_protocol
        self.name = name
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.priority = priority
        self.qos_id = qos_id
        self.qos_policy_id = qos_policy_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.source_cidr = source_cidr
        self.source_port_range = source_port_range
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.dest_cidr is not None:
            result['DestCidr'] = self.dest_cidr
        if self.dest_port_range is not None:
            result['DestPortRange'] = self.dest_port_range
        if self.dpi_group_ids is not None:
            result['DpiGroupIds'] = self.dpi_group_ids
        if self.dpi_signature_ids is not None:
            result['DpiSignatureIds'] = self.dpi_signature_ids
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.ip_protocol is not None:
            result['IpProtocol'] = self.ip_protocol
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.qos_id is not None:
            result['QosId'] = self.qos_id
        if self.qos_policy_id is not None:
            result['QosPolicyId'] = self.qos_policy_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_cidr is not None:
            result['SourceCidr'] = self.source_cidr
        if self.source_port_range is not None:
            result['SourcePortRange'] = self.source_port_range
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DestCidr') is not None:
            self.dest_cidr = m.get('DestCidr')
        if m.get('DestPortRange') is not None:
            self.dest_port_range = m.get('DestPortRange')
        if m.get('DpiGroupIds') is not None:
            self.dpi_group_ids = m.get('DpiGroupIds')
        if m.get('DpiSignatureIds') is not None:
            self.dpi_signature_ids = m.get('DpiSignatureIds')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('IpProtocol') is not None:
            self.ip_protocol = m.get('IpProtocol')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('QosId') is not None:
            self.qos_id = m.get('QosId')
        if m.get('QosPolicyId') is not None:
            self.qos_policy_id = m.get('QosPolicyId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceCidr') is not None:
            self.source_cidr = m.get('SourceCidr')
        if m.get('SourcePortRange') is not None:
            self.source_port_range = m.get('SourcePortRange')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class ModifyQosPolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyQosPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifyQosPolicyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyQosPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyRouteDistributionStrategyRequest(TeaModel):
    def __init__(
        self,
        dest_cidr_block: str = None,
        hc_instance_id: str = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        route_distribution: str = None,
        route_source: str = None,
        smart_agid: str = None,
        source_type: str = None,
    ):
        self.dest_cidr_block = dest_cidr_block
        self.hc_instance_id = hc_instance_id
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.route_distribution = route_distribution
        self.route_source = route_source
        self.smart_agid = smart_agid
        self.source_type = source_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dest_cidr_block is not None:
            result['DestCidrBlock'] = self.dest_cidr_block
        if self.hc_instance_id is not None:
            result['HcInstanceId'] = self.hc_instance_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.route_distribution is not None:
            result['RouteDistribution'] = self.route_distribution
        if self.route_source is not None:
            result['RouteSource'] = self.route_source
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DestCidrBlock') is not None:
            self.dest_cidr_block = m.get('DestCidrBlock')
        if m.get('HcInstanceId') is not None:
            self.hc_instance_id = m.get('HcInstanceId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RouteDistribution') is not None:
            self.route_distribution = m.get('RouteDistribution')
        if m.get('RouteSource') is not None:
            self.route_source = m.get('RouteSource')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        return self


class ModifyRouteDistributionStrategyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyRouteDistributionStrategyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifyRouteDistributionStrategyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyRouteDistributionStrategyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifySAGAdminPasswordRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        password: str = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        smart_agsn: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.password = password
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.smart_agsn = smart_agsn

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.password is not None:
            result['Password'] = self.password
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_agsn is not None:
            result['SmartAGSn'] = self.smart_agsn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGSn') is not None:
            self.smart_agsn = m.get('SmartAGSn')
        return self


class ModifySAGAdminPasswordResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifySAGAdminPasswordResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifySAGAdminPasswordResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifySAGAdminPasswordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifySagExpressConnectInterfaceRequest(TeaModel):
    def __init__(
        self,
        ip: str = None,
        mask: str = None,
        owner_account: str = None,
        owner_id: int = None,
        port_name: str = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        smart_agsn: str = None,
        vlan: str = None,
    ):
        self.ip = ip
        self.mask = mask
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.port_name = port_name
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.smart_agsn = smart_agsn
        self.vlan = vlan

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip is not None:
            result['IP'] = self.ip
        if self.mask is not None:
            result['Mask'] = self.mask
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.port_name is not None:
            result['PortName'] = self.port_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_agsn is not None:
            result['SmartAGSn'] = self.smart_agsn
        if self.vlan is not None:
            result['Vlan'] = self.vlan
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IP') is not None:
            self.ip = m.get('IP')
        if m.get('Mask') is not None:
            self.mask = m.get('Mask')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PortName') is not None:
            self.port_name = m.get('PortName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGSn') is not None:
            self.smart_agsn = m.get('SmartAGSn')
        if m.get('Vlan') is not None:
            self.vlan = m.get('Vlan')
        return self


class ModifySagExpressConnectInterfaceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifySagExpressConnectInterfaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifySagExpressConnectInterfaceResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifySagExpressConnectInterfaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifySagGlobalRouteProtocolRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        route_protocol: str = None,
        smart_agid: str = None,
        smart_agsn: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.route_protocol = route_protocol
        self.smart_agid = smart_agid
        self.smart_agsn = smart_agsn

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.route_protocol is not None:
            result['RouteProtocol'] = self.route_protocol
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_agsn is not None:
            result['SmartAGSn'] = self.smart_agsn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RouteProtocol') is not None:
            self.route_protocol = m.get('RouteProtocol')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGSn') is not None:
            self.smart_agsn = m.get('SmartAGSn')
        return self


class ModifySagGlobalRouteProtocolResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifySagGlobalRouteProtocolResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifySagGlobalRouteProtocolResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifySagGlobalRouteProtocolResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifySagHaRequest(TeaModel):
    def __init__(
        self,
        mode: str = None,
        owner_account: str = None,
        owner_id: int = None,
        port_name: str = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        smart_agsn: str = None,
        virtual_ip: str = None,
    ):
        self.mode = mode
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.port_name = port_name
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.smart_agsn = smart_agsn
        self.virtual_ip = virtual_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.port_name is not None:
            result['PortName'] = self.port_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_agsn is not None:
            result['SmartAGSn'] = self.smart_agsn
        if self.virtual_ip is not None:
            result['VirtualIp'] = self.virtual_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PortName') is not None:
            self.port_name = m.get('PortName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGSn') is not None:
            self.smart_agsn = m.get('SmartAGSn')
        if m.get('VirtualIp') is not None:
            self.virtual_ip = m.get('VirtualIp')
        return self


class ModifySagHaResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifySagHaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifySagHaResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifySagHaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifySagLanRequest(TeaModel):
    def __init__(
        self,
        end_ip: str = None,
        ip: str = None,
        iptype: str = None,
        lease: str = None,
        mask: str = None,
        owner_account: str = None,
        owner_id: int = None,
        port_name: str = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        smart_agsn: str = None,
        start_ip: str = None,
    ):
        self.end_ip = end_ip
        self.ip = ip
        self.iptype = iptype
        self.lease = lease
        self.mask = mask
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.port_name = port_name
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.smart_agsn = smart_agsn
        self.start_ip = start_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_ip is not None:
            result['EndIp'] = self.end_ip
        if self.ip is not None:
            result['IP'] = self.ip
        if self.iptype is not None:
            result['IPType'] = self.iptype
        if self.lease is not None:
            result['Lease'] = self.lease
        if self.mask is not None:
            result['Mask'] = self.mask
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.port_name is not None:
            result['PortName'] = self.port_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_agsn is not None:
            result['SmartAGSn'] = self.smart_agsn
        if self.start_ip is not None:
            result['StartIp'] = self.start_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndIp') is not None:
            self.end_ip = m.get('EndIp')
        if m.get('IP') is not None:
            self.ip = m.get('IP')
        if m.get('IPType') is not None:
            self.iptype = m.get('IPType')
        if m.get('Lease') is not None:
            self.lease = m.get('Lease')
        if m.get('Mask') is not None:
            self.mask = m.get('Mask')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PortName') is not None:
            self.port_name = m.get('PortName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGSn') is not None:
            self.smart_agsn = m.get('SmartAGSn')
        if m.get('StartIp') is not None:
            self.start_ip = m.get('StartIp')
        return self


class ModifySagLanResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifySagLanResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifySagLanResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifySagLanResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifySagManagementPortRequest(TeaModel):
    def __init__(
        self,
        gateway: str = None,
        ip: str = None,
        mask: str = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        smart_agsn: str = None,
    ):
        self.gateway = gateway
        self.ip = ip
        self.mask = mask
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.smart_agsn = smart_agsn

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gateway is not None:
            result['Gateway'] = self.gateway
        if self.ip is not None:
            result['IP'] = self.ip
        if self.mask is not None:
            result['Mask'] = self.mask
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_agsn is not None:
            result['SmartAGSn'] = self.smart_agsn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Gateway') is not None:
            self.gateway = m.get('Gateway')
        if m.get('IP') is not None:
            self.ip = m.get('IP')
        if m.get('Mask') is not None:
            self.mask = m.get('Mask')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGSn') is not None:
            self.smart_agsn = m.get('SmartAGSn')
        return self


class ModifySagManagementPortResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifySagManagementPortResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifySagManagementPortResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifySagManagementPortResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifySagPortRoleRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        port_name: str = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        role: str = None,
        smart_agid: str = None,
        smart_agsn: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.port_name = port_name
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.role = role
        self.smart_agid = smart_agid
        self.smart_agsn = smart_agsn

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.port_name is not None:
            result['PortName'] = self.port_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.role is not None:
            result['Role'] = self.role
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_agsn is not None:
            result['SmartAGSn'] = self.smart_agsn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PortName') is not None:
            self.port_name = m.get('PortName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGSn') is not None:
            self.smart_agsn = m.get('SmartAGSn')
        return self


class ModifySagPortRoleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifySagPortRoleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifySagPortRoleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifySagPortRoleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifySagPortRouteProtocolRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        port_name: str = None,
        region_id: str = None,
        remote_as: str = None,
        remote_ip: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        route_protocol: str = None,
        smart_agid: str = None,
        smart_agsn: str = None,
        vlan: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.port_name = port_name
        self.region_id = region_id
        self.remote_as = remote_as
        self.remote_ip = remote_ip
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.route_protocol = route_protocol
        self.smart_agid = smart_agid
        self.smart_agsn = smart_agsn
        self.vlan = vlan

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.port_name is not None:
            result['PortName'] = self.port_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.remote_as is not None:
            result['RemoteAs'] = self.remote_as
        if self.remote_ip is not None:
            result['RemoteIp'] = self.remote_ip
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.route_protocol is not None:
            result['RouteProtocol'] = self.route_protocol
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_agsn is not None:
            result['SmartAGSn'] = self.smart_agsn
        if self.vlan is not None:
            result['Vlan'] = self.vlan
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PortName') is not None:
            self.port_name = m.get('PortName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RemoteAs') is not None:
            self.remote_as = m.get('RemoteAs')
        if m.get('RemoteIp') is not None:
            self.remote_ip = m.get('RemoteIp')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RouteProtocol') is not None:
            self.route_protocol = m.get('RouteProtocol')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGSn') is not None:
            self.smart_agsn = m.get('SmartAGSn')
        if m.get('Vlan') is not None:
            self.vlan = m.get('Vlan')
        return self


class ModifySagPortRouteProtocolResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifySagPortRouteProtocolResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifySagPortRouteProtocolResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifySagPortRouteProtocolResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifySagRemoteAccessRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        remote_access_ip: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        serial_number: str = None,
        smart_agid: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.remote_access_ip = remote_access_ip
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.serial_number = serial_number
        self.smart_agid = smart_agid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.remote_access_ip is not None:
            result['RemoteAccessIp'] = self.remote_access_ip
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.serial_number is not None:
            result['SerialNumber'] = self.serial_number
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RemoteAccessIp') is not None:
            self.remote_access_ip = m.get('RemoteAccessIp')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SerialNumber') is not None:
            self.serial_number = m.get('SerialNumber')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        return self


class ModifySagRemoteAccessResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        remote_access_ip: str = None,
        request_id: str = None,
        serial_number: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.remote_access_ip = remote_access_ip
        self.request_id = request_id
        self.serial_number = serial_number
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.remote_access_ip is not None:
            result['RemoteAccessIp'] = self.remote_access_ip
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.serial_number is not None:
            result['SerialNumber'] = self.serial_number
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RemoteAccessIp') is not None:
            self.remote_access_ip = m.get('RemoteAccessIp')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SerialNumber') is not None:
            self.serial_number = m.get('SerialNumber')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ModifySagRemoteAccessResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifySagRemoteAccessResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifySagRemoteAccessResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifySagRouteProtocolBgpRequest(TeaModel):
    def __init__(
        self,
        hold_time: int = None,
        keep_alive: int = None,
        local_as: int = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        router_id: str = None,
        smart_agid: str = None,
        smart_agsn: str = None,
    ):
        self.hold_time = hold_time
        self.keep_alive = keep_alive
        self.local_as = local_as
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.router_id = router_id
        self.smart_agid = smart_agid
        self.smart_agsn = smart_agsn

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hold_time is not None:
            result['HoldTime'] = self.hold_time
        if self.keep_alive is not None:
            result['KeepAlive'] = self.keep_alive
        if self.local_as is not None:
            result['LocalAs'] = self.local_as
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.router_id is not None:
            result['RouterId'] = self.router_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_agsn is not None:
            result['SmartAGSn'] = self.smart_agsn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HoldTime') is not None:
            self.hold_time = m.get('HoldTime')
        if m.get('KeepAlive') is not None:
            self.keep_alive = m.get('KeepAlive')
        if m.get('LocalAs') is not None:
            self.local_as = m.get('LocalAs')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RouterId') is not None:
            self.router_id = m.get('RouterId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGSn') is not None:
            self.smart_agsn = m.get('SmartAGSn')
        return self


class ModifySagRouteProtocolBgpResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifySagRouteProtocolBgpResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifySagRouteProtocolBgpResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifySagRouteProtocolBgpResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifySagRouteProtocolOspfRequest(TeaModel):
    def __init__(
        self,
        area_id: int = None,
        authentication_type: str = None,
        dead_time: int = None,
        hello_time: int = None,
        md_5key: str = None,
        md_5key_id: int = None,
        owner_account: str = None,
        owner_id: int = None,
        password: str = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        router_id: str = None,
        smart_agid: str = None,
        smart_agsn: str = None,
    ):
        self.area_id = area_id
        self.authentication_type = authentication_type
        self.dead_time = dead_time
        self.hello_time = hello_time
        self.md_5key = md_5key
        self.md_5key_id = md_5key_id
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.password = password
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.router_id = router_id
        self.smart_agid = smart_agid
        self.smart_agsn = smart_agsn

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.area_id is not None:
            result['AreaId'] = self.area_id
        if self.authentication_type is not None:
            result['AuthenticationType'] = self.authentication_type
        if self.dead_time is not None:
            result['DeadTime'] = self.dead_time
        if self.hello_time is not None:
            result['HelloTime'] = self.hello_time
        if self.md_5key is not None:
            result['Md5Key'] = self.md_5key
        if self.md_5key_id is not None:
            result['Md5KeyId'] = self.md_5key_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.password is not None:
            result['Password'] = self.password
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.router_id is not None:
            result['RouterId'] = self.router_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_agsn is not None:
            result['SmartAGSn'] = self.smart_agsn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AreaId') is not None:
            self.area_id = m.get('AreaId')
        if m.get('AuthenticationType') is not None:
            self.authentication_type = m.get('AuthenticationType')
        if m.get('DeadTime') is not None:
            self.dead_time = m.get('DeadTime')
        if m.get('HelloTime') is not None:
            self.hello_time = m.get('HelloTime')
        if m.get('Md5Key') is not None:
            self.md_5key = m.get('Md5Key')
        if m.get('Md5KeyId') is not None:
            self.md_5key_id = m.get('Md5KeyId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RouterId') is not None:
            self.router_id = m.get('RouterId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGSn') is not None:
            self.smart_agsn = m.get('SmartAGSn')
        return self


class ModifySagRouteProtocolOspfResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifySagRouteProtocolOspfResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifySagRouteProtocolOspfResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifySagRouteProtocolOspfResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifySagStaticRouteRequest(TeaModel):
    def __init__(
        self,
        destination_cidr: str = None,
        next_hop: str = None,
        owner_account: str = None,
        owner_id: int = None,
        port_name: str = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        smart_agsn: str = None,
        vlan: str = None,
    ):
        self.destination_cidr = destination_cidr
        self.next_hop = next_hop
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.port_name = port_name
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.smart_agsn = smart_agsn
        self.vlan = vlan

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.destination_cidr is not None:
            result['DestinationCidr'] = self.destination_cidr
        if self.next_hop is not None:
            result['NextHop'] = self.next_hop
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.port_name is not None:
            result['PortName'] = self.port_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_agsn is not None:
            result['SmartAGSn'] = self.smart_agsn
        if self.vlan is not None:
            result['Vlan'] = self.vlan
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DestinationCidr') is not None:
            self.destination_cidr = m.get('DestinationCidr')
        if m.get('NextHop') is not None:
            self.next_hop = m.get('NextHop')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PortName') is not None:
            self.port_name = m.get('PortName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGSn') is not None:
            self.smart_agsn = m.get('SmartAGSn')
        if m.get('Vlan') is not None:
            self.vlan = m.get('Vlan')
        return self


class ModifySagStaticRouteResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifySagStaticRouteResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifySagStaticRouteResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifySagStaticRouteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifySagUserDnsRequest(TeaModel):
    def __init__(
        self,
        master_dns: str = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        slave_dns: str = None,
        smart_agid: str = None,
        smart_agsn: str = None,
    ):
        self.master_dns = master_dns
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.slave_dns = slave_dns
        self.smart_agid = smart_agid
        self.smart_agsn = smart_agsn

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.master_dns is not None:
            result['MasterDns'] = self.master_dns
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.slave_dns is not None:
            result['SlaveDns'] = self.slave_dns
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_agsn is not None:
            result['SmartAGSn'] = self.smart_agsn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MasterDns') is not None:
            self.master_dns = m.get('MasterDns')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SlaveDns') is not None:
            self.slave_dns = m.get('SlaveDns')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGSn') is not None:
            self.smart_agsn = m.get('SmartAGSn')
        return self


class ModifySagUserDnsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifySagUserDnsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifySagUserDnsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifySagUserDnsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifySagWanRequest(TeaModel):
    def __init__(
        self,
        bandwidth: int = None,
        gateway: str = None,
        ip: str = None,
        iptype: str = None,
        isp: str = None,
        mask: str = None,
        owner_account: str = None,
        owner_id: int = None,
        password: str = None,
        port_name: str = None,
        priority: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        smart_agsn: str = None,
        username: str = None,
        weight: int = None,
    ):
        self.bandwidth = bandwidth
        self.gateway = gateway
        self.ip = ip
        self.iptype = iptype
        self.isp = isp
        self.mask = mask
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.password = password
        self.port_name = port_name
        self.priority = priority
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.smart_agsn = smart_agsn
        self.username = username
        self.weight = weight

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.gateway is not None:
            result['Gateway'] = self.gateway
        if self.ip is not None:
            result['IP'] = self.ip
        if self.iptype is not None:
            result['IPType'] = self.iptype
        if self.isp is not None:
            result['ISP'] = self.isp
        if self.mask is not None:
            result['Mask'] = self.mask
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.password is not None:
            result['Password'] = self.password
        if self.port_name is not None:
            result['PortName'] = self.port_name
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_agsn is not None:
            result['SmartAGSn'] = self.smart_agsn
        if self.username is not None:
            result['Username'] = self.username
        if self.weight is not None:
            result['Weight'] = self.weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('Gateway') is not None:
            self.gateway = m.get('Gateway')
        if m.get('IP') is not None:
            self.ip = m.get('IP')
        if m.get('IPType') is not None:
            self.iptype = m.get('IPType')
        if m.get('ISP') is not None:
            self.isp = m.get('ISP')
        if m.get('Mask') is not None:
            self.mask = m.get('Mask')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('PortName') is not None:
            self.port_name = m.get('PortName')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGSn') is not None:
            self.smart_agsn = m.get('SmartAGSn')
        if m.get('Username') is not None:
            self.username = m.get('Username')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        return self


class ModifySagWanResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifySagWanResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifySagWanResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifySagWanResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifySagWanSnatRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        smart_agsn: str = None,
        snat: str = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.smart_agsn = smart_agsn
        self.snat = snat

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_agsn is not None:
            result['SmartAGSn'] = self.smart_agsn
        if self.snat is not None:
            result['Snat'] = self.snat
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGSn') is not None:
            self.smart_agsn = m.get('SmartAGSn')
        if m.get('Snat') is not None:
            self.snat = m.get('Snat')
        return self


class ModifySagWanSnatResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifySagWanSnatResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifySagWanSnatResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifySagWanSnatResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifySagWifiRequest(TeaModel):
    def __init__(
        self,
        authentication_type: str = None,
        bandwidth: str = None,
        channel: str = None,
        encrypt_algorithm: str = None,
        is_auth: str = None,
        is_broadcast: str = None,
        is_enable: str = None,
        owner_account: str = None,
        owner_id: int = None,
        password: str = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        ssid: str = None,
        smart_agid: str = None,
        smart_agsn: str = None,
    ):
        self.authentication_type = authentication_type
        self.bandwidth = bandwidth
        self.channel = channel
        self.encrypt_algorithm = encrypt_algorithm
        self.is_auth = is_auth
        self.is_broadcast = is_broadcast
        self.is_enable = is_enable
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.password = password
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.ssid = ssid
        self.smart_agid = smart_agid
        self.smart_agsn = smart_agsn

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.authentication_type is not None:
            result['AuthenticationType'] = self.authentication_type
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.channel is not None:
            result['Channel'] = self.channel
        if self.encrypt_algorithm is not None:
            result['EncryptAlgorithm'] = self.encrypt_algorithm
        if self.is_auth is not None:
            result['IsAuth'] = self.is_auth
        if self.is_broadcast is not None:
            result['IsBroadcast'] = self.is_broadcast
        if self.is_enable is not None:
            result['IsEnable'] = self.is_enable
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.password is not None:
            result['Password'] = self.password
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.ssid is not None:
            result['SSID'] = self.ssid
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.smart_agsn is not None:
            result['SmartAGSn'] = self.smart_agsn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthenticationType') is not None:
            self.authentication_type = m.get('AuthenticationType')
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('Channel') is not None:
            self.channel = m.get('Channel')
        if m.get('EncryptAlgorithm') is not None:
            self.encrypt_algorithm = m.get('EncryptAlgorithm')
        if m.get('IsAuth') is not None:
            self.is_auth = m.get('IsAuth')
        if m.get('IsBroadcast') is not None:
            self.is_broadcast = m.get('IsBroadcast')
        if m.get('IsEnable') is not None:
            self.is_enable = m.get('IsEnable')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SSID') is not None:
            self.ssid = m.get('SSID')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('SmartAGSn') is not None:
            self.smart_agsn = m.get('SmartAGSn')
        return self


class ModifySagWifiResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifySagWifiResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifySagWifiResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifySagWifiResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifySmartAccessGatewayRequest(TeaModel):
    def __init__(
        self,
        cidr_block: str = None,
        description: str = None,
        name: str = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        routing_strategy: str = None,
        security_lock_threshold: int = None,
        smart_agid: str = None,
    ):
        self.cidr_block = cidr_block
        self.description = description
        self.name = name
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.routing_strategy = routing_strategy
        self.security_lock_threshold = security_lock_threshold
        self.smart_agid = smart_agid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cidr_block is not None:
            result['CidrBlock'] = self.cidr_block
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.routing_strategy is not None:
            result['RoutingStrategy'] = self.routing_strategy
        if self.security_lock_threshold is not None:
            result['SecurityLockThreshold'] = self.security_lock_threshold
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CidrBlock') is not None:
            self.cidr_block = m.get('CidrBlock')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RoutingStrategy') is not None:
            self.routing_strategy = m.get('RoutingStrategy')
        if m.get('SecurityLockThreshold') is not None:
            self.security_lock_threshold = m.get('SecurityLockThreshold')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        return self


class ModifySmartAccessGatewayResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifySmartAccessGatewayResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifySmartAccessGatewayResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifySmartAccessGatewayResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifySmartAccessGatewayClientUserRequest(TeaModel):
    def __init__(
        self,
        bandwidth: int = None,
        email: str = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        user_name: str = None,
    ):
        self.bandwidth = bandwidth
        self.email = email
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.email is not None:
            result['Email'] = self.email
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('Email') is not None:
            self.email = m.get('Email')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class ModifySmartAccessGatewayClientUserResponseBody(TeaModel):
    def __init__(
        self,
        bandwidth: int = None,
        client_ip: str = None,
        request_id: str = None,
        user_mail: str = None,
        user_name: str = None,
    ):
        self.bandwidth = bandwidth
        self.client_ip = client_ip
        self.request_id = request_id
        self.user_mail = user_mail
        self.user_name = user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.client_ip is not None:
            result['ClientIp'] = self.client_ip
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.user_mail is not None:
            result['UserMail'] = self.user_mail
        if self.user_name is not None:
            result['UserName'] = self.user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('ClientIp') is not None:
            self.client_ip = m.get('ClientIp')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UserMail') is not None:
            self.user_mail = m.get('UserMail')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        return self


class ModifySmartAccessGatewayClientUserResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifySmartAccessGatewayClientUserResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifySmartAccessGatewayClientUserResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifySmartAccessGatewayUpBandwidthRequest(TeaModel):
    def __init__(
        self,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
        up_bandwidth_4g: int = None,
        up_bandwidth_wan: int = None,
    ):
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid
        self.up_bandwidth_4g = up_bandwidth_4g
        self.up_bandwidth_wan = up_bandwidth_wan

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.smart_agid is not None:
            result['SmartAGId'] = self.smart_agid
        if self.up_bandwidth_4g is not None:
            result['UpBandwidth4G'] = self.up_bandwidth_4g
        if self.up_bandwidth_wan is not None:
            result['UpBandwidthWan'] = self.up_bandwidth_wan
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SmartAGId') is not None:
            self.smart_agid = m.get('SmartAGId')
        if m.get('UpBandwidth4G') is not None:
            self.up_bandwidth_4g = m.get('UpBandwidth4G')
        if m.get('UpBandwidthWan') is not None:
            self.up_bandwidth_wan = m.get('UpBandwidthWan')
        return self


class ModifySmartAccessGatewayUpBandwidthResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifySmartAccessGatewayUpBandwidthResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifySmartAccessGatewayUpBandwidthResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifySmartAccessGatewayUpBandwidthResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class MoveResourceGroupRequest(TeaModel):
    def __init__(
        self,
        new_resource_group_id: str = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        resource_type: str = None,
    ):
        self.new_resource_group_id = new_resource_group_id
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_id = resource_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.resource_type = resource_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.new_resource_group_id is not None:
            result['NewResourceGroupId'] = self.new_resource_group_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NewResourceGroupId') is not None:
            self.new_resource_group_id = m.get('NewResourceGroupId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        return self


class MoveResourceGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class MoveResourceGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: MoveResourceGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = MoveResourceGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ProbeAccessPointNetworkQualityRequest(TeaModel):
    def __init__(
        self,
        access_point_ids: List[int] = None,
        owner_account: str = None,
        owner_id: int = None,
        region_id: str = None,
        resource_owner_account: str = None,
        resource_owner_id: int = None,
        smart_agid: str = None,
    ):
        self.access_point_ids = access_point_ids
        self.owner_account = owner_account
        self.owner_id = owner_id
        self.region_id = region_id
        self.resource_owner_account = resource_owner_account
        self.resource_owner_id = resource_owner_id
        self.smart_agid = smart_agid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_point_ids is not None:
            result['AccessPointIds'] = self.access_point_ids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if