"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFrontToMediaStore = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const defaults = require("@aws-solutions-constructs/core");
const core_1 = require("@aws-cdk/core");
class CloudFrontToMediaStore extends core_1.Construct {
    /**
     * @param scope - represents the scope for all the resources.
     * @param id - this is a scope-unique id.
     * @param props - user provided props for the construct.
     * @summary Constructs a new instance of CloudFrontToMediaStore class.
     * @since 1.76.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        let cloudFrontDistributionProps = props.cloudFrontDistributionProps;
        if (props.existingMediaStoreContainerObj) {
            this.mediaStoreContainer = props.existingMediaStoreContainerObj;
        }
        else {
            let mediaStoreProps;
            if (props.mediaStoreContainerProps) {
                mediaStoreProps = props.mediaStoreContainerProps;
            }
            else {
                this.cloudFrontOriginAccessIdentity = defaults.CloudFrontOriginAccessIdentity(this);
                mediaStoreProps = {
                    containerName: core_1.Aws.STACK_NAME,
                    policy: JSON.stringify({
                        Version: '2012-10-17',
                        Statement: [{
                                Sid: 'MediaStoreDefaultPolicy',
                                Effect: 'Allow',
                                Principal: '*',
                                Action: [
                                    'mediastore:GetObject',
                                    'mediastore:DescribeObject'
                                ],
                                Resource: `arn:${core_1.Aws.PARTITION}:mediastore:${core_1.Aws.REGION}:${core_1.Aws.ACCOUNT_ID}:container/${core_1.Aws.STACK_NAME}/*`,
                                Condition: {
                                    Bool: {
                                        'aws:UserAgent': this.cloudFrontOriginAccessIdentity.originAccessIdentityName,
                                        'aws:SecureTransport': 'true'
                                    }
                                }
                            }]
                    })
                };
                const userAgentHeader = {
                    'User-Agent': this.cloudFrontOriginAccessIdentity.originAccessIdentityName
                };
                if (cloudFrontDistributionProps) {
                    cloudFrontDistributionProps.customHeaders = userAgentHeader;
                }
                else {
                    cloudFrontDistributionProps = {
                        customHeaders: userAgentHeader
                    };
                }
            }
            this.mediaStoreContainer = defaults.MediaStoreContainer(this, mediaStoreProps);
        }
        [this.cloudFrontWebDistribution, this.cloudFrontLoggingBucket, this.cloudFrontOriginRequestPolicy, this.edgeLambdaFunctionVersion]
            = defaults.CloudFrontDistributionForMediaStore(this, this.mediaStoreContainer, cloudFrontDistributionProps, props.insertHttpSecurityHeaders);
    }
}
exports.CloudFrontToMediaStore = CloudFrontToMediaStore;
_a = JSII_RTTI_SYMBOL_1;
CloudFrontToMediaStore[_a] = { fqn: "@aws-solutions-constructs/aws-cloudfront-mediastore.CloudFrontToMediaStore", version: "1.104.0" };
//# sourceMappingURL=data:application/json;base64,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