"use strict";
// Copyright (c) David Brochart
// Distributed under the terms of the Modified BSD License.
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const golden_layout_1 = __importDefault(require("golden-layout"));
const base_1 = require("@jupyter-widgets/base");
const messaging_1 = require("@phosphor/messaging");
const widgets_1 = require("@phosphor/widgets");
const algorithm_1 = require("@phosphor/algorithm");
const version_1 = require("./version");
// Import the CSS
require("../css/widget.css");
require("golden-layout/src/css/goldenlayout-base.css");
require("../css/widget.css");
class LayoutModel extends base_1.DOMWidgetModel {
    defaults() {
        return Object.assign({}, super.defaults(), { _model_name: LayoutModel.model_name, _model_module: LayoutModel.model_module, _model_module_version: LayoutModel.model_module_version, _view_name: LayoutModel.view_name, _view_module: LayoutModel.view_module, _view_module_version: LayoutModel.view_module_version, config: {}, width: 500, height: 500, theme: 'light', _children: [], _component_names: [] });
    }
}
LayoutModel.serializers = Object.assign({}, base_1.DOMWidgetModel.serializers, { 
    // Add any extra serializers here
    _children: { deserialize: base_1.unpack_models } });
LayoutModel.model_name = 'LayoutModel';
LayoutModel.model_module = version_1.MODULE_NAME;
LayoutModel.model_module_version = version_1.MODULE_VERSION;
LayoutModel.view_name = 'LayoutView'; // Set to null if no view
LayoutModel.view_module = version_1.MODULE_NAME; // Set to null if no view
LayoutModel.view_module_version = version_1.MODULE_VERSION;
exports.LayoutModel = LayoutModel;
class LayoutView extends base_1.DOMWidgetView {
    _createElement(tagName) {
        this.pWidget = new base_1.JupyterPhosphorPanelWidget({ view: this });
        return this.pWidget.node;
    }
    _setElement(el) {
        if (this.el || el !== this.pWidget.node) {
            // Boxes don't allow setting the element beyond the initial creation.
            throw new Error('Cannot reset the DOM element.');
        }
        this.el = this.pWidget.node;
        this.$el = $(this.pWidget.node);
    }
    render() {
        this.el.classList.add('custom-widget');
        let theme = this.model.get('theme');
        if (theme == 'light') {
            require('golden-layout/src/css/goldenlayout-light-theme.css');
        }
        else {
            require('golden-layout/src/css/goldenlayout-dark-theme.css');
        }
        //this.el.style.width = this.model.get('width') + 'px';
        //this.el.style.height = this.model.get('height') + 'px';
        this.children_views = new base_1.ViewList(this.add_child_model, null, this);
        this.config_changed();
        this.update_children();
        this.model.on('change:config', this.config_changed, this);
        this.listenTo(this.model, 'change:_children', this.update_children);
    }
    update_children() {
        this.children_views
            .update(this.model.get('_children'))
            .then((views) => {
            let component_names = this.model.get('_component_names');
            for (var i in views) {
                let view = views[i];
                console.log(view);
                // Notify all children that their sizes may have changed.
                messaging_1.MessageLoop.postMessage(view.pWidget, widgets_1.Widget.ResizeMessage.UnknownSize);
                this.layout.registerComponent(component_names[i], function (container, state) {
                    container.getElement().html(view.el);
                });
            }
            this.layout.init();
        });
    }
    config_changed() {
        let config = this.model.get('config');
        this.layout = new golden_layout_1.default(config, this.el);
    }
    add_child_model(model) {
        // we insert a dummy element so the order is preserved when we add
        // the rendered content later.
        let dummy = new widgets_1.Widget();
        this.pWidget.addWidget(dummy);
        return this.create_child_view(model).then((view) => {
            // replace the dummy widget with the new one.
            let i = algorithm_1.ArrayExt.firstIndexOf(this.pWidget.widgets, dummy);
            this.pWidget.insertWidget(i, view.pWidget);
            dummy.dispose();
            return view;
        }).catch(base_1.reject('Could not add child view to box', true));
    }
}
exports.LayoutView = LayoutView;
//# sourceMappingURL=widget.js.map