/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.builder.xpath.jaxen.function.ext;

import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.xmlpull.v1.builder.xpath.jaxen.Context;
import org.xmlpull.v1.builder.xpath.jaxen.Function;
import org.xmlpull.v1.builder.xpath.jaxen.FunctionCallException;
import org.xmlpull.v1.builder.xpath.jaxen.Navigator;
import org.xmlpull.v1.builder.xpath.jaxen.function.StringFunction;

public abstract class LocaleFunctionSupport
implements Function {
    protected Locale getLocale(Object value, Navigator navigator) {
        if (value instanceof Locale) {
            return (Locale)value;
        }
        if (value instanceof List) {
            List list = (List)value;
            if (!list.isEmpty()) {
                return this.getLocale(list.get(0), navigator);
            }
        } else {
            String text = StringFunction.evaluate(value, navigator);
            if (text != null && text.length() > 0) {
                return this.findLocale(text);
            }
        }
        return null;
    }

    protected Locale findLocale(String localeText) {
        StringTokenizer enu = new StringTokenizer(localeText, "-");
        if (enu.hasMoreTokens()) {
            String language2 = enu.nextToken();
            if (!enu.hasMoreTokens()) {
                return this.findLocaleForLanguage(language2);
            }
            String country = enu.nextToken();
            if (!enu.hasMoreTokens()) {
                return new Locale(language2, country);
            }
            String variant = enu.nextToken();
            return new Locale(language2, country, variant);
        }
        return null;
    }

    protected Locale findLocaleForLanguage(String language2) {
        Locale[] locales = Locale.getAvailableLocales();
        int size = locales.length;
        for (int i = 0; i < size; ++i) {
            String variant;
            String country;
            Locale locale = locales[i];
            if (!language2.equals(locale.getLanguage()) || (country = locale.getCountry()) != null && country.length() != 0 || (variant = locale.getVariant()) != null && variant.length() != 0) continue;
            return locale;
        }
        return null;
    }

    public abstract /* synthetic */ Object call(Context var1, List var2) throws FunctionCallException;
}

