/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum V3WorkClassificationODH {
    PWAF,
    PWFG,
    PWLG,
    PWNSE,
    PWSE,
    PWSG,
    UWNSE,
    UWSE,
    VW,
    NULL;


    public static V3WorkClassificationODH fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("PWAF".equals(codeString)) {
            return PWAF;
        }
        if ("PWFG".equals(codeString)) {
            return PWFG;
        }
        if ("PWLG".equals(codeString)) {
            return PWLG;
        }
        if ("PWNSE".equals(codeString)) {
            return PWNSE;
        }
        if ("PWSE".equals(codeString)) {
            return PWSE;
        }
        if ("PWSG".equals(codeString)) {
            return PWSG;
        }
        if ("UWNSE".equals(codeString)) {
            return UWNSE;
        }
        if ("UWSE".equals(codeString)) {
            return UWSE;
        }
        if ("VW".equals(codeString)) {
            return VW;
        }
        throw new FHIRException("Unknown V3WorkClassificationODH code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PWAF: {
                return "PWAF";
            }
            case PWFG: {
                return "PWFG";
            }
            case PWLG: {
                return "PWLG";
            }
            case PWNSE: {
                return "PWNSE";
            }
            case PWSE: {
                return "PWSE";
            }
            case PWSG: {
                return "PWSG";
            }
            case UWNSE: {
                return "UWNSE";
            }
            case UWSE: {
                return "UWSE";
            }
            case VW: {
                return "VW";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/v3-WorkClassificationODH";
    }

    public String getDefinition() {
        switch (this) {
            case PWAF: {
                return "A situation in which an individual serves in a government-sponsored military force.";
            }
            case PWFG: {
                return "A situation in which an individual works for a national government organization, not including armed forces, and receives a paid salary or wage.";
            }
            case PWLG: {
                return "A situation in which an individual works for a government organization with jurisdiction below the level of state/provincial/territorial/tribal government (e.g., city, town, township), not armed forces, and receives a paid salary or wage.";
            }
            case PWNSE: {
                return "A situation in which an individual works for a business (not government) that they do not own and receives a paid salary or wage.";
            }
            case PWSE: {
                return "A situation in which an individual earns a salary or wage working for himself or herself instead of working for an employer.";
            }
            case PWSG: {
                return "A situation in which an individual works for a government organization with jurisdiction immediately below the level of national government (between national government and local government), not armed forces and receives a paid salary or wage.  Often called a state, provincial, territorial, or tribal government.";
            }
            case UWNSE: {
                return "A situation in which an individual works for a business (not government) that they do not own without receiving a paid salary or wage.";
            }
            case UWSE: {
                return "A situation in which an individual works for himself or herself without receiving a paid salary or wage.";
            }
            case VW: {
                return "A situation in which an individual chooses to do something, especially for other people or for an organization, willingly and without being forced or compensated to do it.  This can include formal activity undertaken through public, private and voluntary organizations as well as informal community participation.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PWAF: {
                return "Paid work, Armed Forces";
            }
            case PWFG: {
                return "Paid work, national government, not armed forces";
            }
            case PWLG: {
                return "Paid work, local government, not armed forces";
            }
            case PWNSE: {
                return "Paid non-governmental work, not self-employed";
            }
            case PWSE: {
                return "Paid work, self-employed";
            }
            case PWSG: {
                return "Paid work, state government, not armed forces";
            }
            case UWNSE: {
                return "Unpaid non-governmental work, not self-employed";
            }
            case UWSE: {
                return "Unpaid work, self-employed";
            }
            case VW: {
                return "Voluntary work";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

