/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.hl7.fhir.r4.model.MetadataResource;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.utilities.VersionUtilities;

public class CanonicalResourceManager<T extends MetadataResource> {
    private boolean enforceUniqueId;
    private List<T> list = new ArrayList<T>();
    private Map<String, T> map = new HashMap<String, T>();

    public CanonicalResourceManager(boolean enforceUniqueId) {
        this.enforceUniqueId = enforceUniqueId;
    }

    public void copy(CanonicalResourceManager<T> source2) {
        this.list.clear();
        this.map.clear();
        this.list.addAll(source2.list);
        this.map.putAll(source2.map);
    }

    public void see(T r) {
        if (!((Resource)r).hasId()) {
            ((Resource)r).setId(UUID.randomUUID().toString());
        }
        if (this.enforceUniqueId && this.map.containsKey(((Resource)r).getId())) {
            this.drop(((Resource)r).getId());
        }
        this.list.add(r);
        this.map.put(((Resource)r).getId(), r);
        if (((MetadataResource)r).hasUrl()) {
            if (((MetadataResource)r).hasVersion()) {
                this.map.put(((MetadataResource)r).getUrl() + "|" + ((MetadataResource)r).getVersion(), r);
            }
            this.updateList(((MetadataResource)r).getUrl(), ((MetadataResource)r).getVersion());
        }
    }

    private void updateList(String url, String version) {
        ArrayList<MetadataResource> rl = new ArrayList<MetadataResource>();
        for (Object t : this.list) {
            if (!url.equals(((MetadataResource)t).getUrl()) || rl.contains(t)) continue;
            rl.add((MetadataResource)t);
        }
        if (rl.size() > 0) {
            Collections.sort(rl, new MetadataResourceVersionComparator());
            this.map.put(url, (MetadataResource)rl.get(rl.size() - 1));
            if (version != null) {
                String lv;
                MetadataResource latest = null;
                for (MetadataResource t : rl) {
                    if (!VersionUtilities.versionsCompatible(t.getVersion(), version)) continue;
                    latest = t;
                }
                if (latest != null && (lv = VersionUtilities.getMajMin(latest.getVersion())) != null && !lv.equals(version)) {
                    this.map.put(url + "|" + lv, (MetadataResource)rl.get(rl.size() - 1));
                }
            }
        }
    }

    public T get(String url) {
        return (T)((MetadataResource)this.map.get(url));
    }

    public boolean has(String url) {
        return this.map.containsKey(url);
    }

    public T get(String system, String version) {
        if (this.map.containsKey(system + "|" + version)) {
            return (T)((MetadataResource)this.map.get(system + "|" + version));
        }
        String mm3 = VersionUtilities.getMajMin(version);
        if (mm3 != null) {
            return (T)((MetadataResource)this.map.get(system + "|" + mm3));
        }
        return null;
    }

    public boolean has(String system, String version) {
        if (this.map.containsKey(system + "|" + version)) {
            return true;
        }
        String mm3 = VersionUtilities.getMajMin(version);
        if (mm3 != null) {
            return this.map.containsKey(system + "|" + mm3);
        }
        return false;
    }

    public int size() {
        return this.list.size();
    }

    public void drop(String id) {
        MetadataResource res = null;
        do {
            res = null;
            for (MetadataResource t : this.list) {
                if (!t.getId().equals(id)) continue;
                res = t;
            }
            if (res == null) continue;
            this.list.remove(res);
            this.map.remove(id);
            this.map.remove(res.getUrl());
            if (res.hasVersion()) {
                this.map.remove(res.getUrl() + "|" + res.getVersion());
                String mm3 = VersionUtilities.getMajMin(res.getVersion());
                if (mm3 != null) {
                    this.map.remove(res.getUrl() + "|" + mm3);
                }
            }
            this.updateList(res.getUrl(), res.getVersion());
        } while (res != null);
    }

    public void listAll(List<T> result) {
        result.addAll(this.list);
    }

    public void listAllM(List<MetadataResource> result) {
        result.addAll(this.list);
    }

    public void clear() {
        this.list.clear();
        this.map.clear();
    }

    public List<T> getList() {
        ArrayList<MetadataResource> res = new ArrayList<MetadataResource>();
        for (MetadataResource t : this.list) {
            if (res.contains(t)) continue;
            res.add(t);
        }
        return res;
    }

    public Set<String> keys() {
        return this.map.keySet();
    }

    public boolean isEnforceUniqueId() {
        return this.enforceUniqueId;
    }

    public class MetadataResourceVersionComparator<T extends MetadataResource>
    implements Comparator<T> {
        @Override
        public int compare(T arg1, T arg2) {
            String v1 = ((MetadataResource)arg1).getVersion();
            String v2 = ((MetadataResource)arg2).getVersion();
            if (v1 == null && v2 == null) {
                return Integer.compare(CanonicalResourceManager.this.list.indexOf(arg1), CanonicalResourceManager.this.list.indexOf(arg2));
            }
            if (v1 == null) {
                return -1;
            }
            if (v2 == null) {
                return 1;
            }
            String mm1 = VersionUtilities.getMajMin(v1);
            String mm22 = VersionUtilities.getMajMin(v2);
            if (mm1 == null || mm22 == null) {
                return v1.compareTo(v2);
            }
            return mm1.compareTo(mm22);
        }
    }
}

