/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.interceptor;

import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.client.api.IHttpRequest;
import ca.uhn.fhir.rest.client.api.IRestfulClient;
import ca.uhn.fhir.rest.client.api.UrlSourceEnum;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class UrlTenantSelectionInterceptor {
    private String myTenantId;

    public UrlTenantSelectionInterceptor() {
        this(null);
    }

    public UrlTenantSelectionInterceptor(String theTenantId) {
        this.myTenantId = theTenantId;
    }

    public String getTenantId() {
        return this.myTenantId;
    }

    public void setTenantId(String theTenantId) {
        this.myTenantId = theTenantId;
    }

    @Hook(value=Pointcut.CLIENT_REQUEST, order=100)
    public void request(IRestfulClient theClient, IHttpRequest theRequest) {
        String tenantId = this.getTenantId();
        if (StringUtils.isBlank(tenantId)) {
            return;
        }
        String requestUri = theRequest.getUri();
        String serverBase = theClient.getServerBase();
        if (serverBase.endsWith("/")) {
            serverBase = serverBase.substring(0, serverBase.length() - 1);
        }
        Validate.isTrue(requestUri.startsWith(serverBase), "Request URI %s does not start with server base %s", requestUri, serverBase);
        if (theRequest.getUrlSource() == UrlSourceEnum.EXPLICIT) {
            return;
        }
        String newUri = serverBase + "/" + tenantId + requestUri.substring(serverBase.length());
        theRequest.setUri(newUri);
    }
}

