/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.terminology;

import au.csiro.pathling.fhirpath.encoding.ImmutableCoding;
import au.csiro.pathling.fhirpath.encoding.SimpleCoding;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hl7.fhir.r4.model.Coding;

public class ConceptTranslator
implements Serializable {
    private static final long serialVersionUID = -8246857034657784595L;
    @Nonnull
    private final Map<SimpleCoding, List<ImmutableCoding>> codingMapping;

    public ConceptTranslator() {
        this(Collections.emptyMap());
    }

    public ConceptTranslator(@Nonnull Map<SimpleCoding, List<ImmutableCoding>> codingMapping) {
        this.codingMapping = codingMapping;
    }

    @Nonnull
    public static ConceptTranslator empty() {
        return new ConceptTranslator();
    }

    @Nonnull
    public List<Coding> translate(@Nullable Collection<SimpleCoding> codings) {
        return codings == null ? Collections.emptyList() : codings.stream().flatMap(c -> this.codingMapping.getOrDefault(c, Collections.emptyList()).stream()).distinct().map(ImmutableCoding::toCoding).collect(Collectors.toList());
    }

    public String toString() {
        return "ConceptTranslator(codingMapping=" + this.codingMapping + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConceptTranslator)) {
            return false;
        }
        ConceptTranslator other = (ConceptTranslator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<SimpleCoding, List<ImmutableCoding>> this$codingMapping = this.codingMapping;
        Map<SimpleCoding, List<ImmutableCoding>> other$codingMapping = other.codingMapping;
        return !(this$codingMapping == null ? other$codingMapping != null : !((Object)this$codingMapping).equals(other$codingMapping));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConceptTranslator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<SimpleCoding, List<ImmutableCoding>> $codingMapping = this.codingMapping;
        result = result * 59 + ($codingMapping == null ? 43 : ((Object)$codingMapping).hashCode());
        return result;
    }
}

