/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.terminology;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.util.OperationOutcomeUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Parameters;

public class BaseMapping {
    protected BaseMapping() {
    }

    private static void setProperty(@Nonnull Object bean, @Nonnull String name, @Nullable Object value) {
        try {
            BeanUtils.setProperty(bean, name, value);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public static <T> T partToBean(@Nonnull Parameters.ParametersParameterComponent component, @Nonnull Supplier<T> supplier) {
        Object result = supplier.get();
        component.getPart().forEach(p -> BaseMapping.setProperty(result, p.getName(), p.getValue()));
        return result;
    }

    @Nonnull
    public static Parameters parametersFromEntry(@Nonnull Bundle.BundleEntryComponent entry, @Nonnull FhirContext fhirContext) {
        BaseMapping.checkResponseEntry(entry, fhirContext);
        return (Parameters)entry.getResource();
    }

    private static void checkResponseEntry(@Nonnull Bundle.BundleEntryComponent entry, @Nonnull FhirContext fhirContext) {
        Bundle.BundleEntryResponseComponent response = entry.getResponse();
        int statusCode = Integer.parseInt(response.getStatus());
        if (statusCode < 200 || statusCode > 299) {
            String message = "Error in response entry : HTTP " + response.getStatus();
            IBaseOperationOutcome oo = (IBaseOperationOutcome)((Object)entry.getResource());
            String details = OperationOutcomeUtil.getFirstIssueDetails(fhirContext, oo);
            if (StringUtils.isNotBlank(details)) {
                message = message + " : " + details;
            }
            BaseServerResponseException exception = BaseServerResponseException.newInstance(statusCode, message);
            exception.setOperationOutcome(oo);
            throw exception;
        }
    }
}

