/*
 * Decompiled with CFR 0.152.
 */
package au.csiro.pathling.fhirpath.encoding;

import au.csiro.pathling.fhirpath.encoding.CodingEncoding;
import au.csiro.pathling.fhirpath.encoding.SimpleCoding;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.GenericArrayData;

public interface SimpleCodingsDecoders {
    public static final String COL_INPUT_CODINGS = "inputCodings";
    public static final String COL_ARG_CODINGS = "argCodings";

    @Nullable
    private static String safeGetString(@Nonnull InternalRow ir, int ordinal) {
        return ir.isNullAt(ordinal) ? null : ir.getString(ordinal);
    }

    @Nullable
    public static SimpleCoding decodeCoding(@Nullable Object row) {
        InternalRow ir = (InternalRow)row;
        if (ir != null) {
            return new SimpleCoding(SimpleCodingsDecoders.safeGetString(ir, CodingEncoding.SYSTEM_INDEX), SimpleCodingsDecoders.safeGetString(ir, CodingEncoding.CODE_INDEX), SimpleCodingsDecoders.safeGetString(ir, CodingEncoding.VERSION_INDEX));
        }
        return null;
    }

    @Nullable
    public static List<SimpleCoding> decodeList(@Nullable Object array) {
        GenericArrayData arrayData = (GenericArrayData)array;
        return array != null ? Stream.of(arrayData.array()).map(SimpleCodingsDecoders::decodeCoding).collect(Collectors.toList()) : null;
    }

    @Nullable
    public static ImmutablePair<List<SimpleCoding>, List<SimpleCoding>> decodeListPair(@Nullable Object row) {
        InternalRow ir = (InternalRow)row;
        return row != null ? ImmutablePair.of(SimpleCodingsDecoders.decodeList(ir.getArray(0)), SimpleCodingsDecoders.decodeList(ir.getArray(1))) : null;
    }
}

