# Generated by Django 2.2.13 on 2020-08-15 19:17

import multiselectfield.db.fields

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("eveonline", "0012_index_additions"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("eveuniverse", "0002_load_eveunit"),
    ]

    operations = [
        migrations.CreateModel(
            name="General",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
            ],
            options={
                "permissions": (
                    ("basic_access", "Can access this app and see timers"),
                    ("create_timer", "Can create new timers and edit own timers"),
                    ("manage_timer", "Can edit and delete any timer"),
                    ("opsec_access", "Can create and see opsec timers"),
                ),
                "managed": False,
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="DiscordWebhook",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="short name to identify this webhook",
                        max_length=64,
                        unique=True,
                    ),
                ),
                (
                    "url",
                    models.CharField(
                        help_text="URL of this webhook, e.g. https://discordapp.com/api/webhooks/123456/abcdef",
                        max_length=255,
                        unique=True,
                    ),
                ),
                (
                    "notes",
                    models.TextField(
                        blank=True,
                        default=None,
                        help_text="you can add notes about this webhook here if you want",
                        null=True,
                    ),
                ),
                (
                    "is_enabled",
                    models.BooleanField(
                        db_index=True,
                        default=True,
                        help_text="whether notifications are currently sent to this webhook",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="NotificationRule",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "trigger",
                    models.CharField(
                        choices=[
                            ("TC", "New timer created"),
                            ("TR", "Scheduled time reached"),
                        ],
                        help_text="Trigger for sending a notification",
                        max_length=2,
                    ),
                ),
                (
                    "scheduled_time",
                    models.PositiveIntegerField(
                        blank=True,
                        choices=[
                            (None, "---------"),
                            (0, "T - 0 minutes"),
                            (5, "T - 5 minutes"),
                            (10, "T - 10 minutes"),
                            (15, "T - 15 minutes"),
                            (30, "T - 30 minutes"),
                            (45, "T - 45 minutes"),
                            (60, "T - 60 minutes"),
                            (90, "T - 90 minutes"),
                            (120, "T - 120 minutes"),
                        ],
                        db_index=True,
                        default=None,
                        help_text="When to sent a notification in relation to when the timer elapses. Use together with `Scheduled time reached` trigger.",
                        null=True,
                    ),
                ),
                (
                    "ping_type",
                    models.CharField(
                        choices=[
                            ("PN", "(no ping)"),
                            ("PH", "@here"),
                            ("PE", "@everyone"),
                        ],
                        default="PN",
                        help_text="Options for pinging on notification",
                        max_length=2,
                    ),
                ),
                (
                    "is_enabled",
                    models.BooleanField(
                        default=True, help_text="whether this rule is currently active"
                    ),
                ),
                (
                    "require_timer_types",
                    multiselectfield.db.fields.MultiSelectField(
                        blank=True,
                        choices=[
                            ("NO", "Unspecified"),
                            ("AR", "Armor"),
                            ("HL", "Hull"),
                            ("FI", "Final"),
                            ("AN", "Anchoring"),
                            ("UA", "Unanchoring"),
                            ("MM", "Moon Mining"),
                        ],
                        help_text="Timer must have one of the given timer types or leave blank to match any.",
                        max_length=20,
                    ),
                ),
                (
                    "exclude_timer_types",
                    multiselectfield.db.fields.MultiSelectField(
                        blank=True,
                        choices=[
                            ("NO", "Unspecified"),
                            ("AR", "Armor"),
                            ("HL", "Hull"),
                            ("FI", "Final"),
                            ("AN", "Anchoring"),
                            ("UA", "Unanchoring"),
                            ("MM", "Moon Mining"),
                        ],
                        help_text="Timer must NOT have one of the given timer types",
                        max_length=20,
                    ),
                ),
                (
                    "require_objectives",
                    multiselectfield.db.fields.MultiSelectField(
                        blank=True,
                        choices=[
                            ("UN", "undefined"),
                            ("HO", "hostile"),
                            ("FR", "friendly"),
                            ("NE", "neutral"),
                        ],
                        help_text="Timer must have one of the given objectives or leave blank to match any.",
                        max_length=11,
                    ),
                ),
                (
                    "exclude_objectives",
                    multiselectfield.db.fields.MultiSelectField(
                        blank=True,
                        choices=[
                            ("UN", "undefined"),
                            ("HO", "hostile"),
                            ("FR", "friendly"),
                            ("NE", "neutral"),
                        ],
                        help_text="Timer must NOT have one of the given objectives",
                        max_length=11,
                    ),
                ),
                (
                    "require_visibility",
                    multiselectfield.db.fields.MultiSelectField(
                        blank=True,
                        choices=[
                            ("UN", "unrestricted"),
                            ("AL", "Alliance only"),
                            ("CO", "Corporation only"),
                        ],
                        help_text="Visibility must be one of the selected or leave blank to match any.",
                        max_length=8,
                    ),
                ),
                (
                    "exclude_visibility",
                    multiselectfield.db.fields.MultiSelectField(
                        blank=True,
                        choices=[
                            ("UN", "unrestricted"),
                            ("AL", "Alliance only"),
                            ("CO", "Corporation only"),
                        ],
                        help_text="Visibility must NOT be one of the selected",
                        max_length=8,
                    ),
                ),
                (
                    "is_important",
                    models.CharField(
                        choices=[("AN", "any"), ("RQ", "required"), ("EX", "excluded")],
                        default="AN",
                        help_text="Wether the timer must be important",
                        max_length=2,
                    ),
                ),
                (
                    "is_opsec",
                    models.CharField(
                        choices=[("AN", "any"), ("RQ", "required"), ("EX", "excluded")],
                        default="AN",
                        help_text="Wether the timer must be OPSEC",
                        max_length=2,
                    ),
                ),
                (
                    "exclude_alliances",
                    models.ManyToManyField(
                        blank=True,
                        help_text="Timer must NOT be created by one of the given alliances",
                        related_name="notification_rule_exclude_alliances",
                        to="eveonline.EveAllianceInfo",
                    ),
                ),
                (
                    "exclude_corporations",
                    models.ManyToManyField(
                        blank=True,
                        help_text="Timer must NOT be created by one of the given corporations",
                        related_name="notification_rule_exclude_corporations",
                        to="eveonline.EveCorporationInfo",
                    ),
                ),
                (
                    "require_alliances",
                    models.ManyToManyField(
                        blank=True,
                        help_text="Timer must be created by one of the given alliances or leave blank to match any.",
                        related_name="notification_rule_require_alliances",
                        to="eveonline.EveAllianceInfo",
                    ),
                ),
                (
                    "require_corporations",
                    models.ManyToManyField(
                        blank=True,
                        help_text="Timer must be created by one of the given corporations or leave blank to match any.",
                        related_name="notification_rule_require_corporations",
                        to="eveonline.EveCorporationInfo",
                    ),
                ),
                (
                    "webhook",
                    models.ForeignKey(
                        help_text="The webhook all notifications are sent to",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="structuretimers.DiscordWebhook",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="ScheduledNotification",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("timer_date", models.DateTimeField(db_index=True)),
                ("notification_date", models.DateTimeField(db_index=True)),
                ("celery_task_id", models.CharField(default="", max_length=765)),
                (
                    "notification_rule",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="structuretimers.NotificationRule",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Timer",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "timer_type",
                    models.CharField(
                        choices=[
                            ("NO", "Unspecified"),
                            ("AR", "Armor"),
                            ("HL", "Hull"),
                            ("FI", "Final"),
                            ("AN", "Anchoring"),
                            ("UA", "Unanchoring"),
                            ("MM", "Moon Mining"),
                        ],
                        default="NO",
                        max_length=2,
                    ),
                ),
                (
                    "location_details",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="Additional information about the location of this structure, e.g. name of nearby planet / moon / gate",
                        max_length=254,
                    ),
                ),
                (
                    "structure_name",
                    models.CharField(blank=True, default="", max_length=254),
                ),
                (
                    "objective",
                    models.CharField(
                        choices=[
                            ("UN", "undefined"),
                            ("HO", "hostile"),
                            ("FR", "friendly"),
                            ("NE", "neutral"),
                        ],
                        default="UN",
                        max_length=2,
                    ),
                ),
                (
                    "date",
                    models.DateTimeField(
                        db_index=True, help_text="Date when this timer happens"
                    ),
                ),
                (
                    "is_important",
                    models.BooleanField(
                        default=False, help_text="Mark this timer as is_important"
                    ),
                ),
                (
                    "owner_name",
                    models.CharField(
                        blank=True,
                        default=None,
                        help_text="Name of the corporation owning the structure",
                        max_length=254,
                        null=True,
                    ),
                ),
                (
                    "is_opsec",
                    models.BooleanField(
                        db_index=True,
                        default=False,
                        help_text="Limit access to users with OPSEC clearance. Can be combined with visibility.",
                    ),
                ),
                (
                    "visibility",
                    models.CharField(
                        choices=[
                            ("UN", "unrestricted"),
                            ("AL", "Alliance only"),
                            ("CO", "Corporation only"),
                        ],
                        db_index=True,
                        default="UN",
                        help_text="The visibility of this timer can be limited to members of your organization",
                        max_length=2,
                    ),
                ),
                (
                    "details_image_url",
                    models.CharField(
                        blank=True,
                        default=None,
                        help_text="URL for details like a screenshot of the structure's fitting, e.g. https://www.example.com/route/image.jpg",
                        max_length=1024,
                        null=True,
                    ),
                ),
                (
                    "details_notes",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="Notes with additional information about this timer",
                    ),
                ),
                (
                    "eve_alliance",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        help_text="Alliance of the user who created this timer",
                        null=True,
                        on_delete=django.db.models.deletion.SET_DEFAULT,
                        related_name="Timers",
                        to="eveonline.EveAllianceInfo",
                    ),
                ),
                (
                    "eve_character",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        help_text="Main character of the user who created this timer",
                        null=True,
                        on_delete=django.db.models.deletion.SET_DEFAULT,
                        related_name="Timers",
                        to="eveonline.EveCharacter",
                    ),
                ),
                (
                    "eve_corporation",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        help_text="Corporation of the user who created this timer",
                        null=True,
                        on_delete=django.db.models.deletion.SET_DEFAULT,
                        related_name="Timers",
                        to="eveonline.EveCorporationInfo",
                    ),
                ),
                (
                    "eve_solar_system",
                    models.ForeignKey(
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="eveuniverse.EveSolarSystem",
                    ),
                ),
                (
                    "notification_rules",
                    models.ManyToManyField(
                        help_text="Notification rules conforming with this timer",
                        through="structuretimers.ScheduledNotification",
                        to="structuretimers.NotificationRule",
                    ),
                ),
                (
                    "structure_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="eveuniverse.EveType",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="Timers",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="schedulednotification",
            name="timer",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="structuretimers.Timer"
            ),
        ),
        migrations.AddConstraint(
            model_name="schedulednotification",
            constraint=models.UniqueConstraint(
                fields=("timer", "notification_rule"),
                name="unique_notification_schedule",
            ),
        ),
    ]
