/*
 * Decompiled with CFR 0.152.
 */
package ca.dmoj.java;

import ca.dmoj.java.BigDecimalDisallowedException;
import ca.dmoj.java.BigIntegerDisallowedException;
import ca.dmoj.java.UnsafePrintStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;

public class SubmissionAgent {
    public static void premain(String argv, Instrumentation inst) throws UnsupportedEncodingException {
        boolean unicode = false;
        boolean noBigMath = false;
        boolean noBuf = false;
        String policy = null;
        if (argv != null) {
            for (String opt : argv.split(",")) {
                if (opt.equals("unicode")) {
                    unicode = true;
                }
                if (opt.equals("nobigmath")) {
                    noBigMath = true;
                }
                if (opt.equals("nobuf")) {
                    noBuf = true;
                }
                if (!opt.startsWith("policy:")) continue;
                policy = opt.split("policy:")[1];
            }
        }
        if (policy == null) {
            throw new IllegalStateException("must specify policy file");
        }
        if (!new File(policy).exists()) {
            throw new IllegalStateException("policy file does not exist: " + policy);
        }
        Thread selfThread = Thread.currentThread();
        if (noBigMath) {
            inst.addTransformer(new ClassFileTransformer(){

                @Override
                public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
                    if (className == null) {
                        return classfileBuffer;
                    }
                    RuntimeException disallowed = null;
                    if (className.startsWith("java/math/BigInteger") || className.startsWith("java/math/MutableBigInteger")) {
                        disallowed = new BigIntegerDisallowedException();
                    } else if (className.startsWith("java/math/BigDecimal")) {
                        disallowed = new BigDecimalDisallowedException();
                    }
                    if (disallowed != null) {
                        SubmissionAgent.dumpExceptionAndExit(disallowed);
                    }
                    return classfileBuffer;
                }
            });
        }
        if (noBuf) {
            System.setOut(new PrintStream(new FileOutputStream(FileDescriptor.out), true));
        } else {
            System.setOut(new UnsafePrintStream(new FileOutputStream(FileDescriptor.out), unicode));
        }
        selfThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable error) {
                SubmissionAgent.dumpExceptionAndExit(error);
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                System.out.flush();
                System.err.flush();
            }
        }));
        System.setProperty("java.security.policy", policy);
        System.setSecurityManager(new SecurityManager());
    }

    private static void dumpExceptionAndExit(Throwable exception) {
        System.err.print("7257b50d-e37a-4664-b1a5-b1340b4206c0: ");
        exception.printStackTrace();
        System.exit(1);
    }
}

