# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from typing import Dict
from Tea.core import TeaCore

from alibabacloud_tea_openapi.client import Client as OpenApiClient
from alibabacloud_tea_openapi import models as open_api_models
from alibabacloud_tea_util.client import Client as UtilClient
from alibabacloud_endpoint_util.client import Client as EndpointUtilClient
from alibabacloud_ens20171110 import models as ens_20171110_models
from alibabacloud_tea_util import models as util_models
from alibabacloud_openapi_util.client import Client as OpenApiUtilClient


class Client(OpenApiClient):
    """
    *\
    """
    def __init__(
        self, 
        config: open_api_models.Config,
    ):
        super().__init__(config)
        self._endpoint_rule = ''
        self.check_config(config)
        self._endpoint = self.get_endpoint('ens', self._region_id, self._endpoint_rule, self._network, self._suffix, self._endpoint_map, self._endpoint)

    def get_endpoint(
        self,
        product_id: str,
        region_id: str,
        endpoint_rule: str,
        network: str,
        suffix: str,
        endpoint_map: Dict[str, str],
        endpoint: str,
    ) -> str:
        if not UtilClient.empty(endpoint):
            return endpoint
        if not UtilClient.is_unset(endpoint_map) and not UtilClient.empty(endpoint_map.get(region_id)):
            return endpoint_map.get(region_id)
        return EndpointUtilClient.get_endpoint_rules(product_id, region_id, endpoint_rule, network, suffix)

    def accosicate_network_acl_with_options(
        self,
        request: ens_20171110_models.AccosicateNetworkAclRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.AccosicateNetworkAclResponse:
        """
        @summary Associates a network access control list (ACL) with a network.
        
        @param request: AccosicateNetworkAclRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AccosicateNetworkAclResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.network_acl_id):
            query['NetworkAclId'] = request.network_acl_id
        if not UtilClient.is_unset(request.resource):
            query['Resource'] = request.resource
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AccosicateNetworkAcl',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.AccosicateNetworkAclResponse(),
            self.call_api(params, req, runtime)
        )

    async def accosicate_network_acl_with_options_async(
        self,
        request: ens_20171110_models.AccosicateNetworkAclRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.AccosicateNetworkAclResponse:
        """
        @summary Associates a network access control list (ACL) with a network.
        
        @param request: AccosicateNetworkAclRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AccosicateNetworkAclResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.network_acl_id):
            query['NetworkAclId'] = request.network_acl_id
        if not UtilClient.is_unset(request.resource):
            query['Resource'] = request.resource
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AccosicateNetworkAcl',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.AccosicateNetworkAclResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def accosicate_network_acl(
        self,
        request: ens_20171110_models.AccosicateNetworkAclRequest,
    ) -> ens_20171110_models.AccosicateNetworkAclResponse:
        """
        @summary Associates a network access control list (ACL) with a network.
        
        @param request: AccosicateNetworkAclRequest
        @return: AccosicateNetworkAclResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.accosicate_network_acl_with_options(request, runtime)

    async def accosicate_network_acl_async(
        self,
        request: ens_20171110_models.AccosicateNetworkAclRequest,
    ) -> ens_20171110_models.AccosicateNetworkAclResponse:
        """
        @summary Associates a network access control list (ACL) with a network.
        
        @param request: AccosicateNetworkAclRequest
        @return: AccosicateNetworkAclResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.accosicate_network_acl_with_options_async(request, runtime)

    def add_backend_servers_with_options(
        self,
        tmp_req: ens_20171110_models.AddBackendServersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.AddBackendServersResponse:
        """
        @summary Adds backend servers.
        
        @description    You can call this operation up to 100 times per second.
        You can call this operation up to 10 times per second per account.
        
        @param tmp_req: AddBackendServersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddBackendServersResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.AddBackendServersShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.backend_servers):
            request.backend_servers_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.backend_servers, 'BackendServers', 'json')
        query = {}
        if not UtilClient.is_unset(request.backend_servers_shrink):
            query['BackendServers'] = request.backend_servers_shrink
        if not UtilClient.is_unset(request.load_balancer_id):
            query['LoadBalancerId'] = request.load_balancer_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddBackendServers',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.AddBackendServersResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_backend_servers_with_options_async(
        self,
        tmp_req: ens_20171110_models.AddBackendServersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.AddBackendServersResponse:
        """
        @summary Adds backend servers.
        
        @description    You can call this operation up to 100 times per second.
        You can call this operation up to 10 times per second per account.
        
        @param tmp_req: AddBackendServersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddBackendServersResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.AddBackendServersShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.backend_servers):
            request.backend_servers_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.backend_servers, 'BackendServers', 'json')
        query = {}
        if not UtilClient.is_unset(request.backend_servers_shrink):
            query['BackendServers'] = request.backend_servers_shrink
        if not UtilClient.is_unset(request.load_balancer_id):
            query['LoadBalancerId'] = request.load_balancer_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddBackendServers',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.AddBackendServersResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_backend_servers(
        self,
        request: ens_20171110_models.AddBackendServersRequest,
    ) -> ens_20171110_models.AddBackendServersResponse:
        """
        @summary Adds backend servers.
        
        @description    You can call this operation up to 100 times per second.
        You can call this operation up to 10 times per second per account.
        
        @param request: AddBackendServersRequest
        @return: AddBackendServersResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_backend_servers_with_options(request, runtime)

    async def add_backend_servers_async(
        self,
        request: ens_20171110_models.AddBackendServersRequest,
    ) -> ens_20171110_models.AddBackendServersResponse:
        """
        @summary Adds backend servers.
        
        @description    You can call this operation up to 100 times per second.
        You can call this operation up to 10 times per second per account.
        
        @param request: AddBackendServersRequest
        @return: AddBackendServersResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_backend_servers_with_options_async(request, runtime)

    def add_network_interface_to_instance_with_options(
        self,
        request: ens_20171110_models.AddNetworkInterfaceToInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.AddNetworkInterfaceToInstanceResponse:
        """
        @summary Adds an IPv6 network interface controller (NIC). A public IP address is automatically assigned at the same time.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 5 times per second per user.
        Internal networks and IPv4 addresses are not supported.
        
        @param request: AddNetworkInterfaceToInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddNetworkInterfaceToInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_start):
            query['AutoStart'] = request.auto_start
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.networks):
            query['Networks'] = request.networks
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddNetworkInterfaceToInstance',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.AddNetworkInterfaceToInstanceResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_network_interface_to_instance_with_options_async(
        self,
        request: ens_20171110_models.AddNetworkInterfaceToInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.AddNetworkInterfaceToInstanceResponse:
        """
        @summary Adds an IPv6 network interface controller (NIC). A public IP address is automatically assigned at the same time.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 5 times per second per user.
        Internal networks and IPv4 addresses are not supported.
        
        @param request: AddNetworkInterfaceToInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddNetworkInterfaceToInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_start):
            query['AutoStart'] = request.auto_start
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.networks):
            query['Networks'] = request.networks
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddNetworkInterfaceToInstance',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.AddNetworkInterfaceToInstanceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_network_interface_to_instance(
        self,
        request: ens_20171110_models.AddNetworkInterfaceToInstanceRequest,
    ) -> ens_20171110_models.AddNetworkInterfaceToInstanceResponse:
        """
        @summary Adds an IPv6 network interface controller (NIC). A public IP address is automatically assigned at the same time.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 5 times per second per user.
        Internal networks and IPv4 addresses are not supported.
        
        @param request: AddNetworkInterfaceToInstanceRequest
        @return: AddNetworkInterfaceToInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_network_interface_to_instance_with_options(request, runtime)

    async def add_network_interface_to_instance_async(
        self,
        request: ens_20171110_models.AddNetworkInterfaceToInstanceRequest,
    ) -> ens_20171110_models.AddNetworkInterfaceToInstanceResponse:
        """
        @summary Adds an IPv6 network interface controller (NIC). A public IP address is automatically assigned at the same time.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 5 times per second per user.
        Internal networks and IPv4 addresses are not supported.
        
        @param request: AddNetworkInterfaceToInstanceRequest
        @return: AddNetworkInterfaceToInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_network_interface_to_instance_with_options_async(request, runtime)

    def add_snat_ip_for_snat_entry_with_options(
        self,
        request: ens_20171110_models.AddSnatIpForSnatEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.AddSnatIpForSnatEntryResponse:
        """
        @summary Adds an elastic IP address (EIP) to a Source Network Address Translation (SNAT) entry.
        
        @param request: AddSnatIpForSnatEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddSnatIpForSnatEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.snat_entry_id):
            query['SnatEntryId'] = request.snat_entry_id
        if not UtilClient.is_unset(request.snat_ip):
            query['SnatIp'] = request.snat_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddSnatIpForSnatEntry',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.AddSnatIpForSnatEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_snat_ip_for_snat_entry_with_options_async(
        self,
        request: ens_20171110_models.AddSnatIpForSnatEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.AddSnatIpForSnatEntryResponse:
        """
        @summary Adds an elastic IP address (EIP) to a Source Network Address Translation (SNAT) entry.
        
        @param request: AddSnatIpForSnatEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddSnatIpForSnatEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.snat_entry_id):
            query['SnatEntryId'] = request.snat_entry_id
        if not UtilClient.is_unset(request.snat_ip):
            query['SnatIp'] = request.snat_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddSnatIpForSnatEntry',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.AddSnatIpForSnatEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_snat_ip_for_snat_entry(
        self,
        request: ens_20171110_models.AddSnatIpForSnatEntryRequest,
    ) -> ens_20171110_models.AddSnatIpForSnatEntryResponse:
        """
        @summary Adds an elastic IP address (EIP) to a Source Network Address Translation (SNAT) entry.
        
        @param request: AddSnatIpForSnatEntryRequest
        @return: AddSnatIpForSnatEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_snat_ip_for_snat_entry_with_options(request, runtime)

    async def add_snat_ip_for_snat_entry_async(
        self,
        request: ens_20171110_models.AddSnatIpForSnatEntryRequest,
    ) -> ens_20171110_models.AddSnatIpForSnatEntryResponse:
        """
        @summary Adds an elastic IP address (EIP) to a Source Network Address Translation (SNAT) entry.
        
        @param request: AddSnatIpForSnatEntryRequest
        @return: AddSnatIpForSnatEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_snat_ip_for_snat_entry_with_options_async(request, runtime)

    def assign_private_ip_addresses_with_options(
        self,
        request: ens_20171110_models.AssignPrivateIpAddressesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.AssignPrivateIpAddressesResponse:
        """
        @summary Assigns secondary private IP addresses to an elastic network interface (ENI).
        
        @param request: AssignPrivateIpAddressesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AssignPrivateIpAddressesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.network_interface_id):
            query['NetworkInterfaceId'] = request.network_interface_id
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssignPrivateIpAddresses',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.AssignPrivateIpAddressesResponse(),
            self.call_api(params, req, runtime)
        )

    async def assign_private_ip_addresses_with_options_async(
        self,
        request: ens_20171110_models.AssignPrivateIpAddressesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.AssignPrivateIpAddressesResponse:
        """
        @summary Assigns secondary private IP addresses to an elastic network interface (ENI).
        
        @param request: AssignPrivateIpAddressesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AssignPrivateIpAddressesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.network_interface_id):
            query['NetworkInterfaceId'] = request.network_interface_id
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssignPrivateIpAddresses',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.AssignPrivateIpAddressesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def assign_private_ip_addresses(
        self,
        request: ens_20171110_models.AssignPrivateIpAddressesRequest,
    ) -> ens_20171110_models.AssignPrivateIpAddressesResponse:
        """
        @summary Assigns secondary private IP addresses to an elastic network interface (ENI).
        
        @param request: AssignPrivateIpAddressesRequest
        @return: AssignPrivateIpAddressesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.assign_private_ip_addresses_with_options(request, runtime)

    async def assign_private_ip_addresses_async(
        self,
        request: ens_20171110_models.AssignPrivateIpAddressesRequest,
    ) -> ens_20171110_models.AssignPrivateIpAddressesResponse:
        """
        @summary Assigns secondary private IP addresses to an elastic network interface (ENI).
        
        @param request: AssignPrivateIpAddressesRequest
        @return: AssignPrivateIpAddressesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.assign_private_ip_addresses_with_options_async(request, runtime)

    def associate_ens_eip_address_with_options(
        self,
        request: ens_20171110_models.AssociateEnsEipAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.AssociateEnsEipAddressResponse:
        """
        @summary Associates an elastic IP address (EIP) with a cloud resource that is deployed in the same region.
        
        @param request: AssociateEnsEipAddressRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AssociateEnsEipAddressResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.allocation_id):
            query['AllocationId'] = request.allocation_id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.standby):
            query['Standby'] = request.standby
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateEnsEipAddress',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.AssociateEnsEipAddressResponse(),
            self.call_api(params, req, runtime)
        )

    async def associate_ens_eip_address_with_options_async(
        self,
        request: ens_20171110_models.AssociateEnsEipAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.AssociateEnsEipAddressResponse:
        """
        @summary Associates an elastic IP address (EIP) with a cloud resource that is deployed in the same region.
        
        @param request: AssociateEnsEipAddressRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AssociateEnsEipAddressResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.allocation_id):
            query['AllocationId'] = request.allocation_id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.standby):
            query['Standby'] = request.standby
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateEnsEipAddress',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.AssociateEnsEipAddressResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def associate_ens_eip_address(
        self,
        request: ens_20171110_models.AssociateEnsEipAddressRequest,
    ) -> ens_20171110_models.AssociateEnsEipAddressResponse:
        """
        @summary Associates an elastic IP address (EIP) with a cloud resource that is deployed in the same region.
        
        @param request: AssociateEnsEipAddressRequest
        @return: AssociateEnsEipAddressResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.associate_ens_eip_address_with_options(request, runtime)

    async def associate_ens_eip_address_async(
        self,
        request: ens_20171110_models.AssociateEnsEipAddressRequest,
    ) -> ens_20171110_models.AssociateEnsEipAddressResponse:
        """
        @summary Associates an elastic IP address (EIP) with a cloud resource that is deployed in the same region.
        
        @param request: AssociateEnsEipAddressRequest
        @return: AssociateEnsEipAddressResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.associate_ens_eip_address_with_options_async(request, runtime)

    def associate_ha_vip_with_options(
        self,
        request: ens_20171110_models.AssociateHaVipRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.AssociateHaVipResponse:
        """
        @summary Associates a high-availability virtual IP address (HAVIP) with an Edge Node Service (ENS) instance or elastic network interface (ENI).
        
        @description When you call this operation to associate an HAVIP, take note of the following items:
        An HAVIP immediately takes effect after it is associated. You do not need to restart the ENS instance. However, you need to associate the HAVIP with the ENI of the ENS instance.
        The HAVIP and ENS instance must belong to the same vSwitch.
        The ENS instance must be in the Running or Stopped state.
        The HAVIP must be in the Available or InUse state.
        AssociateHaVip is an asynchronous operation. After a request is sent, the system returns a request ID and runs the task in the background. You can call the DescribeHaVips operation to query the status of an HAVIP:
        If the HAVIP is in the Associating state, the HAVIP is being associated.
        <!---->
        If the HAVIP is in the InUse state, the HAVIP is associated.
        
        @param request: AssociateHaVipRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AssociateHaVipResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ha_vip_id):
            query['HaVipId'] = request.ha_vip_id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateHaVip',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.AssociateHaVipResponse(),
            self.call_api(params, req, runtime)
        )

    async def associate_ha_vip_with_options_async(
        self,
        request: ens_20171110_models.AssociateHaVipRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.AssociateHaVipResponse:
        """
        @summary Associates a high-availability virtual IP address (HAVIP) with an Edge Node Service (ENS) instance or elastic network interface (ENI).
        
        @description When you call this operation to associate an HAVIP, take note of the following items:
        An HAVIP immediately takes effect after it is associated. You do not need to restart the ENS instance. However, you need to associate the HAVIP with the ENI of the ENS instance.
        The HAVIP and ENS instance must belong to the same vSwitch.
        The ENS instance must be in the Running or Stopped state.
        The HAVIP must be in the Available or InUse state.
        AssociateHaVip is an asynchronous operation. After a request is sent, the system returns a request ID and runs the task in the background. You can call the DescribeHaVips operation to query the status of an HAVIP:
        If the HAVIP is in the Associating state, the HAVIP is being associated.
        <!---->
        If the HAVIP is in the InUse state, the HAVIP is associated.
        
        @param request: AssociateHaVipRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AssociateHaVipResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ha_vip_id):
            query['HaVipId'] = request.ha_vip_id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateHaVip',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.AssociateHaVipResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def associate_ha_vip(
        self,
        request: ens_20171110_models.AssociateHaVipRequest,
    ) -> ens_20171110_models.AssociateHaVipResponse:
        """
        @summary Associates a high-availability virtual IP address (HAVIP) with an Edge Node Service (ENS) instance or elastic network interface (ENI).
        
        @description When you call this operation to associate an HAVIP, take note of the following items:
        An HAVIP immediately takes effect after it is associated. You do not need to restart the ENS instance. However, you need to associate the HAVIP with the ENI of the ENS instance.
        The HAVIP and ENS instance must belong to the same vSwitch.
        The ENS instance must be in the Running or Stopped state.
        The HAVIP must be in the Available or InUse state.
        AssociateHaVip is an asynchronous operation. After a request is sent, the system returns a request ID and runs the task in the background. You can call the DescribeHaVips operation to query the status of an HAVIP:
        If the HAVIP is in the Associating state, the HAVIP is being associated.
        <!---->
        If the HAVIP is in the InUse state, the HAVIP is associated.
        
        @param request: AssociateHaVipRequest
        @return: AssociateHaVipResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.associate_ha_vip_with_options(request, runtime)

    async def associate_ha_vip_async(
        self,
        request: ens_20171110_models.AssociateHaVipRequest,
    ) -> ens_20171110_models.AssociateHaVipResponse:
        """
        @summary Associates a high-availability virtual IP address (HAVIP) with an Edge Node Service (ENS) instance or elastic network interface (ENI).
        
        @description When you call this operation to associate an HAVIP, take note of the following items:
        An HAVIP immediately takes effect after it is associated. You do not need to restart the ENS instance. However, you need to associate the HAVIP with the ENI of the ENS instance.
        The HAVIP and ENS instance must belong to the same vSwitch.
        The ENS instance must be in the Running or Stopped state.
        The HAVIP must be in the Available or InUse state.
        AssociateHaVip is an asynchronous operation. After a request is sent, the system returns a request ID and runs the task in the background. You can call the DescribeHaVips operation to query the status of an HAVIP:
        If the HAVIP is in the Associating state, the HAVIP is being associated.
        <!---->
        If the HAVIP is in the InUse state, the HAVIP is associated.
        
        @param request: AssociateHaVipRequest
        @return: AssociateHaVipResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.associate_ha_vip_with_options_async(request, runtime)

    def attach_disk_with_options(
        self,
        request: ens_20171110_models.AttachDiskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.AttachDiskResponse:
        """
        @summary Attaches a disk to an Edge Node Service (ENS) instance.
        
        @param request: AttachDiskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AttachDiskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.delete_with_instance):
            query['DeleteWithInstance'] = request.delete_with_instance
        if not UtilClient.is_unset(request.disk_id):
            query['DiskId'] = request.disk_id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AttachDisk',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.AttachDiskResponse(),
            self.call_api(params, req, runtime)
        )

    async def attach_disk_with_options_async(
        self,
        request: ens_20171110_models.AttachDiskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.AttachDiskResponse:
        """
        @summary Attaches a disk to an Edge Node Service (ENS) instance.
        
        @param request: AttachDiskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AttachDiskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.delete_with_instance):
            query['DeleteWithInstance'] = request.delete_with_instance
        if not UtilClient.is_unset(request.disk_id):
            query['DiskId'] = request.disk_id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AttachDisk',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.AttachDiskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def attach_disk(
        self,
        request: ens_20171110_models.AttachDiskRequest,
    ) -> ens_20171110_models.AttachDiskResponse:
        """
        @summary Attaches a disk to an Edge Node Service (ENS) instance.
        
        @param request: AttachDiskRequest
        @return: AttachDiskResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.attach_disk_with_options(request, runtime)

    async def attach_disk_async(
        self,
        request: ens_20171110_models.AttachDiskRequest,
    ) -> ens_20171110_models.AttachDiskResponse:
        """
        @summary Attaches a disk to an Edge Node Service (ENS) instance.
        
        @param request: AttachDiskRequest
        @return: AttachDiskResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.attach_disk_with_options_async(request, runtime)

    def attach_ens_instances_with_options(
        self,
        request: ens_20171110_models.AttachEnsInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.AttachEnsInstancesResponse:
        """
        @summary Adds an Edge Node Service (ENS) instance to Container Service for Kubernetes (ACK).
        
        @description # [](#)Usage notes
        You can call this operation up to 10 times per second per account.
        After you execute the command, the instance restarts loading.
        Limits: The instance has at least two vCPUs and 4 GB memory. An image of CentOS 7.4 or later is required.
        
        @param request: AttachEnsInstancesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AttachEnsInstancesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.scripts):
            query['Scripts'] = request.scripts
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AttachEnsInstances',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.AttachEnsInstancesResponse(),
            self.call_api(params, req, runtime)
        )

    async def attach_ens_instances_with_options_async(
        self,
        request: ens_20171110_models.AttachEnsInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.AttachEnsInstancesResponse:
        """
        @summary Adds an Edge Node Service (ENS) instance to Container Service for Kubernetes (ACK).
        
        @description # [](#)Usage notes
        You can call this operation up to 10 times per second per account.
        After you execute the command, the instance restarts loading.
        Limits: The instance has at least two vCPUs and 4 GB memory. An image of CentOS 7.4 or later is required.
        
        @param request: AttachEnsInstancesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AttachEnsInstancesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.scripts):
            query['Scripts'] = request.scripts
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AttachEnsInstances',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.AttachEnsInstancesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def attach_ens_instances(
        self,
        request: ens_20171110_models.AttachEnsInstancesRequest,
    ) -> ens_20171110_models.AttachEnsInstancesResponse:
        """
        @summary Adds an Edge Node Service (ENS) instance to Container Service for Kubernetes (ACK).
        
        @description # [](#)Usage notes
        You can call this operation up to 10 times per second per account.
        After you execute the command, the instance restarts loading.
        Limits: The instance has at least two vCPUs and 4 GB memory. An image of CentOS 7.4 or later is required.
        
        @param request: AttachEnsInstancesRequest
        @return: AttachEnsInstancesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.attach_ens_instances_with_options(request, runtime)

    async def attach_ens_instances_async(
        self,
        request: ens_20171110_models.AttachEnsInstancesRequest,
    ) -> ens_20171110_models.AttachEnsInstancesResponse:
        """
        @summary Adds an Edge Node Service (ENS) instance to Container Service for Kubernetes (ACK).
        
        @description # [](#)Usage notes
        You can call this operation up to 10 times per second per account.
        After you execute the command, the instance restarts loading.
        Limits: The instance has at least two vCPUs and 4 GB memory. An image of CentOS 7.4 or later is required.
        
        @param request: AttachEnsInstancesRequest
        @return: AttachEnsInstancesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.attach_ens_instances_with_options_async(request, runtime)

    def attach_instance_sdgwith_options(
        self,
        tmp_req: ens_20171110_models.AttachInstanceSDGRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.AttachInstanceSDGResponse:
        """
        @summary Attaches a shared data group (SDG) to the corresponding Android in Container (AIC) instance.
        
        @param tmp_req: AttachInstanceSDGRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AttachInstanceSDGResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.AttachInstanceSDGShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.instance_ids):
            request.instance_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.instance_ids, 'InstanceIds', 'json')
        if not UtilClient.is_unset(tmp_req.load_opt):
            request.load_opt_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.load_opt, 'LoadOpt', 'json')
        query = {}
        if not UtilClient.is_unset(request.disk_access_protocol):
            query['DiskAccessProtocol'] = request.disk_access_protocol
        if not UtilClient.is_unset(request.disk_type):
            query['DiskType'] = request.disk_type
        if not UtilClient.is_unset(request.instance_ids_shrink):
            query['InstanceIds'] = request.instance_ids_shrink
        if not UtilClient.is_unset(request.load_opt_shrink):
            query['LoadOpt'] = request.load_opt_shrink
        if not UtilClient.is_unset(request.sdgid):
            query['SDGId'] = request.sdgid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AttachInstanceSDG',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.AttachInstanceSDGResponse(),
            self.call_api(params, req, runtime)
        )

    async def attach_instance_sdgwith_options_async(
        self,
        tmp_req: ens_20171110_models.AttachInstanceSDGRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.AttachInstanceSDGResponse:
        """
        @summary Attaches a shared data group (SDG) to the corresponding Android in Container (AIC) instance.
        
        @param tmp_req: AttachInstanceSDGRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AttachInstanceSDGResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.AttachInstanceSDGShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.instance_ids):
            request.instance_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.instance_ids, 'InstanceIds', 'json')
        if not UtilClient.is_unset(tmp_req.load_opt):
            request.load_opt_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.load_opt, 'LoadOpt', 'json')
        query = {}
        if not UtilClient.is_unset(request.disk_access_protocol):
            query['DiskAccessProtocol'] = request.disk_access_protocol
        if not UtilClient.is_unset(request.disk_type):
            query['DiskType'] = request.disk_type
        if not UtilClient.is_unset(request.instance_ids_shrink):
            query['InstanceIds'] = request.instance_ids_shrink
        if not UtilClient.is_unset(request.load_opt_shrink):
            query['LoadOpt'] = request.load_opt_shrink
        if not UtilClient.is_unset(request.sdgid):
            query['SDGId'] = request.sdgid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AttachInstanceSDG',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.AttachInstanceSDGResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def attach_instance_sdg(
        self,
        request: ens_20171110_models.AttachInstanceSDGRequest,
    ) -> ens_20171110_models.AttachInstanceSDGResponse:
        """
        @summary Attaches a shared data group (SDG) to the corresponding Android in Container (AIC) instance.
        
        @param request: AttachInstanceSDGRequest
        @return: AttachInstanceSDGResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.attach_instance_sdgwith_options(request, runtime)

    async def attach_instance_sdg_async(
        self,
        request: ens_20171110_models.AttachInstanceSDGRequest,
    ) -> ens_20171110_models.AttachInstanceSDGResponse:
        """
        @summary Attaches a shared data group (SDG) to the corresponding Android in Container (AIC) instance.
        
        @param request: AttachInstanceSDGRequest
        @return: AttachInstanceSDGResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.attach_instance_sdgwith_options_async(request, runtime)

    def attach_network_interface_with_options(
        self,
        request: ens_20171110_models.AttachNetworkInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.AttachNetworkInterfaceResponse:
        """
        @summary Attaches an Elastic Network Interface (ENI) to an Edge Node Service (ECS) instance.
        
        @description When you call this operation, take note of the following limits:
        The ENI must be in the Available state.
        An ENI can be attached to only one instance that is the same zone and the same Virtual Private Cloud (VPC).
        The instance must be in the Stopped state.
        A maximum of 10 ENIs can be attached to an instance.
        This operation is an asynchronous operation. After you call this operation to attach an ENI, you can view the status of the ENI to check whether the ENI is attached.
        
        @param request: AttachNetworkInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AttachNetworkInterfaceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.network_interface_id):
            query['NetworkInterfaceId'] = request.network_interface_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AttachNetworkInterface',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.AttachNetworkInterfaceResponse(),
            self.call_api(params, req, runtime)
        )

    async def attach_network_interface_with_options_async(
        self,
        request: ens_20171110_models.AttachNetworkInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.AttachNetworkInterfaceResponse:
        """
        @summary Attaches an Elastic Network Interface (ENI) to an Edge Node Service (ECS) instance.
        
        @description When you call this operation, take note of the following limits:
        The ENI must be in the Available state.
        An ENI can be attached to only one instance that is the same zone and the same Virtual Private Cloud (VPC).
        The instance must be in the Stopped state.
        A maximum of 10 ENIs can be attached to an instance.
        This operation is an asynchronous operation. After you call this operation to attach an ENI, you can view the status of the ENI to check whether the ENI is attached.
        
        @param request: AttachNetworkInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AttachNetworkInterfaceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.network_interface_id):
            query['NetworkInterfaceId'] = request.network_interface_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AttachNetworkInterface',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.AttachNetworkInterfaceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def attach_network_interface(
        self,
        request: ens_20171110_models.AttachNetworkInterfaceRequest,
    ) -> ens_20171110_models.AttachNetworkInterfaceResponse:
        """
        @summary Attaches an Elastic Network Interface (ENI) to an Edge Node Service (ECS) instance.
        
        @description When you call this operation, take note of the following limits:
        The ENI must be in the Available state.
        An ENI can be attached to only one instance that is the same zone and the same Virtual Private Cloud (VPC).
        The instance must be in the Stopped state.
        A maximum of 10 ENIs can be attached to an instance.
        This operation is an asynchronous operation. After you call this operation to attach an ENI, you can view the status of the ENI to check whether the ENI is attached.
        
        @param request: AttachNetworkInterfaceRequest
        @return: AttachNetworkInterfaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.attach_network_interface_with_options(request, runtime)

    async def attach_network_interface_async(
        self,
        request: ens_20171110_models.AttachNetworkInterfaceRequest,
    ) -> ens_20171110_models.AttachNetworkInterfaceResponse:
        """
        @summary Attaches an Elastic Network Interface (ENI) to an Edge Node Service (ECS) instance.
        
        @description When you call this operation, take note of the following limits:
        The ENI must be in the Available state.
        An ENI can be attached to only one instance that is the same zone and the same Virtual Private Cloud (VPC).
        The instance must be in the Stopped state.
        A maximum of 10 ENIs can be attached to an instance.
        This operation is an asynchronous operation. After you call this operation to attach an ENI, you can view the status of the ENI to check whether the ENI is attached.
        
        @param request: AttachNetworkInterfaceRequest
        @return: AttachNetworkInterfaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.attach_network_interface_with_options_async(request, runtime)

    def authorize_security_group_with_options(
        self,
        request: ens_20171110_models.AuthorizeSecurityGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.AuthorizeSecurityGroupResponse:
        """
        @summary Creates an inbound security group rule. This operation allows or denies the inbound traffic from other devices to instances in the security group.
        
        @param request: AuthorizeSecurityGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AuthorizeSecurityGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ip_protocol):
            query['IpProtocol'] = request.ip_protocol
        if not UtilClient.is_unset(request.policy):
            query['Policy'] = request.policy
        if not UtilClient.is_unset(request.port_range):
            query['PortRange'] = request.port_range
        if not UtilClient.is_unset(request.priority):
            query['Priority'] = request.priority
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        if not UtilClient.is_unset(request.source_cidr_ip):
            query['SourceCidrIp'] = request.source_cidr_ip
        if not UtilClient.is_unset(request.source_port_range):
            query['SourcePortRange'] = request.source_port_range
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AuthorizeSecurityGroup',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.AuthorizeSecurityGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def authorize_security_group_with_options_async(
        self,
        request: ens_20171110_models.AuthorizeSecurityGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.AuthorizeSecurityGroupResponse:
        """
        @summary Creates an inbound security group rule. This operation allows or denies the inbound traffic from other devices to instances in the security group.
        
        @param request: AuthorizeSecurityGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AuthorizeSecurityGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ip_protocol):
            query['IpProtocol'] = request.ip_protocol
        if not UtilClient.is_unset(request.policy):
            query['Policy'] = request.policy
        if not UtilClient.is_unset(request.port_range):
            query['PortRange'] = request.port_range
        if not UtilClient.is_unset(request.priority):
            query['Priority'] = request.priority
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        if not UtilClient.is_unset(request.source_cidr_ip):
            query['SourceCidrIp'] = request.source_cidr_ip
        if not UtilClient.is_unset(request.source_port_range):
            query['SourcePortRange'] = request.source_port_range
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AuthorizeSecurityGroup',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.AuthorizeSecurityGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def authorize_security_group(
        self,
        request: ens_20171110_models.AuthorizeSecurityGroupRequest,
    ) -> ens_20171110_models.AuthorizeSecurityGroupResponse:
        """
        @summary Creates an inbound security group rule. This operation allows or denies the inbound traffic from other devices to instances in the security group.
        
        @param request: AuthorizeSecurityGroupRequest
        @return: AuthorizeSecurityGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.authorize_security_group_with_options(request, runtime)

    async def authorize_security_group_async(
        self,
        request: ens_20171110_models.AuthorizeSecurityGroupRequest,
    ) -> ens_20171110_models.AuthorizeSecurityGroupResponse:
        """
        @summary Creates an inbound security group rule. This operation allows or denies the inbound traffic from other devices to instances in the security group.
        
        @param request: AuthorizeSecurityGroupRequest
        @return: AuthorizeSecurityGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.authorize_security_group_with_options_async(request, runtime)

    def authorize_security_group_egress_with_options(
        self,
        request: ens_20171110_models.AuthorizeSecurityGroupEgressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.AuthorizeSecurityGroupEgressResponse:
        """
        @summary Creates an outbound security group rule. This operation allows or denies the outbound traffic from the instances in the security group to other devices.
        
        @description In the security group-related API documents, outbound traffic refers to the traffic that is sent by the source device and received at the destination device.
        
        @param request: AuthorizeSecurityGroupEgressRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AuthorizeSecurityGroupEgressResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dest_cidr_ip):
            query['DestCidrIp'] = request.dest_cidr_ip
        if not UtilClient.is_unset(request.ip_protocol):
            query['IpProtocol'] = request.ip_protocol
        if not UtilClient.is_unset(request.policy):
            query['Policy'] = request.policy
        if not UtilClient.is_unset(request.port_range):
            query['PortRange'] = request.port_range
        if not UtilClient.is_unset(request.priority):
            query['Priority'] = request.priority
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        if not UtilClient.is_unset(request.source_port_range):
            query['SourcePortRange'] = request.source_port_range
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AuthorizeSecurityGroupEgress',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.AuthorizeSecurityGroupEgressResponse(),
            self.call_api(params, req, runtime)
        )

    async def authorize_security_group_egress_with_options_async(
        self,
        request: ens_20171110_models.AuthorizeSecurityGroupEgressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.AuthorizeSecurityGroupEgressResponse:
        """
        @summary Creates an outbound security group rule. This operation allows or denies the outbound traffic from the instances in the security group to other devices.
        
        @description In the security group-related API documents, outbound traffic refers to the traffic that is sent by the source device and received at the destination device.
        
        @param request: AuthorizeSecurityGroupEgressRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AuthorizeSecurityGroupEgressResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dest_cidr_ip):
            query['DestCidrIp'] = request.dest_cidr_ip
        if not UtilClient.is_unset(request.ip_protocol):
            query['IpProtocol'] = request.ip_protocol
        if not UtilClient.is_unset(request.policy):
            query['Policy'] = request.policy
        if not UtilClient.is_unset(request.port_range):
            query['PortRange'] = request.port_range
        if not UtilClient.is_unset(request.priority):
            query['Priority'] = request.priority
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        if not UtilClient.is_unset(request.source_port_range):
            query['SourcePortRange'] = request.source_port_range
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AuthorizeSecurityGroupEgress',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.AuthorizeSecurityGroupEgressResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def authorize_security_group_egress(
        self,
        request: ens_20171110_models.AuthorizeSecurityGroupEgressRequest,
    ) -> ens_20171110_models.AuthorizeSecurityGroupEgressResponse:
        """
        @summary Creates an outbound security group rule. This operation allows or denies the outbound traffic from the instances in the security group to other devices.
        
        @description In the security group-related API documents, outbound traffic refers to the traffic that is sent by the source device and received at the destination device.
        
        @param request: AuthorizeSecurityGroupEgressRequest
        @return: AuthorizeSecurityGroupEgressResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.authorize_security_group_egress_with_options(request, runtime)

    async def authorize_security_group_egress_async(
        self,
        request: ens_20171110_models.AuthorizeSecurityGroupEgressRequest,
    ) -> ens_20171110_models.AuthorizeSecurityGroupEgressResponse:
        """
        @summary Creates an outbound security group rule. This operation allows or denies the outbound traffic from the instances in the security group to other devices.
        
        @description In the security group-related API documents, outbound traffic refers to the traffic that is sent by the source device and received at the destination device.
        
        @param request: AuthorizeSecurityGroupEgressRequest
        @return: AuthorizeSecurityGroupEgressResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.authorize_security_group_egress_with_options_async(request, runtime)

    def clean_dist_data_with_options(
        self,
        request: ens_20171110_models.CleanDistDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CleanDistDataResponse:
        """
        @summary 清理分发数据
        
        @param request: CleanDistDataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CleanDistDataResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.data_name):
            query['DataName'] = request.data_name
        if not UtilClient.is_unset(request.data_version):
            query['DataVersion'] = request.data_version
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CleanDistData',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CleanDistDataResponse(),
            self.call_api(params, req, runtime)
        )

    async def clean_dist_data_with_options_async(
        self,
        request: ens_20171110_models.CleanDistDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CleanDistDataResponse:
        """
        @summary 清理分发数据
        
        @param request: CleanDistDataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CleanDistDataResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.data_name):
            query['DataName'] = request.data_name
        if not UtilClient.is_unset(request.data_version):
            query['DataVersion'] = request.data_version
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CleanDistData',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CleanDistDataResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def clean_dist_data(
        self,
        request: ens_20171110_models.CleanDistDataRequest,
    ) -> ens_20171110_models.CleanDistDataResponse:
        """
        @summary 清理分发数据
        
        @param request: CleanDistDataRequest
        @return: CleanDistDataResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.clean_dist_data_with_options(request, runtime)

    async def clean_dist_data_async(
        self,
        request: ens_20171110_models.CleanDistDataRequest,
    ) -> ens_20171110_models.CleanDistDataResponse:
        """
        @summary 清理分发数据
        
        @param request: CleanDistDataRequest
        @return: CleanDistDataResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.clean_dist_data_with_options_async(request, runtime)

    def copy_sdgwith_options(
        self,
        tmp_req: ens_20171110_models.CopySDGRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CopySDGResponse:
        """
        @summary Copies a shared data group (SDG) across nodes.
        
        @param tmp_req: CopySDGRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CopySDGResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.CopySDGShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.destination_region_ids):
            request.destination_region_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.destination_region_ids, 'DestinationRegionIds', 'json')
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CopySDG',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CopySDGResponse(),
            self.call_api(params, req, runtime)
        )

    async def copy_sdgwith_options_async(
        self,
        tmp_req: ens_20171110_models.CopySDGRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CopySDGResponse:
        """
        @summary Copies a shared data group (SDG) across nodes.
        
        @param tmp_req: CopySDGRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CopySDGResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.CopySDGShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.destination_region_ids):
            request.destination_region_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.destination_region_ids, 'DestinationRegionIds', 'json')
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CopySDG',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CopySDGResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def copy_sdg(
        self,
        request: ens_20171110_models.CopySDGRequest,
    ) -> ens_20171110_models.CopySDGResponse:
        """
        @summary Copies a shared data group (SDG) across nodes.
        
        @param request: CopySDGRequest
        @return: CopySDGResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.copy_sdgwith_options(request, runtime)

    async def copy_sdg_async(
        self,
        request: ens_20171110_models.CopySDGRequest,
    ) -> ens_20171110_models.CopySDGResponse:
        """
        @summary Copies a shared data group (SDG) across nodes.
        
        @param request: CopySDGRequest
        @return: CopySDGResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.copy_sdgwith_options_async(request, runtime)

    def copy_snapshot_with_options(
        self,
        tmp_req: ens_20171110_models.CopySnapshotRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CopySnapshotResponse:
        """
        @summary Copies a snapshot across nodes.
        
        @param tmp_req: CopySnapshotRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CopySnapshotResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.CopySnapshotShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.destination_region_ids):
            request.destination_region_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.destination_region_ids, 'DestinationRegionIds', 'json')
        query = {}
        if not UtilClient.is_unset(request.destination_region_ids_shrink):
            query['DestinationRegionIds'] = request.destination_region_ids_shrink
        if not UtilClient.is_unset(request.destination_snapshot_description):
            query['DestinationSnapshotDescription'] = request.destination_snapshot_description
        if not UtilClient.is_unset(request.destination_snapshot_name):
            query['DestinationSnapshotName'] = request.destination_snapshot_name
        if not UtilClient.is_unset(request.instance_billing_cycle):
            query['InstanceBillingCycle'] = request.instance_billing_cycle
        if not UtilClient.is_unset(request.snapshot_id):
            query['SnapshotId'] = request.snapshot_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CopySnapshot',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CopySnapshotResponse(),
            self.call_api(params, req, runtime)
        )

    async def copy_snapshot_with_options_async(
        self,
        tmp_req: ens_20171110_models.CopySnapshotRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CopySnapshotResponse:
        """
        @summary Copies a snapshot across nodes.
        
        @param tmp_req: CopySnapshotRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CopySnapshotResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.CopySnapshotShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.destination_region_ids):
            request.destination_region_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.destination_region_ids, 'DestinationRegionIds', 'json')
        query = {}
        if not UtilClient.is_unset(request.destination_region_ids_shrink):
            query['DestinationRegionIds'] = request.destination_region_ids_shrink
        if not UtilClient.is_unset(request.destination_snapshot_description):
            query['DestinationSnapshotDescription'] = request.destination_snapshot_description
        if not UtilClient.is_unset(request.destination_snapshot_name):
            query['DestinationSnapshotName'] = request.destination_snapshot_name
        if not UtilClient.is_unset(request.instance_billing_cycle):
            query['InstanceBillingCycle'] = request.instance_billing_cycle
        if not UtilClient.is_unset(request.snapshot_id):
            query['SnapshotId'] = request.snapshot_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CopySnapshot',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CopySnapshotResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def copy_snapshot(
        self,
        request: ens_20171110_models.CopySnapshotRequest,
    ) -> ens_20171110_models.CopySnapshotResponse:
        """
        @summary Copies a snapshot across nodes.
        
        @param request: CopySnapshotRequest
        @return: CopySnapshotResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.copy_snapshot_with_options(request, runtime)

    async def copy_snapshot_async(
        self,
        request: ens_20171110_models.CopySnapshotRequest,
    ) -> ens_20171110_models.CopySnapshotResponse:
        """
        @summary Copies a snapshot across nodes.
        
        @param request: CopySnapshotRequest
        @return: CopySnapshotResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.copy_snapshot_with_options_async(request, runtime)

    def create_armserver_instances_with_options(
        self,
        request: ens_20171110_models.CreateARMServerInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateARMServerInstancesResponse:
        """
        @summary Creates an ARM server.
        
        @param request: CreateARMServerInstancesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateARMServerInstancesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.amount):
            query['Amount'] = request.amount
        if not UtilClient.is_unset(request.auto_renew):
            query['AutoRenew'] = request.auto_renew
        if not UtilClient.is_unset(request.auto_use_coupon):
            query['AutoUseCoupon'] = request.auto_use_coupon
        if not UtilClient.is_unset(request.cidr):
            query['Cidr'] = request.cidr
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.environment_var):
            query['EnvironmentVar'] = request.environment_var
        if not UtilClient.is_unset(request.frequency):
            query['Frequency'] = request.frequency
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.instance_billing_cycle):
            query['InstanceBillingCycle'] = request.instance_billing_cycle
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.key_pair_name):
            query['KeyPairName'] = request.key_pair_name
        if not UtilClient.is_unset(request.name_space):
            query['NameSpace'] = request.name_space
        if not UtilClient.is_unset(request.pay_type):
            query['PayType'] = request.pay_type
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.resolution):
            query['Resolution'] = request.resolution
        if not UtilClient.is_unset(request.server_name):
            query['ServerName'] = request.server_name
        if not UtilClient.is_unset(request.server_type):
            query['ServerType'] = request.server_type
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateARMServerInstances',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateARMServerInstancesResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_armserver_instances_with_options_async(
        self,
        request: ens_20171110_models.CreateARMServerInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateARMServerInstancesResponse:
        """
        @summary Creates an ARM server.
        
        @param request: CreateARMServerInstancesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateARMServerInstancesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.amount):
            query['Amount'] = request.amount
        if not UtilClient.is_unset(request.auto_renew):
            query['AutoRenew'] = request.auto_renew
        if not UtilClient.is_unset(request.auto_use_coupon):
            query['AutoUseCoupon'] = request.auto_use_coupon
        if not UtilClient.is_unset(request.cidr):
            query['Cidr'] = request.cidr
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.environment_var):
            query['EnvironmentVar'] = request.environment_var
        if not UtilClient.is_unset(request.frequency):
            query['Frequency'] = request.frequency
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.instance_billing_cycle):
            query['InstanceBillingCycle'] = request.instance_billing_cycle
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.key_pair_name):
            query['KeyPairName'] = request.key_pair_name
        if not UtilClient.is_unset(request.name_space):
            query['NameSpace'] = request.name_space
        if not UtilClient.is_unset(request.pay_type):
            query['PayType'] = request.pay_type
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.resolution):
            query['Resolution'] = request.resolution
        if not UtilClient.is_unset(request.server_name):
            query['ServerName'] = request.server_name
        if not UtilClient.is_unset(request.server_type):
            query['ServerType'] = request.server_type
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateARMServerInstances',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateARMServerInstancesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_armserver_instances(
        self,
        request: ens_20171110_models.CreateARMServerInstancesRequest,
    ) -> ens_20171110_models.CreateARMServerInstancesResponse:
        """
        @summary Creates an ARM server.
        
        @param request: CreateARMServerInstancesRequest
        @return: CreateARMServerInstancesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_armserver_instances_with_options(request, runtime)

    async def create_armserver_instances_async(
        self,
        request: ens_20171110_models.CreateARMServerInstancesRequest,
    ) -> ens_20171110_models.CreateARMServerInstancesResponse:
        """
        @summary Creates an ARM server.
        
        @param request: CreateARMServerInstancesRequest
        @return: CreateARMServerInstancesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_armserver_instances_with_options_async(request, runtime)

    def create_application_with_options(
        self,
        request: ens_20171110_models.CreateApplicationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateApplicationResponse:
        """
        @summary Creates an edge application that allows you to manage Edge Node Service (ENS) nodes in containers, bare metal instances, and virtual machines.
        
        @param request: CreateApplicationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateApplicationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.template):
            query['Template'] = request.template
        if not UtilClient.is_unset(request.timeout):
            query['Timeout'] = request.timeout
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateApplication',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateApplicationResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_application_with_options_async(
        self,
        request: ens_20171110_models.CreateApplicationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateApplicationResponse:
        """
        @summary Creates an edge application that allows you to manage Edge Node Service (ENS) nodes in containers, bare metal instances, and virtual machines.
        
        @param request: CreateApplicationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateApplicationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.template):
            query['Template'] = request.template
        if not UtilClient.is_unset(request.timeout):
            query['Timeout'] = request.timeout
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateApplication',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateApplicationResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_application(
        self,
        request: ens_20171110_models.CreateApplicationRequest,
    ) -> ens_20171110_models.CreateApplicationResponse:
        """
        @summary Creates an edge application that allows you to manage Edge Node Service (ENS) nodes in containers, bare metal instances, and virtual machines.
        
        @param request: CreateApplicationRequest
        @return: CreateApplicationResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_application_with_options(request, runtime)

    async def create_application_async(
        self,
        request: ens_20171110_models.CreateApplicationRequest,
    ) -> ens_20171110_models.CreateApplicationResponse:
        """
        @summary Creates an edge application that allows you to manage Edge Node Service (ENS) nodes in containers, bare metal instances, and virtual machines.
        
        @param request: CreateApplicationRequest
        @return: CreateApplicationResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_application_with_options_async(request, runtime)

    def create_classic_network_with_options(
        self,
        request: ens_20171110_models.CreateClassicNetworkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateClassicNetworkResponse:
        """
        @summary Creates a classic network
        
        @param request: CreateClassicNetworkRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateClassicNetworkResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cidr_block):
            query['CidrBlock'] = request.cidr_block
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.network_name):
            query['NetworkName'] = request.network_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateClassicNetwork',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateClassicNetworkResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_classic_network_with_options_async(
        self,
        request: ens_20171110_models.CreateClassicNetworkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateClassicNetworkResponse:
        """
        @summary Creates a classic network
        
        @param request: CreateClassicNetworkRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateClassicNetworkResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cidr_block):
            query['CidrBlock'] = request.cidr_block
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.network_name):
            query['NetworkName'] = request.network_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateClassicNetwork',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateClassicNetworkResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_classic_network(
        self,
        request: ens_20171110_models.CreateClassicNetworkRequest,
    ) -> ens_20171110_models.CreateClassicNetworkResponse:
        """
        @summary Creates a classic network
        
        @param request: CreateClassicNetworkRequest
        @return: CreateClassicNetworkResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_classic_network_with_options(request, runtime)

    async def create_classic_network_async(
        self,
        request: ens_20171110_models.CreateClassicNetworkRequest,
    ) -> ens_20171110_models.CreateClassicNetworkResponse:
        """
        @summary Creates a classic network
        
        @param request: CreateClassicNetworkRequest
        @return: CreateClassicNetworkResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_classic_network_with_options_async(request, runtime)

    def create_cluster_with_options(
        self,
        request: ens_20171110_models.CreateClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateClusterResponse:
        """
        @summary Creates a Container Service for Kubernetes (ACK) edge cluster.
        
        @description    You can call this operation up to 10 times per second per account.
        Creating a cluster is an asynchronous operation. After this operation returns the response, it takes 10 to 20 minutes to initialize the cluster. You can call the DescribeCluster operation to query the cluster status. After you create a cluster, you can call the DescribeClusterKubeConfig operation to obtain the cluster certificate.
        
        @param request: CreateClusterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateClusterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_version):
            query['ClusterVersion'] = request.cluster_version
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCluster',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateClusterResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_cluster_with_options_async(
        self,
        request: ens_20171110_models.CreateClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateClusterResponse:
        """
        @summary Creates a Container Service for Kubernetes (ACK) edge cluster.
        
        @description    You can call this operation up to 10 times per second per account.
        Creating a cluster is an asynchronous operation. After this operation returns the response, it takes 10 to 20 minutes to initialize the cluster. You can call the DescribeCluster operation to query the cluster status. After you create a cluster, you can call the DescribeClusterKubeConfig operation to obtain the cluster certificate.
        
        @param request: CreateClusterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateClusterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_version):
            query['ClusterVersion'] = request.cluster_version
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCluster',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateClusterResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_cluster(
        self,
        request: ens_20171110_models.CreateClusterRequest,
    ) -> ens_20171110_models.CreateClusterResponse:
        """
        @summary Creates a Container Service for Kubernetes (ACK) edge cluster.
        
        @description    You can call this operation up to 10 times per second per account.
        Creating a cluster is an asynchronous operation. After this operation returns the response, it takes 10 to 20 minutes to initialize the cluster. You can call the DescribeCluster operation to query the cluster status. After you create a cluster, you can call the DescribeClusterKubeConfig operation to obtain the cluster certificate.
        
        @param request: CreateClusterRequest
        @return: CreateClusterResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_cluster_with_options(request, runtime)

    async def create_cluster_async(
        self,
        request: ens_20171110_models.CreateClusterRequest,
    ) -> ens_20171110_models.CreateClusterResponse:
        """
        @summary Creates a Container Service for Kubernetes (ACK) edge cluster.
        
        @description    You can call this operation up to 10 times per second per account.
        Creating a cluster is an asynchronous operation. After this operation returns the response, it takes 10 to 20 minutes to initialize the cluster. You can call the DescribeCluster operation to query the cluster status. After you create a cluster, you can call the DescribeClusterKubeConfig operation to obtain the cluster certificate.
        
        @param request: CreateClusterRequest
        @return: CreateClusterResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_cluster_with_options_async(request, runtime)

    def create_disk_with_options(
        self,
        request: ens_20171110_models.CreateDiskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateDiskResponse:
        """
        @summary Creates a pay-as-you-go or subscription data disk.
        
        @param request: CreateDiskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDiskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.category):
            query['Category'] = request.category
        if not UtilClient.is_unset(request.disk_name):
            query['DiskName'] = request.disk_name
        if not UtilClient.is_unset(request.encrypted):
            query['Encrypted'] = request.encrypted
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.instance_billing_cycle):
            query['InstanceBillingCycle'] = request.instance_billing_cycle
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.kmskey_id):
            query['KMSKeyId'] = request.kmskey_id
        if not UtilClient.is_unset(request.size):
            query['Size'] = request.size
        if not UtilClient.is_unset(request.snapshot_id):
            query['SnapshotId'] = request.snapshot_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDisk',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateDiskResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_disk_with_options_async(
        self,
        request: ens_20171110_models.CreateDiskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateDiskResponse:
        """
        @summary Creates a pay-as-you-go or subscription data disk.
        
        @param request: CreateDiskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDiskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.category):
            query['Category'] = request.category
        if not UtilClient.is_unset(request.disk_name):
            query['DiskName'] = request.disk_name
        if not UtilClient.is_unset(request.encrypted):
            query['Encrypted'] = request.encrypted
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.instance_billing_cycle):
            query['InstanceBillingCycle'] = request.instance_billing_cycle
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.kmskey_id):
            query['KMSKeyId'] = request.kmskey_id
        if not UtilClient.is_unset(request.size):
            query['Size'] = request.size
        if not UtilClient.is_unset(request.snapshot_id):
            query['SnapshotId'] = request.snapshot_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDisk',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateDiskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_disk(
        self,
        request: ens_20171110_models.CreateDiskRequest,
    ) -> ens_20171110_models.CreateDiskResponse:
        """
        @summary Creates a pay-as-you-go or subscription data disk.
        
        @param request: CreateDiskRequest
        @return: CreateDiskResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_disk_with_options(request, runtime)

    async def create_disk_async(
        self,
        request: ens_20171110_models.CreateDiskRequest,
    ) -> ens_20171110_models.CreateDiskResponse:
        """
        @summary Creates a pay-as-you-go or subscription data disk.
        
        @param request: CreateDiskRequest
        @return: CreateDiskResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_disk_with_options_async(request, runtime)

    def create_eip_instance_with_options(
        self,
        request: ens_20171110_models.CreateEipInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateEipInstanceResponse:
        """
        @summary Applies for an elastic IP address (EIP).
        
        @description    You can call this operation up to 5,000 times per second per account.
        You can call this operation up to 50 times per second per user.
        
        @param request: CreateEipInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateEipInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.isp):
            query['Isp'] = request.isp
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateEipInstance',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateEipInstanceResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_eip_instance_with_options_async(
        self,
        request: ens_20171110_models.CreateEipInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateEipInstanceResponse:
        """
        @summary Applies for an elastic IP address (EIP).
        
        @description    You can call this operation up to 5,000 times per second per account.
        You can call this operation up to 50 times per second per user.
        
        @param request: CreateEipInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateEipInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.isp):
            query['Isp'] = request.isp
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateEipInstance',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateEipInstanceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_eip_instance(
        self,
        request: ens_20171110_models.CreateEipInstanceRequest,
    ) -> ens_20171110_models.CreateEipInstanceResponse:
        """
        @summary Applies for an elastic IP address (EIP).
        
        @description    You can call this operation up to 5,000 times per second per account.
        You can call this operation up to 50 times per second per user.
        
        @param request: CreateEipInstanceRequest
        @return: CreateEipInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_eip_instance_with_options(request, runtime)

    async def create_eip_instance_async(
        self,
        request: ens_20171110_models.CreateEipInstanceRequest,
    ) -> ens_20171110_models.CreateEipInstanceResponse:
        """
        @summary Applies for an elastic IP address (EIP).
        
        @description    You can call this operation up to 5,000 times per second per account.
        You can call this operation up to 50 times per second per user.
        
        @param request: CreateEipInstanceRequest
        @return: CreateEipInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_eip_instance_with_options_async(request, runtime)

    def create_ens_route_entry_with_options(
        self,
        request: ens_20171110_models.CreateEnsRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateEnsRouteEntryResponse:
        """
        @summary Creates a custom route entry.
        
        @param request: CreateEnsRouteEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateEnsRouteEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.destination_cidr_block):
            query['DestinationCidrBlock'] = request.destination_cidr_block
        if not UtilClient.is_unset(request.next_hop_id):
            query['NextHopId'] = request.next_hop_id
        if not UtilClient.is_unset(request.next_hop_type):
            query['NextHopType'] = request.next_hop_type
        if not UtilClient.is_unset(request.route_entry_name):
            query['RouteEntryName'] = request.route_entry_name
        if not UtilClient.is_unset(request.route_table_id):
            query['RouteTableId'] = request.route_table_id
        if not UtilClient.is_unset(request.source_cidr_block):
            query['SourceCidrBlock'] = request.source_cidr_block
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateEnsRouteEntry',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateEnsRouteEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_ens_route_entry_with_options_async(
        self,
        request: ens_20171110_models.CreateEnsRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateEnsRouteEntryResponse:
        """
        @summary Creates a custom route entry.
        
        @param request: CreateEnsRouteEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateEnsRouteEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.destination_cidr_block):
            query['DestinationCidrBlock'] = request.destination_cidr_block
        if not UtilClient.is_unset(request.next_hop_id):
            query['NextHopId'] = request.next_hop_id
        if not UtilClient.is_unset(request.next_hop_type):
            query['NextHopType'] = request.next_hop_type
        if not UtilClient.is_unset(request.route_entry_name):
            query['RouteEntryName'] = request.route_entry_name
        if not UtilClient.is_unset(request.route_table_id):
            query['RouteTableId'] = request.route_table_id
        if not UtilClient.is_unset(request.source_cidr_block):
            query['SourceCidrBlock'] = request.source_cidr_block
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateEnsRouteEntry',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateEnsRouteEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_ens_route_entry(
        self,
        request: ens_20171110_models.CreateEnsRouteEntryRequest,
    ) -> ens_20171110_models.CreateEnsRouteEntryResponse:
        """
        @summary Creates a custom route entry.
        
        @param request: CreateEnsRouteEntryRequest
        @return: CreateEnsRouteEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_ens_route_entry_with_options(request, runtime)

    async def create_ens_route_entry_async(
        self,
        request: ens_20171110_models.CreateEnsRouteEntryRequest,
    ) -> ens_20171110_models.CreateEnsRouteEntryResponse:
        """
        @summary Creates a custom route entry.
        
        @param request: CreateEnsRouteEntryRequest
        @return: CreateEnsRouteEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_ens_route_entry_with_options_async(request, runtime)

    def create_ens_sale_control_with_options(
        self,
        tmp_req: ens_20171110_models.CreateEnsSaleControlRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateEnsSaleControlResponse:
        """
        @summary 创建售卖约束
        
        @param tmp_req: CreateEnsSaleControlRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateEnsSaleControlResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.CreateEnsSaleControlShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.sale_controls):
            request.sale_controls_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.sale_controls, 'SaleControls', 'json')
        query = {}
        if not UtilClient.is_unset(request.ali_uid_account):
            query['AliUidAccount'] = request.ali_uid_account
        if not UtilClient.is_unset(request.commodity_code):
            query['CommodityCode'] = request.commodity_code
        if not UtilClient.is_unset(request.custom_account):
            query['CustomAccount'] = request.custom_account
        if not UtilClient.is_unset(request.sale_controls_shrink):
            query['SaleControls'] = request.sale_controls_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateEnsSaleControl',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateEnsSaleControlResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_ens_sale_control_with_options_async(
        self,
        tmp_req: ens_20171110_models.CreateEnsSaleControlRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateEnsSaleControlResponse:
        """
        @summary 创建售卖约束
        
        @param tmp_req: CreateEnsSaleControlRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateEnsSaleControlResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.CreateEnsSaleControlShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.sale_controls):
            request.sale_controls_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.sale_controls, 'SaleControls', 'json')
        query = {}
        if not UtilClient.is_unset(request.ali_uid_account):
            query['AliUidAccount'] = request.ali_uid_account
        if not UtilClient.is_unset(request.commodity_code):
            query['CommodityCode'] = request.commodity_code
        if not UtilClient.is_unset(request.custom_account):
            query['CustomAccount'] = request.custom_account
        if not UtilClient.is_unset(request.sale_controls_shrink):
            query['SaleControls'] = request.sale_controls_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateEnsSaleControl',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateEnsSaleControlResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_ens_sale_control(
        self,
        request: ens_20171110_models.CreateEnsSaleControlRequest,
    ) -> ens_20171110_models.CreateEnsSaleControlResponse:
        """
        @summary 创建售卖约束
        
        @param request: CreateEnsSaleControlRequest
        @return: CreateEnsSaleControlResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_ens_sale_control_with_options(request, runtime)

    async def create_ens_sale_control_async(
        self,
        request: ens_20171110_models.CreateEnsSaleControlRequest,
    ) -> ens_20171110_models.CreateEnsSaleControlResponse:
        """
        @summary 创建售卖约束
        
        @param request: CreateEnsSaleControlRequest
        @return: CreateEnsSaleControlResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_ens_sale_control_with_options_async(request, runtime)

    def create_ens_service_with_options(
        self,
        request: ens_20171110_models.CreateEnsServiceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateEnsServiceResponse:
        """
        @summary Creates an edge service.
        
        @param request: CreateEnsServiceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateEnsServiceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ens_service_id):
            query['EnsServiceId'] = request.ens_service_id
        if not UtilClient.is_unset(request.order_type):
            query['OrderType'] = request.order_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateEnsService',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateEnsServiceResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_ens_service_with_options_async(
        self,
        request: ens_20171110_models.CreateEnsServiceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateEnsServiceResponse:
        """
        @summary Creates an edge service.
        
        @param request: CreateEnsServiceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateEnsServiceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ens_service_id):
            query['EnsServiceId'] = request.ens_service_id
        if not UtilClient.is_unset(request.order_type):
            query['OrderType'] = request.order_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateEnsService',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateEnsServiceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_ens_service(
        self,
        request: ens_20171110_models.CreateEnsServiceRequest,
    ) -> ens_20171110_models.CreateEnsServiceResponse:
        """
        @summary Creates an edge service.
        
        @param request: CreateEnsServiceRequest
        @return: CreateEnsServiceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_ens_service_with_options(request, runtime)

    async def create_ens_service_async(
        self,
        request: ens_20171110_models.CreateEnsServiceRequest,
    ) -> ens_20171110_models.CreateEnsServiceResponse:
        """
        @summary Creates an edge service.
        
        @param request: CreateEnsServiceRequest
        @return: CreateEnsServiceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_ens_service_with_options_async(request, runtime)

    def create_epn_instance_with_options(
        self,
        request: ens_20171110_models.CreateEpnInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateEpnInstanceResponse:
        """
        @summary Creates an edge private network (EPN) instance.
        
        @param request: CreateEpnInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateEpnInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.epninstance_name):
            query['EPNInstanceName'] = request.epninstance_name
        if not UtilClient.is_unset(request.epninstance_type):
            query['EPNInstanceType'] = request.epninstance_type
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.internet_max_bandwidth_out):
            query['InternetMaxBandwidthOut'] = request.internet_max_bandwidth_out
        if not UtilClient.is_unset(request.networking_model):
            query['NetworkingModel'] = request.networking_model
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateEpnInstance',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateEpnInstanceResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_epn_instance_with_options_async(
        self,
        request: ens_20171110_models.CreateEpnInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateEpnInstanceResponse:
        """
        @summary Creates an edge private network (EPN) instance.
        
        @param request: CreateEpnInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateEpnInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.epninstance_name):
            query['EPNInstanceName'] = request.epninstance_name
        if not UtilClient.is_unset(request.epninstance_type):
            query['EPNInstanceType'] = request.epninstance_type
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.internet_max_bandwidth_out):
            query['InternetMaxBandwidthOut'] = request.internet_max_bandwidth_out
        if not UtilClient.is_unset(request.networking_model):
            query['NetworkingModel'] = request.networking_model
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateEpnInstance',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateEpnInstanceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_epn_instance(
        self,
        request: ens_20171110_models.CreateEpnInstanceRequest,
    ) -> ens_20171110_models.CreateEpnInstanceResponse:
        """
        @summary Creates an edge private network (EPN) instance.
        
        @param request: CreateEpnInstanceRequest
        @return: CreateEpnInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_epn_instance_with_options(request, runtime)

    async def create_epn_instance_async(
        self,
        request: ens_20171110_models.CreateEpnInstanceRequest,
    ) -> ens_20171110_models.CreateEpnInstanceResponse:
        """
        @summary Creates an edge private network (EPN) instance.
        
        @param request: CreateEpnInstanceRequest
        @return: CreateEpnInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_epn_instance_with_options_async(request, runtime)

    def create_file_system_with_options(
        self,
        tmp_req: ens_20171110_models.CreateFileSystemRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateFileSystemResponse:
        """
        @summary Creates a NAS file system.
        
        @param tmp_req: CreateFileSystemRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateFileSystemResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.CreateFileSystemShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.order_details):
            request.order_details_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.order_details, 'OrderDetails', 'json')
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateFileSystem',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateFileSystemResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_file_system_with_options_async(
        self,
        tmp_req: ens_20171110_models.CreateFileSystemRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateFileSystemResponse:
        """
        @summary Creates a NAS file system.
        
        @param tmp_req: CreateFileSystemRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateFileSystemResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.CreateFileSystemShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.order_details):
            request.order_details_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.order_details, 'OrderDetails', 'json')
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateFileSystem',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateFileSystemResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_file_system(
        self,
        request: ens_20171110_models.CreateFileSystemRequest,
    ) -> ens_20171110_models.CreateFileSystemResponse:
        """
        @summary Creates a NAS file system.
        
        @param request: CreateFileSystemRequest
        @return: CreateFileSystemResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_file_system_with_options(request, runtime)

    async def create_file_system_async(
        self,
        request: ens_20171110_models.CreateFileSystemRequest,
    ) -> ens_20171110_models.CreateFileSystemResponse:
        """
        @summary Creates a NAS file system.
        
        @param request: CreateFileSystemRequest
        @return: CreateFileSystemResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_file_system_with_options_async(request, runtime)

    def create_forward_entry_with_options(
        self,
        request: ens_20171110_models.CreateForwardEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateForwardEntryResponse:
        """
        @summary Adds a Destination Network Address Translation (DNAT) entry to a DNAT table.
        
        @param request: CreateForwardEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateForwardEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.external_ip):
            query['ExternalIp'] = request.external_ip
        if not UtilClient.is_unset(request.external_port):
            query['ExternalPort'] = request.external_port
        if not UtilClient.is_unset(request.forward_entry_name):
            query['ForwardEntryName'] = request.forward_entry_name
        if not UtilClient.is_unset(request.health_check_port):
            query['HealthCheckPort'] = request.health_check_port
        if not UtilClient.is_unset(request.internal_ip):
            query['InternalIp'] = request.internal_ip
        if not UtilClient.is_unset(request.internal_port):
            query['InternalPort'] = request.internal_port
        if not UtilClient.is_unset(request.ip_protocol):
            query['IpProtocol'] = request.ip_protocol
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.standby_external_ip):
            query['StandbyExternalIp'] = request.standby_external_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateForwardEntry',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateForwardEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_forward_entry_with_options_async(
        self,
        request: ens_20171110_models.CreateForwardEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateForwardEntryResponse:
        """
        @summary Adds a Destination Network Address Translation (DNAT) entry to a DNAT table.
        
        @param request: CreateForwardEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateForwardEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.external_ip):
            query['ExternalIp'] = request.external_ip
        if not UtilClient.is_unset(request.external_port):
            query['ExternalPort'] = request.external_port
        if not UtilClient.is_unset(request.forward_entry_name):
            query['ForwardEntryName'] = request.forward_entry_name
        if not UtilClient.is_unset(request.health_check_port):
            query['HealthCheckPort'] = request.health_check_port
        if not UtilClient.is_unset(request.internal_ip):
            query['InternalIp'] = request.internal_ip
        if not UtilClient.is_unset(request.internal_port):
            query['InternalPort'] = request.internal_port
        if not UtilClient.is_unset(request.ip_protocol):
            query['IpProtocol'] = request.ip_protocol
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.standby_external_ip):
            query['StandbyExternalIp'] = request.standby_external_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateForwardEntry',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateForwardEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_forward_entry(
        self,
        request: ens_20171110_models.CreateForwardEntryRequest,
    ) -> ens_20171110_models.CreateForwardEntryResponse:
        """
        @summary Adds a Destination Network Address Translation (DNAT) entry to a DNAT table.
        
        @param request: CreateForwardEntryRequest
        @return: CreateForwardEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_forward_entry_with_options(request, runtime)

    async def create_forward_entry_async(
        self,
        request: ens_20171110_models.CreateForwardEntryRequest,
    ) -> ens_20171110_models.CreateForwardEntryResponse:
        """
        @summary Adds a Destination Network Address Translation (DNAT) entry to a DNAT table.
        
        @param request: CreateForwardEntryRequest
        @return: CreateForwardEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_forward_entry_with_options_async(request, runtime)

    def create_ha_vip_with_options(
        self,
        request: ens_20171110_models.CreateHaVipRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateHaVipResponse:
        """
        @summary 创建高可用VIP
        
        @param request: CreateHaVipRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateHaVipResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.amount):
            query['Amount'] = request.amount
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.ip_address):
            query['IpAddress'] = request.ip_address
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateHaVip',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateHaVipResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_ha_vip_with_options_async(
        self,
        request: ens_20171110_models.CreateHaVipRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateHaVipResponse:
        """
        @summary 创建高可用VIP
        
        @param request: CreateHaVipRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateHaVipResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.amount):
            query['Amount'] = request.amount
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.ip_address):
            query['IpAddress'] = request.ip_address
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateHaVip',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateHaVipResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_ha_vip(
        self,
        request: ens_20171110_models.CreateHaVipRequest,
    ) -> ens_20171110_models.CreateHaVipResponse:
        """
        @summary 创建高可用VIP
        
        @param request: CreateHaVipRequest
        @return: CreateHaVipResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_ha_vip_with_options(request, runtime)

    async def create_ha_vip_async(
        self,
        request: ens_20171110_models.CreateHaVipRequest,
    ) -> ens_20171110_models.CreateHaVipResponse:
        """
        @summary 创建高可用VIP
        
        @param request: CreateHaVipRequest
        @return: CreateHaVipResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_ha_vip_with_options_async(request, runtime)

    def create_image_with_options(
        self,
        request: ens_20171110_models.CreateImageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateImageResponse:
        """
        @summary Creates an image from an instance.
        
        @param request: CreateImageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateImageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.delete_after_image_upload):
            query['DeleteAfterImageUpload'] = request.delete_after_image_upload
        if not UtilClient.is_unset(request.image_name):
            query['ImageName'] = request.image_name
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.snapshot_id):
            query['SnapshotId'] = request.snapshot_id
        if not UtilClient.is_unset(request.target_ossregion_id):
            query['TargetOSSRegionId'] = request.target_ossregion_id
        if not UtilClient.is_unset(request.with_data_disks):
            query['WithDataDisks'] = request.with_data_disks
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateImage',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateImageResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_image_with_options_async(
        self,
        request: ens_20171110_models.CreateImageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateImageResponse:
        """
        @summary Creates an image from an instance.
        
        @param request: CreateImageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateImageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.delete_after_image_upload):
            query['DeleteAfterImageUpload'] = request.delete_after_image_upload
        if not UtilClient.is_unset(request.image_name):
            query['ImageName'] = request.image_name
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.snapshot_id):
            query['SnapshotId'] = request.snapshot_id
        if not UtilClient.is_unset(request.target_ossregion_id):
            query['TargetOSSRegionId'] = request.target_ossregion_id
        if not UtilClient.is_unset(request.with_data_disks):
            query['WithDataDisks'] = request.with_data_disks
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateImage',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateImageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_image(
        self,
        request: ens_20171110_models.CreateImageRequest,
    ) -> ens_20171110_models.CreateImageResponse:
        """
        @summary Creates an image from an instance.
        
        @param request: CreateImageRequest
        @return: CreateImageResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_image_with_options(request, runtime)

    async def create_image_async(
        self,
        request: ens_20171110_models.CreateImageRequest,
    ) -> ens_20171110_models.CreateImageResponse:
        """
        @summary Creates an image from an instance.
        
        @param request: CreateImageRequest
        @return: CreateImageResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_image_with_options_async(request, runtime)

    def create_instance_with_options(
        self,
        request: ens_20171110_models.CreateInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateInstanceResponse:
        """
        @summary Creates an instance.
        
        @description    You can call this operation up to 10 times per second per account.
        We recommend that you increase the request time because instance creation is an asynchronous operation. If the return code of the API operation is 0, it indicates that the request is successful, but does not indicate that the instance is created. If the request is successful, an instance ID is returned. You can check whether the instance is created based on the instance ID.
        InvalidUserData.NotInWhiteList operation restriction: You can create an instance only if you are in the whitelist in which members have the purchase permissions. Otherwise, an error is returned.
        
        @param request: CreateInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_renew):
            query['AutoRenew'] = request.auto_renew
        if not UtilClient.is_unset(request.auto_renew_period):
            query['AutoRenewPeriod'] = request.auto_renew_period
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.host_name):
            query['HostName'] = request.host_name
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.instance_name):
            query['InstanceName'] = request.instance_name
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.ip_type):
            query['IpType'] = request.ip_type
        if not UtilClient.is_unset(request.key_pair_name):
            query['KeyPairName'] = request.key_pair_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.password):
            query['Password'] = request.password
        if not UtilClient.is_unset(request.password_inherit):
            query['PasswordInherit'] = request.password_inherit
        if not UtilClient.is_unset(request.payment_type):
            query['PaymentType'] = request.payment_type
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.private_ip_address):
            query['PrivateIpAddress'] = request.private_ip_address
        if not UtilClient.is_unset(request.public_ip_identification):
            query['PublicIpIdentification'] = request.public_ip_identification
        if not UtilClient.is_unset(request.quantity):
            query['Quantity'] = request.quantity
        if not UtilClient.is_unset(request.unique_suffix):
            query['UniqueSuffix'] = request.unique_suffix
        if not UtilClient.is_unset(request.user_data):
            query['UserData'] = request.user_data
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.data_disk):
            query['DataDisk'] = request.data_disk
        if not UtilClient.is_unset(request.system_disk):
            query['SystemDisk'] = request.system_disk
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateInstance',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateInstanceResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_instance_with_options_async(
        self,
        request: ens_20171110_models.CreateInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateInstanceResponse:
        """
        @summary Creates an instance.
        
        @description    You can call this operation up to 10 times per second per account.
        We recommend that you increase the request time because instance creation is an asynchronous operation. If the return code of the API operation is 0, it indicates that the request is successful, but does not indicate that the instance is created. If the request is successful, an instance ID is returned. You can check whether the instance is created based on the instance ID.
        InvalidUserData.NotInWhiteList operation restriction: You can create an instance only if you are in the whitelist in which members have the purchase permissions. Otherwise, an error is returned.
        
        @param request: CreateInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_renew):
            query['AutoRenew'] = request.auto_renew
        if not UtilClient.is_unset(request.auto_renew_period):
            query['AutoRenewPeriod'] = request.auto_renew_period
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.host_name):
            query['HostName'] = request.host_name
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.instance_name):
            query['InstanceName'] = request.instance_name
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.ip_type):
            query['IpType'] = request.ip_type
        if not UtilClient.is_unset(request.key_pair_name):
            query['KeyPairName'] = request.key_pair_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.password):
            query['Password'] = request.password
        if not UtilClient.is_unset(request.password_inherit):
            query['PasswordInherit'] = request.password_inherit
        if not UtilClient.is_unset(request.payment_type):
            query['PaymentType'] = request.payment_type
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.private_ip_address):
            query['PrivateIpAddress'] = request.private_ip_address
        if not UtilClient.is_unset(request.public_ip_identification):
            query['PublicIpIdentification'] = request.public_ip_identification
        if not UtilClient.is_unset(request.quantity):
            query['Quantity'] = request.quantity
        if not UtilClient.is_unset(request.unique_suffix):
            query['UniqueSuffix'] = request.unique_suffix
        if not UtilClient.is_unset(request.user_data):
            query['UserData'] = request.user_data
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.data_disk):
            query['DataDisk'] = request.data_disk
        if not UtilClient.is_unset(request.system_disk):
            query['SystemDisk'] = request.system_disk
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateInstance',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateInstanceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_instance(
        self,
        request: ens_20171110_models.CreateInstanceRequest,
    ) -> ens_20171110_models.CreateInstanceResponse:
        """
        @summary Creates an instance.
        
        @description    You can call this operation up to 10 times per second per account.
        We recommend that you increase the request time because instance creation is an asynchronous operation. If the return code of the API operation is 0, it indicates that the request is successful, but does not indicate that the instance is created. If the request is successful, an instance ID is returned. You can check whether the instance is created based on the instance ID.
        InvalidUserData.NotInWhiteList operation restriction: You can create an instance only if you are in the whitelist in which members have the purchase permissions. Otherwise, an error is returned.
        
        @param request: CreateInstanceRequest
        @return: CreateInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_instance_with_options(request, runtime)

    async def create_instance_async(
        self,
        request: ens_20171110_models.CreateInstanceRequest,
    ) -> ens_20171110_models.CreateInstanceResponse:
        """
        @summary Creates an instance.
        
        @description    You can call this operation up to 10 times per second per account.
        We recommend that you increase the request time because instance creation is an asynchronous operation. If the return code of the API operation is 0, it indicates that the request is successful, but does not indicate that the instance is created. If the request is successful, an instance ID is returned. You can check whether the instance is created based on the instance ID.
        InvalidUserData.NotInWhiteList operation restriction: You can create an instance only if you are in the whitelist in which members have the purchase permissions. Otherwise, an error is returned.
        
        @param request: CreateInstanceRequest
        @return: CreateInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_instance_with_options_async(request, runtime)

    def create_instance_active_ops_task_with_options(
        self,
        tmp_req: ens_20171110_models.CreateInstanceActiveOpsTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateInstanceActiveOpsTaskResponse:
        """
        @summary 调用CreateInstanceOpsTask来针对一个实例或实例运维组发起运维任务
        
        @param tmp_req: CreateInstanceActiveOpsTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateInstanceActiveOpsTaskResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.CreateInstanceActiveOpsTaskShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.instance_ids):
            request.instance_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.instance_ids, 'InstanceIds', 'simple')
        query = {}
        if not UtilClient.is_unset(request.instance_ids_shrink):
            query['InstanceIds'] = request.instance_ids_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateInstanceActiveOpsTask',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateInstanceActiveOpsTaskResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_instance_active_ops_task_with_options_async(
        self,
        tmp_req: ens_20171110_models.CreateInstanceActiveOpsTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateInstanceActiveOpsTaskResponse:
        """
        @summary 调用CreateInstanceOpsTask来针对一个实例或实例运维组发起运维任务
        
        @param tmp_req: CreateInstanceActiveOpsTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateInstanceActiveOpsTaskResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.CreateInstanceActiveOpsTaskShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.instance_ids):
            request.instance_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.instance_ids, 'InstanceIds', 'simple')
        query = {}
        if not UtilClient.is_unset(request.instance_ids_shrink):
            query['InstanceIds'] = request.instance_ids_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateInstanceActiveOpsTask',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateInstanceActiveOpsTaskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_instance_active_ops_task(
        self,
        request: ens_20171110_models.CreateInstanceActiveOpsTaskRequest,
    ) -> ens_20171110_models.CreateInstanceActiveOpsTaskResponse:
        """
        @summary 调用CreateInstanceOpsTask来针对一个实例或实例运维组发起运维任务
        
        @param request: CreateInstanceActiveOpsTaskRequest
        @return: CreateInstanceActiveOpsTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_instance_active_ops_task_with_options(request, runtime)

    async def create_instance_active_ops_task_async(
        self,
        request: ens_20171110_models.CreateInstanceActiveOpsTaskRequest,
    ) -> ens_20171110_models.CreateInstanceActiveOpsTaskResponse:
        """
        @summary 调用CreateInstanceOpsTask来针对一个实例或实例运维组发起运维任务
        
        @param request: CreateInstanceActiveOpsTaskRequest
        @return: CreateInstanceActiveOpsTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_instance_active_ops_task_with_options_async(request, runtime)

    def create_key_pair_with_options(
        self,
        request: ens_20171110_models.CreateKeyPairRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateKeyPairResponse:
        """
        @summary Creates an SSH key pair.
        
        @description An SSH key pair consists of a public key and a private key. ENS stores the public key and returns the unencrypted private key that is PEM-encoded in the PKCS#8 format. You must securely lock away the private key.
        
        @param request: CreateKeyPairRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateKeyPairResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.key_pair_name):
            query['KeyPairName'] = request.key_pair_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateKeyPair',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateKeyPairResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_key_pair_with_options_async(
        self,
        request: ens_20171110_models.CreateKeyPairRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateKeyPairResponse:
        """
        @summary Creates an SSH key pair.
        
        @description An SSH key pair consists of a public key and a private key. ENS stores the public key and returns the unencrypted private key that is PEM-encoded in the PKCS#8 format. You must securely lock away the private key.
        
        @param request: CreateKeyPairRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateKeyPairResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.key_pair_name):
            query['KeyPairName'] = request.key_pair_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateKeyPair',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateKeyPairResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_key_pair(
        self,
        request: ens_20171110_models.CreateKeyPairRequest,
    ) -> ens_20171110_models.CreateKeyPairResponse:
        """
        @summary Creates an SSH key pair.
        
        @description An SSH key pair consists of a public key and a private key. ENS stores the public key and returns the unencrypted private key that is PEM-encoded in the PKCS#8 format. You must securely lock away the private key.
        
        @param request: CreateKeyPairRequest
        @return: CreateKeyPairResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_key_pair_with_options(request, runtime)

    async def create_key_pair_async(
        self,
        request: ens_20171110_models.CreateKeyPairRequest,
    ) -> ens_20171110_models.CreateKeyPairResponse:
        """
        @summary Creates an SSH key pair.
        
        @description An SSH key pair consists of a public key and a private key. ENS stores the public key and returns the unencrypted private key that is PEM-encoded in the PKCS#8 format. You must securely lock away the private key.
        
        @param request: CreateKeyPairRequest
        @return: CreateKeyPairResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_key_pair_with_options_async(request, runtime)

    def create_load_balancer_with_options(
        self,
        request: ens_20171110_models.CreateLoadBalancerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateLoadBalancerResponse:
        """
        @summary Creates an Edge Load Balancer (ELB) instance.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 5 times per second per user.
        
        @param request: CreateLoadBalancerRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLoadBalancerResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.billing_cycle):
            query['BillingCycle'] = request.billing_cycle
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.load_balancer_name):
            query['LoadBalancerName'] = request.load_balancer_name
        if not UtilClient.is_unset(request.load_balancer_spec):
            query['LoadBalancerSpec'] = request.load_balancer_spec
        if not UtilClient.is_unset(request.load_balancer_type):
            query['LoadBalancerType'] = request.load_balancer_type
        if not UtilClient.is_unset(request.network_id):
            query['NetworkId'] = request.network_id
        if not UtilClient.is_unset(request.pay_type):
            query['PayType'] = request.pay_type
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateLoadBalancer',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateLoadBalancerResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_load_balancer_with_options_async(
        self,
        request: ens_20171110_models.CreateLoadBalancerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateLoadBalancerResponse:
        """
        @summary Creates an Edge Load Balancer (ELB) instance.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 5 times per second per user.
        
        @param request: CreateLoadBalancerRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLoadBalancerResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.billing_cycle):
            query['BillingCycle'] = request.billing_cycle
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.load_balancer_name):
            query['LoadBalancerName'] = request.load_balancer_name
        if not UtilClient.is_unset(request.load_balancer_spec):
            query['LoadBalancerSpec'] = request.load_balancer_spec
        if not UtilClient.is_unset(request.load_balancer_type):
            query['LoadBalancerType'] = request.load_balancer_type
        if not UtilClient.is_unset(request.network_id):
            query['NetworkId'] = request.network_id
        if not UtilClient.is_unset(request.pay_type):
            query['PayType'] = request.pay_type
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateLoadBalancer',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateLoadBalancerResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_load_balancer(
        self,
        request: ens_20171110_models.CreateLoadBalancerRequest,
    ) -> ens_20171110_models.CreateLoadBalancerResponse:
        """
        @summary Creates an Edge Load Balancer (ELB) instance.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 5 times per second per user.
        
        @param request: CreateLoadBalancerRequest
        @return: CreateLoadBalancerResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_load_balancer_with_options(request, runtime)

    async def create_load_balancer_async(
        self,
        request: ens_20171110_models.CreateLoadBalancerRequest,
    ) -> ens_20171110_models.CreateLoadBalancerResponse:
        """
        @summary Creates an Edge Load Balancer (ELB) instance.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 5 times per second per user.
        
        @param request: CreateLoadBalancerRequest
        @return: CreateLoadBalancerResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_load_balancer_with_options_async(request, runtime)

    def create_load_balancer_httplistener_with_options(
        self,
        request: ens_20171110_models.CreateLoadBalancerHTTPListenerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateLoadBalancerHTTPListenerResponse:
        """
        @summary Creates an HTTP listener.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: CreateLoadBalancerHTTPListenerRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLoadBalancerHTTPListenerResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.backend_server_port):
            query['BackendServerPort'] = request.backend_server_port
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.forward_port):
            query['ForwardPort'] = request.forward_port
        if not UtilClient.is_unset(request.health_check):
            query['HealthCheck'] = request.health_check
        if not UtilClient.is_unset(request.health_check_connect_port):
            query['HealthCheckConnectPort'] = request.health_check_connect_port
        if not UtilClient.is_unset(request.health_check_domain):
            query['HealthCheckDomain'] = request.health_check_domain
        if not UtilClient.is_unset(request.health_check_http_code):
            query['HealthCheckHttpCode'] = request.health_check_http_code
        if not UtilClient.is_unset(request.health_check_interval):
            query['HealthCheckInterval'] = request.health_check_interval
        if not UtilClient.is_unset(request.health_check_method):
            query['HealthCheckMethod'] = request.health_check_method
        if not UtilClient.is_unset(request.health_check_timeout):
            query['HealthCheckTimeout'] = request.health_check_timeout
        if not UtilClient.is_unset(request.health_check_uri):
            query['HealthCheckURI'] = request.health_check_uri
        if not UtilClient.is_unset(request.healthy_threshold):
            query['HealthyThreshold'] = request.healthy_threshold
        if not UtilClient.is_unset(request.idle_timeout):
            query['IdleTimeout'] = request.idle_timeout
        if not UtilClient.is_unset(request.listener_forward):
            query['ListenerForward'] = request.listener_forward
        if not UtilClient.is_unset(request.listener_port):
            query['ListenerPort'] = request.listener_port
        if not UtilClient.is_unset(request.load_balancer_id):
            query['LoadBalancerId'] = request.load_balancer_id
        if not UtilClient.is_unset(request.request_timeout):
            query['RequestTimeout'] = request.request_timeout
        if not UtilClient.is_unset(request.scheduler):
            query['Scheduler'] = request.scheduler
        if not UtilClient.is_unset(request.unhealthy_threshold):
            query['UnhealthyThreshold'] = request.unhealthy_threshold
        if not UtilClient.is_unset(request.xforwarded_for):
            query['XForwardedFor'] = request.xforwarded_for
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateLoadBalancerHTTPListener',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateLoadBalancerHTTPListenerResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_load_balancer_httplistener_with_options_async(
        self,
        request: ens_20171110_models.CreateLoadBalancerHTTPListenerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateLoadBalancerHTTPListenerResponse:
        """
        @summary Creates an HTTP listener.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: CreateLoadBalancerHTTPListenerRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLoadBalancerHTTPListenerResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.backend_server_port):
            query['BackendServerPort'] = request.backend_server_port
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.forward_port):
            query['ForwardPort'] = request.forward_port
        if not UtilClient.is_unset(request.health_check):
            query['HealthCheck'] = request.health_check
        if not UtilClient.is_unset(request.health_check_connect_port):
            query['HealthCheckConnectPort'] = request.health_check_connect_port
        if not UtilClient.is_unset(request.health_check_domain):
            query['HealthCheckDomain'] = request.health_check_domain
        if not UtilClient.is_unset(request.health_check_http_code):
            query['HealthCheckHttpCode'] = request.health_check_http_code
        if not UtilClient.is_unset(request.health_check_interval):
            query['HealthCheckInterval'] = request.health_check_interval
        if not UtilClient.is_unset(request.health_check_method):
            query['HealthCheckMethod'] = request.health_check_method
        if not UtilClient.is_unset(request.health_check_timeout):
            query['HealthCheckTimeout'] = request.health_check_timeout
        if not UtilClient.is_unset(request.health_check_uri):
            query['HealthCheckURI'] = request.health_check_uri
        if not UtilClient.is_unset(request.healthy_threshold):
            query['HealthyThreshold'] = request.healthy_threshold
        if not UtilClient.is_unset(request.idle_timeout):
            query['IdleTimeout'] = request.idle_timeout
        if not UtilClient.is_unset(request.listener_forward):
            query['ListenerForward'] = request.listener_forward
        if not UtilClient.is_unset(request.listener_port):
            query['ListenerPort'] = request.listener_port
        if not UtilClient.is_unset(request.load_balancer_id):
            query['LoadBalancerId'] = request.load_balancer_id
        if not UtilClient.is_unset(request.request_timeout):
            query['RequestTimeout'] = request.request_timeout
        if not UtilClient.is_unset(request.scheduler):
            query['Scheduler'] = request.scheduler
        if not UtilClient.is_unset(request.unhealthy_threshold):
            query['UnhealthyThreshold'] = request.unhealthy_threshold
        if not UtilClient.is_unset(request.xforwarded_for):
            query['XForwardedFor'] = request.xforwarded_for
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateLoadBalancerHTTPListener',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateLoadBalancerHTTPListenerResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_load_balancer_httplistener(
        self,
        request: ens_20171110_models.CreateLoadBalancerHTTPListenerRequest,
    ) -> ens_20171110_models.CreateLoadBalancerHTTPListenerResponse:
        """
        @summary Creates an HTTP listener.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: CreateLoadBalancerHTTPListenerRequest
        @return: CreateLoadBalancerHTTPListenerResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_load_balancer_httplistener_with_options(request, runtime)

    async def create_load_balancer_httplistener_async(
        self,
        request: ens_20171110_models.CreateLoadBalancerHTTPListenerRequest,
    ) -> ens_20171110_models.CreateLoadBalancerHTTPListenerResponse:
        """
        @summary Creates an HTTP listener.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: CreateLoadBalancerHTTPListenerRequest
        @return: CreateLoadBalancerHTTPListenerResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_load_balancer_httplistener_with_options_async(request, runtime)

    def create_load_balancer_httpslistener_with_options(
        self,
        request: ens_20171110_models.CreateLoadBalancerHTTPSListenerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateLoadBalancerHTTPSListenerResponse:
        """
        @summary Creates an HTTPS listener.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: CreateLoadBalancerHTTPSListenerRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLoadBalancerHTTPSListenerResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.backend_server_port):
            query['BackendServerPort'] = request.backend_server_port
        if not UtilClient.is_unset(request.cookie):
            query['Cookie'] = request.cookie
        if not UtilClient.is_unset(request.cookie_timeout):
            query['CookieTimeout'] = request.cookie_timeout
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.forward_port):
            query['ForwardPort'] = request.forward_port
        if not UtilClient.is_unset(request.health_check):
            query['HealthCheck'] = request.health_check
        if not UtilClient.is_unset(request.health_check_connect_port):
            query['HealthCheckConnectPort'] = request.health_check_connect_port
        if not UtilClient.is_unset(request.health_check_domain):
            query['HealthCheckDomain'] = request.health_check_domain
        if not UtilClient.is_unset(request.health_check_http_code):
            query['HealthCheckHttpCode'] = request.health_check_http_code
        if not UtilClient.is_unset(request.health_check_interval):
            query['HealthCheckInterval'] = request.health_check_interval
        if not UtilClient.is_unset(request.health_check_method):
            query['HealthCheckMethod'] = request.health_check_method
        if not UtilClient.is_unset(request.health_check_timeout):
            query['HealthCheckTimeout'] = request.health_check_timeout
        if not UtilClient.is_unset(request.health_check_uri):
            query['HealthCheckURI'] = request.health_check_uri
        if not UtilClient.is_unset(request.healthy_threshold):
            query['HealthyThreshold'] = request.healthy_threshold
        if not UtilClient.is_unset(request.idle_timeout):
            query['IdleTimeout'] = request.idle_timeout
        if not UtilClient.is_unset(request.listener_forward):
            query['ListenerForward'] = request.listener_forward
        if not UtilClient.is_unset(request.listener_port):
            query['ListenerPort'] = request.listener_port
        if not UtilClient.is_unset(request.load_balancer_id):
            query['LoadBalancerId'] = request.load_balancer_id
        if not UtilClient.is_unset(request.request_timeout):
            query['RequestTimeout'] = request.request_timeout
        if not UtilClient.is_unset(request.scheduler):
            query['Scheduler'] = request.scheduler
        if not UtilClient.is_unset(request.server_certificate_id):
            query['ServerCertificateId'] = request.server_certificate_id
        if not UtilClient.is_unset(request.sticky_session_type):
            query['StickySessionType'] = request.sticky_session_type
        if not UtilClient.is_unset(request.unhealthy_threshold):
            query['UnhealthyThreshold'] = request.unhealthy_threshold
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateLoadBalancerHTTPSListener',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateLoadBalancerHTTPSListenerResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_load_balancer_httpslistener_with_options_async(
        self,
        request: ens_20171110_models.CreateLoadBalancerHTTPSListenerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateLoadBalancerHTTPSListenerResponse:
        """
        @summary Creates an HTTPS listener.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: CreateLoadBalancerHTTPSListenerRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLoadBalancerHTTPSListenerResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.backend_server_port):
            query['BackendServerPort'] = request.backend_server_port
        if not UtilClient.is_unset(request.cookie):
            query['Cookie'] = request.cookie
        if not UtilClient.is_unset(request.cookie_timeout):
            query['CookieTimeout'] = request.cookie_timeout
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.forward_port):
            query['ForwardPort'] = request.forward_port
        if not UtilClient.is_unset(request.health_check):
            query['HealthCheck'] = request.health_check
        if not UtilClient.is_unset(request.health_check_connect_port):
            query['HealthCheckConnectPort'] = request.health_check_connect_port
        if not UtilClient.is_unset(request.health_check_domain):
            query['HealthCheckDomain'] = request.health_check_domain
        if not UtilClient.is_unset(request.health_check_http_code):
            query['HealthCheckHttpCode'] = request.health_check_http_code
        if not UtilClient.is_unset(request.health_check_interval):
            query['HealthCheckInterval'] = request.health_check_interval
        if not UtilClient.is_unset(request.health_check_method):
            query['HealthCheckMethod'] = request.health_check_method
        if not UtilClient.is_unset(request.health_check_timeout):
            query['HealthCheckTimeout'] = request.health_check_timeout
        if not UtilClient.is_unset(request.health_check_uri):
            query['HealthCheckURI'] = request.health_check_uri
        if not UtilClient.is_unset(request.healthy_threshold):
            query['HealthyThreshold'] = request.healthy_threshold
        if not UtilClient.is_unset(request.idle_timeout):
            query['IdleTimeout'] = request.idle_timeout
        if not UtilClient.is_unset(request.listener_forward):
            query['ListenerForward'] = request.listener_forward
        if not UtilClient.is_unset(request.listener_port):
            query['ListenerPort'] = request.listener_port
        if not UtilClient.is_unset(request.load_balancer_id):
            query['LoadBalancerId'] = request.load_balancer_id
        if not UtilClient.is_unset(request.request_timeout):
            query['RequestTimeout'] = request.request_timeout
        if not UtilClient.is_unset(request.scheduler):
            query['Scheduler'] = request.scheduler
        if not UtilClient.is_unset(request.server_certificate_id):
            query['ServerCertificateId'] = request.server_certificate_id
        if not UtilClient.is_unset(request.sticky_session_type):
            query['StickySessionType'] = request.sticky_session_type
        if not UtilClient.is_unset(request.unhealthy_threshold):
            query['UnhealthyThreshold'] = request.unhealthy_threshold
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateLoadBalancerHTTPSListener',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateLoadBalancerHTTPSListenerResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_load_balancer_httpslistener(
        self,
        request: ens_20171110_models.CreateLoadBalancerHTTPSListenerRequest,
    ) -> ens_20171110_models.CreateLoadBalancerHTTPSListenerResponse:
        """
        @summary Creates an HTTPS listener.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: CreateLoadBalancerHTTPSListenerRequest
        @return: CreateLoadBalancerHTTPSListenerResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_load_balancer_httpslistener_with_options(request, runtime)

    async def create_load_balancer_httpslistener_async(
        self,
        request: ens_20171110_models.CreateLoadBalancerHTTPSListenerRequest,
    ) -> ens_20171110_models.CreateLoadBalancerHTTPSListenerResponse:
        """
        @summary Creates an HTTPS listener.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: CreateLoadBalancerHTTPSListenerRequest
        @return: CreateLoadBalancerHTTPSListenerResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_load_balancer_httpslistener_with_options_async(request, runtime)

    def create_load_balancer_tcplistener_with_options(
        self,
        request: ens_20171110_models.CreateLoadBalancerTCPListenerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateLoadBalancerTCPListenerResponse:
        """
        @summary Creates a Transmission Control Protocol (TCP) listener.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: CreateLoadBalancerTCPListenerRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLoadBalancerTCPListenerResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.backend_server_port):
            query['BackendServerPort'] = request.backend_server_port
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.eip_transmit):
            query['EipTransmit'] = request.eip_transmit
        if not UtilClient.is_unset(request.established_timeout):
            query['EstablishedTimeout'] = request.established_timeout
        if not UtilClient.is_unset(request.health_check_connect_port):
            query['HealthCheckConnectPort'] = request.health_check_connect_port
        if not UtilClient.is_unset(request.health_check_connect_timeout):
            query['HealthCheckConnectTimeout'] = request.health_check_connect_timeout
        if not UtilClient.is_unset(request.health_check_domain):
            query['HealthCheckDomain'] = request.health_check_domain
        if not UtilClient.is_unset(request.health_check_http_code):
            query['HealthCheckHttpCode'] = request.health_check_http_code
        if not UtilClient.is_unset(request.health_check_interval):
            query['HealthCheckInterval'] = request.health_check_interval
        if not UtilClient.is_unset(request.health_check_type):
            query['HealthCheckType'] = request.health_check_type
        if not UtilClient.is_unset(request.health_check_uri):
            query['HealthCheckURI'] = request.health_check_uri
        if not UtilClient.is_unset(request.healthy_threshold):
            query['HealthyThreshold'] = request.healthy_threshold
        if not UtilClient.is_unset(request.listener_port):
            query['ListenerPort'] = request.listener_port
        if not UtilClient.is_unset(request.load_balancer_id):
            query['LoadBalancerId'] = request.load_balancer_id
        if not UtilClient.is_unset(request.persistence_timeout):
            query['PersistenceTimeout'] = request.persistence_timeout
        if not UtilClient.is_unset(request.scheduler):
            query['Scheduler'] = request.scheduler
        if not UtilClient.is_unset(request.unhealthy_threshold):
            query['UnhealthyThreshold'] = request.unhealthy_threshold
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateLoadBalancerTCPListener',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateLoadBalancerTCPListenerResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_load_balancer_tcplistener_with_options_async(
        self,
        request: ens_20171110_models.CreateLoadBalancerTCPListenerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateLoadBalancerTCPListenerResponse:
        """
        @summary Creates a Transmission Control Protocol (TCP) listener.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: CreateLoadBalancerTCPListenerRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLoadBalancerTCPListenerResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.backend_server_port):
            query['BackendServerPort'] = request.backend_server_port
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.eip_transmit):
            query['EipTransmit'] = request.eip_transmit
        if not UtilClient.is_unset(request.established_timeout):
            query['EstablishedTimeout'] = request.established_timeout
        if not UtilClient.is_unset(request.health_check_connect_port):
            query['HealthCheckConnectPort'] = request.health_check_connect_port
        if not UtilClient.is_unset(request.health_check_connect_timeout):
            query['HealthCheckConnectTimeout'] = request.health_check_connect_timeout
        if not UtilClient.is_unset(request.health_check_domain):
            query['HealthCheckDomain'] = request.health_check_domain
        if not UtilClient.is_unset(request.health_check_http_code):
            query['HealthCheckHttpCode'] = request.health_check_http_code
        if not UtilClient.is_unset(request.health_check_interval):
            query['HealthCheckInterval'] = request.health_check_interval
        if not UtilClient.is_unset(request.health_check_type):
            query['HealthCheckType'] = request.health_check_type
        if not UtilClient.is_unset(request.health_check_uri):
            query['HealthCheckURI'] = request.health_check_uri
        if not UtilClient.is_unset(request.healthy_threshold):
            query['HealthyThreshold'] = request.healthy_threshold
        if not UtilClient.is_unset(request.listener_port):
            query['ListenerPort'] = request.listener_port
        if not UtilClient.is_unset(request.load_balancer_id):
            query['LoadBalancerId'] = request.load_balancer_id
        if not UtilClient.is_unset(request.persistence_timeout):
            query['PersistenceTimeout'] = request.persistence_timeout
        if not UtilClient.is_unset(request.scheduler):
            query['Scheduler'] = request.scheduler
        if not UtilClient.is_unset(request.unhealthy_threshold):
            query['UnhealthyThreshold'] = request.unhealthy_threshold
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateLoadBalancerTCPListener',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateLoadBalancerTCPListenerResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_load_balancer_tcplistener(
        self,
        request: ens_20171110_models.CreateLoadBalancerTCPListenerRequest,
    ) -> ens_20171110_models.CreateLoadBalancerTCPListenerResponse:
        """
        @summary Creates a Transmission Control Protocol (TCP) listener.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: CreateLoadBalancerTCPListenerRequest
        @return: CreateLoadBalancerTCPListenerResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_load_balancer_tcplistener_with_options(request, runtime)

    async def create_load_balancer_tcplistener_async(
        self,
        request: ens_20171110_models.CreateLoadBalancerTCPListenerRequest,
    ) -> ens_20171110_models.CreateLoadBalancerTCPListenerResponse:
        """
        @summary Creates a Transmission Control Protocol (TCP) listener.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: CreateLoadBalancerTCPListenerRequest
        @return: CreateLoadBalancerTCPListenerResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_load_balancer_tcplistener_with_options_async(request, runtime)

    def create_load_balancer_udplistener_with_options(
        self,
        request: ens_20171110_models.CreateLoadBalancerUDPListenerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateLoadBalancerUDPListenerResponse:
        """
        @summary Creates a User Datagram Protocol (UDP) listener.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: CreateLoadBalancerUDPListenerRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLoadBalancerUDPListenerResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.backend_server_port):
            query['BackendServerPort'] = request.backend_server_port
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.eip_transmit):
            query['EipTransmit'] = request.eip_transmit
        if not UtilClient.is_unset(request.established_timeout):
            query['EstablishedTimeout'] = request.established_timeout
        if not UtilClient.is_unset(request.health_check_connect_port):
            query['HealthCheckConnectPort'] = request.health_check_connect_port
        if not UtilClient.is_unset(request.health_check_connect_timeout):
            query['HealthCheckConnectTimeout'] = request.health_check_connect_timeout
        if not UtilClient.is_unset(request.health_check_exp):
            query['HealthCheckExp'] = request.health_check_exp
        if not UtilClient.is_unset(request.health_check_interval):
            query['HealthCheckInterval'] = request.health_check_interval
        if not UtilClient.is_unset(request.health_check_req):
            query['HealthCheckReq'] = request.health_check_req
        if not UtilClient.is_unset(request.healthy_threshold):
            query['HealthyThreshold'] = request.healthy_threshold
        if not UtilClient.is_unset(request.listener_port):
            query['ListenerPort'] = request.listener_port
        if not UtilClient.is_unset(request.load_balancer_id):
            query['LoadBalancerId'] = request.load_balancer_id
        if not UtilClient.is_unset(request.scheduler):
            query['Scheduler'] = request.scheduler
        if not UtilClient.is_unset(request.unhealthy_threshold):
            query['UnhealthyThreshold'] = request.unhealthy_threshold
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateLoadBalancerUDPListener',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateLoadBalancerUDPListenerResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_load_balancer_udplistener_with_options_async(
        self,
        request: ens_20171110_models.CreateLoadBalancerUDPListenerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateLoadBalancerUDPListenerResponse:
        """
        @summary Creates a User Datagram Protocol (UDP) listener.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: CreateLoadBalancerUDPListenerRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLoadBalancerUDPListenerResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.backend_server_port):
            query['BackendServerPort'] = request.backend_server_port
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.eip_transmit):
            query['EipTransmit'] = request.eip_transmit
        if not UtilClient.is_unset(request.established_timeout):
            query['EstablishedTimeout'] = request.established_timeout
        if not UtilClient.is_unset(request.health_check_connect_port):
            query['HealthCheckConnectPort'] = request.health_check_connect_port
        if not UtilClient.is_unset(request.health_check_connect_timeout):
            query['HealthCheckConnectTimeout'] = request.health_check_connect_timeout
        if not UtilClient.is_unset(request.health_check_exp):
            query['HealthCheckExp'] = request.health_check_exp
        if not UtilClient.is_unset(request.health_check_interval):
            query['HealthCheckInterval'] = request.health_check_interval
        if not UtilClient.is_unset(request.health_check_req):
            query['HealthCheckReq'] = request.health_check_req
        if not UtilClient.is_unset(request.healthy_threshold):
            query['HealthyThreshold'] = request.healthy_threshold
        if not UtilClient.is_unset(request.listener_port):
            query['ListenerPort'] = request.listener_port
        if not UtilClient.is_unset(request.load_balancer_id):
            query['LoadBalancerId'] = request.load_balancer_id
        if not UtilClient.is_unset(request.scheduler):
            query['Scheduler'] = request.scheduler
        if not UtilClient.is_unset(request.unhealthy_threshold):
            query['UnhealthyThreshold'] = request.unhealthy_threshold
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateLoadBalancerUDPListener',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateLoadBalancerUDPListenerResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_load_balancer_udplistener(
        self,
        request: ens_20171110_models.CreateLoadBalancerUDPListenerRequest,
    ) -> ens_20171110_models.CreateLoadBalancerUDPListenerResponse:
        """
        @summary Creates a User Datagram Protocol (UDP) listener.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: CreateLoadBalancerUDPListenerRequest
        @return: CreateLoadBalancerUDPListenerResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_load_balancer_udplistener_with_options(request, runtime)

    async def create_load_balancer_udplistener_async(
        self,
        request: ens_20171110_models.CreateLoadBalancerUDPListenerRequest,
    ) -> ens_20171110_models.CreateLoadBalancerUDPListenerResponse:
        """
        @summary Creates a User Datagram Protocol (UDP) listener.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: CreateLoadBalancerUDPListenerRequest
        @return: CreateLoadBalancerUDPListenerResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_load_balancer_udplistener_with_options_async(request, runtime)

    def create_mount_target_with_options(
        self,
        request: ens_20171110_models.CreateMountTargetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateMountTargetResponse:
        """
        @summary Creates a mount target.
        
        @description ## [](#)Precautions
        After you call this operation, a mount target is not immediately created. Therefore, we recommend that you call the DescribeMountTargets operation to query the status of the mount target. If the mount target is in the Active state, you can then mount the file system. Otherwise, the file system may fail to be mounted.
        
        @param request: CreateMountTargetRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateMountTargetResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.file_system_id):
            query['FileSystemId'] = request.file_system_id
        if not UtilClient.is_unset(request.mount_target_name):
            query['MountTargetName'] = request.mount_target_name
        if not UtilClient.is_unset(request.net_work_id):
            query['NetWorkId'] = request.net_work_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateMountTarget',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateMountTargetResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_mount_target_with_options_async(
        self,
        request: ens_20171110_models.CreateMountTargetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateMountTargetResponse:
        """
        @summary Creates a mount target.
        
        @description ## [](#)Precautions
        After you call this operation, a mount target is not immediately created. Therefore, we recommend that you call the DescribeMountTargets operation to query the status of the mount target. If the mount target is in the Active state, you can then mount the file system. Otherwise, the file system may fail to be mounted.
        
        @param request: CreateMountTargetRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateMountTargetResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.file_system_id):
            query['FileSystemId'] = request.file_system_id
        if not UtilClient.is_unset(request.mount_target_name):
            query['MountTargetName'] = request.mount_target_name
        if not UtilClient.is_unset(request.net_work_id):
            query['NetWorkId'] = request.net_work_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateMountTarget',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateMountTargetResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_mount_target(
        self,
        request: ens_20171110_models.CreateMountTargetRequest,
    ) -> ens_20171110_models.CreateMountTargetResponse:
        """
        @summary Creates a mount target.
        
        @description ## [](#)Precautions
        After you call this operation, a mount target is not immediately created. Therefore, we recommend that you call the DescribeMountTargets operation to query the status of the mount target. If the mount target is in the Active state, you can then mount the file system. Otherwise, the file system may fail to be mounted.
        
        @param request: CreateMountTargetRequest
        @return: CreateMountTargetResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_mount_target_with_options(request, runtime)

    async def create_mount_target_async(
        self,
        request: ens_20171110_models.CreateMountTargetRequest,
    ) -> ens_20171110_models.CreateMountTargetResponse:
        """
        @summary Creates a mount target.
        
        @description ## [](#)Precautions
        After you call this operation, a mount target is not immediately created. Therefore, we recommend that you call the DescribeMountTargets operation to query the status of the mount target. If the mount target is in the Active state, you can then mount the file system. Otherwise, the file system may fail to be mounted.
        
        @param request: CreateMountTargetRequest
        @return: CreateMountTargetResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_mount_target_with_options_async(request, runtime)

    def create_nat_gateway_with_options(
        self,
        request: ens_20171110_models.CreateNatGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateNatGatewayResponse:
        """
        @summary Creates a network address translation (NAT) gateway.
        
        @param request: CreateNatGatewayRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNatGatewayResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.instance_billing_cycle):
            query['InstanceBillingCycle'] = request.instance_billing_cycle
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.network_id):
            query['NetworkId'] = request.network_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNatGateway',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateNatGatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_nat_gateway_with_options_async(
        self,
        request: ens_20171110_models.CreateNatGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateNatGatewayResponse:
        """
        @summary Creates a network address translation (NAT) gateway.
        
        @param request: CreateNatGatewayRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNatGatewayResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.instance_billing_cycle):
            query['InstanceBillingCycle'] = request.instance_billing_cycle
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.network_id):
            query['NetworkId'] = request.network_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNatGateway',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateNatGatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_nat_gateway(
        self,
        request: ens_20171110_models.CreateNatGatewayRequest,
    ) -> ens_20171110_models.CreateNatGatewayResponse:
        """
        @summary Creates a network address translation (NAT) gateway.
        
        @param request: CreateNatGatewayRequest
        @return: CreateNatGatewayResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_nat_gateway_with_options(request, runtime)

    async def create_nat_gateway_async(
        self,
        request: ens_20171110_models.CreateNatGatewayRequest,
    ) -> ens_20171110_models.CreateNatGatewayResponse:
        """
        @summary Creates a network address translation (NAT) gateway.
        
        @param request: CreateNatGatewayRequest
        @return: CreateNatGatewayResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_nat_gateway_with_options_async(request, runtime)

    def create_network_with_options(
        self,
        request: ens_20171110_models.CreateNetworkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateNetworkResponse:
        """
        @summary Creates a virtual private cloud (VPC).
        
        @description    You can call this operation up to 100 times per second.
        You can call this operation up to 5 times per second per user.
        
        @param request: CreateNetworkRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNetworkResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cidr_block):
            query['CidrBlock'] = request.cidr_block
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.network_name):
            query['NetworkName'] = request.network_name
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNetwork',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateNetworkResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_network_with_options_async(
        self,
        request: ens_20171110_models.CreateNetworkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateNetworkResponse:
        """
        @summary Creates a virtual private cloud (VPC).
        
        @description    You can call this operation up to 100 times per second.
        You can call this operation up to 5 times per second per user.
        
        @param request: CreateNetworkRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNetworkResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cidr_block):
            query['CidrBlock'] = request.cidr_block
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.network_name):
            query['NetworkName'] = request.network_name
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNetwork',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateNetworkResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_network(
        self,
        request: ens_20171110_models.CreateNetworkRequest,
    ) -> ens_20171110_models.CreateNetworkResponse:
        """
        @summary Creates a virtual private cloud (VPC).
        
        @description    You can call this operation up to 100 times per second.
        You can call this operation up to 5 times per second per user.
        
        @param request: CreateNetworkRequest
        @return: CreateNetworkResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_network_with_options(request, runtime)

    async def create_network_async(
        self,
        request: ens_20171110_models.CreateNetworkRequest,
    ) -> ens_20171110_models.CreateNetworkResponse:
        """
        @summary Creates a virtual private cloud (VPC).
        
        @description    You can call this operation up to 100 times per second.
        You can call this operation up to 5 times per second per user.
        
        @param request: CreateNetworkRequest
        @return: CreateNetworkResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_network_with_options_async(request, runtime)

    def create_network_acl_with_options(
        self,
        request: ens_20171110_models.CreateNetworkAclRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateNetworkAclResponse:
        """
        @summary Creates a network access control list (ACL).
        
        @param request: CreateNetworkAclRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNetworkAclResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.network_acl_name):
            query['NetworkAclName'] = request.network_acl_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNetworkAcl',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateNetworkAclResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_network_acl_with_options_async(
        self,
        request: ens_20171110_models.CreateNetworkAclRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateNetworkAclResponse:
        """
        @summary Creates a network access control list (ACL).
        
        @param request: CreateNetworkAclRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNetworkAclResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.network_acl_name):
            query['NetworkAclName'] = request.network_acl_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNetworkAcl',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateNetworkAclResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_network_acl(
        self,
        request: ens_20171110_models.CreateNetworkAclRequest,
    ) -> ens_20171110_models.CreateNetworkAclResponse:
        """
        @summary Creates a network access control list (ACL).
        
        @param request: CreateNetworkAclRequest
        @return: CreateNetworkAclResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_network_acl_with_options(request, runtime)

    async def create_network_acl_async(
        self,
        request: ens_20171110_models.CreateNetworkAclRequest,
    ) -> ens_20171110_models.CreateNetworkAclResponse:
        """
        @summary Creates a network access control list (ACL).
        
        @param request: CreateNetworkAclRequest
        @return: CreateNetworkAclResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_network_acl_with_options_async(request, runtime)

    def create_network_acl_entry_with_options(
        self,
        request: ens_20171110_models.CreateNetworkAclEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateNetworkAclEntryResponse:
        """
        @summary Creates a network access control list (ACL) rule.
        
        @param request: CreateNetworkAclEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNetworkAclEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cidr_block):
            query['CidrBlock'] = request.cidr_block
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.destination_cidr_block):
            query['DestinationCidrBlock'] = request.destination_cidr_block
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.network_acl_entry_name):
            query['NetworkAclEntryName'] = request.network_acl_entry_name
        if not UtilClient.is_unset(request.network_acl_id):
            query['NetworkAclId'] = request.network_acl_id
        if not UtilClient.is_unset(request.policy):
            query['Policy'] = request.policy
        if not UtilClient.is_unset(request.port_range):
            query['PortRange'] = request.port_range
        if not UtilClient.is_unset(request.priority):
            query['Priority'] = request.priority
        if not UtilClient.is_unset(request.protocol):
            query['Protocol'] = request.protocol
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNetworkAclEntry',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateNetworkAclEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_network_acl_entry_with_options_async(
        self,
        request: ens_20171110_models.CreateNetworkAclEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateNetworkAclEntryResponse:
        """
        @summary Creates a network access control list (ACL) rule.
        
        @param request: CreateNetworkAclEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNetworkAclEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cidr_block):
            query['CidrBlock'] = request.cidr_block
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.destination_cidr_block):
            query['DestinationCidrBlock'] = request.destination_cidr_block
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.network_acl_entry_name):
            query['NetworkAclEntryName'] = request.network_acl_entry_name
        if not UtilClient.is_unset(request.network_acl_id):
            query['NetworkAclId'] = request.network_acl_id
        if not UtilClient.is_unset(request.policy):
            query['Policy'] = request.policy
        if not UtilClient.is_unset(request.port_range):
            query['PortRange'] = request.port_range
        if not UtilClient.is_unset(request.priority):
            query['Priority'] = request.priority
        if not UtilClient.is_unset(request.protocol):
            query['Protocol'] = request.protocol
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNetworkAclEntry',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateNetworkAclEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_network_acl_entry(
        self,
        request: ens_20171110_models.CreateNetworkAclEntryRequest,
    ) -> ens_20171110_models.CreateNetworkAclEntryResponse:
        """
        @summary Creates a network access control list (ACL) rule.
        
        @param request: CreateNetworkAclEntryRequest
        @return: CreateNetworkAclEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_network_acl_entry_with_options(request, runtime)

    async def create_network_acl_entry_async(
        self,
        request: ens_20171110_models.CreateNetworkAclEntryRequest,
    ) -> ens_20171110_models.CreateNetworkAclEntryResponse:
        """
        @summary Creates a network access control list (ACL) rule.
        
        @param request: CreateNetworkAclEntryRequest
        @return: CreateNetworkAclEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_network_acl_entry_with_options_async(request, runtime)

    def create_network_interface_with_options(
        self,
        tmp_req: ens_20171110_models.CreateNetworkInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateNetworkInterfaceResponse:
        """
        @summary 创建弹性网卡
        
        @param tmp_req: CreateNetworkInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNetworkInterfaceResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.CreateNetworkInterfaceShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.security_group_ids):
            request.security_group_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.security_group_ids, 'SecurityGroupIds', 'json')
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.security_group_ids_shrink):
            query['SecurityGroupIds'] = request.security_group_ids_shrink
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNetworkInterface',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateNetworkInterfaceResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_network_interface_with_options_async(
        self,
        tmp_req: ens_20171110_models.CreateNetworkInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateNetworkInterfaceResponse:
        """
        @summary 创建弹性网卡
        
        @param tmp_req: CreateNetworkInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNetworkInterfaceResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.CreateNetworkInterfaceShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.security_group_ids):
            request.security_group_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.security_group_ids, 'SecurityGroupIds', 'json')
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.security_group_ids_shrink):
            query['SecurityGroupIds'] = request.security_group_ids_shrink
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNetworkInterface',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateNetworkInterfaceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_network_interface(
        self,
        request: ens_20171110_models.CreateNetworkInterfaceRequest,
    ) -> ens_20171110_models.CreateNetworkInterfaceResponse:
        """
        @summary 创建弹性网卡
        
        @param request: CreateNetworkInterfaceRequest
        @return: CreateNetworkInterfaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_network_interface_with_options(request, runtime)

    async def create_network_interface_async(
        self,
        request: ens_20171110_models.CreateNetworkInterfaceRequest,
    ) -> ens_20171110_models.CreateNetworkInterfaceResponse:
        """
        @summary 创建弹性网卡
        
        @param request: CreateNetworkInterfaceRequest
        @return: CreateNetworkInterfaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_network_interface_with_options_async(request, runtime)

    def create_sdgwith_options(
        self,
        request: ens_20171110_models.CreateSDGRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateSDGResponse:
        """
        @summary Creates a shared data group (SDG) on an Android in Container (AIC) instance.
        
        @description A SDG can be regarded as a data partition image of a virtual device. You can save a data partition of a virtual device as an SDG. A created SDG can be deployed in data partitions of other virtual devices to achieve rapid data distribution and application. The procedure for calling SDG-related API operations:
        Call the [CreateSDG](~~CreateSDG~~) operation to create an SDG, which is bound to AIC Instance A (InstanceId). After you create the SDG, a blank cloud disk (also known as an original cloud disk) is attached to Device A (InstanceId).
        Install applications on and deliver files to AIC Instance A (InstanceId).
        Call the [SaveSDG](~~SaveSDG~~) operation to save the data disk of AIC instance A as SDG A.
        Call the [DeploySDG](~~DeploySDG~~) operation to deploy SDG A to AIC Instance B. This operattion is executed asynchronously. You can call the [DescribeARMServerInstances](~~DescribeARMServerInstances~~) operation to query the status of AIC Instance B. If the status of AIC Instance B changes to success, AIC insance B is available, and AIC Instances A and B have the same applications running.
        
        @param request: CreateSDGRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSDGResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSDG',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateSDGResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_sdgwith_options_async(
        self,
        request: ens_20171110_models.CreateSDGRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateSDGResponse:
        """
        @summary Creates a shared data group (SDG) on an Android in Container (AIC) instance.
        
        @description A SDG can be regarded as a data partition image of a virtual device. You can save a data partition of a virtual device as an SDG. A created SDG can be deployed in data partitions of other virtual devices to achieve rapid data distribution and application. The procedure for calling SDG-related API operations:
        Call the [CreateSDG](~~CreateSDG~~) operation to create an SDG, which is bound to AIC Instance A (InstanceId). After you create the SDG, a blank cloud disk (also known as an original cloud disk) is attached to Device A (InstanceId).
        Install applications on and deliver files to AIC Instance A (InstanceId).
        Call the [SaveSDG](~~SaveSDG~~) operation to save the data disk of AIC instance A as SDG A.
        Call the [DeploySDG](~~DeploySDG~~) operation to deploy SDG A to AIC Instance B. This operattion is executed asynchronously. You can call the [DescribeARMServerInstances](~~DescribeARMServerInstances~~) operation to query the status of AIC Instance B. If the status of AIC Instance B changes to success, AIC insance B is available, and AIC Instances A and B have the same applications running.
        
        @param request: CreateSDGRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSDGResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSDG',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateSDGResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_sdg(
        self,
        request: ens_20171110_models.CreateSDGRequest,
    ) -> ens_20171110_models.CreateSDGResponse:
        """
        @summary Creates a shared data group (SDG) on an Android in Container (AIC) instance.
        
        @description A SDG can be regarded as a data partition image of a virtual device. You can save a data partition of a virtual device as an SDG. A created SDG can be deployed in data partitions of other virtual devices to achieve rapid data distribution and application. The procedure for calling SDG-related API operations:
        Call the [CreateSDG](~~CreateSDG~~) operation to create an SDG, which is bound to AIC Instance A (InstanceId). After you create the SDG, a blank cloud disk (also known as an original cloud disk) is attached to Device A (InstanceId).
        Install applications on and deliver files to AIC Instance A (InstanceId).
        Call the [SaveSDG](~~SaveSDG~~) operation to save the data disk of AIC instance A as SDG A.
        Call the [DeploySDG](~~DeploySDG~~) operation to deploy SDG A to AIC Instance B. This operattion is executed asynchronously. You can call the [DescribeARMServerInstances](~~DescribeARMServerInstances~~) operation to query the status of AIC Instance B. If the status of AIC Instance B changes to success, AIC insance B is available, and AIC Instances A and B have the same applications running.
        
        @param request: CreateSDGRequest
        @return: CreateSDGResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_sdgwith_options(request, runtime)

    async def create_sdg_async(
        self,
        request: ens_20171110_models.CreateSDGRequest,
    ) -> ens_20171110_models.CreateSDGResponse:
        """
        @summary Creates a shared data group (SDG) on an Android in Container (AIC) instance.
        
        @description A SDG can be regarded as a data partition image of a virtual device. You can save a data partition of a virtual device as an SDG. A created SDG can be deployed in data partitions of other virtual devices to achieve rapid data distribution and application. The procedure for calling SDG-related API operations:
        Call the [CreateSDG](~~CreateSDG~~) operation to create an SDG, which is bound to AIC Instance A (InstanceId). After you create the SDG, a blank cloud disk (also known as an original cloud disk) is attached to Device A (InstanceId).
        Install applications on and deliver files to AIC Instance A (InstanceId).
        Call the [SaveSDG](~~SaveSDG~~) operation to save the data disk of AIC instance A as SDG A.
        Call the [DeploySDG](~~DeploySDG~~) operation to deploy SDG A to AIC Instance B. This operattion is executed asynchronously. You can call the [DescribeARMServerInstances](~~DescribeARMServerInstances~~) operation to query the status of AIC Instance B. If the status of AIC Instance B changes to success, AIC insance B is available, and AIC Instances A and B have the same applications running.
        
        @param request: CreateSDGRequest
        @return: CreateSDGResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_sdgwith_options_async(request, runtime)

    def create_security_group_with_options(
        self,
        tmp_req: ens_20171110_models.CreateSecurityGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateSecurityGroupResponse:
        """
        @summary Creates a security group.
        
        @param tmp_req: CreateSecurityGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSecurityGroupResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.CreateSecurityGroupShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.permissions):
            request.permissions_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.permissions, 'Permissions', 'json')
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.permissions_shrink):
            query['Permissions'] = request.permissions_shrink
        if not UtilClient.is_unset(request.security_group_name):
            query['SecurityGroupName'] = request.security_group_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSecurityGroup',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateSecurityGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_security_group_with_options_async(
        self,
        tmp_req: ens_20171110_models.CreateSecurityGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateSecurityGroupResponse:
        """
        @summary Creates a security group.
        
        @param tmp_req: CreateSecurityGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSecurityGroupResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.CreateSecurityGroupShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.permissions):
            request.permissions_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.permissions, 'Permissions', 'json')
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.permissions_shrink):
            query['Permissions'] = request.permissions_shrink
        if not UtilClient.is_unset(request.security_group_name):
            query['SecurityGroupName'] = request.security_group_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSecurityGroup',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateSecurityGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_security_group(
        self,
        request: ens_20171110_models.CreateSecurityGroupRequest,
    ) -> ens_20171110_models.CreateSecurityGroupResponse:
        """
        @summary Creates a security group.
        
        @param request: CreateSecurityGroupRequest
        @return: CreateSecurityGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_security_group_with_options(request, runtime)

    async def create_security_group_async(
        self,
        request: ens_20171110_models.CreateSecurityGroupRequest,
    ) -> ens_20171110_models.CreateSecurityGroupResponse:
        """
        @summary Creates a security group.
        
        @param request: CreateSecurityGroupRequest
        @return: CreateSecurityGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_security_group_with_options_async(request, runtime)

    def create_snapshot_with_options(
        self,
        request: ens_20171110_models.CreateSnapshotRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateSnapshotResponse:
        """
        @summary Creates a snapshot.
        
        @param request: CreateSnapshotRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSnapshotResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.disk_id):
            query['DiskId'] = request.disk_id
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.instance_billing_cycle):
            query['InstanceBillingCycle'] = request.instance_billing_cycle
        if not UtilClient.is_unset(request.snapshot_name):
            query['SnapshotName'] = request.snapshot_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSnapshot',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateSnapshotResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_snapshot_with_options_async(
        self,
        request: ens_20171110_models.CreateSnapshotRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateSnapshotResponse:
        """
        @summary Creates a snapshot.
        
        @param request: CreateSnapshotRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSnapshotResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.disk_id):
            query['DiskId'] = request.disk_id
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.instance_billing_cycle):
            query['InstanceBillingCycle'] = request.instance_billing_cycle
        if not UtilClient.is_unset(request.snapshot_name):
            query['SnapshotName'] = request.snapshot_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSnapshot',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateSnapshotResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_snapshot(
        self,
        request: ens_20171110_models.CreateSnapshotRequest,
    ) -> ens_20171110_models.CreateSnapshotResponse:
        """
        @summary Creates a snapshot.
        
        @param request: CreateSnapshotRequest
        @return: CreateSnapshotResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_snapshot_with_options(request, runtime)

    async def create_snapshot_async(
        self,
        request: ens_20171110_models.CreateSnapshotRequest,
    ) -> ens_20171110_models.CreateSnapshotResponse:
        """
        @summary Creates a snapshot.
        
        @param request: CreateSnapshotRequest
        @return: CreateSnapshotResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_snapshot_with_options_async(request, runtime)

    def create_snat_entry_with_options(
        self,
        request: ens_20171110_models.CreateSnatEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateSnatEntryResponse:
        """
        @summary Adds a source network address translation (SNAT) entry to a specified SNAT table.
        
        @param request: CreateSnatEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSnatEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.eip_affinity):
            query['EipAffinity'] = request.eip_affinity
        if not UtilClient.is_unset(request.idle_timeout):
            query['IdleTimeout'] = request.idle_timeout
        if not UtilClient.is_unset(request.isp_affinity):
            query['IspAffinity'] = request.isp_affinity
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.snat_entry_name):
            query['SnatEntryName'] = request.snat_entry_name
        if not UtilClient.is_unset(request.snat_ip):
            query['SnatIp'] = request.snat_ip
        if not UtilClient.is_unset(request.source_cidr):
            query['SourceCIDR'] = request.source_cidr
        if not UtilClient.is_unset(request.source_network_id):
            query['SourceNetworkId'] = request.source_network_id
        if not UtilClient.is_unset(request.source_vswitch_id):
            query['SourceVSwitchId'] = request.source_vswitch_id
        if not UtilClient.is_unset(request.standby_snat_ip):
            query['StandbySnatIp'] = request.standby_snat_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSnatEntry',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateSnatEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_snat_entry_with_options_async(
        self,
        request: ens_20171110_models.CreateSnatEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateSnatEntryResponse:
        """
        @summary Adds a source network address translation (SNAT) entry to a specified SNAT table.
        
        @param request: CreateSnatEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSnatEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.eip_affinity):
            query['EipAffinity'] = request.eip_affinity
        if not UtilClient.is_unset(request.idle_timeout):
            query['IdleTimeout'] = request.idle_timeout
        if not UtilClient.is_unset(request.isp_affinity):
            query['IspAffinity'] = request.isp_affinity
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.snat_entry_name):
            query['SnatEntryName'] = request.snat_entry_name
        if not UtilClient.is_unset(request.snat_ip):
            query['SnatIp'] = request.snat_ip
        if not UtilClient.is_unset(request.source_cidr):
            query['SourceCIDR'] = request.source_cidr
        if not UtilClient.is_unset(request.source_network_id):
            query['SourceNetworkId'] = request.source_network_id
        if not UtilClient.is_unset(request.source_vswitch_id):
            query['SourceVSwitchId'] = request.source_vswitch_id
        if not UtilClient.is_unset(request.standby_snat_ip):
            query['StandbySnatIp'] = request.standby_snat_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSnatEntry',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateSnatEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_snat_entry(
        self,
        request: ens_20171110_models.CreateSnatEntryRequest,
    ) -> ens_20171110_models.CreateSnatEntryResponse:
        """
        @summary Adds a source network address translation (SNAT) entry to a specified SNAT table.
        
        @param request: CreateSnatEntryRequest
        @return: CreateSnatEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_snat_entry_with_options(request, runtime)

    async def create_snat_entry_async(
        self,
        request: ens_20171110_models.CreateSnatEntryRequest,
    ) -> ens_20171110_models.CreateSnatEntryResponse:
        """
        @summary Adds a source network address translation (SNAT) entry to a specified SNAT table.
        
        @param request: CreateSnatEntryRequest
        @return: CreateSnatEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_snat_entry_with_options_async(request, runtime)

    def create_storage_gateway_with_options(
        self,
        tmp_req: ens_20171110_models.CreateStorageGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateStorageGatewayResponse:
        """
        @summary Creates a storage gateway.
        
        @param tmp_req: CreateStorageGatewayRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateStorageGatewayResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.CreateStorageGatewayShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.order_details):
            request.order_details_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.order_details, 'OrderDetails', 'json')
        query = {}
        if not UtilClient.is_unset(request.order_details_shrink):
            query['OrderDetails'] = request.order_details_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateStorageGateway',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateStorageGatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_storage_gateway_with_options_async(
        self,
        tmp_req: ens_20171110_models.CreateStorageGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateStorageGatewayResponse:
        """
        @summary Creates a storage gateway.
        
        @param tmp_req: CreateStorageGatewayRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateStorageGatewayResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.CreateStorageGatewayShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.order_details):
            request.order_details_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.order_details, 'OrderDetails', 'json')
        query = {}
        if not UtilClient.is_unset(request.order_details_shrink):
            query['OrderDetails'] = request.order_details_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateStorageGateway',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateStorageGatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_storage_gateway(
        self,
        request: ens_20171110_models.CreateStorageGatewayRequest,
    ) -> ens_20171110_models.CreateStorageGatewayResponse:
        """
        @summary Creates a storage gateway.
        
        @param request: CreateStorageGatewayRequest
        @return: CreateStorageGatewayResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_storage_gateway_with_options(request, runtime)

    async def create_storage_gateway_async(
        self,
        request: ens_20171110_models.CreateStorageGatewayRequest,
    ) -> ens_20171110_models.CreateStorageGatewayResponse:
        """
        @summary Creates a storage gateway.
        
        @param request: CreateStorageGatewayRequest
        @return: CreateStorageGatewayResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_storage_gateway_with_options_async(request, runtime)

    def create_storage_volume_with_options(
        self,
        request: ens_20171110_models.CreateStorageVolumeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateStorageVolumeResponse:
        """
        @summary Creates a storage volume.
        
        @param request: CreateStorageVolumeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateStorageVolumeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auth_password):
            query['AuthPassword'] = request.auth_password
        if not UtilClient.is_unset(request.auth_protocol):
            query['AuthProtocol'] = request.auth_protocol
        if not UtilClient.is_unset(request.auth_user):
            query['AuthUser'] = request.auth_user
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.gateway_id):
            query['GatewayId'] = request.gateway_id
        if not UtilClient.is_unset(request.is_auth):
            query['IsAuth'] = request.is_auth
        if not UtilClient.is_unset(request.is_enable):
            query['IsEnable'] = request.is_enable
        if not UtilClient.is_unset(request.storage_id):
            query['StorageId'] = request.storage_id
        if not UtilClient.is_unset(request.volume_name):
            query['VolumeName'] = request.volume_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateStorageVolume',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateStorageVolumeResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_storage_volume_with_options_async(
        self,
        request: ens_20171110_models.CreateStorageVolumeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateStorageVolumeResponse:
        """
        @summary Creates a storage volume.
        
        @param request: CreateStorageVolumeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateStorageVolumeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auth_password):
            query['AuthPassword'] = request.auth_password
        if not UtilClient.is_unset(request.auth_protocol):
            query['AuthProtocol'] = request.auth_protocol
        if not UtilClient.is_unset(request.auth_user):
            query['AuthUser'] = request.auth_user
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.gateway_id):
            query['GatewayId'] = request.gateway_id
        if not UtilClient.is_unset(request.is_auth):
            query['IsAuth'] = request.is_auth
        if not UtilClient.is_unset(request.is_enable):
            query['IsEnable'] = request.is_enable
        if not UtilClient.is_unset(request.storage_id):
            query['StorageId'] = request.storage_id
        if not UtilClient.is_unset(request.volume_name):
            query['VolumeName'] = request.volume_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateStorageVolume',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateStorageVolumeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_storage_volume(
        self,
        request: ens_20171110_models.CreateStorageVolumeRequest,
    ) -> ens_20171110_models.CreateStorageVolumeResponse:
        """
        @summary Creates a storage volume.
        
        @param request: CreateStorageVolumeRequest
        @return: CreateStorageVolumeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_storage_volume_with_options(request, runtime)

    async def create_storage_volume_async(
        self,
        request: ens_20171110_models.CreateStorageVolumeRequest,
    ) -> ens_20171110_models.CreateStorageVolumeResponse:
        """
        @summary Creates a storage volume.
        
        @param request: CreateStorageVolumeRequest
        @return: CreateStorageVolumeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_storage_volume_with_options_async(request, runtime)

    def create_vswitch_with_options(
        self,
        request: ens_20171110_models.CreateVSwitchRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateVSwitchResponse:
        """
        @summary A vSwitch is created.
        
        @param request: CreateVSwitchRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVSwitchResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cidr_block):
            query['CidrBlock'] = request.cidr_block
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.network_id):
            query['NetworkId'] = request.network_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.v_switch_name):
            query['VSwitchName'] = request.v_switch_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVSwitch',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateVSwitchResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vswitch_with_options_async(
        self,
        request: ens_20171110_models.CreateVSwitchRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.CreateVSwitchResponse:
        """
        @summary A vSwitch is created.
        
        @param request: CreateVSwitchRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVSwitchResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cidr_block):
            query['CidrBlock'] = request.cidr_block
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.network_id):
            query['NetworkId'] = request.network_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.v_switch_name):
            query['VSwitchName'] = request.v_switch_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVSwitch',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.CreateVSwitchResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vswitch(
        self,
        request: ens_20171110_models.CreateVSwitchRequest,
    ) -> ens_20171110_models.CreateVSwitchResponse:
        """
        @summary A vSwitch is created.
        
        @param request: CreateVSwitchRequest
        @return: CreateVSwitchResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_vswitch_with_options(request, runtime)

    async def create_vswitch_async(
        self,
        request: ens_20171110_models.CreateVSwitchRequest,
    ) -> ens_20171110_models.CreateVSwitchResponse:
        """
        @summary A vSwitch is created.
        
        @param request: CreateVSwitchRequest
        @return: CreateVSwitchResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_vswitch_with_options_async(request, runtime)

    def delete_application_with_options(
        self,
        request: ens_20171110_models.DeleteApplicationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteApplicationResponse:
        """
        @summary Releases all containers and resource instances related to a specific application in an asynchronous manner.
        
        @param request: DeleteApplicationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteApplicationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.timeout):
            query['Timeout'] = request.timeout
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteApplication',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteApplicationResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_application_with_options_async(
        self,
        request: ens_20171110_models.DeleteApplicationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteApplicationResponse:
        """
        @summary Releases all containers and resource instances related to a specific application in an asynchronous manner.
        
        @param request: DeleteApplicationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteApplicationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.timeout):
            query['Timeout'] = request.timeout
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteApplication',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteApplicationResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_application(
        self,
        request: ens_20171110_models.DeleteApplicationRequest,
    ) -> ens_20171110_models.DeleteApplicationResponse:
        """
        @summary Releases all containers and resource instances related to a specific application in an asynchronous manner.
        
        @param request: DeleteApplicationRequest
        @return: DeleteApplicationResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_application_with_options(request, runtime)

    async def delete_application_async(
        self,
        request: ens_20171110_models.DeleteApplicationRequest,
    ) -> ens_20171110_models.DeleteApplicationResponse:
        """
        @summary Releases all containers and resource instances related to a specific application in an asynchronous manner.
        
        @param request: DeleteApplicationRequest
        @return: DeleteApplicationResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_application_with_options_async(request, runtime)

    def delete_bucket_with_options(
        self,
        request: ens_20171110_models.DeleteBucketRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteBucketResponse:
        """
        @summary Deletes a bucket.
        
        @description    Only the Alibaba Cloud Account ID owner of a bucket can delete the bucket from the account.
        You cannot delete buckets that store objects. You can only delete empty buckets.
        
        @param request: DeleteBucketRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteBucketResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bucket_name):
            query['BucketName'] = request.bucket_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteBucket',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteBucketResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_bucket_with_options_async(
        self,
        request: ens_20171110_models.DeleteBucketRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteBucketResponse:
        """
        @summary Deletes a bucket.
        
        @description    Only the Alibaba Cloud Account ID owner of a bucket can delete the bucket from the account.
        You cannot delete buckets that store objects. You can only delete empty buckets.
        
        @param request: DeleteBucketRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteBucketResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bucket_name):
            query['BucketName'] = request.bucket_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteBucket',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteBucketResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_bucket(
        self,
        request: ens_20171110_models.DeleteBucketRequest,
    ) -> ens_20171110_models.DeleteBucketResponse:
        """
        @summary Deletes a bucket.
        
        @description    Only the Alibaba Cloud Account ID owner of a bucket can delete the bucket from the account.
        You cannot delete buckets that store objects. You can only delete empty buckets.
        
        @param request: DeleteBucketRequest
        @return: DeleteBucketResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_bucket_with_options(request, runtime)

    async def delete_bucket_async(
        self,
        request: ens_20171110_models.DeleteBucketRequest,
    ) -> ens_20171110_models.DeleteBucketResponse:
        """
        @summary Deletes a bucket.
        
        @description    Only the Alibaba Cloud Account ID owner of a bucket can delete the bucket from the account.
        You cannot delete buckets that store objects. You can only delete empty buckets.
        
        @param request: DeleteBucketRequest
        @return: DeleteBucketResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_bucket_with_options_async(request, runtime)

    def delete_bucket_lifecycle_with_options(
        self,
        request: ens_20171110_models.DeleteBucketLifecycleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteBucketLifecycleResponse:
        """
        @summary Deletes the lifecycle rules for objects in a bucket.
        
        @param request: DeleteBucketLifecycleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteBucketLifecycleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bucket_name):
            query['BucketName'] = request.bucket_name
        if not UtilClient.is_unset(request.rule_id):
            query['RuleId'] = request.rule_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteBucketLifecycle',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteBucketLifecycleResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_bucket_lifecycle_with_options_async(
        self,
        request: ens_20171110_models.DeleteBucketLifecycleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteBucketLifecycleResponse:
        """
        @summary Deletes the lifecycle rules for objects in a bucket.
        
        @param request: DeleteBucketLifecycleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteBucketLifecycleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bucket_name):
            query['BucketName'] = request.bucket_name
        if not UtilClient.is_unset(request.rule_id):
            query['RuleId'] = request.rule_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteBucketLifecycle',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteBucketLifecycleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_bucket_lifecycle(
        self,
        request: ens_20171110_models.DeleteBucketLifecycleRequest,
    ) -> ens_20171110_models.DeleteBucketLifecycleResponse:
        """
        @summary Deletes the lifecycle rules for objects in a bucket.
        
        @param request: DeleteBucketLifecycleRequest
        @return: DeleteBucketLifecycleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_bucket_lifecycle_with_options(request, runtime)

    async def delete_bucket_lifecycle_async(
        self,
        request: ens_20171110_models.DeleteBucketLifecycleRequest,
    ) -> ens_20171110_models.DeleteBucketLifecycleResponse:
        """
        @summary Deletes the lifecycle rules for objects in a bucket.
        
        @param request: DeleteBucketLifecycleRequest
        @return: DeleteBucketLifecycleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_bucket_lifecycle_with_options_async(request, runtime)

    def delete_disk_with_options(
        self,
        request: ens_20171110_models.DeleteDiskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteDiskResponse:
        """
        @summary Deletes a disk.
        
        @description When you release a disk, the disk must be in the Available state.
        
        @param request: DeleteDiskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDiskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.disk_id):
            query['DiskId'] = request.disk_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDisk',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteDiskResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_disk_with_options_async(
        self,
        request: ens_20171110_models.DeleteDiskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteDiskResponse:
        """
        @summary Deletes a disk.
        
        @description When you release a disk, the disk must be in the Available state.
        
        @param request: DeleteDiskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDiskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.disk_id):
            query['DiskId'] = request.disk_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDisk',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteDiskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_disk(
        self,
        request: ens_20171110_models.DeleteDiskRequest,
    ) -> ens_20171110_models.DeleteDiskResponse:
        """
        @summary Deletes a disk.
        
        @description When you release a disk, the disk must be in the Available state.
        
        @param request: DeleteDiskRequest
        @return: DeleteDiskResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_disk_with_options(request, runtime)

    async def delete_disk_async(
        self,
        request: ens_20171110_models.DeleteDiskRequest,
    ) -> ens_20171110_models.DeleteDiskResponse:
        """
        @summary Deletes a disk.
        
        @description When you release a disk, the disk must be in the Available state.
        
        @param request: DeleteDiskRequest
        @return: DeleteDiskResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_disk_with_options_async(request, runtime)

    def delete_eip_with_options(
        self,
        request: ens_20171110_models.DeleteEipRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteEipResponse:
        """
        @summary 调用DeleteEip删除后付费的弹性公网EIP实例。
        
        @param request: DeleteEipRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteEipResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteEip',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteEipResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_eip_with_options_async(
        self,
        request: ens_20171110_models.DeleteEipRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteEipResponse:
        """
        @summary 调用DeleteEip删除后付费的弹性公网EIP实例。
        
        @param request: DeleteEipRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteEipResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteEip',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteEipResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_eip(
        self,
        request: ens_20171110_models.DeleteEipRequest,
    ) -> ens_20171110_models.DeleteEipResponse:
        """
        @summary 调用DeleteEip删除后付费的弹性公网EIP实例。
        
        @param request: DeleteEipRequest
        @return: DeleteEipResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_eip_with_options(request, runtime)

    async def delete_eip_async(
        self,
        request: ens_20171110_models.DeleteEipRequest,
    ) -> ens_20171110_models.DeleteEipResponse:
        """
        @summary 调用DeleteEip删除后付费的弹性公网EIP实例。
        
        @param request: DeleteEipRequest
        @return: DeleteEipResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_eip_with_options_async(request, runtime)

    def delete_ens_route_entry_with_options(
        self,
        request: ens_20171110_models.DeleteEnsRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteEnsRouteEntryResponse:
        """
        @summary Deletes a custom route entry.
        
        @param request: DeleteEnsRouteEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteEnsRouteEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.route_entry_id):
            query['RouteEntryId'] = request.route_entry_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteEnsRouteEntry',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteEnsRouteEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_ens_route_entry_with_options_async(
        self,
        request: ens_20171110_models.DeleteEnsRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteEnsRouteEntryResponse:
        """
        @summary Deletes a custom route entry.
        
        @param request: DeleteEnsRouteEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteEnsRouteEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.route_entry_id):
            query['RouteEntryId'] = request.route_entry_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteEnsRouteEntry',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteEnsRouteEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_ens_route_entry(
        self,
        request: ens_20171110_models.DeleteEnsRouteEntryRequest,
    ) -> ens_20171110_models.DeleteEnsRouteEntryResponse:
        """
        @summary Deletes a custom route entry.
        
        @param request: DeleteEnsRouteEntryRequest
        @return: DeleteEnsRouteEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_ens_route_entry_with_options(request, runtime)

    async def delete_ens_route_entry_async(
        self,
        request: ens_20171110_models.DeleteEnsRouteEntryRequest,
    ) -> ens_20171110_models.DeleteEnsRouteEntryResponse:
        """
        @summary Deletes a custom route entry.
        
        @param request: DeleteEnsRouteEntryRequest
        @return: DeleteEnsRouteEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_ens_route_entry_with_options_async(request, runtime)

    def delete_ens_sale_condition_control_with_options(
        self,
        tmp_req: ens_20171110_models.DeleteEnsSaleConditionControlRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteEnsSaleConditionControlResponse:
        """
        @summary 删除售卖约束的条件约束
        
        @param tmp_req: DeleteEnsSaleConditionControlRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteEnsSaleConditionControlResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.DeleteEnsSaleConditionControlShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.sale_controls):
            request.sale_controls_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.sale_controls, 'SaleControls', 'json')
        query = {}
        if not UtilClient.is_unset(request.ali_uid_account):
            query['AliUidAccount'] = request.ali_uid_account
        if not UtilClient.is_unset(request.commodity_code):
            query['CommodityCode'] = request.commodity_code
        if not UtilClient.is_unset(request.custom_account):
            query['CustomAccount'] = request.custom_account
        if not UtilClient.is_unset(request.sale_controls_shrink):
            query['SaleControls'] = request.sale_controls_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteEnsSaleConditionControl',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteEnsSaleConditionControlResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_ens_sale_condition_control_with_options_async(
        self,
        tmp_req: ens_20171110_models.DeleteEnsSaleConditionControlRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteEnsSaleConditionControlResponse:
        """
        @summary 删除售卖约束的条件约束
        
        @param tmp_req: DeleteEnsSaleConditionControlRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteEnsSaleConditionControlResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.DeleteEnsSaleConditionControlShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.sale_controls):
            request.sale_controls_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.sale_controls, 'SaleControls', 'json')
        query = {}
        if not UtilClient.is_unset(request.ali_uid_account):
            query['AliUidAccount'] = request.ali_uid_account
        if not UtilClient.is_unset(request.commodity_code):
            query['CommodityCode'] = request.commodity_code
        if not UtilClient.is_unset(request.custom_account):
            query['CustomAccount'] = request.custom_account
        if not UtilClient.is_unset(request.sale_controls_shrink):
            query['SaleControls'] = request.sale_controls_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteEnsSaleConditionControl',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteEnsSaleConditionControlResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_ens_sale_condition_control(
        self,
        request: ens_20171110_models.DeleteEnsSaleConditionControlRequest,
    ) -> ens_20171110_models.DeleteEnsSaleConditionControlResponse:
        """
        @summary 删除售卖约束的条件约束
        
        @param request: DeleteEnsSaleConditionControlRequest
        @return: DeleteEnsSaleConditionControlResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_ens_sale_condition_control_with_options(request, runtime)

    async def delete_ens_sale_condition_control_async(
        self,
        request: ens_20171110_models.DeleteEnsSaleConditionControlRequest,
    ) -> ens_20171110_models.DeleteEnsSaleConditionControlResponse:
        """
        @summary 删除售卖约束的条件约束
        
        @param request: DeleteEnsSaleConditionControlRequest
        @return: DeleteEnsSaleConditionControlResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_ens_sale_condition_control_with_options_async(request, runtime)

    def delete_ens_sale_control_with_options(
        self,
        tmp_req: ens_20171110_models.DeleteEnsSaleControlRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteEnsSaleControlResponse:
        """
        @summary 删除售卖约束基础约束
        
        @param tmp_req: DeleteEnsSaleControlRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteEnsSaleControlResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.DeleteEnsSaleControlShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.sale_controls):
            request.sale_controls_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.sale_controls, 'SaleControls', 'json')
        query = {}
        if not UtilClient.is_unset(request.ali_uid_account):
            query['AliUidAccount'] = request.ali_uid_account
        if not UtilClient.is_unset(request.commodity_code):
            query['CommodityCode'] = request.commodity_code
        if not UtilClient.is_unset(request.custom_account):
            query['CustomAccount'] = request.custom_account
        if not UtilClient.is_unset(request.sale_controls_shrink):
            query['SaleControls'] = request.sale_controls_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteEnsSaleControl',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteEnsSaleControlResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_ens_sale_control_with_options_async(
        self,
        tmp_req: ens_20171110_models.DeleteEnsSaleControlRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteEnsSaleControlResponse:
        """
        @summary 删除售卖约束基础约束
        
        @param tmp_req: DeleteEnsSaleControlRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteEnsSaleControlResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.DeleteEnsSaleControlShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.sale_controls):
            request.sale_controls_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.sale_controls, 'SaleControls', 'json')
        query = {}
        if not UtilClient.is_unset(request.ali_uid_account):
            query['AliUidAccount'] = request.ali_uid_account
        if not UtilClient.is_unset(request.commodity_code):
            query['CommodityCode'] = request.commodity_code
        if not UtilClient.is_unset(request.custom_account):
            query['CustomAccount'] = request.custom_account
        if not UtilClient.is_unset(request.sale_controls_shrink):
            query['SaleControls'] = request.sale_controls_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteEnsSaleControl',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteEnsSaleControlResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_ens_sale_control(
        self,
        request: ens_20171110_models.DeleteEnsSaleControlRequest,
    ) -> ens_20171110_models.DeleteEnsSaleControlResponse:
        """
        @summary 删除售卖约束基础约束
        
        @param request: DeleteEnsSaleControlRequest
        @return: DeleteEnsSaleControlResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_ens_sale_control_with_options(request, runtime)

    async def delete_ens_sale_control_async(
        self,
        request: ens_20171110_models.DeleteEnsSaleControlRequest,
    ) -> ens_20171110_models.DeleteEnsSaleControlResponse:
        """
        @summary 删除售卖约束基础约束
        
        @param request: DeleteEnsSaleControlRequest
        @return: DeleteEnsSaleControlResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_ens_sale_control_with_options_async(request, runtime)

    def delete_epn_instance_with_options(
        self,
        request: ens_20171110_models.DeleteEpnInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteEpnInstanceResponse:
        """
        @summary Deletes an edge private network (EPN) instance.
        
        @description You can delete an EPN instance only when the instance group information is empty.
        
        @param request: DeleteEpnInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteEpnInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.epninstance_id):
            query['EPNInstanceId'] = request.epninstance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteEpnInstance',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteEpnInstanceResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_epn_instance_with_options_async(
        self,
        request: ens_20171110_models.DeleteEpnInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteEpnInstanceResponse:
        """
        @summary Deletes an edge private network (EPN) instance.
        
        @description You can delete an EPN instance only when the instance group information is empty.
        
        @param request: DeleteEpnInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteEpnInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.epninstance_id):
            query['EPNInstanceId'] = request.epninstance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteEpnInstance',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteEpnInstanceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_epn_instance(
        self,
        request: ens_20171110_models.DeleteEpnInstanceRequest,
    ) -> ens_20171110_models.DeleteEpnInstanceResponse:
        """
        @summary Deletes an edge private network (EPN) instance.
        
        @description You can delete an EPN instance only when the instance group information is empty.
        
        @param request: DeleteEpnInstanceRequest
        @return: DeleteEpnInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_epn_instance_with_options(request, runtime)

    async def delete_epn_instance_async(
        self,
        request: ens_20171110_models.DeleteEpnInstanceRequest,
    ) -> ens_20171110_models.DeleteEpnInstanceResponse:
        """
        @summary Deletes an edge private network (EPN) instance.
        
        @description You can delete an EPN instance only when the instance group information is empty.
        
        @param request: DeleteEpnInstanceRequest
        @return: DeleteEpnInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_epn_instance_with_options_async(request, runtime)

    def delete_file_system_with_options(
        self,
        request: ens_20171110_models.DeleteFileSystemRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteFileSystemResponse:
        """
        @summary Deletes a File Storage NAS file system.
        
        @param request: DeleteFileSystemRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteFileSystemResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteFileSystem',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteFileSystemResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_file_system_with_options_async(
        self,
        request: ens_20171110_models.DeleteFileSystemRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteFileSystemResponse:
        """
        @summary Deletes a File Storage NAS file system.
        
        @param request: DeleteFileSystemRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteFileSystemResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteFileSystem',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteFileSystemResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_file_system(
        self,
        request: ens_20171110_models.DeleteFileSystemRequest,
    ) -> ens_20171110_models.DeleteFileSystemResponse:
        """
        @summary Deletes a File Storage NAS file system.
        
        @param request: DeleteFileSystemRequest
        @return: DeleteFileSystemResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_file_system_with_options(request, runtime)

    async def delete_file_system_async(
        self,
        request: ens_20171110_models.DeleteFileSystemRequest,
    ) -> ens_20171110_models.DeleteFileSystemResponse:
        """
        @summary Deletes a File Storage NAS file system.
        
        @param request: DeleteFileSystemRequest
        @return: DeleteFileSystemResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_file_system_with_options_async(request, runtime)

    def delete_forward_entry_with_options(
        self,
        request: ens_20171110_models.DeleteForwardEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteForwardEntryResponse:
        """
        @summary Deletes a Destination Network Address Translation (DNAT) entry from a specified DNAT table.
        
        @param request: DeleteForwardEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteForwardEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.forward_entry_id):
            query['ForwardEntryId'] = request.forward_entry_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteForwardEntry',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteForwardEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_forward_entry_with_options_async(
        self,
        request: ens_20171110_models.DeleteForwardEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteForwardEntryResponse:
        """
        @summary Deletes a Destination Network Address Translation (DNAT) entry from a specified DNAT table.
        
        @param request: DeleteForwardEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteForwardEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.forward_entry_id):
            query['ForwardEntryId'] = request.forward_entry_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteForwardEntry',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteForwardEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_forward_entry(
        self,
        request: ens_20171110_models.DeleteForwardEntryRequest,
    ) -> ens_20171110_models.DeleteForwardEntryResponse:
        """
        @summary Deletes a Destination Network Address Translation (DNAT) entry from a specified DNAT table.
        
        @param request: DeleteForwardEntryRequest
        @return: DeleteForwardEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_forward_entry_with_options(request, runtime)

    async def delete_forward_entry_async(
        self,
        request: ens_20171110_models.DeleteForwardEntryRequest,
    ) -> ens_20171110_models.DeleteForwardEntryResponse:
        """
        @summary Deletes a Destination Network Address Translation (DNAT) entry from a specified DNAT table.
        
        @param request: DeleteForwardEntryRequest
        @return: DeleteForwardEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_forward_entry_with_options_async(request, runtime)

    def delete_ha_vips_with_options(
        self,
        tmp_req: ens_20171110_models.DeleteHaVipsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteHaVipsResponse:
        """
        @summary 删除高可用VIP实例
        
        @param tmp_req: DeleteHaVipsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteHaVipsResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.DeleteHaVipsShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.ha_vip_ids):
            request.ha_vip_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.ha_vip_ids, 'HaVipIds', 'json')
        query = {}
        if not UtilClient.is_unset(request.ha_vip_ids_shrink):
            query['HaVipIds'] = request.ha_vip_ids_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteHaVips',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteHaVipsResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_ha_vips_with_options_async(
        self,
        tmp_req: ens_20171110_models.DeleteHaVipsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteHaVipsResponse:
        """
        @summary 删除高可用VIP实例
        
        @param tmp_req: DeleteHaVipsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteHaVipsResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.DeleteHaVipsShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.ha_vip_ids):
            request.ha_vip_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.ha_vip_ids, 'HaVipIds', 'json')
        query = {}
        if not UtilClient.is_unset(request.ha_vip_ids_shrink):
            query['HaVipIds'] = request.ha_vip_ids_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteHaVips',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteHaVipsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_ha_vips(
        self,
        request: ens_20171110_models.DeleteHaVipsRequest,
    ) -> ens_20171110_models.DeleteHaVipsResponse:
        """
        @summary 删除高可用VIP实例
        
        @param request: DeleteHaVipsRequest
        @return: DeleteHaVipsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_ha_vips_with_options(request, runtime)

    async def delete_ha_vips_async(
        self,
        request: ens_20171110_models.DeleteHaVipsRequest,
    ) -> ens_20171110_models.DeleteHaVipsResponse:
        """
        @summary 删除高可用VIP实例
        
        @param request: DeleteHaVipsRequest
        @return: DeleteHaVipsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_ha_vips_with_options_async(request, runtime)

    def delete_image_with_options(
        self,
        request: ens_20171110_models.DeleteImageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteImageResponse:
        """
        @summary Deletes a custom image.
        
        @param request: DeleteImageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteImageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteImage',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteImageResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_image_with_options_async(
        self,
        request: ens_20171110_models.DeleteImageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteImageResponse:
        """
        @summary Deletes a custom image.
        
        @param request: DeleteImageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteImageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteImage',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteImageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_image(
        self,
        request: ens_20171110_models.DeleteImageRequest,
    ) -> ens_20171110_models.DeleteImageResponse:
        """
        @summary Deletes a custom image.
        
        @param request: DeleteImageRequest
        @return: DeleteImageResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_image_with_options(request, runtime)

    async def delete_image_async(
        self,
        request: ens_20171110_models.DeleteImageRequest,
    ) -> ens_20171110_models.DeleteImageResponse:
        """
        @summary Deletes a custom image.
        
        @param request: DeleteImageRequest
        @return: DeleteImageResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_image_with_options_async(request, runtime)

    def delete_key_pairs_with_options(
        self,
        request: ens_20171110_models.DeleteKeyPairsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteKeyPairsResponse:
        """
        @summary Deletes SSH key pairs.
        
        @description    After you delete an SSH key pair, you can no longer query the key pair by calling the DescribeKeyPairs operation.
        If you delete an SSH key pair that is bound to an Edge Node Service (ENS) instance, ENS no longer stores the SSH key pair. However, you can still use the key pair to access the instance. When you call the DescribeInstance operation to query instance information, no other information but the name of the key pair (**KeyPairName**) is returned.
        
        @param request: DeleteKeyPairsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteKeyPairsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.key_pair_id):
            query['KeyPairId'] = request.key_pair_id
        if not UtilClient.is_unset(request.key_pair_name):
            query['KeyPairName'] = request.key_pair_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteKeyPairs',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteKeyPairsResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_key_pairs_with_options_async(
        self,
        request: ens_20171110_models.DeleteKeyPairsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteKeyPairsResponse:
        """
        @summary Deletes SSH key pairs.
        
        @description    After you delete an SSH key pair, you can no longer query the key pair by calling the DescribeKeyPairs operation.
        If you delete an SSH key pair that is bound to an Edge Node Service (ENS) instance, ENS no longer stores the SSH key pair. However, you can still use the key pair to access the instance. When you call the DescribeInstance operation to query instance information, no other information but the name of the key pair (**KeyPairName**) is returned.
        
        @param request: DeleteKeyPairsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteKeyPairsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.key_pair_id):
            query['KeyPairId'] = request.key_pair_id
        if not UtilClient.is_unset(request.key_pair_name):
            query['KeyPairName'] = request.key_pair_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteKeyPairs',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteKeyPairsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_key_pairs(
        self,
        request: ens_20171110_models.DeleteKeyPairsRequest,
    ) -> ens_20171110_models.DeleteKeyPairsResponse:
        """
        @summary Deletes SSH key pairs.
        
        @description    After you delete an SSH key pair, you can no longer query the key pair by calling the DescribeKeyPairs operation.
        If you delete an SSH key pair that is bound to an Edge Node Service (ENS) instance, ENS no longer stores the SSH key pair. However, you can still use the key pair to access the instance. When you call the DescribeInstance operation to query instance information, no other information but the name of the key pair (**KeyPairName**) is returned.
        
        @param request: DeleteKeyPairsRequest
        @return: DeleteKeyPairsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_key_pairs_with_options(request, runtime)

    async def delete_key_pairs_async(
        self,
        request: ens_20171110_models.DeleteKeyPairsRequest,
    ) -> ens_20171110_models.DeleteKeyPairsResponse:
        """
        @summary Deletes SSH key pairs.
        
        @description    After you delete an SSH key pair, you can no longer query the key pair by calling the DescribeKeyPairs operation.
        If you delete an SSH key pair that is bound to an Edge Node Service (ENS) instance, ENS no longer stores the SSH key pair. However, you can still use the key pair to access the instance. When you call the DescribeInstance operation to query instance information, no other information but the name of the key pair (**KeyPairName**) is returned.
        
        @param request: DeleteKeyPairsRequest
        @return: DeleteKeyPairsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_key_pairs_with_options_async(request, runtime)

    def delete_load_balancer_listener_with_options(
        self,
        request: ens_20171110_models.DeleteLoadBalancerListenerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteLoadBalancerListenerResponse:
        """
        @summary Deletes a listener.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: DeleteLoadBalancerListenerRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLoadBalancerListenerResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.listener_port):
            query['ListenerPort'] = request.listener_port
        if not UtilClient.is_unset(request.listener_protocol):
            query['ListenerProtocol'] = request.listener_protocol
        if not UtilClient.is_unset(request.load_balancer_id):
            query['LoadBalancerId'] = request.load_balancer_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLoadBalancerListener',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteLoadBalancerListenerResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_load_balancer_listener_with_options_async(
        self,
        request: ens_20171110_models.DeleteLoadBalancerListenerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteLoadBalancerListenerResponse:
        """
        @summary Deletes a listener.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: DeleteLoadBalancerListenerRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLoadBalancerListenerResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.listener_port):
            query['ListenerPort'] = request.listener_port
        if not UtilClient.is_unset(request.listener_protocol):
            query['ListenerProtocol'] = request.listener_protocol
        if not UtilClient.is_unset(request.load_balancer_id):
            query['LoadBalancerId'] = request.load_balancer_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLoadBalancerListener',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteLoadBalancerListenerResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_load_balancer_listener(
        self,
        request: ens_20171110_models.DeleteLoadBalancerListenerRequest,
    ) -> ens_20171110_models.DeleteLoadBalancerListenerResponse:
        """
        @summary Deletes a listener.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: DeleteLoadBalancerListenerRequest
        @return: DeleteLoadBalancerListenerResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_load_balancer_listener_with_options(request, runtime)

    async def delete_load_balancer_listener_async(
        self,
        request: ens_20171110_models.DeleteLoadBalancerListenerRequest,
    ) -> ens_20171110_models.DeleteLoadBalancerListenerResponse:
        """
        @summary Deletes a listener.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: DeleteLoadBalancerListenerRequest
        @return: DeleteLoadBalancerListenerResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_load_balancer_listener_with_options_async(request, runtime)

    def delete_mount_target_with_options(
        self,
        request: ens_20171110_models.DeleteMountTargetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteMountTargetResponse:
        """
        @summary Deletes a mount target.
        
        @description After you delete a mount target, the mount target cannot be restored. Proceed with caution.
        
        @param request: DeleteMountTargetRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteMountTargetResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.file_system_id):
            query['FileSystemId'] = request.file_system_id
        if not UtilClient.is_unset(request.mount_target_name):
            query['MountTargetName'] = request.mount_target_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteMountTarget',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteMountTargetResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_mount_target_with_options_async(
        self,
        request: ens_20171110_models.DeleteMountTargetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteMountTargetResponse:
        """
        @summary Deletes a mount target.
        
        @description After you delete a mount target, the mount target cannot be restored. Proceed with caution.
        
        @param request: DeleteMountTargetRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteMountTargetResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.file_system_id):
            query['FileSystemId'] = request.file_system_id
        if not UtilClient.is_unset(request.mount_target_name):
            query['MountTargetName'] = request.mount_target_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteMountTarget',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteMountTargetResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_mount_target(
        self,
        request: ens_20171110_models.DeleteMountTargetRequest,
    ) -> ens_20171110_models.DeleteMountTargetResponse:
        """
        @summary Deletes a mount target.
        
        @description After you delete a mount target, the mount target cannot be restored. Proceed with caution.
        
        @param request: DeleteMountTargetRequest
        @return: DeleteMountTargetResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_mount_target_with_options(request, runtime)

    async def delete_mount_target_async(
        self,
        request: ens_20171110_models.DeleteMountTargetRequest,
    ) -> ens_20171110_models.DeleteMountTargetResponse:
        """
        @summary Deletes a mount target.
        
        @description After you delete a mount target, the mount target cannot be restored. Proceed with caution.
        
        @param request: DeleteMountTargetRequest
        @return: DeleteMountTargetResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_mount_target_with_options_async(request, runtime)

    def delete_nat_gateway_with_options(
        self,
        request: ens_20171110_models.DeleteNatGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteNatGatewayResponse:
        """
        @summary Deletes an Internet network address translation (NAT) gateway.
        
        @param request: DeleteNatGatewayRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNatGatewayResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.force_delete):
            query['ForceDelete'] = request.force_delete
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNatGateway',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteNatGatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_nat_gateway_with_options_async(
        self,
        request: ens_20171110_models.DeleteNatGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteNatGatewayResponse:
        """
        @summary Deletes an Internet network address translation (NAT) gateway.
        
        @param request: DeleteNatGatewayRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNatGatewayResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.force_delete):
            query['ForceDelete'] = request.force_delete
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNatGateway',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteNatGatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_nat_gateway(
        self,
        request: ens_20171110_models.DeleteNatGatewayRequest,
    ) -> ens_20171110_models.DeleteNatGatewayResponse:
        """
        @summary Deletes an Internet network address translation (NAT) gateway.
        
        @param request: DeleteNatGatewayRequest
        @return: DeleteNatGatewayResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_nat_gateway_with_options(request, runtime)

    async def delete_nat_gateway_async(
        self,
        request: ens_20171110_models.DeleteNatGatewayRequest,
    ) -> ens_20171110_models.DeleteNatGatewayResponse:
        """
        @summary Deletes an Internet network address translation (NAT) gateway.
        
        @param request: DeleteNatGatewayRequest
        @return: DeleteNatGatewayResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_nat_gateway_with_options_async(request, runtime)

    def delete_network_with_options(
        self,
        request: ens_20171110_models.DeleteNetworkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteNetworkResponse:
        """
        @summary Deletes a virtual private cloud (VPC).
        
        @param request: DeleteNetworkRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNetworkResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.network_id):
            query['NetworkId'] = request.network_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNetwork',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteNetworkResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_network_with_options_async(
        self,
        request: ens_20171110_models.DeleteNetworkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteNetworkResponse:
        """
        @summary Deletes a virtual private cloud (VPC).
        
        @param request: DeleteNetworkRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNetworkResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.network_id):
            query['NetworkId'] = request.network_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNetwork',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteNetworkResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_network(
        self,
        request: ens_20171110_models.DeleteNetworkRequest,
    ) -> ens_20171110_models.DeleteNetworkResponse:
        """
        @summary Deletes a virtual private cloud (VPC).
        
        @param request: DeleteNetworkRequest
        @return: DeleteNetworkResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_network_with_options(request, runtime)

    async def delete_network_async(
        self,
        request: ens_20171110_models.DeleteNetworkRequest,
    ) -> ens_20171110_models.DeleteNetworkResponse:
        """
        @summary Deletes a virtual private cloud (VPC).
        
        @param request: DeleteNetworkRequest
        @return: DeleteNetworkResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_network_with_options_async(request, runtime)

    def delete_network_acl_with_options(
        self,
        request: ens_20171110_models.DeleteNetworkAclRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteNetworkAclResponse:
        """
        @summary Deletes a network access control list (ACL).
        
        @param request: DeleteNetworkAclRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNetworkAclResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.network_acl_id):
            query['NetworkAclId'] = request.network_acl_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNetworkAcl',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteNetworkAclResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_network_acl_with_options_async(
        self,
        request: ens_20171110_models.DeleteNetworkAclRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteNetworkAclResponse:
        """
        @summary Deletes a network access control list (ACL).
        
        @param request: DeleteNetworkAclRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNetworkAclResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.network_acl_id):
            query['NetworkAclId'] = request.network_acl_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNetworkAcl',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteNetworkAclResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_network_acl(
        self,
        request: ens_20171110_models.DeleteNetworkAclRequest,
    ) -> ens_20171110_models.DeleteNetworkAclResponse:
        """
        @summary Deletes a network access control list (ACL).
        
        @param request: DeleteNetworkAclRequest
        @return: DeleteNetworkAclResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_network_acl_with_options(request, runtime)

    async def delete_network_acl_async(
        self,
        request: ens_20171110_models.DeleteNetworkAclRequest,
    ) -> ens_20171110_models.DeleteNetworkAclResponse:
        """
        @summary Deletes a network access control list (ACL).
        
        @param request: DeleteNetworkAclRequest
        @return: DeleteNetworkAclResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_network_acl_with_options_async(request, runtime)

    def delete_network_acl_entry_with_options(
        self,
        request: ens_20171110_models.DeleteNetworkAclEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteNetworkAclEntryResponse:
        """
        @summary Deletes a network access control list (ACL) rule.
        
        @param request: DeleteNetworkAclEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNetworkAclEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.network_acl_entry_id):
            query['NetworkAclEntryId'] = request.network_acl_entry_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNetworkAclEntry',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteNetworkAclEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_network_acl_entry_with_options_async(
        self,
        request: ens_20171110_models.DeleteNetworkAclEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteNetworkAclEntryResponse:
        """
        @summary Deletes a network access control list (ACL) rule.
        
        @param request: DeleteNetworkAclEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNetworkAclEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.network_acl_entry_id):
            query['NetworkAclEntryId'] = request.network_acl_entry_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNetworkAclEntry',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteNetworkAclEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_network_acl_entry(
        self,
        request: ens_20171110_models.DeleteNetworkAclEntryRequest,
    ) -> ens_20171110_models.DeleteNetworkAclEntryResponse:
        """
        @summary Deletes a network access control list (ACL) rule.
        
        @param request: DeleteNetworkAclEntryRequest
        @return: DeleteNetworkAclEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_network_acl_entry_with_options(request, runtime)

    async def delete_network_acl_entry_async(
        self,
        request: ens_20171110_models.DeleteNetworkAclEntryRequest,
    ) -> ens_20171110_models.DeleteNetworkAclEntryResponse:
        """
        @summary Deletes a network access control list (ACL) rule.
        
        @param request: DeleteNetworkAclEntryRequest
        @return: DeleteNetworkAclEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_network_acl_entry_with_options_async(request, runtime)

    def delete_network_interfaces_with_options(
        self,
        tmp_req: ens_20171110_models.DeleteNetworkInterfacesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteNetworkInterfacesResponse:
        """
        @summary 删除弹性网卡
        
        @param tmp_req: DeleteNetworkInterfacesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNetworkInterfacesResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.DeleteNetworkInterfacesShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.network_interface_ids):
            request.network_interface_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.network_interface_ids, 'NetworkInterfaceIds', 'json')
        query = {}
        if not UtilClient.is_unset(request.network_interface_ids_shrink):
            query['NetworkInterfaceIds'] = request.network_interface_ids_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNetworkInterfaces',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteNetworkInterfacesResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_network_interfaces_with_options_async(
        self,
        tmp_req: ens_20171110_models.DeleteNetworkInterfacesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteNetworkInterfacesResponse:
        """
        @summary 删除弹性网卡
        
        @param tmp_req: DeleteNetworkInterfacesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNetworkInterfacesResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.DeleteNetworkInterfacesShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.network_interface_ids):
            request.network_interface_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.network_interface_ids, 'NetworkInterfaceIds', 'json')
        query = {}
        if not UtilClient.is_unset(request.network_interface_ids_shrink):
            query['NetworkInterfaceIds'] = request.network_interface_ids_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNetworkInterfaces',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteNetworkInterfacesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_network_interfaces(
        self,
        request: ens_20171110_models.DeleteNetworkInterfacesRequest,
    ) -> ens_20171110_models.DeleteNetworkInterfacesResponse:
        """
        @summary 删除弹性网卡
        
        @param request: DeleteNetworkInterfacesRequest
        @return: DeleteNetworkInterfacesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_network_interfaces_with_options(request, runtime)

    async def delete_network_interfaces_async(
        self,
        request: ens_20171110_models.DeleteNetworkInterfacesRequest,
    ) -> ens_20171110_models.DeleteNetworkInterfacesResponse:
        """
        @summary 删除弹性网卡
        
        @param request: DeleteNetworkInterfacesRequest
        @return: DeleteNetworkInterfacesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_network_interfaces_with_options_async(request, runtime)

    def delete_object_with_options(
        self,
        request: ens_20171110_models.DeleteObjectRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteObjectResponse:
        """
        @summary Deletes an object.
        
        @param request: DeleteObjectRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteObjectResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bucket_name):
            query['BucketName'] = request.bucket_name
        if not UtilClient.is_unset(request.object_key):
            query['ObjectKey'] = request.object_key
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteObject',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteObjectResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_object_with_options_async(
        self,
        request: ens_20171110_models.DeleteObjectRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteObjectResponse:
        """
        @summary Deletes an object.
        
        @param request: DeleteObjectRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteObjectResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bucket_name):
            query['BucketName'] = request.bucket_name
        if not UtilClient.is_unset(request.object_key):
            query['ObjectKey'] = request.object_key
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteObject',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteObjectResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_object(
        self,
        request: ens_20171110_models.DeleteObjectRequest,
    ) -> ens_20171110_models.DeleteObjectResponse:
        """
        @summary Deletes an object.
        
        @param request: DeleteObjectRequest
        @return: DeleteObjectResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_object_with_options(request, runtime)

    async def delete_object_async(
        self,
        request: ens_20171110_models.DeleteObjectRequest,
    ) -> ens_20171110_models.DeleteObjectResponse:
        """
        @summary Deletes an object.
        
        @param request: DeleteObjectRequest
        @return: DeleteObjectResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_object_with_options_async(request, runtime)

    def delete_sdgwith_options(
        self,
        tmp_req: ens_20171110_models.DeleteSDGRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteSDGResponse:
        """
        @summary Deletes a shared data group (SDG).
        
        @description If all the SDGs corresponding to the original disk are deleted, the original disk is automatically cleared.
        
        @param tmp_req: DeleteSDGRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSDGResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.DeleteSDGShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.sdgid):
            request.sdgid_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.sdgid, 'SDGId', 'json')
        query = {}
        if not UtilClient.is_unset(request.sdgid_shrink):
            query['SDGId'] = request.sdgid_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSDG',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteSDGResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_sdgwith_options_async(
        self,
        tmp_req: ens_20171110_models.DeleteSDGRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteSDGResponse:
        """
        @summary Deletes a shared data group (SDG).
        
        @description If all the SDGs corresponding to the original disk are deleted, the original disk is automatically cleared.
        
        @param tmp_req: DeleteSDGRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSDGResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.DeleteSDGShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.sdgid):
            request.sdgid_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.sdgid, 'SDGId', 'json')
        query = {}
        if not UtilClient.is_unset(request.sdgid_shrink):
            query['SDGId'] = request.sdgid_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSDG',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteSDGResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_sdg(
        self,
        request: ens_20171110_models.DeleteSDGRequest,
    ) -> ens_20171110_models.DeleteSDGResponse:
        """
        @summary Deletes a shared data group (SDG).
        
        @description If all the SDGs corresponding to the original disk are deleted, the original disk is automatically cleared.
        
        @param request: DeleteSDGRequest
        @return: DeleteSDGResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_sdgwith_options(request, runtime)

    async def delete_sdg_async(
        self,
        request: ens_20171110_models.DeleteSDGRequest,
    ) -> ens_20171110_models.DeleteSDGResponse:
        """
        @summary Deletes a shared data group (SDG).
        
        @description If all the SDGs corresponding to the original disk are deleted, the original disk is automatically cleared.
        
        @param request: DeleteSDGRequest
        @return: DeleteSDGResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_sdgwith_options_async(request, runtime)

    def delete_security_group_with_options(
        self,
        request: ens_20171110_models.DeleteSecurityGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteSecurityGroupResponse:
        """
        @summary Deletes a security group.
        
        @description Before you delete a security group, make sure that no instances exist in the security group.
        
        @param request: DeleteSecurityGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSecurityGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSecurityGroup',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteSecurityGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_security_group_with_options_async(
        self,
        request: ens_20171110_models.DeleteSecurityGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteSecurityGroupResponse:
        """
        @summary Deletes a security group.
        
        @description Before you delete a security group, make sure that no instances exist in the security group.
        
        @param request: DeleteSecurityGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSecurityGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSecurityGroup',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteSecurityGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_security_group(
        self,
        request: ens_20171110_models.DeleteSecurityGroupRequest,
    ) -> ens_20171110_models.DeleteSecurityGroupResponse:
        """
        @summary Deletes a security group.
        
        @description Before you delete a security group, make sure that no instances exist in the security group.
        
        @param request: DeleteSecurityGroupRequest
        @return: DeleteSecurityGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_security_group_with_options(request, runtime)

    async def delete_security_group_async(
        self,
        request: ens_20171110_models.DeleteSecurityGroupRequest,
    ) -> ens_20171110_models.DeleteSecurityGroupResponse:
        """
        @summary Deletes a security group.
        
        @description Before you delete a security group, make sure that no instances exist in the security group.
        
        @param request: DeleteSecurityGroupRequest
        @return: DeleteSecurityGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_security_group_with_options_async(request, runtime)

    def delete_snapshot_with_options(
        self,
        request: ens_20171110_models.DeleteSnapshotRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteSnapshotResponse:
        """
        @summary Deletes a snapshot.
        
        @param request: DeleteSnapshotRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSnapshotResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.snapshot_id):
            query['SnapshotId'] = request.snapshot_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSnapshot',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteSnapshotResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_snapshot_with_options_async(
        self,
        request: ens_20171110_models.DeleteSnapshotRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteSnapshotResponse:
        """
        @summary Deletes a snapshot.
        
        @param request: DeleteSnapshotRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSnapshotResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.snapshot_id):
            query['SnapshotId'] = request.snapshot_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSnapshot',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteSnapshotResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_snapshot(
        self,
        request: ens_20171110_models.DeleteSnapshotRequest,
    ) -> ens_20171110_models.DeleteSnapshotResponse:
        """
        @summary Deletes a snapshot.
        
        @param request: DeleteSnapshotRequest
        @return: DeleteSnapshotResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_snapshot_with_options(request, runtime)

    async def delete_snapshot_async(
        self,
        request: ens_20171110_models.DeleteSnapshotRequest,
    ) -> ens_20171110_models.DeleteSnapshotResponse:
        """
        @summary Deletes a snapshot.
        
        @param request: DeleteSnapshotRequest
        @return: DeleteSnapshotResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_snapshot_with_options_async(request, runtime)

    def delete_snat_entry_with_options(
        self,
        request: ens_20171110_models.DeleteSnatEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteSnatEntryResponse:
        """
        @summary Deletes a source network address translation (SNAT) entry from a specified SNAT table.
        
        @param request: DeleteSnatEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSnatEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.snat_entry_id):
            query['SnatEntryId'] = request.snat_entry_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSnatEntry',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteSnatEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_snat_entry_with_options_async(
        self,
        request: ens_20171110_models.DeleteSnatEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteSnatEntryResponse:
        """
        @summary Deletes a source network address translation (SNAT) entry from a specified SNAT table.
        
        @param request: DeleteSnatEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSnatEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.snat_entry_id):
            query['SnatEntryId'] = request.snat_entry_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSnatEntry',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteSnatEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_snat_entry(
        self,
        request: ens_20171110_models.DeleteSnatEntryRequest,
    ) -> ens_20171110_models.DeleteSnatEntryResponse:
        """
        @summary Deletes a source network address translation (SNAT) entry from a specified SNAT table.
        
        @param request: DeleteSnatEntryRequest
        @return: DeleteSnatEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_snat_entry_with_options(request, runtime)

    async def delete_snat_entry_async(
        self,
        request: ens_20171110_models.DeleteSnatEntryRequest,
    ) -> ens_20171110_models.DeleteSnatEntryResponse:
        """
        @summary Deletes a source network address translation (SNAT) entry from a specified SNAT table.
        
        @param request: DeleteSnatEntryRequest
        @return: DeleteSnatEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_snat_entry_with_options_async(request, runtime)

    def delete_snat_ip_for_snat_entry_with_options(
        self,
        request: ens_20171110_models.DeleteSnatIpForSnatEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteSnatIpForSnatEntryResponse:
        """
        @summary Deletes an elastic IP address (EIP) from a source network address translation (SNAT) entry.
        
        @param request: DeleteSnatIpForSnatEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSnatIpForSnatEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.snat_entry_id):
            query['SnatEntryId'] = request.snat_entry_id
        if not UtilClient.is_unset(request.snat_ip):
            query['SnatIp'] = request.snat_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSnatIpForSnatEntry',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteSnatIpForSnatEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_snat_ip_for_snat_entry_with_options_async(
        self,
        request: ens_20171110_models.DeleteSnatIpForSnatEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteSnatIpForSnatEntryResponse:
        """
        @summary Deletes an elastic IP address (EIP) from a source network address translation (SNAT) entry.
        
        @param request: DeleteSnatIpForSnatEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSnatIpForSnatEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.snat_entry_id):
            query['SnatEntryId'] = request.snat_entry_id
        if not UtilClient.is_unset(request.snat_ip):
            query['SnatIp'] = request.snat_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSnatIpForSnatEntry',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteSnatIpForSnatEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_snat_ip_for_snat_entry(
        self,
        request: ens_20171110_models.DeleteSnatIpForSnatEntryRequest,
    ) -> ens_20171110_models.DeleteSnatIpForSnatEntryResponse:
        """
        @summary Deletes an elastic IP address (EIP) from a source network address translation (SNAT) entry.
        
        @param request: DeleteSnatIpForSnatEntryRequest
        @return: DeleteSnatIpForSnatEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_snat_ip_for_snat_entry_with_options(request, runtime)

    async def delete_snat_ip_for_snat_entry_async(
        self,
        request: ens_20171110_models.DeleteSnatIpForSnatEntryRequest,
    ) -> ens_20171110_models.DeleteSnatIpForSnatEntryResponse:
        """
        @summary Deletes an elastic IP address (EIP) from a source network address translation (SNAT) entry.
        
        @param request: DeleteSnatIpForSnatEntryRequest
        @return: DeleteSnatIpForSnatEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_snat_ip_for_snat_entry_with_options_async(request, runtime)

    def delete_storage_gateway_with_options(
        self,
        request: ens_20171110_models.DeleteStorageGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteStorageGatewayResponse:
        """
        @summary Deletes a storage gateway.
        
        @param request: DeleteStorageGatewayRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteStorageGatewayResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.gateway_id):
            query['GatewayId'] = request.gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteStorageGateway',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteStorageGatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_storage_gateway_with_options_async(
        self,
        request: ens_20171110_models.DeleteStorageGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteStorageGatewayResponse:
        """
        @summary Deletes a storage gateway.
        
        @param request: DeleteStorageGatewayRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteStorageGatewayResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.gateway_id):
            query['GatewayId'] = request.gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteStorageGateway',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteStorageGatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_storage_gateway(
        self,
        request: ens_20171110_models.DeleteStorageGatewayRequest,
    ) -> ens_20171110_models.DeleteStorageGatewayResponse:
        """
        @summary Deletes a storage gateway.
        
        @param request: DeleteStorageGatewayRequest
        @return: DeleteStorageGatewayResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_storage_gateway_with_options(request, runtime)

    async def delete_storage_gateway_async(
        self,
        request: ens_20171110_models.DeleteStorageGatewayRequest,
    ) -> ens_20171110_models.DeleteStorageGatewayResponse:
        """
        @summary Deletes a storage gateway.
        
        @param request: DeleteStorageGatewayRequest
        @return: DeleteStorageGatewayResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_storage_gateway_with_options_async(request, runtime)

    def delete_storage_volume_with_options(
        self,
        request: ens_20171110_models.DeleteStorageVolumeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteStorageVolumeResponse:
        """
        @summary Deletes a storage volume.
        
        @param request: DeleteStorageVolumeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteStorageVolumeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.volume_id):
            query['VolumeId'] = request.volume_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteStorageVolume',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteStorageVolumeResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_storage_volume_with_options_async(
        self,
        request: ens_20171110_models.DeleteStorageVolumeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteStorageVolumeResponse:
        """
        @summary Deletes a storage volume.
        
        @param request: DeleteStorageVolumeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteStorageVolumeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.volume_id):
            query['VolumeId'] = request.volume_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteStorageVolume',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteStorageVolumeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_storage_volume(
        self,
        request: ens_20171110_models.DeleteStorageVolumeRequest,
    ) -> ens_20171110_models.DeleteStorageVolumeResponse:
        """
        @summary Deletes a storage volume.
        
        @param request: DeleteStorageVolumeRequest
        @return: DeleteStorageVolumeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_storage_volume_with_options(request, runtime)

    async def delete_storage_volume_async(
        self,
        request: ens_20171110_models.DeleteStorageVolumeRequest,
    ) -> ens_20171110_models.DeleteStorageVolumeResponse:
        """
        @summary Deletes a storage volume.
        
        @param request: DeleteStorageVolumeRequest
        @return: DeleteStorageVolumeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_storage_volume_with_options_async(request, runtime)

    def delete_vswitch_with_options(
        self,
        request: ens_20171110_models.DeleteVSwitchRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteVSwitchResponse:
        """
        @summary Deletes a vSwitch.
        
        @description Before you delete a vSwitch, make sure that no instances exist in the vSwitch.
        
        @param request: DeleteVSwitchRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVSwitchResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVSwitch',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteVSwitchResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_vswitch_with_options_async(
        self,
        request: ens_20171110_models.DeleteVSwitchRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeleteVSwitchResponse:
        """
        @summary Deletes a vSwitch.
        
        @description Before you delete a vSwitch, make sure that no instances exist in the vSwitch.
        
        @param request: DeleteVSwitchRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVSwitchResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVSwitch',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeleteVSwitchResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_vswitch(
        self,
        request: ens_20171110_models.DeleteVSwitchRequest,
    ) -> ens_20171110_models.DeleteVSwitchResponse:
        """
        @summary Deletes a vSwitch.
        
        @description Before you delete a vSwitch, make sure that no instances exist in the vSwitch.
        
        @param request: DeleteVSwitchRequest
        @return: DeleteVSwitchResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_vswitch_with_options(request, runtime)

    async def delete_vswitch_async(
        self,
        request: ens_20171110_models.DeleteVSwitchRequest,
    ) -> ens_20171110_models.DeleteVSwitchResponse:
        """
        @summary Deletes a vSwitch.
        
        @description Before you delete a vSwitch, make sure that no instances exist in the vSwitch.
        
        @param request: DeleteVSwitchRequest
        @return: DeleteVSwitchResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_vswitch_with_options_async(request, runtime)

    def deploy_instance_sdgwith_options(
        self,
        tmp_req: ens_20171110_models.DeployInstanceSDGRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeployInstanceSDGResponse:
        """
        @summary Deploys a shared data group (SDG) to compute instances.
        
        @param tmp_req: DeployInstanceSDGRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeployInstanceSDGResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.DeployInstanceSDGShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.instance_ids):
            request.instance_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.instance_ids, 'InstanceIds', 'json')
        query = {}
        if not UtilClient.is_unset(request.deployment_type):
            query['DeploymentType'] = request.deployment_type
        if not UtilClient.is_unset(request.disk_access_protocol):
            query['DiskAccessProtocol'] = request.disk_access_protocol
        if not UtilClient.is_unset(request.disk_type):
            query['DiskType'] = request.disk_type
        if not UtilClient.is_unset(request.instance_ids_shrink):
            query['InstanceIds'] = request.instance_ids_shrink
        if not UtilClient.is_unset(request.sdgid):
            query['SDGId'] = request.sdgid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeployInstanceSDG',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeployInstanceSDGResponse(),
            self.call_api(params, req, runtime)
        )

    async def deploy_instance_sdgwith_options_async(
        self,
        tmp_req: ens_20171110_models.DeployInstanceSDGRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeployInstanceSDGResponse:
        """
        @summary Deploys a shared data group (SDG) to compute instances.
        
        @param tmp_req: DeployInstanceSDGRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeployInstanceSDGResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.DeployInstanceSDGShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.instance_ids):
            request.instance_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.instance_ids, 'InstanceIds', 'json')
        query = {}
        if not UtilClient.is_unset(request.deployment_type):
            query['DeploymentType'] = request.deployment_type
        if not UtilClient.is_unset(request.disk_access_protocol):
            query['DiskAccessProtocol'] = request.disk_access_protocol
        if not UtilClient.is_unset(request.disk_type):
            query['DiskType'] = request.disk_type
        if not UtilClient.is_unset(request.instance_ids_shrink):
            query['InstanceIds'] = request.instance_ids_shrink
        if not UtilClient.is_unset(request.sdgid):
            query['SDGId'] = request.sdgid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeployInstanceSDG',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeployInstanceSDGResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def deploy_instance_sdg(
        self,
        request: ens_20171110_models.DeployInstanceSDGRequest,
    ) -> ens_20171110_models.DeployInstanceSDGResponse:
        """
        @summary Deploys a shared data group (SDG) to compute instances.
        
        @param request: DeployInstanceSDGRequest
        @return: DeployInstanceSDGResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.deploy_instance_sdgwith_options(request, runtime)

    async def deploy_instance_sdg_async(
        self,
        request: ens_20171110_models.DeployInstanceSDGRequest,
    ) -> ens_20171110_models.DeployInstanceSDGResponse:
        """
        @summary Deploys a shared data group (SDG) to compute instances.
        
        @param request: DeployInstanceSDGRequest
        @return: DeployInstanceSDGResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.deploy_instance_sdgwith_options_async(request, runtime)

    def deploy_sdgwith_options(
        self,
        tmp_req: ens_20171110_models.DeploySDGRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeploySDGResponse:
        """
        @summary Deploys shared data groups (SDGs).
        
        @param tmp_req: DeploySDGRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeploySDGResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.DeploySDGShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.instance_ids):
            request.instance_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.instance_ids, 'InstanceIds', 'json')
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeploySDG',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeploySDGResponse(),
            self.call_api(params, req, runtime)
        )

    async def deploy_sdgwith_options_async(
        self,
        tmp_req: ens_20171110_models.DeploySDGRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DeploySDGResponse:
        """
        @summary Deploys shared data groups (SDGs).
        
        @param tmp_req: DeploySDGRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeploySDGResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.DeploySDGShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.instance_ids):
            request.instance_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.instance_ids, 'InstanceIds', 'json')
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeploySDG',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DeploySDGResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def deploy_sdg(
        self,
        request: ens_20171110_models.DeploySDGRequest,
    ) -> ens_20171110_models.DeploySDGResponse:
        """
        @summary Deploys shared data groups (SDGs).
        
        @param request: DeploySDGRequest
        @return: DeploySDGResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.deploy_sdgwith_options(request, runtime)

    async def deploy_sdg_async(
        self,
        request: ens_20171110_models.DeploySDGRequest,
    ) -> ens_20171110_models.DeploySDGResponse:
        """
        @summary Deploys shared data groups (SDGs).
        
        @param request: DeploySDGRequest
        @return: DeploySDGResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.deploy_sdgwith_options_async(request, runtime)

    def describe_aicimages_with_options(
        self,
        request: ens_20171110_models.DescribeAICImagesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeAICImagesResponse:
        """
        @summary Queries information about images of the Android in Container (AIC) instance.
        
        @param request: DescribeAICImagesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAICImagesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.image_type):
            query['ImageType'] = request.image_type
        if not UtilClient.is_unset(request.image_url):
            query['ImageUrl'] = request.image_url
        if not UtilClient.is_unset(request.max_date):
            query['MaxDate'] = request.max_date
        if not UtilClient.is_unset(request.min_date):
            query['MinDate'] = request.min_date
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAICImages',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeAICImagesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_aicimages_with_options_async(
        self,
        request: ens_20171110_models.DescribeAICImagesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeAICImagesResponse:
        """
        @summary Queries information about images of the Android in Container (AIC) instance.
        
        @param request: DescribeAICImagesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAICImagesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.image_type):
            query['ImageType'] = request.image_type
        if not UtilClient.is_unset(request.image_url):
            query['ImageUrl'] = request.image_url
        if not UtilClient.is_unset(request.max_date):
            query['MaxDate'] = request.max_date
        if not UtilClient.is_unset(request.min_date):
            query['MinDate'] = request.min_date
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAICImages',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeAICImagesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_aicimages(
        self,
        request: ens_20171110_models.DescribeAICImagesRequest,
    ) -> ens_20171110_models.DescribeAICImagesResponse:
        """
        @summary Queries information about images of the Android in Container (AIC) instance.
        
        @param request: DescribeAICImagesRequest
        @return: DescribeAICImagesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_aicimages_with_options(request, runtime)

    async def describe_aicimages_async(
        self,
        request: ens_20171110_models.DescribeAICImagesRequest,
    ) -> ens_20171110_models.DescribeAICImagesResponse:
        """
        @summary Queries information about images of the Android in Container (AIC) instance.
        
        @param request: DescribeAICImagesRequest
        @return: DescribeAICImagesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_aicimages_with_options_async(request, runtime)

    def describe_armserver_instances_with_options(
        self,
        tmp_req: ens_20171110_models.DescribeARMServerInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeARMServerInstancesResponse:
        """
        @summary Queries information about ARM servers and Android in Container (AIC) instances.
        
        @param tmp_req: DescribeARMServerInstancesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeARMServerInstancesResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.DescribeARMServerInstancesShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.aicspecs):
            request.aicspecs_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.aicspecs, 'AICSpecs', 'json')
        if not UtilClient.is_unset(tmp_req.ens_region_ids):
            request.ens_region_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.ens_region_ids, 'EnsRegionIds', 'json')
        if not UtilClient.is_unset(tmp_req.server_ids):
            request.server_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.server_ids, 'ServerIds', 'json')
        if not UtilClient.is_unset(tmp_req.server_specs):
            request.server_specs_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.server_specs, 'ServerSpecs', 'json')
        if not UtilClient.is_unset(tmp_req.states):
            request.states_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.states, 'States', 'json')
        if not UtilClient.is_unset(tmp_req.tags):
            request.tags_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.tags, 'Tags', 'json')
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeARMServerInstances',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeARMServerInstancesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_armserver_instances_with_options_async(
        self,
        tmp_req: ens_20171110_models.DescribeARMServerInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeARMServerInstancesResponse:
        """
        @summary Queries information about ARM servers and Android in Container (AIC) instances.
        
        @param tmp_req: DescribeARMServerInstancesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeARMServerInstancesResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.DescribeARMServerInstancesShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.aicspecs):
            request.aicspecs_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.aicspecs, 'AICSpecs', 'json')
        if not UtilClient.is_unset(tmp_req.ens_region_ids):
            request.ens_region_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.ens_region_ids, 'EnsRegionIds', 'json')
        if not UtilClient.is_unset(tmp_req.server_ids):
            request.server_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.server_ids, 'ServerIds', 'json')
        if not UtilClient.is_unset(tmp_req.server_specs):
            request.server_specs_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.server_specs, 'ServerSpecs', 'json')
        if not UtilClient.is_unset(tmp_req.states):
            request.states_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.states, 'States', 'json')
        if not UtilClient.is_unset(tmp_req.tags):
            request.tags_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.tags, 'Tags', 'json')
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeARMServerInstances',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeARMServerInstancesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_armserver_instances(
        self,
        request: ens_20171110_models.DescribeARMServerInstancesRequest,
    ) -> ens_20171110_models.DescribeARMServerInstancesResponse:
        """
        @summary Queries information about ARM servers and Android in Container (AIC) instances.
        
        @param request: DescribeARMServerInstancesRequest
        @return: DescribeARMServerInstancesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_armserver_instances_with_options(request, runtime)

    async def describe_armserver_instances_async(
        self,
        request: ens_20171110_models.DescribeARMServerInstancesRequest,
    ) -> ens_20171110_models.DescribeARMServerInstancesResponse:
        """
        @summary Queries information about ARM servers and Android in Container (AIC) instances.
        
        @param request: DescribeARMServerInstancesRequest
        @return: DescribeARMServerInstancesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_armserver_instances_with_options_async(request, runtime)

    def describe_application_with_options(
        self,
        request: ens_20171110_models.DescribeApplicationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeApplicationResponse:
        """
        @summary Queries the basic properties, resources, and container status of an application.
        
        @param request: DescribeApplicationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeApplicationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_versions):
            query['AppVersions'] = request.app_versions
        if not UtilClient.is_unset(request.level):
            query['Level'] = request.level
        if not UtilClient.is_unset(request.out_detail_stat_params):
            query['OutDetailStatParams'] = request.out_detail_stat_params
        if not UtilClient.is_unset(request.resource_selector):
            query['ResourceSelector'] = request.resource_selector
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeApplication',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeApplicationResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_application_with_options_async(
        self,
        request: ens_20171110_models.DescribeApplicationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeApplicationResponse:
        """
        @summary Queries the basic properties, resources, and container status of an application.
        
        @param request: DescribeApplicationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeApplicationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.app_versions):
            query['AppVersions'] = request.app_versions
        if not UtilClient.is_unset(request.level):
            query['Level'] = request.level
        if not UtilClient.is_unset(request.out_detail_stat_params):
            query['OutDetailStatParams'] = request.out_detail_stat_params
        if not UtilClient.is_unset(request.resource_selector):
            query['ResourceSelector'] = request.resource_selector
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeApplication',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeApplicationResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_application(
        self,
        request: ens_20171110_models.DescribeApplicationRequest,
    ) -> ens_20171110_models.DescribeApplicationResponse:
        """
        @summary Queries the basic properties, resources, and container status of an application.
        
        @param request: DescribeApplicationRequest
        @return: DescribeApplicationResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_application_with_options(request, runtime)

    async def describe_application_async(
        self,
        request: ens_20171110_models.DescribeApplicationRequest,
    ) -> ens_20171110_models.DescribeApplicationResponse:
        """
        @summary Queries the basic properties, resources, and container status of an application.
        
        @param request: DescribeApplicationRequest
        @return: DescribeApplicationResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_application_with_options_async(request, runtime)

    def describe_available_resource_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeAvailableResourceResponse:
        """
        @summary Queries the resources that can be created.
        
        @param request: DescribeAvailableResourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAvailableResourceResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeAvailableResource',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeAvailableResourceResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_available_resource_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeAvailableResourceResponse:
        """
        @summary Queries the resources that can be created.
        
        @param request: DescribeAvailableResourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAvailableResourceResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeAvailableResource',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeAvailableResourceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_available_resource(self) -> ens_20171110_models.DescribeAvailableResourceResponse:
        """
        @summary Queries the resources that can be created.
        
        @return: DescribeAvailableResourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_available_resource_with_options(runtime)

    async def describe_available_resource_async(self) -> ens_20171110_models.DescribeAvailableResourceResponse:
        """
        @summary Queries the resources that can be created.
        
        @return: DescribeAvailableResourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_available_resource_with_options_async(runtime)

    def describe_available_resource_info_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeAvailableResourceInfoResponse:
        """
        @summary Queries the specifications of resources that you can purchase when you create an instance.
        
        @param request: DescribeAvailableResourceInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAvailableResourceInfoResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeAvailableResourceInfo',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeAvailableResourceInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_available_resource_info_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeAvailableResourceInfoResponse:
        """
        @summary Queries the specifications of resources that you can purchase when you create an instance.
        
        @param request: DescribeAvailableResourceInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAvailableResourceInfoResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeAvailableResourceInfo',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeAvailableResourceInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_available_resource_info(self) -> ens_20171110_models.DescribeAvailableResourceInfoResponse:
        """
        @summary Queries the specifications of resources that you can purchase when you create an instance.
        
        @return: DescribeAvailableResourceInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_available_resource_info_with_options(runtime)

    async def describe_available_resource_info_async(self) -> ens_20171110_models.DescribeAvailableResourceInfoResponse:
        """
        @summary Queries the specifications of resources that you can purchase when you create an instance.
        
        @return: DescribeAvailableResourceInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_available_resource_info_with_options_async(runtime)

    def describe_band_withd_charge_type_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeBandWithdChargeTypeResponse:
        """
        @summary Queries available bandwidth metering methods.
        
        @param request: DescribeBandWithdChargeTypeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBandWithdChargeTypeResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeBandWithdChargeType',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeBandWithdChargeTypeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_band_withd_charge_type_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeBandWithdChargeTypeResponse:
        """
        @summary Queries available bandwidth metering methods.
        
        @param request: DescribeBandWithdChargeTypeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBandWithdChargeTypeResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeBandWithdChargeType',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeBandWithdChargeTypeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_band_withd_charge_type(self) -> ens_20171110_models.DescribeBandWithdChargeTypeResponse:
        """
        @summary Queries available bandwidth metering methods.
        
        @return: DescribeBandWithdChargeTypeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_band_withd_charge_type_with_options(runtime)

    async def describe_band_withd_charge_type_async(self) -> ens_20171110_models.DescribeBandWithdChargeTypeResponse:
        """
        @summary Queries available bandwidth metering methods.
        
        @return: DescribeBandWithdChargeTypeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_band_withd_charge_type_with_options_async(runtime)

    def describe_bandwitdh_by_internet_charge_type_with_options(
        self,
        request: ens_20171110_models.DescribeBandwitdhByInternetChargeTypeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeBandwitdhByInternetChargeTypeResponse:
        """
        @summary Queries the metering method for the bandwidth.
        
        @param request: DescribeBandwitdhByInternetChargeTypeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBandwitdhByInternetChargeTypeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.isp):
            query['Isp'] = request.isp
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBandwitdhByInternetChargeType',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeBandwitdhByInternetChargeTypeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_bandwitdh_by_internet_charge_type_with_options_async(
        self,
        request: ens_20171110_models.DescribeBandwitdhByInternetChargeTypeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeBandwitdhByInternetChargeTypeResponse:
        """
        @summary Queries the metering method for the bandwidth.
        
        @param request: DescribeBandwitdhByInternetChargeTypeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBandwitdhByInternetChargeTypeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.isp):
            query['Isp'] = request.isp
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBandwitdhByInternetChargeType',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeBandwitdhByInternetChargeTypeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_bandwitdh_by_internet_charge_type(
        self,
        request: ens_20171110_models.DescribeBandwitdhByInternetChargeTypeRequest,
    ) -> ens_20171110_models.DescribeBandwitdhByInternetChargeTypeResponse:
        """
        @summary Queries the metering method for the bandwidth.
        
        @param request: DescribeBandwitdhByInternetChargeTypeRequest
        @return: DescribeBandwitdhByInternetChargeTypeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_bandwitdh_by_internet_charge_type_with_options(request, runtime)

    async def describe_bandwitdh_by_internet_charge_type_async(
        self,
        request: ens_20171110_models.DescribeBandwitdhByInternetChargeTypeRequest,
    ) -> ens_20171110_models.DescribeBandwitdhByInternetChargeTypeResponse:
        """
        @summary Queries the metering method for the bandwidth.
        
        @param request: DescribeBandwitdhByInternetChargeTypeRequest
        @return: DescribeBandwitdhByInternetChargeTypeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_bandwitdh_by_internet_charge_type_with_options_async(request, runtime)

    def describe_cloud_disk_available_resource_info_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeCloudDiskAvailableResourceInfoResponse:
        """
        @summary Queries the available resources in a region.
        
        @param request: DescribeCloudDiskAvailableResourceInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCloudDiskAvailableResourceInfoResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeCloudDiskAvailableResourceInfo',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeCloudDiskAvailableResourceInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_cloud_disk_available_resource_info_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeCloudDiskAvailableResourceInfoResponse:
        """
        @summary Queries the available resources in a region.
        
        @param request: DescribeCloudDiskAvailableResourceInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCloudDiskAvailableResourceInfoResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeCloudDiskAvailableResourceInfo',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeCloudDiskAvailableResourceInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_cloud_disk_available_resource_info(self) -> ens_20171110_models.DescribeCloudDiskAvailableResourceInfoResponse:
        """
        @summary Queries the available resources in a region.
        
        @return: DescribeCloudDiskAvailableResourceInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_cloud_disk_available_resource_info_with_options(runtime)

    async def describe_cloud_disk_available_resource_info_async(self) -> ens_20171110_models.DescribeCloudDiskAvailableResourceInfoResponse:
        """
        @summary Queries the available resources in a region.
        
        @return: DescribeCloudDiskAvailableResourceInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_cloud_disk_available_resource_info_with_options_async(runtime)

    def describe_cloud_disk_types_with_options(
        self,
        tmp_req: ens_20171110_models.DescribeCloudDiskTypesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeCloudDiskTypesResponse:
        """
        @summary The specifications of available resources are queried when you create a disk.
        
        @param tmp_req: DescribeCloudDiskTypesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCloudDiskTypesResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.DescribeCloudDiskTypesShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.ens_region_ids):
            request.ens_region_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.ens_region_ids, 'EnsRegionIds', 'json')
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCloudDiskTypes',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeCloudDiskTypesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_cloud_disk_types_with_options_async(
        self,
        tmp_req: ens_20171110_models.DescribeCloudDiskTypesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeCloudDiskTypesResponse:
        """
        @summary The specifications of available resources are queried when you create a disk.
        
        @param tmp_req: DescribeCloudDiskTypesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCloudDiskTypesResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.DescribeCloudDiskTypesShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.ens_region_ids):
            request.ens_region_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.ens_region_ids, 'EnsRegionIds', 'json')
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCloudDiskTypes',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeCloudDiskTypesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_cloud_disk_types(
        self,
        request: ens_20171110_models.DescribeCloudDiskTypesRequest,
    ) -> ens_20171110_models.DescribeCloudDiskTypesResponse:
        """
        @summary The specifications of available resources are queried when you create a disk.
        
        @param request: DescribeCloudDiskTypesRequest
        @return: DescribeCloudDiskTypesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_cloud_disk_types_with_options(request, runtime)

    async def describe_cloud_disk_types_async(
        self,
        request: ens_20171110_models.DescribeCloudDiskTypesRequest,
    ) -> ens_20171110_models.DescribeCloudDiskTypesResponse:
        """
        @summary The specifications of available resources are queried when you create a disk.
        
        @param request: DescribeCloudDiskTypesRequest
        @return: DescribeCloudDiskTypesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_cloud_disk_types_with_options_async(request, runtime)

    def describe_cluster_with_options(
        self,
        request: ens_20171110_models.DescribeClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeClusterResponse:
        """
        @summary Queries Container Service for Kubernetes (ACK) edge clusters.
        
        @description    You can call this operation up to 100 times per second per account.
        
        @param request: DescribeClusterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeClusterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCluster',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeClusterResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_cluster_with_options_async(
        self,
        request: ens_20171110_models.DescribeClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeClusterResponse:
        """
        @summary Queries Container Service for Kubernetes (ACK) edge clusters.
        
        @description    You can call this operation up to 100 times per second per account.
        
        @param request: DescribeClusterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeClusterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCluster',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeClusterResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_cluster(
        self,
        request: ens_20171110_models.DescribeClusterRequest,
    ) -> ens_20171110_models.DescribeClusterResponse:
        """
        @summary Queries Container Service for Kubernetes (ACK) edge clusters.
        
        @description    You can call this operation up to 100 times per second per account.
        
        @param request: DescribeClusterRequest
        @return: DescribeClusterResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_cluster_with_options(request, runtime)

    async def describe_cluster_async(
        self,
        request: ens_20171110_models.DescribeClusterRequest,
    ) -> ens_20171110_models.DescribeClusterResponse:
        """
        @summary Queries Container Service for Kubernetes (ACK) edge clusters.
        
        @description    You can call this operation up to 100 times per second per account.
        
        @param request: DescribeClusterRequest
        @return: DescribeClusterResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_cluster_with_options_async(request, runtime)

    def describe_cluster_kube_config_with_options(
        self,
        request: ens_20171110_models.DescribeClusterKubeConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeClusterKubeConfigResponse:
        """
        @summary Queries the certificate of a Container Service for Kubernetes (ACK) edge cluster.
        
        @description    The maximum number of times that each user can call this operation per second is 100.
        
        @param request: DescribeClusterKubeConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeClusterKubeConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeClusterKubeConfig',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeClusterKubeConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_cluster_kube_config_with_options_async(
        self,
        request: ens_20171110_models.DescribeClusterKubeConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeClusterKubeConfigResponse:
        """
        @summary Queries the certificate of a Container Service for Kubernetes (ACK) edge cluster.
        
        @description    The maximum number of times that each user can call this operation per second is 100.
        
        @param request: DescribeClusterKubeConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeClusterKubeConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeClusterKubeConfig',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeClusterKubeConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_cluster_kube_config(
        self,
        request: ens_20171110_models.DescribeClusterKubeConfigRequest,
    ) -> ens_20171110_models.DescribeClusterKubeConfigResponse:
        """
        @summary Queries the certificate of a Container Service for Kubernetes (ACK) edge cluster.
        
        @description    The maximum number of times that each user can call this operation per second is 100.
        
        @param request: DescribeClusterKubeConfigRequest
        @return: DescribeClusterKubeConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_cluster_kube_config_with_options(request, runtime)

    async def describe_cluster_kube_config_async(
        self,
        request: ens_20171110_models.DescribeClusterKubeConfigRequest,
    ) -> ens_20171110_models.DescribeClusterKubeConfigResponse:
        """
        @summary Queries the certificate of a Container Service for Kubernetes (ACK) edge cluster.
        
        @description    The maximum number of times that each user can call this operation per second is 100.
        
        @param request: DescribeClusterKubeConfigRequest
        @return: DescribeClusterKubeConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_cluster_kube_config_with_options_async(request, runtime)

    def describe_create_pre_paid_instance_result_with_options(
        self,
        request: ens_20171110_models.DescribeCreatePrePaidInstanceResultRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeCreatePrePaidInstanceResultResponse:
        """
        @summary Queries the results of creating an instance.
        
        @param request: DescribeCreatePrePaidInstanceResultRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCreatePrePaidInstanceResultResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCreatePrePaidInstanceResult',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeCreatePrePaidInstanceResultResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_create_pre_paid_instance_result_with_options_async(
        self,
        request: ens_20171110_models.DescribeCreatePrePaidInstanceResultRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeCreatePrePaidInstanceResultResponse:
        """
        @summary Queries the results of creating an instance.
        
        @param request: DescribeCreatePrePaidInstanceResultRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCreatePrePaidInstanceResultResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCreatePrePaidInstanceResult',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeCreatePrePaidInstanceResultResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_create_pre_paid_instance_result(
        self,
        request: ens_20171110_models.DescribeCreatePrePaidInstanceResultRequest,
    ) -> ens_20171110_models.DescribeCreatePrePaidInstanceResultResponse:
        """
        @summary Queries the results of creating an instance.
        
        @param request: DescribeCreatePrePaidInstanceResultRequest
        @return: DescribeCreatePrePaidInstanceResultResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_create_pre_paid_instance_result_with_options(request, runtime)

    async def describe_create_pre_paid_instance_result_async(
        self,
        request: ens_20171110_models.DescribeCreatePrePaidInstanceResultRequest,
    ) -> ens_20171110_models.DescribeCreatePrePaidInstanceResultResponse:
        """
        @summary Queries the results of creating an instance.
        
        @param request: DescribeCreatePrePaidInstanceResultRequest
        @return: DescribeCreatePrePaidInstanceResultResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_create_pre_paid_instance_result_with_options_async(request, runtime)

    def describe_data_dist_result_with_options(
        self,
        tmp_req: ens_20171110_models.DescribeDataDistResultRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeDataDistResultResponse:
        """
        @summary Queries the distribution status of data files on edge instances of an application.
        
        @param tmp_req: DescribeDataDistResultRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDataDistResultResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.DescribeDataDistResultShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.ens_region_ids):
            request.ens_region_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.ens_region_ids, 'EnsRegionIds', 'json')
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.data_names):
            query['DataNames'] = request.data_names
        if not UtilClient.is_unset(request.data_versions):
            query['DataVersions'] = request.data_versions
        if not UtilClient.is_unset(request.ens_region_ids_shrink):
            query['EnsRegionIds'] = request.ens_region_ids_shrink
        if not UtilClient.is_unset(request.instance_ids):
            query['InstanceIds'] = request.instance_ids
        if not UtilClient.is_unset(request.max_date):
            query['MaxDate'] = request.max_date
        if not UtilClient.is_unset(request.min_date):
            query['MinDate'] = request.min_date
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDataDistResult',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeDataDistResultResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_data_dist_result_with_options_async(
        self,
        tmp_req: ens_20171110_models.DescribeDataDistResultRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeDataDistResultResponse:
        """
        @summary Queries the distribution status of data files on edge instances of an application.
        
        @param tmp_req: DescribeDataDistResultRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDataDistResultResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.DescribeDataDistResultShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.ens_region_ids):
            request.ens_region_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.ens_region_ids, 'EnsRegionIds', 'json')
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.data_names):
            query['DataNames'] = request.data_names
        if not UtilClient.is_unset(request.data_versions):
            query['DataVersions'] = request.data_versions
        if not UtilClient.is_unset(request.ens_region_ids_shrink):
            query['EnsRegionIds'] = request.ens_region_ids_shrink
        if not UtilClient.is_unset(request.instance_ids):
            query['InstanceIds'] = request.instance_ids
        if not UtilClient.is_unset(request.max_date):
            query['MaxDate'] = request.max_date
        if not UtilClient.is_unset(request.min_date):
            query['MinDate'] = request.min_date
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDataDistResult',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeDataDistResultResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_data_dist_result(
        self,
        request: ens_20171110_models.DescribeDataDistResultRequest,
    ) -> ens_20171110_models.DescribeDataDistResultResponse:
        """
        @summary Queries the distribution status of data files on edge instances of an application.
        
        @param request: DescribeDataDistResultRequest
        @return: DescribeDataDistResultResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_data_dist_result_with_options(request, runtime)

    async def describe_data_dist_result_async(
        self,
        request: ens_20171110_models.DescribeDataDistResultRequest,
    ) -> ens_20171110_models.DescribeDataDistResultResponse:
        """
        @summary Queries the distribution status of data files on edge instances of an application.
        
        @param request: DescribeDataDistResultRequest
        @return: DescribeDataDistResultResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_data_dist_result_with_options_async(request, runtime)

    def describe_data_download_urlwith_options(
        self,
        request: ens_20171110_models.DescribeDataDownloadURLRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeDataDownloadURLResponse:
        """
        @summary Queries the download URLs of application data on file servers and returns the file servers on which data is pushed.
        
        @param request: DescribeDataDownloadURLRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDataDownloadURLResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDataDownloadURL',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeDataDownloadURLResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_data_download_urlwith_options_async(
        self,
        request: ens_20171110_models.DescribeDataDownloadURLRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeDataDownloadURLResponse:
        """
        @summary Queries the download URLs of application data on file servers and returns the file servers on which data is pushed.
        
        @param request: DescribeDataDownloadURLRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDataDownloadURLResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDataDownloadURL',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeDataDownloadURLResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_data_download_url(
        self,
        request: ens_20171110_models.DescribeDataDownloadURLRequest,
    ) -> ens_20171110_models.DescribeDataDownloadURLResponse:
        """
        @summary Queries the download URLs of application data on file servers and returns the file servers on which data is pushed.
        
        @param request: DescribeDataDownloadURLRequest
        @return: DescribeDataDownloadURLResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_data_download_urlwith_options(request, runtime)

    async def describe_data_download_url_async(
        self,
        request: ens_20171110_models.DescribeDataDownloadURLRequest,
    ) -> ens_20171110_models.DescribeDataDownloadURLResponse:
        """
        @summary Queries the download URLs of application data on file servers and returns the file servers on which data is pushed.
        
        @param request: DescribeDataDownloadURLRequest
        @return: DescribeDataDownloadURLResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_data_download_urlwith_options_async(request, runtime)

    def describe_data_push_result_with_options(
        self,
        request: ens_20171110_models.DescribeDataPushResultRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeDataPushResultResponse:
        """
        @summary Queries the push status of application data files on Edge Node Service (ENS) nodes.
        
        @param request: DescribeDataPushResultRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDataPushResultResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.data_names):
            query['DataNames'] = request.data_names
        if not UtilClient.is_unset(request.data_versions):
            query['DataVersions'] = request.data_versions
        if not UtilClient.is_unset(request.max_date):
            query['MaxDate'] = request.max_date
        if not UtilClient.is_unset(request.min_date):
            query['MinDate'] = request.min_date
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_ids):
            query['RegionIds'] = request.region_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDataPushResult',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeDataPushResultResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_data_push_result_with_options_async(
        self,
        request: ens_20171110_models.DescribeDataPushResultRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeDataPushResultResponse:
        """
        @summary Queries the push status of application data files on Edge Node Service (ENS) nodes.
        
        @param request: DescribeDataPushResultRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDataPushResultResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.data_names):
            query['DataNames'] = request.data_names
        if not UtilClient.is_unset(request.data_versions):
            query['DataVersions'] = request.data_versions
        if not UtilClient.is_unset(request.max_date):
            query['MaxDate'] = request.max_date
        if not UtilClient.is_unset(request.min_date):
            query['MinDate'] = request.min_date
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_ids):
            query['RegionIds'] = request.region_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDataPushResult',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeDataPushResultResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_data_push_result(
        self,
        request: ens_20171110_models.DescribeDataPushResultRequest,
    ) -> ens_20171110_models.DescribeDataPushResultResponse:
        """
        @summary Queries the push status of application data files on Edge Node Service (ENS) nodes.
        
        @param request: DescribeDataPushResultRequest
        @return: DescribeDataPushResultResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_data_push_result_with_options(request, runtime)

    async def describe_data_push_result_async(
        self,
        request: ens_20171110_models.DescribeDataPushResultRequest,
    ) -> ens_20171110_models.DescribeDataPushResultResponse:
        """
        @summary Queries the push status of application data files on Edge Node Service (ENS) nodes.
        
        @param request: DescribeDataPushResultRequest
        @return: DescribeDataPushResultResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_data_push_result_with_options_async(request, runtime)

    def describe_device_service_with_options(
        self,
        request: ens_20171110_models.DescribeDeviceServiceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeDeviceServiceResponse:
        """
        @summary Queries the properties of instances and virtual devices in a specific edge application.
        
        @param request: DescribeDeviceServiceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDeviceServiceResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDeviceService',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeDeviceServiceResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_device_service_with_options_async(
        self,
        request: ens_20171110_models.DescribeDeviceServiceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeDeviceServiceResponse:
        """
        @summary Queries the properties of instances and virtual devices in a specific edge application.
        
        @param request: DescribeDeviceServiceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDeviceServiceResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDeviceService',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeDeviceServiceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_device_service(
        self,
        request: ens_20171110_models.DescribeDeviceServiceRequest,
    ) -> ens_20171110_models.DescribeDeviceServiceResponse:
        """
        @summary Queries the properties of instances and virtual devices in a specific edge application.
        
        @param request: DescribeDeviceServiceRequest
        @return: DescribeDeviceServiceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_device_service_with_options(request, runtime)

    async def describe_device_service_async(
        self,
        request: ens_20171110_models.DescribeDeviceServiceRequest,
    ) -> ens_20171110_models.DescribeDeviceServiceResponse:
        """
        @summary Queries the properties of instances and virtual devices in a specific edge application.
        
        @param request: DescribeDeviceServiceRequest
        @return: DescribeDeviceServiceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_device_service_with_options_async(request, runtime)

    def describe_disk_iops_list_with_options(
        self,
        request: ens_20171110_models.DescribeDiskIopsListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeDiskIopsListResponse:
        """
        @summary Queries the disk IOPS monitoring data.
        
        @param request: DescribeDiskIopsListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDiskIopsListResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDiskIopsList',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeDiskIopsListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_disk_iops_list_with_options_async(
        self,
        request: ens_20171110_models.DescribeDiskIopsListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeDiskIopsListResponse:
        """
        @summary Queries the disk IOPS monitoring data.
        
        @param request: DescribeDiskIopsListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDiskIopsListResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDiskIopsList',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeDiskIopsListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_disk_iops_list(
        self,
        request: ens_20171110_models.DescribeDiskIopsListRequest,
    ) -> ens_20171110_models.DescribeDiskIopsListResponse:
        """
        @summary Queries the disk IOPS monitoring data.
        
        @param request: DescribeDiskIopsListRequest
        @return: DescribeDiskIopsListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_disk_iops_list_with_options(request, runtime)

    async def describe_disk_iops_list_async(
        self,
        request: ens_20171110_models.DescribeDiskIopsListRequest,
    ) -> ens_20171110_models.DescribeDiskIopsListResponse:
        """
        @summary Queries the disk IOPS monitoring data.
        
        @param request: DescribeDiskIopsListRequest
        @return: DescribeDiskIopsListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_disk_iops_list_with_options_async(request, runtime)

    def describe_disks_with_options(
        self,
        request: ens_20171110_models.DescribeDisksRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeDisksResponse:
        """
        @summary Queries the information about one or more disks.
        
        @param request: DescribeDisksRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDisksResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.category):
            query['Category'] = request.category
        if not UtilClient.is_unset(request.disk_charge_type):
            query['DiskChargeType'] = request.disk_charge_type
        if not UtilClient.is_unset(request.disk_id):
            query['DiskId'] = request.disk_id
        if not UtilClient.is_unset(request.disk_ids):
            query['DiskIds'] = request.disk_ids
        if not UtilClient.is_unset(request.disk_name):
            query['DiskName'] = request.disk_name
        if not UtilClient.is_unset(request.disk_type):
            query['DiskType'] = request.disk_type
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.ens_region_ids):
            query['EnsRegionIds'] = request.ens_region_ids
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.order_by_params):
            query['OrderByParams'] = request.order_by_params
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.snapshot_id):
            query['SnapshotId'] = request.snapshot_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDisks',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeDisksResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_disks_with_options_async(
        self,
        request: ens_20171110_models.DescribeDisksRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeDisksResponse:
        """
        @summary Queries the information about one or more disks.
        
        @param request: DescribeDisksRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDisksResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.category):
            query['Category'] = request.category
        if not UtilClient.is_unset(request.disk_charge_type):
            query['DiskChargeType'] = request.disk_charge_type
        if not UtilClient.is_unset(request.disk_id):
            query['DiskId'] = request.disk_id
        if not UtilClient.is_unset(request.disk_ids):
            query['DiskIds'] = request.disk_ids
        if not UtilClient.is_unset(request.disk_name):
            query['DiskName'] = request.disk_name
        if not UtilClient.is_unset(request.disk_type):
            query['DiskType'] = request.disk_type
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.ens_region_ids):
            query['EnsRegionIds'] = request.ens_region_ids
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.order_by_params):
            query['OrderByParams'] = request.order_by_params
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.snapshot_id):
            query['SnapshotId'] = request.snapshot_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDisks',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeDisksResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_disks(
        self,
        request: ens_20171110_models.DescribeDisksRequest,
    ) -> ens_20171110_models.DescribeDisksResponse:
        """
        @summary Queries the information about one or more disks.
        
        @param request: DescribeDisksRequest
        @return: DescribeDisksResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_disks_with_options(request, runtime)

    async def describe_disks_async(
        self,
        request: ens_20171110_models.DescribeDisksRequest,
    ) -> ens_20171110_models.DescribeDisksResponse:
        """
        @summary Queries the information about one or more disks.
        
        @param request: DescribeDisksRequest
        @return: DescribeDisksResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_disks_with_options_async(request, runtime)

    def describe_elb_available_resource_info_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeElbAvailableResourceInfoResponse:
        """
        @summary Queries the specifications of resources that you can purchase when you create an instance.
        
        @param request: DescribeElbAvailableResourceInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeElbAvailableResourceInfoResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeElbAvailableResourceInfo',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeElbAvailableResourceInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_elb_available_resource_info_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeElbAvailableResourceInfoResponse:
        """
        @summary Queries the specifications of resources that you can purchase when you create an instance.
        
        @param request: DescribeElbAvailableResourceInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeElbAvailableResourceInfoResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeElbAvailableResourceInfo',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeElbAvailableResourceInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_elb_available_resource_info(self) -> ens_20171110_models.DescribeElbAvailableResourceInfoResponse:
        """
        @summary Queries the specifications of resources that you can purchase when you create an instance.
        
        @return: DescribeElbAvailableResourceInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_elb_available_resource_info_with_options(runtime)

    async def describe_elb_available_resource_info_async(self) -> ens_20171110_models.DescribeElbAvailableResourceInfoResponse:
        """
        @summary Queries the specifications of resources that you can purchase when you create an instance.
        
        @return: DescribeElbAvailableResourceInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_elb_available_resource_info_with_options_async(runtime)

    def describe_ens_commodity_code_with_options(
        self,
        request: ens_20171110_models.DescribeEnsCommodityCodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeEnsCommodityCodeResponse:
        """
        @summary 描述商品code
        
        @param request: DescribeEnsCommodityCodeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeEnsCommodityCodeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.commodity_code):
            query['CommodityCode'] = request.commodity_code
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEnsCommodityCode',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeEnsCommodityCodeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ens_commodity_code_with_options_async(
        self,
        request: ens_20171110_models.DescribeEnsCommodityCodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeEnsCommodityCodeResponse:
        """
        @summary 描述商品code
        
        @param request: DescribeEnsCommodityCodeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeEnsCommodityCodeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.commodity_code):
            query['CommodityCode'] = request.commodity_code
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEnsCommodityCode',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeEnsCommodityCodeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ens_commodity_code(
        self,
        request: ens_20171110_models.DescribeEnsCommodityCodeRequest,
    ) -> ens_20171110_models.DescribeEnsCommodityCodeResponse:
        """
        @summary 描述商品code
        
        @param request: DescribeEnsCommodityCodeRequest
        @return: DescribeEnsCommodityCodeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_ens_commodity_code_with_options(request, runtime)

    async def describe_ens_commodity_code_async(
        self,
        request: ens_20171110_models.DescribeEnsCommodityCodeRequest,
    ) -> ens_20171110_models.DescribeEnsCommodityCodeResponse:
        """
        @summary 描述商品code
        
        @param request: DescribeEnsCommodityCodeRequest
        @return: DescribeEnsCommodityCodeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_ens_commodity_code_with_options_async(request, runtime)

    def describe_ens_commodity_module_code_with_options(
        self,
        request: ens_20171110_models.DescribeEnsCommodityModuleCodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeEnsCommodityModuleCodeResponse:
        """
        @summary 获取模块code
        
        @param request: DescribeEnsCommodityModuleCodeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeEnsCommodityModuleCodeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.commodity_code):
            query['CommodityCode'] = request.commodity_code
        if not UtilClient.is_unset(request.module_code):
            query['ModuleCode'] = request.module_code
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEnsCommodityModuleCode',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeEnsCommodityModuleCodeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ens_commodity_module_code_with_options_async(
        self,
        request: ens_20171110_models.DescribeEnsCommodityModuleCodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeEnsCommodityModuleCodeResponse:
        """
        @summary 获取模块code
        
        @param request: DescribeEnsCommodityModuleCodeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeEnsCommodityModuleCodeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.commodity_code):
            query['CommodityCode'] = request.commodity_code
        if not UtilClient.is_unset(request.module_code):
            query['ModuleCode'] = request.module_code
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEnsCommodityModuleCode',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeEnsCommodityModuleCodeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ens_commodity_module_code(
        self,
        request: ens_20171110_models.DescribeEnsCommodityModuleCodeRequest,
    ) -> ens_20171110_models.DescribeEnsCommodityModuleCodeResponse:
        """
        @summary 获取模块code
        
        @param request: DescribeEnsCommodityModuleCodeRequest
        @return: DescribeEnsCommodityModuleCodeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_ens_commodity_module_code_with_options(request, runtime)

    async def describe_ens_commodity_module_code_async(
        self,
        request: ens_20171110_models.DescribeEnsCommodityModuleCodeRequest,
    ) -> ens_20171110_models.DescribeEnsCommodityModuleCodeResponse:
        """
        @summary 获取模块code
        
        @param request: DescribeEnsCommodityModuleCodeRequest
        @return: DescribeEnsCommodityModuleCodeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_ens_commodity_module_code_with_options_async(request, runtime)

    def describe_ens_eip_addresses_with_options(
        self,
        request: ens_20171110_models.DescribeEnsEipAddressesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeEnsEipAddressesResponse:
        """
        @summary Queries elastic IP addresses (EIPs).
        
        @param request: DescribeEnsEipAddressesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeEnsEipAddressesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.allocation_id):
            query['AllocationId'] = request.allocation_id
        if not UtilClient.is_unset(request.associated_instance_id):
            query['AssociatedInstanceId'] = request.associated_instance_id
        if not UtilClient.is_unset(request.associated_instance_type):
            query['AssociatedInstanceType'] = request.associated_instance_type
        if not UtilClient.is_unset(request.eip_address):
            query['EipAddress'] = request.eip_address
        if not UtilClient.is_unset(request.eip_name):
            query['EipName'] = request.eip_name
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.ens_region_ids):
            query['EnsRegionIds'] = request.ens_region_ids
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.standby):
            query['Standby'] = request.standby
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEnsEipAddresses',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeEnsEipAddressesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ens_eip_addresses_with_options_async(
        self,
        request: ens_20171110_models.DescribeEnsEipAddressesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeEnsEipAddressesResponse:
        """
        @summary Queries elastic IP addresses (EIPs).
        
        @param request: DescribeEnsEipAddressesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeEnsEipAddressesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.allocation_id):
            query['AllocationId'] = request.allocation_id
        if not UtilClient.is_unset(request.associated_instance_id):
            query['AssociatedInstanceId'] = request.associated_instance_id
        if not UtilClient.is_unset(request.associated_instance_type):
            query['AssociatedInstanceType'] = request.associated_instance_type
        if not UtilClient.is_unset(request.eip_address):
            query['EipAddress'] = request.eip_address
        if not UtilClient.is_unset(request.eip_name):
            query['EipName'] = request.eip_name
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.ens_region_ids):
            query['EnsRegionIds'] = request.ens_region_ids
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.standby):
            query['Standby'] = request.standby
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEnsEipAddresses',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeEnsEipAddressesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ens_eip_addresses(
        self,
        request: ens_20171110_models.DescribeEnsEipAddressesRequest,
    ) -> ens_20171110_models.DescribeEnsEipAddressesResponse:
        """
        @summary Queries elastic IP addresses (EIPs).
        
        @param request: DescribeEnsEipAddressesRequest
        @return: DescribeEnsEipAddressesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_ens_eip_addresses_with_options(request, runtime)

    async def describe_ens_eip_addresses_async(
        self,
        request: ens_20171110_models.DescribeEnsEipAddressesRequest,
    ) -> ens_20171110_models.DescribeEnsEipAddressesResponse:
        """
        @summary Queries elastic IP addresses (EIPs).
        
        @param request: DescribeEnsEipAddressesRequest
        @return: DescribeEnsEipAddressesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_ens_eip_addresses_with_options_async(request, runtime)

    def describe_ens_net_district_with_options(
        self,
        request: ens_20171110_models.DescribeEnsNetDistrictRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeEnsNetDistrictResponse:
        """
        @summary Queries regions in which ENS resources can be created.
        
        @param request: DescribeEnsNetDistrictRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeEnsNetDistrictResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.net_district_code):
            query['NetDistrictCode'] = request.net_district_code
        if not UtilClient.is_unset(request.net_level_code):
            query['NetLevelCode'] = request.net_level_code
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEnsNetDistrict',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeEnsNetDistrictResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ens_net_district_with_options_async(
        self,
        request: ens_20171110_models.DescribeEnsNetDistrictRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeEnsNetDistrictResponse:
        """
        @summary Queries regions in which ENS resources can be created.
        
        @param request: DescribeEnsNetDistrictRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeEnsNetDistrictResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.net_district_code):
            query['NetDistrictCode'] = request.net_district_code
        if not UtilClient.is_unset(request.net_level_code):
            query['NetLevelCode'] = request.net_level_code
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEnsNetDistrict',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeEnsNetDistrictResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ens_net_district(
        self,
        request: ens_20171110_models.DescribeEnsNetDistrictRequest,
    ) -> ens_20171110_models.DescribeEnsNetDistrictResponse:
        """
        @summary Queries regions in which ENS resources can be created.
        
        @param request: DescribeEnsNetDistrictRequest
        @return: DescribeEnsNetDistrictResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_ens_net_district_with_options(request, runtime)

    async def describe_ens_net_district_async(
        self,
        request: ens_20171110_models.DescribeEnsNetDistrictRequest,
    ) -> ens_20171110_models.DescribeEnsNetDistrictResponse:
        """
        @summary Queries regions in which ENS resources can be created.
        
        @param request: DescribeEnsNetDistrictRequest
        @return: DescribeEnsNetDistrictResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_ens_net_district_with_options_async(request, runtime)

    def describe_ens_net_level_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeEnsNetLevelResponse:
        """
        @summary Queries the supported network levels.
        
        @param request: DescribeEnsNetLevelRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeEnsNetLevelResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeEnsNetLevel',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeEnsNetLevelResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ens_net_level_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeEnsNetLevelResponse:
        """
        @summary Queries the supported network levels.
        
        @param request: DescribeEnsNetLevelRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeEnsNetLevelResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeEnsNetLevel',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeEnsNetLevelResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ens_net_level(self) -> ens_20171110_models.DescribeEnsNetLevelResponse:
        """
        @summary Queries the supported network levels.
        
        @return: DescribeEnsNetLevelResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_ens_net_level_with_options(runtime)

    async def describe_ens_net_level_async(self) -> ens_20171110_models.DescribeEnsNetLevelResponse:
        """
        @summary Queries the supported network levels.
        
        @return: DescribeEnsNetLevelResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_ens_net_level_with_options_async(runtime)

    def describe_ens_net_sale_district_with_options(
        self,
        request: ens_20171110_models.DescribeEnsNetSaleDistrictRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeEnsNetSaleDistrictResponse:
        """
        @summary Queries the information about ISPs and number of ISPs in an area.
        
        @param request: DescribeEnsNetSaleDistrictRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeEnsNetSaleDistrictResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.net_district_code):
            query['NetDistrictCode'] = request.net_district_code
        if not UtilClient.is_unset(request.net_level_code):
            query['NetLevelCode'] = request.net_level_code
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEnsNetSaleDistrict',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeEnsNetSaleDistrictResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ens_net_sale_district_with_options_async(
        self,
        request: ens_20171110_models.DescribeEnsNetSaleDistrictRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeEnsNetSaleDistrictResponse:
        """
        @summary Queries the information about ISPs and number of ISPs in an area.
        
        @param request: DescribeEnsNetSaleDistrictRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeEnsNetSaleDistrictResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.net_district_code):
            query['NetDistrictCode'] = request.net_district_code
        if not UtilClient.is_unset(request.net_level_code):
            query['NetLevelCode'] = request.net_level_code
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEnsNetSaleDistrict',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeEnsNetSaleDistrictResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ens_net_sale_district(
        self,
        request: ens_20171110_models.DescribeEnsNetSaleDistrictRequest,
    ) -> ens_20171110_models.DescribeEnsNetSaleDistrictResponse:
        """
        @summary Queries the information about ISPs and number of ISPs in an area.
        
        @param request: DescribeEnsNetSaleDistrictRequest
        @return: DescribeEnsNetSaleDistrictResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_ens_net_sale_district_with_options(request, runtime)

    async def describe_ens_net_sale_district_async(
        self,
        request: ens_20171110_models.DescribeEnsNetSaleDistrictRequest,
    ) -> ens_20171110_models.DescribeEnsNetSaleDistrictResponse:
        """
        @summary Queries the information about ISPs and number of ISPs in an area.
        
        @param request: DescribeEnsNetSaleDistrictRequest
        @return: DescribeEnsNetSaleDistrictResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_ens_net_sale_district_with_options_async(request, runtime)

    def describe_ens_region_id_ipv_6info_with_options(
        self,
        request: ens_20171110_models.DescribeEnsRegionIdIpv6InfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeEnsRegionIdIpv6InfoResponse:
        """
        @summary Queries whether a node supports IPv6.
        
        @param request: DescribeEnsRegionIdIpv6InfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeEnsRegionIdIpv6InfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEnsRegionIdIpv6Info',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeEnsRegionIdIpv6InfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ens_region_id_ipv_6info_with_options_async(
        self,
        request: ens_20171110_models.DescribeEnsRegionIdIpv6InfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeEnsRegionIdIpv6InfoResponse:
        """
        @summary Queries whether a node supports IPv6.
        
        @param request: DescribeEnsRegionIdIpv6InfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeEnsRegionIdIpv6InfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEnsRegionIdIpv6Info',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeEnsRegionIdIpv6InfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ens_region_id_ipv_6info(
        self,
        request: ens_20171110_models.DescribeEnsRegionIdIpv6InfoRequest,
    ) -> ens_20171110_models.DescribeEnsRegionIdIpv6InfoResponse:
        """
        @summary Queries whether a node supports IPv6.
        
        @param request: DescribeEnsRegionIdIpv6InfoRequest
        @return: DescribeEnsRegionIdIpv6InfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_ens_region_id_ipv_6info_with_options(request, runtime)

    async def describe_ens_region_id_ipv_6info_async(
        self,
        request: ens_20171110_models.DescribeEnsRegionIdIpv6InfoRequest,
    ) -> ens_20171110_models.DescribeEnsRegionIdIpv6InfoResponse:
        """
        @summary Queries whether a node supports IPv6.
        
        @param request: DescribeEnsRegionIdIpv6InfoRequest
        @return: DescribeEnsRegionIdIpv6InfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_ens_region_id_ipv_6info_with_options_async(request, runtime)

    def describe_ens_region_id_resource_with_options(
        self,
        request: ens_20171110_models.DescribeEnsRegionIdResourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeEnsRegionIdResourceResponse:
        """
        @summary Queries node resources.
        
        @description ***\
        
        @param request: DescribeEnsRegionIdResourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeEnsRegionIdResourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.isp):
            query['Isp'] = request.isp
        if not UtilClient.is_unset(request.order_by_params):
            query['OrderByParams'] = request.order_by_params
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEnsRegionIdResource',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeEnsRegionIdResourceResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ens_region_id_resource_with_options_async(
        self,
        request: ens_20171110_models.DescribeEnsRegionIdResourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeEnsRegionIdResourceResponse:
        """
        @summary Queries node resources.
        
        @description ***\
        
        @param request: DescribeEnsRegionIdResourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeEnsRegionIdResourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.isp):
            query['Isp'] = request.isp
        if not UtilClient.is_unset(request.order_by_params):
            query['OrderByParams'] = request.order_by_params
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEnsRegionIdResource',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeEnsRegionIdResourceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ens_region_id_resource(
        self,
        request: ens_20171110_models.DescribeEnsRegionIdResourceRequest,
    ) -> ens_20171110_models.DescribeEnsRegionIdResourceResponse:
        """
        @summary Queries node resources.
        
        @description ***\
        
        @param request: DescribeEnsRegionIdResourceRequest
        @return: DescribeEnsRegionIdResourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_ens_region_id_resource_with_options(request, runtime)

    async def describe_ens_region_id_resource_async(
        self,
        request: ens_20171110_models.DescribeEnsRegionIdResourceRequest,
    ) -> ens_20171110_models.DescribeEnsRegionIdResourceResponse:
        """
        @summary Queries node resources.
        
        @description ***\
        
        @param request: DescribeEnsRegionIdResourceRequest
        @return: DescribeEnsRegionIdResourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_ens_region_id_resource_with_options_async(request, runtime)

    def describe_ens_regions_with_options(
        self,
        request: ens_20171110_models.DescribeEnsRegionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeEnsRegionsResponse:
        """
        @summary Queries the Edge Node Service (ENS) nodes that you can use.
        
        @param request: DescribeEnsRegionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeEnsRegionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEnsRegions',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeEnsRegionsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ens_regions_with_options_async(
        self,
        request: ens_20171110_models.DescribeEnsRegionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeEnsRegionsResponse:
        """
        @summary Queries the Edge Node Service (ENS) nodes that you can use.
        
        @param request: DescribeEnsRegionsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeEnsRegionsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEnsRegions',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeEnsRegionsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ens_regions(
        self,
        request: ens_20171110_models.DescribeEnsRegionsRequest,
    ) -> ens_20171110_models.DescribeEnsRegionsResponse:
        """
        @summary Queries the Edge Node Service (ENS) nodes that you can use.
        
        @param request: DescribeEnsRegionsRequest
        @return: DescribeEnsRegionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_ens_regions_with_options(request, runtime)

    async def describe_ens_regions_async(
        self,
        request: ens_20171110_models.DescribeEnsRegionsRequest,
    ) -> ens_20171110_models.DescribeEnsRegionsResponse:
        """
        @summary Queries the Edge Node Service (ENS) nodes that you can use.
        
        @param request: DescribeEnsRegionsRequest
        @return: DescribeEnsRegionsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_ens_regions_with_options_async(request, runtime)

    def describe_ens_resource_usage_with_options(
        self,
        request: ens_20171110_models.DescribeEnsResourceUsageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeEnsResourceUsageResponse:
        """
        @summary Queries the usage summary of ENS virtual machines (VMs), disks, and networks.
        
        @param request: DescribeEnsResourceUsageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeEnsResourceUsageResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEnsResourceUsage',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeEnsResourceUsageResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ens_resource_usage_with_options_async(
        self,
        request: ens_20171110_models.DescribeEnsResourceUsageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeEnsResourceUsageResponse:
        """
        @summary Queries the usage summary of ENS virtual machines (VMs), disks, and networks.
        
        @param request: DescribeEnsResourceUsageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeEnsResourceUsageResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEnsResourceUsage',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeEnsResourceUsageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ens_resource_usage(
        self,
        request: ens_20171110_models.DescribeEnsResourceUsageRequest,
    ) -> ens_20171110_models.DescribeEnsResourceUsageResponse:
        """
        @summary Queries the usage summary of ENS virtual machines (VMs), disks, and networks.
        
        @param request: DescribeEnsResourceUsageRequest
        @return: DescribeEnsResourceUsageResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_ens_resource_usage_with_options(request, runtime)

    async def describe_ens_resource_usage_async(
        self,
        request: ens_20171110_models.DescribeEnsResourceUsageRequest,
    ) -> ens_20171110_models.DescribeEnsResourceUsageResponse:
        """
        @summary Queries the usage summary of ENS virtual machines (VMs), disks, and networks.
        
        @param request: DescribeEnsResourceUsageRequest
        @return: DescribeEnsResourceUsageResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_ens_resource_usage_with_options_async(request, runtime)

    def describe_ens_route_entry_list_with_options(
        self,
        request: ens_20171110_models.DescribeEnsRouteEntryListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeEnsRouteEntryListResponse:
        """
        @summary Queries route entries.
        
        @param request: DescribeEnsRouteEntryListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeEnsRouteEntryListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.destination_cidr_block):
            query['DestinationCidrBlock'] = request.destination_cidr_block
        if not UtilClient.is_unset(request.next_hop_id):
            query['NextHopId'] = request.next_hop_id
        if not UtilClient.is_unset(request.next_hop_type):
            query['NextHopType'] = request.next_hop_type
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.route_entry_id):
            query['RouteEntryId'] = request.route_entry_id
        if not UtilClient.is_unset(request.route_entry_name):
            query['RouteEntryName'] = request.route_entry_name
        if not UtilClient.is_unset(request.route_entry_type):
            query['RouteEntryType'] = request.route_entry_type
        if not UtilClient.is_unset(request.route_table_id):
            query['RouteTableId'] = request.route_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEnsRouteEntryList',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeEnsRouteEntryListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ens_route_entry_list_with_options_async(
        self,
        request: ens_20171110_models.DescribeEnsRouteEntryListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeEnsRouteEntryListResponse:
        """
        @summary Queries route entries.
        
        @param request: DescribeEnsRouteEntryListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeEnsRouteEntryListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.destination_cidr_block):
            query['DestinationCidrBlock'] = request.destination_cidr_block
        if not UtilClient.is_unset(request.next_hop_id):
            query['NextHopId'] = request.next_hop_id
        if not UtilClient.is_unset(request.next_hop_type):
            query['NextHopType'] = request.next_hop_type
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.route_entry_id):
            query['RouteEntryId'] = request.route_entry_id
        if not UtilClient.is_unset(request.route_entry_name):
            query['RouteEntryName'] = request.route_entry_name
        if not UtilClient.is_unset(request.route_entry_type):
            query['RouteEntryType'] = request.route_entry_type
        if not UtilClient.is_unset(request.route_table_id):
            query['RouteTableId'] = request.route_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEnsRouteEntryList',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeEnsRouteEntryListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ens_route_entry_list(
        self,
        request: ens_20171110_models.DescribeEnsRouteEntryListRequest,
    ) -> ens_20171110_models.DescribeEnsRouteEntryListResponse:
        """
        @summary Queries route entries.
        
        @param request: DescribeEnsRouteEntryListRequest
        @return: DescribeEnsRouteEntryListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_ens_route_entry_list_with_options(request, runtime)

    async def describe_ens_route_entry_list_async(
        self,
        request: ens_20171110_models.DescribeEnsRouteEntryListRequest,
    ) -> ens_20171110_models.DescribeEnsRouteEntryListResponse:
        """
        @summary Queries route entries.
        
        @param request: DescribeEnsRouteEntryListRequest
        @return: DescribeEnsRouteEntryListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_ens_route_entry_list_with_options_async(request, runtime)

    def describe_ens_route_tables_with_options(
        self,
        request: ens_20171110_models.DescribeEnsRouteTablesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeEnsRouteTablesResponse:
        """
        @summary Queries route tables.
        
        @param request: DescribeEnsRouteTablesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeEnsRouteTablesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.associate_type):
            query['AssociateType'] = request.associate_type
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.ens_region_ids):
            query['EnsRegionIds'] = request.ens_region_ids
        if not UtilClient.is_unset(request.network_id):
            query['NetworkId'] = request.network_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.route_table_id):
            query['RouteTableId'] = request.route_table_id
        if not UtilClient.is_unset(request.route_table_name):
            query['RouteTableName'] = request.route_table_name
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEnsRouteTables',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeEnsRouteTablesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ens_route_tables_with_options_async(
        self,
        request: ens_20171110_models.DescribeEnsRouteTablesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeEnsRouteTablesResponse:
        """
        @summary Queries route tables.
        
        @param request: DescribeEnsRouteTablesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeEnsRouteTablesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.associate_type):
            query['AssociateType'] = request.associate_type
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.ens_region_ids):
            query['EnsRegionIds'] = request.ens_region_ids
        if not UtilClient.is_unset(request.network_id):
            query['NetworkId'] = request.network_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.route_table_id):
            query['RouteTableId'] = request.route_table_id
        if not UtilClient.is_unset(request.route_table_name):
            query['RouteTableName'] = request.route_table_name
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEnsRouteTables',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeEnsRouteTablesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ens_route_tables(
        self,
        request: ens_20171110_models.DescribeEnsRouteTablesRequest,
    ) -> ens_20171110_models.DescribeEnsRouteTablesResponse:
        """
        @summary Queries route tables.
        
        @param request: DescribeEnsRouteTablesRequest
        @return: DescribeEnsRouteTablesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_ens_route_tables_with_options(request, runtime)

    async def describe_ens_route_tables_async(
        self,
        request: ens_20171110_models.DescribeEnsRouteTablesRequest,
    ) -> ens_20171110_models.DescribeEnsRouteTablesResponse:
        """
        @summary Queries route tables.
        
        @param request: DescribeEnsRouteTablesRequest
        @return: DescribeEnsRouteTablesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_ens_route_tables_with_options_async(request, runtime)

    def describe_ens_sale_control_with_options(
        self,
        request: ens_20171110_models.DescribeEnsSaleControlRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeEnsSaleControlResponse:
        """
        @summary 展示配置的售卖约束信息
        
        @param request: DescribeEnsSaleControlRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeEnsSaleControlResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ali_uid_account):
            query['AliUidAccount'] = request.ali_uid_account
        if not UtilClient.is_unset(request.commodity_code):
            query['CommodityCode'] = request.commodity_code
        if not UtilClient.is_unset(request.custom_account):
            query['CustomAccount'] = request.custom_account
        if not UtilClient.is_unset(request.module_code):
            query['ModuleCode'] = request.module_code
        if not UtilClient.is_unset(request.order_type):
            query['OrderType'] = request.order_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEnsSaleControl',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeEnsSaleControlResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ens_sale_control_with_options_async(
        self,
        request: ens_20171110_models.DescribeEnsSaleControlRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeEnsSaleControlResponse:
        """
        @summary 展示配置的售卖约束信息
        
        @param request: DescribeEnsSaleControlRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeEnsSaleControlResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ali_uid_account):
            query['AliUidAccount'] = request.ali_uid_account
        if not UtilClient.is_unset(request.commodity_code):
            query['CommodityCode'] = request.commodity_code
        if not UtilClient.is_unset(request.custom_account):
            query['CustomAccount'] = request.custom_account
        if not UtilClient.is_unset(request.module_code):
            query['ModuleCode'] = request.module_code
        if not UtilClient.is_unset(request.order_type):
            query['OrderType'] = request.order_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEnsSaleControl',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeEnsSaleControlResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ens_sale_control(
        self,
        request: ens_20171110_models.DescribeEnsSaleControlRequest,
    ) -> ens_20171110_models.DescribeEnsSaleControlResponse:
        """
        @summary 展示配置的售卖约束信息
        
        @param request: DescribeEnsSaleControlRequest
        @return: DescribeEnsSaleControlResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_ens_sale_control_with_options(request, runtime)

    async def describe_ens_sale_control_async(
        self,
        request: ens_20171110_models.DescribeEnsSaleControlRequest,
    ) -> ens_20171110_models.DescribeEnsSaleControlResponse:
        """
        @summary 展示配置的售卖约束信息
        
        @param request: DescribeEnsSaleControlRequest
        @return: DescribeEnsSaleControlResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_ens_sale_control_with_options_async(request, runtime)

    def describe_ens_sale_control_available_resource_with_options(
        self,
        request: ens_20171110_models.DescribeEnsSaleControlAvailableResourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeEnsSaleControlAvailableResourceResponse:
        """
        @summary 获取可用资源
        
        @param request: DescribeEnsSaleControlAvailableResourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeEnsSaleControlAvailableResourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.commodity_code):
            query['CommodityCode'] = request.commodity_code
        if not UtilClient.is_unset(request.custom_account):
            query['CustomAccount'] = request.custom_account
        if not UtilClient.is_unset(request.order_type):
            query['OrderType'] = request.order_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEnsSaleControlAvailableResource',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeEnsSaleControlAvailableResourceResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ens_sale_control_available_resource_with_options_async(
        self,
        request: ens_20171110_models.DescribeEnsSaleControlAvailableResourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeEnsSaleControlAvailableResourceResponse:
        """
        @summary 获取可用资源
        
        @param request: DescribeEnsSaleControlAvailableResourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeEnsSaleControlAvailableResourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.commodity_code):
            query['CommodityCode'] = request.commodity_code
        if not UtilClient.is_unset(request.custom_account):
            query['CustomAccount'] = request.custom_account
        if not UtilClient.is_unset(request.order_type):
            query['OrderType'] = request.order_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEnsSaleControlAvailableResource',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeEnsSaleControlAvailableResourceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ens_sale_control_available_resource(
        self,
        request: ens_20171110_models.DescribeEnsSaleControlAvailableResourceRequest,
    ) -> ens_20171110_models.DescribeEnsSaleControlAvailableResourceResponse:
        """
        @summary 获取可用资源
        
        @param request: DescribeEnsSaleControlAvailableResourceRequest
        @return: DescribeEnsSaleControlAvailableResourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_ens_sale_control_available_resource_with_options(request, runtime)

    async def describe_ens_sale_control_available_resource_async(
        self,
        request: ens_20171110_models.DescribeEnsSaleControlAvailableResourceRequest,
    ) -> ens_20171110_models.DescribeEnsSaleControlAvailableResourceResponse:
        """
        @summary 获取可用资源
        
        @param request: DescribeEnsSaleControlAvailableResourceRequest
        @return: DescribeEnsSaleControlAvailableResourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_ens_sale_control_available_resource_with_options_async(request, runtime)

    def describe_ens_sale_control_stock_with_options(
        self,
        request: ens_20171110_models.DescribeEnsSaleControlStockRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeEnsSaleControlStockResponse:
        """
        @summary 获取售卖约束库存
        
        @param request: DescribeEnsSaleControlStockRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeEnsSaleControlStockResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ali_uid_account):
            query['AliUidAccount'] = request.ali_uid_account
        if not UtilClient.is_unset(request.commodity_code):
            query['CommodityCode'] = request.commodity_code
        if not UtilClient.is_unset(request.custom_account):
            query['CustomAccount'] = request.custom_account
        if not UtilClient.is_unset(request.module_code):
            query['ModuleCode'] = request.module_code
        if not UtilClient.is_unset(request.order_type):
            query['OrderType'] = request.order_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEnsSaleControlStock',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeEnsSaleControlStockResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ens_sale_control_stock_with_options_async(
        self,
        request: ens_20171110_models.DescribeEnsSaleControlStockRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeEnsSaleControlStockResponse:
        """
        @summary 获取售卖约束库存
        
        @param request: DescribeEnsSaleControlStockRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeEnsSaleControlStockResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ali_uid_account):
            query['AliUidAccount'] = request.ali_uid_account
        if not UtilClient.is_unset(request.commodity_code):
            query['CommodityCode'] = request.commodity_code
        if not UtilClient.is_unset(request.custom_account):
            query['CustomAccount'] = request.custom_account
        if not UtilClient.is_unset(request.module_code):
            query['ModuleCode'] = request.module_code
        if not UtilClient.is_unset(request.order_type):
            query['OrderType'] = request.order_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEnsSaleControlStock',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeEnsSaleControlStockResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ens_sale_control_stock(
        self,
        request: ens_20171110_models.DescribeEnsSaleControlStockRequest,
    ) -> ens_20171110_models.DescribeEnsSaleControlStockResponse:
        """
        @summary 获取售卖约束库存
        
        @param request: DescribeEnsSaleControlStockRequest
        @return: DescribeEnsSaleControlStockResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_ens_sale_control_stock_with_options(request, runtime)

    async def describe_ens_sale_control_stock_async(
        self,
        request: ens_20171110_models.DescribeEnsSaleControlStockRequest,
    ) -> ens_20171110_models.DescribeEnsSaleControlStockResponse:
        """
        @summary 获取售卖约束库存
        
        @param request: DescribeEnsSaleControlStockRequest
        @return: DescribeEnsSaleControlStockResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_ens_sale_control_stock_with_options_async(request, runtime)

    def describe_epn_band_width_data_with_options(
        self,
        request: ens_20171110_models.DescribeEpnBandWidthDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeEpnBandWidthDataResponse:
        """
        @summary Queries the EPN bandwidth usage.
        
        @param request: DescribeEpnBandWidthDataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeEpnBandWidthDataResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.epninstance_id):
            query['EPNInstanceId'] = request.epninstance_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.isp):
            query['Isp'] = request.isp
        if not UtilClient.is_unset(request.networking_model):
            query['NetworkingModel'] = request.networking_model
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEpnBandWidthData',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeEpnBandWidthDataResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_epn_band_width_data_with_options_async(
        self,
        request: ens_20171110_models.DescribeEpnBandWidthDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeEpnBandWidthDataResponse:
        """
        @summary Queries the EPN bandwidth usage.
        
        @param request: DescribeEpnBandWidthDataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeEpnBandWidthDataResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.epninstance_id):
            query['EPNInstanceId'] = request.epninstance_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.isp):
            query['Isp'] = request.isp
        if not UtilClient.is_unset(request.networking_model):
            query['NetworkingModel'] = request.networking_model
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEpnBandWidthData',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeEpnBandWidthDataResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_epn_band_width_data(
        self,
        request: ens_20171110_models.DescribeEpnBandWidthDataRequest,
    ) -> ens_20171110_models.DescribeEpnBandWidthDataResponse:
        """
        @summary Queries the EPN bandwidth usage.
        
        @param request: DescribeEpnBandWidthDataRequest
        @return: DescribeEpnBandWidthDataResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_epn_band_width_data_with_options(request, runtime)

    async def describe_epn_band_width_data_async(
        self,
        request: ens_20171110_models.DescribeEpnBandWidthDataRequest,
    ) -> ens_20171110_models.DescribeEpnBandWidthDataResponse:
        """
        @summary Queries the EPN bandwidth usage.
        
        @param request: DescribeEpnBandWidthDataRequest
        @return: DescribeEpnBandWidthDataResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_epn_band_width_data_with_options_async(request, runtime)

    def describe_epn_bandwitdh_by_internet_charge_type_with_options(
        self,
        request: ens_20171110_models.DescribeEpnBandwitdhByInternetChargeTypeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeEpnBandwitdhByInternetChargeTypeResponse:
        """
        @summary Queries the metering method of the EPN bandwidth within a time period.
        
        @param request: DescribeEpnBandwitdhByInternetChargeTypeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeEpnBandwitdhByInternetChargeTypeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.isp):
            query['Isp'] = request.isp
        if not UtilClient.is_unset(request.networking_model):
            query['NetworkingModel'] = request.networking_model
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEpnBandwitdhByInternetChargeType',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeEpnBandwitdhByInternetChargeTypeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_epn_bandwitdh_by_internet_charge_type_with_options_async(
        self,
        request: ens_20171110_models.DescribeEpnBandwitdhByInternetChargeTypeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeEpnBandwitdhByInternetChargeTypeResponse:
        """
        @summary Queries the metering method of the EPN bandwidth within a time period.
        
        @param request: DescribeEpnBandwitdhByInternetChargeTypeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeEpnBandwitdhByInternetChargeTypeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.isp):
            query['Isp'] = request.isp
        if not UtilClient.is_unset(request.networking_model):
            query['NetworkingModel'] = request.networking_model
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEpnBandwitdhByInternetChargeType',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeEpnBandwitdhByInternetChargeTypeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_epn_bandwitdh_by_internet_charge_type(
        self,
        request: ens_20171110_models.DescribeEpnBandwitdhByInternetChargeTypeRequest,
    ) -> ens_20171110_models.DescribeEpnBandwitdhByInternetChargeTypeResponse:
        """
        @summary Queries the metering method of the EPN bandwidth within a time period.
        
        @param request: DescribeEpnBandwitdhByInternetChargeTypeRequest
        @return: DescribeEpnBandwitdhByInternetChargeTypeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_epn_bandwitdh_by_internet_charge_type_with_options(request, runtime)

    async def describe_epn_bandwitdh_by_internet_charge_type_async(
        self,
        request: ens_20171110_models.DescribeEpnBandwitdhByInternetChargeTypeRequest,
    ) -> ens_20171110_models.DescribeEpnBandwitdhByInternetChargeTypeResponse:
        """
        @summary Queries the metering method of the EPN bandwidth within a time period.
        
        @param request: DescribeEpnBandwitdhByInternetChargeTypeRequest
        @return: DescribeEpnBandwitdhByInternetChargeTypeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_epn_bandwitdh_by_internet_charge_type_with_options_async(request, runtime)

    def describe_epn_instance_attribute_with_options(
        self,
        request: ens_20171110_models.DescribeEpnInstanceAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeEpnInstanceAttributeResponse:
        """
        @summary Queries networking information about an EPN instance.
        
        @description In internal networking mode, the value of Instances is empty in the response. In public networking mode, the value of VSwitches is empty in the response.
        
        @param request: DescribeEpnInstanceAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeEpnInstanceAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.epninstance_id):
            query['EPNInstanceId'] = request.epninstance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEpnInstanceAttribute',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeEpnInstanceAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_epn_instance_attribute_with_options_async(
        self,
        request: ens_20171110_models.DescribeEpnInstanceAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeEpnInstanceAttributeResponse:
        """
        @summary Queries networking information about an EPN instance.
        
        @description In internal networking mode, the value of Instances is empty in the response. In public networking mode, the value of VSwitches is empty in the response.
        
        @param request: DescribeEpnInstanceAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeEpnInstanceAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.epninstance_id):
            query['EPNInstanceId'] = request.epninstance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEpnInstanceAttribute',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeEpnInstanceAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_epn_instance_attribute(
        self,
        request: ens_20171110_models.DescribeEpnInstanceAttributeRequest,
    ) -> ens_20171110_models.DescribeEpnInstanceAttributeResponse:
        """
        @summary Queries networking information about an EPN instance.
        
        @description In internal networking mode, the value of Instances is empty in the response. In public networking mode, the value of VSwitches is empty in the response.
        
        @param request: DescribeEpnInstanceAttributeRequest
        @return: DescribeEpnInstanceAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_epn_instance_attribute_with_options(request, runtime)

    async def describe_epn_instance_attribute_async(
        self,
        request: ens_20171110_models.DescribeEpnInstanceAttributeRequest,
    ) -> ens_20171110_models.DescribeEpnInstanceAttributeResponse:
        """
        @summary Queries networking information about an EPN instance.
        
        @description In internal networking mode, the value of Instances is empty in the response. In public networking mode, the value of VSwitches is empty in the response.
        
        @param request: DescribeEpnInstanceAttributeRequest
        @return: DescribeEpnInstanceAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_epn_instance_attribute_with_options_async(request, runtime)

    def describe_epn_instances_with_options(
        self,
        request: ens_20171110_models.DescribeEpnInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeEpnInstancesResponse:
        """
        @summary Queries EPN instances.
        
        @param request: DescribeEpnInstancesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeEpnInstancesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.epninstance_id):
            query['EPNInstanceId'] = request.epninstance_id
        if not UtilClient.is_unset(request.epninstance_name):
            query['EPNInstanceName'] = request.epninstance_name
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEpnInstances',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeEpnInstancesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_epn_instances_with_options_async(
        self,
        request: ens_20171110_models.DescribeEpnInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeEpnInstancesResponse:
        """
        @summary Queries EPN instances.
        
        @param request: DescribeEpnInstancesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeEpnInstancesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.epninstance_id):
            query['EPNInstanceId'] = request.epninstance_id
        if not UtilClient.is_unset(request.epninstance_name):
            query['EPNInstanceName'] = request.epninstance_name
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEpnInstances',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeEpnInstancesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_epn_instances(
        self,
        request: ens_20171110_models.DescribeEpnInstancesRequest,
    ) -> ens_20171110_models.DescribeEpnInstancesResponse:
        """
        @summary Queries EPN instances.
        
        @param request: DescribeEpnInstancesRequest
        @return: DescribeEpnInstancesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_epn_instances_with_options(request, runtime)

    async def describe_epn_instances_async(
        self,
        request: ens_20171110_models.DescribeEpnInstancesRequest,
    ) -> ens_20171110_models.DescribeEpnInstancesResponse:
        """
        @summary Queries EPN instances.
        
        @param request: DescribeEpnInstancesRequest
        @return: DescribeEpnInstancesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_epn_instances_with_options_async(request, runtime)

    def describe_epn_measurement_data_with_options(
        self,
        request: ens_20171110_models.DescribeEpnMeasurementDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeEpnMeasurementDataResponse:
        """
        @summary Queries the metering data of the edge private network (EPN).
        
        @param request: DescribeEpnMeasurementDataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeEpnMeasurementDataResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_date):
            query['EndDate'] = request.end_date
        if not UtilClient.is_unset(request.start_date):
            query['StartDate'] = request.start_date
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEpnMeasurementData',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeEpnMeasurementDataResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_epn_measurement_data_with_options_async(
        self,
        request: ens_20171110_models.DescribeEpnMeasurementDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeEpnMeasurementDataResponse:
        """
        @summary Queries the metering data of the edge private network (EPN).
        
        @param request: DescribeEpnMeasurementDataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeEpnMeasurementDataResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_date):
            query['EndDate'] = request.end_date
        if not UtilClient.is_unset(request.start_date):
            query['StartDate'] = request.start_date
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEpnMeasurementData',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeEpnMeasurementDataResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_epn_measurement_data(
        self,
        request: ens_20171110_models.DescribeEpnMeasurementDataRequest,
    ) -> ens_20171110_models.DescribeEpnMeasurementDataResponse:
        """
        @summary Queries the metering data of the edge private network (EPN).
        
        @param request: DescribeEpnMeasurementDataRequest
        @return: DescribeEpnMeasurementDataResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_epn_measurement_data_with_options(request, runtime)

    async def describe_epn_measurement_data_async(
        self,
        request: ens_20171110_models.DescribeEpnMeasurementDataRequest,
    ) -> ens_20171110_models.DescribeEpnMeasurementDataResponse:
        """
        @summary Queries the metering data of the edge private network (EPN).
        
        @param request: DescribeEpnMeasurementDataRequest
        @return: DescribeEpnMeasurementDataResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_epn_measurement_data_with_options_async(request, runtime)

    def describe_export_image_info_with_options(
        self,
        request: ens_20171110_models.DescribeExportImageInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeExportImageInfoResponse:
        """
        @summary Queries the export result of an image.
        
        @description    You can call this operation to query information about all custom images in your account. The information include the image properties, image export status, and the Object Storage Service (OSS) download links.
        Empty strings are returned for images that are not exported.
        The download links may become invalid if you delete objects in OSS.
        
        @param request: DescribeExportImageInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeExportImageInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.image_name):
            query['ImageName'] = request.image_name
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeExportImageInfo',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeExportImageInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_export_image_info_with_options_async(
        self,
        request: ens_20171110_models.DescribeExportImageInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeExportImageInfoResponse:
        """
        @summary Queries the export result of an image.
        
        @description    You can call this operation to query information about all custom images in your account. The information include the image properties, image export status, and the Object Storage Service (OSS) download links.
        Empty strings are returned for images that are not exported.
        The download links may become invalid if you delete objects in OSS.
        
        @param request: DescribeExportImageInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeExportImageInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.image_name):
            query['ImageName'] = request.image_name
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeExportImageInfo',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeExportImageInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_export_image_info(
        self,
        request: ens_20171110_models.DescribeExportImageInfoRequest,
    ) -> ens_20171110_models.DescribeExportImageInfoResponse:
        """
        @summary Queries the export result of an image.
        
        @description    You can call this operation to query information about all custom images in your account. The information include the image properties, image export status, and the Object Storage Service (OSS) download links.
        Empty strings are returned for images that are not exported.
        The download links may become invalid if you delete objects in OSS.
        
        @param request: DescribeExportImageInfoRequest
        @return: DescribeExportImageInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_export_image_info_with_options(request, runtime)

    async def describe_export_image_info_async(
        self,
        request: ens_20171110_models.DescribeExportImageInfoRequest,
    ) -> ens_20171110_models.DescribeExportImageInfoResponse:
        """
        @summary Queries the export result of an image.
        
        @description    You can call this operation to query information about all custom images in your account. The information include the image properties, image export status, and the Object Storage Service (OSS) download links.
        Empty strings are returned for images that are not exported.
        The download links may become invalid if you delete objects in OSS.
        
        @param request: DescribeExportImageInfoRequest
        @return: DescribeExportImageInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_export_image_info_with_options_async(request, runtime)

    def describe_export_image_status_with_options(
        self,
        request: ens_20171110_models.DescribeExportImageStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeExportImageStatusResponse:
        """
        @summary Queries the export status of an image.
        
        @param request: DescribeExportImageStatusRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeExportImageStatusResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeExportImageStatus',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeExportImageStatusResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_export_image_status_with_options_async(
        self,
        request: ens_20171110_models.DescribeExportImageStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeExportImageStatusResponse:
        """
        @summary Queries the export status of an image.
        
        @param request: DescribeExportImageStatusRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeExportImageStatusResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeExportImageStatus',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeExportImageStatusResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_export_image_status(
        self,
        request: ens_20171110_models.DescribeExportImageStatusRequest,
    ) -> ens_20171110_models.DescribeExportImageStatusResponse:
        """
        @summary Queries the export status of an image.
        
        @param request: DescribeExportImageStatusRequest
        @return: DescribeExportImageStatusResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_export_image_status_with_options(request, runtime)

    async def describe_export_image_status_async(
        self,
        request: ens_20171110_models.DescribeExportImageStatusRequest,
    ) -> ens_20171110_models.DescribeExportImageStatusResponse:
        """
        @summary Queries the export status of an image.
        
        @param request: DescribeExportImageStatusRequest
        @return: DescribeExportImageStatusResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_export_image_status_with_options_async(request, runtime)

    def describe_file_systems_with_options(
        self,
        request: ens_20171110_models.DescribeFileSystemsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeFileSystemsResponse:
        """
        @summary Queries the information about file systems.
        
        @param request: DescribeFileSystemsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeFileSystemsResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeFileSystems',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeFileSystemsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_file_systems_with_options_async(
        self,
        request: ens_20171110_models.DescribeFileSystemsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeFileSystemsResponse:
        """
        @summary Queries the information about file systems.
        
        @param request: DescribeFileSystemsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeFileSystemsResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeFileSystems',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeFileSystemsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_file_systems(
        self,
        request: ens_20171110_models.DescribeFileSystemsRequest,
    ) -> ens_20171110_models.DescribeFileSystemsResponse:
        """
        @summary Queries the information about file systems.
        
        @param request: DescribeFileSystemsRequest
        @return: DescribeFileSystemsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_file_systems_with_options(request, runtime)

    async def describe_file_systems_async(
        self,
        request: ens_20171110_models.DescribeFileSystemsRequest,
    ) -> ens_20171110_models.DescribeFileSystemsResponse:
        """
        @summary Queries the information about file systems.
        
        @param request: DescribeFileSystemsRequest
        @return: DescribeFileSystemsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_file_systems_with_options_async(request, runtime)

    def describe_forward_table_entries_with_options(
        self,
        request: ens_20171110_models.DescribeForwardTableEntriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeForwardTableEntriesResponse:
        """
        @summary Queries Destination Network Address Translation (DNAT) entries that you created.
        
        @param request: DescribeForwardTableEntriesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeForwardTableEntriesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.external_ip):
            query['ExternalIp'] = request.external_ip
        if not UtilClient.is_unset(request.forward_entry_id):
            query['ForwardEntryId'] = request.forward_entry_id
        if not UtilClient.is_unset(request.forward_entry_name):
            query['ForwardEntryName'] = request.forward_entry_name
        if not UtilClient.is_unset(request.internal_ip):
            query['InternalIp'] = request.internal_ip
        if not UtilClient.is_unset(request.ip_protocol):
            query['IpProtocol'] = request.ip_protocol
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeForwardTableEntries',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeForwardTableEntriesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_forward_table_entries_with_options_async(
        self,
        request: ens_20171110_models.DescribeForwardTableEntriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeForwardTableEntriesResponse:
        """
        @summary Queries Destination Network Address Translation (DNAT) entries that you created.
        
        @param request: DescribeForwardTableEntriesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeForwardTableEntriesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.external_ip):
            query['ExternalIp'] = request.external_ip
        if not UtilClient.is_unset(request.forward_entry_id):
            query['ForwardEntryId'] = request.forward_entry_id
        if not UtilClient.is_unset(request.forward_entry_name):
            query['ForwardEntryName'] = request.forward_entry_name
        if not UtilClient.is_unset(request.internal_ip):
            query['InternalIp'] = request.internal_ip
        if not UtilClient.is_unset(request.ip_protocol):
            query['IpProtocol'] = request.ip_protocol
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeForwardTableEntries',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeForwardTableEntriesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_forward_table_entries(
        self,
        request: ens_20171110_models.DescribeForwardTableEntriesRequest,
    ) -> ens_20171110_models.DescribeForwardTableEntriesResponse:
        """
        @summary Queries Destination Network Address Translation (DNAT) entries that you created.
        
        @param request: DescribeForwardTableEntriesRequest
        @return: DescribeForwardTableEntriesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_forward_table_entries_with_options(request, runtime)

    async def describe_forward_table_entries_async(
        self,
        request: ens_20171110_models.DescribeForwardTableEntriesRequest,
    ) -> ens_20171110_models.DescribeForwardTableEntriesResponse:
        """
        @summary Queries Destination Network Address Translation (DNAT) entries that you created.
        
        @param request: DescribeForwardTableEntriesRequest
        @return: DescribeForwardTableEntriesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_forward_table_entries_with_options_async(request, runtime)

    def describe_ha_vips_with_options(
        self,
        request: ens_20171110_models.DescribeHaVipsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeHaVipsResponse:
        """
        @summary Queries high-availability virtual IP addresses (HAVIPs).
        
        @param request: DescribeHaVipsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeHaVipsResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeHaVips',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeHaVipsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ha_vips_with_options_async(
        self,
        request: ens_20171110_models.DescribeHaVipsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeHaVipsResponse:
        """
        @summary Queries high-availability virtual IP addresses (HAVIPs).
        
        @param request: DescribeHaVipsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeHaVipsResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeHaVips',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeHaVipsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ha_vips(
        self,
        request: ens_20171110_models.DescribeHaVipsRequest,
    ) -> ens_20171110_models.DescribeHaVipsResponse:
        """
        @summary Queries high-availability virtual IP addresses (HAVIPs).
        
        @param request: DescribeHaVipsRequest
        @return: DescribeHaVipsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_ha_vips_with_options(request, runtime)

    async def describe_ha_vips_async(
        self,
        request: ens_20171110_models.DescribeHaVipsRequest,
    ) -> ens_20171110_models.DescribeHaVipsResponse:
        """
        @summary Queries high-availability virtual IP addresses (HAVIPs).
        
        @param request: DescribeHaVipsRequest
        @return: DescribeHaVipsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_ha_vips_with_options_async(request, runtime)

    def describe_image_infos_with_options(
        self,
        request: ens_20171110_models.DescribeImageInfosRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeImageInfosResponse:
        """
        @summary Queries available images.
        
        @param request: DescribeImageInfosRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeImageInfosResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.os_type):
            query['OsType'] = request.os_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImageInfos',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeImageInfosResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_image_infos_with_options_async(
        self,
        request: ens_20171110_models.DescribeImageInfosRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeImageInfosResponse:
        """
        @summary Queries available images.
        
        @param request: DescribeImageInfosRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeImageInfosResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.os_type):
            query['OsType'] = request.os_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImageInfos',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeImageInfosResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_image_infos(
        self,
        request: ens_20171110_models.DescribeImageInfosRequest,
    ) -> ens_20171110_models.DescribeImageInfosResponse:
        """
        @summary Queries available images.
        
        @param request: DescribeImageInfosRequest
        @return: DescribeImageInfosResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_image_infos_with_options(request, runtime)

    async def describe_image_infos_async(
        self,
        request: ens_20171110_models.DescribeImageInfosRequest,
    ) -> ens_20171110_models.DescribeImageInfosResponse:
        """
        @summary Queries available images.
        
        @param request: DescribeImageInfosRequest
        @return: DescribeImageInfosResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_image_infos_with_options_async(request, runtime)

    def describe_image_share_permission_with_options(
        self,
        request: ens_20171110_models.DescribeImageSharePermissionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeImageSharePermissionResponse:
        """
        @summary Queries the accounts with which you share an image specified by the ImageId parameter.
        
        @param request: DescribeImageSharePermissionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeImageSharePermissionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.aliyun_id):
            query['AliyunId'] = request.aliyun_id
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImageSharePermission',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeImageSharePermissionResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_image_share_permission_with_options_async(
        self,
        request: ens_20171110_models.DescribeImageSharePermissionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeImageSharePermissionResponse:
        """
        @summary Queries the accounts with which you share an image specified by the ImageId parameter.
        
        @param request: DescribeImageSharePermissionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeImageSharePermissionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.aliyun_id):
            query['AliyunId'] = request.aliyun_id
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImageSharePermission',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeImageSharePermissionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_image_share_permission(
        self,
        request: ens_20171110_models.DescribeImageSharePermissionRequest,
    ) -> ens_20171110_models.DescribeImageSharePermissionResponse:
        """
        @summary Queries the accounts with which you share an image specified by the ImageId parameter.
        
        @param request: DescribeImageSharePermissionRequest
        @return: DescribeImageSharePermissionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_image_share_permission_with_options(request, runtime)

    async def describe_image_share_permission_async(
        self,
        request: ens_20171110_models.DescribeImageSharePermissionRequest,
    ) -> ens_20171110_models.DescribeImageSharePermissionResponse:
        """
        @summary Queries the accounts with which you share an image specified by the ImageId parameter.
        
        @param request: DescribeImageSharePermissionRequest
        @return: DescribeImageSharePermissionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_image_share_permission_with_options_async(request, runtime)

    def describe_images_with_options(
        self,
        request: ens_20171110_models.DescribeImagesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeImagesResponse:
        """
        @summary Queries available images.
        
        @param request: DescribeImagesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeImagesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.image_name):
            query['ImageName'] = request.image_name
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.snapshot_id):
            query['SnapshotId'] = request.snapshot_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImages',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeImagesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_images_with_options_async(
        self,
        request: ens_20171110_models.DescribeImagesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeImagesResponse:
        """
        @summary Queries available images.
        
        @param request: DescribeImagesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeImagesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.image_name):
            query['ImageName'] = request.image_name
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.snapshot_id):
            query['SnapshotId'] = request.snapshot_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImages',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeImagesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_images(
        self,
        request: ens_20171110_models.DescribeImagesRequest,
    ) -> ens_20171110_models.DescribeImagesResponse:
        """
        @summary Queries available images.
        
        @param request: DescribeImagesRequest
        @return: DescribeImagesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_images_with_options(request, runtime)

    async def describe_images_async(
        self,
        request: ens_20171110_models.DescribeImagesRequest,
    ) -> ens_20171110_models.DescribeImagesResponse:
        """
        @summary Queries available images.
        
        @param request: DescribeImagesRequest
        @return: DescribeImagesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_images_with_options_async(request, runtime)

    def describe_instance_auto_renew_attribute_with_options(
        self,
        request: ens_20171110_models.DescribeInstanceAutoRenewAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeInstanceAutoRenewAttributeResponse:
        """
        @summary You can call this operation to query whether auto-renewal is enabled for an instance.
        
        @param request: DescribeInstanceAutoRenewAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInstanceAutoRenewAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_ids):
            query['InstanceIds'] = request.instance_ids
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInstanceAutoRenewAttribute',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeInstanceAutoRenewAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_instance_auto_renew_attribute_with_options_async(
        self,
        request: ens_20171110_models.DescribeInstanceAutoRenewAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeInstanceAutoRenewAttributeResponse:
        """
        @summary You can call this operation to query whether auto-renewal is enabled for an instance.
        
        @param request: DescribeInstanceAutoRenewAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInstanceAutoRenewAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_ids):
            query['InstanceIds'] = request.instance_ids
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInstanceAutoRenewAttribute',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeInstanceAutoRenewAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_instance_auto_renew_attribute(
        self,
        request: ens_20171110_models.DescribeInstanceAutoRenewAttributeRequest,
    ) -> ens_20171110_models.DescribeInstanceAutoRenewAttributeResponse:
        """
        @summary You can call this operation to query whether auto-renewal is enabled for an instance.
        
        @param request: DescribeInstanceAutoRenewAttributeRequest
        @return: DescribeInstanceAutoRenewAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_instance_auto_renew_attribute_with_options(request, runtime)

    async def describe_instance_auto_renew_attribute_async(
        self,
        request: ens_20171110_models.DescribeInstanceAutoRenewAttributeRequest,
    ) -> ens_20171110_models.DescribeInstanceAutoRenewAttributeResponse:
        """
        @summary You can call this operation to query whether auto-renewal is enabled for an instance.
        
        @param request: DescribeInstanceAutoRenewAttributeRequest
        @return: DescribeInstanceAutoRenewAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_instance_auto_renew_attribute_with_options_async(request, runtime)

    def describe_instance_bandwidth_detail_with_options(
        self,
        request: ens_20171110_models.DescribeInstanceBandwidthDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeInstanceBandwidthDetailResponse:
        """
        @summary 查询实例5分钟粒度带宽明细
        
        @param request: DescribeInstanceBandwidthDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInstanceBandwidthDetailResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInstanceBandwidthDetail',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeInstanceBandwidthDetailResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_instance_bandwidth_detail_with_options_async(
        self,
        request: ens_20171110_models.DescribeInstanceBandwidthDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeInstanceBandwidthDetailResponse:
        """
        @summary 查询实例5分钟粒度带宽明细
        
        @param request: DescribeInstanceBandwidthDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInstanceBandwidthDetailResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInstanceBandwidthDetail',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeInstanceBandwidthDetailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_instance_bandwidth_detail(
        self,
        request: ens_20171110_models.DescribeInstanceBandwidthDetailRequest,
    ) -> ens_20171110_models.DescribeInstanceBandwidthDetailResponse:
        """
        @summary 查询实例5分钟粒度带宽明细
        
        @param request: DescribeInstanceBandwidthDetailRequest
        @return: DescribeInstanceBandwidthDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_instance_bandwidth_detail_with_options(request, runtime)

    async def describe_instance_bandwidth_detail_async(
        self,
        request: ens_20171110_models.DescribeInstanceBandwidthDetailRequest,
    ) -> ens_20171110_models.DescribeInstanceBandwidthDetailResponse:
        """
        @summary 查询实例5分钟粒度带宽明细
        
        @param request: DescribeInstanceBandwidthDetailRequest
        @return: DescribeInstanceBandwidthDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_instance_bandwidth_detail_with_options_async(request, runtime)

    def describe_instance_boot_configuration_with_options(
        self,
        request: ens_20171110_models.DescribeInstanceBootConfigurationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeInstanceBootConfigurationResponse:
        """
        @summary Queries the boot configuration of a heterogeneous PC Farm bare metal instance.
        
        @description Queries the boot configuration of a heterogeneous PC Farm bare metal instance.
        
        @param request: DescribeInstanceBootConfigurationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInstanceBootConfigurationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.boot_set):
            query['BootSet'] = request.boot_set
        if not UtilClient.is_unset(request.boot_type):
            query['BootType'] = request.boot_type
        if not UtilClient.is_unset(request.disk_set):
            query['DiskSet'] = request.disk_set
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInstanceBootConfiguration',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeInstanceBootConfigurationResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_instance_boot_configuration_with_options_async(
        self,
        request: ens_20171110_models.DescribeInstanceBootConfigurationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeInstanceBootConfigurationResponse:
        """
        @summary Queries the boot configuration of a heterogeneous PC Farm bare metal instance.
        
        @description Queries the boot configuration of a heterogeneous PC Farm bare metal instance.
        
        @param request: DescribeInstanceBootConfigurationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInstanceBootConfigurationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.boot_set):
            query['BootSet'] = request.boot_set
        if not UtilClient.is_unset(request.boot_type):
            query['BootType'] = request.boot_type
        if not UtilClient.is_unset(request.disk_set):
            query['DiskSet'] = request.disk_set
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInstanceBootConfiguration',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeInstanceBootConfigurationResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_instance_boot_configuration(
        self,
        request: ens_20171110_models.DescribeInstanceBootConfigurationRequest,
    ) -> ens_20171110_models.DescribeInstanceBootConfigurationResponse:
        """
        @summary Queries the boot configuration of a heterogeneous PC Farm bare metal instance.
        
        @description Queries the boot configuration of a heterogeneous PC Farm bare metal instance.
        
        @param request: DescribeInstanceBootConfigurationRequest
        @return: DescribeInstanceBootConfigurationResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_instance_boot_configuration_with_options(request, runtime)

    async def describe_instance_boot_configuration_async(
        self,
        request: ens_20171110_models.DescribeInstanceBootConfigurationRequest,
    ) -> ens_20171110_models.DescribeInstanceBootConfigurationResponse:
        """
        @summary Queries the boot configuration of a heterogeneous PC Farm bare metal instance.
        
        @description Queries the boot configuration of a heterogeneous PC Farm bare metal instance.
        
        @param request: DescribeInstanceBootConfigurationRequest
        @return: DescribeInstanceBootConfigurationResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_instance_boot_configuration_with_options_async(request, runtime)

    def describe_instance_monitor_data_with_options(
        self,
        request: ens_20171110_models.DescribeInstanceMonitorDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeInstanceMonitorDataResponse:
        """
        @summary Queries the vCPU and memory usage of an instance.
        
        @param request: DescribeInstanceMonitorDataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInstanceMonitorDataResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInstanceMonitorData',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeInstanceMonitorDataResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_instance_monitor_data_with_options_async(
        self,
        request: ens_20171110_models.DescribeInstanceMonitorDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeInstanceMonitorDataResponse:
        """
        @summary Queries the vCPU and memory usage of an instance.
        
        @param request: DescribeInstanceMonitorDataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInstanceMonitorDataResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInstanceMonitorData',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeInstanceMonitorDataResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_instance_monitor_data(
        self,
        request: ens_20171110_models.DescribeInstanceMonitorDataRequest,
    ) -> ens_20171110_models.DescribeInstanceMonitorDataResponse:
        """
        @summary Queries the vCPU and memory usage of an instance.
        
        @param request: DescribeInstanceMonitorDataRequest
        @return: DescribeInstanceMonitorDataResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_instance_monitor_data_with_options(request, runtime)

    async def describe_instance_monitor_data_async(
        self,
        request: ens_20171110_models.DescribeInstanceMonitorDataRequest,
    ) -> ens_20171110_models.DescribeInstanceMonitorDataResponse:
        """
        @summary Queries the vCPU and memory usage of an instance.
        
        @param request: DescribeInstanceMonitorDataRequest
        @return: DescribeInstanceMonitorDataResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_instance_monitor_data_with_options_async(request, runtime)

    def describe_instance_sdgstatus_with_options(
        self,
        tmp_req: ens_20171110_models.DescribeInstanceSDGStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeInstanceSDGStatusResponse:
        """
        @summary Queries shared data groups (SDGs) that are mounted to an Android in Container (AIC) instance.
        
        @param tmp_req: DescribeInstanceSDGStatusRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInstanceSDGStatusResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.DescribeInstanceSDGStatusShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.sdgids):
            request.sdgids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.sdgids, 'SDGIds', 'json')
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInstanceSDGStatus',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeInstanceSDGStatusResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_instance_sdgstatus_with_options_async(
        self,
        tmp_req: ens_20171110_models.DescribeInstanceSDGStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeInstanceSDGStatusResponse:
        """
        @summary Queries shared data groups (SDGs) that are mounted to an Android in Container (AIC) instance.
        
        @param tmp_req: DescribeInstanceSDGStatusRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInstanceSDGStatusResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.DescribeInstanceSDGStatusShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.sdgids):
            request.sdgids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.sdgids, 'SDGIds', 'json')
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInstanceSDGStatus',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeInstanceSDGStatusResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_instance_sdgstatus(
        self,
        request: ens_20171110_models.DescribeInstanceSDGStatusRequest,
    ) -> ens_20171110_models.DescribeInstanceSDGStatusResponse:
        """
        @summary Queries shared data groups (SDGs) that are mounted to an Android in Container (AIC) instance.
        
        @param request: DescribeInstanceSDGStatusRequest
        @return: DescribeInstanceSDGStatusResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_instance_sdgstatus_with_options(request, runtime)

    async def describe_instance_sdgstatus_async(
        self,
        request: ens_20171110_models.DescribeInstanceSDGStatusRequest,
    ) -> ens_20171110_models.DescribeInstanceSDGStatusResponse:
        """
        @summary Queries shared data groups (SDGs) that are mounted to an Android in Container (AIC) instance.
        
        @param request: DescribeInstanceSDGStatusRequest
        @return: DescribeInstanceSDGStatusResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_instance_sdgstatus_with_options_async(request, runtime)

    def describe_instance_spec_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeInstanceSpecResponse:
        """
        @summary Queries the instance specifications that you can purchase.
        
        @param request: DescribeInstanceSpecRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInstanceSpecResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeInstanceSpec',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeInstanceSpecResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_instance_spec_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeInstanceSpecResponse:
        """
        @summary Queries the instance specifications that you can purchase.
        
        @param request: DescribeInstanceSpecRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInstanceSpecResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeInstanceSpec',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeInstanceSpecResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_instance_spec(self) -> ens_20171110_models.DescribeInstanceSpecResponse:
        """
        @summary Queries the instance specifications that you can purchase.
        
        @return: DescribeInstanceSpecResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_instance_spec_with_options(runtime)

    async def describe_instance_spec_async(self) -> ens_20171110_models.DescribeInstanceSpecResponse:
        """
        @summary Queries the instance specifications that you can purchase.
        
        @return: DescribeInstanceSpecResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_instance_spec_with_options_async(runtime)

    def describe_instance_types_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeInstanceTypesResponse:
        """
        @summary Queries the specifications of instance types.
        
        @param request: DescribeInstanceTypesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInstanceTypesResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeInstanceTypes',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeInstanceTypesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_instance_types_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeInstanceTypesResponse:
        """
        @summary Queries the specifications of instance types.
        
        @param request: DescribeInstanceTypesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInstanceTypesResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeInstanceTypes',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeInstanceTypesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_instance_types(self) -> ens_20171110_models.DescribeInstanceTypesResponse:
        """
        @summary Queries the specifications of instance types.
        
        @return: DescribeInstanceTypesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_instance_types_with_options(runtime)

    async def describe_instance_types_async(self) -> ens_20171110_models.DescribeInstanceTypesResponse:
        """
        @summary Queries the specifications of instance types.
        
        @return: DescribeInstanceTypesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_instance_types_with_options_async(runtime)

    def describe_instance_vnc_url_with_options(
        self,
        request: ens_20171110_models.DescribeInstanceVncUrlRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeInstanceVncUrlResponse:
        """
        @summary Queries the Virtual Network Computing (VNC) URL of an Edge Node Service (ENS) instance.
        
        @param request: DescribeInstanceVncUrlRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInstanceVncUrlResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInstanceVncUrl',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeInstanceVncUrlResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_instance_vnc_url_with_options_async(
        self,
        request: ens_20171110_models.DescribeInstanceVncUrlRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeInstanceVncUrlResponse:
        """
        @summary Queries the Virtual Network Computing (VNC) URL of an Edge Node Service (ENS) instance.
        
        @param request: DescribeInstanceVncUrlRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInstanceVncUrlResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInstanceVncUrl',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeInstanceVncUrlResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_instance_vnc_url(
        self,
        request: ens_20171110_models.DescribeInstanceVncUrlRequest,
    ) -> ens_20171110_models.DescribeInstanceVncUrlResponse:
        """
        @summary Queries the Virtual Network Computing (VNC) URL of an Edge Node Service (ENS) instance.
        
        @param request: DescribeInstanceVncUrlRequest
        @return: DescribeInstanceVncUrlResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_instance_vnc_url_with_options(request, runtime)

    async def describe_instance_vnc_url_async(
        self,
        request: ens_20171110_models.DescribeInstanceVncUrlRequest,
    ) -> ens_20171110_models.DescribeInstanceVncUrlResponse:
        """
        @summary Queries the Virtual Network Computing (VNC) URL of an Edge Node Service (ENS) instance.
        
        @param request: DescribeInstanceVncUrlRequest
        @return: DescribeInstanceVncUrlResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_instance_vnc_url_with_options_async(request, runtime)

    def describe_instances_with_options(
        self,
        tmp_req: ens_20171110_models.DescribeInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeInstancesResponse:
        """
        @summary You can call this operation to view the details of one or more instances.
        
        @description    You can call this operation up to 800 times per second per account.
        You can call this operation up to 100 times per second per user.
        You can specify multiple request parameters to be queried. Specified parameters are evaluated by using the AND operator. Only the specified parameters are included in the filter conditions. However, if InstanceIds is set to an empty JSON array, it is regarded as a valid filter condition and an empty result is returned.
        
        @param tmp_req: DescribeInstancesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInstancesResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.DescribeInstancesShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.service_status):
            request.service_status_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.service_status, 'ServiceStatus', 'json')
        if not UtilClient.is_unset(tmp_req.tags):
            request.tags_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.tags, 'Tags', 'json')
        query = {}
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.ens_region_ids):
            query['EnsRegionIds'] = request.ens_region_ids
        if not UtilClient.is_unset(request.ens_service_id):
            query['EnsServiceId'] = request.ens_service_id
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instance_ids):
            query['InstanceIds'] = request.instance_ids
        if not UtilClient.is_unset(request.instance_name):
            query['InstanceName'] = request.instance_name
        if not UtilClient.is_unset(request.instance_resource_type):
            query['InstanceResourceType'] = request.instance_resource_type
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.intranet_ip):
            query['IntranetIp'] = request.intranet_ip
        if not UtilClient.is_unset(request.network_id):
            query['NetworkId'] = request.network_id
        if not UtilClient.is_unset(request.order_by_params):
            query['OrderByParams'] = request.order_by_params
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.search_key):
            query['SearchKey'] = request.search_key
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        if not UtilClient.is_unset(request.service_status_shrink):
            query['ServiceStatus'] = request.service_status_shrink
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.tags_shrink):
            query['Tags'] = request.tags_shrink
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInstances',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeInstancesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_instances_with_options_async(
        self,
        tmp_req: ens_20171110_models.DescribeInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeInstancesResponse:
        """
        @summary You can call this operation to view the details of one or more instances.
        
        @description    You can call this operation up to 800 times per second per account.
        You can call this operation up to 100 times per second per user.
        You can specify multiple request parameters to be queried. Specified parameters are evaluated by using the AND operator. Only the specified parameters are included in the filter conditions. However, if InstanceIds is set to an empty JSON array, it is regarded as a valid filter condition and an empty result is returned.
        
        @param tmp_req: DescribeInstancesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInstancesResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.DescribeInstancesShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.service_status):
            request.service_status_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.service_status, 'ServiceStatus', 'json')
        if not UtilClient.is_unset(tmp_req.tags):
            request.tags_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.tags, 'Tags', 'json')
        query = {}
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.ens_region_ids):
            query['EnsRegionIds'] = request.ens_region_ids
        if not UtilClient.is_unset(request.ens_service_id):
            query['EnsServiceId'] = request.ens_service_id
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instance_ids):
            query['InstanceIds'] = request.instance_ids
        if not UtilClient.is_unset(request.instance_name):
            query['InstanceName'] = request.instance_name
        if not UtilClient.is_unset(request.instance_resource_type):
            query['InstanceResourceType'] = request.instance_resource_type
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.intranet_ip):
            query['IntranetIp'] = request.intranet_ip
        if not UtilClient.is_unset(request.network_id):
            query['NetworkId'] = request.network_id
        if not UtilClient.is_unset(request.order_by_params):
            query['OrderByParams'] = request.order_by_params
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.search_key):
            query['SearchKey'] = request.search_key
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        if not UtilClient.is_unset(request.service_status_shrink):
            query['ServiceStatus'] = request.service_status_shrink
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.tags_shrink):
            query['Tags'] = request.tags_shrink
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInstances',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeInstancesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_instances(
        self,
        request: ens_20171110_models.DescribeInstancesRequest,
    ) -> ens_20171110_models.DescribeInstancesResponse:
        """
        @summary You can call this operation to view the details of one or more instances.
        
        @description    You can call this operation up to 800 times per second per account.
        You can call this operation up to 100 times per second per user.
        You can specify multiple request parameters to be queried. Specified parameters are evaluated by using the AND operator. Only the specified parameters are included in the filter conditions. However, if InstanceIds is set to an empty JSON array, it is regarded as a valid filter condition and an empty result is returned.
        
        @param request: DescribeInstancesRequest
        @return: DescribeInstancesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_instances_with_options(request, runtime)

    async def describe_instances_async(
        self,
        request: ens_20171110_models.DescribeInstancesRequest,
    ) -> ens_20171110_models.DescribeInstancesResponse:
        """
        @summary You can call this operation to view the details of one or more instances.
        
        @description    You can call this operation up to 800 times per second per account.
        You can call this operation up to 100 times per second per user.
        You can specify multiple request parameters to be queried. Specified parameters are evaluated by using the AND operator. Only the specified parameters are included in the filter conditions. However, if InstanceIds is set to an empty JSON array, it is regarded as a valid filter condition and an empty result is returned.
        
        @param request: DescribeInstancesRequest
        @return: DescribeInstancesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_instances_with_options_async(request, runtime)

    def describe_key_pairs_with_options(
        self,
        request: ens_20171110_models.DescribeKeyPairsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeKeyPairsResponse:
        """
        @summary Queries one or more key pairs.
        
        @param request: DescribeKeyPairsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeKeyPairsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.key_pair_id):
            query['KeyPairId'] = request.key_pair_id
        if not UtilClient.is_unset(request.key_pair_name):
            query['KeyPairName'] = request.key_pair_name
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeKeyPairs',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeKeyPairsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_key_pairs_with_options_async(
        self,
        request: ens_20171110_models.DescribeKeyPairsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeKeyPairsResponse:
        """
        @summary Queries one or more key pairs.
        
        @param request: DescribeKeyPairsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeKeyPairsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.key_pair_id):
            query['KeyPairId'] = request.key_pair_id
        if not UtilClient.is_unset(request.key_pair_name):
            query['KeyPairName'] = request.key_pair_name
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeKeyPairs',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeKeyPairsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_key_pairs(
        self,
        request: ens_20171110_models.DescribeKeyPairsRequest,
    ) -> ens_20171110_models.DescribeKeyPairsResponse:
        """
        @summary Queries one or more key pairs.
        
        @param request: DescribeKeyPairsRequest
        @return: DescribeKeyPairsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_key_pairs_with_options(request, runtime)

    async def describe_key_pairs_async(
        self,
        request: ens_20171110_models.DescribeKeyPairsRequest,
    ) -> ens_20171110_models.DescribeKeyPairsResponse:
        """
        @summary Queries one or more key pairs.
        
        @param request: DescribeKeyPairsRequest
        @return: DescribeKeyPairsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_key_pairs_with_options_async(request, runtime)

    def describe_load_balancer_attribute_with_options(
        self,
        request: ens_20171110_models.DescribeLoadBalancerAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeLoadBalancerAttributeResponse:
        """
        @summary Queries detailed information about an Edge Load Balancer (ELB) instance.
        
        @description    You can call this operation up to 100 times per second.
        You can call this operation up to 10 times per second per account.
        
        @param request: DescribeLoadBalancerAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeLoadBalancerAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.load_balancer_id):
            query['LoadBalancerId'] = request.load_balancer_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeLoadBalancerAttribute',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeLoadBalancerAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_load_balancer_attribute_with_options_async(
        self,
        request: ens_20171110_models.DescribeLoadBalancerAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeLoadBalancerAttributeResponse:
        """
        @summary Queries detailed information about an Edge Load Balancer (ELB) instance.
        
        @description    You can call this operation up to 100 times per second.
        You can call this operation up to 10 times per second per account.
        
        @param request: DescribeLoadBalancerAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeLoadBalancerAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.load_balancer_id):
            query['LoadBalancerId'] = request.load_balancer_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeLoadBalancerAttribute',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeLoadBalancerAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_load_balancer_attribute(
        self,
        request: ens_20171110_models.DescribeLoadBalancerAttributeRequest,
    ) -> ens_20171110_models.DescribeLoadBalancerAttributeResponse:
        """
        @summary Queries detailed information about an Edge Load Balancer (ELB) instance.
        
        @description    You can call this operation up to 100 times per second.
        You can call this operation up to 10 times per second per account.
        
        @param request: DescribeLoadBalancerAttributeRequest
        @return: DescribeLoadBalancerAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_load_balancer_attribute_with_options(request, runtime)

    async def describe_load_balancer_attribute_async(
        self,
        request: ens_20171110_models.DescribeLoadBalancerAttributeRequest,
    ) -> ens_20171110_models.DescribeLoadBalancerAttributeResponse:
        """
        @summary Queries detailed information about an Edge Load Balancer (ELB) instance.
        
        @description    You can call this operation up to 100 times per second.
        You can call this operation up to 10 times per second per account.
        
        @param request: DescribeLoadBalancerAttributeRequest
        @return: DescribeLoadBalancerAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_load_balancer_attribute_with_options_async(request, runtime)

    def describe_load_balancer_httplistener_attribute_with_options(
        self,
        request: ens_20171110_models.DescribeLoadBalancerHTTPListenerAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeLoadBalancerHTTPListenerAttributeResponse:
        """
        @summary Queries the configuration of an HTTP listener.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: DescribeLoadBalancerHTTPListenerAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeLoadBalancerHTTPListenerAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.listener_port):
            query['ListenerPort'] = request.listener_port
        if not UtilClient.is_unset(request.load_balancer_id):
            query['LoadBalancerId'] = request.load_balancer_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeLoadBalancerHTTPListenerAttribute',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeLoadBalancerHTTPListenerAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_load_balancer_httplistener_attribute_with_options_async(
        self,
        request: ens_20171110_models.DescribeLoadBalancerHTTPListenerAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeLoadBalancerHTTPListenerAttributeResponse:
        """
        @summary Queries the configuration of an HTTP listener.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: DescribeLoadBalancerHTTPListenerAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeLoadBalancerHTTPListenerAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.listener_port):
            query['ListenerPort'] = request.listener_port
        if not UtilClient.is_unset(request.load_balancer_id):
            query['LoadBalancerId'] = request.load_balancer_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeLoadBalancerHTTPListenerAttribute',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeLoadBalancerHTTPListenerAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_load_balancer_httplistener_attribute(
        self,
        request: ens_20171110_models.DescribeLoadBalancerHTTPListenerAttributeRequest,
    ) -> ens_20171110_models.DescribeLoadBalancerHTTPListenerAttributeResponse:
        """
        @summary Queries the configuration of an HTTP listener.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: DescribeLoadBalancerHTTPListenerAttributeRequest
        @return: DescribeLoadBalancerHTTPListenerAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_load_balancer_httplistener_attribute_with_options(request, runtime)

    async def describe_load_balancer_httplistener_attribute_async(
        self,
        request: ens_20171110_models.DescribeLoadBalancerHTTPListenerAttributeRequest,
    ) -> ens_20171110_models.DescribeLoadBalancerHTTPListenerAttributeResponse:
        """
        @summary Queries the configuration of an HTTP listener.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: DescribeLoadBalancerHTTPListenerAttributeRequest
        @return: DescribeLoadBalancerHTTPListenerAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_load_balancer_httplistener_attribute_with_options_async(request, runtime)

    def describe_load_balancer_httpslistener_attribute_with_options(
        self,
        request: ens_20171110_models.DescribeLoadBalancerHTTPSListenerAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeLoadBalancerHTTPSListenerAttributeResponse:
        """
        @summary Queries the configurations of an HTTPS listener.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: DescribeLoadBalancerHTTPSListenerAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeLoadBalancerHTTPSListenerAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.listener_port):
            query['ListenerPort'] = request.listener_port
        if not UtilClient.is_unset(request.load_balancer_id):
            query['LoadBalancerId'] = request.load_balancer_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeLoadBalancerHTTPSListenerAttribute',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeLoadBalancerHTTPSListenerAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_load_balancer_httpslistener_attribute_with_options_async(
        self,
        request: ens_20171110_models.DescribeLoadBalancerHTTPSListenerAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeLoadBalancerHTTPSListenerAttributeResponse:
        """
        @summary Queries the configurations of an HTTPS listener.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: DescribeLoadBalancerHTTPSListenerAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeLoadBalancerHTTPSListenerAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.listener_port):
            query['ListenerPort'] = request.listener_port
        if not UtilClient.is_unset(request.load_balancer_id):
            query['LoadBalancerId'] = request.load_balancer_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeLoadBalancerHTTPSListenerAttribute',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeLoadBalancerHTTPSListenerAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_load_balancer_httpslistener_attribute(
        self,
        request: ens_20171110_models.DescribeLoadBalancerHTTPSListenerAttributeRequest,
    ) -> ens_20171110_models.DescribeLoadBalancerHTTPSListenerAttributeResponse:
        """
        @summary Queries the configurations of an HTTPS listener.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: DescribeLoadBalancerHTTPSListenerAttributeRequest
        @return: DescribeLoadBalancerHTTPSListenerAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_load_balancer_httpslistener_attribute_with_options(request, runtime)

    async def describe_load_balancer_httpslistener_attribute_async(
        self,
        request: ens_20171110_models.DescribeLoadBalancerHTTPSListenerAttributeRequest,
    ) -> ens_20171110_models.DescribeLoadBalancerHTTPSListenerAttributeResponse:
        """
        @summary Queries the configurations of an HTTPS listener.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: DescribeLoadBalancerHTTPSListenerAttributeRequest
        @return: DescribeLoadBalancerHTTPSListenerAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_load_balancer_httpslistener_attribute_with_options_async(request, runtime)

    def describe_load_balancer_listen_monitor_with_options(
        self,
        request: ens_20171110_models.DescribeLoadBalancerListenMonitorRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeLoadBalancerListenMonitorResponse:
        """
        @summary Queries monitoring data of an edge load balancer (ELB) instance.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: DescribeLoadBalancerListenMonitorRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeLoadBalancerListenMonitorResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeLoadBalancerListenMonitor',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeLoadBalancerListenMonitorResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_load_balancer_listen_monitor_with_options_async(
        self,
        request: ens_20171110_models.DescribeLoadBalancerListenMonitorRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeLoadBalancerListenMonitorResponse:
        """
        @summary Queries monitoring data of an edge load balancer (ELB) instance.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: DescribeLoadBalancerListenMonitorRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeLoadBalancerListenMonitorResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeLoadBalancerListenMonitor',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeLoadBalancerListenMonitorResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_load_balancer_listen_monitor(
        self,
        request: ens_20171110_models.DescribeLoadBalancerListenMonitorRequest,
    ) -> ens_20171110_models.DescribeLoadBalancerListenMonitorResponse:
        """
        @summary Queries monitoring data of an edge load balancer (ELB) instance.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: DescribeLoadBalancerListenMonitorRequest
        @return: DescribeLoadBalancerListenMonitorResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_load_balancer_listen_monitor_with_options(request, runtime)

    async def describe_load_balancer_listen_monitor_async(
        self,
        request: ens_20171110_models.DescribeLoadBalancerListenMonitorRequest,
    ) -> ens_20171110_models.DescribeLoadBalancerListenMonitorResponse:
        """
        @summary Queries monitoring data of an edge load balancer (ELB) instance.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: DescribeLoadBalancerListenMonitorRequest
        @return: DescribeLoadBalancerListenMonitorResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_load_balancer_listen_monitor_with_options_async(request, runtime)

    def describe_load_balancer_listeners_with_options(
        self,
        request: ens_20171110_models.DescribeLoadBalancerListenersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeLoadBalancerListenersResponse:
        """
        @summary Queries listeners of Edge Load Balancer (ELB) instances.
        
        @param request: DescribeLoadBalancerListenersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeLoadBalancerListenersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.listener_port):
            query['ListenerPort'] = request.listener_port
        if not UtilClient.is_unset(request.load_balancer_id):
            query['LoadBalancerId'] = request.load_balancer_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeLoadBalancerListeners',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeLoadBalancerListenersResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_load_balancer_listeners_with_options_async(
        self,
        request: ens_20171110_models.DescribeLoadBalancerListenersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeLoadBalancerListenersResponse:
        """
        @summary Queries listeners of Edge Load Balancer (ELB) instances.
        
        @param request: DescribeLoadBalancerListenersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeLoadBalancerListenersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.listener_port):
            query['ListenerPort'] = request.listener_port
        if not UtilClient.is_unset(request.load_balancer_id):
            query['LoadBalancerId'] = request.load_balancer_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeLoadBalancerListeners',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeLoadBalancerListenersResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_load_balancer_listeners(
        self,
        request: ens_20171110_models.DescribeLoadBalancerListenersRequest,
    ) -> ens_20171110_models.DescribeLoadBalancerListenersResponse:
        """
        @summary Queries listeners of Edge Load Balancer (ELB) instances.
        
        @param request: DescribeLoadBalancerListenersRequest
        @return: DescribeLoadBalancerListenersResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_load_balancer_listeners_with_options(request, runtime)

    async def describe_load_balancer_listeners_async(
        self,
        request: ens_20171110_models.DescribeLoadBalancerListenersRequest,
    ) -> ens_20171110_models.DescribeLoadBalancerListenersResponse:
        """
        @summary Queries listeners of Edge Load Balancer (ELB) instances.
        
        @param request: DescribeLoadBalancerListenersRequest
        @return: DescribeLoadBalancerListenersResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_load_balancer_listeners_with_options_async(request, runtime)

    def describe_load_balancer_spec_with_options(
        self,
        request: ens_20171110_models.DescribeLoadBalancerSpecRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeLoadBalancerSpecResponse:
        """
        @summary Queries the specifications of an Edge Load Balancer (ELB) instance.
        
        @param request: DescribeLoadBalancerSpecRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeLoadBalancerSpecResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeLoadBalancerSpec',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeLoadBalancerSpecResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_load_balancer_spec_with_options_async(
        self,
        request: ens_20171110_models.DescribeLoadBalancerSpecRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeLoadBalancerSpecResponse:
        """
        @summary Queries the specifications of an Edge Load Balancer (ELB) instance.
        
        @param request: DescribeLoadBalancerSpecRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeLoadBalancerSpecResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeLoadBalancerSpec',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeLoadBalancerSpecResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_load_balancer_spec(
        self,
        request: ens_20171110_models.DescribeLoadBalancerSpecRequest,
    ) -> ens_20171110_models.DescribeLoadBalancerSpecResponse:
        """
        @summary Queries the specifications of an Edge Load Balancer (ELB) instance.
        
        @param request: DescribeLoadBalancerSpecRequest
        @return: DescribeLoadBalancerSpecResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_load_balancer_spec_with_options(request, runtime)

    async def describe_load_balancer_spec_async(
        self,
        request: ens_20171110_models.DescribeLoadBalancerSpecRequest,
    ) -> ens_20171110_models.DescribeLoadBalancerSpecResponse:
        """
        @summary Queries the specifications of an Edge Load Balancer (ELB) instance.
        
        @param request: DescribeLoadBalancerSpecRequest
        @return: DescribeLoadBalancerSpecResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_load_balancer_spec_with_options_async(request, runtime)

    def describe_load_balancer_tcplistener_attribute_with_options(
        self,
        request: ens_20171110_models.DescribeLoadBalancerTCPListenerAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeLoadBalancerTCPListenerAttributeResponse:
        """
        @summary Queries the configurations of a Transmission Control Protocol (TCP) listener.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: DescribeLoadBalancerTCPListenerAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeLoadBalancerTCPListenerAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.listener_port):
            query['ListenerPort'] = request.listener_port
        if not UtilClient.is_unset(request.load_balancer_id):
            query['LoadBalancerId'] = request.load_balancer_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeLoadBalancerTCPListenerAttribute',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeLoadBalancerTCPListenerAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_load_balancer_tcplistener_attribute_with_options_async(
        self,
        request: ens_20171110_models.DescribeLoadBalancerTCPListenerAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeLoadBalancerTCPListenerAttributeResponse:
        """
        @summary Queries the configurations of a Transmission Control Protocol (TCP) listener.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: DescribeLoadBalancerTCPListenerAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeLoadBalancerTCPListenerAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.listener_port):
            query['ListenerPort'] = request.listener_port
        if not UtilClient.is_unset(request.load_balancer_id):
            query['LoadBalancerId'] = request.load_balancer_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeLoadBalancerTCPListenerAttribute',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeLoadBalancerTCPListenerAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_load_balancer_tcplistener_attribute(
        self,
        request: ens_20171110_models.DescribeLoadBalancerTCPListenerAttributeRequest,
    ) -> ens_20171110_models.DescribeLoadBalancerTCPListenerAttributeResponse:
        """
        @summary Queries the configurations of a Transmission Control Protocol (TCP) listener.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: DescribeLoadBalancerTCPListenerAttributeRequest
        @return: DescribeLoadBalancerTCPListenerAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_load_balancer_tcplistener_attribute_with_options(request, runtime)

    async def describe_load_balancer_tcplistener_attribute_async(
        self,
        request: ens_20171110_models.DescribeLoadBalancerTCPListenerAttributeRequest,
    ) -> ens_20171110_models.DescribeLoadBalancerTCPListenerAttributeResponse:
        """
        @summary Queries the configurations of a Transmission Control Protocol (TCP) listener.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: DescribeLoadBalancerTCPListenerAttributeRequest
        @return: DescribeLoadBalancerTCPListenerAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_load_balancer_tcplistener_attribute_with_options_async(request, runtime)

    def describe_load_balancer_udplistener_attribute_with_options(
        self,
        request: ens_20171110_models.DescribeLoadBalancerUDPListenerAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeLoadBalancerUDPListenerAttributeResponse:
        """
        @summary Queries the configuration of a User Datagram Protocol (UDP) listener.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: DescribeLoadBalancerUDPListenerAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeLoadBalancerUDPListenerAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.listener_port):
            query['ListenerPort'] = request.listener_port
        if not UtilClient.is_unset(request.load_balancer_id):
            query['LoadBalancerId'] = request.load_balancer_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeLoadBalancerUDPListenerAttribute',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeLoadBalancerUDPListenerAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_load_balancer_udplistener_attribute_with_options_async(
        self,
        request: ens_20171110_models.DescribeLoadBalancerUDPListenerAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeLoadBalancerUDPListenerAttributeResponse:
        """
        @summary Queries the configuration of a User Datagram Protocol (UDP) listener.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: DescribeLoadBalancerUDPListenerAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeLoadBalancerUDPListenerAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.listener_port):
            query['ListenerPort'] = request.listener_port
        if not UtilClient.is_unset(request.load_balancer_id):
            query['LoadBalancerId'] = request.load_balancer_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeLoadBalancerUDPListenerAttribute',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeLoadBalancerUDPListenerAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_load_balancer_udplistener_attribute(
        self,
        request: ens_20171110_models.DescribeLoadBalancerUDPListenerAttributeRequest,
    ) -> ens_20171110_models.DescribeLoadBalancerUDPListenerAttributeResponse:
        """
        @summary Queries the configuration of a User Datagram Protocol (UDP) listener.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: DescribeLoadBalancerUDPListenerAttributeRequest
        @return: DescribeLoadBalancerUDPListenerAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_load_balancer_udplistener_attribute_with_options(request, runtime)

    async def describe_load_balancer_udplistener_attribute_async(
        self,
        request: ens_20171110_models.DescribeLoadBalancerUDPListenerAttributeRequest,
    ) -> ens_20171110_models.DescribeLoadBalancerUDPListenerAttributeResponse:
        """
        @summary Queries the configuration of a User Datagram Protocol (UDP) listener.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: DescribeLoadBalancerUDPListenerAttributeRequest
        @return: DescribeLoadBalancerUDPListenerAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_load_balancer_udplistener_attribute_with_options_async(request, runtime)

    def describe_load_balancers_with_options(
        self,
        request: ens_20171110_models.DescribeLoadBalancersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeLoadBalancersResponse:
        """
        @summary Queries the Edge Load Balance (ELB) instances that you have created.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: DescribeLoadBalancersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeLoadBalancersResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeLoadBalancers',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeLoadBalancersResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_load_balancers_with_options_async(
        self,
        request: ens_20171110_models.DescribeLoadBalancersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeLoadBalancersResponse:
        """
        @summary Queries the Edge Load Balance (ELB) instances that you have created.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: DescribeLoadBalancersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeLoadBalancersResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeLoadBalancers',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeLoadBalancersResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_load_balancers(
        self,
        request: ens_20171110_models.DescribeLoadBalancersRequest,
    ) -> ens_20171110_models.DescribeLoadBalancersResponse:
        """
        @summary Queries the Edge Load Balance (ELB) instances that you have created.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: DescribeLoadBalancersRequest
        @return: DescribeLoadBalancersResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_load_balancers_with_options(request, runtime)

    async def describe_load_balancers_async(
        self,
        request: ens_20171110_models.DescribeLoadBalancersRequest,
    ) -> ens_20171110_models.DescribeLoadBalancersResponse:
        """
        @summary Queries the Edge Load Balance (ELB) instances that you have created.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: DescribeLoadBalancersRequest
        @return: DescribeLoadBalancersResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_load_balancers_with_options_async(request, runtime)

    def describe_measurement_data_with_options(
        self,
        request: ens_20171110_models.DescribeMeasurementDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeMeasurementDataResponse:
        """
        @summary Queries the metering data of the user.
        
        @param request: DescribeMeasurementDataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeMeasurementDataResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_date):
            query['EndDate'] = request.end_date
        if not UtilClient.is_unset(request.start_date):
            query['StartDate'] = request.start_date
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeMeasurementData',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeMeasurementDataResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_measurement_data_with_options_async(
        self,
        request: ens_20171110_models.DescribeMeasurementDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeMeasurementDataResponse:
        """
        @summary Queries the metering data of the user.
        
        @param request: DescribeMeasurementDataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeMeasurementDataResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_date):
            query['EndDate'] = request.end_date
        if not UtilClient.is_unset(request.start_date):
            query['StartDate'] = request.start_date
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeMeasurementData',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeMeasurementDataResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_measurement_data(
        self,
        request: ens_20171110_models.DescribeMeasurementDataRequest,
    ) -> ens_20171110_models.DescribeMeasurementDataResponse:
        """
        @summary Queries the metering data of the user.
        
        @param request: DescribeMeasurementDataRequest
        @return: DescribeMeasurementDataResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_measurement_data_with_options(request, runtime)

    async def describe_measurement_data_async(
        self,
        request: ens_20171110_models.DescribeMeasurementDataRequest,
    ) -> ens_20171110_models.DescribeMeasurementDataResponse:
        """
        @summary Queries the metering data of the user.
        
        @param request: DescribeMeasurementDataRequest
        @return: DescribeMeasurementDataResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_measurement_data_with_options_async(request, runtime)

    def describe_mount_targets_with_options(
        self,
        request: ens_20171110_models.DescribeMountTargetsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeMountTargetsResponse:
        """
        @summary Queries the information about mount targets.
        
        @param request: DescribeMountTargetsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeMountTargetsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.file_system_id):
            query['FileSystemId'] = request.file_system_id
        if not UtilClient.is_unset(request.mount_target_name):
            query['MountTargetName'] = request.mount_target_name
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeMountTargets',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeMountTargetsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_mount_targets_with_options_async(
        self,
        request: ens_20171110_models.DescribeMountTargetsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeMountTargetsResponse:
        """
        @summary Queries the information about mount targets.
        
        @param request: DescribeMountTargetsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeMountTargetsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.file_system_id):
            query['FileSystemId'] = request.file_system_id
        if not UtilClient.is_unset(request.mount_target_name):
            query['MountTargetName'] = request.mount_target_name
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeMountTargets',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeMountTargetsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_mount_targets(
        self,
        request: ens_20171110_models.DescribeMountTargetsRequest,
    ) -> ens_20171110_models.DescribeMountTargetsResponse:
        """
        @summary Queries the information about mount targets.
        
        @param request: DescribeMountTargetsRequest
        @return: DescribeMountTargetsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_mount_targets_with_options(request, runtime)

    async def describe_mount_targets_async(
        self,
        request: ens_20171110_models.DescribeMountTargetsRequest,
    ) -> ens_20171110_models.DescribeMountTargetsResponse:
        """
        @summary Queries the information about mount targets.
        
        @param request: DescribeMountTargetsRequest
        @return: DescribeMountTargetsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_mount_targets_with_options_async(request, runtime)

    def describe_nasavailable_resource_info_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeNASAvailableResourceInfoResponse:
        """
        @summary 输出指定用户ID下可用资源对应的nas信息
        
        @param request: DescribeNASAvailableResourceInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNASAvailableResourceInfoResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeNASAvailableResourceInfo',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeNASAvailableResourceInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_nasavailable_resource_info_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeNASAvailableResourceInfoResponse:
        """
        @summary 输出指定用户ID下可用资源对应的nas信息
        
        @param request: DescribeNASAvailableResourceInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNASAvailableResourceInfoResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeNASAvailableResourceInfo',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeNASAvailableResourceInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_nasavailable_resource_info(self) -> ens_20171110_models.DescribeNASAvailableResourceInfoResponse:
        """
        @summary 输出指定用户ID下可用资源对应的nas信息
        
        @return: DescribeNASAvailableResourceInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_nasavailable_resource_info_with_options(runtime)

    async def describe_nasavailable_resource_info_async(self) -> ens_20171110_models.DescribeNASAvailableResourceInfoResponse:
        """
        @summary 输出指定用户ID下可用资源对应的nas信息
        
        @return: DescribeNASAvailableResourceInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_nasavailable_resource_info_with_options_async(runtime)

    def describe_ncinformation_with_options(
        self,
        request: ens_20171110_models.DescribeNCInformationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeNCInformationResponse:
        """
        @summary 根据筛选条件获取指定NC属性和资源量信息
        
        @param request: DescribeNCInformationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNCInformationResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNCInformation',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeNCInformationResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ncinformation_with_options_async(
        self,
        request: ens_20171110_models.DescribeNCInformationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeNCInformationResponse:
        """
        @summary 根据筛选条件获取指定NC属性和资源量信息
        
        @param request: DescribeNCInformationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNCInformationResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNCInformation',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeNCInformationResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ncinformation(
        self,
        request: ens_20171110_models.DescribeNCInformationRequest,
    ) -> ens_20171110_models.DescribeNCInformationResponse:
        """
        @summary 根据筛选条件获取指定NC属性和资源量信息
        
        @param request: DescribeNCInformationRequest
        @return: DescribeNCInformationResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_ncinformation_with_options(request, runtime)

    async def describe_ncinformation_async(
        self,
        request: ens_20171110_models.DescribeNCInformationRequest,
    ) -> ens_20171110_models.DescribeNCInformationResponse:
        """
        @summary 根据筛选条件获取指定NC属性和资源量信息
        
        @param request: DescribeNCInformationRequest
        @return: DescribeNCInformationResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_ncinformation_with_options_async(request, runtime)

    def describe_nat_gateways_with_options(
        self,
        request: ens_20171110_models.DescribeNatGatewaysRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeNatGatewaysResponse:
        """
        @summary Queries created Network Address Translation (NAT) gateways.
        
        @param request: DescribeNatGatewaysRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNatGatewaysResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNatGateways',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeNatGatewaysResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_nat_gateways_with_options_async(
        self,
        request: ens_20171110_models.DescribeNatGatewaysRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeNatGatewaysResponse:
        """
        @summary Queries created Network Address Translation (NAT) gateways.
        
        @param request: DescribeNatGatewaysRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNatGatewaysResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNatGateways',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeNatGatewaysResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_nat_gateways(
        self,
        request: ens_20171110_models.DescribeNatGatewaysRequest,
    ) -> ens_20171110_models.DescribeNatGatewaysResponse:
        """
        @summary Queries created Network Address Translation (NAT) gateways.
        
        @param request: DescribeNatGatewaysRequest
        @return: DescribeNatGatewaysResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_nat_gateways_with_options(request, runtime)

    async def describe_nat_gateways_async(
        self,
        request: ens_20171110_models.DescribeNatGatewaysRequest,
    ) -> ens_20171110_models.DescribeNatGatewaysResponse:
        """
        @summary Queries created Network Address Translation (NAT) gateways.
        
        @param request: DescribeNatGatewaysRequest
        @return: DescribeNatGatewaysResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_nat_gateways_with_options_async(request, runtime)

    def describe_network_acls_with_options(
        self,
        request: ens_20171110_models.DescribeNetworkAclsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeNetworkAclsResponse:
        """
        @summary Queries network access control lists (ACLs).
        
        @param request: DescribeNetworkAclsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNetworkAclsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.network_acl_id):
            query['NetworkAclId'] = request.network_acl_id
        if not UtilClient.is_unset(request.network_acl_name):
            query['NetworkAclName'] = request.network_acl_name
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNetworkAcls',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeNetworkAclsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_network_acls_with_options_async(
        self,
        request: ens_20171110_models.DescribeNetworkAclsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeNetworkAclsResponse:
        """
        @summary Queries network access control lists (ACLs).
        
        @param request: DescribeNetworkAclsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNetworkAclsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.network_acl_id):
            query['NetworkAclId'] = request.network_acl_id
        if not UtilClient.is_unset(request.network_acl_name):
            query['NetworkAclName'] = request.network_acl_name
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNetworkAcls',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeNetworkAclsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_network_acls(
        self,
        request: ens_20171110_models.DescribeNetworkAclsRequest,
    ) -> ens_20171110_models.DescribeNetworkAclsResponse:
        """
        @summary Queries network access control lists (ACLs).
        
        @param request: DescribeNetworkAclsRequest
        @return: DescribeNetworkAclsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_network_acls_with_options(request, runtime)

    async def describe_network_acls_async(
        self,
        request: ens_20171110_models.DescribeNetworkAclsRequest,
    ) -> ens_20171110_models.DescribeNetworkAclsResponse:
        """
        @summary Queries network access control lists (ACLs).
        
        @param request: DescribeNetworkAclsRequest
        @return: DescribeNetworkAclsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_network_acls_with_options_async(request, runtime)

    def describe_network_attribute_with_options(
        self,
        request: ens_20171110_models.DescribeNetworkAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeNetworkAttributeResponse:
        """
        @summary Queries the configuration of a specified network.
        
        @description    You can call this operation up to 100 times per second.
        You can call this operation up to 10 times per second per account.
        
        @param request: DescribeNetworkAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNetworkAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.network_id):
            query['NetworkId'] = request.network_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNetworkAttribute',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeNetworkAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_network_attribute_with_options_async(
        self,
        request: ens_20171110_models.DescribeNetworkAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeNetworkAttributeResponse:
        """
        @summary Queries the configuration of a specified network.
        
        @description    You can call this operation up to 100 times per second.
        You can call this operation up to 10 times per second per account.
        
        @param request: DescribeNetworkAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNetworkAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.network_id):
            query['NetworkId'] = request.network_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNetworkAttribute',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeNetworkAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_network_attribute(
        self,
        request: ens_20171110_models.DescribeNetworkAttributeRequest,
    ) -> ens_20171110_models.DescribeNetworkAttributeResponse:
        """
        @summary Queries the configuration of a specified network.
        
        @description    You can call this operation up to 100 times per second.
        You can call this operation up to 10 times per second per account.
        
        @param request: DescribeNetworkAttributeRequest
        @return: DescribeNetworkAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_network_attribute_with_options(request, runtime)

    async def describe_network_attribute_async(
        self,
        request: ens_20171110_models.DescribeNetworkAttributeRequest,
    ) -> ens_20171110_models.DescribeNetworkAttributeResponse:
        """
        @summary Queries the configuration of a specified network.
        
        @description    You can call this operation up to 100 times per second.
        You can call this operation up to 10 times per second per account.
        
        @param request: DescribeNetworkAttributeRequest
        @return: DescribeNetworkAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_network_attribute_with_options_async(request, runtime)

    def describe_network_interfaces_with_options(
        self,
        request: ens_20171110_models.DescribeNetworkInterfacesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeNetworkInterfacesResponse:
        """
        @summary Queries Elastic Network Interfaces (ENIs).
        
        @param request: DescribeNetworkInterfacesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNetworkInterfacesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.ens_region_ids):
            query['EnsRegionIds'] = request.ens_region_ids
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.ipv_6address):
            query['Ipv6Address'] = request.ipv_6address
        if not UtilClient.is_unset(request.network_id):
            query['NetworkId'] = request.network_id
        if not UtilClient.is_unset(request.network_interface_id):
            query['NetworkInterfaceId'] = request.network_interface_id
        if not UtilClient.is_unset(request.network_interface_ids):
            query['NetworkInterfaceIds'] = request.network_interface_ids
        if not UtilClient.is_unset(request.network_interface_name):
            query['NetworkInterfaceName'] = request.network_interface_name
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.primary_ip_address):
            query['PrimaryIpAddress'] = request.primary_ip_address
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNetworkInterfaces',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeNetworkInterfacesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_network_interfaces_with_options_async(
        self,
        request: ens_20171110_models.DescribeNetworkInterfacesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeNetworkInterfacesResponse:
        """
        @summary Queries Elastic Network Interfaces (ENIs).
        
        @param request: DescribeNetworkInterfacesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNetworkInterfacesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.ens_region_ids):
            query['EnsRegionIds'] = request.ens_region_ids
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.ipv_6address):
            query['Ipv6Address'] = request.ipv_6address
        if not UtilClient.is_unset(request.network_id):
            query['NetworkId'] = request.network_id
        if not UtilClient.is_unset(request.network_interface_id):
            query['NetworkInterfaceId'] = request.network_interface_id
        if not UtilClient.is_unset(request.network_interface_ids):
            query['NetworkInterfaceIds'] = request.network_interface_ids
        if not UtilClient.is_unset(request.network_interface_name):
            query['NetworkInterfaceName'] = request.network_interface_name
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.primary_ip_address):
            query['PrimaryIpAddress'] = request.primary_ip_address
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNetworkInterfaces',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeNetworkInterfacesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_network_interfaces(
        self,
        request: ens_20171110_models.DescribeNetworkInterfacesRequest,
    ) -> ens_20171110_models.DescribeNetworkInterfacesResponse:
        """
        @summary Queries Elastic Network Interfaces (ENIs).
        
        @param request: DescribeNetworkInterfacesRequest
        @return: DescribeNetworkInterfacesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_network_interfaces_with_options(request, runtime)

    async def describe_network_interfaces_async(
        self,
        request: ens_20171110_models.DescribeNetworkInterfacesRequest,
    ) -> ens_20171110_models.DescribeNetworkInterfacesResponse:
        """
        @summary Queries Elastic Network Interfaces (ENIs).
        
        @param request: DescribeNetworkInterfacesRequest
        @return: DescribeNetworkInterfacesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_network_interfaces_with_options_async(request, runtime)

    def describe_networks_with_options(
        self,
        request: ens_20171110_models.DescribeNetworksRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeNetworksResponse:
        """
        @summary Query the network list.
        
        @description    You can call this operation up to 100 times per second.
        You can call this operation up to 10 times per second per account.
        
        @param request: DescribeNetworksRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNetworksResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.ens_region_ids):
            query['EnsRegionIds'] = request.ens_region_ids
        if not UtilClient.is_unset(request.network_id):
            query['NetworkId'] = request.network_id
        if not UtilClient.is_unset(request.network_ids):
            query['NetworkIds'] = request.network_ids
        if not UtilClient.is_unset(request.network_name):
            query['NetworkName'] = request.network_name
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNetworks',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeNetworksResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_networks_with_options_async(
        self,
        request: ens_20171110_models.DescribeNetworksRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeNetworksResponse:
        """
        @summary Query the network list.
        
        @description    You can call this operation up to 100 times per second.
        You can call this operation up to 10 times per second per account.
        
        @param request: DescribeNetworksRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNetworksResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.ens_region_ids):
            query['EnsRegionIds'] = request.ens_region_ids
        if not UtilClient.is_unset(request.network_id):
            query['NetworkId'] = request.network_id
        if not UtilClient.is_unset(request.network_ids):
            query['NetworkIds'] = request.network_ids
        if not UtilClient.is_unset(request.network_name):
            query['NetworkName'] = request.network_name
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNetworks',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeNetworksResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_networks(
        self,
        request: ens_20171110_models.DescribeNetworksRequest,
    ) -> ens_20171110_models.DescribeNetworksResponse:
        """
        @summary Query the network list.
        
        @description    You can call this operation up to 100 times per second.
        You can call this operation up to 10 times per second per account.
        
        @param request: DescribeNetworksRequest
        @return: DescribeNetworksResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_networks_with_options(request, runtime)

    async def describe_networks_async(
        self,
        request: ens_20171110_models.DescribeNetworksRequest,
    ) -> ens_20171110_models.DescribeNetworksResponse:
        """
        @summary Query the network list.
        
        @description    You can call this operation up to 100 times per second.
        You can call this operation up to 10 times per second per account.
        
        @param request: DescribeNetworksRequest
        @return: DescribeNetworksResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_networks_with_options_async(request, runtime)

    def describe_pre_paid_instance_stock_with_options(
        self,
        request: ens_20171110_models.DescribePrePaidInstanceStockRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribePrePaidInstanceStockResponse:
        """
        @summary Queries the specifications of resources that can be purchased in subscription billing mode.
        
        @param request: DescribePrePaidInstanceStockRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePrePaidInstanceStockResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.data_disk_size):
            query['DataDiskSize'] = request.data_disk_size
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.instance_spec):
            query['InstanceSpec'] = request.instance_spec
        if not UtilClient.is_unset(request.system_disk_size):
            query['SystemDiskSize'] = request.system_disk_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePrePaidInstanceStock',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribePrePaidInstanceStockResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_pre_paid_instance_stock_with_options_async(
        self,
        request: ens_20171110_models.DescribePrePaidInstanceStockRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribePrePaidInstanceStockResponse:
        """
        @summary Queries the specifications of resources that can be purchased in subscription billing mode.
        
        @param request: DescribePrePaidInstanceStockRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePrePaidInstanceStockResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.data_disk_size):
            query['DataDiskSize'] = request.data_disk_size
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.instance_spec):
            query['InstanceSpec'] = request.instance_spec
        if not UtilClient.is_unset(request.system_disk_size):
            query['SystemDiskSize'] = request.system_disk_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePrePaidInstanceStock',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribePrePaidInstanceStockResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_pre_paid_instance_stock(
        self,
        request: ens_20171110_models.DescribePrePaidInstanceStockRequest,
    ) -> ens_20171110_models.DescribePrePaidInstanceStockResponse:
        """
        @summary Queries the specifications of resources that can be purchased in subscription billing mode.
        
        @param request: DescribePrePaidInstanceStockRequest
        @return: DescribePrePaidInstanceStockResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_pre_paid_instance_stock_with_options(request, runtime)

    async def describe_pre_paid_instance_stock_async(
        self,
        request: ens_20171110_models.DescribePrePaidInstanceStockRequest,
    ) -> ens_20171110_models.DescribePrePaidInstanceStockResponse:
        """
        @summary Queries the specifications of resources that can be purchased in subscription billing mode.
        
        @param request: DescribePrePaidInstanceStockRequest
        @return: DescribePrePaidInstanceStockResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_pre_paid_instance_stock_with_options_async(request, runtime)

    def describe_price_with_options(
        self,
        tmp_req: ens_20171110_models.DescribePriceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribePriceResponse:
        """
        @summary Queries the most recent price of an Edge Node Service (ENS) instance.
        
        @param tmp_req: DescribePriceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePriceResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.DescribePriceShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.data_disks):
            request.data_disks_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.data_disks, 'DataDisks', 'json')
        query = {}
        if not UtilClient.is_unset(request.data_disks_shrink):
            query['DataDisks'] = request.data_disks_shrink
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.quantity):
            query['Quantity'] = request.quantity
        if not UtilClient.is_unset(request.data_disk):
            query['DataDisk'] = request.data_disk
        if not UtilClient.is_unset(request.system_disk):
            query['SystemDisk'] = request.system_disk
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePrice',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribePriceResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_price_with_options_async(
        self,
        tmp_req: ens_20171110_models.DescribePriceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribePriceResponse:
        """
        @summary Queries the most recent price of an Edge Node Service (ENS) instance.
        
        @param tmp_req: DescribePriceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePriceResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.DescribePriceShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.data_disks):
            request.data_disks_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.data_disks, 'DataDisks', 'json')
        query = {}
        if not UtilClient.is_unset(request.data_disks_shrink):
            query['DataDisks'] = request.data_disks_shrink
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.quantity):
            query['Quantity'] = request.quantity
        if not UtilClient.is_unset(request.data_disk):
            query['DataDisk'] = request.data_disk
        if not UtilClient.is_unset(request.system_disk):
            query['SystemDisk'] = request.system_disk
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePrice',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribePriceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_price(
        self,
        request: ens_20171110_models.DescribePriceRequest,
    ) -> ens_20171110_models.DescribePriceResponse:
        """
        @summary Queries the most recent price of an Edge Node Service (ENS) instance.
        
        @param request: DescribePriceRequest
        @return: DescribePriceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_price_with_options(request, runtime)

    async def describe_price_async(
        self,
        request: ens_20171110_models.DescribePriceRequest,
    ) -> ens_20171110_models.DescribePriceResponse:
        """
        @summary Queries the most recent price of an Edge Node Service (ENS) instance.
        
        @param request: DescribePriceRequest
        @return: DescribePriceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_price_with_options_async(request, runtime)

    def describe_region_isps_with_options(
        self,
        request: ens_20171110_models.DescribeRegionIspsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeRegionIspsResponse:
        """
        @summary Queries information about the Internet service providers (ISPs) of edge nodes.
        
        @param request: DescribeRegionIspsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRegionIspsResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRegionIsps',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeRegionIspsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_region_isps_with_options_async(
        self,
        request: ens_20171110_models.DescribeRegionIspsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeRegionIspsResponse:
        """
        @summary Queries information about the Internet service providers (ISPs) of edge nodes.
        
        @param request: DescribeRegionIspsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRegionIspsResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRegionIsps',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeRegionIspsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_region_isps(
        self,
        request: ens_20171110_models.DescribeRegionIspsRequest,
    ) -> ens_20171110_models.DescribeRegionIspsResponse:
        """
        @summary Queries information about the Internet service providers (ISPs) of edge nodes.
        
        @param request: DescribeRegionIspsRequest
        @return: DescribeRegionIspsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_region_isps_with_options(request, runtime)

    async def describe_region_isps_async(
        self,
        request: ens_20171110_models.DescribeRegionIspsRequest,
    ) -> ens_20171110_models.DescribeRegionIspsResponse:
        """
        @summary Queries information about the Internet service providers (ISPs) of edge nodes.
        
        @param request: DescribeRegionIspsRequest
        @return: DescribeRegionIspsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_region_isps_with_options_async(request, runtime)

    def describe_region_resource_with_options(
        self,
        request: ens_20171110_models.DescribeRegionResourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeRegionResourceResponse:
        """
        @summary 获取区域节点资源量信息
        
        @param request: DescribeRegionResourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRegionResourceResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRegionResource',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeRegionResourceResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_region_resource_with_options_async(
        self,
        request: ens_20171110_models.DescribeRegionResourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeRegionResourceResponse:
        """
        @summary 获取区域节点资源量信息
        
        @param request: DescribeRegionResourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRegionResourceResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRegionResource',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeRegionResourceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_region_resource(
        self,
        request: ens_20171110_models.DescribeRegionResourceRequest,
    ) -> ens_20171110_models.DescribeRegionResourceResponse:
        """
        @summary 获取区域节点资源量信息
        
        @param request: DescribeRegionResourceRequest
        @return: DescribeRegionResourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_region_resource_with_options(request, runtime)

    async def describe_region_resource_async(
        self,
        request: ens_20171110_models.DescribeRegionResourceRequest,
    ) -> ens_20171110_models.DescribeRegionResourceResponse:
        """
        @summary 获取区域节点资源量信息
        
        @param request: DescribeRegionResourceRequest
        @return: DescribeRegionResourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_region_resource_with_options_async(request, runtime)

    def describe_reserved_resource_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeReservedResourceResponse:
        """
        @summary Queries the specifications of resources that you can purchase.
        
        @param request: DescribeReservedResourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeReservedResourceResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeReservedResource',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeReservedResourceResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_reserved_resource_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeReservedResourceResponse:
        """
        @summary Queries the specifications of resources that you can purchase.
        
        @param request: DescribeReservedResourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeReservedResourceResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeReservedResource',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeReservedResourceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_reserved_resource(self) -> ens_20171110_models.DescribeReservedResourceResponse:
        """
        @summary Queries the specifications of resources that you can purchase.
        
        @return: DescribeReservedResourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_reserved_resource_with_options(runtime)

    async def describe_reserved_resource_async(self) -> ens_20171110_models.DescribeReservedResourceResponse:
        """
        @summary Queries the specifications of resources that you can purchase.
        
        @return: DescribeReservedResourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_reserved_resource_with_options_async(runtime)

    def describe_resource_timeline_with_options(
        self,
        request: ens_20171110_models.DescribeResourceTimelineRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeResourceTimelineResponse:
        """
        @summary 获取资源状态变化时间线
        
        @param request: DescribeResourceTimelineRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeResourceTimelineResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeResourceTimeline',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeResourceTimelineResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_resource_timeline_with_options_async(
        self,
        request: ens_20171110_models.DescribeResourceTimelineRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeResourceTimelineResponse:
        """
        @summary 获取资源状态变化时间线
        
        @param request: DescribeResourceTimelineRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeResourceTimelineResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeResourceTimeline',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeResourceTimelineResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_resource_timeline(
        self,
        request: ens_20171110_models.DescribeResourceTimelineRequest,
    ) -> ens_20171110_models.DescribeResourceTimelineResponse:
        """
        @summary 获取资源状态变化时间线
        
        @param request: DescribeResourceTimelineRequest
        @return: DescribeResourceTimelineResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_resource_timeline_with_options(request, runtime)

    async def describe_resource_timeline_async(
        self,
        request: ens_20171110_models.DescribeResourceTimelineRequest,
    ) -> ens_20171110_models.DescribeResourceTimelineResponse:
        """
        @summary 获取资源状态变化时间线
        
        @param request: DescribeResourceTimelineRequest
        @return: DescribeResourceTimelineResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_resource_timeline_with_options_async(request, runtime)

    def describe_sdgwith_options(
        self,
        tmp_req: ens_20171110_models.DescribeSDGRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeSDGResponse:
        """
        @summary Queries basic information about shared data groups (SDGs), including node preload information.
        
        @param tmp_req: DescribeSDGRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSDGResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.DescribeSDGShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.sdgids):
            request.sdgids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.sdgids, 'SDGIds', 'json')
        query = {}
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.sdgids_shrink):
            query['SDGIds'] = request.sdgids_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSDG',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeSDGResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_sdgwith_options_async(
        self,
        tmp_req: ens_20171110_models.DescribeSDGRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeSDGResponse:
        """
        @summary Queries basic information about shared data groups (SDGs), including node preload information.
        
        @param tmp_req: DescribeSDGRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSDGResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.DescribeSDGShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.sdgids):
            request.sdgids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.sdgids, 'SDGIds', 'json')
        query = {}
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.sdgids_shrink):
            query['SDGIds'] = request.sdgids_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSDG',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeSDGResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_sdg(
        self,
        request: ens_20171110_models.DescribeSDGRequest,
    ) -> ens_20171110_models.DescribeSDGResponse:
        """
        @summary Queries basic information about shared data groups (SDGs), including node preload information.
        
        @param request: DescribeSDGRequest
        @return: DescribeSDGResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_sdgwith_options(request, runtime)

    async def describe_sdg_async(
        self,
        request: ens_20171110_models.DescribeSDGRequest,
    ) -> ens_20171110_models.DescribeSDGResponse:
        """
        @summary Queries basic information about shared data groups (SDGs), including node preload information.
        
        @param request: DescribeSDGRequest
        @return: DescribeSDGResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_sdgwith_options_async(request, runtime)

    def describe_sdgdeployment_status_with_options(
        self,
        tmp_req: ens_20171110_models.DescribeSDGDeploymentStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeSDGDeploymentStatusResponse:
        """
        @summary Queries the deployment status of the shared data group (SDG).
        
        @param tmp_req: DescribeSDGDeploymentStatusRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSDGDeploymentStatusResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.DescribeSDGDeploymentStatusShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.instance_ids):
            request.instance_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.instance_ids, 'InstanceIds', 'json')
        if not UtilClient.is_unset(tmp_req.region_ids):
            request.region_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.region_ids, 'RegionIds', 'json')
        query = {}
        if not UtilClient.is_unset(request.deployment_type):
            query['DeploymentType'] = request.deployment_type
        if not UtilClient.is_unset(request.instance_ids_shrink):
            query['InstanceIds'] = request.instance_ids_shrink
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_ids_shrink):
            query['RegionIds'] = request.region_ids_shrink
        if not UtilClient.is_unset(request.sdgid):
            query['SDGId'] = request.sdgid
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSDGDeploymentStatus',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeSDGDeploymentStatusResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_sdgdeployment_status_with_options_async(
        self,
        tmp_req: ens_20171110_models.DescribeSDGDeploymentStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeSDGDeploymentStatusResponse:
        """
        @summary Queries the deployment status of the shared data group (SDG).
        
        @param tmp_req: DescribeSDGDeploymentStatusRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSDGDeploymentStatusResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.DescribeSDGDeploymentStatusShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.instance_ids):
            request.instance_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.instance_ids, 'InstanceIds', 'json')
        if not UtilClient.is_unset(tmp_req.region_ids):
            request.region_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.region_ids, 'RegionIds', 'json')
        query = {}
        if not UtilClient.is_unset(request.deployment_type):
            query['DeploymentType'] = request.deployment_type
        if not UtilClient.is_unset(request.instance_ids_shrink):
            query['InstanceIds'] = request.instance_ids_shrink
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_ids_shrink):
            query['RegionIds'] = request.region_ids_shrink
        if not UtilClient.is_unset(request.sdgid):
            query['SDGId'] = request.sdgid
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSDGDeploymentStatus',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeSDGDeploymentStatusResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_sdgdeployment_status(
        self,
        request: ens_20171110_models.DescribeSDGDeploymentStatusRequest,
    ) -> ens_20171110_models.DescribeSDGDeploymentStatusResponse:
        """
        @summary Queries the deployment status of the shared data group (SDG).
        
        @param request: DescribeSDGDeploymentStatusRequest
        @return: DescribeSDGDeploymentStatusResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_sdgdeployment_status_with_options(request, runtime)

    async def describe_sdgdeployment_status_async(
        self,
        request: ens_20171110_models.DescribeSDGDeploymentStatusRequest,
    ) -> ens_20171110_models.DescribeSDGDeploymentStatusResponse:
        """
        @summary Queries the deployment status of the shared data group (SDG).
        
        @param request: DescribeSDGDeploymentStatusRequest
        @return: DescribeSDGDeploymentStatusResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_sdgdeployment_status_with_options_async(request, runtime)

    def describe_sdgs_with_options(
        self,
        tmp_req: ens_20171110_models.DescribeSDGsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeSDGsResponse:
        """
        @summary Queries information about created shared data groups (SDGs).
        
        @param tmp_req: DescribeSDGsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSDGsResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.DescribeSDGsShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.instance_ids):
            request.instance_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.instance_ids, 'InstanceIds', 'json')
        if not UtilClient.is_unset(tmp_req.sdgids):
            request.sdgids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.sdgids, 'SDGIds', 'json')
        query = {}
        if not UtilClient.is_unset(request.instance_ids_shrink):
            query['InstanceIds'] = request.instance_ids_shrink
        if not UtilClient.is_unset(request.sdgids_shrink):
            query['SDGIds'] = request.sdgids_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSDGs',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeSDGsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_sdgs_with_options_async(
        self,
        tmp_req: ens_20171110_models.DescribeSDGsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeSDGsResponse:
        """
        @summary Queries information about created shared data groups (SDGs).
        
        @param tmp_req: DescribeSDGsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSDGsResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.DescribeSDGsShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.instance_ids):
            request.instance_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.instance_ids, 'InstanceIds', 'json')
        if not UtilClient.is_unset(tmp_req.sdgids):
            request.sdgids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.sdgids, 'SDGIds', 'json')
        query = {}
        if not UtilClient.is_unset(request.instance_ids_shrink):
            query['InstanceIds'] = request.instance_ids_shrink
        if not UtilClient.is_unset(request.sdgids_shrink):
            query['SDGIds'] = request.sdgids_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSDGs',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeSDGsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_sdgs(
        self,
        request: ens_20171110_models.DescribeSDGsRequest,
    ) -> ens_20171110_models.DescribeSDGsResponse:
        """
        @summary Queries information about created shared data groups (SDGs).
        
        @param request: DescribeSDGsRequest
        @return: DescribeSDGsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_sdgs_with_options(request, runtime)

    async def describe_sdgs_async(
        self,
        request: ens_20171110_models.DescribeSDGsRequest,
    ) -> ens_20171110_models.DescribeSDGsResponse:
        """
        @summary Queries information about created shared data groups (SDGs).
        
        @param request: DescribeSDGsRequest
        @return: DescribeSDGsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_sdgs_with_options_async(request, runtime)

    def describe_secondary_public_ip_addresses_with_options(
        self,
        request: ens_20171110_models.DescribeSecondaryPublicIpAddressesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeSecondaryPublicIpAddressesResponse:
        """
        @summary Queries created secondary public IP addresses.
        
        @param request: DescribeSecondaryPublicIpAddressesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSecondaryPublicIpAddressesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.ens_region_ids):
            query['EnsRegionIds'] = request.ens_region_ids
        if not UtilClient.is_unset(request.isp):
            query['Isp'] = request.isp
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.secondary_public_ip_address):
            query['SecondaryPublicIpAddress'] = request.secondary_public_ip_address
        if not UtilClient.is_unset(request.secondary_public_ip_id):
            query['SecondaryPublicIpId'] = request.secondary_public_ip_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSecondaryPublicIpAddresses',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeSecondaryPublicIpAddressesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_secondary_public_ip_addresses_with_options_async(
        self,
        request: ens_20171110_models.DescribeSecondaryPublicIpAddressesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeSecondaryPublicIpAddressesResponse:
        """
        @summary Queries created secondary public IP addresses.
        
        @param request: DescribeSecondaryPublicIpAddressesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSecondaryPublicIpAddressesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.ens_region_ids):
            query['EnsRegionIds'] = request.ens_region_ids
        if not UtilClient.is_unset(request.isp):
            query['Isp'] = request.isp
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.secondary_public_ip_address):
            query['SecondaryPublicIpAddress'] = request.secondary_public_ip_address
        if not UtilClient.is_unset(request.secondary_public_ip_id):
            query['SecondaryPublicIpId'] = request.secondary_public_ip_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSecondaryPublicIpAddresses',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeSecondaryPublicIpAddressesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_secondary_public_ip_addresses(
        self,
        request: ens_20171110_models.DescribeSecondaryPublicIpAddressesRequest,
    ) -> ens_20171110_models.DescribeSecondaryPublicIpAddressesResponse:
        """
        @summary Queries created secondary public IP addresses.
        
        @param request: DescribeSecondaryPublicIpAddressesRequest
        @return: DescribeSecondaryPublicIpAddressesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_secondary_public_ip_addresses_with_options(request, runtime)

    async def describe_secondary_public_ip_addresses_async(
        self,
        request: ens_20171110_models.DescribeSecondaryPublicIpAddressesRequest,
    ) -> ens_20171110_models.DescribeSecondaryPublicIpAddressesResponse:
        """
        @summary Queries created secondary public IP addresses.
        
        @param request: DescribeSecondaryPublicIpAddressesRequest
        @return: DescribeSecondaryPublicIpAddressesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_secondary_public_ip_addresses_with_options_async(request, runtime)

    def describe_security_group_attribute_with_options(
        self,
        request: ens_20171110_models.DescribeSecurityGroupAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeSecurityGroupAttributeResponse:
        """
        @summary Queries the rules of a security group.
        
        @param request: DescribeSecurityGroupAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSecurityGroupAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSecurityGroupAttribute',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeSecurityGroupAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_security_group_attribute_with_options_async(
        self,
        request: ens_20171110_models.DescribeSecurityGroupAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeSecurityGroupAttributeResponse:
        """
        @summary Queries the rules of a security group.
        
        @param request: DescribeSecurityGroupAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSecurityGroupAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSecurityGroupAttribute',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeSecurityGroupAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_security_group_attribute(
        self,
        request: ens_20171110_models.DescribeSecurityGroupAttributeRequest,
    ) -> ens_20171110_models.DescribeSecurityGroupAttributeResponse:
        """
        @summary Queries the rules of a security group.
        
        @param request: DescribeSecurityGroupAttributeRequest
        @return: DescribeSecurityGroupAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_security_group_attribute_with_options(request, runtime)

    async def describe_security_group_attribute_async(
        self,
        request: ens_20171110_models.DescribeSecurityGroupAttributeRequest,
    ) -> ens_20171110_models.DescribeSecurityGroupAttributeResponse:
        """
        @summary Queries the rules of a security group.
        
        @param request: DescribeSecurityGroupAttributeRequest
        @return: DescribeSecurityGroupAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_security_group_attribute_with_options_async(request, runtime)

    def describe_security_groups_with_options(
        self,
        request: ens_20171110_models.DescribeSecurityGroupsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeSecurityGroupsResponse:
        """
        @summary Queries details about created security groups.
        
        @param request: DescribeSecurityGroupsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSecurityGroupsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        if not UtilClient.is_unset(request.security_group_name):
            query['SecurityGroupName'] = request.security_group_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSecurityGroups',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeSecurityGroupsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_security_groups_with_options_async(
        self,
        request: ens_20171110_models.DescribeSecurityGroupsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeSecurityGroupsResponse:
        """
        @summary Queries details about created security groups.
        
        @param request: DescribeSecurityGroupsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSecurityGroupsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        if not UtilClient.is_unset(request.security_group_name):
            query['SecurityGroupName'] = request.security_group_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSecurityGroups',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeSecurityGroupsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_security_groups(
        self,
        request: ens_20171110_models.DescribeSecurityGroupsRequest,
    ) -> ens_20171110_models.DescribeSecurityGroupsResponse:
        """
        @summary Queries details about created security groups.
        
        @param request: DescribeSecurityGroupsRequest
        @return: DescribeSecurityGroupsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_security_groups_with_options(request, runtime)

    async def describe_security_groups_async(
        self,
        request: ens_20171110_models.DescribeSecurityGroupsRequest,
    ) -> ens_20171110_models.DescribeSecurityGroupsResponse:
        """
        @summary Queries details about created security groups.
        
        @param request: DescribeSecurityGroupsRequest
        @return: DescribeSecurityGroupsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_security_groups_with_options_async(request, runtime)

    def describe_self_images_with_options(
        self,
        request: ens_20171110_models.DescribeSelfImagesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeSelfImagesResponse:
        """
        @summary Queries custom images.
        
        @param request: DescribeSelfImagesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSelfImagesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.image_name):
            query['ImageName'] = request.image_name
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.snapshot_id):
            query['SnapshotId'] = request.snapshot_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSelfImages',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeSelfImagesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_self_images_with_options_async(
        self,
        request: ens_20171110_models.DescribeSelfImagesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeSelfImagesResponse:
        """
        @summary Queries custom images.
        
        @param request: DescribeSelfImagesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSelfImagesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.image_name):
            query['ImageName'] = request.image_name
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.snapshot_id):
            query['SnapshotId'] = request.snapshot_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSelfImages',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeSelfImagesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_self_images(
        self,
        request: ens_20171110_models.DescribeSelfImagesRequest,
    ) -> ens_20171110_models.DescribeSelfImagesResponse:
        """
        @summary Queries custom images.
        
        @param request: DescribeSelfImagesRequest
        @return: DescribeSelfImagesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_self_images_with_options(request, runtime)

    async def describe_self_images_async(
        self,
        request: ens_20171110_models.DescribeSelfImagesRequest,
    ) -> ens_20171110_models.DescribeSelfImagesResponse:
        """
        @summary Queries custom images.
        
        @param request: DescribeSelfImagesRequest
        @return: DescribeSelfImagesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_self_images_with_options_async(request, runtime)

    def describe_servcie_schedule_with_options(
        self,
        request: ens_20171110_models.DescribeServcieScheduleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeServcieScheduleResponse:
        """
        @summary You can call the DescribeServcieSchedule to query the real-time status of the instance device or container that is being occupied by the UUID.
        
        @param request: DescribeServcieScheduleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeServcieScheduleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.pod_config_name):
            query['PodConfigName'] = request.pod_config_name
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeServcieSchedule',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeServcieScheduleResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_servcie_schedule_with_options_async(
        self,
        request: ens_20171110_models.DescribeServcieScheduleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeServcieScheduleResponse:
        """
        @summary You can call the DescribeServcieSchedule to query the real-time status of the instance device or container that is being occupied by the UUID.
        
        @param request: DescribeServcieScheduleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeServcieScheduleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.pod_config_name):
            query['PodConfigName'] = request.pod_config_name
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeServcieSchedule',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeServcieScheduleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_servcie_schedule(
        self,
        request: ens_20171110_models.DescribeServcieScheduleRequest,
    ) -> ens_20171110_models.DescribeServcieScheduleResponse:
        """
        @summary You can call the DescribeServcieSchedule to query the real-time status of the instance device or container that is being occupied by the UUID.
        
        @param request: DescribeServcieScheduleRequest
        @return: DescribeServcieScheduleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_servcie_schedule_with_options(request, runtime)

    async def describe_servcie_schedule_async(
        self,
        request: ens_20171110_models.DescribeServcieScheduleRequest,
    ) -> ens_20171110_models.DescribeServcieScheduleResponse:
        """
        @summary You can call the DescribeServcieSchedule to query the real-time status of the instance device or container that is being occupied by the UUID.
        
        @param request: DescribeServcieScheduleRequest
        @return: DescribeServcieScheduleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_servcie_schedule_with_options_async(request, runtime)

    def describe_server_load_balancer_listen_monitor_with_options(
        self,
        request: ens_20171110_models.DescribeServerLoadBalancerListenMonitorRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeServerLoadBalancerListenMonitorResponse:
        """
        @summary Queries the monitoring data of an edge load balancer (ELB) instance based on the listener.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: DescribeServerLoadBalancerListenMonitorRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeServerLoadBalancerListenMonitorResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeServerLoadBalancerListenMonitor',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeServerLoadBalancerListenMonitorResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_server_load_balancer_listen_monitor_with_options_async(
        self,
        request: ens_20171110_models.DescribeServerLoadBalancerListenMonitorRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeServerLoadBalancerListenMonitorResponse:
        """
        @summary Queries the monitoring data of an edge load balancer (ELB) instance based on the listener.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: DescribeServerLoadBalancerListenMonitorRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeServerLoadBalancerListenMonitorResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeServerLoadBalancerListenMonitor',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeServerLoadBalancerListenMonitorResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_server_load_balancer_listen_monitor(
        self,
        request: ens_20171110_models.DescribeServerLoadBalancerListenMonitorRequest,
    ) -> ens_20171110_models.DescribeServerLoadBalancerListenMonitorResponse:
        """
        @summary Queries the monitoring data of an edge load balancer (ELB) instance based on the listener.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: DescribeServerLoadBalancerListenMonitorRequest
        @return: DescribeServerLoadBalancerListenMonitorResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_server_load_balancer_listen_monitor_with_options(request, runtime)

    async def describe_server_load_balancer_listen_monitor_async(
        self,
        request: ens_20171110_models.DescribeServerLoadBalancerListenMonitorRequest,
    ) -> ens_20171110_models.DescribeServerLoadBalancerListenMonitorResponse:
        """
        @summary Queries the monitoring data of an edge load balancer (ELB) instance based on the listener.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: DescribeServerLoadBalancerListenMonitorRequest
        @return: DescribeServerLoadBalancerListenMonitorResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_server_load_balancer_listen_monitor_with_options_async(request, runtime)

    def describe_server_load_balancer_monitor_with_options(
        self,
        request: ens_20171110_models.DescribeServerLoadBalancerMonitorRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeServerLoadBalancerMonitorResponse:
        """
        @summary Queries the request monitoring data of an edge load balancer (ELB) instance.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: DescribeServerLoadBalancerMonitorRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeServerLoadBalancerMonitorResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeServerLoadBalancerMonitor',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeServerLoadBalancerMonitorResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_server_load_balancer_monitor_with_options_async(
        self,
        request: ens_20171110_models.DescribeServerLoadBalancerMonitorRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeServerLoadBalancerMonitorResponse:
        """
        @summary Queries the request monitoring data of an edge load balancer (ELB) instance.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: DescribeServerLoadBalancerMonitorRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeServerLoadBalancerMonitorResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeServerLoadBalancerMonitor',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeServerLoadBalancerMonitorResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_server_load_balancer_monitor(
        self,
        request: ens_20171110_models.DescribeServerLoadBalancerMonitorRequest,
    ) -> ens_20171110_models.DescribeServerLoadBalancerMonitorResponse:
        """
        @summary Queries the request monitoring data of an edge load balancer (ELB) instance.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: DescribeServerLoadBalancerMonitorRequest
        @return: DescribeServerLoadBalancerMonitorResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_server_load_balancer_monitor_with_options(request, runtime)

    async def describe_server_load_balancer_monitor_async(
        self,
        request: ens_20171110_models.DescribeServerLoadBalancerMonitorRequest,
    ) -> ens_20171110_models.DescribeServerLoadBalancerMonitorResponse:
        """
        @summary Queries the request monitoring data of an edge load balancer (ELB) instance.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: DescribeServerLoadBalancerMonitorRequest
        @return: DescribeServerLoadBalancerMonitorResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_server_load_balancer_monitor_with_options_async(request, runtime)

    def describe_snapshots_with_options(
        self,
        request: ens_20171110_models.DescribeSnapshotsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeSnapshotsResponse:
        """
        @summary Queries information about snapshots.
        
        @param request: DescribeSnapshotsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSnapshotsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.disk_id):
            query['DiskId'] = request.disk_id
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.ens_region_ids):
            query['EnsRegionIds'] = request.ens_region_ids
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.snapshot_id):
            query['SnapshotId'] = request.snapshot_id
        if not UtilClient.is_unset(request.snapshot_name):
            query['SnapshotName'] = request.snapshot_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSnapshots',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeSnapshotsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_snapshots_with_options_async(
        self,
        request: ens_20171110_models.DescribeSnapshotsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeSnapshotsResponse:
        """
        @summary Queries information about snapshots.
        
        @param request: DescribeSnapshotsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSnapshotsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.disk_id):
            query['DiskId'] = request.disk_id
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.ens_region_ids):
            query['EnsRegionIds'] = request.ens_region_ids
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.snapshot_id):
            query['SnapshotId'] = request.snapshot_id
        if not UtilClient.is_unset(request.snapshot_name):
            query['SnapshotName'] = request.snapshot_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSnapshots',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeSnapshotsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_snapshots(
        self,
        request: ens_20171110_models.DescribeSnapshotsRequest,
    ) -> ens_20171110_models.DescribeSnapshotsResponse:
        """
        @summary Queries information about snapshots.
        
        @param request: DescribeSnapshotsRequest
        @return: DescribeSnapshotsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_snapshots_with_options(request, runtime)

    async def describe_snapshots_async(
        self,
        request: ens_20171110_models.DescribeSnapshotsRequest,
    ) -> ens_20171110_models.DescribeSnapshotsResponse:
        """
        @summary Queries information about snapshots.
        
        @param request: DescribeSnapshotsRequest
        @return: DescribeSnapshotsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_snapshots_with_options_async(request, runtime)

    def describe_snat_attribute_with_options(
        self,
        request: ens_20171110_models.DescribeSnatAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeSnatAttributeResponse:
        """
        @summary Queries the details of a specific source network address translation (SNAT) entry.
        
        @param request: DescribeSnatAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSnatAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.snat_entry_id):
            query['SnatEntryId'] = request.snat_entry_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSnatAttribute',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeSnatAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_snat_attribute_with_options_async(
        self,
        request: ens_20171110_models.DescribeSnatAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeSnatAttributeResponse:
        """
        @summary Queries the details of a specific source network address translation (SNAT) entry.
        
        @param request: DescribeSnatAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSnatAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.snat_entry_id):
            query['SnatEntryId'] = request.snat_entry_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSnatAttribute',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeSnatAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_snat_attribute(
        self,
        request: ens_20171110_models.DescribeSnatAttributeRequest,
    ) -> ens_20171110_models.DescribeSnatAttributeResponse:
        """
        @summary Queries the details of a specific source network address translation (SNAT) entry.
        
        @param request: DescribeSnatAttributeRequest
        @return: DescribeSnatAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_snat_attribute_with_options(request, runtime)

    async def describe_snat_attribute_async(
        self,
        request: ens_20171110_models.DescribeSnatAttributeRequest,
    ) -> ens_20171110_models.DescribeSnatAttributeResponse:
        """
        @summary Queries the details of a specific source network address translation (SNAT) entry.
        
        @param request: DescribeSnatAttributeRequest
        @return: DescribeSnatAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_snat_attribute_with_options_async(request, runtime)

    def describe_snat_table_entries_with_options(
        self,
        request: ens_20171110_models.DescribeSnatTableEntriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeSnatTableEntriesResponse:
        """
        @summary Queries source network address translation (SNAT) entries.
        
        @param request: DescribeSnatTableEntriesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSnatTableEntriesResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSnatTableEntries',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeSnatTableEntriesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_snat_table_entries_with_options_async(
        self,
        request: ens_20171110_models.DescribeSnatTableEntriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeSnatTableEntriesResponse:
        """
        @summary Queries source network address translation (SNAT) entries.
        
        @param request: DescribeSnatTableEntriesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSnatTableEntriesResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSnatTableEntries',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeSnatTableEntriesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_snat_table_entries(
        self,
        request: ens_20171110_models.DescribeSnatTableEntriesRequest,
    ) -> ens_20171110_models.DescribeSnatTableEntriesResponse:
        """
        @summary Queries source network address translation (SNAT) entries.
        
        @param request: DescribeSnatTableEntriesRequest
        @return: DescribeSnatTableEntriesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_snat_table_entries_with_options(request, runtime)

    async def describe_snat_table_entries_async(
        self,
        request: ens_20171110_models.DescribeSnatTableEntriesRequest,
    ) -> ens_20171110_models.DescribeSnatTableEntriesResponse:
        """
        @summary Queries source network address translation (SNAT) entries.
        
        @param request: DescribeSnatTableEntriesRequest
        @return: DescribeSnatTableEntriesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_snat_table_entries_with_options_async(request, runtime)

    def describe_storage_gateway_with_options(
        self,
        request: ens_20171110_models.DescribeStorageGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeStorageGatewayResponse:
        """
        @summary Queries storage gateways.
        
        @param request: DescribeStorageGatewayRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeStorageGatewayResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.gateway_id):
            query['GatewayId'] = request.gateway_id
        if not UtilClient.is_unset(request.gateway_type):
            query['GatewayType'] = request.gateway_type
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeStorageGateway',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeStorageGatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_storage_gateway_with_options_async(
        self,
        request: ens_20171110_models.DescribeStorageGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeStorageGatewayResponse:
        """
        @summary Queries storage gateways.
        
        @param request: DescribeStorageGatewayRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeStorageGatewayResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.gateway_id):
            query['GatewayId'] = request.gateway_id
        if not UtilClient.is_unset(request.gateway_type):
            query['GatewayType'] = request.gateway_type
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeStorageGateway',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeStorageGatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_storage_gateway(
        self,
        request: ens_20171110_models.DescribeStorageGatewayRequest,
    ) -> ens_20171110_models.DescribeStorageGatewayResponse:
        """
        @summary Queries storage gateways.
        
        @param request: DescribeStorageGatewayRequest
        @return: DescribeStorageGatewayResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_storage_gateway_with_options(request, runtime)

    async def describe_storage_gateway_async(
        self,
        request: ens_20171110_models.DescribeStorageGatewayRequest,
    ) -> ens_20171110_models.DescribeStorageGatewayResponse:
        """
        @summary Queries storage gateways.
        
        @param request: DescribeStorageGatewayRequest
        @return: DescribeStorageGatewayResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_storage_gateway_with_options_async(request, runtime)

    def describe_storage_volume_with_options(
        self,
        request: ens_20171110_models.DescribeStorageVolumeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeStorageVolumeResponse:
        """
        @summary Queries volumes.
        
        @param request: DescribeStorageVolumeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeStorageVolumeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.gateway_id):
            query['GatewayId'] = request.gateway_id
        if not UtilClient.is_unset(request.is_enable):
            query['IsEnable'] = request.is_enable
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.storage_id):
            query['StorageId'] = request.storage_id
        if not UtilClient.is_unset(request.volume_id):
            query['VolumeId'] = request.volume_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeStorageVolume',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeStorageVolumeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_storage_volume_with_options_async(
        self,
        request: ens_20171110_models.DescribeStorageVolumeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeStorageVolumeResponse:
        """
        @summary Queries volumes.
        
        @param request: DescribeStorageVolumeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeStorageVolumeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.gateway_id):
            query['GatewayId'] = request.gateway_id
        if not UtilClient.is_unset(request.is_enable):
            query['IsEnable'] = request.is_enable
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.storage_id):
            query['StorageId'] = request.storage_id
        if not UtilClient.is_unset(request.volume_id):
            query['VolumeId'] = request.volume_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeStorageVolume',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeStorageVolumeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_storage_volume(
        self,
        request: ens_20171110_models.DescribeStorageVolumeRequest,
    ) -> ens_20171110_models.DescribeStorageVolumeResponse:
        """
        @summary Queries volumes.
        
        @param request: DescribeStorageVolumeRequest
        @return: DescribeStorageVolumeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_storage_volume_with_options(request, runtime)

    async def describe_storage_volume_async(
        self,
        request: ens_20171110_models.DescribeStorageVolumeRequest,
    ) -> ens_20171110_models.DescribeStorageVolumeResponse:
        """
        @summary Queries volumes.
        
        @param request: DescribeStorageVolumeRequest
        @return: DescribeStorageVolumeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_storage_volume_with_options_async(request, runtime)

    def describe_user_band_width_data_with_options(
        self,
        request: ens_20171110_models.DescribeUserBandWidthDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeUserBandWidthDataResponse:
        """
        @summary Queries the bandwidth that you use within a specified period of time.
        
        @param request: DescribeUserBandWidthDataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeUserBandWidthDataResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.isp):
            query['Isp'] = request.isp
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeUserBandWidthData',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeUserBandWidthDataResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_user_band_width_data_with_options_async(
        self,
        request: ens_20171110_models.DescribeUserBandWidthDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeUserBandWidthDataResponse:
        """
        @summary Queries the bandwidth that you use within a specified period of time.
        
        @param request: DescribeUserBandWidthDataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeUserBandWidthDataResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.isp):
            query['Isp'] = request.isp
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeUserBandWidthData',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeUserBandWidthDataResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_user_band_width_data(
        self,
        request: ens_20171110_models.DescribeUserBandWidthDataRequest,
    ) -> ens_20171110_models.DescribeUserBandWidthDataResponse:
        """
        @summary Queries the bandwidth that you use within a specified period of time.
        
        @param request: DescribeUserBandWidthDataRequest
        @return: DescribeUserBandWidthDataResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_user_band_width_data_with_options(request, runtime)

    async def describe_user_band_width_data_async(
        self,
        request: ens_20171110_models.DescribeUserBandWidthDataRequest,
    ) -> ens_20171110_models.DescribeUserBandWidthDataResponse:
        """
        @summary Queries the bandwidth that you use within a specified period of time.
        
        @param request: DescribeUserBandWidthDataRequest
        @return: DescribeUserBandWidthDataResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_user_band_width_data_with_options_async(request, runtime)

    def describe_vswitch_attributes_with_options(
        self,
        request: ens_20171110_models.DescribeVSwitchAttributesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeVSwitchAttributesResponse:
        """
        @summary 调用DescribeVSwitchAttributes接口查询指定交换机的配置信息。
        
        @param request: DescribeVSwitchAttributesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeVSwitchAttributesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVSwitchAttributes',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeVSwitchAttributesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vswitch_attributes_with_options_async(
        self,
        request: ens_20171110_models.DescribeVSwitchAttributesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeVSwitchAttributesResponse:
        """
        @summary 调用DescribeVSwitchAttributes接口查询指定交换机的配置信息。
        
        @param request: DescribeVSwitchAttributesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeVSwitchAttributesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVSwitchAttributes',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeVSwitchAttributesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vswitch_attributes(
        self,
        request: ens_20171110_models.DescribeVSwitchAttributesRequest,
    ) -> ens_20171110_models.DescribeVSwitchAttributesResponse:
        """
        @summary 调用DescribeVSwitchAttributes接口查询指定交换机的配置信息。
        
        @param request: DescribeVSwitchAttributesRequest
        @return: DescribeVSwitchAttributesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_vswitch_attributes_with_options(request, runtime)

    async def describe_vswitch_attributes_async(
        self,
        request: ens_20171110_models.DescribeVSwitchAttributesRequest,
    ) -> ens_20171110_models.DescribeVSwitchAttributesResponse:
        """
        @summary 调用DescribeVSwitchAttributes接口查询指定交换机的配置信息。
        
        @param request: DescribeVSwitchAttributesRequest
        @return: DescribeVSwitchAttributesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_vswitch_attributes_with_options_async(request, runtime)

    def describe_vswitches_with_options(
        self,
        request: ens_20171110_models.DescribeVSwitchesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeVSwitchesResponse:
        """
        @summary Queries information about available vSwitches.
        
        @param request: DescribeVSwitchesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeVSwitchesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.ens_region_ids):
            query['EnsRegionIds'] = request.ens_region_ids
        if not UtilClient.is_unset(request.network_id):
            query['NetworkId'] = request.network_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.v_switch_ids):
            query['VSwitchIds'] = request.v_switch_ids
        if not UtilClient.is_unset(request.v_switch_name):
            query['VSwitchName'] = request.v_switch_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVSwitches',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeVSwitchesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vswitches_with_options_async(
        self,
        request: ens_20171110_models.DescribeVSwitchesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DescribeVSwitchesResponse:
        """
        @summary Queries information about available vSwitches.
        
        @param request: DescribeVSwitchesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeVSwitchesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.ens_region_ids):
            query['EnsRegionIds'] = request.ens_region_ids
        if not UtilClient.is_unset(request.network_id):
            query['NetworkId'] = request.network_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.v_switch_ids):
            query['VSwitchIds'] = request.v_switch_ids
        if not UtilClient.is_unset(request.v_switch_name):
            query['VSwitchName'] = request.v_switch_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVSwitches',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DescribeVSwitchesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vswitches(
        self,
        request: ens_20171110_models.DescribeVSwitchesRequest,
    ) -> ens_20171110_models.DescribeVSwitchesResponse:
        """
        @summary Queries information about available vSwitches.
        
        @param request: DescribeVSwitchesRequest
        @return: DescribeVSwitchesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_vswitches_with_options(request, runtime)

    async def describe_vswitches_async(
        self,
        request: ens_20171110_models.DescribeVSwitchesRequest,
    ) -> ens_20171110_models.DescribeVSwitchesResponse:
        """
        @summary Queries information about available vSwitches.
        
        @param request: DescribeVSwitchesRequest
        @return: DescribeVSwitchesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_vswitches_with_options_async(request, runtime)

    def detach_disk_with_options(
        self,
        request: ens_20171110_models.DetachDiskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DetachDiskResponse:
        """
        @summary Detaches a pay-as-you-go disk from an Edge Node Service (ENS) instance. You cannot call this operation to detach a disk that is created together with an instance.
        
        @param request: DetachDiskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DetachDiskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.disk_id):
            query['DiskId'] = request.disk_id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DetachDisk',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DetachDiskResponse(),
            self.call_api(params, req, runtime)
        )

    async def detach_disk_with_options_async(
        self,
        request: ens_20171110_models.DetachDiskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DetachDiskResponse:
        """
        @summary Detaches a pay-as-you-go disk from an Edge Node Service (ENS) instance. You cannot call this operation to detach a disk that is created together with an instance.
        
        @param request: DetachDiskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DetachDiskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.disk_id):
            query['DiskId'] = request.disk_id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DetachDisk',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DetachDiskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def detach_disk(
        self,
        request: ens_20171110_models.DetachDiskRequest,
    ) -> ens_20171110_models.DetachDiskResponse:
        """
        @summary Detaches a pay-as-you-go disk from an Edge Node Service (ENS) instance. You cannot call this operation to detach a disk that is created together with an instance.
        
        @param request: DetachDiskRequest
        @return: DetachDiskResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.detach_disk_with_options(request, runtime)

    async def detach_disk_async(
        self,
        request: ens_20171110_models.DetachDiskRequest,
    ) -> ens_20171110_models.DetachDiskResponse:
        """
        @summary Detaches a pay-as-you-go disk from an Edge Node Service (ENS) instance. You cannot call this operation to detach a disk that is created together with an instance.
        
        @param request: DetachDiskRequest
        @return: DetachDiskResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.detach_disk_with_options_async(request, runtime)

    def detach_instance_sdgwith_options(
        self,
        tmp_req: ens_20171110_models.DetachInstanceSDGRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DetachInstanceSDGResponse:
        """
        @summary Detaches a shared data group (SDG).
        
        @param tmp_req: DetachInstanceSDGRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DetachInstanceSDGResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.DetachInstanceSDGShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.instance_ids):
            request.instance_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.instance_ids, 'InstanceIds', 'json')
        query = {}
        if not UtilClient.is_unset(request.instance_ids_shrink):
            query['InstanceIds'] = request.instance_ids_shrink
        if not UtilClient.is_unset(request.sdgid):
            query['SDGId'] = request.sdgid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DetachInstanceSDG',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DetachInstanceSDGResponse(),
            self.call_api(params, req, runtime)
        )

    async def detach_instance_sdgwith_options_async(
        self,
        tmp_req: ens_20171110_models.DetachInstanceSDGRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DetachInstanceSDGResponse:
        """
        @summary Detaches a shared data group (SDG).
        
        @param tmp_req: DetachInstanceSDGRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DetachInstanceSDGResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.DetachInstanceSDGShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.instance_ids):
            request.instance_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.instance_ids, 'InstanceIds', 'json')
        query = {}
        if not UtilClient.is_unset(request.instance_ids_shrink):
            query['InstanceIds'] = request.instance_ids_shrink
        if not UtilClient.is_unset(request.sdgid):
            query['SDGId'] = request.sdgid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DetachInstanceSDG',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DetachInstanceSDGResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def detach_instance_sdg(
        self,
        request: ens_20171110_models.DetachInstanceSDGRequest,
    ) -> ens_20171110_models.DetachInstanceSDGResponse:
        """
        @summary Detaches a shared data group (SDG).
        
        @param request: DetachInstanceSDGRequest
        @return: DetachInstanceSDGResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.detach_instance_sdgwith_options(request, runtime)

    async def detach_instance_sdg_async(
        self,
        request: ens_20171110_models.DetachInstanceSDGRequest,
    ) -> ens_20171110_models.DetachInstanceSDGResponse:
        """
        @summary Detaches a shared data group (SDG).
        
        @param request: DetachInstanceSDGRequest
        @return: DetachInstanceSDGResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.detach_instance_sdgwith_options_async(request, runtime)

    def detach_network_interface_with_options(
        self,
        request: ens_20171110_models.DetachNetworkInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DetachNetworkInterfaceResponse:
        """
        @summary Detach an elastic network interface (ENI) from an instance.
        
        @description Before you call this operation, take note of the following items:
        You cannot detach a primary ENI from an instance.
        The ENI must be in the InUse state.
        The instances are in the Stopped state.
        This operation is an asynchronous operation. After this operation is called to detach an ENI, you can check the state of the ENI to determine whether the ENI is detached.
        
        @param request: DetachNetworkInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DetachNetworkInterfaceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.network_interface_id):
            query['NetworkInterfaceId'] = request.network_interface_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DetachNetworkInterface',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DetachNetworkInterfaceResponse(),
            self.call_api(params, req, runtime)
        )

    async def detach_network_interface_with_options_async(
        self,
        request: ens_20171110_models.DetachNetworkInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DetachNetworkInterfaceResponse:
        """
        @summary Detach an elastic network interface (ENI) from an instance.
        
        @description Before you call this operation, take note of the following items:
        You cannot detach a primary ENI from an instance.
        The ENI must be in the InUse state.
        The instances are in the Stopped state.
        This operation is an asynchronous operation. After this operation is called to detach an ENI, you can check the state of the ENI to determine whether the ENI is detached.
        
        @param request: DetachNetworkInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DetachNetworkInterfaceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.network_interface_id):
            query['NetworkInterfaceId'] = request.network_interface_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DetachNetworkInterface',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DetachNetworkInterfaceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def detach_network_interface(
        self,
        request: ens_20171110_models.DetachNetworkInterfaceRequest,
    ) -> ens_20171110_models.DetachNetworkInterfaceResponse:
        """
        @summary Detach an elastic network interface (ENI) from an instance.
        
        @description Before you call this operation, take note of the following items:
        You cannot detach a primary ENI from an instance.
        The ENI must be in the InUse state.
        The instances are in the Stopped state.
        This operation is an asynchronous operation. After this operation is called to detach an ENI, you can check the state of the ENI to determine whether the ENI is detached.
        
        @param request: DetachNetworkInterfaceRequest
        @return: DetachNetworkInterfaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.detach_network_interface_with_options(request, runtime)

    async def detach_network_interface_async(
        self,
        request: ens_20171110_models.DetachNetworkInterfaceRequest,
    ) -> ens_20171110_models.DetachNetworkInterfaceResponse:
        """
        @summary Detach an elastic network interface (ENI) from an instance.
        
        @description Before you call this operation, take note of the following items:
        You cannot detach a primary ENI from an instance.
        The ENI must be in the InUse state.
        The instances are in the Stopped state.
        This operation is an asynchronous operation. After this operation is called to detach an ENI, you can check the state of the ENI to determine whether the ENI is detached.
        
        @param request: DetachNetworkInterfaceRequest
        @return: DetachNetworkInterfaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.detach_network_interface_with_options_async(request, runtime)

    def dist_application_data_with_options(
        self,
        request: ens_20171110_models.DistApplicationDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DistApplicationDataResponse:
        """
        @summary Distributes pushed data to the Edge Node Service (ENS) instances of the application. You can specify multiple canary release policies, decompress files, and restart containers.
        
        @param request: DistApplicationDataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DistApplicationDataResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.data):
            query['Data'] = request.data
        if not UtilClient.is_unset(request.dist_strategy):
            query['DistStrategy'] = request.dist_strategy
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DistApplicationData',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DistApplicationDataResponse(),
            self.call_api(params, req, runtime)
        )

    async def dist_application_data_with_options_async(
        self,
        request: ens_20171110_models.DistApplicationDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.DistApplicationDataResponse:
        """
        @summary Distributes pushed data to the Edge Node Service (ENS) instances of the application. You can specify multiple canary release policies, decompress files, and restart containers.
        
        @param request: DistApplicationDataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DistApplicationDataResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.data):
            query['Data'] = request.data
        if not UtilClient.is_unset(request.dist_strategy):
            query['DistStrategy'] = request.dist_strategy
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DistApplicationData',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.DistApplicationDataResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def dist_application_data(
        self,
        request: ens_20171110_models.DistApplicationDataRequest,
    ) -> ens_20171110_models.DistApplicationDataResponse:
        """
        @summary Distributes pushed data to the Edge Node Service (ENS) instances of the application. You can specify multiple canary release policies, decompress files, and restart containers.
        
        @param request: DistApplicationDataRequest
        @return: DistApplicationDataResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.dist_application_data_with_options(request, runtime)

    async def dist_application_data_async(
        self,
        request: ens_20171110_models.DistApplicationDataRequest,
    ) -> ens_20171110_models.DistApplicationDataResponse:
        """
        @summary Distributes pushed data to the Edge Node Service (ENS) instances of the application. You can specify multiple canary release policies, decompress files, and restart containers.
        
        @param request: DistApplicationDataRequest
        @return: DistApplicationDataResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.dist_application_data_with_options_async(request, runtime)

    def export_bill_detail_data_with_options(
        self,
        request: ens_20171110_models.ExportBillDetailDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ExportBillDetailDataResponse:
        """
        @summary Exports billing details within a specific time range.
        
        @param request: ExportBillDetailDataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExportBillDetailDataResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_date):
            query['EndDate'] = request.end_date
        if not UtilClient.is_unset(request.start_date):
            query['StartDate'] = request.start_date
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ExportBillDetailData',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ExportBillDetailDataResponse(),
            self.call_api(params, req, runtime)
        )

    async def export_bill_detail_data_with_options_async(
        self,
        request: ens_20171110_models.ExportBillDetailDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ExportBillDetailDataResponse:
        """
        @summary Exports billing details within a specific time range.
        
        @param request: ExportBillDetailDataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExportBillDetailDataResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_date):
            query['EndDate'] = request.end_date
        if not UtilClient.is_unset(request.start_date):
            query['StartDate'] = request.start_date
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ExportBillDetailData',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ExportBillDetailDataResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def export_bill_detail_data(
        self,
        request: ens_20171110_models.ExportBillDetailDataRequest,
    ) -> ens_20171110_models.ExportBillDetailDataResponse:
        """
        @summary Exports billing details within a specific time range.
        
        @param request: ExportBillDetailDataRequest
        @return: ExportBillDetailDataResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.export_bill_detail_data_with_options(request, runtime)

    async def export_bill_detail_data_async(
        self,
        request: ens_20171110_models.ExportBillDetailDataRequest,
    ) -> ens_20171110_models.ExportBillDetailDataResponse:
        """
        @summary Exports billing details within a specific time range.
        
        @param request: ExportBillDetailDataRequest
        @return: ExportBillDetailDataResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.export_bill_detail_data_with_options_async(request, runtime)

    def export_image_with_options(
        self,
        request: ens_20171110_models.ExportImageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ExportImageResponse:
        """
        @summary Exports a custom image to an Object Storage Service (OSS) bucket in the same region.
        
        @param request: ExportImageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExportImageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.ossbucket):
            query['OSSBucket'] = request.ossbucket
        if not UtilClient.is_unset(request.ossprefix):
            query['OSSPrefix'] = request.ossprefix
        if not UtilClient.is_unset(request.ossregion_id):
            query['OSSRegionId'] = request.ossregion_id
        if not UtilClient.is_unset(request.role_name):
            query['RoleName'] = request.role_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ExportImage',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ExportImageResponse(),
            self.call_api(params, req, runtime)
        )

    async def export_image_with_options_async(
        self,
        request: ens_20171110_models.ExportImageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ExportImageResponse:
        """
        @summary Exports a custom image to an Object Storage Service (OSS) bucket in the same region.
        
        @param request: ExportImageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExportImageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.ossbucket):
            query['OSSBucket'] = request.ossbucket
        if not UtilClient.is_unset(request.ossprefix):
            query['OSSPrefix'] = request.ossprefix
        if not UtilClient.is_unset(request.ossregion_id):
            query['OSSRegionId'] = request.ossregion_id
        if not UtilClient.is_unset(request.role_name):
            query['RoleName'] = request.role_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ExportImage',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ExportImageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def export_image(
        self,
        request: ens_20171110_models.ExportImageRequest,
    ) -> ens_20171110_models.ExportImageResponse:
        """
        @summary Exports a custom image to an Object Storage Service (OSS) bucket in the same region.
        
        @param request: ExportImageRequest
        @return: ExportImageResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.export_image_with_options(request, runtime)

    async def export_image_async(
        self,
        request: ens_20171110_models.ExportImageRequest,
    ) -> ens_20171110_models.ExportImageResponse:
        """
        @summary Exports a custom image to an Object Storage Service (OSS) bucket in the same region.
        
        @param request: ExportImageRequest
        @return: ExportImageResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.export_image_with_options_async(request, runtime)

    def export_measurement_data_with_options(
        self,
        request: ens_20171110_models.ExportMeasurementDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ExportMeasurementDataResponse:
        """
        @summary Exports the metering data within a specific time range.
        
        @param request: ExportMeasurementDataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExportMeasurementDataResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_date):
            query['EndDate'] = request.end_date
        if not UtilClient.is_unset(request.start_date):
            query['StartDate'] = request.start_date
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ExportMeasurementData',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ExportMeasurementDataResponse(),
            self.call_api(params, req, runtime)
        )

    async def export_measurement_data_with_options_async(
        self,
        request: ens_20171110_models.ExportMeasurementDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ExportMeasurementDataResponse:
        """
        @summary Exports the metering data within a specific time range.
        
        @param request: ExportMeasurementDataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExportMeasurementDataResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_date):
            query['EndDate'] = request.end_date
        if not UtilClient.is_unset(request.start_date):
            query['StartDate'] = request.start_date
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ExportMeasurementData',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ExportMeasurementDataResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def export_measurement_data(
        self,
        request: ens_20171110_models.ExportMeasurementDataRequest,
    ) -> ens_20171110_models.ExportMeasurementDataResponse:
        """
        @summary Exports the metering data within a specific time range.
        
        @param request: ExportMeasurementDataRequest
        @return: ExportMeasurementDataResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.export_measurement_data_with_options(request, runtime)

    async def export_measurement_data_async(
        self,
        request: ens_20171110_models.ExportMeasurementDataRequest,
    ) -> ens_20171110_models.ExportMeasurementDataResponse:
        """
        @summary Exports the metering data within a specific time range.
        
        @param request: ExportMeasurementDataRequest
        @return: ExportMeasurementDataResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.export_measurement_data_with_options_async(request, runtime)

    def get_bucket_acl_with_options(
        self,
        request: ens_20171110_models.GetBucketAclRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.GetBucketAclResponse:
        """
        @summary Queries the access control list (ACL) of a bucket.
        
        @param request: GetBucketAclRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetBucketAclResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bucket_name):
            query['BucketName'] = request.bucket_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetBucketAcl',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.GetBucketAclResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_bucket_acl_with_options_async(
        self,
        request: ens_20171110_models.GetBucketAclRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.GetBucketAclResponse:
        """
        @summary Queries the access control list (ACL) of a bucket.
        
        @param request: GetBucketAclRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetBucketAclResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bucket_name):
            query['BucketName'] = request.bucket_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetBucketAcl',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.GetBucketAclResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_bucket_acl(
        self,
        request: ens_20171110_models.GetBucketAclRequest,
    ) -> ens_20171110_models.GetBucketAclResponse:
        """
        @summary Queries the access control list (ACL) of a bucket.
        
        @param request: GetBucketAclRequest
        @return: GetBucketAclResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_bucket_acl_with_options(request, runtime)

    async def get_bucket_acl_async(
        self,
        request: ens_20171110_models.GetBucketAclRequest,
    ) -> ens_20171110_models.GetBucketAclResponse:
        """
        @summary Queries the access control list (ACL) of a bucket.
        
        @param request: GetBucketAclRequest
        @return: GetBucketAclResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_bucket_acl_with_options_async(request, runtime)

    def get_bucket_info_with_options(
        self,
        request: ens_20171110_models.GetBucketInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.GetBucketInfoResponse:
        """
        @summary Queries the detailed information about a bucket.
        
        @param request: GetBucketInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetBucketInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bucket_name):
            query['BucketName'] = request.bucket_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetBucketInfo',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.GetBucketInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_bucket_info_with_options_async(
        self,
        request: ens_20171110_models.GetBucketInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.GetBucketInfoResponse:
        """
        @summary Queries the detailed information about a bucket.
        
        @param request: GetBucketInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetBucketInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bucket_name):
            query['BucketName'] = request.bucket_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetBucketInfo',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.GetBucketInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_bucket_info(
        self,
        request: ens_20171110_models.GetBucketInfoRequest,
    ) -> ens_20171110_models.GetBucketInfoResponse:
        """
        @summary Queries the detailed information about a bucket.
        
        @param request: GetBucketInfoRequest
        @return: GetBucketInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_bucket_info_with_options(request, runtime)

    async def get_bucket_info_async(
        self,
        request: ens_20171110_models.GetBucketInfoRequest,
    ) -> ens_20171110_models.GetBucketInfoResponse:
        """
        @summary Queries the detailed information about a bucket.
        
        @param request: GetBucketInfoRequest
        @return: GetBucketInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_bucket_info_with_options_async(request, runtime)

    def get_bucket_lifecycle_with_options(
        self,
        request: ens_20171110_models.GetBucketLifecycleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.GetBucketLifecycleResponse:
        """
        @summary Queries lifecycle rules.
        
        @param request: GetBucketLifecycleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetBucketLifecycleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bucket_name):
            query['BucketName'] = request.bucket_name
        if not UtilClient.is_unset(request.rule_id):
            query['RuleId'] = request.rule_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetBucketLifecycle',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.GetBucketLifecycleResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_bucket_lifecycle_with_options_async(
        self,
        request: ens_20171110_models.GetBucketLifecycleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.GetBucketLifecycleResponse:
        """
        @summary Queries lifecycle rules.
        
        @param request: GetBucketLifecycleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetBucketLifecycleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bucket_name):
            query['BucketName'] = request.bucket_name
        if not UtilClient.is_unset(request.rule_id):
            query['RuleId'] = request.rule_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetBucketLifecycle',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.GetBucketLifecycleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_bucket_lifecycle(
        self,
        request: ens_20171110_models.GetBucketLifecycleRequest,
    ) -> ens_20171110_models.GetBucketLifecycleResponse:
        """
        @summary Queries lifecycle rules.
        
        @param request: GetBucketLifecycleRequest
        @return: GetBucketLifecycleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_bucket_lifecycle_with_options(request, runtime)

    async def get_bucket_lifecycle_async(
        self,
        request: ens_20171110_models.GetBucketLifecycleRequest,
    ) -> ens_20171110_models.GetBucketLifecycleResponse:
        """
        @summary Queries lifecycle rules.
        
        @param request: GetBucketLifecycleRequest
        @return: GetBucketLifecycleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_bucket_lifecycle_with_options_async(request, runtime)

    def get_oss_storage_and_acc_by_buckets_with_options(
        self,
        request: ens_20171110_models.GetOssStorageAndAccByBucketsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.GetOssStorageAndAccByBucketsResponse:
        """
        @summary Queries the storage usage in the previous billing cycle and the cumulative number of calls in this month.
        
        @param request: GetOssStorageAndAccByBucketsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetOssStorageAndAccByBucketsResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetOssStorageAndAccByBuckets',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.GetOssStorageAndAccByBucketsResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_oss_storage_and_acc_by_buckets_with_options_async(
        self,
        request: ens_20171110_models.GetOssStorageAndAccByBucketsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.GetOssStorageAndAccByBucketsResponse:
        """
        @summary Queries the storage usage in the previous billing cycle and the cumulative number of calls in this month.
        
        @param request: GetOssStorageAndAccByBucketsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetOssStorageAndAccByBucketsResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetOssStorageAndAccByBuckets',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.GetOssStorageAndAccByBucketsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_oss_storage_and_acc_by_buckets(
        self,
        request: ens_20171110_models.GetOssStorageAndAccByBucketsRequest,
    ) -> ens_20171110_models.GetOssStorageAndAccByBucketsResponse:
        """
        @summary Queries the storage usage in the previous billing cycle and the cumulative number of calls in this month.
        
        @param request: GetOssStorageAndAccByBucketsRequest
        @return: GetOssStorageAndAccByBucketsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_oss_storage_and_acc_by_buckets_with_options(request, runtime)

    async def get_oss_storage_and_acc_by_buckets_async(
        self,
        request: ens_20171110_models.GetOssStorageAndAccByBucketsRequest,
    ) -> ens_20171110_models.GetOssStorageAndAccByBucketsResponse:
        """
        @summary Queries the storage usage in the previous billing cycle and the cumulative number of calls in this month.
        
        @param request: GetOssStorageAndAccByBucketsRequest
        @return: GetOssStorageAndAccByBucketsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_oss_storage_and_acc_by_buckets_with_options_async(request, runtime)

    def get_oss_usage_data_with_options(
        self,
        request: ens_20171110_models.GetOssUsageDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.GetOssUsageDataResponse:
        """
        @summary Queries the storage and bandwidth usage within a specific time range.
        
        @description The query and aggregation granularity of bandwidth and storage usage cannot exceed one day. Data aggregation is to collect the maximum values of usage data within a period of time.
        
        @param request: GetOssUsageDataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetOssUsageDataResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetOssUsageData',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.GetOssUsageDataResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_oss_usage_data_with_options_async(
        self,
        request: ens_20171110_models.GetOssUsageDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.GetOssUsageDataResponse:
        """
        @summary Queries the storage and bandwidth usage within a specific time range.
        
        @description The query and aggregation granularity of bandwidth and storage usage cannot exceed one day. Data aggregation is to collect the maximum values of usage data within a period of time.
        
        @param request: GetOssUsageDataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: GetOssUsageDataResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetOssUsageData',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.GetOssUsageDataResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_oss_usage_data(
        self,
        request: ens_20171110_models.GetOssUsageDataRequest,
    ) -> ens_20171110_models.GetOssUsageDataResponse:
        """
        @summary Queries the storage and bandwidth usage within a specific time range.
        
        @description The query and aggregation granularity of bandwidth and storage usage cannot exceed one day. Data aggregation is to collect the maximum values of usage data within a period of time.
        
        @param request: GetOssUsageDataRequest
        @return: GetOssUsageDataResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.get_oss_usage_data_with_options(request, runtime)

    async def get_oss_usage_data_async(
        self,
        request: ens_20171110_models.GetOssUsageDataRequest,
    ) -> ens_20171110_models.GetOssUsageDataResponse:
        """
        @summary Queries the storage and bandwidth usage within a specific time range.
        
        @description The query and aggregation granularity of bandwidth and storage usage cannot exceed one day. Data aggregation is to collect the maximum values of usage data within a period of time.
        
        @param request: GetOssUsageDataRequest
        @return: GetOssUsageDataResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.get_oss_usage_data_with_options_async(request, runtime)

    def import_image_with_options(
        self,
        tmp_req: ens_20171110_models.ImportImageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ImportImageResponse:
        """
        @summary 调用ImportImage导入一份您的镜像文件到云服务器。
        
        @param tmp_req: ImportImageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ImportImageResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.ImportImageShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.disk_device_mapping):
            request.disk_device_mapping_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.disk_device_mapping, 'DiskDeviceMapping', 'json')
        query = {}
        if not UtilClient.is_unset(request.architecture):
            query['Architecture'] = request.architecture
        if not UtilClient.is_unset(request.compute_type):
            query['ComputeType'] = request.compute_type
        if not UtilClient.is_unset(request.disk_device_mapping_shrink):
            query['DiskDeviceMapping'] = request.disk_device_mapping_shrink
        if not UtilClient.is_unset(request.image_format):
            query['ImageFormat'] = request.image_format
        if not UtilClient.is_unset(request.image_name):
            query['ImageName'] = request.image_name
        if not UtilClient.is_unset(request.license_type):
            query['LicenseType'] = request.license_type
        if not UtilClient.is_unset(request.ossbucket):
            query['OSSBucket'] = request.ossbucket
        if not UtilClient.is_unset(request.ossobject):
            query['OSSObject'] = request.ossobject
        if not UtilClient.is_unset(request.ossregion):
            query['OSSRegion'] = request.ossregion
        if not UtilClient.is_unset(request.ostype):
            query['OSType'] = request.ostype
        if not UtilClient.is_unset(request.osversion):
            query['OSVersion'] = request.osversion
        if not UtilClient.is_unset(request.platform):
            query['Platform'] = request.platform
        if not UtilClient.is_unset(request.target_ossregion_id):
            query['TargetOSSRegionId'] = request.target_ossregion_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ImportImage',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ImportImageResponse(),
            self.call_api(params, req, runtime)
        )

    async def import_image_with_options_async(
        self,
        tmp_req: ens_20171110_models.ImportImageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ImportImageResponse:
        """
        @summary 调用ImportImage导入一份您的镜像文件到云服务器。
        
        @param tmp_req: ImportImageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ImportImageResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.ImportImageShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.disk_device_mapping):
            request.disk_device_mapping_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.disk_device_mapping, 'DiskDeviceMapping', 'json')
        query = {}
        if not UtilClient.is_unset(request.architecture):
            query['Architecture'] = request.architecture
        if not UtilClient.is_unset(request.compute_type):
            query['ComputeType'] = request.compute_type
        if not UtilClient.is_unset(request.disk_device_mapping_shrink):
            query['DiskDeviceMapping'] = request.disk_device_mapping_shrink
        if not UtilClient.is_unset(request.image_format):
            query['ImageFormat'] = request.image_format
        if not UtilClient.is_unset(request.image_name):
            query['ImageName'] = request.image_name
        if not UtilClient.is_unset(request.license_type):
            query['LicenseType'] = request.license_type
        if not UtilClient.is_unset(request.ossbucket):
            query['OSSBucket'] = request.ossbucket
        if not UtilClient.is_unset(request.ossobject):
            query['OSSObject'] = request.ossobject
        if not UtilClient.is_unset(request.ossregion):
            query['OSSRegion'] = request.ossregion
        if not UtilClient.is_unset(request.ostype):
            query['OSType'] = request.ostype
        if not UtilClient.is_unset(request.osversion):
            query['OSVersion'] = request.osversion
        if not UtilClient.is_unset(request.platform):
            query['Platform'] = request.platform
        if not UtilClient.is_unset(request.target_ossregion_id):
            query['TargetOSSRegionId'] = request.target_ossregion_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ImportImage',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ImportImageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def import_image(
        self,
        request: ens_20171110_models.ImportImageRequest,
    ) -> ens_20171110_models.ImportImageResponse:
        """
        @summary 调用ImportImage导入一份您的镜像文件到云服务器。
        
        @param request: ImportImageRequest
        @return: ImportImageResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.import_image_with_options(request, runtime)

    async def import_image_async(
        self,
        request: ens_20171110_models.ImportImageRequest,
    ) -> ens_20171110_models.ImportImageResponse:
        """
        @summary 调用ImportImage导入一份您的镜像文件到云服务器。
        
        @param request: ImportImageRequest
        @return: ImportImageResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.import_image_with_options_async(request, runtime)

    def import_key_pair_with_options(
        self,
        request: ens_20171110_models.ImportKeyPairRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ImportKeyPairResponse:
        """
        @summary Imports the public key of a Rivest–Shamir–Adleman (RSA)-encrypted key pair that is generated by a third-party tool.
        
        @description    After the key pair is imported, ENS stores the public key. You must securely store the private key.
        The key pair can be only in the ssh-rsa format.
        
        @param request: ImportKeyPairRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ImportKeyPairResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.key_pair_name):
            query['KeyPairName'] = request.key_pair_name
        if not UtilClient.is_unset(request.public_key_body):
            query['PublicKeyBody'] = request.public_key_body
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ImportKeyPair',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ImportKeyPairResponse(),
            self.call_api(params, req, runtime)
        )

    async def import_key_pair_with_options_async(
        self,
        request: ens_20171110_models.ImportKeyPairRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ImportKeyPairResponse:
        """
        @summary Imports the public key of a Rivest–Shamir–Adleman (RSA)-encrypted key pair that is generated by a third-party tool.
        
        @description    After the key pair is imported, ENS stores the public key. You must securely store the private key.
        The key pair can be only in the ssh-rsa format.
        
        @param request: ImportKeyPairRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ImportKeyPairResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.key_pair_name):
            query['KeyPairName'] = request.key_pair_name
        if not UtilClient.is_unset(request.public_key_body):
            query['PublicKeyBody'] = request.public_key_body
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ImportKeyPair',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ImportKeyPairResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def import_key_pair(
        self,
        request: ens_20171110_models.ImportKeyPairRequest,
    ) -> ens_20171110_models.ImportKeyPairResponse:
        """
        @summary Imports the public key of a Rivest–Shamir–Adleman (RSA)-encrypted key pair that is generated by a third-party tool.
        
        @description    After the key pair is imported, ENS stores the public key. You must securely store the private key.
        The key pair can be only in the ssh-rsa format.
        
        @param request: ImportKeyPairRequest
        @return: ImportKeyPairResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.import_key_pair_with_options(request, runtime)

    async def import_key_pair_async(
        self,
        request: ens_20171110_models.ImportKeyPairRequest,
    ) -> ens_20171110_models.ImportKeyPairResponse:
        """
        @summary Imports the public key of a Rivest–Shamir–Adleman (RSA)-encrypted key pair that is generated by a third-party tool.
        
        @description    After the key pair is imported, ENS stores the public key. You must securely store the private key.
        The key pair can be only in the ssh-rsa format.
        
        @param request: ImportKeyPairRequest
        @return: ImportKeyPairResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.import_key_pair_with_options_async(request, runtime)

    def join_public_ips_to_epn_instance_with_options(
        self,
        request: ens_20171110_models.JoinPublicIpsToEpnInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.JoinPublicIpsToEpnInstanceResponse:
        """
        @summary Assigns public IP addresses to an EPN instance.
        
        @param request: JoinPublicIpsToEpnInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: JoinPublicIpsToEpnInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.epninstance_id):
            query['EPNInstanceId'] = request.epninstance_id
        if not UtilClient.is_unset(request.instance_infos):
            query['InstanceInfos'] = request.instance_infos
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='JoinPublicIpsToEpnInstance',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.JoinPublicIpsToEpnInstanceResponse(),
            self.call_api(params, req, runtime)
        )

    async def join_public_ips_to_epn_instance_with_options_async(
        self,
        request: ens_20171110_models.JoinPublicIpsToEpnInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.JoinPublicIpsToEpnInstanceResponse:
        """
        @summary Assigns public IP addresses to an EPN instance.
        
        @param request: JoinPublicIpsToEpnInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: JoinPublicIpsToEpnInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.epninstance_id):
            query['EPNInstanceId'] = request.epninstance_id
        if not UtilClient.is_unset(request.instance_infos):
            query['InstanceInfos'] = request.instance_infos
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='JoinPublicIpsToEpnInstance',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.JoinPublicIpsToEpnInstanceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def join_public_ips_to_epn_instance(
        self,
        request: ens_20171110_models.JoinPublicIpsToEpnInstanceRequest,
    ) -> ens_20171110_models.JoinPublicIpsToEpnInstanceResponse:
        """
        @summary Assigns public IP addresses to an EPN instance.
        
        @param request: JoinPublicIpsToEpnInstanceRequest
        @return: JoinPublicIpsToEpnInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.join_public_ips_to_epn_instance_with_options(request, runtime)

    async def join_public_ips_to_epn_instance_async(
        self,
        request: ens_20171110_models.JoinPublicIpsToEpnInstanceRequest,
    ) -> ens_20171110_models.JoinPublicIpsToEpnInstanceResponse:
        """
        @summary Assigns public IP addresses to an EPN instance.
        
        @param request: JoinPublicIpsToEpnInstanceRequest
        @return: JoinPublicIpsToEpnInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.join_public_ips_to_epn_instance_with_options_async(request, runtime)

    def join_security_group_with_options(
        self,
        request: ens_20171110_models.JoinSecurityGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.JoinSecurityGroupResponse:
        """
        @summary Adds an Edge Node Service (ENS) instance to a specified security group.
        
        @description Before you call this operation to add an instance to a security group, make sure that the instance is in the Stopped or Running state.
        
        @param request: JoinSecurityGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: JoinSecurityGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.network_interface_id):
            query['NetworkInterfaceId'] = request.network_interface_id
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='JoinSecurityGroup',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.JoinSecurityGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def join_security_group_with_options_async(
        self,
        request: ens_20171110_models.JoinSecurityGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.JoinSecurityGroupResponse:
        """
        @summary Adds an Edge Node Service (ENS) instance to a specified security group.
        
        @description Before you call this operation to add an instance to a security group, make sure that the instance is in the Stopped or Running state.
        
        @param request: JoinSecurityGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: JoinSecurityGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.network_interface_id):
            query['NetworkInterfaceId'] = request.network_interface_id
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='JoinSecurityGroup',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.JoinSecurityGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def join_security_group(
        self,
        request: ens_20171110_models.JoinSecurityGroupRequest,
    ) -> ens_20171110_models.JoinSecurityGroupResponse:
        """
        @summary Adds an Edge Node Service (ENS) instance to a specified security group.
        
        @description Before you call this operation to add an instance to a security group, make sure that the instance is in the Stopped or Running state.
        
        @param request: JoinSecurityGroupRequest
        @return: JoinSecurityGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.join_security_group_with_options(request, runtime)

    async def join_security_group_async(
        self,
        request: ens_20171110_models.JoinSecurityGroupRequest,
    ) -> ens_20171110_models.JoinSecurityGroupResponse:
        """
        @summary Adds an Edge Node Service (ENS) instance to a specified security group.
        
        @description Before you call this operation to add an instance to a security group, make sure that the instance is in the Stopped or Running state.
        
        @param request: JoinSecurityGroupRequest
        @return: JoinSecurityGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.join_security_group_with_options_async(request, runtime)

    def join_vswitches_to_epn_instance_with_options(
        self,
        request: ens_20171110_models.JoinVSwitchesToEpnInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.JoinVSwitchesToEpnInstanceResponse:
        """
        @summary Performs networking.
        
        @description For the Internal Connection mode and the Intelligent Acceleration and Internal Connection mode, instances of the vSwitch take effect automatically. You do not need to manually add instances. For public connections such as intelligent acceleration, you need to call an operation to manually add the instances to Internet-facing instances.
        
        @param request: JoinVSwitchesToEpnInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: JoinVSwitchesToEpnInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.epninstance_id):
            query['EPNInstanceId'] = request.epninstance_id
        if not UtilClient.is_unset(request.v_switches_info):
            query['VSwitchesInfo'] = request.v_switches_info
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='JoinVSwitchesToEpnInstance',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.JoinVSwitchesToEpnInstanceResponse(),
            self.call_api(params, req, runtime)
        )

    async def join_vswitches_to_epn_instance_with_options_async(
        self,
        request: ens_20171110_models.JoinVSwitchesToEpnInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.JoinVSwitchesToEpnInstanceResponse:
        """
        @summary Performs networking.
        
        @description For the Internal Connection mode and the Intelligent Acceleration and Internal Connection mode, instances of the vSwitch take effect automatically. You do not need to manually add instances. For public connections such as intelligent acceleration, you need to call an operation to manually add the instances to Internet-facing instances.
        
        @param request: JoinVSwitchesToEpnInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: JoinVSwitchesToEpnInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.epninstance_id):
            query['EPNInstanceId'] = request.epninstance_id
        if not UtilClient.is_unset(request.v_switches_info):
            query['VSwitchesInfo'] = request.v_switches_info
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='JoinVSwitchesToEpnInstance',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.JoinVSwitchesToEpnInstanceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def join_vswitches_to_epn_instance(
        self,
        request: ens_20171110_models.JoinVSwitchesToEpnInstanceRequest,
    ) -> ens_20171110_models.JoinVSwitchesToEpnInstanceResponse:
        """
        @summary Performs networking.
        
        @description For the Internal Connection mode and the Intelligent Acceleration and Internal Connection mode, instances of the vSwitch take effect automatically. You do not need to manually add instances. For public connections such as intelligent acceleration, you need to call an operation to manually add the instances to Internet-facing instances.
        
        @param request: JoinVSwitchesToEpnInstanceRequest
        @return: JoinVSwitchesToEpnInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.join_vswitches_to_epn_instance_with_options(request, runtime)

    async def join_vswitches_to_epn_instance_async(
        self,
        request: ens_20171110_models.JoinVSwitchesToEpnInstanceRequest,
    ) -> ens_20171110_models.JoinVSwitchesToEpnInstanceResponse:
        """
        @summary Performs networking.
        
        @description For the Internal Connection mode and the Intelligent Acceleration and Internal Connection mode, instances of the vSwitch take effect automatically. You do not need to manually add instances. For public connections such as intelligent acceleration, you need to call an operation to manually add the instances to Internet-facing instances.
        
        @param request: JoinVSwitchesToEpnInstanceRequest
        @return: JoinVSwitchesToEpnInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.join_vswitches_to_epn_instance_with_options_async(request, runtime)

    def leave_security_group_with_options(
        self,
        request: ens_20171110_models.LeaveSecurityGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.LeaveSecurityGroupResponse:
        """
        @summary Removes an instance from a security group.
        
        @description Before you remove an instance from a security group, the instance must be in the Stopped or Running state.
        
        @param request: LeaveSecurityGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: LeaveSecurityGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.network_interface_id):
            query['NetworkInterfaceId'] = request.network_interface_id
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='LeaveSecurityGroup',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.LeaveSecurityGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def leave_security_group_with_options_async(
        self,
        request: ens_20171110_models.LeaveSecurityGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.LeaveSecurityGroupResponse:
        """
        @summary Removes an instance from a security group.
        
        @description Before you remove an instance from a security group, the instance must be in the Stopped or Running state.
        
        @param request: LeaveSecurityGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: LeaveSecurityGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.network_interface_id):
            query['NetworkInterfaceId'] = request.network_interface_id
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='LeaveSecurityGroup',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.LeaveSecurityGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def leave_security_group(
        self,
        request: ens_20171110_models.LeaveSecurityGroupRequest,
    ) -> ens_20171110_models.LeaveSecurityGroupResponse:
        """
        @summary Removes an instance from a security group.
        
        @description Before you remove an instance from a security group, the instance must be in the Stopped or Running state.
        
        @param request: LeaveSecurityGroupRequest
        @return: LeaveSecurityGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.leave_security_group_with_options(request, runtime)

    async def leave_security_group_async(
        self,
        request: ens_20171110_models.LeaveSecurityGroupRequest,
    ) -> ens_20171110_models.LeaveSecurityGroupResponse:
        """
        @summary Removes an instance from a security group.
        
        @description Before you remove an instance from a security group, the instance must be in the Stopped or Running state.
        
        @param request: LeaveSecurityGroupRequest
        @return: LeaveSecurityGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.leave_security_group_with_options_async(request, runtime)

    def list_applications_with_options(
        self,
        request: ens_20171110_models.ListApplicationsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ListApplicationsResponse:
        """
        @summary Queries the created applications.
        
        @param request: ListApplicationsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListApplicationsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_versions):
            query['AppVersions'] = request.app_versions
        if not UtilClient.is_unset(request.cluster_names):
            query['ClusterNames'] = request.cluster_names
        if not UtilClient.is_unset(request.level):
            query['Level'] = request.level
        if not UtilClient.is_unset(request.max_date):
            query['MaxDate'] = request.max_date
        if not UtilClient.is_unset(request.min_date):
            query['MinDate'] = request.min_date
        if not UtilClient.is_unset(request.out_app_info_params):
            query['OutAppInfoParams'] = request.out_app_info_params
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListApplications',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ListApplicationsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_applications_with_options_async(
        self,
        request: ens_20171110_models.ListApplicationsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ListApplicationsResponse:
        """
        @summary Queries the created applications.
        
        @param request: ListApplicationsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListApplicationsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_versions):
            query['AppVersions'] = request.app_versions
        if not UtilClient.is_unset(request.cluster_names):
            query['ClusterNames'] = request.cluster_names
        if not UtilClient.is_unset(request.level):
            query['Level'] = request.level
        if not UtilClient.is_unset(request.max_date):
            query['MaxDate'] = request.max_date
        if not UtilClient.is_unset(request.min_date):
            query['MinDate'] = request.min_date
        if not UtilClient.is_unset(request.out_app_info_params):
            query['OutAppInfoParams'] = request.out_app_info_params
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListApplications',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ListApplicationsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_applications(
        self,
        request: ens_20171110_models.ListApplicationsRequest,
    ) -> ens_20171110_models.ListApplicationsResponse:
        """
        @summary Queries the created applications.
        
        @param request: ListApplicationsRequest
        @return: ListApplicationsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_applications_with_options(request, runtime)

    async def list_applications_async(
        self,
        request: ens_20171110_models.ListApplicationsRequest,
    ) -> ens_20171110_models.ListApplicationsResponse:
        """
        @summary Queries the created applications.
        
        @param request: ListApplicationsRequest
        @return: ListApplicationsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_applications_with_options_async(request, runtime)

    def list_buckets_with_options(
        self,
        request: ens_20171110_models.ListBucketsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ListBucketsResponse:
        """
        @summary Queries all buckets of a user.
        
        @param request: ListBucketsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListBucketsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.prefix):
            query['Prefix'] = request.prefix
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListBuckets',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ListBucketsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_buckets_with_options_async(
        self,
        request: ens_20171110_models.ListBucketsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ListBucketsResponse:
        """
        @summary Queries all buckets of a user.
        
        @param request: ListBucketsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListBucketsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.prefix):
            query['Prefix'] = request.prefix
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListBuckets',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ListBucketsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_buckets(
        self,
        request: ens_20171110_models.ListBucketsRequest,
    ) -> ens_20171110_models.ListBucketsResponse:
        """
        @summary Queries all buckets of a user.
        
        @param request: ListBucketsRequest
        @return: ListBucketsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_buckets_with_options(request, runtime)

    async def list_buckets_async(
        self,
        request: ens_20171110_models.ListBucketsRequest,
    ) -> ens_20171110_models.ListBucketsResponse:
        """
        @summary Queries all buckets of a user.
        
        @param request: ListBucketsRequest
        @return: ListBucketsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_buckets_with_options_async(request, runtime)

    def list_objects_with_options(
        self,
        request: ens_20171110_models.ListObjectsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ListObjectsResponse:
        """
        @summary Queries the information about all objects in a bucket.
        
        @param request: ListObjectsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListObjectsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bucket_name):
            query['BucketName'] = request.bucket_name
        if not UtilClient.is_unset(request.continuation_token):
            query['ContinuationToken'] = request.continuation_token
        if not UtilClient.is_unset(request.encoding_type):
            query['EncodingType'] = request.encoding_type
        if not UtilClient.is_unset(request.marker):
            query['Marker'] = request.marker
        if not UtilClient.is_unset(request.max_keys):
            query['MaxKeys'] = request.max_keys
        if not UtilClient.is_unset(request.prefix):
            query['Prefix'] = request.prefix
        if not UtilClient.is_unset(request.start_after):
            query['StartAfter'] = request.start_after
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListObjects',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ListObjectsResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_objects_with_options_async(
        self,
        request: ens_20171110_models.ListObjectsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ListObjectsResponse:
        """
        @summary Queries the information about all objects in a bucket.
        
        @param request: ListObjectsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListObjectsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bucket_name):
            query['BucketName'] = request.bucket_name
        if not UtilClient.is_unset(request.continuation_token):
            query['ContinuationToken'] = request.continuation_token
        if not UtilClient.is_unset(request.encoding_type):
            query['EncodingType'] = request.encoding_type
        if not UtilClient.is_unset(request.marker):
            query['Marker'] = request.marker
        if not UtilClient.is_unset(request.max_keys):
            query['MaxKeys'] = request.max_keys
        if not UtilClient.is_unset(request.prefix):
            query['Prefix'] = request.prefix
        if not UtilClient.is_unset(request.start_after):
            query['StartAfter'] = request.start_after
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListObjects',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ListObjectsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_objects(
        self,
        request: ens_20171110_models.ListObjectsRequest,
    ) -> ens_20171110_models.ListObjectsResponse:
        """
        @summary Queries the information about all objects in a bucket.
        
        @param request: ListObjectsRequest
        @return: ListObjectsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_objects_with_options(request, runtime)

    async def list_objects_async(
        self,
        request: ens_20171110_models.ListObjectsRequest,
    ) -> ens_20171110_models.ListObjectsResponse:
        """
        @summary Queries the information about all objects in a bucket.
        
        @param request: ListObjectsRequest
        @return: ListObjectsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_objects_with_options_async(request, runtime)

    def list_product_abilities_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ListProductAbilitiesResponse:
        """
        @summary 获取所有产品能力
        
        @param request: ListProductAbilitiesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListProductAbilitiesResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='ListProductAbilities',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ListProductAbilitiesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_product_abilities_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ListProductAbilitiesResponse:
        """
        @summary 获取所有产品能力
        
        @param request: ListProductAbilitiesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListProductAbilitiesResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='ListProductAbilities',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ListProductAbilitiesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_product_abilities(self) -> ens_20171110_models.ListProductAbilitiesResponse:
        """
        @summary 获取所有产品能力
        
        @return: ListProductAbilitiesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_product_abilities_with_options(runtime)

    async def list_product_abilities_async(self) -> ens_20171110_models.ListProductAbilitiesResponse:
        """
        @summary 获取所有产品能力
        
        @return: ListProductAbilitiesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_product_abilities_with_options_async(runtime)

    def list_tag_resources_with_options(
        self,
        request: ens_20171110_models.ListTagResourcesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ListTagResourcesResponse:
        """
        @summary Queries tags that are added to Edge Node Service (ENS) instances.
        
        @param request: ListTagResourcesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListTagResourcesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListTagResources',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ListTagResourcesResponse(),
            self.call_api(params, req, runtime)
        )

    async def list_tag_resources_with_options_async(
        self,
        request: ens_20171110_models.ListTagResourcesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ListTagResourcesResponse:
        """
        @summary Queries tags that are added to Edge Node Service (ENS) instances.
        
        @param request: ListTagResourcesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ListTagResourcesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ListTagResources',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ListTagResourcesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def list_tag_resources(
        self,
        request: ens_20171110_models.ListTagResourcesRequest,
    ) -> ens_20171110_models.ListTagResourcesResponse:
        """
        @summary Queries tags that are added to Edge Node Service (ENS) instances.
        
        @param request: ListTagResourcesRequest
        @return: ListTagResourcesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.list_tag_resources_with_options(request, runtime)

    async def list_tag_resources_async(
        self,
        request: ens_20171110_models.ListTagResourcesRequest,
    ) -> ens_20171110_models.ListTagResourcesResponse:
        """
        @summary Queries tags that are added to Edge Node Service (ENS) instances.
        
        @param request: ListTagResourcesRequest
        @return: ListTagResourcesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.list_tag_resources_with_options_async(request, runtime)

    def modify_ens_eip_address_attribute_with_options(
        self,
        request: ens_20171110_models.ModifyEnsEipAddressAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ModifyEnsEipAddressAttributeResponse:
        """
        @summary Modifies the name, description, and peak bandwidth of a specified elastic IP address (EIP).
        
        @param request: ModifyEnsEipAddressAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyEnsEipAddressAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.allocation_id):
            query['AllocationId'] = request.allocation_id
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyEnsEipAddressAttribute',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ModifyEnsEipAddressAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_ens_eip_address_attribute_with_options_async(
        self,
        request: ens_20171110_models.ModifyEnsEipAddressAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ModifyEnsEipAddressAttributeResponse:
        """
        @summary Modifies the name, description, and peak bandwidth of a specified elastic IP address (EIP).
        
        @param request: ModifyEnsEipAddressAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyEnsEipAddressAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.allocation_id):
            query['AllocationId'] = request.allocation_id
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyEnsEipAddressAttribute',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ModifyEnsEipAddressAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_ens_eip_address_attribute(
        self,
        request: ens_20171110_models.ModifyEnsEipAddressAttributeRequest,
    ) -> ens_20171110_models.ModifyEnsEipAddressAttributeResponse:
        """
        @summary Modifies the name, description, and peak bandwidth of a specified elastic IP address (EIP).
        
        @param request: ModifyEnsEipAddressAttributeRequest
        @return: ModifyEnsEipAddressAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_ens_eip_address_attribute_with_options(request, runtime)

    async def modify_ens_eip_address_attribute_async(
        self,
        request: ens_20171110_models.ModifyEnsEipAddressAttributeRequest,
    ) -> ens_20171110_models.ModifyEnsEipAddressAttributeResponse:
        """
        @summary Modifies the name, description, and peak bandwidth of a specified elastic IP address (EIP).
        
        @param request: ModifyEnsEipAddressAttributeRequest
        @return: ModifyEnsEipAddressAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_ens_eip_address_attribute_with_options_async(request, runtime)

    def modify_ens_route_entry_with_options(
        self,
        request: ens_20171110_models.ModifyEnsRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ModifyEnsRouteEntryResponse:
        """
        @summary 调用ModifyEnsRouteEntry接口修改自定义路由条目名称、描述。
        
        @param request: ModifyEnsRouteEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyEnsRouteEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.route_entry_id):
            query['RouteEntryId'] = request.route_entry_id
        if not UtilClient.is_unset(request.route_entry_name):
            query['RouteEntryName'] = request.route_entry_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyEnsRouteEntry',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ModifyEnsRouteEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_ens_route_entry_with_options_async(
        self,
        request: ens_20171110_models.ModifyEnsRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ModifyEnsRouteEntryResponse:
        """
        @summary 调用ModifyEnsRouteEntry接口修改自定义路由条目名称、描述。
        
        @param request: ModifyEnsRouteEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyEnsRouteEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.route_entry_id):
            query['RouteEntryId'] = request.route_entry_id
        if not UtilClient.is_unset(request.route_entry_name):
            query['RouteEntryName'] = request.route_entry_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyEnsRouteEntry',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ModifyEnsRouteEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_ens_route_entry(
        self,
        request: ens_20171110_models.ModifyEnsRouteEntryRequest,
    ) -> ens_20171110_models.ModifyEnsRouteEntryResponse:
        """
        @summary 调用ModifyEnsRouteEntry接口修改自定义路由条目名称、描述。
        
        @param request: ModifyEnsRouteEntryRequest
        @return: ModifyEnsRouteEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_ens_route_entry_with_options(request, runtime)

    async def modify_ens_route_entry_async(
        self,
        request: ens_20171110_models.ModifyEnsRouteEntryRequest,
    ) -> ens_20171110_models.ModifyEnsRouteEntryResponse:
        """
        @summary 调用ModifyEnsRouteEntry接口修改自定义路由条目名称、描述。
        
        @param request: ModifyEnsRouteEntryRequest
        @return: ModifyEnsRouteEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_ens_route_entry_with_options_async(request, runtime)

    def modify_epn_instance_with_options(
        self,
        request: ens_20171110_models.ModifyEpnInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ModifyEpnInstanceResponse:
        """
        @summary Modifies an Edge Private Network (EPN) instance.
        
        @param request: ModifyEpnInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyEpnInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.epninstance_id):
            query['EPNInstanceId'] = request.epninstance_id
        if not UtilClient.is_unset(request.epninstance_name):
            query['EPNInstanceName'] = request.epninstance_name
        if not UtilClient.is_unset(request.internet_max_bandwidth_out):
            query['InternetMaxBandwidthOut'] = request.internet_max_bandwidth_out
        if not UtilClient.is_unset(request.networking_model):
            query['NetworkingModel'] = request.networking_model
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyEpnInstance',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ModifyEpnInstanceResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_epn_instance_with_options_async(
        self,
        request: ens_20171110_models.ModifyEpnInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ModifyEpnInstanceResponse:
        """
        @summary Modifies an Edge Private Network (EPN) instance.
        
        @param request: ModifyEpnInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyEpnInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.epninstance_id):
            query['EPNInstanceId'] = request.epninstance_id
        if not UtilClient.is_unset(request.epninstance_name):
            query['EPNInstanceName'] = request.epninstance_name
        if not UtilClient.is_unset(request.internet_max_bandwidth_out):
            query['InternetMaxBandwidthOut'] = request.internet_max_bandwidth_out
        if not UtilClient.is_unset(request.networking_model):
            query['NetworkingModel'] = request.networking_model
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyEpnInstance',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ModifyEpnInstanceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_epn_instance(
        self,
        request: ens_20171110_models.ModifyEpnInstanceRequest,
    ) -> ens_20171110_models.ModifyEpnInstanceResponse:
        """
        @summary Modifies an Edge Private Network (EPN) instance.
        
        @param request: ModifyEpnInstanceRequest
        @return: ModifyEpnInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_epn_instance_with_options(request, runtime)

    async def modify_epn_instance_async(
        self,
        request: ens_20171110_models.ModifyEpnInstanceRequest,
    ) -> ens_20171110_models.ModifyEpnInstanceResponse:
        """
        @summary Modifies an Edge Private Network (EPN) instance.
        
        @param request: ModifyEpnInstanceRequest
        @return: ModifyEpnInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_epn_instance_with_options_async(request, runtime)

    def modify_file_system_with_options(
        self,
        request: ens_20171110_models.ModifyFileSystemRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ModifyFileSystemResponse:
        """
        @summary Modifies the description of a NAS file system.
        
        @param request: ModifyFileSystemRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyFileSystemResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.file_system_id):
            query['FileSystemId'] = request.file_system_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyFileSystem',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ModifyFileSystemResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_file_system_with_options_async(
        self,
        request: ens_20171110_models.ModifyFileSystemRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ModifyFileSystemResponse:
        """
        @summary Modifies the description of a NAS file system.
        
        @param request: ModifyFileSystemRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyFileSystemResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.ens_region_id):
            query['EnsRegionId'] = request.ens_region_id
        if not UtilClient.is_unset(request.file_system_id):
            query['FileSystemId'] = request.file_system_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyFileSystem',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ModifyFileSystemResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_file_system(
        self,
        request: ens_20171110_models.ModifyFileSystemRequest,
    ) -> ens_20171110_models.ModifyFileSystemResponse:
        """
        @summary Modifies the description of a NAS file system.
        
        @param request: ModifyFileSystemRequest
        @return: ModifyFileSystemResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_file_system_with_options(request, runtime)

    async def modify_file_system_async(
        self,
        request: ens_20171110_models.ModifyFileSystemRequest,
    ) -> ens_20171110_models.ModifyFileSystemResponse:
        """
        @summary Modifies the description of a NAS file system.
        
        @param request: ModifyFileSystemRequest
        @return: ModifyFileSystemResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_file_system_with_options_async(request, runtime)

    def modify_forward_entry_with_options(
        self,
        request: ens_20171110_models.ModifyForwardEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ModifyForwardEntryResponse:
        """
        @summary Modifies a Destination Network Address Translation (DNAT) rule.
        
        @param request: ModifyForwardEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyForwardEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.external_ip):
            query['ExternalIp'] = request.external_ip
        if not UtilClient.is_unset(request.external_port):
            query['ExternalPort'] = request.external_port
        if not UtilClient.is_unset(request.forward_entry_id):
            query['ForwardEntryId'] = request.forward_entry_id
        if not UtilClient.is_unset(request.forward_entry_name):
            query['ForwardEntryName'] = request.forward_entry_name
        if not UtilClient.is_unset(request.health_check_port):
            query['HealthCheckPort'] = request.health_check_port
        if not UtilClient.is_unset(request.internal_ip):
            query['InternalIp'] = request.internal_ip
        if not UtilClient.is_unset(request.internal_port):
            query['InternalPort'] = request.internal_port
        if not UtilClient.is_unset(request.ip_protocol):
            query['IpProtocol'] = request.ip_protocol
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyForwardEntry',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ModifyForwardEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_forward_entry_with_options_async(
        self,
        request: ens_20171110_models.ModifyForwardEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ModifyForwardEntryResponse:
        """
        @summary Modifies a Destination Network Address Translation (DNAT) rule.
        
        @param request: ModifyForwardEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyForwardEntryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.external_ip):
            query['ExternalIp'] = request.external_ip
        if not UtilClient.is_unset(request.external_port):
            query['ExternalPort'] = request.external_port
        if not UtilClient.is_unset(request.forward_entry_id):
            query['ForwardEntryId'] = request.forward_entry_id
        if not UtilClient.is_unset(request.forward_entry_name):
            query['ForwardEntryName'] = request.forward_entry_name
        if not UtilClient.is_unset(request.health_check_port):
            query['HealthCheckPort'] = request.health_check_port
        if not UtilClient.is_unset(request.internal_ip):
            query['InternalIp'] = request.internal_ip
        if not UtilClient.is_unset(request.internal_port):
            query['InternalPort'] = request.internal_port
        if not UtilClient.is_unset(request.ip_protocol):
            query['IpProtocol'] = request.ip_protocol
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyForwardEntry',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ModifyForwardEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_forward_entry(
        self,
        request: ens_20171110_models.ModifyForwardEntryRequest,
    ) -> ens_20171110_models.ModifyForwardEntryResponse:
        """
        @summary Modifies a Destination Network Address Translation (DNAT) rule.
        
        @param request: ModifyForwardEntryRequest
        @return: ModifyForwardEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_forward_entry_with_options(request, runtime)

    async def modify_forward_entry_async(
        self,
        request: ens_20171110_models.ModifyForwardEntryRequest,
    ) -> ens_20171110_models.ModifyForwardEntryResponse:
        """
        @summary Modifies a Destination Network Address Translation (DNAT) rule.
        
        @param request: ModifyForwardEntryRequest
        @return: ModifyForwardEntryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_forward_entry_with_options_async(request, runtime)

    def modify_ha_vip_attribute_with_options(
        self,
        request: ens_20171110_models.ModifyHaVipAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ModifyHaVipAttributeResponse:
        """
        @summary Modifies the name of a high-availability virtual IP address (HAVIP).
        
        @param request: ModifyHaVipAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyHaVipAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ha_vip_id):
            query['HaVipId'] = request.ha_vip_id
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyHaVipAttribute',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ModifyHaVipAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_ha_vip_attribute_with_options_async(
        self,
        request: ens_20171110_models.ModifyHaVipAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ModifyHaVipAttributeResponse:
        """
        @summary Modifies the name of a high-availability virtual IP address (HAVIP).
        
        @param request: ModifyHaVipAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyHaVipAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ha_vip_id):
            query['HaVipId'] = request.ha_vip_id
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyHaVipAttribute',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ModifyHaVipAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_ha_vip_attribute(
        self,
        request: ens_20171110_models.ModifyHaVipAttributeRequest,
    ) -> ens_20171110_models.ModifyHaVipAttributeResponse:
        """
        @summary Modifies the name of a high-availability virtual IP address (HAVIP).
        
        @param request: ModifyHaVipAttributeRequest
        @return: ModifyHaVipAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_ha_vip_attribute_with_options(request, runtime)

    async def modify_ha_vip_attribute_async(
        self,
        request: ens_20171110_models.ModifyHaVipAttributeRequest,
    ) -> ens_20171110_models.ModifyHaVipAttributeResponse:
        """
        @summary Modifies the name of a high-availability virtual IP address (HAVIP).
        
        @param request: ModifyHaVipAttributeRequest
        @return: ModifyHaVipAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_ha_vip_attribute_with_options_async(request, runtime)

    def modify_image_attribute_with_options(
        self,
        request: ens_20171110_models.ModifyImageAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ModifyImageAttributeResponse:
        """
        @summary Modifies the image attributes.
        
        @param request: ModifyImageAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyImageAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.image_name):
            query['ImageName'] = request.image_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyImageAttribute',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ModifyImageAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_image_attribute_with_options_async(
        self,
        request: ens_20171110_models.ModifyImageAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ModifyImageAttributeResponse:
        """
        @summary Modifies the image attributes.
        
        @param request: ModifyImageAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyImageAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.image_name):
            query['ImageName'] = request.image_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyImageAttribute',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ModifyImageAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_image_attribute(
        self,
        request: ens_20171110_models.ModifyImageAttributeRequest,
    ) -> ens_20171110_models.ModifyImageAttributeResponse:
        """
        @summary Modifies the image attributes.
        
        @param request: ModifyImageAttributeRequest
        @return: ModifyImageAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_image_attribute_with_options(request, runtime)

    async def modify_image_attribute_async(
        self,
        request: ens_20171110_models.ModifyImageAttributeRequest,
    ) -> ens_20171110_models.ModifyImageAttributeResponse:
        """
        @summary Modifies the image attributes.
        
        @param request: ModifyImageAttributeRequest
        @return: ModifyImageAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_image_attribute_with_options_async(request, runtime)

    def modify_image_share_permission_with_options(
        self,
        request: ens_20171110_models.ModifyImageSharePermissionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ModifyImageSharePermissionResponse:
        """
        @summary Shares or unshares an image.
        
        @param request: ModifyImageSharePermissionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyImageSharePermissionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.add_accounts):
            query['AddAccounts'] = request.add_accounts
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.remove_accounts):
            query['RemoveAccounts'] = request.remove_accounts
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyImageSharePermission',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ModifyImageSharePermissionResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_image_share_permission_with_options_async(
        self,
        request: ens_20171110_models.ModifyImageSharePermissionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ModifyImageSharePermissionResponse:
        """
        @summary Shares or unshares an image.
        
        @param request: ModifyImageSharePermissionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyImageSharePermissionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.add_accounts):
            query['AddAccounts'] = request.add_accounts
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.remove_accounts):
            query['RemoveAccounts'] = request.remove_accounts
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyImageSharePermission',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ModifyImageSharePermissionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_image_share_permission(
        self,
        request: ens_20171110_models.ModifyImageSharePermissionRequest,
    ) -> ens_20171110_models.ModifyImageSharePermissionResponse:
        """
        @summary Shares or unshares an image.
        
        @param request: ModifyImageSharePermissionRequest
        @return: ModifyImageSharePermissionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_image_share_permission_with_options(request, runtime)

    async def modify_image_share_permission_async(
        self,
        request: ens_20171110_models.ModifyImageSharePermissionRequest,
    ) -> ens_20171110_models.ModifyImageSharePermissionResponse:
        """
        @summary Shares or unshares an image.
        
        @param request: ModifyImageSharePermissionRequest
        @return: ModifyImageSharePermissionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_image_share_permission_with_options_async(request, runtime)

    def modify_instance_attribute_with_options(
        self,
        request: ens_20171110_models.ModifyInstanceAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ModifyInstanceAttributeResponse:
        """
        @summary Changes the attributes of an instance, such as the name and the password.
        
        @description    If an instance is in the Starting state, you cannot reset the password of the instance.
        When the instance is in the Running state, you cannot change the password of the instance.
        After resetting the password, you must Restart the instance in the ECS console or call the RebootInstance operation to validate the modifications. The restart operation within the instance does not validate the modifications.
        
        @param request: ModifyInstanceAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyInstanceAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.deletion_protection):
            query['DeletionProtection'] = request.deletion_protection
        if not UtilClient.is_unset(request.host_name):
            query['HostName'] = request.host_name
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instance_name):
            query['InstanceName'] = request.instance_name
        if not UtilClient.is_unset(request.password):
            query['Password'] = request.password
        if not UtilClient.is_unset(request.user_data):
            query['UserData'] = request.user_data
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyInstanceAttribute',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ModifyInstanceAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_instance_attribute_with_options_async(
        self,
        request: ens_20171110_models.ModifyInstanceAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ModifyInstanceAttributeResponse:
        """
        @summary Changes the attributes of an instance, such as the name and the password.
        
        @description    If an instance is in the Starting state, you cannot reset the password of the instance.
        When the instance is in the Running state, you cannot change the password of the instance.
        After resetting the password, you must Restart the instance in the ECS console or call the RebootInstance operation to validate the modifications. The restart operation within the instance does not validate the modifications.
        
        @param request: ModifyInstanceAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyInstanceAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.deletion_protection):
            query['DeletionProtection'] = request.deletion_protection
        if not UtilClient.is_unset(request.host_name):
            query['HostName'] = request.host_name
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instance_name):
            query['InstanceName'] = request.instance_name
        if not UtilClient.is_unset(request.password):
            query['Password'] = request.password
        if not UtilClient.is_unset(request.user_data):
            query['UserData'] = request.user_data
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyInstanceAttribute',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ModifyInstanceAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_instance_attribute(
        self,
        request: ens_20171110_models.ModifyInstanceAttributeRequest,
    ) -> ens_20171110_models.ModifyInstanceAttributeResponse:
        """
        @summary Changes the attributes of an instance, such as the name and the password.
        
        @description    If an instance is in the Starting state, you cannot reset the password of the instance.
        When the instance is in the Running state, you cannot change the password of the instance.
        After resetting the password, you must Restart the instance in the ECS console or call the RebootInstance operation to validate the modifications. The restart operation within the instance does not validate the modifications.
        
        @param request: ModifyInstanceAttributeRequest
        @return: ModifyInstanceAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_instance_attribute_with_options(request, runtime)

    async def modify_instance_attribute_async(
        self,
        request: ens_20171110_models.ModifyInstanceAttributeRequest,
    ) -> ens_20171110_models.ModifyInstanceAttributeResponse:
        """
        @summary Changes the attributes of an instance, such as the name and the password.
        
        @description    If an instance is in the Starting state, you cannot reset the password of the instance.
        When the instance is in the Running state, you cannot change the password of the instance.
        After resetting the password, you must Restart the instance in the ECS console or call the RebootInstance operation to validate the modifications. The restart operation within the instance does not validate the modifications.
        
        @param request: ModifyInstanceAttributeRequest
        @return: ModifyInstanceAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_instance_attribute_with_options_async(request, runtime)

    def modify_instance_auto_renew_attribute_with_options(
        self,
        request: ens_20171110_models.ModifyInstanceAutoRenewAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ModifyInstanceAutoRenewAttributeResponse:
        """
        @summary Configures auto-renewal for instances.
        
        @param request: ModifyInstanceAutoRenewAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyInstanceAutoRenewAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_renew):
            query['AutoRenew'] = request.auto_renew
        if not UtilClient.is_unset(request.duration):
            query['Duration'] = request.duration
        if not UtilClient.is_unset(request.instance_ids):
            query['InstanceIds'] = request.instance_ids
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.renewal_status):
            query['RenewalStatus'] = request.renewal_status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyInstanceAutoRenewAttribute',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ModifyInstanceAutoRenewAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_instance_auto_renew_attribute_with_options_async(
        self,
        request: ens_20171110_models.ModifyInstanceAutoRenewAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ModifyInstanceAutoRenewAttributeResponse:
        """
        @summary Configures auto-renewal for instances.
        
        @param request: ModifyInstanceAutoRenewAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyInstanceAutoRenewAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_renew):
            query['AutoRenew'] = request.auto_renew
        if not UtilClient.is_unset(request.duration):
            query['Duration'] = request.duration
        if not UtilClient.is_unset(request.instance_ids):
            query['InstanceIds'] = request.instance_ids
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.renewal_status):
            query['RenewalStatus'] = request.renewal_status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyInstanceAutoRenewAttribute',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ModifyInstanceAutoRenewAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_instance_auto_renew_attribute(
        self,
        request: ens_20171110_models.ModifyInstanceAutoRenewAttributeRequest,
    ) -> ens_20171110_models.ModifyInstanceAutoRenewAttributeResponse:
        """
        @summary Configures auto-renewal for instances.
        
        @param request: ModifyInstanceAutoRenewAttributeRequest
        @return: ModifyInstanceAutoRenewAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_instance_auto_renew_attribute_with_options(request, runtime)

    async def modify_instance_auto_renew_attribute_async(
        self,
        request: ens_20171110_models.ModifyInstanceAutoRenewAttributeRequest,
    ) -> ens_20171110_models.ModifyInstanceAutoRenewAttributeResponse:
        """
        @summary Configures auto-renewal for instances.
        
        @param request: ModifyInstanceAutoRenewAttributeRequest
        @return: ModifyInstanceAutoRenewAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_instance_auto_renew_attribute_with_options_async(request, runtime)

    def modify_instance_boot_configuration_with_options(
        self,
        request: ens_20171110_models.ModifyInstanceBootConfigurationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ModifyInstanceBootConfigurationResponse:
        """
        @summary 修改启动配置，只支持异构实例(PCFarm裸金属)。
        
        @param request: ModifyInstanceBootConfigurationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyInstanceBootConfigurationResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyInstanceBootConfiguration',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ModifyInstanceBootConfigurationResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_instance_boot_configuration_with_options_async(
        self,
        request: ens_20171110_models.ModifyInstanceBootConfigurationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ModifyInstanceBootConfigurationResponse:
        """
        @summary 修改启动配置，只支持异构实例(PCFarm裸金属)。
        
        @param request: ModifyInstanceBootConfigurationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyInstanceBootConfigurationResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyInstanceBootConfiguration',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ModifyInstanceBootConfigurationResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_instance_boot_configuration(
        self,
        request: ens_20171110_models.ModifyInstanceBootConfigurationRequest,
    ) -> ens_20171110_models.ModifyInstanceBootConfigurationResponse:
        """
        @summary 修改启动配置，只支持异构实例(PCFarm裸金属)。
        
        @param request: ModifyInstanceBootConfigurationRequest
        @return: ModifyInstanceBootConfigurationResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_instance_boot_configuration_with_options(request, runtime)

    async def modify_instance_boot_configuration_async(
        self,
        request: ens_20171110_models.ModifyInstanceBootConfigurationRequest,
    ) -> ens_20171110_models.ModifyInstanceBootConfigurationResponse:
        """
        @summary 修改启动配置，只支持异构实例(PCFarm裸金属)。
        
        @param request: ModifyInstanceBootConfigurationRequest
        @return: ModifyInstanceBootConfigurationResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_instance_boot_configuration_with_options_async(request, runtime)

    def modify_instance_charge_type_with_options(
        self,
        tmp_req: ens_20171110_models.ModifyInstanceChargeTypeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ModifyInstanceChargeTypeResponse:
        """
        @summary Changes the billing method of Edge Node Service (ENS) instances. You can switch between the pay-as-you-go and subscription billing methods for instances. You can also change the billing method for disks that you created with pay-as-you-go instances to subscription.
        
        @description Before you call this operation, make sure that you fully understand the billing methods and pricing of ENS.
        The instances must be in the Running or Stopped state, and you have no overdue payments for them.
        
        @param tmp_req: ModifyInstanceChargeTypeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyInstanceChargeTypeResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.ModifyInstanceChargeTypeShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.instance_ids):
            request.instance_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.instance_ids, 'InstanceIds', 'json')
        query = {}
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.auto_renew):
            query['AutoRenew'] = request.auto_renew
        if not UtilClient.is_unset(request.billing_cycle):
            query['BillingCycle'] = request.billing_cycle
        if not UtilClient.is_unset(request.include_data_disks):
            query['IncludeDataDisks'] = request.include_data_disks
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.instance_ids_shrink):
            query['InstanceIds'] = request.instance_ids_shrink
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyInstanceChargeType',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ModifyInstanceChargeTypeResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_instance_charge_type_with_options_async(
        self,
        tmp_req: ens_20171110_models.ModifyInstanceChargeTypeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ModifyInstanceChargeTypeResponse:
        """
        @summary Changes the billing method of Edge Node Service (ENS) instances. You can switch between the pay-as-you-go and subscription billing methods for instances. You can also change the billing method for disks that you created with pay-as-you-go instances to subscription.
        
        @description Before you call this operation, make sure that you fully understand the billing methods and pricing of ENS.
        The instances must be in the Running or Stopped state, and you have no overdue payments for them.
        
        @param tmp_req: ModifyInstanceChargeTypeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyInstanceChargeTypeResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ens_20171110_models.ModifyInstanceChargeTypeShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.instance_ids):
            request.instance_ids_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.instance_ids, 'InstanceIds', 'json')
        query = {}
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.auto_renew):
            query['AutoRenew'] = request.auto_renew
        if not UtilClient.is_unset(request.billing_cycle):
            query['BillingCycle'] = request.billing_cycle
        if not UtilClient.is_unset(request.include_data_disks):
            query['IncludeDataDisks'] = request.include_data_disks
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.instance_ids_shrink):
            query['InstanceIds'] = request.instance_ids_shrink
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyInstanceChargeType',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ModifyInstanceChargeTypeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_instance_charge_type(
        self,
        request: ens_20171110_models.ModifyInstanceChargeTypeRequest,
    ) -> ens_20171110_models.ModifyInstanceChargeTypeResponse:
        """
        @summary Changes the billing method of Edge Node Service (ENS) instances. You can switch between the pay-as-you-go and subscription billing methods for instances. You can also change the billing method for disks that you created with pay-as-you-go instances to subscription.
        
        @description Before you call this operation, make sure that you fully understand the billing methods and pricing of ENS.
        The instances must be in the Running or Stopped state, and you have no overdue payments for them.
        
        @param request: ModifyInstanceChargeTypeRequest
        @return: ModifyInstanceChargeTypeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_instance_charge_type_with_options(request, runtime)

    async def modify_instance_charge_type_async(
        self,
        request: ens_20171110_models.ModifyInstanceChargeTypeRequest,
    ) -> ens_20171110_models.ModifyInstanceChargeTypeResponse:
        """
        @summary Changes the billing method of Edge Node Service (ENS) instances. You can switch between the pay-as-you-go and subscription billing methods for instances. You can also change the billing method for disks that you created with pay-as-you-go instances to subscription.
        
        @description Before you call this operation, make sure that you fully understand the billing methods and pricing of ENS.
        The instances must be in the Running or Stopped state, and you have no overdue payments for them.
        
        @param request: ModifyInstanceChargeTypeRequest
        @return: ModifyInstanceChargeTypeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_instance_charge_type_with_options_async(request, runtime)

    def modify_load_balancer_attribute_with_options(
        self,
        request: ens_20171110_models.ModifyLoadBalancerAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ModifyLoadBalancerAttributeResponse:
        """
        @summary Modifies the information about an Edge Load Balancer (ELB) instance.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: ModifyLoadBalancerAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyLoadBalancerAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.load_balancer_id):
            query['LoadBalancerId'] = request.load_balancer_id
        if not UtilClient.is_unset(request.load_balancer_name):
            query['LoadBalancerName'] = request.load_balancer_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyLoadBalancerAttribute',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ModifyLoadBalancerAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_load_balancer_attribute_with_options_async(
        self,
        request: ens_20171110_models.ModifyLoadBalancerAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ModifyLoadBalancerAttributeResponse:
        """
        @summary Modifies the information about an Edge Load Balancer (ELB) instance.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: ModifyLoadBalancerAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyLoadBalancerAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.load_balancer_id):
            query['LoadBalancerId'] = request.load_balancer_id
        if not UtilClient.is_unset(request.load_balancer_name):
            query['LoadBalancerName'] = request.load_balancer_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyLoadBalancerAttribute',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ModifyLoadBalancerAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_load_balancer_attribute(
        self,
        request: ens_20171110_models.ModifyLoadBalancerAttributeRequest,
    ) -> ens_20171110_models.ModifyLoadBalancerAttributeResponse:
        """
        @summary Modifies the information about an Edge Load Balancer (ELB) instance.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: ModifyLoadBalancerAttributeRequest
        @return: ModifyLoadBalancerAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_load_balancer_attribute_with_options(request, runtime)

    async def modify_load_balancer_attribute_async(
        self,
        request: ens_20171110_models.ModifyLoadBalancerAttributeRequest,
    ) -> ens_20171110_models.ModifyLoadBalancerAttributeResponse:
        """
        @summary Modifies the information about an Edge Load Balancer (ELB) instance.
        
        @description    You can call this operation up to 100 times per second per account.
        You can call this operation up to 10 times per second per user.
        
        @param request: ModifyLoadBalancerAttributeRequest
        @return: ModifyLoadBalancerAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_load_balancer_attribute_with_options_async(request, runtime)

    def modify_network_attribute_with_options(
        self,
        request: ens_20171110_models.ModifyNetworkAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ModifyNetworkAttributeResponse:
        """
        @summary Modifies the network information.
        
        @description    You can call this operation up to 100 times per second.
        You can call this operation up to 5 times per second per user.
        
        @param request: ModifyNetworkAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyNetworkAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.network_id):
            query['NetworkId'] = request.network_id
        if not UtilClient.is_unset(request.network_name):
            query['NetworkName'] = request.network_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyNetworkAttribute',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ModifyNetworkAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def modify_network_attribute_with_options_async(
        self,
        request: ens_20171110_models.ModifyNetworkAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ModifyNetworkAttributeResponse:
        """
        @summary Modifies the network information.
        
        @description    You can call this operation up to 100 times per second.
        You can call this operation up to 5 times per second per user.
        
        @param request: ModifyNetworkAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyNetworkAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.network_id):
            query['NetworkId'] = request.network_id
        if not UtilClient.is_unset(request.network_name):
            query['NetworkName'] = request.network_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ModifyNetworkAttribute',
            version='2017-11-10',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ens_20171110_models.ModifyNetworkAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def modify_network_attribute(
        self,
        request: ens_20171110_models.ModifyNetworkAttributeRequest,
    ) -> ens_20171110_models.ModifyNetworkAttributeResponse:
        """
        @summary Modifies the network information.
        
        @description    You can call this operation up to 100 times per second.
        You can call this operation up to 5 times per second per user.
        
        @param request: ModifyNetworkAttributeRequest
        @return: ModifyNetworkAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.modify_network_attribute_with_options(request, runtime)

    async def modify_network_attribute_async(
        self,
        request: ens_20171110_models.ModifyNetworkAttributeRequest,
    ) -> ens_20171110_models.ModifyNetworkAttributeResponse:
        """
        @summary Modifies the network information.
        
        @description    You can call this operation up to 100 times per second.
        You can call this operation up to 5 times per second per user.
        
        @param request: ModifyNetworkAttributeRequest
        @return: ModifyNetworkAttributeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.modify_network_attribute_with_options_async(request, runtime)

    def modify_network_interface_attribute_with_options(
        self,
        request: ens_20171110_models.ModifyNetworkInterfaceAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ens_20171110_models.ModifyNetworkInterfaceAttributeResponse:
        """
        @summary Modifies the attributes of an elastic network interface (ENI), such as its name and description.
        
        @param request: ModifyNetworkInterfaceAttributeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ModifyNetworkInterfaceAttributeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.network_interface_id):
            query['NetworkInterfaceId'] = request.network_interface_id
        if not UtilClient.is_unset(request.network_interface_name):
 