# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AcknowledgeArgs', 'Acknowledge']

@pulumi.input_type
class AcknowledgeArgs:
    def __init__(__self__, *,
                 comment: pulumi.Input[str],
                 issues: pulumi.Input[Sequence[pulumi.Input['AcknowledgeIssueArgs']]]):
        """
        The set of arguments for constructing a Acknowledge resource.
        :param pulumi.Input[str] comment: A comment describing the reason for the acknowledgment
        :param pulumi.Input[Sequence[pulumi.Input['AcknowledgeIssueArgs']]] issues: A list of existing security acknowledges.
        """
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "issues", issues)

    @property
    @pulumi.getter
    def comment(self) -> pulumi.Input[str]:
        """
        A comment describing the reason for the acknowledgment
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: pulumi.Input[str]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter
    def issues(self) -> pulumi.Input[Sequence[pulumi.Input['AcknowledgeIssueArgs']]]:
        """
        A list of existing security acknowledges.
        """
        return pulumi.get(self, "issues")

    @issues.setter
    def issues(self, value: pulumi.Input[Sequence[pulumi.Input['AcknowledgeIssueArgs']]]):
        pulumi.set(self, "issues", value)


@pulumi.input_type
class _AcknowledgeState:
    def __init__(__self__, *,
                 comment: Optional[pulumi.Input[str]] = None,
                 issues: Optional[pulumi.Input[Sequence[pulumi.Input['AcknowledgeIssueArgs']]]] = None):
        """
        Input properties used for looking up and filtering Acknowledge resources.
        :param pulumi.Input[str] comment: A comment describing the reason for the acknowledgment
        :param pulumi.Input[Sequence[pulumi.Input['AcknowledgeIssueArgs']]] issues: A list of existing security acknowledges.
        """
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if issues is not None:
            pulumi.set(__self__, "issues", issues)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        A comment describing the reason for the acknowledgment
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter
    def issues(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AcknowledgeIssueArgs']]]]:
        """
        A list of existing security acknowledges.
        """
        return pulumi.get(self, "issues")

    @issues.setter
    def issues(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AcknowledgeIssueArgs']]]]):
        pulumi.set(self, "issues", value)


class Acknowledge(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 issues: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AcknowledgeIssueArgs']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_aquasec as aquasec

        acknowledge = aquasec.Acknowledge("acknowledge",
            comment="comment",
            issues=[
                aquasec.AcknowledgeIssueArgs(
                    docker_id="",
                    image_name="image:latest",
                    issue_name="CVE-2022-1271",
                    issue_type="vulnerability",
                    registry_name="registry",
                    resource_cpe="cpe:/a:gnu:gzip:1.10",
                    resource_name="gzip",
                    resource_path="/usr/bin/gzip",
                    resource_type="executable",
                    resource_version="1.10",
                ),
                aquasec.AcknowledgeIssueArgs(
                    docker_id="docker-id",
                    image_name="image-name",
                    issue_name="ALAS2-2021-1722",
                    issue_type="vulnerability",
                    registry_name="registry-name",
                    resource_cpe="pkg:/amzn:2:nss-softokn:3.44.0-8.amzn2",
                    resource_name="nss-softokn",
                    resource_path="",
                    resource_type="package",
                    resource_version="3.44.0-8.amzn2",
                ),
            ])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] comment: A comment describing the reason for the acknowledgment
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AcknowledgeIssueArgs']]]] issues: A list of existing security acknowledges.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AcknowledgeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_aquasec as aquasec

        acknowledge = aquasec.Acknowledge("acknowledge",
            comment="comment",
            issues=[
                aquasec.AcknowledgeIssueArgs(
                    docker_id="",
                    image_name="image:latest",
                    issue_name="CVE-2022-1271",
                    issue_type="vulnerability",
                    registry_name="registry",
                    resource_cpe="cpe:/a:gnu:gzip:1.10",
                    resource_name="gzip",
                    resource_path="/usr/bin/gzip",
                    resource_type="executable",
                    resource_version="1.10",
                ),
                aquasec.AcknowledgeIssueArgs(
                    docker_id="docker-id",
                    image_name="image-name",
                    issue_name="ALAS2-2021-1722",
                    issue_type="vulnerability",
                    registry_name="registry-name",
                    resource_cpe="pkg:/amzn:2:nss-softokn:3.44.0-8.amzn2",
                    resource_name="nss-softokn",
                    resource_path="",
                    resource_type="package",
                    resource_version="3.44.0-8.amzn2",
                ),
            ])
        ```

        :param str resource_name: The name of the resource.
        :param AcknowledgeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AcknowledgeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 issues: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AcknowledgeIssueArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AcknowledgeArgs.__new__(AcknowledgeArgs)

            if comment is None and not opts.urn:
                raise TypeError("Missing required property 'comment'")
            __props__.__dict__["comment"] = comment
            if issues is None and not opts.urn:
                raise TypeError("Missing required property 'issues'")
            __props__.__dict__["issues"] = issues
        super(Acknowledge, __self__).__init__(
            'aquasec:index/acknowledge:Acknowledge',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            comment: Optional[pulumi.Input[str]] = None,
            issues: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AcknowledgeIssueArgs']]]]] = None) -> 'Acknowledge':
        """
        Get an existing Acknowledge resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] comment: A comment describing the reason for the acknowledgment
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AcknowledgeIssueArgs']]]] issues: A list of existing security acknowledges.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AcknowledgeState.__new__(_AcknowledgeState)

        __props__.__dict__["comment"] = comment
        __props__.__dict__["issues"] = issues
        return Acknowledge(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def comment(self) -> pulumi.Output[str]:
        """
        A comment describing the reason for the acknowledgment
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def issues(self) -> pulumi.Output[Sequence['outputs.AcknowledgeIssue']]:
        """
        A list of existing security acknowledges.
        """
        return pulumi.get(self, "issues")

