# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['SentryProjectArgs', 'SentryProject']

@pulumi.input_type
class SentryProjectArgs:
    def __init__(__self__, *,
                 organization: pulumi.Input[str],
                 team: pulumi.Input[str],
                 digests_max_delay: Optional[pulumi.Input[int]] = None,
                 digests_min_delay: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input[str]] = None,
                 resolve_age: Optional[pulumi.Input[int]] = None,
                 slug: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SentryProject resource.
        :param pulumi.Input[str] organization: The slug of the organization the project should be created for.
        :param pulumi.Input[str] team: The slug of the team the project should be created for.
        :param pulumi.Input[int] digests_max_delay: The maximum amount of time (in seconds) to wait between scheduling digests for delivery.
        :param pulumi.Input[int] digests_min_delay: The minimum amount of time (in seconds) to wait between scheduling digests for delivery after the initial scheduling.
        :param pulumi.Input[str] name: The human readable name for the project.
        :param pulumi.Input[str] platform: The integration platform.
        :param pulumi.Input[int] resolve_age: Hours in which an issue is automatically resolve if not seen after this amount of time.
        :param pulumi.Input[str] slug: The unique URL slug for this project. If this is not provided a slug is automatically generated based on the name.
        """
        pulumi.set(__self__, "organization", organization)
        pulumi.set(__self__, "team", team)
        if digests_max_delay is not None:
            pulumi.set(__self__, "digests_max_delay", digests_max_delay)
        if digests_min_delay is not None:
            pulumi.set(__self__, "digests_min_delay", digests_min_delay)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if resolve_age is not None:
            pulumi.set(__self__, "resolve_age", resolve_age)
        if slug is not None:
            pulumi.set(__self__, "slug", slug)

    @property
    @pulumi.getter
    def organization(self) -> pulumi.Input[str]:
        """
        The slug of the organization the project should be created for.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: pulumi.Input[str]):
        pulumi.set(self, "organization", value)

    @property
    @pulumi.getter
    def team(self) -> pulumi.Input[str]:
        """
        The slug of the team the project should be created for.
        """
        return pulumi.get(self, "team")

    @team.setter
    def team(self, value: pulumi.Input[str]):
        pulumi.set(self, "team", value)

    @property
    @pulumi.getter(name="digestsMaxDelay")
    def digests_max_delay(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum amount of time (in seconds) to wait between scheduling digests for delivery.
        """
        return pulumi.get(self, "digests_max_delay")

    @digests_max_delay.setter
    def digests_max_delay(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "digests_max_delay", value)

    @property
    @pulumi.getter(name="digestsMinDelay")
    def digests_min_delay(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum amount of time (in seconds) to wait between scheduling digests for delivery after the initial scheduling.
        """
        return pulumi.get(self, "digests_min_delay")

    @digests_min_delay.setter
    def digests_min_delay(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "digests_min_delay", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The human readable name for the project.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[str]]:
        """
        The integration platform.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "platform", value)

    @property
    @pulumi.getter(name="resolveAge")
    def resolve_age(self) -> Optional[pulumi.Input[int]]:
        """
        Hours in which an issue is automatically resolve if not seen after this amount of time.
        """
        return pulumi.get(self, "resolve_age")

    @resolve_age.setter
    def resolve_age(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "resolve_age", value)

    @property
    @pulumi.getter
    def slug(self) -> Optional[pulumi.Input[str]]:
        """
        The unique URL slug for this project. If this is not provided a slug is automatically generated based on the name.
        """
        return pulumi.get(self, "slug")

    @slug.setter
    def slug(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "slug", value)


@pulumi.input_type
class _SentryProjectState:
    def __init__(__self__, *,
                 color: Optional[pulumi.Input[str]] = None,
                 digests_max_delay: Optional[pulumi.Input[int]] = None,
                 digests_min_delay: Optional[pulumi.Input[int]] = None,
                 features: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 is_bookmarked: Optional[pulumi.Input[bool]] = None,
                 is_public: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 organization: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 resolve_age: Optional[pulumi.Input[int]] = None,
                 slug: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 team: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SentryProject resources.
        :param pulumi.Input[int] digests_max_delay: The maximum amount of time (in seconds) to wait between scheduling digests for delivery.
        :param pulumi.Input[int] digests_min_delay: The minimum amount of time (in seconds) to wait between scheduling digests for delivery after the initial scheduling.
        :param pulumi.Input[str] name: The human readable name for the project.
        :param pulumi.Input[str] organization: The slug of the organization the project should be created for.
        :param pulumi.Input[str] platform: The integration platform.
        :param pulumi.Input[int] resolve_age: Hours in which an issue is automatically resolve if not seen after this amount of time.
        :param pulumi.Input[str] slug: The unique URL slug for this project. If this is not provided a slug is automatically generated based on the name.
        :param pulumi.Input[str] team: The slug of the team the project should be created for.
        """
        if color is not None:
            pulumi.set(__self__, "color", color)
        if digests_max_delay is not None:
            pulumi.set(__self__, "digests_max_delay", digests_max_delay)
        if digests_min_delay is not None:
            pulumi.set(__self__, "digests_min_delay", digests_min_delay)
        if features is not None:
            pulumi.set(__self__, "features", features)
        if is_bookmarked is not None:
            warnings.warn("""is_bookmarked is no longer used""", DeprecationWarning)
            pulumi.log.warn("""is_bookmarked is deprecated: is_bookmarked is no longer used""")
        if is_bookmarked is not None:
            pulumi.set(__self__, "is_bookmarked", is_bookmarked)
        if is_public is not None:
            pulumi.set(__self__, "is_public", is_public)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if resolve_age is not None:
            pulumi.set(__self__, "resolve_age", resolve_age)
        if slug is not None:
            pulumi.set(__self__, "slug", slug)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if team is not None:
            pulumi.set(__self__, "team", team)

    @property
    @pulumi.getter
    def color(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "color")

    @color.setter
    def color(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "color", value)

    @property
    @pulumi.getter(name="digestsMaxDelay")
    def digests_max_delay(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum amount of time (in seconds) to wait between scheduling digests for delivery.
        """
        return pulumi.get(self, "digests_max_delay")

    @digests_max_delay.setter
    def digests_max_delay(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "digests_max_delay", value)

    @property
    @pulumi.getter(name="digestsMinDelay")
    def digests_min_delay(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum amount of time (in seconds) to wait between scheduling digests for delivery after the initial scheduling.
        """
        return pulumi.get(self, "digests_min_delay")

    @digests_min_delay.setter
    def digests_min_delay(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "digests_min_delay", value)

    @property
    @pulumi.getter
    def features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "features")

    @features.setter
    def features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "features", value)

    @property
    @pulumi.getter(name="isBookmarked")
    def is_bookmarked(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "is_bookmarked")

    @is_bookmarked.setter
    def is_bookmarked(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_bookmarked", value)

    @property
    @pulumi.getter(name="isPublic")
    def is_public(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "is_public")

    @is_public.setter
    def is_public(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_public", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The human readable name for the project.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input[str]]:
        """
        The slug of the organization the project should be created for.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization", value)

    @property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[str]]:
        """
        The integration platform.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "platform", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="resolveAge")
    def resolve_age(self) -> Optional[pulumi.Input[int]]:
        """
        Hours in which an issue is automatically resolve if not seen after this amount of time.
        """
        return pulumi.get(self, "resolve_age")

    @resolve_age.setter
    def resolve_age(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "resolve_age", value)

    @property
    @pulumi.getter
    def slug(self) -> Optional[pulumi.Input[str]]:
        """
        The unique URL slug for this project. If this is not provided a slug is automatically generated based on the name.
        """
        return pulumi.get(self, "slug")

    @slug.setter
    def slug(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "slug", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def team(self) -> Optional[pulumi.Input[str]]:
        """
        The slug of the team the project should be created for.
        """
        return pulumi.get(self, "team")

    @team.setter
    def team(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "team", value)


class SentryProject(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 digests_max_delay: Optional[pulumi.Input[int]] = None,
                 digests_min_delay: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 organization: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input[str]] = None,
                 resolve_age: Optional[pulumi.Input[int]] = None,
                 slug: Optional[pulumi.Input[str]] = None,
                 team: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## # SentryProject Resource

        Sentry Project resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_sentry as sentry

        # Create a project
        default = sentry.SentryProject("default",
            organization="my-organization",
            platform="javascript",
            resolve_age=720,
            slug="web-app",
            team="my-team")
        ```

        ## Import

        This resource can be imported using an ID made up of the organization slug and project slugbash

        ```sh
         $ pulumi import sentry:index/sentryProject:SentryProject default org-slug/project-slug
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] digests_max_delay: The maximum amount of time (in seconds) to wait between scheduling digests for delivery.
        :param pulumi.Input[int] digests_min_delay: The minimum amount of time (in seconds) to wait between scheduling digests for delivery after the initial scheduling.
        :param pulumi.Input[str] name: The human readable name for the project.
        :param pulumi.Input[str] organization: The slug of the organization the project should be created for.
        :param pulumi.Input[str] platform: The integration platform.
        :param pulumi.Input[int] resolve_age: Hours in which an issue is automatically resolve if not seen after this amount of time.
        :param pulumi.Input[str] slug: The unique URL slug for this project. If this is not provided a slug is automatically generated based on the name.
        :param pulumi.Input[str] team: The slug of the team the project should be created for.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SentryProjectArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # SentryProject Resource

        Sentry Project resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_sentry as sentry

        # Create a project
        default = sentry.SentryProject("default",
            organization="my-organization",
            platform="javascript",
            resolve_age=720,
            slug="web-app",
            team="my-team")
        ```

        ## Import

        This resource can be imported using an ID made up of the organization slug and project slugbash

        ```sh
         $ pulumi import sentry:index/sentryProject:SentryProject default org-slug/project-slug
        ```

        :param str resource_name: The name of the resource.
        :param SentryProjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SentryProjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 digests_max_delay: Optional[pulumi.Input[int]] = None,
                 digests_min_delay: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 organization: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input[str]] = None,
                 resolve_age: Optional[pulumi.Input[int]] = None,
                 slug: Optional[pulumi.Input[str]] = None,
                 team: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        else:
            opts = copy.copy(opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SentryProjectArgs.__new__(SentryProjectArgs)

            __props__.__dict__["digests_max_delay"] = digests_max_delay
            __props__.__dict__["digests_min_delay"] = digests_min_delay
            __props__.__dict__["name"] = name
            if organization is None and not opts.urn:
                raise TypeError("Missing required property 'organization'")
            __props__.__dict__["organization"] = organization
            __props__.__dict__["platform"] = platform
            __props__.__dict__["resolve_age"] = resolve_age
            __props__.__dict__["slug"] = slug
            if team is None and not opts.urn:
                raise TypeError("Missing required property 'team'")
            __props__.__dict__["team"] = team
            __props__.__dict__["color"] = None
            __props__.__dict__["features"] = None
            __props__.__dict__["is_bookmarked"] = None
            __props__.__dict__["is_public"] = None
            __props__.__dict__["project_id"] = None
            __props__.__dict__["status"] = None
        super(SentryProject, __self__).__init__(
            'sentry:index/sentryProject:SentryProject',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            color: Optional[pulumi.Input[str]] = None,
            digests_max_delay: Optional[pulumi.Input[int]] = None,
            digests_min_delay: Optional[pulumi.Input[int]] = None,
            features: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            is_bookmarked: Optional[pulumi.Input[bool]] = None,
            is_public: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            organization: Optional[pulumi.Input[str]] = None,
            platform: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            resolve_age: Optional[pulumi.Input[int]] = None,
            slug: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            team: Optional[pulumi.Input[str]] = None) -> 'SentryProject':
        """
        Get an existing SentryProject resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] digests_max_delay: The maximum amount of time (in seconds) to wait between scheduling digests for delivery.
        :param pulumi.Input[int] digests_min_delay: The minimum amount of time (in seconds) to wait between scheduling digests for delivery after the initial scheduling.
        :param pulumi.Input[str] name: The human readable name for the project.
        :param pulumi.Input[str] organization: The slug of the organization the project should be created for.
        :param pulumi.Input[str] platform: The integration platform.
        :param pulumi.Input[int] resolve_age: Hours in which an issue is automatically resolve if not seen after this amount of time.
        :param pulumi.Input[str] slug: The unique URL slug for this project. If this is not provided a slug is automatically generated based on the name.
        :param pulumi.Input[str] team: The slug of the team the project should be created for.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SentryProjectState.__new__(_SentryProjectState)

        __props__.__dict__["color"] = color
        __props__.__dict__["digests_max_delay"] = digests_max_delay
        __props__.__dict__["digests_min_delay"] = digests_min_delay
        __props__.__dict__["features"] = features
        __props__.__dict__["is_bookmarked"] = is_bookmarked
        __props__.__dict__["is_public"] = is_public
        __props__.__dict__["name"] = name
        __props__.__dict__["organization"] = organization
        __props__.__dict__["platform"] = platform
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["resolve_age"] = resolve_age
        __props__.__dict__["slug"] = slug
        __props__.__dict__["status"] = status
        __props__.__dict__["team"] = team
        return SentryProject(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def color(self) -> pulumi.Output[str]:
        return pulumi.get(self, "color")

    @property
    @pulumi.getter(name="digestsMaxDelay")
    def digests_max_delay(self) -> pulumi.Output[int]:
        """
        The maximum amount of time (in seconds) to wait between scheduling digests for delivery.
        """
        return pulumi.get(self, "digests_max_delay")

    @property
    @pulumi.getter(name="digestsMinDelay")
    def digests_min_delay(self) -> pulumi.Output[int]:
        """
        The minimum amount of time (in seconds) to wait between scheduling digests for delivery after the initial scheduling.
        """
        return pulumi.get(self, "digests_min_delay")

    @property
    @pulumi.getter
    def features(self) -> pulumi.Output[Sequence[str]]:
        return pulumi.get(self, "features")

    @property
    @pulumi.getter(name="isBookmarked")
    def is_bookmarked(self) -> pulumi.Output[bool]:
        return pulumi.get(self, "is_bookmarked")

    @property
    @pulumi.getter(name="isPublic")
    def is_public(self) -> pulumi.Output[bool]:
        return pulumi.get(self, "is_public")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The human readable name for the project.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def organization(self) -> pulumi.Output[str]:
        """
        The slug of the organization the project should be created for.
        """
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter
    def platform(self) -> pulumi.Output[str]:
        """
        The integration platform.
        """
        return pulumi.get(self, "platform")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="resolveAge")
    def resolve_age(self) -> pulumi.Output[int]:
        """
        Hours in which an issue is automatically resolve if not seen after this amount of time.
        """
        return pulumi.get(self, "resolve_age")

    @property
    @pulumi.getter
    def slug(self) -> pulumi.Output[str]:
        """
        The unique URL slug for this project. If this is not provided a slug is automatically generated based on the name.
        """
        return pulumi.get(self, "slug")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def team(self) -> pulumi.Output[str]:
        """
        The slug of the team the project should be created for.
        """
        return pulumi.get(self, "team")

