'''
# CDK IoT Core Certificates

[![Source](https://img.shields.io/badge/Source-GitHub-blue?logo=github)](https://github.com/devops-at-home/cdk-iot-core-certificates)
[![Release](https://github.com/devops-at-home/cdk-iot-core-certificates/workflows/Release/badge.svg)](https://github.com/devops-at-home/cdk-iot-core-certificates/actions/workflows/release.yml)
[![GitHub](https://img.shields.io/github/license/devops-at-home/cdk-iot-core-certificates)](https://github.com/devops-at-home/cdk-iot-core-certificates/blob/main/LICENSE)
[![Docs](https://img.shields.io/badge/awscdk.io-cdk--iot--core--certificates-orange)](https://awscdk.io/packages/cdk-iot-core-certificates@0.0.4/#/)

[![npm package](https://img.shields.io/npm/v/cdk-iot-core-certificates?color=brightgreen)](https://www.npmjs.com/package/cdk-iot-core-certificates)

![Downloads](https://img.shields.io/badge/-DOWNLOADS:-brightgreen?color=gray)
[![npm downloads](https://img.shields.io/npm/dt/cdk-iot-core-certificates?label=npm&color=blueviolet)](https://www.npmjs.com/package/cdk-iot-core-certificates)

[AWS CDK](https://aws.amazon.com/cdk/) L3 construct for managing certificates for [AWS IoT Core](https://aws.amazon.com/iot-core/)

CloudFormation doesn't directly support creation of certificates for AWS IoT Core. This construct provides an easy interface for creating certificates through a [custom CloudFormation resource](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-custom-resources.html). The private key is stored in [AWS Parameter Store](https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-parameter-store.html).

## Installation

This package has peer dependencies, which need to be installed along in the expected version.

For TypeScript/NodeJS, add these to your `dependencies` in `package.json`:

* cdk-iot-core-certificates

## Usage

```python
import { ThingWithCert } from 'cdk-iot-core-certificates';

// Creates new AWS IoT Thing called thingName
// Saves certs to /devices/thingName/certPem and /devices/thingName/privKey
// thingName and paramPrefix cannot start with '/'
const { thingArn, certId, certPem, privKey } = new ThingWithCert(this, 'ThingWithCert', {
    thingName: 'integrationTest',
    saveToParamStore: true,
    paramPrefix: 'devices',
});

new CfnOutput(this, 'Output-ThingArn', {
    value: thingArn,
});

new CfnOutput(this, 'Output-CertId', {
    value: certId,
});

new CfnOutput(this, 'Output-CertPem', {
    value: certPem,
});

new CfnOutput(this, 'Output-PrivKey', {
    value: privKey,
});
```
'''
import abc
import builtins
import datetime
import enum
import typing

import jsii
import publication
import typing_extensions

from typeguard import check_type

from ._jsii import *

import aws_cdk as _aws_cdk_ceddda9d
import constructs as _constructs_77d1e7e8


class ThingWithCert(
    _constructs_77d1e7e8.Construct,
    metaclass=jsii.JSIIMeta,
    jsii_type="cdk-iot-core-certificates.ThingWithCert",
):
    def __init__(
        self,
        scope: _constructs_77d1e7e8.Construct,
        id: builtins.str,
        *,
        thing_name: builtins.str,
        param_prefix: typing.Optional[builtins.str] = None,
        save_to_param_store: typing.Optional[builtins.bool] = None,
        account: typing.Optional[builtins.str] = None,
        environment_from_arn: typing.Optional[builtins.str] = None,
        physical_name: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
    ) -> None:
        '''
        :param scope: -
        :param id: -
        :param thing_name: 
        :param param_prefix: 
        :param save_to_param_store: 
        :param account: The AWS account ID this resource belongs to. Default: - the resource is in the same account as the stack it belongs to
        :param environment_from_arn: ARN to deduce region and account from. The ARN is parsed and the account and region are taken from the ARN. This should be used for imported resources. Cannot be supplied together with either ``account`` or ``region``. Default: - take environment from ``account``, ``region`` parameters, or use Stack environment.
        :param physical_name: The value passed in by users to the physical name prop of the resource. - ``undefined`` implies that a physical name will be allocated by CloudFormation during deployment. - a concrete value implies a specific physical name - ``PhysicalName.GENERATE_IF_NEEDED`` is a marker that indicates that a physical will only be generated by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation. Default: - The physical name will be allocated by CloudFormation at deployment time
        :param region: The AWS region this resource belongs to. Default: - the resource is in the same region as the stack it belongs to
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__78ed925682bc79ebb3ee3124822f4ea6036c54d8d311c98a5984a6e1bb2748ae)
            check_type(argname="argument scope", value=scope, expected_type=type_hints["scope"])
            check_type(argname="argument id", value=id, expected_type=type_hints["id"])
        props = ThingWithCertProps(
            thing_name=thing_name,
            param_prefix=param_prefix,
            save_to_param_store=save_to_param_store,
            account=account,
            environment_from_arn=environment_from_arn,
            physical_name=physical_name,
            region=region,
        )

        jsii.create(self.__class__, self, [scope, id, props])

    @builtins.property
    @jsii.member(jsii_name="certId")
    def cert_id(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "certId"))

    @builtins.property
    @jsii.member(jsii_name="certPem")
    def cert_pem(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "certPem"))

    @builtins.property
    @jsii.member(jsii_name="privKey")
    def priv_key(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "privKey"))

    @builtins.property
    @jsii.member(jsii_name="thingArn")
    def thing_arn(self) -> builtins.str:
        return typing.cast(builtins.str, jsii.get(self, "thingArn"))


@jsii.data_type(
    jsii_type="cdk-iot-core-certificates.ThingWithCertProps",
    jsii_struct_bases=[_aws_cdk_ceddda9d.ResourceProps],
    name_mapping={
        "account": "account",
        "environment_from_arn": "environmentFromArn",
        "physical_name": "physicalName",
        "region": "region",
        "thing_name": "thingName",
        "param_prefix": "paramPrefix",
        "save_to_param_store": "saveToParamStore",
    },
)
class ThingWithCertProps(_aws_cdk_ceddda9d.ResourceProps):
    def __init__(
        self,
        *,
        account: typing.Optional[builtins.str] = None,
        environment_from_arn: typing.Optional[builtins.str] = None,
        physical_name: typing.Optional[builtins.str] = None,
        region: typing.Optional[builtins.str] = None,
        thing_name: builtins.str,
        param_prefix: typing.Optional[builtins.str] = None,
        save_to_param_store: typing.Optional[builtins.bool] = None,
    ) -> None:
        '''
        :param account: The AWS account ID this resource belongs to. Default: - the resource is in the same account as the stack it belongs to
        :param environment_from_arn: ARN to deduce region and account from. The ARN is parsed and the account and region are taken from the ARN. This should be used for imported resources. Cannot be supplied together with either ``account`` or ``region``. Default: - take environment from ``account``, ``region`` parameters, or use Stack environment.
        :param physical_name: The value passed in by users to the physical name prop of the resource. - ``undefined`` implies that a physical name will be allocated by CloudFormation during deployment. - a concrete value implies a specific physical name - ``PhysicalName.GENERATE_IF_NEEDED`` is a marker that indicates that a physical will only be generated by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation. Default: - The physical name will be allocated by CloudFormation at deployment time
        :param region: The AWS region this resource belongs to. Default: - the resource is in the same region as the stack it belongs to
        :param thing_name: 
        :param param_prefix: 
        :param save_to_param_store: 
        '''
        if __debug__:
            type_hints = typing.get_type_hints(_typecheckingstub__9374762b960d745923c8237c65ab9e0f23069886449e9b629dbd5abfbece4160)
            check_type(argname="argument account", value=account, expected_type=type_hints["account"])
            check_type(argname="argument environment_from_arn", value=environment_from_arn, expected_type=type_hints["environment_from_arn"])
            check_type(argname="argument physical_name", value=physical_name, expected_type=type_hints["physical_name"])
            check_type(argname="argument region", value=region, expected_type=type_hints["region"])
            check_type(argname="argument thing_name", value=thing_name, expected_type=type_hints["thing_name"])
            check_type(argname="argument param_prefix", value=param_prefix, expected_type=type_hints["param_prefix"])
            check_type(argname="argument save_to_param_store", value=save_to_param_store, expected_type=type_hints["save_to_param_store"])
        self._values: typing.Dict[builtins.str, typing.Any] = {
            "thing_name": thing_name,
        }
        if account is not None:
            self._values["account"] = account
        if environment_from_arn is not None:
            self._values["environment_from_arn"] = environment_from_arn
        if physical_name is not None:
            self._values["physical_name"] = physical_name
        if region is not None:
            self._values["region"] = region
        if param_prefix is not None:
            self._values["param_prefix"] = param_prefix
        if save_to_param_store is not None:
            self._values["save_to_param_store"] = save_to_param_store

    @builtins.property
    def account(self) -> typing.Optional[builtins.str]:
        '''The AWS account ID this resource belongs to.

        :default: - the resource is in the same account as the stack it belongs to
        '''
        result = self._values.get("account")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def environment_from_arn(self) -> typing.Optional[builtins.str]:
        '''ARN to deduce region and account from.

        The ARN is parsed and the account and region are taken from the ARN.
        This should be used for imported resources.

        Cannot be supplied together with either ``account`` or ``region``.

        :default: - take environment from ``account``, ``region`` parameters, or use Stack environment.
        '''
        result = self._values.get("environment_from_arn")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def physical_name(self) -> typing.Optional[builtins.str]:
        '''The value passed in by users to the physical name prop of the resource.

        - ``undefined`` implies that a physical name will be allocated by
          CloudFormation during deployment.
        - a concrete value implies a specific physical name
        - ``PhysicalName.GENERATE_IF_NEEDED`` is a marker that indicates that a physical will only be generated
          by the CDK if it is needed for cross-environment references. Otherwise, it will be allocated by CloudFormation.

        :default: - The physical name will be allocated by CloudFormation at deployment time
        '''
        result = self._values.get("physical_name")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def region(self) -> typing.Optional[builtins.str]:
        '''The AWS region this resource belongs to.

        :default: - the resource is in the same region as the stack it belongs to
        '''
        result = self._values.get("region")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def thing_name(self) -> builtins.str:
        result = self._values.get("thing_name")
        assert result is not None, "Required property 'thing_name' is missing"
        return typing.cast(builtins.str, result)

    @builtins.property
    def param_prefix(self) -> typing.Optional[builtins.str]:
        result = self._values.get("param_prefix")
        return typing.cast(typing.Optional[builtins.str], result)

    @builtins.property
    def save_to_param_store(self) -> typing.Optional[builtins.bool]:
        result = self._values.get("save_to_param_store")
        return typing.cast(typing.Optional[builtins.bool], result)

    def __eq__(self, rhs: typing.Any) -> builtins.bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs: typing.Any) -> builtins.bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ThingWithCertProps(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


__all__ = [
    "ThingWithCert",
    "ThingWithCertProps",
]

publication.publish()

def _typecheckingstub__78ed925682bc79ebb3ee3124822f4ea6036c54d8d311c98a5984a6e1bb2748ae(
    scope: _constructs_77d1e7e8.Construct,
    id: builtins.str,
    *,
    thing_name: builtins.str,
    param_prefix: typing.Optional[builtins.str] = None,
    save_to_param_store: typing.Optional[builtins.bool] = None,
    account: typing.Optional[builtins.str] = None,
    environment_from_arn: typing.Optional[builtins.str] = None,
    physical_name: typing.Optional[builtins.str] = None,
    region: typing.Optional[builtins.str] = None,
) -> None:
    """Type checking stubs"""
    pass

def _typecheckingstub__9374762b960d745923c8237c65ab9e0f23069886449e9b629dbd5abfbece4160(
    *,
    account: typing.Optional[builtins.str] = None,
    environment_from_arn: typing.Optional[builtins.str] = None,
    physical_name: typing.Optional[builtins.str] = None,
    region: typing.Optional[builtins.str] = None,
    thing_name: builtins.str,
    param_prefix: typing.Optional[builtins.str] = None,
    save_to_param_store: typing.Optional[builtins.bool] = None,
) -> None:
    """Type checking stubs"""
    pass
