"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const aws_sdk_1 = require("aws-sdk");
const iot_1 = require("./adapters/iot");
const thing_1 = require("./adapters/thing");
const thingHandler = thing_1.thingAdaptor(iot_1.iotAdaptor(new aws_sdk_1.Iot()));
exports.handler = async (event) => {
    const { RequestType, LogicalResourceId, RequestId, StackId } = event;
    try {
        const thingName = event.ResourceProperties.ThingName;
        if (RequestType === 'Create') {
            const { thingArn, certId, certPem, privKey } = await thingHandler.create(thingName);
            return {
                Status: 'SUCCESS',
                PhysicalResourceId: thingArn,
                LogicalResourceId,
                RequestId,
                StackId,
                Data: {
                    thingArn,
                    certId,
                    certPem,
                    privKey,
                },
            };
        }
        else if (event.RequestType === 'Delete') {
            await thingHandler.delete(thingName);
            return {
                Status: 'SUCCESS',
                PhysicalResourceId: event.PhysicalResourceId,
                LogicalResourceId,
                RequestId,
                StackId,
            };
        }
        else if (event.RequestType === 'Update') {
            return {
                Status: 'SUCCESS',
                PhysicalResourceId: event.PhysicalResourceId,
                LogicalResourceId,
                RequestId,
                StackId,
            };
        }
        else {
            throw new Error('Received invalid request type');
        }
    }
    catch (err) {
        const Reason = err.message;
        return {
            Status: 'FAILED',
            Reason,
            RequestId,
            StackId,
            LogicalResourceId,
            // @ts-ignore
            PhysicalResourceId: event.PhysicalResourceId || LogicalResourceId,
        };
    }
};
//# sourceMappingURL=data:application/json;base64,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