"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.thingAdaptor = void 0;
exports.thingAdaptor = (iotAdaptor) => {
    return {
        create: async (thingName) => {
            const { thingArn } = await iotAdaptor.createThing({
                thingName: thingName,
            });
            console.info(`Thing created with ARN: ${thingArn}`);
            const { certificateId, certificateArn, certificatePem, keyPair } = await iotAdaptor.createKeysAndCertificates();
            const { PrivateKey } = keyPair;
            const { policyArn } = await iotAdaptor.createPolicy(thingName);
            console.info(`Policy created with ARN: ${policyArn}`);
            await iotAdaptor.attachPrincipalPolicy({
                policyName: thingName,
                principal: certificateArn,
            });
            console.info('Policy attached to certificate');
            await iotAdaptor.attachThingPrincipal({
                principal: certificateArn,
                thingName: thingName,
            });
            console.info('Certificate attached to thing');
            return {
                certId: certificateId,
                certPem: certificatePem,
                privKey: PrivateKey,
                thingArn: thingArn,
            };
        },
        delete: async (thingName) => {
            const { principals } = await iotAdaptor.listThingPrincipals(thingName);
            for await (const certificateArn of principals) {
                await iotAdaptor.detachPrincipalPolicy({
                    policyName: thingName,
                    principal: certificateArn,
                });
                console.info(`Policy detached from certificate for ${thingName}`);
                await iotAdaptor.detachThingPrincipal({
                    principal: certificateArn,
                    thingName: thingName,
                });
                console.info(`Certificate detached from thing for ${certificateArn}`);
                await iotAdaptor.updateCertificateToInactive(certificateArn);
                console.info(`Certificate marked as inactive for ${certificateArn}`);
                await iotAdaptor.deleteCertificate(certificateArn);
                console.info(`Certificate deleted from thing for ${certificateArn}`);
                await iotAdaptor.deleteThing(thingName);
                console.info(`Thing deleted with name: ${thingName}`);
            }
            await iotAdaptor.deletePolicy(thingName);
            console.info(`Policy deleted: ${thingName}`);
        },
    };
};
//# sourceMappingURL=data:application/json;base64,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