"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.iotAdaptor = void 0;
const iot_1 = require("../util/iot");
exports.iotAdaptor = (iot) => {
    return {
        createThing: async (thingRequest) => {
            return iot.createThing(thingRequest).promise();
        },
        createKeysAndCertificates: async () => {
            return iot
                .createKeysAndCertificate({
                setAsActive: true,
            })
                .promise();
        },
        createPolicy: async (thingName) => {
            return iot
                .createPolicy({
                policyName: thingName,
                policyDocument: policyDoc,
            })
                .promise();
        },
        attachPrincipalPolicy: async (props) => {
            await iot.attachPrincipalPolicy(props).promise();
        },
        attachThingPrincipal: async (props) => {
            return iot.attachThingPrincipal(props).promise();
        },
        listThingPrincipals: async (thingName) => {
            return iot
                .listThingPrincipals({
                thingName: thingName,
            })
                .promise();
        },
        detachPrincipalPolicy: async (props) => {
            await iot.detachPrincipalPolicy(props).promise();
        },
        detachThingPrincipal: async (props) => {
            return iot.detachThingPrincipal(props).promise();
        },
        updateCertificateToInactive: async (certArn) => {
            await iot
                .updateCertificate({
                certificateId: iot_1.getCertIdFromARN(certArn),
                newStatus: 'INACTIVE',
            })
                .promise();
        },
        deleteCertificate: async (certArn) => {
            await iot
                .deleteCertificate({
                certificateId: iot_1.getCertIdFromARN(certArn),
            })
                .promise();
        },
        deletePolicy: async (policyName) => {
            await iot
                .deletePolicy({
                policyName: policyName,
            })
                .promise();
        },
        deleteThing: async (thingName) => {
            await iot
                .deleteThing({
                thingName: thingName,
            })
                .promise();
        },
    };
};
const policyDoc = `{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Action": [
        "iot:Publish",
        "iot:Subscribe",
        "iot:Connect",
        "iot:Receive"
      ],
      "Resource": [
        "*"
      ]
    },
    {
      "Effect": "Allow",
      "Action": [
        "iot:GetThingShadow",
        "iot:UpdateThingShadow",
        "iot:DeleteThingShadow"
      ],
      "Resource": [
        "*"
      ]
    }
  ]
}`;
//# sourceMappingURL=data:application/json;base64,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