"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.getParamStorePath = exports.ThingWithCert = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_cloudformation_1 = require("aws-cdk-lib/aws-cloudformation");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_lambda_nodejs_1 = require("aws-cdk-lib/aws-lambda-nodejs");
const aws_logs_1 = require("aws-cdk-lib/aws-logs");
const aws_ssm_1 = require("aws-cdk-lib/aws-ssm");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
const path_1 = require("path");
class ThingWithCert extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const { thingName, saveToParamStore, paramPrefix } = props;
        const role = new aws_iam_1.Role(this, 'LambdaExecutionRole', {
            assumedBy: new aws_iam_1.CompositePrincipal(new aws_iam_1.ServicePrincipal('lambda.amazonaws.com')),
        });
        role.addToPolicy(new aws_iam_1.PolicyStatement({
            resources: ['arn:aws:logs:*:*:*'],
            actions: ['logs:CreateLogGroup', 'logs:CreateLogStream', 'logs:PutLogEvents'],
        }));
        role.addToPolicy(new aws_iam_1.PolicyStatement({
            resources: ['*'],
            actions: ['iot:*'],
        }));
        const onEventHandler = new aws_lambda_nodejs_1.NodejsFunction(this, 'lambdaFunction', {
            entry: path_1.join(__dirname, 'lambda', 'index.js'),
            handler: 'handler',
            timeout: aws_cdk_lib_1.Duration.seconds(10),
            role,
            logRetention: aws_logs_1.RetentionDays.ONE_DAY,
        });
        const { serviceToken } = new custom_resources_1.Provider(this, 'lambdaProvider', {
            onEventHandler,
        });
        const lambdaCustomResource = new aws_cloudformation_1.CfnCustomResource(this, 'lambdaCustomResource', {
            serviceToken,
        });
        lambdaCustomResource.addPropertyOverride('ThingName', thingName);
        const paramStorePath = exports.getParamStorePath(thingName, paramPrefix);
        if (saveToParamStore) {
            new aws_ssm_1.CfnParameter(this, 'paramStoreCertPem', {
                type: 'String',
                value: lambdaCustomResource.getAtt('certPem').toString(),
                name: `${paramStorePath}/certPem`,
            });
            new aws_ssm_1.CfnParameter(this, 'paramStorePrivKey', {
                type: 'String',
                value: lambdaCustomResource.getAtt('privKey').toString(),
                name: `${paramStorePath}/privKey`,
            });
        }
        this.thingArn = lambdaCustomResource.getAtt('thingArn').toString();
        this.certId = lambdaCustomResource.getAtt('certId').toString();
        this.certPem = lambdaCustomResource.getAtt('certPem').toString();
        this.privKey = lambdaCustomResource.getAtt('privKey').toString();
    }
}
exports.ThingWithCert = ThingWithCert;
_a = JSII_RTTI_SYMBOL_1;
ThingWithCert[_a] = { fqn: "cdk-iot-core-certificates.ThingWithCert", version: "1.0.43" };
exports.getParamStorePath = (thingName, paramPrefix) => {
    if (thingName.charAt(0) === '/') {
        throw new Error("thingName cannot start with '/'");
    }
    if (paramPrefix && paramPrefix.charAt(0) === '/') {
        throw new Error("paramPrefix cannot start with '/'");
    }
    return paramPrefix ? `/${paramPrefix}/${thingName}` : `/${thingName}`;
};
//# sourceMappingURL=data:application/json;base64,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